/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAck is the corresponding interface of BACnetServiceAck
type BACnetServiceAck interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetServiceChoice returns ServiceChoice (discriminator field)
	GetServiceChoice() BACnetConfirmedServiceChoice
	// GetServiceAckPayloadLength returns ServiceAckPayloadLength (virtual field)
	GetServiceAckPayloadLength() uint32
}

// BACnetServiceAckExactly can be used when we want exactly this type and not a type which fulfills BACnetServiceAck.
// This is useful for switch cases.
type BACnetServiceAckExactly interface {
	BACnetServiceAck
	isBACnetServiceAck() bool
}

// _BACnetServiceAck is the data-structure of this message
type _BACnetServiceAck struct {
	_BACnetServiceAckChildRequirements

	// Arguments.
	ServiceAckLength uint32
}

type _BACnetServiceAckChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetServiceChoice() BACnetConfirmedServiceChoice
}

type BACnetServiceAckParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetServiceAck, serializeChildFunction func() error) error
	GetTypeName() string
}

type BACnetServiceAckChild interface {
	utils.Serializable
	InitializeParent(parent BACnetServiceAck)
	GetParent() *BACnetServiceAck

	GetTypeName() string
	BACnetServiceAck
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetServiceAck) GetServiceAckPayloadLength() uint32 {
	ctx := context.Background()
	_ = ctx
	return uint32(utils.InlineIf((bool((m.ServiceAckLength) > (0))), func() any { return uint32((uint32(m.ServiceAckLength) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetServiceAck factory function for _BACnetServiceAck
func NewBACnetServiceAck(serviceAckLength uint32) *_BACnetServiceAck {
	return &_BACnetServiceAck{ServiceAckLength: serviceAckLength}
}

// Deprecated: use the interface for direct cast
func CastBACnetServiceAck(structType any) BACnetServiceAck {
	if casted, ok := structType.(BACnetServiceAck); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAck); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAck) GetTypeName() string {
	return "BACnetServiceAck"
}

func (m *_BACnetServiceAck) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (serviceChoice)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetServiceAck) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetServiceAckParse(ctx context.Context, theBytes []byte, serviceAckLength uint32) (BACnetServiceAck, error) {
	return BACnetServiceAckParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), serviceAckLength)
}

func BACnetServiceAckParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, serviceAckLength uint32) (BACnetServiceAck, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetServiceAck"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAck")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Discriminator Field (serviceChoice) (Used as input to a switch field)
	if pullErr := readBuffer.PullContext("serviceChoice"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for serviceChoice")
	}
	serviceChoice_temp, _serviceChoiceErr := BACnetConfirmedServiceChoiceParseWithBuffer(ctx, readBuffer)
	var serviceChoice BACnetConfirmedServiceChoice = serviceChoice_temp
	if closeErr := readBuffer.CloseContext("serviceChoice"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for serviceChoice")
	}
	if _serviceChoiceErr != nil {
		return nil, errors.Wrap(_serviceChoiceErr, "Error parsing 'serviceChoice' field of BACnetServiceAck")
	}

	// Virtual field
	_serviceAckPayloadLength := utils.InlineIf((bool((serviceAckLength) > (0))), func() any { return uint32((uint32(serviceAckLength) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32)
	serviceAckPayloadLength := uint32(_serviceAckPayloadLength)
	_ = serviceAckPayloadLength

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type BACnetServiceAckChildSerializeRequirement interface {
		BACnetServiceAck
		InitializeParent(BACnetServiceAck)
		GetParent() BACnetServiceAck
	}
	var _childTemp any
	var _child BACnetServiceAckChildSerializeRequirement
	var typeSwitchError error
	switch {
	case serviceChoice == BACnetConfirmedServiceChoice_GET_ALARM_SUMMARY: // BACnetServiceAckGetAlarmSummary
		_childTemp, typeSwitchError = BACnetServiceAckGetAlarmSummaryParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_GET_ENROLLMENT_SUMMARY: // BACnetServiceAckGetEnrollmentSummary
		_childTemp, typeSwitchError = BACnetServiceAckGetEnrollmentSummaryParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_GET_EVENT_INFORMATION: // BACnetServiceAckGetEventInformation
		_childTemp, typeSwitchError = BACnetServiceAckGetEventInformationParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_READ_FILE: // BACnetServiceAckAtomicReadFile
		_childTemp, typeSwitchError = BACnetServiceAckAtomicReadFileParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_WRITE_FILE: // BACnetServiceAckAtomicWriteFile
		_childTemp, typeSwitchError = BACnetServiceAckAtomicWriteFileParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_CREATE_OBJECT: // BACnetServiceAckCreateObject
		_childTemp, typeSwitchError = BACnetServiceAckCreateObjectParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY: // BACnetServiceAckReadProperty
		_childTemp, typeSwitchError = BACnetServiceAckReadPropertyParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_MULTIPLE: // BACnetServiceAckReadPropertyMultiple
		_childTemp, typeSwitchError = BACnetServiceAckReadPropertyMultipleParseWithBuffer(ctx, readBuffer, serviceAckPayloadLength, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_READ_RANGE: // BACnetServiceAckReadRange
		_childTemp, typeSwitchError = BACnetServiceAckReadRangeParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_PRIVATE_TRANSFER: // BACnetServiceAckConfirmedPrivateTransfer
		_childTemp, typeSwitchError = BACnetServiceAckConfirmedPrivateTransferParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_VT_OPEN: // BACnetServiceAckVTOpen
		_childTemp, typeSwitchError = BACnetServiceAckVTOpenParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_VT_DATA: // BACnetServiceAckVTData
		_childTemp, typeSwitchError = BACnetServiceAckVTDataParseWithBuffer(ctx, readBuffer, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_AUTHENTICATE: // BACnetServiceAckAuthenticate
		_childTemp, typeSwitchError = BACnetServiceAckAuthenticateParseWithBuffer(ctx, readBuffer, serviceAckPayloadLength, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_REQUEST_KEY: // BACnetServiceAckRequestKey
		_childTemp, typeSwitchError = BACnetServiceAckRequestKeyParseWithBuffer(ctx, readBuffer, serviceAckPayloadLength, serviceAckLength)
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_CONDITIONAL: // BACnetServiceAckReadPropertyConditional
		_childTemp, typeSwitchError = BACnetServiceAckReadPropertyConditionalParseWithBuffer(ctx, readBuffer, serviceAckPayloadLength, serviceAckLength)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [serviceChoice=%v]", serviceChoice)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of BACnetServiceAck")
	}
	_child = _childTemp.(BACnetServiceAckChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("BACnetServiceAck"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAck")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_BACnetServiceAck) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetServiceAck, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetServiceAck"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetServiceAck")
	}

	// Discriminator Field (serviceChoice) (Used as input to a switch field)
	serviceChoice := BACnetConfirmedServiceChoice(child.GetServiceChoice())
	if pushErr := writeBuffer.PushContext("serviceChoice"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for serviceChoice")
	}
	_serviceChoiceErr := writeBuffer.WriteSerializable(ctx, serviceChoice)
	if popErr := writeBuffer.PopContext("serviceChoice"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for serviceChoice")
	}

	if _serviceChoiceErr != nil {
		return errors.Wrap(_serviceChoiceErr, "Error serializing 'serviceChoice' field")
	}
	// Virtual field
	serviceAckPayloadLength := m.GetServiceAckPayloadLength()
	_ = serviceAckPayloadLength
	if _serviceAckPayloadLengthErr := writeBuffer.WriteVirtual(ctx, "serviceAckPayloadLength", m.GetServiceAckPayloadLength()); _serviceAckPayloadLengthErr != nil {
		return errors.Wrap(_serviceAckPayloadLengthErr, "Error serializing 'serviceAckPayloadLength' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetServiceAck"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetServiceAck")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetServiceAck) GetServiceAckLength() uint32 {
	return m.ServiceAckLength
}

//
////

func (m *_BACnetServiceAck) isBACnetServiceAck() bool {
	return true
}

func (m *_BACnetServiceAck) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
