/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyIdentifier is an enum
type BACnetPropertyIdentifier uint32

type IBACnetPropertyIdentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	BACnetPropertyIdentifier_ABSENTEE_LIMIT                      BACnetPropertyIdentifier = 244
	BACnetPropertyIdentifier_ACCEPTED_MODES                      BACnetPropertyIdentifier = 175
	BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS                 BACnetPropertyIdentifier = 245
	BACnetPropertyIdentifier_ACCESS_DOORS                        BACnetPropertyIdentifier = 246
	BACnetPropertyIdentifier_ACCESS_EVENT                        BACnetPropertyIdentifier = 247
	BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR  BACnetPropertyIdentifier = 248
	BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL             BACnetPropertyIdentifier = 249
	BACnetPropertyIdentifier_ACCESS_EVENT_TAG                    BACnetPropertyIdentifier = 322
	BACnetPropertyIdentifier_ACCESS_EVENT_TIME                   BACnetPropertyIdentifier = 250
	BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS           BACnetPropertyIdentifier = 251
	BACnetPropertyIdentifier_ACCOMPANIMENT                       BACnetPropertyIdentifier = 252
	BACnetPropertyIdentifier_ACCOMPANIMENT_TIME                  BACnetPropertyIdentifier = 253
	BACnetPropertyIdentifier_ACK_REQUIRED                        BACnetPropertyIdentifier = 1
	BACnetPropertyIdentifier_ACKED_TRANSITIONS                   BACnetPropertyIdentifier = 0
	BACnetPropertyIdentifier_ACTION                              BACnetPropertyIdentifier = 2
	BACnetPropertyIdentifier_ACTION_TEXT                         BACnetPropertyIdentifier = 3
	BACnetPropertyIdentifier_ACTIVATION_TIME                     BACnetPropertyIdentifier = 254
	BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY        BACnetPropertyIdentifier = 255
	BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS   BACnetPropertyIdentifier = 481
	BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS            BACnetPropertyIdentifier = 152
	BACnetPropertyIdentifier_ACTIVE_TEXT                         BACnetPropertyIdentifier = 4
	BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS                  BACnetPropertyIdentifier = 5
	BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL                   BACnetPropertyIdentifier = 212
	BACnetPropertyIdentifier_ADJUST_VALUE                        BACnetPropertyIdentifier = 176
	BACnetPropertyIdentifier_ALARM_VALUE                         BACnetPropertyIdentifier = 6
	BACnetPropertyIdentifier_ALARM_VALUES                        BACnetPropertyIdentifier = 7
	BACnetPropertyIdentifier_ALIGN_INTERVALS                     BACnetPropertyIdentifier = 193
	BACnetPropertyIdentifier_ALL                                 BACnetPropertyIdentifier = 8
	BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL               BACnetPropertyIdentifier = 9
	BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT           BACnetPropertyIdentifier = 365
	BACnetPropertyIdentifier_APDU_LENGTH                         BACnetPropertyIdentifier = 399
	BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT                BACnetPropertyIdentifier = 10
	BACnetPropertyIdentifier_APDU_TIMEOUT                        BACnetPropertyIdentifier = 11
	BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION        BACnetPropertyIdentifier = 12
	BACnetPropertyIdentifier_ARCHIVE                             BACnetPropertyIdentifier = 13
	BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS              BACnetPropertyIdentifier = 256
	BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS              BACnetPropertyIdentifier = 447
	BACnetPropertyIdentifier_ATTEMPTED_SAMPLES                   BACnetPropertyIdentifier = 124
	BACnetPropertyIdentifier_AUTHENTICATION_FACTORS              BACnetPropertyIdentifier = 257
	BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST          BACnetPropertyIdentifier = 258
	BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES         BACnetPropertyIdentifier = 259
	BACnetPropertyIdentifier_AUTHENTICATION_STATUS               BACnetPropertyIdentifier = 260
	BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS            BACnetPropertyIdentifier = 364
	BACnetPropertyIdentifier_AUTHORIZATION_MODE                  BACnetPropertyIdentifier = 261
	BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY                BACnetPropertyIdentifier = 169
	BACnetPropertyIdentifier_AVERAGE_VALUE                       BACnetPropertyIdentifier = 125
	BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE            BACnetPropertyIdentifier = 338
	BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT              BACnetPropertyIdentifier = 153
	BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME             BACnetPropertyIdentifier = 339
	BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS            BACnetPropertyIdentifier = 407
	BACnetPropertyIdentifier_BACNET_IP_MODE                      BACnetPropertyIdentifier = 408
	BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS         BACnetPropertyIdentifier = 409
	BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL             BACnetPropertyIdentifier = 410
	BACnetPropertyIdentifier_BACNET_IP_UDP_PORT                  BACnetPropertyIdentifier = 412
	BACnetPropertyIdentifier_BACNET_IPV6_MODE                    BACnetPropertyIdentifier = 435
	BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT                BACnetPropertyIdentifier = 438
	BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS       BACnetPropertyIdentifier = 440
	BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY         BACnetPropertyIdentifier = 327
	BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS        BACnetPropertyIdentifier = 413
	BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE   BACnetPropertyIdentifier = 414
	BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE           BACnetPropertyIdentifier = 415
	BACnetPropertyIdentifier_BELONGS_TO                          BACnetPropertyIdentifier = 262
	BACnetPropertyIdentifier_BIAS                                BACnetPropertyIdentifier = 14
	BACnetPropertyIdentifier_BIT_MASK                            BACnetPropertyIdentifier = 342
	BACnetPropertyIdentifier_BIT_TEXT                            BACnetPropertyIdentifier = 343
	BACnetPropertyIdentifier_BLINK_WARN_ENABLE                   BACnetPropertyIdentifier = 373
	BACnetPropertyIdentifier_BUFFER_SIZE                         BACnetPropertyIdentifier = 126
	BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION              BACnetPropertyIdentifier = 448
	BACnetPropertyIdentifier_CAR_DOOR_COMMAND                    BACnetPropertyIdentifier = 449
	BACnetPropertyIdentifier_CAR_DOOR_STATUS                     BACnetPropertyIdentifier = 450
	BACnetPropertyIdentifier_CAR_DOOR_TEXT                       BACnetPropertyIdentifier = 451
	BACnetPropertyIdentifier_CAR_DOOR_ZONE                       BACnetPropertyIdentifier = 452
	BACnetPropertyIdentifier_CAR_DRIVE_STATUS                    BACnetPropertyIdentifier = 453
	BACnetPropertyIdentifier_CAR_LOAD                            BACnetPropertyIdentifier = 454
	BACnetPropertyIdentifier_CAR_LOAD_UNITS                      BACnetPropertyIdentifier = 455
	BACnetPropertyIdentifier_CAR_MODE                            BACnetPropertyIdentifier = 456
	BACnetPropertyIdentifier_CAR_MOVING_DIRECTION                BACnetPropertyIdentifier = 457
	BACnetPropertyIdentifier_CAR_POSITION                        BACnetPropertyIdentifier = 458
	BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT               BACnetPropertyIdentifier = 15
	BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME                BACnetPropertyIdentifier = 16
	BACnetPropertyIdentifier_CHANGES_PENDING                     BACnetPropertyIdentifier = 416
	BACnetPropertyIdentifier_CHANNEL_NUMBER                      BACnetPropertyIdentifier = 366
	BACnetPropertyIdentifier_CLIENT_COV_INCREMENT                BACnetPropertyIdentifier = 127
	BACnetPropertyIdentifier_COMMAND                             BACnetPropertyIdentifier = 417
	BACnetPropertyIdentifier_COMMAND_TIME_ARRAY                  BACnetPropertyIdentifier = 430
	BACnetPropertyIdentifier_CONFIGURATION_FILES                 BACnetPropertyIdentifier = 154
	BACnetPropertyIdentifier_CONTROL_GROUPS                      BACnetPropertyIdentifier = 367
	BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE       BACnetPropertyIdentifier = 19
	BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS           BACnetPropertyIdentifier = 20
	BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE           BACnetPropertyIdentifier = 21
	BACnetPropertyIdentifier_COUNT                               BACnetPropertyIdentifier = 177
	BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE                 BACnetPropertyIdentifier = 178
	BACnetPropertyIdentifier_COUNT_CHANGE_TIME                   BACnetPropertyIdentifier = 179
	BACnetPropertyIdentifier_COV_INCREMENT                       BACnetPropertyIdentifier = 22
	BACnetPropertyIdentifier_COV_PERIOD                          BACnetPropertyIdentifier = 180
	BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL         BACnetPropertyIdentifier = 128
	BACnetPropertyIdentifier_COVU_PERIOD                         BACnetPropertyIdentifier = 349
	BACnetPropertyIdentifier_COVU_RECIPIENTS                     BACnetPropertyIdentifier = 350
	BACnetPropertyIdentifier_CREDENTIAL_DISABLE                  BACnetPropertyIdentifier = 263
	BACnetPropertyIdentifier_CREDENTIAL_STATUS                   BACnetPropertyIdentifier = 264
	BACnetPropertyIdentifier_CREDENTIALS                         BACnetPropertyIdentifier = 265
	BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE                 BACnetPropertyIdentifier = 266
	BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY            BACnetPropertyIdentifier = 431
	BACnetPropertyIdentifier_DATABASE_REVISION                   BACnetPropertyIdentifier = 155
	BACnetPropertyIdentifier_DATE_LIST                           BACnetPropertyIdentifier = 23
	BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS             BACnetPropertyIdentifier = 24
	BACnetPropertyIdentifier_DAYS_REMAINING                      BACnetPropertyIdentifier = 267
	BACnetPropertyIdentifier_DEADBAND                            BACnetPropertyIdentifier = 25
	BACnetPropertyIdentifier_DEFAULT_FADE_TIME                   BACnetPropertyIdentifier = 374
	BACnetPropertyIdentifier_DEFAULT_RAMP_RATE                   BACnetPropertyIdentifier = 375
	BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT              BACnetPropertyIdentifier = 376
	BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP    BACnetPropertyIdentifier = 490
	BACnetPropertyIdentifier_DEFAULT_TIMEOUT                     BACnetPropertyIdentifier = 393
	BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION           BACnetPropertyIdentifier = 484
	BACnetPropertyIdentifier_DERIVATIVE_CONSTANT                 BACnetPropertyIdentifier = 26
	BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS           BACnetPropertyIdentifier = 27
	BACnetPropertyIdentifier_DESCRIPTION                         BACnetPropertyIdentifier = 28
	BACnetPropertyIdentifier_DESCRIPTION_OF_HALT                 BACnetPropertyIdentifier = 29
	BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING              BACnetPropertyIdentifier = 30
	BACnetPropertyIdentifier_DEVICE_TYPE                         BACnetPropertyIdentifier = 31
	BACnetPropertyIdentifier_DIRECT_READING                      BACnetPropertyIdentifier = 156
	BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION           BACnetPropertyIdentifier = 328
	BACnetPropertyIdentifier_DO_NOT_HIDE                         BACnetPropertyIdentifier = 329
	BACnetPropertyIdentifier_DOOR_ALARM_STATE                    BACnetPropertyIdentifier = 226
	BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME            BACnetPropertyIdentifier = 227
	BACnetPropertyIdentifier_DOOR_MEMBERS                        BACnetPropertyIdentifier = 228
	BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME             BACnetPropertyIdentifier = 229
	BACnetPropertyIdentifier_DOOR_PULSE_TIME                     BACnetPropertyIdentifier = 230
	BACnetPropertyIdentifier_DOOR_STATUS                         BACnetPropertyIdentifier = 231
	BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME              BACnetPropertyIdentifier = 232
	BACnetPropertyIdentifier_DUTY_WINDOW                         BACnetPropertyIdentifier = 213
	BACnetPropertyIdentifier_EFFECTIVE_PERIOD                    BACnetPropertyIdentifier = 32
	BACnetPropertyIdentifier_EGRESS_ACTIVE                       BACnetPropertyIdentifier = 386
	BACnetPropertyIdentifier_EGRESS_TIME                         BACnetPropertyIdentifier = 377
	BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME                 BACnetPropertyIdentifier = 33
	BACnetPropertyIdentifier_ELEVATOR_GROUP                      BACnetPropertyIdentifier = 459
	BACnetPropertyIdentifier_ENABLE                              BACnetPropertyIdentifier = 133
	BACnetPropertyIdentifier_ENERGY_METER                        BACnetPropertyIdentifier = 460
	BACnetPropertyIdentifier_ENERGY_METER_REF                    BACnetPropertyIdentifier = 461
	BACnetPropertyIdentifier_ENTRY_POINTS                        BACnetPropertyIdentifier = 268
	BACnetPropertyIdentifier_ERROR_LIMIT                         BACnetPropertyIdentifier = 34
	BACnetPropertyIdentifier_ESCALATOR_MODE                      BACnetPropertyIdentifier = 462
	BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT             BACnetPropertyIdentifier = 354
	BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF         BACnetPropertyIdentifier = 355
	BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE              BACnetPropertyIdentifier = 353
	BACnetPropertyIdentifier_EVENT_ENABLE                        BACnetPropertyIdentifier = 35
	BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS                 BACnetPropertyIdentifier = 351
	BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG          BACnetPropertyIdentifier = 352
	BACnetPropertyIdentifier_EVENT_PARAMETERS                    BACnetPropertyIdentifier = 83
	BACnetPropertyIdentifier_EVENT_STATE                         BACnetPropertyIdentifier = 36
	BACnetPropertyIdentifier_EVENT_TIME_STAMPS                   BACnetPropertyIdentifier = 130
	BACnetPropertyIdentifier_EVENT_TYPE                          BACnetPropertyIdentifier = 37
	BACnetPropertyIdentifier_EXCEPTION_SCHEDULE                  BACnetPropertyIdentifier = 38
	BACnetPropertyIdentifier_EXECUTION_DELAY                     BACnetPropertyIdentifier = 368
	BACnetPropertyIdentifier_EXIT_POINTS                         BACnetPropertyIdentifier = 269
	BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL                 BACnetPropertyIdentifier = 214
	BACnetPropertyIdentifier_EXPIRATION_TIME                     BACnetPropertyIdentifier = 270
	BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE                BACnetPropertyIdentifier = 271
	BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS               BACnetPropertyIdentifier = 272
	BACnetPropertyIdentifier_FAILED_ATTEMPTS                     BACnetPropertyIdentifier = 273
	BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME                BACnetPropertyIdentifier = 274
	BACnetPropertyIdentifier_FAULT_HIGH_LIMIT                    BACnetPropertyIdentifier = 388
	BACnetPropertyIdentifier_FAULT_LOW_LIMIT                     BACnetPropertyIdentifier = 389
	BACnetPropertyIdentifier_FAULT_PARAMETERS                    BACnetPropertyIdentifier = 358
	BACnetPropertyIdentifier_FAULT_SIGNALS                       BACnetPropertyIdentifier = 463
	BACnetPropertyIdentifier_FAULT_TYPE                          BACnetPropertyIdentifier = 359
	BACnetPropertyIdentifier_FAULT_VALUES                        BACnetPropertyIdentifier = 39
	BACnetPropertyIdentifier_FD_BBMD_ADDRESS                     BACnetPropertyIdentifier = 418
	BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME            BACnetPropertyIdentifier = 419
	BACnetPropertyIdentifier_FEEDBACK_VALUE                      BACnetPropertyIdentifier = 40
	BACnetPropertyIdentifier_FILE_ACCESS_METHOD                  BACnetPropertyIdentifier = 41
	BACnetPropertyIdentifier_FILE_SIZE                           BACnetPropertyIdentifier = 42
	BACnetPropertyIdentifier_FILE_TYPE                           BACnetPropertyIdentifier = 43
	BACnetPropertyIdentifier_FIRMWARE_REVISION                   BACnetPropertyIdentifier = 44
	BACnetPropertyIdentifier_FLOOR_TEXT                          BACnetPropertyIdentifier = 464
	BACnetPropertyIdentifier_FULL_DUTY_BASELINE                  BACnetPropertyIdentifier = 215
	BACnetPropertyIdentifier_GLOBAL_IDENTIFIER                   BACnetPropertyIdentifier = 323
	BACnetPropertyIdentifier_GROUP_ID                            BACnetPropertyIdentifier = 465
	BACnetPropertyIdentifier_GROUP_MEMBER_NAMES                  BACnetPropertyIdentifier = 346
	BACnetPropertyIdentifier_GROUP_MEMBERS                       BACnetPropertyIdentifier = 345
	BACnetPropertyIdentifier_GROUP_MODE                          BACnetPropertyIdentifier = 467
	BACnetPropertyIdentifier_HIGH_LIMIT                          BACnetPropertyIdentifier = 45
	BACnetPropertyIdentifier_HIGHER_DECK                         BACnetPropertyIdentifier = 468
	BACnetPropertyIdentifier_IN_PROCESS                          BACnetPropertyIdentifier = 47
	BACnetPropertyIdentifier_IN_PROGRESS                         BACnetPropertyIdentifier = 378
	BACnetPropertyIdentifier_INACTIVE_TEXT                       BACnetPropertyIdentifier = 46
	BACnetPropertyIdentifier_INITIAL_TIMEOUT                     BACnetPropertyIdentifier = 394
	BACnetPropertyIdentifier_INPUT_REFERENCE                     BACnetPropertyIdentifier = 181
	BACnetPropertyIdentifier_INSTALLATION_ID                     BACnetPropertyIdentifier = 469
	BACnetPropertyIdentifier_INSTANCE_OF                         BACnetPropertyIdentifier = 48
	BACnetPropertyIdentifier_INSTANTANEOUS_POWER                 BACnetPropertyIdentifier = 379
	BACnetPropertyIdentifier_INTEGRAL_CONSTANT                   BACnetPropertyIdentifier = 49
	BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS             BACnetPropertyIdentifier = 50
	BACnetPropertyIdentifier_INTERFACE_VALUE                     BACnetPropertyIdentifier = 387
	BACnetPropertyIdentifier_INTERVAL_OFFSET                     BACnetPropertyIdentifier = 195
	BACnetPropertyIdentifier_IP_ADDRESS                          BACnetPropertyIdentifier = 400
	BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY                  BACnetPropertyIdentifier = 401
	BACnetPropertyIdentifier_IP_DHCP_ENABLE                      BACnetPropertyIdentifier = 402
	BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME                  BACnetPropertyIdentifier = 403
	BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING        BACnetPropertyIdentifier = 404
	BACnetPropertyIdentifier_IP_DHCP_SERVER                      BACnetPropertyIdentifier = 405
	BACnetPropertyIdentifier_IP_DNS_SERVER                       BACnetPropertyIdentifier = 406
	BACnetPropertyIdentifier_IP_SUBNET_MASK                      BACnetPropertyIdentifier = 411
	BACnetPropertyIdentifier_IPV6_ADDRESS                        BACnetPropertyIdentifier = 436
	BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE         BACnetPropertyIdentifier = 442
	BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY                BACnetPropertyIdentifier = 439
	BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME                BACnetPropertyIdentifier = 443
	BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING      BACnetPropertyIdentifier = 444
	BACnetPropertyIdentifier_IPV6_DHCP_SERVER                    BACnetPropertyIdentifier = 445
	BACnetPropertyIdentifier_IPV6_DNS_SERVER                     BACnetPropertyIdentifier = 441
	BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH                  BACnetPropertyIdentifier = 437
	BACnetPropertyIdentifier_IPV6_ZONE_INDEX                     BACnetPropertyIdentifier = 446
	BACnetPropertyIdentifier_IS_UTC                              BACnetPropertyIdentifier = 344
	BACnetPropertyIdentifier_KEY_SETS                            BACnetPropertyIdentifier = 330
	BACnetPropertyIdentifier_LANDING_CALL_CONTROL                BACnetPropertyIdentifier = 471
	BACnetPropertyIdentifier_LANDING_CALLS                       BACnetPropertyIdentifier = 470
	BACnetPropertyIdentifier_LANDING_DOOR_STATUS                 BACnetPropertyIdentifier = 472
	BACnetPropertyIdentifier_LAST_ACCESS_EVENT                   BACnetPropertyIdentifier = 275
	BACnetPropertyIdentifier_LAST_ACCESS_POINT                   BACnetPropertyIdentifier = 276
	BACnetPropertyIdentifier_LAST_COMMAND_TIME                   BACnetPropertyIdentifier = 432
	BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED               BACnetPropertyIdentifier = 277
	BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME          BACnetPropertyIdentifier = 278
	BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED             BACnetPropertyIdentifier = 279
	BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME        BACnetPropertyIdentifier = 280
	BACnetPropertyIdentifier_LAST_KEY_SERVER                     BACnetPropertyIdentifier = 331
	BACnetPropertyIdentifier_LAST_NOTIFY_RECORD                  BACnetPropertyIdentifier = 173
	BACnetPropertyIdentifier_LAST_PRIORITY                       BACnetPropertyIdentifier = 369
	BACnetPropertyIdentifier_LAST_RESTART_REASON                 BACnetPropertyIdentifier = 196
	BACnetPropertyIdentifier_LAST_RESTORE_TIME                   BACnetPropertyIdentifier = 157
	BACnetPropertyIdentifier_LAST_STATE_CHANGE                   BACnetPropertyIdentifier = 395
	BACnetPropertyIdentifier_LAST_USE_TIME                       BACnetPropertyIdentifier = 281
	BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES            BACnetPropertyIdentifier = 166
	BACnetPropertyIdentifier_LIGHTING_COMMAND                    BACnetPropertyIdentifier = 380
	BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY   BACnetPropertyIdentifier = 381
	BACnetPropertyIdentifier_LIMIT_ENABLE                        BACnetPropertyIdentifier = 52
	BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL           BACnetPropertyIdentifier = 182
	BACnetPropertyIdentifier_LINK_SPEED                          BACnetPropertyIdentifier = 420
	BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE            BACnetPropertyIdentifier = 422
	BACnetPropertyIdentifier_LINK_SPEEDS                         BACnetPropertyIdentifier = 421
	BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS               BACnetPropertyIdentifier = 53
	BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES  BACnetPropertyIdentifier = 54
	BACnetPropertyIdentifier_LOCAL_DATE                          BACnetPropertyIdentifier = 56
	BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY               BACnetPropertyIdentifier = 360
	BACnetPropertyIdentifier_LOCAL_TIME                          BACnetPropertyIdentifier = 57
	BACnetPropertyIdentifier_LOCATION                            BACnetPropertyIdentifier = 58
	BACnetPropertyIdentifier_LOCK_STATUS                         BACnetPropertyIdentifier = 233
	BACnetPropertyIdentifier_LOCKOUT                             BACnetPropertyIdentifier = 282
	BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME             BACnetPropertyIdentifier = 283
	BACnetPropertyIdentifier_LOG_BUFFER                          BACnetPropertyIdentifier = 131
	BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY          BACnetPropertyIdentifier = 132
	BACnetPropertyIdentifier_LOG_INTERVAL                        BACnetPropertyIdentifier = 134
	BACnetPropertyIdentifier_LOGGING_OBJECT                      BACnetPropertyIdentifier = 183
	BACnetPropertyIdentifier_LOGGING_RECORD                      BACnetPropertyIdentifier = 184
	BACnetPropertyIdentifier_LOGGING_TYPE                        BACnetPropertyIdentifier = 197
	BACnetPropertyIdentifier_LOW_DIFF_LIMIT                      BACnetPropertyIdentifier = 390
	BACnetPropertyIdentifier_LOW_LIMIT                           BACnetPropertyIdentifier = 59
	BACnetPropertyIdentifier_LOWER_DECK                          BACnetPropertyIdentifier = 473
	BACnetPropertyIdentifier_MAC_ADDRESS                         BACnetPropertyIdentifier = 423
	BACnetPropertyIdentifier_MACHINE_ROOM_ID                     BACnetPropertyIdentifier = 474
	BACnetPropertyIdentifier_MAINTENANCE_REQUIRED                BACnetPropertyIdentifier = 158
	BACnetPropertyIdentifier_MAKING_CAR_CALL                     BACnetPropertyIdentifier = 475
	BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE      BACnetPropertyIdentifier = 60
	BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING        BACnetPropertyIdentifier = 170
	BACnetPropertyIdentifier_MASKED_ALARM_VALUES                 BACnetPropertyIdentifier = 234
	BACnetPropertyIdentifier_MAX_ACTUAL_VALUE                    BACnetPropertyIdentifier = 382
	BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED            BACnetPropertyIdentifier = 62
	BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS                 BACnetPropertyIdentifier = 285
	BACnetPropertyIdentifier_MAX_INFO_FRAMES                     BACnetPropertyIdentifier = 63
	BACnetPropertyIdentifier_MAX_MASTER                          BACnetPropertyIdentifier = 64
	BACnetPropertyIdentifier_MAX_PRES_VALUE                      BACnetPropertyIdentifier = 65
	BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED               BACnetPropertyIdentifier = 167
	BACnetPropertyIdentifier_MAXIMUM_OUTPUT                      BACnetPropertyIdentifier = 61
	BACnetPropertyIdentifier_MAXIMUM_VALUE                       BACnetPropertyIdentifier = 135
	BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP             BACnetPropertyIdentifier = 149
	BACnetPropertyIdentifier_MEMBER_OF                           BACnetPropertyIdentifier = 159
	BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS                 BACnetPropertyIdentifier = 347
	BACnetPropertyIdentifier_MEMBERS                             BACnetPropertyIdentifier = 286
	BACnetPropertyIdentifier_MIN_ACTUAL_VALUE                    BACnetPropertyIdentifier = 383
	BACnetPropertyIdentifier_MIN_PRES_VALUE                      BACnetPropertyIdentifier = 69
	BACnetPropertyIdentifier_MINIMUM_OFF_TIME                    BACnetPropertyIdentifier = 66
	BACnetPropertyIdentifier_MINIMUM_ON_TIME                     BACnetPropertyIdentifier = 67
	BACnetPropertyIdentifier_MINIMUM_OUTPUT                      BACnetPropertyIdentifier = 68
	BACnetPropertyIdentifier_MINIMUM_VALUE                       BACnetPropertyIdentifier = 136
	BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP             BACnetPropertyIdentifier = 150
	BACnetPropertyIdentifier_MODE                                BACnetPropertyIdentifier = 160
	BACnetPropertyIdentifier_MODEL_NAME                          BACnetPropertyIdentifier = 70
	BACnetPropertyIdentifier_MODIFICATION_DATE                   BACnetPropertyIdentifier = 71
	BACnetPropertyIdentifier_MUSTER_POINT                        BACnetPropertyIdentifier = 287
	BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES               BACnetPropertyIdentifier = 288
	BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES    BACnetPropertyIdentifier = 332
	BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME              BACnetPropertyIdentifier = 424
	BACnetPropertyIdentifier_NETWORK_NUMBER                      BACnetPropertyIdentifier = 425
	BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY              BACnetPropertyIdentifier = 426
	BACnetPropertyIdentifier_NETWORK_TYPE                        BACnetPropertyIdentifier = 427
	BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR                 BACnetPropertyIdentifier = 476
	BACnetPropertyIdentifier_NODE_SUBTYPE                        BACnetPropertyIdentifier = 207
	BACnetPropertyIdentifier_NODE_TYPE                           BACnetPropertyIdentifier = 208
	BACnetPropertyIdentifier_NOTIFICATION_CLASS                  BACnetPropertyIdentifier = 17
	BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD              BACnetPropertyIdentifier = 137
	BACnetPropertyIdentifier_NOTIFY_TYPE                         BACnetPropertyIdentifier = 72
	BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES              BACnetPropertyIdentifier = 73
	BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES   BACnetPropertyIdentifier = 289
	BACnetPropertyIdentifier_NUMBER_OF_STATES                    BACnetPropertyIdentifier = 74
	BACnetPropertyIdentifier_OBJECT_IDENTIFIER                   BACnetPropertyIdentifier = 75
	BACnetPropertyIdentifier_OBJECT_LIST                         BACnetPropertyIdentifier = 76
	BACnetPropertyIdentifier_OBJECT_NAME                         BACnetPropertyIdentifier = 77
	BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE           BACnetPropertyIdentifier = 78
	BACnetPropertyIdentifier_OBJECT_TYPE                         BACnetPropertyIdentifier = 79
	BACnetPropertyIdentifier_OCCUPANCY_COUNT                     BACnetPropertyIdentifier = 290
	BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST              BACnetPropertyIdentifier = 291
	BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE              BACnetPropertyIdentifier = 292
	BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT               BACnetPropertyIdentifier = 294
	BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED      BACnetPropertyIdentifier = 295
	BACnetPropertyIdentifier_OCCUPANCY_STATE                     BACnetPropertyIdentifier = 296
	BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT               BACnetPropertyIdentifier = 297
	BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED      BACnetPropertyIdentifier = 298
	BACnetPropertyIdentifier_OPERATION_DIRECTION                 BACnetPropertyIdentifier = 477
	BACnetPropertyIdentifier_OPERATION_EXPECTED                  BACnetPropertyIdentifier = 161
	BACnetPropertyIdentifier_OPTIONAL                            BACnetPropertyIdentifier = 80
	BACnetPropertyIdentifier_OUT_OF_SERVICE                      BACnetPropertyIdentifier = 81
	BACnetPropertyIdentifier_OUTPUT_UNITS                        BACnetPropertyIdentifier = 82
	BACnetPropertyIdentifier_PACKET_REORDER_TIME                 BACnetPropertyIdentifier = 333
	BACnetPropertyIdentifier_PASSBACK_MODE                       BACnetPropertyIdentifier = 300
	BACnetPropertyIdentifier_PASSBACK_TIMEOUT                    BACnetPropertyIdentifier = 301
	BACnetPropertyIdentifier_PASSENGER_ALARM                     BACnetPropertyIdentifier = 478
	BACnetPropertyIdentifier_POLARITY                            BACnetPropertyIdentifier = 84
	BACnetPropertyIdentifier_PORT_FILTER                         BACnetPropertyIdentifier = 363
	BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES               BACnetPropertyIdentifier = 302
	BACnetPropertyIdentifier_POWER                               BACnetPropertyIdentifier = 384
	BACnetPropertyIdentifier_POWER_MODE                          BACnetPropertyIdentifier = 479
	BACnetPropertyIdentifier_PRESCALE                            BACnetPropertyIdentifier = 185
	BACnetPropertyIdentifier_PRESENT_VALUE                       BACnetPropertyIdentifier = 85
	BACnetPropertyIdentifier_PRIORITY                            BACnetPropertyIdentifier = 86
	BACnetPropertyIdentifier_PRIORITY_ARRAY                      BACnetPropertyIdentifier = 87
	BACnetPropertyIdentifier_PRIORITY_FOR_WRITING                BACnetPropertyIdentifier = 88
	BACnetPropertyIdentifier_PROCESS_IDENTIFIER                  BACnetPropertyIdentifier = 89
	BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER           BACnetPropertyIdentifier = 361
	BACnetPropertyIdentifier_PROFILE_LOCATION                    BACnetPropertyIdentifier = 485
	BACnetPropertyIdentifier_PROFILE_NAME                        BACnetPropertyIdentifier = 168
	BACnetPropertyIdentifier_PROGRAM_CHANGE                      BACnetPropertyIdentifier = 90
	BACnetPropertyIdentifier_PROGRAM_LOCATION                    BACnetPropertyIdentifier = 91
	BACnetPropertyIdentifier_PROGRAM_STATE                       BACnetPropertyIdentifier = 92
	BACnetPropertyIdentifier_PROPERTY_LIST                       BACnetPropertyIdentifier = 371
	BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT               BACnetPropertyIdentifier = 93
	BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS         BACnetPropertyIdentifier = 94
	BACnetPropertyIdentifier_PROTOCOL_LEVEL                      BACnetPropertyIdentifier = 482
	BACnetPropertyIdentifier_PROTOCOL_CONFORMANCE_CLASS          BACnetPropertyIdentifier = 95
	BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED     BACnetPropertyIdentifier = 96
	BACnetPropertyIdentifier_PROTOCOL_REVISION                   BACnetPropertyIdentifier = 139
	BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED         BACnetPropertyIdentifier = 97
	BACnetPropertyIdentifier_PROTOCOL_VERSION                    BACnetPropertyIdentifier = 98
	BACnetPropertyIdentifier_PULSE_RATE                          BACnetPropertyIdentifier = 186
	BACnetPropertyIdentifier_READ_ONLY                           BACnetPropertyIdentifier = 99
	BACnetPropertyIdentifier_REASON_FOR_DISABLE                  BACnetPropertyIdentifier = 303
	BACnetPropertyIdentifier_REASON_FOR_HALT                     BACnetPropertyIdentifier = 100
	BACnetPropertyIdentifier_RECIPIENT_LIST                      BACnetPropertyIdentifier = 102
	BACnetPropertyIdentifier_RECORD_COUNT                        BACnetPropertyIdentifier = 141
	BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION          BACnetPropertyIdentifier = 140
	BACnetPropertyIdentifier_REFERENCE_PORT                      BACnetPropertyIdentifier = 483
	BACnetPropertyIdentifier_REGISTERED_CAR_CALL                 BACnetPropertyIdentifier = 480
	BACnetPropertyIdentifier_RELIABILITY                         BACnetPropertyIdentifier = 103
	BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT      BACnetPropertyIdentifier = 357
	BACnetPropertyIdentifier_RELINQUISH_DEFAULT                  BACnetPropertyIdentifier = 104
	BACnetPropertyIdentifier_REPRESENTS                          BACnetPropertyIdentifier = 491
	BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL                BACnetPropertyIdentifier = 218
	BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL           BACnetPropertyIdentifier = 348
	BACnetPropertyIdentifier_REQUIRED                            BACnetPropertyIdentifier = 105
	BACnetPropertyIdentifier_RESOLUTION                          BACnetPropertyIdentifier = 106
	BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS     BACnetPropertyIdentifier = 202
	BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME             BACnetPropertyIdentifier = 340
	BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME            BACnetPropertyIdentifier = 341
	BACnetPropertyIdentifier_ROUTING_TABLE                       BACnetPropertyIdentifier = 428
	BACnetPropertyIdentifier_SCALE                               BACnetPropertyIdentifier = 187
	BACnetPropertyIdentifier_SCALE_FACTOR                        BACnetPropertyIdentifier = 188
	BACnetPropertyIdentifier_SCHEDULE_DEFAULT                    BACnetPropertyIdentifier = 174
	BACnetPropertyIdentifier_SECURED_STATUS                      BACnetPropertyIdentifier = 235
	BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT                BACnetPropertyIdentifier = 334
	BACnetPropertyIdentifier_SECURITY_TIME_WINDOW                BACnetPropertyIdentifier = 335
	BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED              BACnetPropertyIdentifier = 107
	BACnetPropertyIdentifier_SERIAL_NUMBER                       BACnetPropertyIdentifier = 372
	BACnetPropertyIdentifier_SETPOINT                            BACnetPropertyIdentifier = 108
	BACnetPropertyIdentifier_SETPOINT_REFERENCE                  BACnetPropertyIdentifier = 109
	BACnetPropertyIdentifier_SETTING                             BACnetPropertyIdentifier = 162
	BACnetPropertyIdentifier_SHED_DURATION                       BACnetPropertyIdentifier = 219
	BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS             BACnetPropertyIdentifier = 220
	BACnetPropertyIdentifier_SHED_LEVELS                         BACnetPropertyIdentifier = 221
	BACnetPropertyIdentifier_SILENCED                            BACnetPropertyIdentifier = 163
	BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING               BACnetPropertyIdentifier = 171
	BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE                  BACnetPropertyIdentifier = 172
	BACnetPropertyIdentifier_START_TIME                          BACnetPropertyIdentifier = 142
	BACnetPropertyIdentifier_STATE_CHANGE_VALUES                 BACnetPropertyIdentifier = 396
	BACnetPropertyIdentifier_STATE_DESCRIPTION                   BACnetPropertyIdentifier = 222
	BACnetPropertyIdentifier_STATE_TEXT                          BACnetPropertyIdentifier = 110
	BACnetPropertyIdentifier_STATUS_FLAGS                        BACnetPropertyIdentifier = 111
	BACnetPropertyIdentifier_STOP_TIME                           BACnetPropertyIdentifier = 143
	BACnetPropertyIdentifier_STOP_WHEN_FULL                      BACnetPropertyIdentifier = 144
	BACnetPropertyIdentifier_STRIKE_COUNT                        BACnetPropertyIdentifier = 391
	BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST              BACnetPropertyIdentifier = 209
	BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS             BACnetPropertyIdentifier = 210
	BACnetPropertyIdentifier_SUBORDINATE_LIST                    BACnetPropertyIdentifier = 211
	BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES              BACnetPropertyIdentifier = 487
	BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS           BACnetPropertyIdentifier = 489
	BACnetPropertyIdentifier_SUBORDINATE_TAGS                    BACnetPropertyIdentifier = 488
	BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS               BACnetPropertyIdentifier = 362
	BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES            BACnetPropertyIdentifier = 305
	BACnetPropertyIdentifier_SUPPORTED_FORMATS                   BACnetPropertyIdentifier = 304
	BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS       BACnetPropertyIdentifier = 336
	BACnetPropertyIdentifier_SYSTEM_STATUS                       BACnetPropertyIdentifier = 112
	BACnetPropertyIdentifier_TAGS                                BACnetPropertyIdentifier = 486
	BACnetPropertyIdentifier_THREAT_AUTHORITY                    BACnetPropertyIdentifier = 306
	BACnetPropertyIdentifier_THREAT_LEVEL                        BACnetPropertyIdentifier = 307
	BACnetPropertyIdentifier_TIME_DELAY                          BACnetPropertyIdentifier = 113
	BACnetPropertyIdentifier_TIME_DELAY_NORMAL                   BACnetPropertyIdentifier = 356
	BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET           BACnetPropertyIdentifier = 114
	BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART              BACnetPropertyIdentifier = 203
	BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET           BACnetPropertyIdentifier = 115
	BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET          BACnetPropertyIdentifier = 392
	BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL       BACnetPropertyIdentifier = 204
	BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS     BACnetPropertyIdentifier = 116
	BACnetPropertyIdentifier_TIMER_RUNNING                       BACnetPropertyIdentifier = 397
	BACnetPropertyIdentifier_TIMER_STATE                         BACnetPropertyIdentifier = 398
	BACnetPropertyIdentifier_TOTAL_RECORD_COUNT                  BACnetPropertyIdentifier = 145
	BACnetPropertyIdentifier_TRACE_FLAG                          BACnetPropertyIdentifier = 308
	BACnetPropertyIdentifier_TRACKING_VALUE                      BACnetPropertyIdentifier = 164
	BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS      BACnetPropertyIdentifier = 309
	BACnetPropertyIdentifier_TRANSITION                          BACnetPropertyIdentifier = 385
	BACnetPropertyIdentifier_TRIGGER                             BACnetPropertyIdentifier = 205
	BACnetPropertyIdentifier_UNITS                               BACnetPropertyIdentifier = 117
	BACnetPropertyIdentifier_UPDATE_INTERVAL                     BACnetPropertyIdentifier = 118
	BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT              BACnetPropertyIdentifier = 337
	BACnetPropertyIdentifier_UPDATE_TIME                         BACnetPropertyIdentifier = 189
	BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER            BACnetPropertyIdentifier = 310
	BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE          BACnetPropertyIdentifier = 311
	BACnetPropertyIdentifier_USER_NAME                           BACnetPropertyIdentifier = 317
	BACnetPropertyIdentifier_USER_TYPE                           BACnetPropertyIdentifier = 318
	BACnetPropertyIdentifier_USES_REMAINING                      BACnetPropertyIdentifier = 319
	BACnetPropertyIdentifier_UTC_OFFSET                          BACnetPropertyIdentifier = 119
	BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS BACnetPropertyIdentifier = 206
	BACnetPropertyIdentifier_VALID_SAMPLES                       BACnetPropertyIdentifier = 146
	BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE                 BACnetPropertyIdentifier = 190
	BACnetPropertyIdentifier_VALUE_CHANGE_TIME                   BACnetPropertyIdentifier = 192
	BACnetPropertyIdentifier_VALUE_SET                           BACnetPropertyIdentifier = 191
	BACnetPropertyIdentifier_VALUE_SOURCE                        BACnetPropertyIdentifier = 433
	BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY                  BACnetPropertyIdentifier = 434
	BACnetPropertyIdentifier_VARIANCE_VALUE                      BACnetPropertyIdentifier = 151
	BACnetPropertyIdentifier_VENDOR_IDENTIFIER                   BACnetPropertyIdentifier = 120
	BACnetPropertyIdentifier_VENDOR_NAME                         BACnetPropertyIdentifier = 121
	BACnetPropertyIdentifier_VERIFICATION_TIME                   BACnetPropertyIdentifier = 326
	BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE           BACnetPropertyIdentifier = 429
	BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED                BACnetPropertyIdentifier = 122
	BACnetPropertyIdentifier_WEEKLY_SCHEDULE                     BACnetPropertyIdentifier = 123
	BACnetPropertyIdentifier_WINDOW_INTERVAL                     BACnetPropertyIdentifier = 147
	BACnetPropertyIdentifier_WINDOW_SAMPLES                      BACnetPropertyIdentifier = 148
	BACnetPropertyIdentifier_WRITE_STATUS                        BACnetPropertyIdentifier = 370
	BACnetPropertyIdentifier_ZONE_FROM                           BACnetPropertyIdentifier = 320
	BACnetPropertyIdentifier_ZONE_MEMBERS                        BACnetPropertyIdentifier = 165
	BACnetPropertyIdentifier_ZONE_TO                             BACnetPropertyIdentifier = 321
	BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE            BACnetPropertyIdentifier = 9999
)

var BACnetPropertyIdentifierValues []BACnetPropertyIdentifier

func init() {
	_ = errors.New
	BACnetPropertyIdentifierValues = []BACnetPropertyIdentifier{
		BACnetPropertyIdentifier_ABSENTEE_LIMIT,
		BACnetPropertyIdentifier_ACCEPTED_MODES,
		BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS,
		BACnetPropertyIdentifier_ACCESS_DOORS,
		BACnetPropertyIdentifier_ACCESS_EVENT,
		BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR,
		BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL,
		BACnetPropertyIdentifier_ACCESS_EVENT_TAG,
		BACnetPropertyIdentifier_ACCESS_EVENT_TIME,
		BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS,
		BACnetPropertyIdentifier_ACCOMPANIMENT,
		BACnetPropertyIdentifier_ACCOMPANIMENT_TIME,
		BACnetPropertyIdentifier_ACK_REQUIRED,
		BACnetPropertyIdentifier_ACKED_TRANSITIONS,
		BACnetPropertyIdentifier_ACTION,
		BACnetPropertyIdentifier_ACTION_TEXT,
		BACnetPropertyIdentifier_ACTIVATION_TIME,
		BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY,
		BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS,
		BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS,
		BACnetPropertyIdentifier_ACTIVE_TEXT,
		BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS,
		BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL,
		BACnetPropertyIdentifier_ADJUST_VALUE,
		BACnetPropertyIdentifier_ALARM_VALUE,
		BACnetPropertyIdentifier_ALARM_VALUES,
		BACnetPropertyIdentifier_ALIGN_INTERVALS,
		BACnetPropertyIdentifier_ALL,
		BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL,
		BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT,
		BACnetPropertyIdentifier_APDU_LENGTH,
		BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT,
		BACnetPropertyIdentifier_APDU_TIMEOUT,
		BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION,
		BACnetPropertyIdentifier_ARCHIVE,
		BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS,
		BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS,
		BACnetPropertyIdentifier_ATTEMPTED_SAMPLES,
		BACnetPropertyIdentifier_AUTHENTICATION_FACTORS,
		BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST,
		BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES,
		BACnetPropertyIdentifier_AUTHENTICATION_STATUS,
		BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS,
		BACnetPropertyIdentifier_AUTHORIZATION_MODE,
		BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY,
		BACnetPropertyIdentifier_AVERAGE_VALUE,
		BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE,
		BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT,
		BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME,
		BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS,
		BACnetPropertyIdentifier_BACNET_IP_MODE,
		BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS,
		BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL,
		BACnetPropertyIdentifier_BACNET_IP_UDP_PORT,
		BACnetPropertyIdentifier_BACNET_IPV6_MODE,
		BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT,
		BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS,
		BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY,
		BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS,
		BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE,
		BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE,
		BACnetPropertyIdentifier_BELONGS_TO,
		BACnetPropertyIdentifier_BIAS,
		BACnetPropertyIdentifier_BIT_MASK,
		BACnetPropertyIdentifier_BIT_TEXT,
		BACnetPropertyIdentifier_BLINK_WARN_ENABLE,
		BACnetPropertyIdentifier_BUFFER_SIZE,
		BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION,
		BACnetPropertyIdentifier_CAR_DOOR_COMMAND,
		BACnetPropertyIdentifier_CAR_DOOR_STATUS,
		BACnetPropertyIdentifier_CAR_DOOR_TEXT,
		BACnetPropertyIdentifier_CAR_DOOR_ZONE,
		BACnetPropertyIdentifier_CAR_DRIVE_STATUS,
		BACnetPropertyIdentifier_CAR_LOAD,
		BACnetPropertyIdentifier_CAR_LOAD_UNITS,
		BACnetPropertyIdentifier_CAR_MODE,
		BACnetPropertyIdentifier_CAR_MOVING_DIRECTION,
		BACnetPropertyIdentifier_CAR_POSITION,
		BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT,
		BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME,
		BACnetPropertyIdentifier_CHANGES_PENDING,
		BACnetPropertyIdentifier_CHANNEL_NUMBER,
		BACnetPropertyIdentifier_CLIENT_COV_INCREMENT,
		BACnetPropertyIdentifier_COMMAND,
		BACnetPropertyIdentifier_COMMAND_TIME_ARRAY,
		BACnetPropertyIdentifier_CONFIGURATION_FILES,
		BACnetPropertyIdentifier_CONTROL_GROUPS,
		BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE,
		BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS,
		BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE,
		BACnetPropertyIdentifier_COUNT,
		BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE,
		BACnetPropertyIdentifier_COUNT_CHANGE_TIME,
		BACnetPropertyIdentifier_COV_INCREMENT,
		BACnetPropertyIdentifier_COV_PERIOD,
		BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL,
		BACnetPropertyIdentifier_COVU_PERIOD,
		BACnetPropertyIdentifier_COVU_RECIPIENTS,
		BACnetPropertyIdentifier_CREDENTIAL_DISABLE,
		BACnetPropertyIdentifier_CREDENTIAL_STATUS,
		BACnetPropertyIdentifier_CREDENTIALS,
		BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE,
		BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY,
		BACnetPropertyIdentifier_DATABASE_REVISION,
		BACnetPropertyIdentifier_DATE_LIST,
		BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS,
		BACnetPropertyIdentifier_DAYS_REMAINING,
		BACnetPropertyIdentifier_DEADBAND,
		BACnetPropertyIdentifier_DEFAULT_FADE_TIME,
		BACnetPropertyIdentifier_DEFAULT_RAMP_RATE,
		BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT,
		BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP,
		BACnetPropertyIdentifier_DEFAULT_TIMEOUT,
		BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION,
		BACnetPropertyIdentifier_DERIVATIVE_CONSTANT,
		BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS,
		BACnetPropertyIdentifier_DESCRIPTION,
		BACnetPropertyIdentifier_DESCRIPTION_OF_HALT,
		BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING,
		BACnetPropertyIdentifier_DEVICE_TYPE,
		BACnetPropertyIdentifier_DIRECT_READING,
		BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION,
		BACnetPropertyIdentifier_DO_NOT_HIDE,
		BACnetPropertyIdentifier_DOOR_ALARM_STATE,
		BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME,
		BACnetPropertyIdentifier_DOOR_MEMBERS,
		BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME,
		BACnetPropertyIdentifier_DOOR_PULSE_TIME,
		BACnetPropertyIdentifier_DOOR_STATUS,
		BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME,
		BACnetPropertyIdentifier_DUTY_WINDOW,
		BACnetPropertyIdentifier_EFFECTIVE_PERIOD,
		BACnetPropertyIdentifier_EGRESS_ACTIVE,
		BACnetPropertyIdentifier_EGRESS_TIME,
		BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME,
		BACnetPropertyIdentifier_ELEVATOR_GROUP,
		BACnetPropertyIdentifier_ENABLE,
		BACnetPropertyIdentifier_ENERGY_METER,
		BACnetPropertyIdentifier_ENERGY_METER_REF,
		BACnetPropertyIdentifier_ENTRY_POINTS,
		BACnetPropertyIdentifier_ERROR_LIMIT,
		BACnetPropertyIdentifier_ESCALATOR_MODE,
		BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT,
		BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF,
		BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE,
		BACnetPropertyIdentifier_EVENT_ENABLE,
		BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS,
		BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG,
		BACnetPropertyIdentifier_EVENT_PARAMETERS,
		BACnetPropertyIdentifier_EVENT_STATE,
		BACnetPropertyIdentifier_EVENT_TIME_STAMPS,
		BACnetPropertyIdentifier_EVENT_TYPE,
		BACnetPropertyIdentifier_EXCEPTION_SCHEDULE,
		BACnetPropertyIdentifier_EXECUTION_DELAY,
		BACnetPropertyIdentifier_EXIT_POINTS,
		BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL,
		BACnetPropertyIdentifier_EXPIRATION_TIME,
		BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE,
		BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS,
		BACnetPropertyIdentifier_FAILED_ATTEMPTS,
		BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME,
		BACnetPropertyIdentifier_FAULT_HIGH_LIMIT,
		BACnetPropertyIdentifier_FAULT_LOW_LIMIT,
		BACnetPropertyIdentifier_FAULT_PARAMETERS,
		BACnetPropertyIdentifier_FAULT_SIGNALS,
		BACnetPropertyIdentifier_FAULT_TYPE,
		BACnetPropertyIdentifier_FAULT_VALUES,
		BACnetPropertyIdentifier_FD_BBMD_ADDRESS,
		BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME,
		BACnetPropertyIdentifier_FEEDBACK_VALUE,
		BACnetPropertyIdentifier_FILE_ACCESS_METHOD,
		BACnetPropertyIdentifier_FILE_SIZE,
		BACnetPropertyIdentifier_FILE_TYPE,
		BACnetPropertyIdentifier_FIRMWARE_REVISION,
		BACnetPropertyIdentifier_FLOOR_TEXT,
		BACnetPropertyIdentifier_FULL_DUTY_BASELINE,
		BACnetPropertyIdentifier_GLOBAL_IDENTIFIER,
		BACnetPropertyIdentifier_GROUP_ID,
		BACnetPropertyIdentifier_GROUP_MEMBER_NAMES,
		BACnetPropertyIdentifier_GROUP_MEMBERS,
		BACnetPropertyIdentifier_GROUP_MODE,
		BACnetPropertyIdentifier_HIGH_LIMIT,
		BACnetPropertyIdentifier_HIGHER_DECK,
		BACnetPropertyIdentifier_IN_PROCESS,
		BACnetPropertyIdentifier_IN_PROGRESS,
		BACnetPropertyIdentifier_INACTIVE_TEXT,
		BACnetPropertyIdentifier_INITIAL_TIMEOUT,
		BACnetPropertyIdentifier_INPUT_REFERENCE,
		BACnetPropertyIdentifier_INSTALLATION_ID,
		BACnetPropertyIdentifier_INSTANCE_OF,
		BACnetPropertyIdentifier_INSTANTANEOUS_POWER,
		BACnetPropertyIdentifier_INTEGRAL_CONSTANT,
		BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS,
		BACnetPropertyIdentifier_INTERFACE_VALUE,
		BACnetPropertyIdentifier_INTERVAL_OFFSET,
		BACnetPropertyIdentifier_IP_ADDRESS,
		BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY,
		BACnetPropertyIdentifier_IP_DHCP_ENABLE,
		BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME,
		BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING,
		BACnetPropertyIdentifier_IP_DHCP_SERVER,
		BACnetPropertyIdentifier_IP_DNS_SERVER,
		BACnetPropertyIdentifier_IP_SUBNET_MASK,
		BACnetPropertyIdentifier_IPV6_ADDRESS,
		BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE,
		BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY,
		BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME,
		BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING,
		BACnetPropertyIdentifier_IPV6_DHCP_SERVER,
		BACnetPropertyIdentifier_IPV6_DNS_SERVER,
		BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH,
		BACnetPropertyIdentifier_IPV6_ZONE_INDEX,
		BACnetPropertyIdentifier_IS_UTC,
		BACnetPropertyIdentifier_KEY_SETS,
		BACnetPropertyIdentifier_LANDING_CALL_CONTROL,
		BACnetPropertyIdentifier_LANDING_CALLS,
		BACnetPropertyIdentifier_LANDING_DOOR_STATUS,
		BACnetPropertyIdentifier_LAST_ACCESS_EVENT,
		BACnetPropertyIdentifier_LAST_ACCESS_POINT,
		BACnetPropertyIdentifier_LAST_COMMAND_TIME,
		BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED,
		BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME,
		BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED,
		BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME,
		BACnetPropertyIdentifier_LAST_KEY_SERVER,
		BACnetPropertyIdentifier_LAST_NOTIFY_RECORD,
		BACnetPropertyIdentifier_LAST_PRIORITY,
		BACnetPropertyIdentifier_LAST_RESTART_REASON,
		BACnetPropertyIdentifier_LAST_RESTORE_TIME,
		BACnetPropertyIdentifier_LAST_STATE_CHANGE,
		BACnetPropertyIdentifier_LAST_USE_TIME,
		BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES,
		BACnetPropertyIdentifier_LIGHTING_COMMAND,
		BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY,
		BACnetPropertyIdentifier_LIMIT_ENABLE,
		BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL,
		BACnetPropertyIdentifier_LINK_SPEED,
		BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE,
		BACnetPropertyIdentifier_LINK_SPEEDS,
		BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS,
		BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES,
		BACnetPropertyIdentifier_LOCAL_DATE,
		BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY,
		BACnetPropertyIdentifier_LOCAL_TIME,
		BACnetPropertyIdentifier_LOCATION,
		BACnetPropertyIdentifier_LOCK_STATUS,
		BACnetPropertyIdentifier_LOCKOUT,
		BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME,
		BACnetPropertyIdentifier_LOG_BUFFER,
		BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY,
		BACnetPropertyIdentifier_LOG_INTERVAL,
		BACnetPropertyIdentifier_LOGGING_OBJECT,
		BACnetPropertyIdentifier_LOGGING_RECORD,
		BACnetPropertyIdentifier_LOGGING_TYPE,
		BACnetPropertyIdentifier_LOW_DIFF_LIMIT,
		BACnetPropertyIdentifier_LOW_LIMIT,
		BACnetPropertyIdentifier_LOWER_DECK,
		BACnetPropertyIdentifier_MAC_ADDRESS,
		BACnetPropertyIdentifier_MACHINE_ROOM_ID,
		BACnetPropertyIdentifier_MAINTENANCE_REQUIRED,
		BACnetPropertyIdentifier_MAKING_CAR_CALL,
		BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE,
		BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING,
		BACnetPropertyIdentifier_MASKED_ALARM_VALUES,
		BACnetPropertyIdentifier_MAX_ACTUAL_VALUE,
		BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED,
		BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS,
		BACnetPropertyIdentifier_MAX_INFO_FRAMES,
		BACnetPropertyIdentifier_MAX_MASTER,
		BACnetPropertyIdentifier_MAX_PRES_VALUE,
		BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED,
		BACnetPropertyIdentifier_MAXIMUM_OUTPUT,
		BACnetPropertyIdentifier_MAXIMUM_VALUE,
		BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP,
		BACnetPropertyIdentifier_MEMBER_OF,
		BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS,
		BACnetPropertyIdentifier_MEMBERS,
		BACnetPropertyIdentifier_MIN_ACTUAL_VALUE,
		BACnetPropertyIdentifier_MIN_PRES_VALUE,
		BACnetPropertyIdentifier_MINIMUM_OFF_TIME,
		BACnetPropertyIdentifier_MINIMUM_ON_TIME,
		BACnetPropertyIdentifier_MINIMUM_OUTPUT,
		BACnetPropertyIdentifier_MINIMUM_VALUE,
		BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP,
		BACnetPropertyIdentifier_MODE,
		BACnetPropertyIdentifier_MODEL_NAME,
		BACnetPropertyIdentifier_MODIFICATION_DATE,
		BACnetPropertyIdentifier_MUSTER_POINT,
		BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES,
		BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES,
		BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME,
		BACnetPropertyIdentifier_NETWORK_NUMBER,
		BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY,
		BACnetPropertyIdentifier_NETWORK_TYPE,
		BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR,
		BACnetPropertyIdentifier_NODE_SUBTYPE,
		BACnetPropertyIdentifier_NODE_TYPE,
		BACnetPropertyIdentifier_NOTIFICATION_CLASS,
		BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD,
		BACnetPropertyIdentifier_NOTIFY_TYPE,
		BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES,
		BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES,
		BACnetPropertyIdentifier_NUMBER_OF_STATES,
		BACnetPropertyIdentifier_OBJECT_IDENTIFIER,
		BACnetPropertyIdentifier_OBJECT_LIST,
		BACnetPropertyIdentifier_OBJECT_NAME,
		BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE,
		BACnetPropertyIdentifier_OBJECT_TYPE,
		BACnetPropertyIdentifier_OCCUPANCY_COUNT,
		BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST,
		BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE,
		BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT,
		BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED,
		BACnetPropertyIdentifier_OCCUPANCY_STATE,
		BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT,
		BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED,
		BACnetPropertyIdentifier_OPERATION_DIRECTION,
		BACnetPropertyIdentifier_OPERATION_EXPECTED,
		BACnetPropertyIdentifier_OPTIONAL,
		BACnetPropertyIdentifier_OUT_OF_SERVICE,
		BACnetPropertyIdentifier_OUTPUT_UNITS,
		BACnetPropertyIdentifier_PACKET_REORDER_TIME,
		BACnetPropertyIdentifier_PASSBACK_MODE,
		BACnetPropertyIdentifier_PASSBACK_TIMEOUT,
		BACnetPropertyIdentifier_PASSENGER_ALARM,
		BACnetPropertyIdentifier_POLARITY,
		BACnetPropertyIdentifier_PORT_FILTER,
		BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES,
		BACnetPropertyIdentifier_POWER,
		BACnetPropertyIdentifier_POWER_MODE,
		BACnetPropertyIdentifier_PRESCALE,
		BACnetPropertyIdentifier_PRESENT_VALUE,
		BACnetPropertyIdentifier_PRIORITY,
		BACnetPropertyIdentifier_PRIORITY_ARRAY,
		BACnetPropertyIdentifier_PRIORITY_FOR_WRITING,
		BACnetPropertyIdentifier_PROCESS_IDENTIFIER,
		BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER,
		BACnetPropertyIdentifier_PROFILE_LOCATION,
		BACnetPropertyIdentifier_PROFILE_NAME,
		BACnetPropertyIdentifier_PROGRAM_CHANGE,
		BACnetPropertyIdentifier_PROGRAM_LOCATION,
		BACnetPropertyIdentifier_PROGRAM_STATE,
		BACnetPropertyIdentifier_PROPERTY_LIST,
		BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT,
		BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS,
		BACnetPropertyIdentifier_PROTOCOL_LEVEL,
		BACnetPropertyIdentifier_PROTOCOL_CONFORMANCE_CLASS,
		BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED,
		BACnetPropertyIdentifier_PROTOCOL_REVISION,
		BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED,
		BACnetPropertyIdentifier_PROTOCOL_VERSION,
		BACnetPropertyIdentifier_PULSE_RATE,
		BACnetPropertyIdentifier_READ_ONLY,
		BACnetPropertyIdentifier_REASON_FOR_DISABLE,
		BACnetPropertyIdentifier_REASON_FOR_HALT,
		BACnetPropertyIdentifier_RECIPIENT_LIST,
		BACnetPropertyIdentifier_RECORD_COUNT,
		BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION,
		BACnetPropertyIdentifier_REFERENCE_PORT,
		BACnetPropertyIdentifier_REGISTERED_CAR_CALL,
		BACnetPropertyIdentifier_RELIABILITY,
		BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT,
		BACnetPropertyIdentifier_RELINQUISH_DEFAULT,
		BACnetPropertyIdentifier_REPRESENTS,
		BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL,
		BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL,
		BACnetPropertyIdentifier_REQUIRED,
		BACnetPropertyIdentifier_RESOLUTION,
		BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS,
		BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME,
		BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME,
		BACnetPropertyIdentifier_ROUTING_TABLE,
		BACnetPropertyIdentifier_SCALE,
		BACnetPropertyIdentifier_SCALE_FACTOR,
		BACnetPropertyIdentifier_SCHEDULE_DEFAULT,
		BACnetPropertyIdentifier_SECURED_STATUS,
		BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT,
		BACnetPropertyIdentifier_SECURITY_TIME_WINDOW,
		BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED,
		BACnetPropertyIdentifier_SERIAL_NUMBER,
		BACnetPropertyIdentifier_SETPOINT,
		BACnetPropertyIdentifier_SETPOINT_REFERENCE,
		BACnetPropertyIdentifier_SETTING,
		BACnetPropertyIdentifier_SHED_DURATION,
		BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS,
		BACnetPropertyIdentifier_SHED_LEVELS,
		BACnetPropertyIdentifier_SILENCED,
		BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING,
		BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE,
		BACnetPropertyIdentifier_START_TIME,
		BACnetPropertyIdentifier_STATE_CHANGE_VALUES,
		BACnetPropertyIdentifier_STATE_DESCRIPTION,
		BACnetPropertyIdentifier_STATE_TEXT,
		BACnetPropertyIdentifier_STATUS_FLAGS,
		BACnetPropertyIdentifier_STOP_TIME,
		BACnetPropertyIdentifier_STOP_WHEN_FULL,
		BACnetPropertyIdentifier_STRIKE_COUNT,
		BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST,
		BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS,
		BACnetPropertyIdentifier_SUBORDINATE_LIST,
		BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES,
		BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS,
		BACnetPropertyIdentifier_SUBORDINATE_TAGS,
		BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS,
		BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES,
		BACnetPropertyIdentifier_SUPPORTED_FORMATS,
		BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS,
		BACnetPropertyIdentifier_SYSTEM_STATUS,
		BACnetPropertyIdentifier_TAGS,
		BACnetPropertyIdentifier_THREAT_AUTHORITY,
		BACnetPropertyIdentifier_THREAT_LEVEL,
		BACnetPropertyIdentifier_TIME_DELAY,
		BACnetPropertyIdentifier_TIME_DELAY_NORMAL,
		BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET,
		BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART,
		BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET,
		BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET,
		BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL,
		BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS,
		BACnetPropertyIdentifier_TIMER_RUNNING,
		BACnetPropertyIdentifier_TIMER_STATE,
		BACnetPropertyIdentifier_TOTAL_RECORD_COUNT,
		BACnetPropertyIdentifier_TRACE_FLAG,
		BACnetPropertyIdentifier_TRACKING_VALUE,
		BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS,
		BACnetPropertyIdentifier_TRANSITION,
		BACnetPropertyIdentifier_TRIGGER,
		BACnetPropertyIdentifier_UNITS,
		BACnetPropertyIdentifier_UPDATE_INTERVAL,
		BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT,
		BACnetPropertyIdentifier_UPDATE_TIME,
		BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER,
		BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE,
		BACnetPropertyIdentifier_USER_NAME,
		BACnetPropertyIdentifier_USER_TYPE,
		BACnetPropertyIdentifier_USES_REMAINING,
		BACnetPropertyIdentifier_UTC_OFFSET,
		BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS,
		BACnetPropertyIdentifier_VALID_SAMPLES,
		BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE,
		BACnetPropertyIdentifier_VALUE_CHANGE_TIME,
		BACnetPropertyIdentifier_VALUE_SET,
		BACnetPropertyIdentifier_VALUE_SOURCE,
		BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY,
		BACnetPropertyIdentifier_VARIANCE_VALUE,
		BACnetPropertyIdentifier_VENDOR_IDENTIFIER,
		BACnetPropertyIdentifier_VENDOR_NAME,
		BACnetPropertyIdentifier_VERIFICATION_TIME,
		BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE,
		BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED,
		BACnetPropertyIdentifier_WEEKLY_SCHEDULE,
		BACnetPropertyIdentifier_WINDOW_INTERVAL,
		BACnetPropertyIdentifier_WINDOW_SAMPLES,
		BACnetPropertyIdentifier_WRITE_STATUS,
		BACnetPropertyIdentifier_ZONE_FROM,
		BACnetPropertyIdentifier_ZONE_MEMBERS,
		BACnetPropertyIdentifier_ZONE_TO,
		BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE,
	}
}

func BACnetPropertyIdentifierByValue(value uint32) (enum BACnetPropertyIdentifier, ok bool) {
	switch value {
	case 0:
		return BACnetPropertyIdentifier_ACKED_TRANSITIONS, true
	case 1:
		return BACnetPropertyIdentifier_ACK_REQUIRED, true
	case 10:
		return BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT, true
	case 100:
		return BACnetPropertyIdentifier_REASON_FOR_HALT, true
	case 102:
		return BACnetPropertyIdentifier_RECIPIENT_LIST, true
	case 103:
		return BACnetPropertyIdentifier_RELIABILITY, true
	case 104:
		return BACnetPropertyIdentifier_RELINQUISH_DEFAULT, true
	case 105:
		return BACnetPropertyIdentifier_REQUIRED, true
	case 106:
		return BACnetPropertyIdentifier_RESOLUTION, true
	case 107:
		return BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED, true
	case 108:
		return BACnetPropertyIdentifier_SETPOINT, true
	case 109:
		return BACnetPropertyIdentifier_SETPOINT_REFERENCE, true
	case 11:
		return BACnetPropertyIdentifier_APDU_TIMEOUT, true
	case 110:
		return BACnetPropertyIdentifier_STATE_TEXT, true
	case 111:
		return BACnetPropertyIdentifier_STATUS_FLAGS, true
	case 112:
		return BACnetPropertyIdentifier_SYSTEM_STATUS, true
	case 113:
		return BACnetPropertyIdentifier_TIME_DELAY, true
	case 114:
		return BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET, true
	case 115:
		return BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET, true
	case 116:
		return BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS, true
	case 117:
		return BACnetPropertyIdentifier_UNITS, true
	case 118:
		return BACnetPropertyIdentifier_UPDATE_INTERVAL, true
	case 119:
		return BACnetPropertyIdentifier_UTC_OFFSET, true
	case 12:
		return BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION, true
	case 120:
		return BACnetPropertyIdentifier_VENDOR_IDENTIFIER, true
	case 121:
		return BACnetPropertyIdentifier_VENDOR_NAME, true
	case 122:
		return BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED, true
	case 123:
		return BACnetPropertyIdentifier_WEEKLY_SCHEDULE, true
	case 124:
		return BACnetPropertyIdentifier_ATTEMPTED_SAMPLES, true
	case 125:
		return BACnetPropertyIdentifier_AVERAGE_VALUE, true
	case 126:
		return BACnetPropertyIdentifier_BUFFER_SIZE, true
	case 127:
		return BACnetPropertyIdentifier_CLIENT_COV_INCREMENT, true
	case 128:
		return BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL, true
	case 13:
		return BACnetPropertyIdentifier_ARCHIVE, true
	case 130:
		return BACnetPropertyIdentifier_EVENT_TIME_STAMPS, true
	case 131:
		return BACnetPropertyIdentifier_LOG_BUFFER, true
	case 132:
		return BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY, true
	case 133:
		return BACnetPropertyIdentifier_ENABLE, true
	case 134:
		return BACnetPropertyIdentifier_LOG_INTERVAL, true
	case 135:
		return BACnetPropertyIdentifier_MAXIMUM_VALUE, true
	case 136:
		return BACnetPropertyIdentifier_MINIMUM_VALUE, true
	case 137:
		return BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD, true
	case 139:
		return BACnetPropertyIdentifier_PROTOCOL_REVISION, true
	case 14:
		return BACnetPropertyIdentifier_BIAS, true
	case 140:
		return BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION, true
	case 141:
		return BACnetPropertyIdentifier_RECORD_COUNT, true
	case 142:
		return BACnetPropertyIdentifier_START_TIME, true
	case 143:
		return BACnetPropertyIdentifier_STOP_TIME, true
	case 144:
		return BACnetPropertyIdentifier_STOP_WHEN_FULL, true
	case 145:
		return BACnetPropertyIdentifier_TOTAL_RECORD_COUNT, true
	case 146:
		return BACnetPropertyIdentifier_VALID_SAMPLES, true
	case 147:
		return BACnetPropertyIdentifier_WINDOW_INTERVAL, true
	case 148:
		return BACnetPropertyIdentifier_WINDOW_SAMPLES, true
	case 149:
		return BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP, true
	case 15:
		return BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT, true
	case 150:
		return BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP, true
	case 151:
		return BACnetPropertyIdentifier_VARIANCE_VALUE, true
	case 152:
		return BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS, true
	case 153:
		return BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT, true
	case 154:
		return BACnetPropertyIdentifier_CONFIGURATION_FILES, true
	case 155:
		return BACnetPropertyIdentifier_DATABASE_REVISION, true
	case 156:
		return BACnetPropertyIdentifier_DIRECT_READING, true
	case 157:
		return BACnetPropertyIdentifier_LAST_RESTORE_TIME, true
	case 158:
		return BACnetPropertyIdentifier_MAINTENANCE_REQUIRED, true
	case 159:
		return BACnetPropertyIdentifier_MEMBER_OF, true
	case 16:
		return BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME, true
	case 160:
		return BACnetPropertyIdentifier_MODE, true
	case 161:
		return BACnetPropertyIdentifier_OPERATION_EXPECTED, true
	case 162:
		return BACnetPropertyIdentifier_SETTING, true
	case 163:
		return BACnetPropertyIdentifier_SILENCED, true
	case 164:
		return BACnetPropertyIdentifier_TRACKING_VALUE, true
	case 165:
		return BACnetPropertyIdentifier_ZONE_MEMBERS, true
	case 166:
		return BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES, true
	case 167:
		return BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED, true
	case 168:
		return BACnetPropertyIdentifier_PROFILE_NAME, true
	case 169:
		return BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY, true
	case 17:
		return BACnetPropertyIdentifier_NOTIFICATION_CLASS, true
	case 170:
		return BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING, true
	case 171:
		return BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING, true
	case 172:
		return BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE, true
	case 173:
		return BACnetPropertyIdentifier_LAST_NOTIFY_RECORD, true
	case 174:
		return BACnetPropertyIdentifier_SCHEDULE_DEFAULT, true
	case 175:
		return BACnetPropertyIdentifier_ACCEPTED_MODES, true
	case 176:
		return BACnetPropertyIdentifier_ADJUST_VALUE, true
	case 177:
		return BACnetPropertyIdentifier_COUNT, true
	case 178:
		return BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE, true
	case 179:
		return BACnetPropertyIdentifier_COUNT_CHANGE_TIME, true
	case 180:
		return BACnetPropertyIdentifier_COV_PERIOD, true
	case 181:
		return BACnetPropertyIdentifier_INPUT_REFERENCE, true
	case 182:
		return BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL, true
	case 183:
		return BACnetPropertyIdentifier_LOGGING_OBJECT, true
	case 184:
		return BACnetPropertyIdentifier_LOGGING_RECORD, true
	case 185:
		return BACnetPropertyIdentifier_PRESCALE, true
	case 186:
		return BACnetPropertyIdentifier_PULSE_RATE, true
	case 187:
		return BACnetPropertyIdentifier_SCALE, true
	case 188:
		return BACnetPropertyIdentifier_SCALE_FACTOR, true
	case 189:
		return BACnetPropertyIdentifier_UPDATE_TIME, true
	case 19:
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE, true
	case 190:
		return BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE, true
	case 191:
		return BACnetPropertyIdentifier_VALUE_SET, true
	case 192:
		return BACnetPropertyIdentifier_VALUE_CHANGE_TIME, true
	case 193:
		return BACnetPropertyIdentifier_ALIGN_INTERVALS, true
	case 195:
		return BACnetPropertyIdentifier_INTERVAL_OFFSET, true
	case 196:
		return BACnetPropertyIdentifier_LAST_RESTART_REASON, true
	case 197:
		return BACnetPropertyIdentifier_LOGGING_TYPE, true
	case 2:
		return BACnetPropertyIdentifier_ACTION, true
	case 20:
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS, true
	case 202:
		return BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS, true
	case 203:
		return BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART, true
	case 204:
		return BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL, true
	case 205:
		return BACnetPropertyIdentifier_TRIGGER, true
	case 206:
		return BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS, true
	case 207:
		return BACnetPropertyIdentifier_NODE_SUBTYPE, true
	case 208:
		return BACnetPropertyIdentifier_NODE_TYPE, true
	case 209:
		return BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST, true
	case 21:
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE, true
	case 210:
		return BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS, true
	case 211:
		return BACnetPropertyIdentifier_SUBORDINATE_LIST, true
	case 212:
		return BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL, true
	case 213:
		return BACnetPropertyIdentifier_DUTY_WINDOW, true
	case 214:
		return BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL, true
	case 215:
		return BACnetPropertyIdentifier_FULL_DUTY_BASELINE, true
	case 218:
		return BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL, true
	case 219:
		return BACnetPropertyIdentifier_SHED_DURATION, true
	case 22:
		return BACnetPropertyIdentifier_COV_INCREMENT, true
	case 220:
		return BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS, true
	case 221:
		return BACnetPropertyIdentifier_SHED_LEVELS, true
	case 222:
		return BACnetPropertyIdentifier_STATE_DESCRIPTION, true
	case 226:
		return BACnetPropertyIdentifier_DOOR_ALARM_STATE, true
	case 227:
		return BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME, true
	case 228:
		return BACnetPropertyIdentifier_DOOR_MEMBERS, true
	case 229:
		return BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME, true
	case 23:
		return BACnetPropertyIdentifier_DATE_LIST, true
	case 230:
		return BACnetPropertyIdentifier_DOOR_PULSE_TIME, true
	case 231:
		return BACnetPropertyIdentifier_DOOR_STATUS, true
	case 232:
		return BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME, true
	case 233:
		return BACnetPropertyIdentifier_LOCK_STATUS, true
	case 234:
		return BACnetPropertyIdentifier_MASKED_ALARM_VALUES, true
	case 235:
		return BACnetPropertyIdentifier_SECURED_STATUS, true
	case 24:
		return BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS, true
	case 244:
		return BACnetPropertyIdentifier_ABSENTEE_LIMIT, true
	case 245:
		return BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS, true
	case 246:
		return BACnetPropertyIdentifier_ACCESS_DOORS, true
	case 247:
		return BACnetPropertyIdentifier_ACCESS_EVENT, true
	case 248:
		return BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR, true
	case 249:
		return BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL, true
	case 25:
		return BACnetPropertyIdentifier_DEADBAND, true
	case 250:
		return BACnetPropertyIdentifier_ACCESS_EVENT_TIME, true
	case 251:
		return BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS, true
	case 252:
		return BACnetPropertyIdentifier_ACCOMPANIMENT, true
	case 253:
		return BACnetPropertyIdentifier_ACCOMPANIMENT_TIME, true
	case 254:
		return BACnetPropertyIdentifier_ACTIVATION_TIME, true
	case 255:
		return BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY, true
	case 256:
		return BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS, true
	case 257:
		return BACnetPropertyIdentifier_AUTHENTICATION_FACTORS, true
	case 258:
		return BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST, true
	case 259:
		return BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES, true
	case 26:
		return BACnetPropertyIdentifier_DERIVATIVE_CONSTANT, true
	case 260:
		return BACnetPropertyIdentifier_AUTHENTICATION_STATUS, true
	case 261:
		return BACnetPropertyIdentifier_AUTHORIZATION_MODE, true
	case 262:
		return BACnetPropertyIdentifier_BELONGS_TO, true
	case 263:
		return BACnetPropertyIdentifier_CREDENTIAL_DISABLE, true
	case 264:
		return BACnetPropertyIdentifier_CREDENTIAL_STATUS, true
	case 265:
		return BACnetPropertyIdentifier_CREDENTIALS, true
	case 266:
		return BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE, true
	case 267:
		return BACnetPropertyIdentifier_DAYS_REMAINING, true
	case 268:
		return BACnetPropertyIdentifier_ENTRY_POINTS, true
	case 269:
		return BACnetPropertyIdentifier_EXIT_POINTS, true
	case 27:
		return BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS, true
	case 270:
		return BACnetPropertyIdentifier_EXPIRATION_TIME, true
	case 271:
		return BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE, true
	case 272:
		return BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS, true
	case 273:
		return BACnetPropertyIdentifier_FAILED_ATTEMPTS, true
	case 274:
		return BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME, true
	case 275:
		return BACnetPropertyIdentifier_LAST_ACCESS_EVENT, true
	case 276:
		return BACnetPropertyIdentifier_LAST_ACCESS_POINT, true
	case 277:
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED, true
	case 278:
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME, true
	case 279:
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED, true
	case 28:
		return BACnetPropertyIdentifier_DESCRIPTION, true
	case 280:
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME, true
	case 281:
		return BACnetPropertyIdentifier_LAST_USE_TIME, true
	case 282:
		return BACnetPropertyIdentifier_LOCKOUT, true
	case 283:
		return BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME, true
	case 285:
		return BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS, true
	case 286:
		return BACnetPropertyIdentifier_MEMBERS, true
	case 287:
		return BACnetPropertyIdentifier_MUSTER_POINT, true
	case 288:
		return BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES, true
	case 289:
		return BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES, true
	case 29:
		return BACnetPropertyIdentifier_DESCRIPTION_OF_HALT, true
	case 290:
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT, true
	case 291:
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST, true
	case 292:
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE, true
	case 294:
		return BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT, true
	case 295:
		return BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED, true
	case 296:
		return BACnetPropertyIdentifier_OCCUPANCY_STATE, true
	case 297:
		return BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT, true
	case 298:
		return BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED, true
	case 3:
		return BACnetPropertyIdentifier_ACTION_TEXT, true
	case 30:
		return BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING, true
	case 300:
		return BACnetPropertyIdentifier_PASSBACK_MODE, true
	case 301:
		return BACnetPropertyIdentifier_PASSBACK_TIMEOUT, true
	case 302:
		return BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES, true
	case 303:
		return BACnetPropertyIdentifier_REASON_FOR_DISABLE, true
	case 304:
		return BACnetPropertyIdentifier_SUPPORTED_FORMATS, true
	case 305:
		return BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES, true
	case 306:
		return BACnetPropertyIdentifier_THREAT_AUTHORITY, true
	case 307:
		return BACnetPropertyIdentifier_THREAT_LEVEL, true
	case 308:
		return BACnetPropertyIdentifier_TRACE_FLAG, true
	case 309:
		return BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS, true
	case 31:
		return BACnetPropertyIdentifier_DEVICE_TYPE, true
	case 310:
		return BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER, true
	case 311:
		return BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE, true
	case 317:
		return BACnetPropertyIdentifier_USER_NAME, true
	case 318:
		return BACnetPropertyIdentifier_USER_TYPE, true
	case 319:
		return BACnetPropertyIdentifier_USES_REMAINING, true
	case 32:
		return BACnetPropertyIdentifier_EFFECTIVE_PERIOD, true
	case 320:
		return BACnetPropertyIdentifier_ZONE_FROM, true
	case 321:
		return BACnetPropertyIdentifier_ZONE_TO, true
	case 322:
		return BACnetPropertyIdentifier_ACCESS_EVENT_TAG, true
	case 323:
		return BACnetPropertyIdentifier_GLOBAL_IDENTIFIER, true
	case 326:
		return BACnetPropertyIdentifier_VERIFICATION_TIME, true
	case 327:
		return BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY, true
	case 328:
		return BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION, true
	case 329:
		return BACnetPropertyIdentifier_DO_NOT_HIDE, true
	case 33:
		return BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME, true
	case 330:
		return BACnetPropertyIdentifier_KEY_SETS, true
	case 331:
		return BACnetPropertyIdentifier_LAST_KEY_SERVER, true
	case 332:
		return BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES, true
	case 333:
		return BACnetPropertyIdentifier_PACKET_REORDER_TIME, true
	case 334:
		return BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT, true
	case 335:
		return BACnetPropertyIdentifier_SECURITY_TIME_WINDOW, true
	case 336:
		return BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS, true
	case 337:
		return BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT, true
	case 338:
		return BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE, true
	case 339:
		return BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME, true
	case 34:
		return BACnetPropertyIdentifier_ERROR_LIMIT, true
	case 340:
		return BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME, true
	case 341:
		return BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME, true
	case 342:
		return BACnetPropertyIdentifier_BIT_MASK, true
	case 343:
		return BACnetPropertyIdentifier_BIT_TEXT, true
	case 344:
		return BACnetPropertyIdentifier_IS_UTC, true
	case 345:
		return BACnetPropertyIdentifier_GROUP_MEMBERS, true
	case 346:
		return BACnetPropertyIdentifier_GROUP_MEMBER_NAMES, true
	case 347:
		return BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS, true
	case 348:
		return BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL, true
	case 349:
		return BACnetPropertyIdentifier_COVU_PERIOD, true
	case 35:
		return BACnetPropertyIdentifier_EVENT_ENABLE, true
	case 350:
		return BACnetPropertyIdentifier_COVU_RECIPIENTS, true
	case 351:
		return BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS, true
	case 352:
		return BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG, true
	case 353:
		return BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE, true
	case 354:
		return BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT, true
	case 355:
		return BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF, true
	case 356:
		return BACnetPropertyIdentifier_TIME_DELAY_NORMAL, true
	case 357:
		return BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT, true
	case 358:
		return BACnetPropertyIdentifier_FAULT_PARAMETERS, true
	case 359:
		return BACnetPropertyIdentifier_FAULT_TYPE, true
	case 36:
		return BACnetPropertyIdentifier_EVENT_STATE, true
	case 360:
		return BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY, true
	case 361:
		return BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER, true
	case 362:
		return BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS, true
	case 363:
		return BACnetPropertyIdentifier_PORT_FILTER, true
	case 364:
		return BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS, true
	case 365:
		return BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT, true
	case 366:
		return BACnetPropertyIdentifier_CHANNEL_NUMBER, true
	case 367:
		return BACnetPropertyIdentifier_CONTROL_GROUPS, true
	case 368:
		return BACnetPropertyIdentifier_EXECUTION_DELAY, true
	case 369:
		return BACnetPropertyIdentifier_LAST_PRIORITY, true
	case 37:
		return BACnetPropertyIdentifier_EVENT_TYPE, true
	case 370:
		return BACnetPropertyIdentifier_WRITE_STATUS, true
	case 371:
		return BACnetPropertyIdentifier_PROPERTY_LIST, true
	case 372:
		return BACnetPropertyIdentifier_SERIAL_NUMBER, true
	case 373:
		return BACnetPropertyIdentifier_BLINK_WARN_ENABLE, true
	case 374:
		return BACnetPropertyIdentifier_DEFAULT_FADE_TIME, true
	case 375:
		return BACnetPropertyIdentifier_DEFAULT_RAMP_RATE, true
	case 376:
		return BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT, true
	case 377:
		return BACnetPropertyIdentifier_EGRESS_TIME, true
	case 378:
		return BACnetPropertyIdentifier_IN_PROGRESS, true
	case 379:
		return BACnetPropertyIdentifier_INSTANTANEOUS_POWER, true
	case 38:
		return BACnetPropertyIdentifier_EXCEPTION_SCHEDULE, true
	case 380:
		return BACnetPropertyIdentifier_LIGHTING_COMMAND, true
	case 381:
		return BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY, true
	case 382:
		return BACnetPropertyIdentifier_MAX_ACTUAL_VALUE, true
	case 383:
		return BACnetPropertyIdentifier_MIN_ACTUAL_VALUE, true
	case 384:
		return BACnetPropertyIdentifier_POWER, true
	case 385:
		return BACnetPropertyIdentifier_TRANSITION, true
	case 386:
		return BACnetPropertyIdentifier_EGRESS_ACTIVE, true
	case 387:
		return BACnetPropertyIdentifier_INTERFACE_VALUE, true
	case 388:
		return BACnetPropertyIdentifier_FAULT_HIGH_LIMIT, true
	case 389:
		return BACnetPropertyIdentifier_FAULT_LOW_LIMIT, true
	case 39:
		return BACnetPropertyIdentifier_FAULT_VALUES, true
	case 390:
		return BACnetPropertyIdentifier_LOW_DIFF_LIMIT, true
	case 391:
		return BACnetPropertyIdentifier_STRIKE_COUNT, true
	case 392:
		return BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET, true
	case 393:
		return BACnetPropertyIdentifier_DEFAULT_TIMEOUT, true
	case 394:
		return BACnetPropertyIdentifier_INITIAL_TIMEOUT, true
	case 395:
		return BACnetPropertyIdentifier_LAST_STATE_CHANGE, true
	case 396:
		return BACnetPropertyIdentifier_STATE_CHANGE_VALUES, true
	case 397:
		return BACnetPropertyIdentifier_TIMER_RUNNING, true
	case 398:
		return BACnetPropertyIdentifier_TIMER_STATE, true
	case 399:
		return BACnetPropertyIdentifier_APDU_LENGTH, true
	case 4:
		return BACnetPropertyIdentifier_ACTIVE_TEXT, true
	case 40:
		return BACnetPropertyIdentifier_FEEDBACK_VALUE, true
	case 400:
		return BACnetPropertyIdentifier_IP_ADDRESS, true
	case 401:
		return BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY, true
	case 402:
		return BACnetPropertyIdentifier_IP_DHCP_ENABLE, true
	case 403:
		return BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME, true
	case 404:
		return BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING, true
	case 405:
		return BACnetPropertyIdentifier_IP_DHCP_SERVER, true
	case 406:
		return BACnetPropertyIdentifier_IP_DNS_SERVER, true
	case 407:
		return BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS, true
	case 408:
		return BACnetPropertyIdentifier_BACNET_IP_MODE, true
	case 409:
		return BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS, true
	case 41:
		return BACnetPropertyIdentifier_FILE_ACCESS_METHOD, true
	case 410:
		return BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL, true
	case 411:
		return BACnetPropertyIdentifier_IP_SUBNET_MASK, true
	case 412:
		return BACnetPropertyIdentifier_BACNET_IP_UDP_PORT, true
	case 413:
		return BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS, true
	case 414:
		return BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE, true
	case 415:
		return BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE, true
	case 416:
		return BACnetPropertyIdentifier_CHANGES_PENDING, true
	case 417:
		return BACnetPropertyIdentifier_COMMAND, true
	case 418:
		return BACnetPropertyIdentifier_FD_BBMD_ADDRESS, true
	case 419:
		return BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME, true
	case 42:
		return BACnetPropertyIdentifier_FILE_SIZE, true
	case 420:
		return BACnetPropertyIdentifier_LINK_SPEED, true
	case 421:
		return BACnetPropertyIdentifier_LINK_SPEEDS, true
	case 422:
		return BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE, true
	case 423:
		return BACnetPropertyIdentifier_MAC_ADDRESS, true
	case 424:
		return BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME, true
	case 425:
		return BACnetPropertyIdentifier_NETWORK_NUMBER, true
	case 426:
		return BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY, true
	case 427:
		return BACnetPropertyIdentifier_NETWORK_TYPE, true
	case 428:
		return BACnetPropertyIdentifier_ROUTING_TABLE, true
	case 429:
		return BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE, true
	case 43:
		return BACnetPropertyIdentifier_FILE_TYPE, true
	case 430:
		return BACnetPropertyIdentifier_COMMAND_TIME_ARRAY, true
	case 431:
		return BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY, true
	case 432:
		return BACnetPropertyIdentifier_LAST_COMMAND_TIME, true
	case 433:
		return BACnetPropertyIdentifier_VALUE_SOURCE, true
	case 434:
		return BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY, true
	case 435:
		return BACnetPropertyIdentifier_BACNET_IPV6_MODE, true
	case 436:
		return BACnetPropertyIdentifier_IPV6_ADDRESS, true
	case 437:
		return BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH, true
	case 438:
		return BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT, true
	case 439:
		return BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY, true
	case 44:
		return BACnetPropertyIdentifier_FIRMWARE_REVISION, true
	case 440:
		return BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS, true
	case 441:
		return BACnetPropertyIdentifier_IPV6_DNS_SERVER, true
	case 442:
		return BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE, true
	case 443:
		return BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME, true
	case 444:
		return BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING, true
	case 445:
		return BACnetPropertyIdentifier_IPV6_DHCP_SERVER, true
	case 446:
		return BACnetPropertyIdentifier_IPV6_ZONE_INDEX, true
	case 447:
		return BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS, true
	case 448:
		return BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION, true
	case 449:
		return BACnetPropertyIdentifier_CAR_DOOR_COMMAND, true
	case 45:
		return BACnetPropertyIdentifier_HIGH_LIMIT, true
	case 450:
		return BACnetPropertyIdentifier_CAR_DOOR_STATUS, true
	case 451:
		return BACnetPropertyIdentifier_CAR_DOOR_TEXT, true
	case 452:
		return BACnetPropertyIdentifier_CAR_DOOR_ZONE, true
	case 453:
		return BACnetPropertyIdentifier_CAR_DRIVE_STATUS, true
	case 454:
		return BACnetPropertyIdentifier_CAR_LOAD, true
	case 455:
		return BACnetPropertyIdentifier_CAR_LOAD_UNITS, true
	case 456:
		return BACnetPropertyIdentifier_CAR_MODE, true
	case 457:
		return BACnetPropertyIdentifier_CAR_MOVING_DIRECTION, true
	case 458:
		return BACnetPropertyIdentifier_CAR_POSITION, true
	case 459:
		return BACnetPropertyIdentifier_ELEVATOR_GROUP, true
	case 46:
		return BACnetPropertyIdentifier_INACTIVE_TEXT, true
	case 460:
		return BACnetPropertyIdentifier_ENERGY_METER, true
	case 461:
		return BACnetPropertyIdentifier_ENERGY_METER_REF, true
	case 462:
		return BACnetPropertyIdentifier_ESCALATOR_MODE, true
	case 463:
		return BACnetPropertyIdentifier_FAULT_SIGNALS, true
	case 464:
		return BACnetPropertyIdentifier_FLOOR_TEXT, true
	case 465:
		return BACnetPropertyIdentifier_GROUP_ID, true
	case 467:
		return BACnetPropertyIdentifier_GROUP_MODE, true
	case 468:
		return BACnetPropertyIdentifier_HIGHER_DECK, true
	case 469:
		return BACnetPropertyIdentifier_INSTALLATION_ID, true
	case 47:
		return BACnetPropertyIdentifier_IN_PROCESS, true
	case 470:
		return BACnetPropertyIdentifier_LANDING_CALLS, true
	case 471:
		return BACnetPropertyIdentifier_LANDING_CALL_CONTROL, true
	case 472:
		return BACnetPropertyIdentifier_LANDING_DOOR_STATUS, true
	case 473:
		return BACnetPropertyIdentifier_LOWER_DECK, true
	case 474:
		return BACnetPropertyIdentifier_MACHINE_ROOM_ID, true
	case 475:
		return BACnetPropertyIdentifier_MAKING_CAR_CALL, true
	case 476:
		return BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR, true
	case 477:
		return BACnetPropertyIdentifier_OPERATION_DIRECTION, true
	case 478:
		return BACnetPropertyIdentifier_PASSENGER_ALARM, true
	case 479:
		return BACnetPropertyIdentifier_POWER_MODE, true
	case 48:
		return BACnetPropertyIdentifier_INSTANCE_OF, true
	case 480:
		return BACnetPropertyIdentifier_REGISTERED_CAR_CALL, true
	case 481:
		return BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS, true
	case 482:
		return BACnetPropertyIdentifier_PROTOCOL_LEVEL, true
	case 483:
		return BACnetPropertyIdentifier_REFERENCE_PORT, true
	case 484:
		return BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION, true
	case 485:
		return BACnetPropertyIdentifier_PROFILE_LOCATION, true
	case 486:
		return BACnetPropertyIdentifier_TAGS, true
	case 487:
		return BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES, true
	case 488:
		return BACnetPropertyIdentifier_SUBORDINATE_TAGS, true
	case 489:
		return BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS, true
	case 49:
		return BACnetPropertyIdentifier_INTEGRAL_CONSTANT, true
	case 490:
		return BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP, true
	case 491:
		return BACnetPropertyIdentifier_REPRESENTS, true
	case 5:
		return BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS, true
	case 50:
		return BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS, true
	case 52:
		return BACnetPropertyIdentifier_LIMIT_ENABLE, true
	case 53:
		return BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS, true
	case 54:
		return BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES, true
	case 56:
		return BACnetPropertyIdentifier_LOCAL_DATE, true
	case 57:
		return BACnetPropertyIdentifier_LOCAL_TIME, true
	case 58:
		return BACnetPropertyIdentifier_LOCATION, true
	case 59:
		return BACnetPropertyIdentifier_LOW_LIMIT, true
	case 6:
		return BACnetPropertyIdentifier_ALARM_VALUE, true
	case 60:
		return BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE, true
	case 61:
		return BACnetPropertyIdentifier_MAXIMUM_OUTPUT, true
	case 62:
		return BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED, true
	case 63:
		return BACnetPropertyIdentifier_MAX_INFO_FRAMES, true
	case 64:
		return BACnetPropertyIdentifier_MAX_MASTER, true
	case 65:
		return BACnetPropertyIdentifier_MAX_PRES_VALUE, true
	case 66:
		return BACnetPropertyIdentifier_MINIMUM_OFF_TIME, true
	case 67:
		return BACnetPropertyIdentifier_MINIMUM_ON_TIME, true
	case 68:
		return BACnetPropertyIdentifier_MINIMUM_OUTPUT, true
	case 69:
		return BACnetPropertyIdentifier_MIN_PRES_VALUE, true
	case 7:
		return BACnetPropertyIdentifier_ALARM_VALUES, true
	case 70:
		return BACnetPropertyIdentifier_MODEL_NAME, true
	case 71:
		return BACnetPropertyIdentifier_MODIFICATION_DATE, true
	case 72:
		return BACnetPropertyIdentifier_NOTIFY_TYPE, true
	case 73:
		return BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES, true
	case 74:
		return BACnetPropertyIdentifier_NUMBER_OF_STATES, true
	case 75:
		return BACnetPropertyIdentifier_OBJECT_IDENTIFIER, true
	case 76:
		return BACnetPropertyIdentifier_OBJECT_LIST, true
	case 77:
		return BACnetPropertyIdentifier_OBJECT_NAME, true
	case 78:
		return BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE, true
	case 79:
		return BACnetPropertyIdentifier_OBJECT_TYPE, true
	case 8:
		return BACnetPropertyIdentifier_ALL, true
	case 80:
		return BACnetPropertyIdentifier_OPTIONAL, true
	case 81:
		return BACnetPropertyIdentifier_OUT_OF_SERVICE, true
	case 82:
		return BACnetPropertyIdentifier_OUTPUT_UNITS, true
	case 83:
		return BACnetPropertyIdentifier_EVENT_PARAMETERS, true
	case 84:
		return BACnetPropertyIdentifier_POLARITY, true
	case 85:
		return BACnetPropertyIdentifier_PRESENT_VALUE, true
	case 86:
		return BACnetPropertyIdentifier_PRIORITY, true
	case 87:
		return BACnetPropertyIdentifier_PRIORITY_ARRAY, true
	case 88:
		return BACnetPropertyIdentifier_PRIORITY_FOR_WRITING, true
	case 89:
		return BACnetPropertyIdentifier_PROCESS_IDENTIFIER, true
	case 9:
		return BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL, true
	case 90:
		return BACnetPropertyIdentifier_PROGRAM_CHANGE, true
	case 91:
		return BACnetPropertyIdentifier_PROGRAM_LOCATION, true
	case 92:
		return BACnetPropertyIdentifier_PROGRAM_STATE, true
	case 93:
		return BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT, true
	case 94:
		return BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS, true
	case 95:
		return BACnetPropertyIdentifier_PROTOCOL_CONFORMANCE_CLASS, true
	case 96:
		return BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED, true
	case 97:
		return BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED, true
	case 98:
		return BACnetPropertyIdentifier_PROTOCOL_VERSION, true
	case 99:
		return BACnetPropertyIdentifier_READ_ONLY, true
	case 9999:
		return BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE, true
	}
	return 0, false
}

func BACnetPropertyIdentifierByName(value string) (enum BACnetPropertyIdentifier, ok bool) {
	switch value {
	case "ACKED_TRANSITIONS":
		return BACnetPropertyIdentifier_ACKED_TRANSITIONS, true
	case "ACK_REQUIRED":
		return BACnetPropertyIdentifier_ACK_REQUIRED, true
	case "APDU_SEGMENT_TIMEOUT":
		return BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT, true
	case "REASON_FOR_HALT":
		return BACnetPropertyIdentifier_REASON_FOR_HALT, true
	case "RECIPIENT_LIST":
		return BACnetPropertyIdentifier_RECIPIENT_LIST, true
	case "RELIABILITY":
		return BACnetPropertyIdentifier_RELIABILITY, true
	case "RELINQUISH_DEFAULT":
		return BACnetPropertyIdentifier_RELINQUISH_DEFAULT, true
	case "REQUIRED":
		return BACnetPropertyIdentifier_REQUIRED, true
	case "RESOLUTION":
		return BACnetPropertyIdentifier_RESOLUTION, true
	case "SEGMENTATION_SUPPORTED":
		return BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED, true
	case "SETPOINT":
		return BACnetPropertyIdentifier_SETPOINT, true
	case "SETPOINT_REFERENCE":
		return BACnetPropertyIdentifier_SETPOINT_REFERENCE, true
	case "APDU_TIMEOUT":
		return BACnetPropertyIdentifier_APDU_TIMEOUT, true
	case "STATE_TEXT":
		return BACnetPropertyIdentifier_STATE_TEXT, true
	case "STATUS_FLAGS":
		return BACnetPropertyIdentifier_STATUS_FLAGS, true
	case "SYSTEM_STATUS":
		return BACnetPropertyIdentifier_SYSTEM_STATUS, true
	case "TIME_DELAY":
		return BACnetPropertyIdentifier_TIME_DELAY, true
	case "TIME_OF_ACTIVE_TIME_RESET":
		return BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET, true
	case "TIME_OF_STATE_COUNT_RESET":
		return BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET, true
	case "TIME_SYNCHRONIZATION_RECIPIENTS":
		return BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS, true
	case "UNITS":
		return BACnetPropertyIdentifier_UNITS, true
	case "UPDATE_INTERVAL":
		return BACnetPropertyIdentifier_UPDATE_INTERVAL, true
	case "UTC_OFFSET":
		return BACnetPropertyIdentifier_UTC_OFFSET, true
	case "APPLICATION_SOFTWARE_VERSION":
		return BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION, true
	case "VENDOR_IDENTIFIER":
		return BACnetPropertyIdentifier_VENDOR_IDENTIFIER, true
	case "VENDOR_NAME":
		return BACnetPropertyIdentifier_VENDOR_NAME, true
	case "VT_CLASSES_SUPPORTED":
		return BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED, true
	case "WEEKLY_SCHEDULE":
		return BACnetPropertyIdentifier_WEEKLY_SCHEDULE, true
	case "ATTEMPTED_SAMPLES":
		return BACnetPropertyIdentifier_ATTEMPTED_SAMPLES, true
	case "AVERAGE_VALUE":
		return BACnetPropertyIdentifier_AVERAGE_VALUE, true
	case "BUFFER_SIZE":
		return BACnetPropertyIdentifier_BUFFER_SIZE, true
	case "CLIENT_COV_INCREMENT":
		return BACnetPropertyIdentifier_CLIENT_COV_INCREMENT, true
	case "COV_RESUBSCRIPTION_INTERVAL":
		return BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL, true
	case "ARCHIVE":
		return BACnetPropertyIdentifier_ARCHIVE, true
	case "EVENT_TIME_STAMPS":
		return BACnetPropertyIdentifier_EVENT_TIME_STAMPS, true
	case "LOG_BUFFER":
		return BACnetPropertyIdentifier_LOG_BUFFER, true
	case "LOG_DEVICE_OBJECT_PROPERTY":
		return BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY, true
	case "ENABLE":
		return BACnetPropertyIdentifier_ENABLE, true
	case "LOG_INTERVAL":
		return BACnetPropertyIdentifier_LOG_INTERVAL, true
	case "MAXIMUM_VALUE":
		return BACnetPropertyIdentifier_MAXIMUM_VALUE, true
	case "MINIMUM_VALUE":
		return BACnetPropertyIdentifier_MINIMUM_VALUE, true
	case "NOTIFICATION_THRESHOLD":
		return BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD, true
	case "PROTOCOL_REVISION":
		return BACnetPropertyIdentifier_PROTOCOL_REVISION, true
	case "BIAS":
		return BACnetPropertyIdentifier_BIAS, true
	case "RECORDS_SINCE_NOTIFICATION":
		return BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION, true
	case "RECORD_COUNT":
		return BACnetPropertyIdentifier_RECORD_COUNT, true
	case "START_TIME":
		return BACnetPropertyIdentifier_START_TIME, true
	case "STOP_TIME":
		return BACnetPropertyIdentifier_STOP_TIME, true
	case "STOP_WHEN_FULL":
		return BACnetPropertyIdentifier_STOP_WHEN_FULL, true
	case "TOTAL_RECORD_COUNT":
		return BACnetPropertyIdentifier_TOTAL_RECORD_COUNT, true
	case "VALID_SAMPLES":
		return BACnetPropertyIdentifier_VALID_SAMPLES, true
	case "WINDOW_INTERVAL":
		return BACnetPropertyIdentifier_WINDOW_INTERVAL, true
	case "WINDOW_SAMPLES":
		return BACnetPropertyIdentifier_WINDOW_SAMPLES, true
	case "MAXIMUM_VALUE_TIMESTAMP":
		return BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP, true
	case "CHANGE_OF_STATE_COUNT":
		return BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT, true
	case "MINIMUM_VALUE_TIMESTAMP":
		return BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP, true
	case "VARIANCE_VALUE":
		return BACnetPropertyIdentifier_VARIANCE_VALUE, true
	case "ACTIVE_COV_SUBSCRIPTIONS":
		return BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS, true
	case "BACKUP_FAILURE_TIMEOUT":
		return BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT, true
	case "CONFIGURATION_FILES":
		return BACnetPropertyIdentifier_CONFIGURATION_FILES, true
	case "DATABASE_REVISION":
		return BACnetPropertyIdentifier_DATABASE_REVISION, true
	case "DIRECT_READING":
		return BACnetPropertyIdentifier_DIRECT_READING, true
	case "LAST_RESTORE_TIME":
		return BACnetPropertyIdentifier_LAST_RESTORE_TIME, true
	case "MAINTENANCE_REQUIRED":
		return BACnetPropertyIdentifier_MAINTENANCE_REQUIRED, true
	case "MEMBER_OF":
		return BACnetPropertyIdentifier_MEMBER_OF, true
	case "CHANGE_OF_STATE_TIME":
		return BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME, true
	case "MODE":
		return BACnetPropertyIdentifier_MODE, true
	case "OPERATION_EXPECTED":
		return BACnetPropertyIdentifier_OPERATION_EXPECTED, true
	case "SETTING":
		return BACnetPropertyIdentifier_SETTING, true
	case "SILENCED":
		return BACnetPropertyIdentifier_SILENCED, true
	case "TRACKING_VALUE":
		return BACnetPropertyIdentifier_TRACKING_VALUE, true
	case "ZONE_MEMBERS":
		return BACnetPropertyIdentifier_ZONE_MEMBERS, true
	case "LIFE_SAFETY_ALARM_VALUES":
		return BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES, true
	case "MAX_SEGMENTS_ACCEPTED":
		return BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED, true
	case "PROFILE_NAME":
		return BACnetPropertyIdentifier_PROFILE_NAME, true
	case "AUTO_SLAVE_DISCOVERY":
		return BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY, true
	case "NOTIFICATION_CLASS":
		return BACnetPropertyIdentifier_NOTIFICATION_CLASS, true
	case "MANUAL_SLAVE_ADDRESS_BINDING":
		return BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING, true
	case "SLAVE_ADDRESS_BINDING":
		return BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING, true
	case "SLAVE_PROXY_ENABLE":
		return BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE, true
	case "LAST_NOTIFY_RECORD":
		return BACnetPropertyIdentifier_LAST_NOTIFY_RECORD, true
	case "SCHEDULE_DEFAULT":
		return BACnetPropertyIdentifier_SCHEDULE_DEFAULT, true
	case "ACCEPTED_MODES":
		return BACnetPropertyIdentifier_ACCEPTED_MODES, true
	case "ADJUST_VALUE":
		return BACnetPropertyIdentifier_ADJUST_VALUE, true
	case "COUNT":
		return BACnetPropertyIdentifier_COUNT, true
	case "COUNT_BEFORE_CHANGE":
		return BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE, true
	case "COUNT_CHANGE_TIME":
		return BACnetPropertyIdentifier_COUNT_CHANGE_TIME, true
	case "COV_PERIOD":
		return BACnetPropertyIdentifier_COV_PERIOD, true
	case "INPUT_REFERENCE":
		return BACnetPropertyIdentifier_INPUT_REFERENCE, true
	case "LIMIT_MONITORING_INTERVAL":
		return BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL, true
	case "LOGGING_OBJECT":
		return BACnetPropertyIdentifier_LOGGING_OBJECT, true
	case "LOGGING_RECORD":
		return BACnetPropertyIdentifier_LOGGING_RECORD, true
	case "PRESCALE":
		return BACnetPropertyIdentifier_PRESCALE, true
	case "PULSE_RATE":
		return BACnetPropertyIdentifier_PULSE_RATE, true
	case "SCALE":
		return BACnetPropertyIdentifier_SCALE, true
	case "SCALE_FACTOR":
		return BACnetPropertyIdentifier_SCALE_FACTOR, true
	case "UPDATE_TIME":
		return BACnetPropertyIdentifier_UPDATE_TIME, true
	case "CONTROLLED_VARIABLE_REFERENCE":
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE, true
	case "VALUE_BEFORE_CHANGE":
		return BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE, true
	case "VALUE_SET":
		return BACnetPropertyIdentifier_VALUE_SET, true
	case "VALUE_CHANGE_TIME":
		return BACnetPropertyIdentifier_VALUE_CHANGE_TIME, true
	case "ALIGN_INTERVALS":
		return BACnetPropertyIdentifier_ALIGN_INTERVALS, true
	case "INTERVAL_OFFSET":
		return BACnetPropertyIdentifier_INTERVAL_OFFSET, true
	case "LAST_RESTART_REASON":
		return BACnetPropertyIdentifier_LAST_RESTART_REASON, true
	case "LOGGING_TYPE":
		return BACnetPropertyIdentifier_LOGGING_TYPE, true
	case "ACTION":
		return BACnetPropertyIdentifier_ACTION, true
	case "CONTROLLED_VARIABLE_UNITS":
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS, true
	case "RESTART_NOTIFICATION_RECIPIENTS":
		return BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS, true
	case "TIME_OF_DEVICE_RESTART":
		return BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART, true
	case "TIME_SYNCHRONIZATION_INTERVAL":
		return BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL, true
	case "TRIGGER":
		return BACnetPropertyIdentifier_TRIGGER, true
	case "UTC_TIME_SYNCHRONIZATION_RECIPIENTS":
		return BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS, true
	case "NODE_SUBTYPE":
		return BACnetPropertyIdentifier_NODE_SUBTYPE, true
	case "NODE_TYPE":
		return BACnetPropertyIdentifier_NODE_TYPE, true
	case "STRUCTURED_OBJECT_LIST":
		return BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST, true
	case "CONTROLLED_VARIABLE_VALUE":
		return BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE, true
	case "SUBORDINATE_ANNOTATIONS":
		return BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS, true
	case "SUBORDINATE_LIST":
		return BACnetPropertyIdentifier_SUBORDINATE_LIST, true
	case "ACTUAL_SHED_LEVEL":
		return BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL, true
	case "DUTY_WINDOW":
		return BACnetPropertyIdentifier_DUTY_WINDOW, true
	case "EXPECTED_SHED_LEVEL":
		return BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL, true
	case "FULL_DUTY_BASELINE":
		return BACnetPropertyIdentifier_FULL_DUTY_BASELINE, true
	case "REQUESTED_SHED_LEVEL":
		return BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL, true
	case "SHED_DURATION":
		return BACnetPropertyIdentifier_SHED_DURATION, true
	case "COV_INCREMENT":
		return BACnetPropertyIdentifier_COV_INCREMENT, true
	case "SHED_LEVEL_DESCRIPTIONS":
		return BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS, true
	case "SHED_LEVELS":
		return BACnetPropertyIdentifier_SHED_LEVELS, true
	case "STATE_DESCRIPTION":
		return BACnetPropertyIdentifier_STATE_DESCRIPTION, true
	case "DOOR_ALARM_STATE":
		return BACnetPropertyIdentifier_DOOR_ALARM_STATE, true
	case "DOOR_EXTENDED_PULSE_TIME":
		return BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME, true
	case "DOOR_MEMBERS":
		return BACnetPropertyIdentifier_DOOR_MEMBERS, true
	case "DOOR_OPEN_TOO_LONG_TIME":
		return BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME, true
	case "DATE_LIST":
		return BACnetPropertyIdentifier_DATE_LIST, true
	case "DOOR_PULSE_TIME":
		return BACnetPropertyIdentifier_DOOR_PULSE_TIME, true
	case "DOOR_STATUS":
		return BACnetPropertyIdentifier_DOOR_STATUS, true
	case "DOOR_UNLOCK_DELAY_TIME":
		return BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME, true
	case "LOCK_STATUS":
		return BACnetPropertyIdentifier_LOCK_STATUS, true
	case "MASKED_ALARM_VALUES":
		return BACnetPropertyIdentifier_MASKED_ALARM_VALUES, true
	case "SECURED_STATUS":
		return BACnetPropertyIdentifier_SECURED_STATUS, true
	case "DAYLIGHT_SAVINGS_STATUS":
		return BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS, true
	case "ABSENTEE_LIMIT":
		return BACnetPropertyIdentifier_ABSENTEE_LIMIT, true
	case "ACCESS_ALARM_EVENTS":
		return BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS, true
	case "ACCESS_DOORS":
		return BACnetPropertyIdentifier_ACCESS_DOORS, true
	case "ACCESS_EVENT":
		return BACnetPropertyIdentifier_ACCESS_EVENT, true
	case "ACCESS_EVENT_AUTHENTICATION_FACTOR":
		return BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR, true
	case "ACCESS_EVENT_CREDENTIAL":
		return BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL, true
	case "DEADBAND":
		return BACnetPropertyIdentifier_DEADBAND, true
	case "ACCESS_EVENT_TIME":
		return BACnetPropertyIdentifier_ACCESS_EVENT_TIME, true
	case "ACCESS_TRANSACTION_EVENTS":
		return BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS, true
	case "ACCOMPANIMENT":
		return BACnetPropertyIdentifier_ACCOMPANIMENT, true
	case "ACCOMPANIMENT_TIME":
		return BACnetPropertyIdentifier_ACCOMPANIMENT_TIME, true
	case "ACTIVATION_TIME":
		return BACnetPropertyIdentifier_ACTIVATION_TIME, true
	case "ACTIVE_AUTHENTICATION_POLICY":
		return BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY, true
	case "ASSIGNED_ACCESS_RIGHTS":
		return BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS, true
	case "AUTHENTICATION_FACTORS":
		return BACnetPropertyIdentifier_AUTHENTICATION_FACTORS, true
	case "AUTHENTICATION_POLICY_LIST":
		return BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST, true
	case "AUTHENTICATION_POLICY_NAMES":
		return BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES, true
	case "DERIVATIVE_CONSTANT":
		return BACnetPropertyIdentifier_DERIVATIVE_CONSTANT, true
	case "AUTHENTICATION_STATUS":
		return BACnetPropertyIdentifier_AUTHENTICATION_STATUS, true
	case "AUTHORIZATION_MODE":
		return BACnetPropertyIdentifier_AUTHORIZATION_MODE, true
	case "BELONGS_TO":
		return BACnetPropertyIdentifier_BELONGS_TO, true
	case "CREDENTIAL_DISABLE":
		return BACnetPropertyIdentifier_CREDENTIAL_DISABLE, true
	case "CREDENTIAL_STATUS":
		return BACnetPropertyIdentifier_CREDENTIAL_STATUS, true
	case "CREDENTIALS":
		return BACnetPropertyIdentifier_CREDENTIALS, true
	case "CREDENTIALS_IN_ZONE":
		return BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE, true
	case "DAYS_REMAINING":
		return BACnetPropertyIdentifier_DAYS_REMAINING, true
	case "ENTRY_POINTS":
		return BACnetPropertyIdentifier_ENTRY_POINTS, true
	case "EXIT_POINTS":
		return BACnetPropertyIdentifier_EXIT_POINTS, true
	case "DERIVATIVE_CONSTANT_UNITS":
		return BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS, true
	case "EXPIRATION_TIME":
		return BACnetPropertyIdentifier_EXPIRATION_TIME, true
	case "EXTENDED_TIME_ENABLE":
		return BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE, true
	case "FAILED_ATTEMPT_EVENTS":
		return BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS, true
	case "FAILED_ATTEMPTS":
		return BACnetPropertyIdentifier_FAILED_ATTEMPTS, true
	case "FAILED_ATTEMPTS_TIME":
		return BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME, true
	case "LAST_ACCESS_EVENT":
		return BACnetPropertyIdentifier_LAST_ACCESS_EVENT, true
	case "LAST_ACCESS_POINT":
		return BACnetPropertyIdentifier_LAST_ACCESS_POINT, true
	case "LAST_CREDENTIAL_ADDED":
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED, true
	case "LAST_CREDENTIAL_ADDED_TIME":
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME, true
	case "LAST_CREDENTIAL_REMOVED":
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED, true
	case "DESCRIPTION":
		return BACnetPropertyIdentifier_DESCRIPTION, true
	case "LAST_CREDENTIAL_REMOVED_TIME":
		return BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME, true
	case "LAST_USE_TIME":
		return BACnetPropertyIdentifier_LAST_USE_TIME, true
	case "LOCKOUT":
		return BACnetPropertyIdentifier_LOCKOUT, true
	case "LOCKOUT_RELINQUISH_TIME":
		return BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME, true
	case "MAX_FAILED_ATTEMPTS":
		return BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS, true
	case "MEMBERS":
		return BACnetPropertyIdentifier_MEMBERS, true
	case "MUSTER_POINT":
		return BACnetPropertyIdentifier_MUSTER_POINT, true
	case "NEGATIVE_ACCESS_RULES":
		return BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES, true
	case "NUMBER_OF_AUTHENTICATION_POLICIES":
		return BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES, true
	case "DESCRIPTION_OF_HALT":
		return BACnetPropertyIdentifier_DESCRIPTION_OF_HALT, true
	case "OCCUPANCY_COUNT":
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT, true
	case "OCCUPANCY_COUNT_ADJUST":
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST, true
	case "OCCUPANCY_COUNT_ENABLE":
		return BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE, true
	case "OCCUPANCY_LOWER_LIMIT":
		return BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT, true
	case "OCCUPANCY_LOWER_LIMIT_ENFORCED":
		return BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED, true
	case "OCCUPANCY_STATE":
		return BACnetPropertyIdentifier_OCCUPANCY_STATE, true
	case "OCCUPANCY_UPPER_LIMIT":
		return BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT, true
	case "OCCUPANCY_UPPER_LIMIT_ENFORCED":
		return BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED, true
	case "ACTION_TEXT":
		return BACnetPropertyIdentifier_ACTION_TEXT, true
	case "DEVICE_ADDRESS_BINDING":
		return BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING, true
	case "PASSBACK_MODE":
		return BACnetPropertyIdentifier_PASSBACK_MODE, true
	case "PASSBACK_TIMEOUT":
		return BACnetPropertyIdentifier_PASSBACK_TIMEOUT, true
	case "POSITIVE_ACCESS_RULES":
		return BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES, true
	case "REASON_FOR_DISABLE":
		return BACnetPropertyIdentifier_REASON_FOR_DISABLE, true
	case "SUPPORTED_FORMATS":
		return BACnetPropertyIdentifier_SUPPORTED_FORMATS, true
	case "SUPPORTED_FORMAT_CLASSES":
		return BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES, true
	case "THREAT_AUTHORITY":
		return BACnetPropertyIdentifier_THREAT_AUTHORITY, true
	case "THREAT_LEVEL":
		return BACnetPropertyIdentifier_THREAT_LEVEL, true
	case "TRACE_FLAG":
		return BACnetPropertyIdentifier_TRACE_FLAG, true
	case "TRANSACTION_NOTIFICATION_CLASS":
		return BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS, true
	case "DEVICE_TYPE":
		return BACnetPropertyIdentifier_DEVICE_TYPE, true
	case "USER_EXTERNAL_IDENTIFIER":
		return BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER, true
	case "USER_INFORMATION_REFERENCE":
		return BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE, true
	case "USER_NAME":
		return BACnetPropertyIdentifier_USER_NAME, true
	case "USER_TYPE":
		return BACnetPropertyIdentifier_USER_TYPE, true
	case "USES_REMAINING":
		return BACnetPropertyIdentifier_USES_REMAINING, true
	case "EFFECTIVE_PERIOD":
		return BACnetPropertyIdentifier_EFFECTIVE_PERIOD, true
	case "ZONE_FROM":
		return BACnetPropertyIdentifier_ZONE_FROM, true
	case "ZONE_TO":
		return BACnetPropertyIdentifier_ZONE_TO, true
	case "ACCESS_EVENT_TAG":
		return BACnetPropertyIdentifier_ACCESS_EVENT_TAG, true
	case "GLOBAL_IDENTIFIER":
		return BACnetPropertyIdentifier_GLOBAL_IDENTIFIER, true
	case "VERIFICATION_TIME":
		return BACnetPropertyIdentifier_VERIFICATION_TIME, true
	case "BASE_DEVICE_SECURITY_POLICY":
		return BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY, true
	case "DISTRIBUTION_KEY_REVISION":
		return BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION, true
	case "DO_NOT_HIDE":
		return BACnetPropertyIdentifier_DO_NOT_HIDE, true
	case "ELAPSED_ACTIVE_TIME":
		return BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME, true
	case "KEY_SETS":
		return BACnetPropertyIdentifier_KEY_SETS, true
	case "LAST_KEY_SERVER":
		return BACnetPropertyIdentifier_LAST_KEY_SERVER, true
	case "NETWORK_ACCESS_SECURITY_POLICIES":
		return BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES, true
	case "PACKET_REORDER_TIME":
		return BACnetPropertyIdentifier_PACKET_REORDER_TIME, true
	case "SECURITY_PDU_TIMEOUT":
		return BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT, true
	case "SECURITY_TIME_WINDOW":
		return BACnetPropertyIdentifier_SECURITY_TIME_WINDOW, true
	case "SUPPORTED_SECURITY_ALGORITHMS":
		return BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS, true
	case "UPDATE_KEY_SET_TIMEOUT":
		return BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT, true
	case "BACKUP_AND_RESTORE_STATE":
		return BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE, true
	case "BACKUP_PREPARATION_TIME":
		return BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME, true
	case "ERROR_LIMIT":
		return BACnetPropertyIdentifier_ERROR_LIMIT, true
	case "RESTORE_COMPLETION_TIME":
		return BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME, true
	case "RESTORE_PREPARATION_TIME":
		return BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME, true
	case "BIT_MASK":
		return BACnetPropertyIdentifier_BIT_MASK, true
	case "BIT_TEXT":
		return BACnetPropertyIdentifier_BIT_TEXT, true
	case "IS_UTC":
		return BACnetPropertyIdentifier_IS_UTC, true
	case "GROUP_MEMBERS":
		return BACnetPropertyIdentifier_GROUP_MEMBERS, true
	case "GROUP_MEMBER_NAMES":
		return BACnetPropertyIdentifier_GROUP_MEMBER_NAMES, true
	case "MEMBER_STATUS_FLAGS":
		return BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS, true
	case "REQUESTED_UPDATE_INTERVAL":
		return BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL, true
	case "COVU_PERIOD":
		return BACnetPropertyIdentifier_COVU_PERIOD, true
	case "EVENT_ENABLE":
		return BACnetPropertyIdentifier_EVENT_ENABLE, true
	case "COVU_RECIPIENTS":
		return BACnetPropertyIdentifier_COVU_RECIPIENTS, true
	case "EVENT_MESSAGE_TEXTS":
		return BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS, true
	case "EVENT_MESSAGE_TEXTS_CONFIG":
		return BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG, true
	case "EVENT_DETECTION_ENABLE":
		return BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE, true
	case "EVENT_ALGORITHM_INHIBIT":
		return BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT, true
	case "EVENT_ALGORITHM_INHIBIT_REF":
		return BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF, true
	case "TIME_DELAY_NORMAL":
		return BACnetPropertyIdentifier_TIME_DELAY_NORMAL, true
	case "RELIABILITY_EVALUATION_INHIBIT":
		return BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT, true
	case "FAULT_PARAMETERS":
		return BACnetPropertyIdentifier_FAULT_PARAMETERS, true
	case "FAULT_TYPE":
		return BACnetPropertyIdentifier_FAULT_TYPE, true
	case "EVENT_STATE":
		return BACnetPropertyIdentifier_EVENT_STATE, true
	case "LOCAL_FORWARDING_ONLY":
		return BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY, true
	case "PROCESS_IDENTIFIER_FILTER":
		return BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER, true
	case "SUBSCRIBED_RECIPIENTS":
		return BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS, true
	case "PORT_FILTER":
		return BACnetPropertyIdentifier_PORT_FILTER, true
	case "AUTHORIZATION_EXEMPTIONS":
		return BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS, true
	case "ALLOW_GROUP_DELAY_INHIBIT":
		return BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT, true
	case "CHANNEL_NUMBER":
		return BACnetPropertyIdentifier_CHANNEL_NUMBER, true
	case "CONTROL_GROUPS":
		return BACnetPropertyIdentifier_CONTROL_GROUPS, true
	case "EXECUTION_DELAY":
		return BACnetPropertyIdentifier_EXECUTION_DELAY, true
	case "LAST_PRIORITY":
		return BACnetPropertyIdentifier_LAST_PRIORITY, true
	case "EVENT_TYPE":
		return BACnetPropertyIdentifier_EVENT_TYPE, true
	case "WRITE_STATUS":
		return BACnetPropertyIdentifier_WRITE_STATUS, true
	case "PROPERTY_LIST":
		return BACnetPropertyIdentifier_PROPERTY_LIST, true
	case "SERIAL_NUMBER":
		return BACnetPropertyIdentifier_SERIAL_NUMBER, true
	case "BLINK_WARN_ENABLE":
		return BACnetPropertyIdentifier_BLINK_WARN_ENABLE, true
	case "DEFAULT_FADE_TIME":
		return BACnetPropertyIdentifier_DEFAULT_FADE_TIME, true
	case "DEFAULT_RAMP_RATE":
		return BACnetPropertyIdentifier_DEFAULT_RAMP_RATE, true
	case "DEFAULT_STEP_INCREMENT":
		return BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT, true
	case "EGRESS_TIME":
		return BACnetPropertyIdentifier_EGRESS_TIME, true
	case "IN_PROGRESS":
		return BACnetPropertyIdentifier_IN_PROGRESS, true
	case "INSTANTANEOUS_POWER":
		return BACnetPropertyIdentifier_INSTANTANEOUS_POWER, true
	case "EXCEPTION_SCHEDULE":
		return BACnetPropertyIdentifier_EXCEPTION_SCHEDULE, true
	case "LIGHTING_COMMAND":
		return BACnetPropertyIdentifier_LIGHTING_COMMAND, true
	case "LIGHTING_COMMAND_DEFAULT_PRIORITY":
		return BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY, true
	case "MAX_ACTUAL_VALUE":
		return BACnetPropertyIdentifier_MAX_ACTUAL_VALUE, true
	case "MIN_ACTUAL_VALUE":
		return BACnetPropertyIdentifier_MIN_ACTUAL_VALUE, true
	case "POWER":
		return BACnetPropertyIdentifier_POWER, true
	case "TRANSITION":
		return BACnetPropertyIdentifier_TRANSITION, true
	case "EGRESS_ACTIVE":
		return BACnetPropertyIdentifier_EGRESS_ACTIVE, true
	case "INTERFACE_VALUE":
		return BACnetPropertyIdentifier_INTERFACE_VALUE, true
	case "FAULT_HIGH_LIMIT":
		return BACnetPropertyIdentifier_FAULT_HIGH_LIMIT, true
	case "FAULT_LOW_LIMIT":
		return BACnetPropertyIdentifier_FAULT_LOW_LIMIT, true
	case "FAULT_VALUES":
		return BACnetPropertyIdentifier_FAULT_VALUES, true
	case "LOW_DIFF_LIMIT":
		return BACnetPropertyIdentifier_LOW_DIFF_LIMIT, true
	case "STRIKE_COUNT":
		return BACnetPropertyIdentifier_STRIKE_COUNT, true
	case "TIME_OF_STRIKE_COUNT_RESET":
		return BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET, true
	case "DEFAULT_TIMEOUT":
		return BACnetPropertyIdentifier_DEFAULT_TIMEOUT, true
	case "INITIAL_TIMEOUT":
		return BACnetPropertyIdentifier_INITIAL_TIMEOUT, true
	case "LAST_STATE_CHANGE":
		return BACnetPropertyIdentifier_LAST_STATE_CHANGE, true
	case "STATE_CHANGE_VALUES":
		return BACnetPropertyIdentifier_STATE_CHANGE_VALUES, true
	case "TIMER_RUNNING":
		return BACnetPropertyIdentifier_TIMER_RUNNING, true
	case "TIMER_STATE":
		return BACnetPropertyIdentifier_TIMER_STATE, true
	case "APDU_LENGTH":
		return BACnetPropertyIdentifier_APDU_LENGTH, true
	case "ACTIVE_TEXT":
		return BACnetPropertyIdentifier_ACTIVE_TEXT, true
	case "FEEDBACK_VALUE":
		return BACnetPropertyIdentifier_FEEDBACK_VALUE, true
	case "IP_ADDRESS":
		return BACnetPropertyIdentifier_IP_ADDRESS, true
	case "IP_DEFAULT_GATEWAY":
		return BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY, true
	case "IP_DHCP_ENABLE":
		return BACnetPropertyIdentifier_IP_DHCP_ENABLE, true
	case "IP_DHCP_LEASE_TIME":
		return BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME, true
	case "IP_DHCP_LEASE_TIME_REMAINING":
		return BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING, true
	case "IP_DHCP_SERVER":
		return BACnetPropertyIdentifier_IP_DHCP_SERVER, true
	case "IP_DNS_SERVER":
		return BACnetPropertyIdentifier_IP_DNS_SERVER, true
	case "BACNET_IP_GLOBAL_ADDRESS":
		return BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS, true
	case "BACNET_IP_MODE":
		return BACnetPropertyIdentifier_BACNET_IP_MODE, true
	case "BACNET_IP_MULTICAST_ADDRESS":
		return BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS, true
	case "FILE_ACCESS_METHOD":
		return BACnetPropertyIdentifier_FILE_ACCESS_METHOD, true
	case "BACNET_IP_NAT_TRAVERSAL":
		return BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL, true
	case "IP_SUBNET_MASK":
		return BACnetPropertyIdentifier_IP_SUBNET_MASK, true
	case "BACNET_IP_UDP_PORT":
		return BACnetPropertyIdentifier_BACNET_IP_UDP_PORT, true
	case "BBMD_ACCEPT_FD_REGISTRATIONS":
		return BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS, true
	case "BBMD_BROADCAST_DISTRIBUTION_TABLE":
		return BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE, true
	case "BBMD_FOREIGN_DEVICE_TABLE":
		return BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE, true
	case "CHANGES_PENDING":
		return BACnetPropertyIdentifier_CHANGES_PENDING, true
	case "COMMAND":
		return BACnetPropertyIdentifier_COMMAND, true
	case "FD_BBMD_ADDRESS":
		return BACnetPropertyIdentifier_FD_BBMD_ADDRESS, true
	case "FD_SUBSCRIPTION_LIFETIME":
		return BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME, true
	case "FILE_SIZE":
		return BACnetPropertyIdentifier_FILE_SIZE, true
	case "LINK_SPEED":
		return BACnetPropertyIdentifier_LINK_SPEED, true
	case "LINK_SPEEDS":
		return BACnetPropertyIdentifier_LINK_SPEEDS, true
	case "LINK_SPEED_AUTONEGOTIATE":
		return BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE, true
	case "MAC_ADDRESS":
		return BACnetPropertyIdentifier_MAC_ADDRESS, true
	case "NETWORK_INTERFACE_NAME":
		return BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME, true
	case "NETWORK_NUMBER":
		return BACnetPropertyIdentifier_NETWORK_NUMBER, true
	case "NETWORK_NUMBER_QUALITY":
		return BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY, true
	case "NETWORK_TYPE":
		return BACnetPropertyIdentifier_NETWORK_TYPE, true
	case "ROUTING_TABLE":
		return BACnetPropertyIdentifier_ROUTING_TABLE, true
	case "VIRTUAL_MAC_ADDRESS_TABLE":
		return BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE, true
	case "FILE_TYPE":
		return BACnetPropertyIdentifier_FILE_TYPE, true
	case "COMMAND_TIME_ARRAY":
		return BACnetPropertyIdentifier_COMMAND_TIME_ARRAY, true
	case "CURRENT_COMMAND_PRIORITY":
		return BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY, true
	case "LAST_COMMAND_TIME":
		return BACnetPropertyIdentifier_LAST_COMMAND_TIME, true
	case "VALUE_SOURCE":
		return BACnetPropertyIdentifier_VALUE_SOURCE, true
	case "VALUE_SOURCE_ARRAY":
		return BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY, true
	case "BACNET_IPV6_MODE":
		return BACnetPropertyIdentifier_BACNET_IPV6_MODE, true
	case "IPV6_ADDRESS":
		return BACnetPropertyIdentifier_IPV6_ADDRESS, true
	case "IPV6_PREFIX_LENGTH":
		return BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH, true
	case "BACNET_IPV6_UDP_PORT":
		return BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT, true
	case "IPV6_DEFAULT_GATEWAY":
		return BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY, true
	case "FIRMWARE_REVISION":
		return BACnetPropertyIdentifier_FIRMWARE_REVISION, true
	case "BACNET_IPV6_MULTICAST_ADDRESS":
		return BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS, true
	case "IPV6_DNS_SERVER":
		return BACnetPropertyIdentifier_IPV6_DNS_SERVER, true
	case "IPV6_AUTO_ADDRESSING_ENABLE":
		return BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE, true
	case "IPV6_DHCP_LEASE_TIME":
		return BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME, true
	case "IPV6_DHCP_LEASE_TIME_REMAINING":
		return BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING, true
	case "IPV6_DHCP_SERVER":
		return BACnetPropertyIdentifier_IPV6_DHCP_SERVER, true
	case "IPV6_ZONE_INDEX":
		return BACnetPropertyIdentifier_IPV6_ZONE_INDEX, true
	case "ASSIGNED_LANDING_CALLS":
		return BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS, true
	case "CAR_ASSIGNED_DIRECTION":
		return BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION, true
	case "CAR_DOOR_COMMAND":
		return BACnetPropertyIdentifier_CAR_DOOR_COMMAND, true
	case "HIGH_LIMIT":
		return BACnetPropertyIdentifier_HIGH_LIMIT, true
	case "CAR_DOOR_STATUS":
		return BACnetPropertyIdentifier_CAR_DOOR_STATUS, true
	case "CAR_DOOR_TEXT":
		return BACnetPropertyIdentifier_CAR_DOOR_TEXT, true
	case "CAR_DOOR_ZONE":
		return BACnetPropertyIdentifier_CAR_DOOR_ZONE, true
	case "CAR_DRIVE_STATUS":
		return BACnetPropertyIdentifier_CAR_DRIVE_STATUS, true
	case "CAR_LOAD":
		return BACnetPropertyIdentifier_CAR_LOAD, true
	case "CAR_LOAD_UNITS":
		return BACnetPropertyIdentifier_CAR_LOAD_UNITS, true
	case "CAR_MODE":
		return BACnetPropertyIdentifier_CAR_MODE, true
	case "CAR_MOVING_DIRECTION":
		return BACnetPropertyIdentifier_CAR_MOVING_DIRECTION, true
	case "CAR_POSITION":
		return BACnetPropertyIdentifier_CAR_POSITION, true
	case "ELEVATOR_GROUP":
		return BACnetPropertyIdentifier_ELEVATOR_GROUP, true
	case "INACTIVE_TEXT":
		return BACnetPropertyIdentifier_INACTIVE_TEXT, true
	case "ENERGY_METER":
		return BACnetPropertyIdentifier_ENERGY_METER, true
	case "ENERGY_METER_REF":
		return BACnetPropertyIdentifier_ENERGY_METER_REF, true
	case "ESCALATOR_MODE":
		return BACnetPropertyIdentifier_ESCALATOR_MODE, true
	case "FAULT_SIGNALS":
		return BACnetPropertyIdentifier_FAULT_SIGNALS, true
	case "FLOOR_TEXT":
		return BACnetPropertyIdentifier_FLOOR_TEXT, true
	case "GROUP_ID":
		return BACnetPropertyIdentifier_GROUP_ID, true
	case "GROUP_MODE":
		return BACnetPropertyIdentifier_GROUP_MODE, true
	case "HIGHER_DECK":
		return BACnetPropertyIdentifier_HIGHER_DECK, true
	case "INSTALLATION_ID":
		return BACnetPropertyIdentifier_INSTALLATION_ID, true
	case "IN_PROCESS":
		return BACnetPropertyIdentifier_IN_PROCESS, true
	case "LANDING_CALLS":
		return BACnetPropertyIdentifier_LANDING_CALLS, true
	case "LANDING_CALL_CONTROL":
		return BACnetPropertyIdentifier_LANDING_CALL_CONTROL, true
	case "LANDING_DOOR_STATUS":
		return BACnetPropertyIdentifier_LANDING_DOOR_STATUS, true
	case "LOWER_DECK":
		return BACnetPropertyIdentifier_LOWER_DECK, true
	case "MACHINE_ROOM_ID":
		return BACnetPropertyIdentifier_MACHINE_ROOM_ID, true
	case "MAKING_CAR_CALL":
		return BACnetPropertyIdentifier_MAKING_CAR_CALL, true
	case "NEXT_STOPPING_FLOOR":
		return BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR, true
	case "OPERATION_DIRECTION":
		return BACnetPropertyIdentifier_OPERATION_DIRECTION, true
	case "PASSENGER_ALARM":
		return BACnetPropertyIdentifier_PASSENGER_ALARM, true
	case "POWER_MODE":
		return BACnetPropertyIdentifier_POWER_MODE, true
	case "INSTANCE_OF":
		return BACnetPropertyIdentifier_INSTANCE_OF, true
	case "REGISTERED_CAR_CALL":
		return BACnetPropertyIdentifier_REGISTERED_CAR_CALL, true
	case "ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS":
		return BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS, true
	case "PROTOCOL_LEVEL":
		return BACnetPropertyIdentifier_PROTOCOL_LEVEL, true
	case "REFERENCE_PORT":
		return BACnetPropertyIdentifier_REFERENCE_PORT, true
	case "DEPLOYED_PROFILE_LOCATION":
		return BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION, true
	case "PROFILE_LOCATION":
		return BACnetPropertyIdentifier_PROFILE_LOCATION, true
	case "TAGS":
		return BACnetPropertyIdentifier_TAGS, true
	case "SUBORDINATE_NODE_TYPES":
		return BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES, true
	case "SUBORDINATE_TAGS":
		return BACnetPropertyIdentifier_SUBORDINATE_TAGS, true
	case "SUBORDINATE_RELATIONSHIPS":
		return BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS, true
	case "INTEGRAL_CONSTANT":
		return BACnetPropertyIdentifier_INTEGRAL_CONSTANT, true
	case "DEFAULT_SUBORDINATE_RELATIONSHIP":
		return BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP, true
	case "REPRESENTS":
		return BACnetPropertyIdentifier_REPRESENTS, true
	case "ACTIVE_VT_SESSIONS":
		return BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS, true
	case "INTEGRAL_CONSTANT_UNITS":
		return BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS, true
	case "LIMIT_ENABLE":
		return BACnetPropertyIdentifier_LIMIT_ENABLE, true
	case "LIST_OF_GROUP_MEMBERS":
		return BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS, true
	case "LIST_OF_OBJECT_PROPERTY_REFERENCES":
		return BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES, true
	case "LOCAL_DATE":
		return BACnetPropertyIdentifier_LOCAL_DATE, true
	case "LOCAL_TIME":
		return BACnetPropertyIdentifier_LOCAL_TIME, true
	case "LOCATION":
		return BACnetPropertyIdentifier_LOCATION, true
	case "LOW_LIMIT":
		return BACnetPropertyIdentifier_LOW_LIMIT, true
	case "ALARM_VALUE":
		return BACnetPropertyIdentifier_ALARM_VALUE, true
	case "MANIPULATED_VARIABLE_REFERENCE":
		return BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE, true
	case "MAXIMUM_OUTPUT":
		return BACnetPropertyIdentifier_MAXIMUM_OUTPUT, true
	case "MAX_APDU_LENGTH_ACCEPTED":
		return BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED, true
	case "MAX_INFO_FRAMES":
		return BACnetPropertyIdentifier_MAX_INFO_FRAMES, true
	case "MAX_MASTER":
		return BACnetPropertyIdentifier_MAX_MASTER, true
	case "MAX_PRES_VALUE":
		return BACnetPropertyIdentifier_MAX_PRES_VALUE, true
	case "MINIMUM_OFF_TIME":
		return BACnetPropertyIdentifier_MINIMUM_OFF_TIME, true
	case "MINIMUM_ON_TIME":
		return BACnetPropertyIdentifier_MINIMUM_ON_TIME, true
	case "MINIMUM_OUTPUT":
		return BACnetPropertyIdentifier_MINIMUM_OUTPUT, true
	case "MIN_PRES_VALUE":
		return BACnetPropertyIdentifier_MIN_PRES_VALUE, true
	case "ALARM_VALUES":
		return BACnetPropertyIdentifier_ALARM_VALUES, true
	case "MODEL_NAME":
		return BACnetPropertyIdentifier_MODEL_NAME, true
	case "MODIFICATION_DATE":
		return BACnetPropertyIdentifier_MODIFICATION_DATE, true
	case "NOTIFY_TYPE":
		return BACnetPropertyIdentifier_NOTIFY_TYPE, true
	case "NUMBER_OF_APDU_RETRIES":
		return BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES, true
	case "NUMBER_OF_STATES":
		return BACnetPropertyIdentifier_NUMBER_OF_STATES, true
	case "OBJECT_IDENTIFIER":
		return BACnetPropertyIdentifier_OBJECT_IDENTIFIER, true
	case "OBJECT_LIST":
		return BACnetPropertyIdentifier_OBJECT_LIST, true
	case "OBJECT_NAME":
		return BACnetPropertyIdentifier_OBJECT_NAME, true
	case "OBJECT_PROPERTY_REFERENCE":
		return BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE, true
	case "OBJECT_TYPE":
		return BACnetPropertyIdentifier_OBJECT_TYPE, true
	case "ALL":
		return BACnetPropertyIdentifier_ALL, true
	case "OPTIONAL":
		return BACnetPropertyIdentifier_OPTIONAL, true
	case "OUT_OF_SERVICE":
		return BACnetPropertyIdentifier_OUT_OF_SERVICE, true
	case "OUTPUT_UNITS":
		return BACnetPropertyIdentifier_OUTPUT_UNITS, true
	case "EVENT_PARAMETERS":
		return BACnetPropertyIdentifier_EVENT_PARAMETERS, true
	case "POLARITY":
		return BACnetPropertyIdentifier_POLARITY, true
	case "PRESENT_VALUE":
		return BACnetPropertyIdentifier_PRESENT_VALUE, true
	case "PRIORITY":
		return BACnetPropertyIdentifier_PRIORITY, true
	case "PRIORITY_ARRAY":
		return BACnetPropertyIdentifier_PRIORITY_ARRAY, true
	case "PRIORITY_FOR_WRITING":
		return BACnetPropertyIdentifier_PRIORITY_FOR_WRITING, true
	case "PROCESS_IDENTIFIER":
		return BACnetPropertyIdentifier_PROCESS_IDENTIFIER, true
	case "ALL_WRITES_SUCCESSFUL":
		return BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL, true
	case "PROGRAM_CHANGE":
		return BACnetPropertyIdentifier_PROGRAM_CHANGE, true
	case "PROGRAM_LOCATION":
		return BACnetPropertyIdentifier_PROGRAM_LOCATION, true
	case "PROGRAM_STATE":
		return BACnetPropertyIdentifier_PROGRAM_STATE, true
	case "PROPORTIONAL_CONSTANT":
		return BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT, true
	case "PROPORTIONAL_CONSTANT_UNITS":
		return BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS, true
	case "PROTOCOL_CONFORMANCE_CLASS":
		return BACnetPropertyIdentifier_PROTOCOL_CONFORMANCE_CLASS, true
	case "PROTOCOL_OBJECT_TYPES_SUPPORTED":
		return BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED, true
	case "PROTOCOL_SERVICES_SUPPORTED":
		return BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED, true
	case "PROTOCOL_VERSION":
		return BACnetPropertyIdentifier_PROTOCOL_VERSION, true
	case "READ_ONLY":
		return BACnetPropertyIdentifier_READ_ONLY, true
	case "VENDOR_PROPRIETARY_VALUE":
		return BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE, true
	}
	return 0, false
}

func BACnetPropertyIdentifierKnows(value uint32) bool {
	for _, typeValue := range BACnetPropertyIdentifierValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetPropertyIdentifier(structType any) BACnetPropertyIdentifier {
	castFunc := func(typ any) BACnetPropertyIdentifier {
		if sBACnetPropertyIdentifier, ok := typ.(BACnetPropertyIdentifier); ok {
			return sBACnetPropertyIdentifier
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetPropertyIdentifier) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m BACnetPropertyIdentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetPropertyIdentifierParse(ctx context.Context, theBytes []byte) (BACnetPropertyIdentifier, error) {
	return BACnetPropertyIdentifierParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetPropertyIdentifierParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPropertyIdentifier, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("BACnetPropertyIdentifier", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetPropertyIdentifier")
	}
	if enum, ok := BACnetPropertyIdentifierByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetPropertyIdentifier")
		return BACnetPropertyIdentifier(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetPropertyIdentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetPropertyIdentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("BACnetPropertyIdentifier", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetPropertyIdentifier) PLC4XEnumName() string {
	switch e {
	case BACnetPropertyIdentifier_ACKED_TRANSITIONS:
		return "ACKED_TRANSITIONS"
	case BACnetPropertyIdentifier_ACK_REQUIRED:
		return "ACK_REQUIRED"
	case BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT:
		return "APDU_SEGMENT_TIMEOUT"
	case BACnetPropertyIdentifier_REASON_FOR_HALT:
		return "REASON_FOR_HALT"
	case BACnetPropertyIdentifier_RECIPIENT_LIST:
		return "RECIPIENT_LIST"
	case BACnetPropertyIdentifier_RELIABILITY:
		return "RELIABILITY"
	case BACnetPropertyIdentifier_RELINQUISH_DEFAULT:
		return "RELINQUISH_DEFAULT"
	case BACnetPropertyIdentifier_REQUIRED:
		return "REQUIRED"
	case BACnetPropertyIdentifier_RESOLUTION:
		return "RESOLUTION"
	case BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED:
		return "SEGMENTATION_SUPPORTED"
	case BACnetPropertyIdentifier_SETPOINT:
		return "SETPOINT"
	case BACnetPropertyIdentifier_SETPOINT_REFERENCE:
		return "SETPOINT_REFERENCE"
	case BACnetPropertyIdentifier_APDU_TIMEOUT:
		return "APDU_TIMEOUT"
	case BACnetPropertyIdentifier_STATE_TEXT:
		return "STATE_TEXT"
	case BACnetPropertyIdentifier_STATUS_FLAGS:
		return "STATUS_FLAGS"
	case BACnetPropertyIdentifier_SYSTEM_STATUS:
		return "SYSTEM_STATUS"
	case BACnetPropertyIdentifier_TIME_DELAY:
		return "TIME_DELAY"
	case BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET:
		return "TIME_OF_ACTIVE_TIME_RESET"
	case BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET:
		return "TIME_OF_STATE_COUNT_RESET"
	case BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS:
		return "TIME_SYNCHRONIZATION_RECIPIENTS"
	case BACnetPropertyIdentifier_UNITS:
		return "UNITS"
	case BACnetPropertyIdentifier_UPDATE_INTERVAL:
		return "UPDATE_INTERVAL"
	case BACnetPropertyIdentifier_UTC_OFFSET:
		return "UTC_OFFSET"
	case BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION:
		return "APPLICATION_SOFTWARE_VERSION"
	case BACnetPropertyIdentifier_VENDOR_IDENTIFIER:
		return "VENDOR_IDENTIFIER"
	case BACnetPropertyIdentifier_VENDOR_NAME:
		return "VENDOR_NAME"
	case BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED:
		return "VT_CLASSES_SUPPORTED"
	case BACnetPropertyIdentifier_WEEKLY_SCHEDULE:
		return "WEEKLY_SCHEDULE"
	case BACnetPropertyIdentifier_ATTEMPTED_SAMPLES:
		return "ATTEMPTED_SAMPLES"
	case BACnetPropertyIdentifier_AVERAGE_VALUE:
		return "AVERAGE_VALUE"
	case BACnetPropertyIdentifier_BUFFER_SIZE:
		return "BUFFER_SIZE"
	case BACnetPropertyIdentifier_CLIENT_COV_INCREMENT:
		return "CLIENT_COV_INCREMENT"
	case BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL:
		return "COV_RESUBSCRIPTION_INTERVAL"
	case BACnetPropertyIdentifier_ARCHIVE:
		return "ARCHIVE"
	case BACnetPropertyIdentifier_EVENT_TIME_STAMPS:
		return "EVENT_TIME_STAMPS"
	case BACnetPropertyIdentifier_LOG_BUFFER:
		return "LOG_BUFFER"
	case BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY:
		return "LOG_DEVICE_OBJECT_PROPERTY"
	case BACnetPropertyIdentifier_ENABLE:
		return "ENABLE"
	case BACnetPropertyIdentifier_LOG_INTERVAL:
		return "LOG_INTERVAL"
	case BACnetPropertyIdentifier_MAXIMUM_VALUE:
		return "MAXIMUM_VALUE"
	case BACnetPropertyIdentifier_MINIMUM_VALUE:
		return "MINIMUM_VALUE"
	case BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD:
		return "NOTIFICATION_THRESHOLD"
	case BACnetPropertyIdentifier_PROTOCOL_REVISION:
		return "PROTOCOL_REVISION"
	case BACnetPropertyIdentifier_BIAS:
		return "BIAS"
	case BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION:
		return "RECORDS_SINCE_NOTIFICATION"
	case BACnetPropertyIdentifier_RECORD_COUNT:
		return "RECORD_COUNT"
	case BACnetPropertyIdentifier_START_TIME:
		return "START_TIME"
	case BACnetPropertyIdentifier_STOP_TIME:
		return "STOP_TIME"
	case BACnetPropertyIdentifier_STOP_WHEN_FULL:
		return "STOP_WHEN_FULL"
	case BACnetPropertyIdentifier_TOTAL_RECORD_COUNT:
		return "TOTAL_RECORD_COUNT"
	case BACnetPropertyIdentifier_VALID_SAMPLES:
		return "VALID_SAMPLES"
	case BACnetPropertyIdentifier_WINDOW_INTERVAL:
		return "WINDOW_INTERVAL"
	case BACnetPropertyIdentifier_WINDOW_SAMPLES:
		return "WINDOW_SAMPLES"
	case BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP:
		return "MAXIMUM_VALUE_TIMESTAMP"
	case BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT:
		return "CHANGE_OF_STATE_COUNT"
	case BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP:
		return "MINIMUM_VALUE_TIMESTAMP"
	case BACnetPropertyIdentifier_VARIANCE_VALUE:
		return "VARIANCE_VALUE"
	case BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS:
		return "ACTIVE_COV_SUBSCRIPTIONS"
	case BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT:
		return "BACKUP_FAILURE_TIMEOUT"
	case BACnetPropertyIdentifier_CONFIGURATION_FILES:
		return "CONFIGURATION_FILES"
	case BACnetPropertyIdentifier_DATABASE_REVISION:
		return "DATABASE_REVISION"
	case BACnetPropertyIdentifier_DIRECT_READING:
		return "DIRECT_READING"
	case BACnetPropertyIdentifier_LAST_RESTORE_TIME:
		return "LAST_RESTORE_TIME"
	case BACnetPropertyIdentifier_MAINTENANCE_REQUIRED:
		return "MAINTENANCE_REQUIRED"
	case BACnetPropertyIdentifier_MEMBER_OF:
		return "MEMBER_OF"
	case BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME:
		return "CHANGE_OF_STATE_TIME"
	case BACnetPropertyIdentifier_MODE:
		return "MODE"
	case BACnetPropertyIdentifier_OPERATION_EXPECTED:
		return "OPERATION_EXPECTED"
	case BACnetPropertyIdentifier_SETTING:
		return "SETTING"
	case BACnetPropertyIdentifier_SILENCED:
		return "SILENCED"
	case BACnetPropertyIdentifier_TRACKING_VALUE:
		return "TRACKING_VALUE"
	case BACnetPropertyIdentifier_ZONE_MEMBERS:
		return "ZONE_MEMBERS"
	case BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES:
		return "LIFE_SAFETY_ALARM_VALUES"
	case BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED:
		return "MAX_SEGMENTS_ACCEPTED"
	case BACnetPropertyIdentifier_PROFILE_NAME:
		return "PROFILE_NAME"
	case BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY:
		return "AUTO_SLAVE_DISCOVERY"
	case BACnetPropertyIdentifier_NOTIFICATION_CLASS:
		return "NOTIFICATION_CLASS"
	case BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING:
		return "MANUAL_SLAVE_ADDRESS_BINDING"
	case BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING:
		return "SLAVE_ADDRESS_BINDING"
	case BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE:
		return "SLAVE_PROXY_ENABLE"
	case BACnetPropertyIdentifier_LAST_NOTIFY_RECORD:
		return "LAST_NOTIFY_RECORD"
	case BACnetPropertyIdentifier_SCHEDULE_DEFAULT:
		return "SCHEDULE_DEFAULT"
	case BACnetPropertyIdentifier_ACCEPTED_MODES:
		return "ACCEPTED_MODES"
	case BACnetPropertyIdentifier_ADJUST_VALUE:
		return "ADJUST_VALUE"
	case BACnetPropertyIdentifier_COUNT:
		return "COUNT"
	case BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE:
		return "COUNT_BEFORE_CHANGE"
	case BACnetPropertyIdentifier_COUNT_CHANGE_TIME:
		return "COUNT_CHANGE_TIME"
	case BACnetPropertyIdentifier_COV_PERIOD:
		return "COV_PERIOD"
	case BACnetPropertyIdentifier_INPUT_REFERENCE:
		return "INPUT_REFERENCE"
	case BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL:
		return "LIMIT_MONITORING_INTERVAL"
	case BACnetPropertyIdentifier_LOGGING_OBJECT:
		return "LOGGING_OBJECT"
	case BACnetPropertyIdentifier_LOGGING_RECORD:
		return "LOGGING_RECORD"
	case BACnetPropertyIdentifier_PRESCALE:
		return "PRESCALE"
	case BACnetPropertyIdentifier_PULSE_RATE:
		return "PULSE_RATE"
	case BACnetPropertyIdentifier_SCALE:
		return "SCALE"
	case BACnetPropertyIdentifier_SCALE_FACTOR:
		return "SCALE_FACTOR"
	case BACnetPropertyIdentifier_UPDATE_TIME:
		return "UPDATE_TIME"
	case BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE:
		return "CONTROLLED_VARIABLE_REFERENCE"
	case BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE:
		return "VALUE_BEFORE_CHANGE"
	case BACnetPropertyIdentifier_VALUE_SET:
		return "VALUE_SET"
	case BACnetPropertyIdentifier_VALUE_CHANGE_TIME:
		return "VALUE_CHANGE_TIME"
	case BACnetPropertyIdentifier_ALIGN_INTERVALS:
		return "ALIGN_INTERVALS"
	case BACnetPropertyIdentifier_INTERVAL_OFFSET:
		return "INTERVAL_OFFSET"
	case BACnetPropertyIdentifier_LAST_RESTART_REASON:
		return "LAST_RESTART_REASON"
	case BACnetPropertyIdentifier_LOGGING_TYPE:
		return "LOGGING_TYPE"
	case BACnetPropertyIdentifier_ACTION:
		return "ACTION"
	case BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS:
		return "CONTROLLED_VARIABLE_UNITS"
	case BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS:
		return "RESTART_NOTIFICATION_RECIPIENTS"
	case BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART:
		return "TIME_OF_DEVICE_RESTART"
	case BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL:
		return "TIME_SYNCHRONIZATION_INTERVAL"
	case BACnetPropertyIdentifier_TRIGGER:
		return "TRIGGER"
	case BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS:
		return "UTC_TIME_SYNCHRONIZATION_RECIPIENTS"
	case BACnetPropertyIdentifier_NODE_SUBTYPE:
		return "NODE_SUBTYPE"
	case BACnetPropertyIdentifier_NODE_TYPE:
		return "NODE_TYPE"
	case BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST:
		return "STRUCTURED_OBJECT_LIST"
	case BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE:
		return "CONTROLLED_VARIABLE_VALUE"
	case BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS:
		return "SUBORDINATE_ANNOTATIONS"
	case BACnetPropertyIdentifier_SUBORDINATE_LIST:
		return "SUBORDINATE_LIST"
	case BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL:
		return "ACTUAL_SHED_LEVEL"
	case BACnetPropertyIdentifier_DUTY_WINDOW:
		return "DUTY_WINDOW"
	case BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL:
		return "EXPECTED_SHED_LEVEL"
	case BACnetPropertyIdentifier_FULL_DUTY_BASELINE:
		return "FULL_DUTY_BASELINE"
	case BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL:
		return "REQUESTED_SHED_LEVEL"
	case BACnetPropertyIdentifier_SHED_DURATION:
		return "SHED_DURATION"
	case BACnetPropertyIdentifier_COV_INCREMENT:
		return "COV_INCREMENT"
	case BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS:
		return "SHED_LEVEL_DESCRIPTIONS"
	case BACnetPropertyIdentifier_SHED_LEVELS:
		return "SHED_LEVELS"
	case BACnetPropertyIdentifier_STATE_DESCRIPTION:
		return "STATE_DESCRIPTION"
	case BACnetPropertyIdentifier_DOOR_ALARM_STATE:
		return "DOOR_ALARM_STATE"
	case BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME:
		return "DOOR_EXTENDED_PULSE_TIME"
	case BACnetPropertyIdentifier_DOOR_MEMBERS:
		return "DOOR_MEMBERS"
	case BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME:
		return "DOOR_OPEN_TOO_LONG_TIME"
	case BACnetPropertyIdentifier_DATE_LIST:
		return "DATE_LIST"
	case BACnetPropertyIdentifier_DOOR_PULSE_TIME:
		return "DOOR_PULSE_TIME"
	case BACnetPropertyIdentifier_DOOR_STATUS:
		return "DOOR_STATUS"
	case BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME:
		return "DOOR_UNLOCK_DELAY_TIME"
	case BACnetPropertyIdentifier_LOCK_STATUS:
		return "LOCK_STATUS"
	case BACnetPropertyIdentifier_MASKED_ALARM_VALUES:
		return "MASKED_ALARM_VALUES"
	case BACnetPropertyIdentifier_SECURED_STATUS:
		return "SECURED_STATUS"
	case BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS:
		return "DAYLIGHT_SAVINGS_STATUS"
	case BACnetPropertyIdentifier_ABSENTEE_LIMIT:
		return "ABSENTEE_LIMIT"
	case BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS:
		return "ACCESS_ALARM_EVENTS"
	case BACnetPropertyIdentifier_ACCESS_DOORS:
		return "ACCESS_DOORS"
	case BACnetPropertyIdentifier_ACCESS_EVENT:
		return "ACCESS_EVENT"
	case BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR:
		return "ACCESS_EVENT_AUTHENTICATION_FACTOR"
	case BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL:
		return "ACCESS_EVENT_CREDENTIAL"
	case BACnetPropertyIdentifier_DEADBAND:
		return "DEADBAND"
	case BACnetPropertyIdentifier_ACCESS_EVENT_TIME:
		return "ACCESS_EVENT_TIME"
	case BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS:
		return "ACCESS_TRANSACTION_EVENTS"
	case BACnetPropertyIdentifier_ACCOMPANIMENT:
		return "ACCOMPANIMENT"
	case BACnetPropertyIdentifier_ACCOMPANIMENT_TIME:
		return "ACCOMPANIMENT_TIME"
	case BACnetPropertyIdentifier_ACTIVATION_TIME:
		return "ACTIVATION_TIME"
	case BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY:
		return "ACTIVE_AUTHENTICATION_POLICY"
	case BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS:
		return "ASSIGNED_ACCESS_RIGHTS"
	case BACnetPropertyIdentifier_AUTHENTICATION_FACTORS:
		return "AUTHENTICATION_FACTORS"
	case BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST:
		return "AUTHENTICATION_POLICY_LIST"
	case BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES:
		return "AUTHENTICATION_POLICY_NAMES"
	case BACnetPropertyIdentifier_DERIVATIVE_CONSTANT:
		return "DERIVATIVE_CONSTANT"
	case BACnetPropertyIdentifier_AUTHENTICATION_STATUS:
		return "AUTHENTICATION_STATUS"
	case BACnetPropertyIdentifier_AUTHORIZATION_MODE:
		return "AUTHORIZATION_MODE"
	case BACnetPropertyIdentifier_BELONGS_TO:
		return "BELONGS_TO"
	case BACnetPropertyIdentifier_CREDENTIAL_DISABLE:
		return "CREDENTIAL_DISABLE"
	case BACnetPropertyIdentifier_CREDENTIAL_STATUS:
		return "CREDENTIAL_STATUS"
	case BACnetPropertyIdentifier_CREDENTIALS:
		return "CREDENTIALS"
	case BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE:
		return "CREDENTIALS_IN_ZONE"
	case BACnetPropertyIdentifier_DAYS_REMAINING:
		return "DAYS_REMAINING"
	case BACnetPropertyIdentifier_ENTRY_POINTS:
		return "ENTRY_POINTS"
	case BACnetPropertyIdentifier_EXIT_POINTS:
		return "EXIT_POINTS"
	case BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS:
		return "DERIVATIVE_CONSTANT_UNITS"
	case BACnetPropertyIdentifier_EXPIRATION_TIME:
		return "EXPIRATION_TIME"
	case BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE:
		return "EXTENDED_TIME_ENABLE"
	case BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS:
		return "FAILED_ATTEMPT_EVENTS"
	case BACnetPropertyIdentifier_FAILED_ATTEMPTS:
		return "FAILED_ATTEMPTS"
	case BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME:
		return "FAILED_ATTEMPTS_TIME"
	case BACnetPropertyIdentifier_LAST_ACCESS_EVENT:
		return "LAST_ACCESS_EVENT"
	case BACnetPropertyIdentifier_LAST_ACCESS_POINT:
		return "LAST_ACCESS_POINT"
	case BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED:
		return "LAST_CREDENTIAL_ADDED"
	case BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME:
		return "LAST_CREDENTIAL_ADDED_TIME"
	case BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED:
		return "LAST_CREDENTIAL_REMOVED"
	case BACnetPropertyIdentifier_DESCRIPTION:
		return "DESCRIPTION"
	case BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME:
		return "LAST_CREDENTIAL_REMOVED_TIME"
	case BACnetPropertyIdentifier_LAST_USE_TIME:
		return "LAST_USE_TIME"
	case BACnetPropertyIdentifier_LOCKOUT:
		return "LOCKOUT"
	case BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME:
		return "LOCKOUT_RELINQUISH_TIME"
	case BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS:
		return "MAX_FAILED_ATTEMPTS"
	case BACnetPropertyIdentifier_MEMBERS:
		return "MEMBERS"
	case BACnetPropertyIdentifier_MUSTER_POINT:
		return "MUSTER_POINT"
	case BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES:
		return "NEGATIVE_ACCESS_RULES"
	case BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES:
		return "NUMBER_OF_AUTHENTICATION_POLICIES"
	case BACnetPropertyIdentifier_DESCRIPTION_OF_HALT:
		return "DESCRIPTION_OF_HALT"
	case BACnetPropertyIdentifier_OCCUPANCY_COUNT:
		return "OCCUPANCY_COUNT"
	case BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST:
		return "OCCUPANCY_COUNT_ADJUST"
	case BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE:
		return "OCCUPANCY_COUNT_ENABLE"
	case BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT:
		return "OCCUPANCY_LOWER_LIMIT"
	case BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED:
		return "OCCUPANCY_LOWER_LIMIT_ENFORCED"
	case BACnetPropertyIdentifier_OCCUPANCY_STATE:
		return "OCCUPANCY_STATE"
	case BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT:
		return "OCCUPANCY_UPPER_LIMIT"
	case BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED:
		return "OCCUPANCY_UPPER_LIMIT_ENFORCED"
	case BACnetPropertyIdentifier_ACTION_TEXT:
		return "ACTION_TEXT"
	case BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING:
		return "DEVICE_ADDRESS_BINDING"
	case BACnetPropertyIdentifier_PASSBACK_MODE:
		return "PASSBACK_MODE"
	case BACnetPropertyIdentifier_PASSBACK_TIMEOUT:
		return "PASSBACK_TIMEOUT"
	case BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES:
		return "POSITIVE_ACCESS_RULES"
	case BACnetPropertyIdentifier_REASON_FOR_DISABLE:
		return "REASON_FOR_DISABLE"
	case BACnetPropertyIdentifier_SUPPORTED_FORMATS:
		return "SUPPORTED_FORMATS"
	case BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES:
		return "SUPPORTED_FORMAT_CLASSES"
	case BACnetPropertyIdentifier_THREAT_AUTHORITY:
		return "THREAT_AUTHORITY"
	case BACnetPropertyIdentifier_THREAT_LEVEL:
		return "THREAT_LEVEL"
	case BACnetPropertyIdentifier_TRACE_FLAG:
		return "TRACE_FLAG"
	case BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS:
		return "TRANSACTION_NOTIFICATION_CLASS"
	case BACnetPropertyIdentifier_DEVICE_TYPE:
		return "DEVICE_TYPE"
	case BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER:
		return "USER_EXTERNAL_IDENTIFIER"
	case BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE:
		return "USER_INFORMATION_REFERENCE"
	case BACnetPropertyIdentifier_USER_NAME:
		return "USER_NAME"
	case BACnetPropertyIdentifier_USER_TYPE:
		return "USER_TYPE"
	case BACnetPropertyIdentifier_USES_REMAINING:
		return "USES_REMAINING"
	case BACnetPropertyIdentifier_EFFECTIVE_PERIOD:
		return "EFFECTIVE_PERIOD"
	case BACnetPropertyIdentifier_ZONE_FROM:
		return "ZONE_FROM"
	case BACnetPropertyIdentifier_ZONE_TO:
		return "ZONE_TO"
	case BACnetPropertyIdentifier_ACCESS_EVENT_TAG:
		return "ACCESS_EVENT_TAG"
	case BACnetPropertyIdentifier_GLOBAL_IDENTIFIER:
		return "GLOBAL_IDENTIFIER"
	case BACnetPropertyIdentifier_VERIFICATION_TIME:
		return "VERIFICATION_TIME"
	case BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY:
		return "BASE_DEVICE_SECURITY_POLICY"
	case BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION:
		return "DISTRIBUTION_KEY_REVISION"
	case BACnetPropertyIdentifier_DO_NOT_HIDE:
		return "DO_NOT_HIDE"
	case BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME:
		return "ELAPSED_ACTIVE_TIME"
	case BACnetPropertyIdentifier_KEY_SETS:
		return "KEY_SETS"
	case BACnetPropertyIdentifier_LAST_KEY_SERVER:
		return "LAST_KEY_SERVER"
	case BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES:
		return "NETWORK_ACCESS_SECURITY_POLICIES"
	case BACnetPropertyIdentifier_PACKET_REORDER_TIME:
		return "PACKET_REORDER_TIME"
	case BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT:
		return "SECURITY_PDU_TIMEOUT"
	case BACnetPropertyIdentifier_SECURITY_TIME_WINDOW:
		return "SECURITY_TIME_WINDOW"
	case BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS:
		return "SUPPORTED_SECURITY_ALGORITHMS"
	case BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT:
		return "UPDATE_KEY_SET_TIMEOUT"
	case BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE:
		return "BACKUP_AND_RESTORE_STATE"
	case BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME:
		return "BACKUP_PREPARATION_TIME"
	case BACnetPropertyIdentifier_ERROR_LIMIT:
		return "ERROR_LIMIT"
	case BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME:
		return "RESTORE_COMPLETION_TIME"
	case BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME:
		return "RESTORE_PREPARATION_TIME"
	case BACnetPropertyIdentifier_BIT_MASK:
		return "BIT_MASK"
	case BACnetPropertyIdentifier_BIT_TEXT:
		return "BIT_TEXT"
	case BACnetPropertyIdentifier_IS_UTC:
		return "IS_UTC"
	case BACnetPropertyIdentifier_GROUP_MEMBERS:
		return "GROUP_MEMBERS"
	case BACnetPropertyIdentifier_GROUP_MEMBER_NAMES:
		return "GROUP_MEMBER_NAMES"
	case BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS:
		return "MEMBER_STATUS_FLAGS"
	case BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL:
		return "REQUESTED_UPDATE_INTERVAL"
	case BACnetPropertyIdentifier_COVU_PERIOD:
		return "COVU_PERIOD"
	case BACnetPropertyIdentifier_EVENT_ENABLE:
		return "EVENT_ENABLE"
	case BACnetPropertyIdentifier_COVU_RECIPIENTS:
		return "COVU_RECIPIENTS"
	case BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS:
		return "EVENT_MESSAGE_TEXTS"
	case BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG:
		return "EVENT_MESSAGE_TEXTS_CONFIG"
	case BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE:
		return "EVENT_DETECTION_ENABLE"
	case BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT:
		return "EVENT_ALGORITHM_INHIBIT"
	case BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF:
		return "EVENT_ALGORITHM_INHIBIT_REF"
	case BACnetPropertyIdentifier_TIME_DELAY_NORMAL:
		return "TIME_DELAY_NORMAL"
	case BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT:
		return "RELIABILITY_EVALUATION_INHIBIT"
	case BACnetPropertyIdentifier_FAULT_PARAMETERS:
		return "FAULT_PARAMETERS"
	case BACnetPropertyIdentifier_FAULT_TYPE:
		return "FAULT_TYPE"
	case BACnetPropertyIdentifier_EVENT_STATE:
		return "EVENT_STATE"
	case BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY:
		return "LOCAL_FORWARDING_ONLY"
	case BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER:
		return "PROCESS_IDENTIFIER_FILTER"
	case BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS:
		return "SUBSCRIBED_RECIPIENTS"
	case BACnetPropertyIdentifier_PORT_FILTER:
		return "PORT_FILTER"
	case BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS:
		return "AUTHORIZATION_EXEMPTIONS"
	case BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT:
		return "ALLOW_GROUP_DELAY_INHIBIT"
	case BACnetPropertyIdentifier_CHANNEL_NUMBER:
		return "CHANNEL_NUMBER"
	case BACnetPropertyIdentifier_CONTROL_GROUPS:
		return "CONTROL_GROUPS"
	case BACnetPropertyIdentifier_EXECUTION_DELAY:
		return "EXECUTION_DELAY"
	case BACnetPropertyIdentifier_LAST_PRIORITY:
		return "LAST_PRIORITY"
	case BACnetPropertyIdentifier_EVENT_TYPE:
		return "EVENT_TYPE"
	case BACnetPropertyIdentifier_WRITE_STATUS:
		return "WRITE_STATUS"
	case BACnetPropertyIdentifier_PROPERTY_LIST:
		return "PROPERTY_LIST"
	case BACnetPropertyIdentifier_SERIAL_NUMBER:
		return "SERIAL_NUMBER"
	case BACnetPropertyIdentifier_BLINK_WARN_ENABLE:
		return "BLINK_WARN_ENABLE"
	case BACnetPropertyIdentifier_DEFAULT_FADE_TIME:
		return "DEFAULT_FADE_TIME"
	case BACnetPropertyIdentifier_DEFAULT_RAMP_RATE:
		return "DEFAULT_RAMP_RATE"
	case BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT:
		return "DEFAULT_STEP_INCREMENT"
	case BACnetPropertyIdentifier_EGRESS_TIME:
		return "EGRESS_TIME"
	case BACnetPropertyIdentifier_IN_PROGRESS:
		return "IN_PROGRESS"
	case BACnetPropertyIdentifier_INSTANTANEOUS_POWER:
		return "INSTANTANEOUS_POWER"
	case BACnetPropertyIdentifier_EXCEPTION_SCHEDULE:
		return "EXCEPTION_SCHEDULE"
	case BACnetPropertyIdentifier_LIGHTING_COMMAND:
		return "LIGHTING_COMMAND"
	case BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY:
		return "LIGHTING_COMMAND_DEFAULT_PRIORITY"
	case BACnetPropertyIdentifier_MAX_ACTUAL_VALUE:
		return "MAX_ACTUAL_VALUE"
	case BACnetPropertyIdentifier_MIN_ACTUAL_VALUE:
		return "MIN_ACTUAL_VALUE"
	case BACnetPropertyIdentifier_POWER:
		return "POWER"
	case BACnetPropertyIdentifier_TRANSITION:
		return "TRANSITION"
	case BACnetPropertyIdentifier_EGRESS_ACTIVE:
		return "EGRESS_ACTIVE"
	case BACnetPropertyIdentifier_INTERFACE_VALUE:
		return "INTERFACE_VALUE"
	case BACnetPropertyIdentifier_FAULT_HIGH_LIMIT:
		return "FAULT_HIGH_LIMIT"
	case BACnetPropertyIdentifier_FAULT_LOW_LIMIT:
		return "FAULT_LOW_LIMIT"
	case BACnetPropertyIdentifier_FAULT_VALUES:
		return "FAULT_VALUES"
	case BACnetPropertyIdentifier_LOW_DIFF_LIMIT:
		return "LOW_DIFF_LIMIT"
	case BACnetPropertyIdentifier_STRIKE_COUNT:
		return "STRIKE_COUNT"
	case BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET:
		return "TIME_OF_STRIKE_COUNT_RESET"
	case BACnetPropertyIdentifier_DEFAULT_TIMEOUT:
		return "DEFAULT_TIMEOUT"
	case BACnetPropertyIdentifier_INITIAL_TIMEOUT:
		return "INITIAL_TIMEOUT"
	case BACnetPropertyIdentifier_LAST_STATE_CHANGE:
		return "LAST_STATE_CHANGE"
	case BACnetPropertyIdentifier_STATE_CHANGE_VALUES:
		return "STATE_CHANGE_VALUES"
	case BACnetPropertyIdentifier_TIMER_RUNNING:
		return "TIMER_RUNNING"
	case BACnetPropertyIdentifier_TIMER_STATE:
		return "TIMER_STATE"
	case BACnetPropertyIdentifier_APDU_LENGTH:
		return "APDU_LENGTH"
	case BACnetPropertyIdentifier_ACTIVE_TEXT:
		return "ACTIVE_TEXT"
	case BACnetPropertyIdentifier_FEEDBACK_VALUE:
		return "FEEDBACK_VALUE"
	case BACnetPropertyIdentifier_IP_ADDRESS:
		return "IP_ADDRESS"
	case BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY:
		return "IP_DEFAULT_GATEWAY"
	case BACnetPropertyIdentifier_IP_DHCP_ENABLE:
		return "IP_DHCP_ENABLE"
	case BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME:
		return "IP_DHCP_LEASE_TIME"
	case BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING:
		return "IP_DHCP_LEASE_TIME_REMAINING"
	case BACnetPropertyIdentifier_IP_DHCP_SERVER:
		return "IP_DHCP_SERVER"
	case BACnetPropertyIdentifier_IP_DNS_SERVER:
		return "IP_DNS_SERVER"
	case BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS:
		return "BACNET_IP_GLOBAL_ADDRESS"
	case BACnetPropertyIdentifier_BACNET_IP_MODE:
		return "BACNET_IP_MODE"
	case BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS:
		return "BACNET_IP_MULTICAST_ADDRESS"
	case BACnetPropertyIdentifier_FILE_ACCESS_METHOD:
		return "FILE_ACCESS_METHOD"
	case BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL:
		return "BACNET_IP_NAT_TRAVERSAL"
	case BACnetPropertyIdentifier_IP_SUBNET_MASK:
		return "IP_SUBNET_MASK"
	case BACnetPropertyIdentifier_BACNET_IP_UDP_PORT:
		return "BACNET_IP_UDP_PORT"
	case BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS:
		return "BBMD_ACCEPT_FD_REGISTRATIONS"
	case BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE:
		return "BBMD_BROADCAST_DISTRIBUTION_TABLE"
	case BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE:
		return "BBMD_FOREIGN_DEVICE_TABLE"
	case BACnetPropertyIdentifier_CHANGES_PENDING:
		return "CHANGES_PENDING"
	case BACnetPropertyIdentifier_COMMAND:
		return "COMMAND"
	case BACnetPropertyIdentifier_FD_BBMD_ADDRESS:
		return "FD_BBMD_ADDRESS"
	case BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME:
		return "FD_SUBSCRIPTION_LIFETIME"
	case BACnetPropertyIdentifier_FILE_SIZE:
		return "FILE_SIZE"
	case BACnetPropertyIdentifier_LINK_SPEED:
		return "LINK_SPEED"
	case BACnetPropertyIdentifier_LINK_SPEEDS:
		return "LINK_SPEEDS"
	case BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE:
		return "LINK_SPEED_AUTONEGOTIATE"
	case BACnetPropertyIdentifier_MAC_ADDRESS:
		return "MAC_ADDRESS"
	case BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME:
		return "NETWORK_INTERFACE_NAME"
	case BACnetPropertyIdentifier_NETWORK_NUMBER:
		return "NETWORK_NUMBER"
	case BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY:
		return "NETWORK_NUMBER_QUALITY"
	case BACnetPropertyIdentifier_NETWORK_TYPE:
		return "NETWORK_TYPE"
	case BACnetPropertyIdentifier_ROUTING_TABLE:
		return "ROUTING_TABLE"
	case BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE:
		return "VIRTUAL_MAC_ADDRESS_TABLE"
	case BACnetPropertyIdentifier_FILE_TYPE:
		return "FILE_TYPE"
	case BACnetPropertyIdentifier_COMMAND_TIME_ARRAY:
		return "COMMAND_TIME_ARRAY"
	case BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY:
		return "CURRENT_COMMAND_PRIORITY"
	case BACnetPropertyIdentifier_LAST_COMMAND_TIME:
		return "LAST_COMMAND_TIME"
	case BACnetPropertyIdentifier_VALUE_SOURCE:
		return "VALUE_SOURCE"
	case BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY:
		return "VALUE_SOURCE_ARRAY"
	case BACnetPropertyIdentifier_BACNET_IPV6_MODE:
		return "BACNET_IPV6_MODE"
	case BACnetPropertyIdentifier_IPV6_ADDRESS:
		return "IPV6_ADDRESS"
	case BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH:
		return "IPV6_PREFIX_LENGTH"
	case BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT:
		return "BACNET_IPV6_UDP_PORT"
	case BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY:
		return "IPV6_DEFAULT_GATEWAY"
	case BACnetPropertyIdentifier_FIRMWARE_REVISION:
		return "FIRMWARE_REVISION"
	case BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS:
		return "BACNET_IPV6_MULTICAST_ADDRESS"
	case BACnetPropertyIdentifier_IPV6_DNS_SERVER:
		return "IPV6_DNS_SERVER"
	case BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE:
		return "IPV6_AUTO_ADDRESSING_ENABLE"
	case BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME:
		return "IPV6_DHCP_LEASE_TIME"
	case BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING:
		return "IPV6_DHCP_LEASE_TIME_REMAINING"
	case BACnetPropertyIdentifier_IPV6_DHCP_SERVER:
		return "IPV6_DHCP_SERVER"
	case BACnetPropertyIdentifier_IPV6_ZONE_INDEX:
		return "IPV6_ZONE_INDEX"
	case BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS:
		return "ASSIGNED_LANDING_CALLS"
	case BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION:
		return "CAR_ASSIGNED_DIRECTION"
	case BACnetPropertyIdentifier_CAR_DOOR_COMMAND:
		return "CAR_DOOR_COMMAND"
	case BACnetPropertyIdentifier_HIGH_LIMIT:
		return "HIGH_LIMIT"
	case BACnetPropertyIdentifier_CAR_DOOR_STATUS:
		return "CAR_DOOR_STATUS"
	case BACnetPropertyIdentifier_CAR_DOOR_TEXT:
		return "CAR_DOOR_TEXT"
	case BACnetPropertyIdentifier_CAR_DOOR_ZONE:
		return "CAR_DOOR_ZONE"
	case BACnetPropertyIdentifier_CAR_DRIVE_STATUS:
		return "CAR_DRIVE_STATUS"
	case BACnetPropertyIdentifier_CAR_LOAD:
		return "CAR_LOAD"
	case BACnetPropertyIdentifier_CAR_LOAD_UNITS:
		return "CAR_LOAD_UNITS"
	case BACnetPropertyIdentifier_CAR_MODE:
		return "CAR_MODE"
	case BACnetPropertyIdentifier_CAR_MOVING_DIRECTION:
		return "CAR_MOVING_DIRECTION"
	case BACnetPropertyIdentifier_CAR_POSITION:
		return "CAR_POSITION"
	case BACnetPropertyIdentifier_ELEVATOR_GROUP:
		return "ELEVATOR_GROUP"
	case BACnetPropertyIdentifier_INACTIVE_TEXT:
		return "INACTIVE_TEXT"
	case BACnetPropertyIdentifier_ENERGY_METER:
		return "ENERGY_METER"
	case BACnetPropertyIdentifier_ENERGY_METER_REF:
		return "ENERGY_METER_REF"
	case BACnetPropertyIdentifier_ESCALATOR_MODE:
		return "ESCALATOR_MODE"
	case BACnetPropertyIdentifier_FAULT_SIGNALS:
		return "FAULT_SIGNALS"
	case BACnetPropertyIdentifier_FLOOR_TEXT:
		return "FLOOR_TEXT"
	case BACnetPropertyIdentifier_GROUP_ID:
		return "GROUP_ID"
	case BACnetPropertyIdentifier_GROUP_MODE:
		return "GROUP_MODE"
	case BACnetPropertyIdentifier_HIGHER_DECK:
		return "HIGHER_DECK"
	case BACnetPropertyIdentifier_INSTALLATION_ID:
		return "INSTALLATION_ID"
	case BACnetPropertyIdentifier_IN_PROCESS:
		return "IN_PROCESS"
	case BACnetPropertyIdentifier_LANDING_CALLS:
		return "LANDING_CALLS"
	case BACnetPropertyIdentifier_LANDING_CALL_CONTROL:
		return "LANDING_CALL_CONTROL"
	case BACnetPropertyIdentifier_LANDING_DOOR_STATUS:
		return "LANDING_DOOR_STATUS"
	case BACnetPropertyIdentifier_LOWER_DECK:
		return "LOWER_DECK"
	case BACnetPropertyIdentifier_MACHINE_ROOM_ID:
		return "MACHINE_ROOM_ID"
	case BACnetPropertyIdentifier_MAKING_CAR_CALL:
		return "MAKING_CAR_CALL"
	case BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR:
		return "NEXT_STOPPING_FLOOR"
	case BACnetPropertyIdentifier_OPERATION_DIRECTION:
		return "OPERATION_DIRECTION"
	case BACnetPropertyIdentifier_PASSENGER_ALARM:
		return "PASSENGER_ALARM"
	case BACnetPropertyIdentifier_POWER_MODE:
		return "POWER_MODE"
	case BACnetPropertyIdentifier_INSTANCE_OF:
		return "INSTANCE_OF"
	case BACnetPropertyIdentifier_REGISTERED_CAR_CALL:
		return "REGISTERED_CAR_CALL"
	case BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS:
		return "ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS"
	case BACnetPropertyIdentifier_PROTOCOL_LEVEL:
		return "PROTOCOL_LEVEL"
	case BACnetPropertyIdentifier_REFERENCE_PORT:
		return "REFERENCE_PORT"
	case BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION:
		return "DEPLOYED_PROFILE_LOCATION"
	case BACnetPropertyIdentifier_PROFILE_LOCATION:
		return "PROFILE_LOCATION"
	case BACnetPropertyIdentifier_TAGS:
		return "TAGS"
	case BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES:
		return "SUBORDINATE_NODE_TYPES"
	case BACnetPropertyIdentifier_SUBORDINATE_TAGS:
		return "SUBORDINATE_TAGS"
	case BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS:
		return "SUBORDINATE_RELATIONSHIPS"
	case BACnetPropertyIdentifier_INTEGRAL_CONSTANT:
		return "INTEGRAL_CONSTANT"
	case BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP:
		return "DEFAULT_SUBORDINATE_RELATIONSHIP"
	case BACnetPropertyIdentifier_REPRESENTS:
		return "REPRESENTS"
	case BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS:
		return "ACTIVE_VT_SESSIONS"
	case BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS:
		return "INTEGRAL_CONSTANT_UNITS"
	case BACnetPropertyIdentifier_LIMIT_ENABLE:
		return "LIMIT_ENABLE"
	case BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS:
		return "LIST_OF_GROUP_MEMBERS"
	case BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES:
		return "LIST_OF_OBJECT_PROPERTY_REFERENCES"
	case BACnetPropertyIdentifier_LOCAL_DATE:
		return "LOCAL_DATE"
	case BACnetPropertyIdentifier_LOCAL_TIME:
		return "LOCAL_TIME"
	case BACnetPropertyIdentifier_LOCATION:
		return "LOCATION"
	case BACnetPropertyIdentifier_LOW_LIMIT:
		return "LOW_LIMIT"
	case BACnetPropertyIdentifier_ALARM_VALUE:
		return "ALARM_VALUE"
	case BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE:
		return "MANIPULATED_VARIABLE_REFERENCE"
	case BACnetPropertyIdentifier_MAXIMUM_OUTPUT:
		return "MAXIMUM_OUTPUT"
	case BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED:
		return "MAX_APDU_LENGTH_ACCEPTED"
	case BACnetPropertyIdentifier_MAX_INFO_FRAMES:
		return "MAX_INFO_FRAMES"
	case BACnetPropertyIdentifier_MAX_MASTER:
		return "MAX_MASTER"
	case BACnetPropertyIdentifier_MAX_PRES_VALUE:
		return "MAX_PRES_VALUE"
	case BACnetPropertyIdentifier_MINIMUM_OFF_TIME:
		return "MINIMUM_OFF_TIME"
	case BACnetPropertyIdentifier_MINIMUM_ON_TIME:
		return "MINIMUM_ON_TIME"
	case BACnetPropertyIdentifier_MINIMUM_OUTPUT:
		return "MINIMUM_OUTPUT"
	case BACnetPropertyIdentifier_MIN_PRES_VALUE:
		return "MIN_PRES_VALUE"
	case BACnetPropertyIdentifier_ALARM_VALUES:
		return "ALARM_VALUES"
	case BACnetPropertyIdentifier_MODEL_NAME:
		return "MODEL_NAME"
	case BACnetPropertyIdentifier_MODIFICATION_DATE:
		return "MODIFICATION_DATE"
	case BACnetPropertyIdentifier_NOTIFY_TYPE:
		return "NOTIFY_TYPE"
	case BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES:
		return "NUMBER_OF_APDU_RETRIES"
	case BACnetPropertyIdentifier_NUMBER_OF_STATES:
		return "NUMBER_OF_STATES"
	case BACnetPropertyIdentifier_OBJECT_IDENTIFIER:
		return "OBJECT_IDENTIFIER"
	case BACnetPropertyIdentifier_OBJECT_LIST:
		return "OBJECT_LIST"
	case BACnetPropertyIdentifier_OBJECT_NAME:
		return "OBJECT_NAME"
	case BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE:
		return "OBJECT_PROPERTY_REFERENCE"
	case BACnetPropertyIdentifier_OBJECT_TYPE:
		return "OBJECT_TYPE"
	case BACnetPropertyIdentifier_ALL:
		return "ALL"
	case BACnetPropertyIdentifier_OPTIONAL:
		return "OPTIONAL"
	case BACnetPropertyIdentifier_OUT_OF_SERVICE:
		return "OUT_OF_SERVICE"
	case BACnetPropertyIdentifier_OUTPUT_UNITS:
		return "OUTPUT_UNITS"
	case BACnetPropertyIdentifier_EVENT_PARAMETERS:
		return "EVENT_PARAMETERS"
	case BACnetPropertyIdentifier_POLARITY:
		return "POLARITY"
	case BACnetPropertyIdentifier_PRESENT_VALUE:
		return "PRESENT_VALUE"
	case BACnetPropertyIdentifier_PRIORITY:
		return "PRIORITY"
	case BACnetPropertyIdentifier_PRIORITY_ARRAY:
		return "PRIORITY_ARRAY"
	case BACnetPropertyIdentifier_PRIORITY_FOR_WRITING:
		return "PRIORITY_FOR_WRITING"
	case BACnetPropertyIdentifier_PROCESS_IDENTIFIER:
		return "PROCESS_IDENTIFIER"
	case BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL:
		return "ALL_WRITES_SUCCESSFUL"
	case BACnetPropertyIdentifier_PROGRAM_CHANGE:
		return "PROGRAM_CHANGE"
	case BACnetPropertyIdentifier_PROGRAM_LOCATION:
		return "PROGRAM_LOCATION"
	case BACnetPropertyIdentifier_PROGRAM_STATE:
		return "PROGRAM_STATE"
	case BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT:
		return "PROPORTIONAL_CONSTANT"
	case BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS:
		return "PROPORTIONAL_CONSTANT_UNITS"
	case BACnetPropertyIdentifier_PROTOCOL_CONFORMANCE_CLASS:
		return "PROTOCOL_CONFORMANCE_CLASS"
	case BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED:
		return "PROTOCOL_OBJECT_TYPES_SUPPORTED"
	case BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED:
		return "PROTOCOL_SERVICES_SUPPORTED"
	case BACnetPropertyIdentifier_PROTOCOL_VERSION:
		return "PROTOCOL_VERSION"
	case BACnetPropertyIdentifier_READ_ONLY:
		return "READ_ONLY"
	case BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE:
		return "VENDOR_PROPRIETARY_VALUE"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e BACnetPropertyIdentifier) String() string {
	return e.PLC4XEnumName()
}
