/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataRepresents is the corresponding interface of BACnetConstructedDataRepresents
type BACnetConstructedDataRepresents interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetRepresents returns Represents (property field)
	GetRepresents() BACnetDeviceObjectReference
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDeviceObjectReference
}

// BACnetConstructedDataRepresentsExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataRepresents.
// This is useful for switch cases.
type BACnetConstructedDataRepresentsExactly interface {
	BACnetConstructedDataRepresents
	isBACnetConstructedDataRepresents() bool
}

// _BACnetConstructedDataRepresents is the data-structure of this message
type _BACnetConstructedDataRepresents struct {
	*_BACnetConstructedData
	Represents BACnetDeviceObjectReference
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataRepresents) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataRepresents) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_REPRESENTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataRepresents) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataRepresents) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataRepresents) GetRepresents() BACnetDeviceObjectReference {
	return m.Represents
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataRepresents) GetActualValue() BACnetDeviceObjectReference {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDeviceObjectReference(m.GetRepresents())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataRepresents factory function for _BACnetConstructedDataRepresents
func NewBACnetConstructedDataRepresents(represents BACnetDeviceObjectReference, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataRepresents {
	_result := &_BACnetConstructedDataRepresents{
		Represents:             represents,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataRepresents(structType any) BACnetConstructedDataRepresents {
	if casted, ok := structType.(BACnetConstructedDataRepresents); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataRepresents); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataRepresents) GetTypeName() string {
	return "BACnetConstructedDataRepresents"
}

func (m *_BACnetConstructedDataRepresents) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (represents)
	lengthInBits += m.Represents.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataRepresents) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataRepresentsParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataRepresents, error) {
	return BACnetConstructedDataRepresentsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataRepresentsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataRepresents, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataRepresents"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataRepresents")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (represents)
	if pullErr := readBuffer.PullContext("represents"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for represents")
	}
	_represents, _representsErr := BACnetDeviceObjectReferenceParseWithBuffer(ctx, readBuffer)
	if _representsErr != nil {
		return nil, errors.Wrap(_representsErr, "Error parsing 'represents' field of BACnetConstructedDataRepresents")
	}
	represents := _represents.(BACnetDeviceObjectReference)
	if closeErr := readBuffer.CloseContext("represents"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for represents")
	}

	// Virtual field
	_actualValue := represents
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataRepresents"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataRepresents")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataRepresents{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		Represents: represents,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataRepresents) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataRepresents) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataRepresents"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataRepresents")
		}

		// Simple Field (represents)
		if pushErr := writeBuffer.PushContext("represents"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for represents")
		}
		_representsErr := writeBuffer.WriteSerializable(ctx, m.GetRepresents())
		if popErr := writeBuffer.PopContext("represents"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for represents")
		}
		if _representsErr != nil {
			return errors.Wrap(_representsErr, "Error serializing 'represents' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataRepresents"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataRepresents")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataRepresents) isBACnetConstructedDataRepresents() bool {
	return true
}

func (m *_BACnetConstructedDataRepresents) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
