/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProtocolServicesSupported is the corresponding interface of BACnetConstructedDataProtocolServicesSupported
type BACnetConstructedDataProtocolServicesSupported interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetProtocolServicesSupported returns ProtocolServicesSupported (property field)
	GetProtocolServicesSupported() BACnetServicesSupportedTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetServicesSupportedTagged
}

// BACnetConstructedDataProtocolServicesSupportedExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataProtocolServicesSupported.
// This is useful for switch cases.
type BACnetConstructedDataProtocolServicesSupportedExactly interface {
	BACnetConstructedDataProtocolServicesSupported
	isBACnetConstructedDataProtocolServicesSupported() bool
}

// _BACnetConstructedDataProtocolServicesSupported is the data-structure of this message
type _BACnetConstructedDataProtocolServicesSupported struct {
	*_BACnetConstructedData
	ProtocolServicesSupported BACnetServicesSupportedTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProtocolServicesSupported) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProtocolServicesSupported) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProtocolServicesSupported) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataProtocolServicesSupported) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProtocolServicesSupported) GetProtocolServicesSupported() BACnetServicesSupportedTagged {
	return m.ProtocolServicesSupported
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProtocolServicesSupported) GetActualValue() BACnetServicesSupportedTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetServicesSupportedTagged(m.GetProtocolServicesSupported())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataProtocolServicesSupported factory function for _BACnetConstructedDataProtocolServicesSupported
func NewBACnetConstructedDataProtocolServicesSupported(protocolServicesSupported BACnetServicesSupportedTagged, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProtocolServicesSupported {
	_result := &_BACnetConstructedDataProtocolServicesSupported{
		ProtocolServicesSupported: protocolServicesSupported,
		_BACnetConstructedData:    NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProtocolServicesSupported(structType any) BACnetConstructedDataProtocolServicesSupported {
	if casted, ok := structType.(BACnetConstructedDataProtocolServicesSupported); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProtocolServicesSupported); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProtocolServicesSupported) GetTypeName() string {
	return "BACnetConstructedDataProtocolServicesSupported"
}

func (m *_BACnetConstructedDataProtocolServicesSupported) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (protocolServicesSupported)
	lengthInBits += m.ProtocolServicesSupported.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProtocolServicesSupported) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataProtocolServicesSupportedParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataProtocolServicesSupported, error) {
	return BACnetConstructedDataProtocolServicesSupportedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataProtocolServicesSupportedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataProtocolServicesSupported, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProtocolServicesSupported"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProtocolServicesSupported")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (protocolServicesSupported)
	if pullErr := readBuffer.PullContext("protocolServicesSupported"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for protocolServicesSupported")
	}
	_protocolServicesSupported, _protocolServicesSupportedErr := BACnetServicesSupportedTaggedParseWithBuffer(ctx, readBuffer, uint8(uint8(0)), TagClass(TagClass_APPLICATION_TAGS))
	if _protocolServicesSupportedErr != nil {
		return nil, errors.Wrap(_protocolServicesSupportedErr, "Error parsing 'protocolServicesSupported' field of BACnetConstructedDataProtocolServicesSupported")
	}
	protocolServicesSupported := _protocolServicesSupported.(BACnetServicesSupportedTagged)
	if closeErr := readBuffer.CloseContext("protocolServicesSupported"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for protocolServicesSupported")
	}

	// Virtual field
	_actualValue := protocolServicesSupported
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProtocolServicesSupported"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProtocolServicesSupported")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataProtocolServicesSupported{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		ProtocolServicesSupported: protocolServicesSupported,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataProtocolServicesSupported) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataProtocolServicesSupported) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProtocolServicesSupported"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProtocolServicesSupported")
		}

		// Simple Field (protocolServicesSupported)
		if pushErr := writeBuffer.PushContext("protocolServicesSupported"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for protocolServicesSupported")
		}
		_protocolServicesSupportedErr := writeBuffer.WriteSerializable(ctx, m.GetProtocolServicesSupported())
		if popErr := writeBuffer.PopContext("protocolServicesSupported"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for protocolServicesSupported")
		}
		if _protocolServicesSupportedErr != nil {
			return errors.Wrap(_protocolServicesSupportedErr, "Error serializing 'protocolServicesSupported' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProtocolServicesSupported"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProtocolServicesSupported")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProtocolServicesSupported) isBACnetConstructedDataProtocolServicesSupported() bool {
	return true
}

func (m *_BACnetConstructedDataProtocolServicesSupported) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
