/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataFailedAttemptEvents is the corresponding interface of BACnetConstructedDataFailedAttemptEvents
type BACnetConstructedDataFailedAttemptEvents interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetFailedAttemptEvents returns FailedAttemptEvents (property field)
	GetFailedAttemptEvents() []BACnetAccessEventTagged
}

// BACnetConstructedDataFailedAttemptEventsExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataFailedAttemptEvents.
// This is useful for switch cases.
type BACnetConstructedDataFailedAttemptEventsExactly interface {
	BACnetConstructedDataFailedAttemptEvents
	isBACnetConstructedDataFailedAttemptEvents() bool
}

// _BACnetConstructedDataFailedAttemptEvents is the data-structure of this message
type _BACnetConstructedDataFailedAttemptEvents struct {
	*_BACnetConstructedData
	FailedAttemptEvents []BACnetAccessEventTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataFailedAttemptEvents) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataFailedAttemptEvents) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataFailedAttemptEvents) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataFailedAttemptEvents) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataFailedAttemptEvents) GetFailedAttemptEvents() []BACnetAccessEventTagged {
	return m.FailedAttemptEvents
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataFailedAttemptEvents factory function for _BACnetConstructedDataFailedAttemptEvents
func NewBACnetConstructedDataFailedAttemptEvents(failedAttemptEvents []BACnetAccessEventTagged, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataFailedAttemptEvents {
	_result := &_BACnetConstructedDataFailedAttemptEvents{
		FailedAttemptEvents:    failedAttemptEvents,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataFailedAttemptEvents(structType any) BACnetConstructedDataFailedAttemptEvents {
	if casted, ok := structType.(BACnetConstructedDataFailedAttemptEvents); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataFailedAttemptEvents); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataFailedAttemptEvents) GetTypeName() string {
	return "BACnetConstructedDataFailedAttemptEvents"
}

func (m *_BACnetConstructedDataFailedAttemptEvents) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Array field
	if len(m.FailedAttemptEvents) > 0 {
		for _, element := range m.FailedAttemptEvents {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataFailedAttemptEvents) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataFailedAttemptEventsParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataFailedAttemptEvents, error) {
	return BACnetConstructedDataFailedAttemptEventsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataFailedAttemptEventsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataFailedAttemptEvents, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataFailedAttemptEvents"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataFailedAttemptEvents")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Array field (failedAttemptEvents)
	if pullErr := readBuffer.PullContext("failedAttemptEvents", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for failedAttemptEvents")
	}
	// Terminated array
	var failedAttemptEvents []BACnetAccessEventTagged
	{
		for !bool(IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber)) {
			_item, _err := BACnetAccessEventTaggedParseWithBuffer(ctx, readBuffer, uint8(0), TagClass_APPLICATION_TAGS)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'failedAttemptEvents' field of BACnetConstructedDataFailedAttemptEvents")
			}
			failedAttemptEvents = append(failedAttemptEvents, _item.(BACnetAccessEventTagged))
		}
	}
	if closeErr := readBuffer.CloseContext("failedAttemptEvents", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for failedAttemptEvents")
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataFailedAttemptEvents"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataFailedAttemptEvents")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataFailedAttemptEvents{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		FailedAttemptEvents: failedAttemptEvents,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataFailedAttemptEvents) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataFailedAttemptEvents) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataFailedAttemptEvents"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataFailedAttemptEvents")
		}

		// Array Field (failedAttemptEvents)
		if pushErr := writeBuffer.PushContext("failedAttemptEvents", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for failedAttemptEvents")
		}
		for _curItem, _element := range m.GetFailedAttemptEvents() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetFailedAttemptEvents()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'failedAttemptEvents' field")
			}
		}
		if popErr := writeBuffer.PopContext("failedAttemptEvents", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for failedAttemptEvents")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataFailedAttemptEvents"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataFailedAttemptEvents")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataFailedAttemptEvents) isBACnetConstructedDataFailedAttemptEvents() bool {
	return true
}

func (m *_BACnetConstructedDataFailedAttemptEvents) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
