/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
	"io"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataEventTimeStamps is the corresponding interface of BACnetConstructedDataEventTimeStamps
type BACnetConstructedDataEventTimeStamps interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetEventTimeStamps returns EventTimeStamps (property field)
	GetEventTimeStamps() []BACnetTimeStamp
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// GetToOffnormal returns ToOffnormal (virtual field)
	GetToOffnormal() BACnetTimeStamp
	// GetToFault returns ToFault (virtual field)
	GetToFault() BACnetTimeStamp
	// GetToNormal returns ToNormal (virtual field)
	GetToNormal() BACnetTimeStamp
}

// BACnetConstructedDataEventTimeStampsExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataEventTimeStamps.
// This is useful for switch cases.
type BACnetConstructedDataEventTimeStampsExactly interface {
	BACnetConstructedDataEventTimeStamps
	isBACnetConstructedDataEventTimeStamps() bool
}

// _BACnetConstructedDataEventTimeStamps is the data-structure of this message
type _BACnetConstructedDataEventTimeStamps struct {
	*_BACnetConstructedData
	NumberOfDataElements BACnetApplicationTagUnsignedInteger
	EventTimeStamps      []BACnetTimeStamp
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataEventTimeStamps) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataEventTimeStamps) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_EVENT_TIME_STAMPS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataEventTimeStamps) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataEventTimeStamps) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataEventTimeStamps) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataEventTimeStamps) GetEventTimeStamps() []BACnetTimeStamp {
	return m.EventTimeStamps
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataEventTimeStamps) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.NumberOfDataElements
	_ = numberOfDataElements
	return uint64(uint64(0))
}

func (m *_BACnetConstructedDataEventTimeStamps) GetToOffnormal() BACnetTimeStamp {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.NumberOfDataElements
	_ = numberOfDataElements
	return CastBACnetTimeStamp(CastBACnetTimeStamp(utils.InlineIf(bool((len(m.GetEventTimeStamps())) == (3)), func() any { return CastBACnetTimeStamp(m.GetEventTimeStamps()[0]) }, func() any { return CastBACnetTimeStamp(nil) })))
}

func (m *_BACnetConstructedDataEventTimeStamps) GetToFault() BACnetTimeStamp {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.NumberOfDataElements
	_ = numberOfDataElements
	return CastBACnetTimeStamp(CastBACnetTimeStamp(utils.InlineIf(bool((len(m.GetEventTimeStamps())) == (3)), func() any { return CastBACnetTimeStamp(m.GetEventTimeStamps()[1]) }, func() any { return CastBACnetTimeStamp(nil) })))
}

func (m *_BACnetConstructedDataEventTimeStamps) GetToNormal() BACnetTimeStamp {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.NumberOfDataElements
	_ = numberOfDataElements
	return CastBACnetTimeStamp(CastBACnetTimeStamp(utils.InlineIf(bool((len(m.GetEventTimeStamps())) == (3)), func() any { return CastBACnetTimeStamp(m.GetEventTimeStamps()[2]) }, func() any { return CastBACnetTimeStamp(nil) })))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataEventTimeStamps factory function for _BACnetConstructedDataEventTimeStamps
func NewBACnetConstructedDataEventTimeStamps(numberOfDataElements BACnetApplicationTagUnsignedInteger, eventTimeStamps []BACnetTimeStamp, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataEventTimeStamps {
	_result := &_BACnetConstructedDataEventTimeStamps{
		NumberOfDataElements:   numberOfDataElements,
		EventTimeStamps:        eventTimeStamps,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataEventTimeStamps(structType any) BACnetConstructedDataEventTimeStamps {
	if casted, ok := structType.(BACnetConstructedDataEventTimeStamps); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataEventTimeStamps); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataEventTimeStamps) GetTypeName() string {
	return "BACnetConstructedDataEventTimeStamps"
}

func (m *_BACnetConstructedDataEventTimeStamps) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.EventTimeStamps) > 0 {
		for _, element := range m.EventTimeStamps {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataEventTimeStamps) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataEventTimeStampsParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataEventTimeStamps, error) {
	return BACnetConstructedDataEventTimeStampsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataEventTimeStampsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataEventTimeStamps, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataEventTimeStamps"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataEventTimeStamps")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Virtual field
	_zero := uint64(0)
	zero := uint64(_zero)
	_ = zero

	// Optional Field (numberOfDataElements) (Can be skipped, if a given expression evaluates to false)
	var numberOfDataElements BACnetApplicationTagUnsignedInteger = nil
	if bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("numberOfDataElements"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for numberOfDataElements")
		}
		_val, _err := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			log.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'numberOfDataElements' field of BACnetConstructedDataEventTimeStamps")
		default:
			numberOfDataElements = _val.(BACnetApplicationTagUnsignedInteger)
			if closeErr := readBuffer.CloseContext("numberOfDataElements"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for numberOfDataElements")
			}
		}
	}

	// Array field (eventTimeStamps)
	if pullErr := readBuffer.PullContext("eventTimeStamps", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for eventTimeStamps")
	}
	// Terminated array
	var eventTimeStamps []BACnetTimeStamp
	{
		for !bool(IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber)) {
			_item, _err := BACnetTimeStampParseWithBuffer(ctx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'eventTimeStamps' field of BACnetConstructedDataEventTimeStamps")
			}
			eventTimeStamps = append(eventTimeStamps, _item.(BACnetTimeStamp))
		}
	}
	if closeErr := readBuffer.CloseContext("eventTimeStamps", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for eventTimeStamps")
	}

	// Virtual field
	_toOffnormal := CastBACnetTimeStamp(utils.InlineIf(bool((len(eventTimeStamps)) == (3)), func() any { return CastBACnetTimeStamp(eventTimeStamps[0]) }, func() any { return CastBACnetTimeStamp(nil) }))
	toOffnormal := _toOffnormal
	_ = toOffnormal

	// Virtual field
	_toFault := CastBACnetTimeStamp(utils.InlineIf(bool((len(eventTimeStamps)) == (3)), func() any { return CastBACnetTimeStamp(eventTimeStamps[1]) }, func() any { return CastBACnetTimeStamp(nil) }))
	toFault := _toFault
	_ = toFault

	// Virtual field
	_toNormal := CastBACnetTimeStamp(utils.InlineIf(bool((len(eventTimeStamps)) == (3)), func() any { return CastBACnetTimeStamp(eventTimeStamps[2]) }, func() any { return CastBACnetTimeStamp(nil) }))
	toNormal := _toNormal
	_ = toNormal

	// Validation
	if !(bool(bool((arrayIndexArgument) != (nil))) || bool(bool((len(eventTimeStamps)) == (3)))) {
		return nil, errors.WithStack(utils.ParseValidationError{"eventTimeStamps should have exactly 3 values"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataEventTimeStamps"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataEventTimeStamps")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataEventTimeStamps{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		NumberOfDataElements: numberOfDataElements,
		EventTimeStamps:      eventTimeStamps,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataEventTimeStamps) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataEventTimeStamps) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataEventTimeStamps"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataEventTimeStamps")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		// Optional Field (numberOfDataElements) (Can be skipped, if the value is null)
		var numberOfDataElements BACnetApplicationTagUnsignedInteger = nil
		if m.GetNumberOfDataElements() != nil {
			if pushErr := writeBuffer.PushContext("numberOfDataElements"); pushErr != nil {
				return errors.Wrap(pushErr, "Error pushing for numberOfDataElements")
			}
			numberOfDataElements = m.GetNumberOfDataElements()
			_numberOfDataElementsErr := writeBuffer.WriteSerializable(ctx, numberOfDataElements)
			if popErr := writeBuffer.PopContext("numberOfDataElements"); popErr != nil {
				return errors.Wrap(popErr, "Error popping for numberOfDataElements")
			}
			if _numberOfDataElementsErr != nil {
				return errors.Wrap(_numberOfDataElementsErr, "Error serializing 'numberOfDataElements' field")
			}
		}

		// Array Field (eventTimeStamps)
		if pushErr := writeBuffer.PushContext("eventTimeStamps", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for eventTimeStamps")
		}
		for _curItem, _element := range m.GetEventTimeStamps() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetEventTimeStamps()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'eventTimeStamps' field")
			}
		}
		if popErr := writeBuffer.PopContext("eventTimeStamps", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for eventTimeStamps")
		}
		// Virtual field
		toOffnormal := m.GetToOffnormal()
		_ = toOffnormal
		if _toOffnormalErr := writeBuffer.WriteVirtual(ctx, "toOffnormal", m.GetToOffnormal()); _toOffnormalErr != nil {
			return errors.Wrap(_toOffnormalErr, "Error serializing 'toOffnormal' field")
		}
		// Virtual field
		toFault := m.GetToFault()
		_ = toFault
		if _toFaultErr := writeBuffer.WriteVirtual(ctx, "toFault", m.GetToFault()); _toFaultErr != nil {
			return errors.Wrap(_toFaultErr, "Error serializing 'toFault' field")
		}
		// Virtual field
		toNormal := m.GetToNormal()
		_ = toNormal
		if _toNormalErr := writeBuffer.WriteVirtual(ctx, "toNormal", m.GetToNormal()); _toNormalErr != nil {
			return errors.Wrap(_toNormalErr, "Error serializing 'toNormal' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataEventTimeStamps"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataEventTimeStamps")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataEventTimeStamps) isBACnetConstructedDataEventTimeStamps() bool {
	return true
}

func (m *_BACnetConstructedDataEventTimeStamps) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
