/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequestAcknowledgeAlarm is the corresponding interface of BACnetConfirmedServiceRequestAcknowledgeAlarm
type BACnetConfirmedServiceRequestAcknowledgeAlarm interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConfirmedServiceRequest
	// GetAcknowledgingProcessIdentifier returns AcknowledgingProcessIdentifier (property field)
	GetAcknowledgingProcessIdentifier() BACnetContextTagUnsignedInteger
	// GetEventObjectIdentifier returns EventObjectIdentifier (property field)
	GetEventObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetEventStateAcknowledged returns EventStateAcknowledged (property field)
	GetEventStateAcknowledged() BACnetEventStateTagged
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() BACnetTimeStampEnclosed
	// GetAcknowledgmentSource returns AcknowledgmentSource (property field)
	GetAcknowledgmentSource() BACnetContextTagCharacterString
	// GetTimeOfAcknowledgment returns TimeOfAcknowledgment (property field)
	GetTimeOfAcknowledgment() BACnetTimeStampEnclosed
}

// BACnetConfirmedServiceRequestAcknowledgeAlarmExactly can be used when we want exactly this type and not a type which fulfills BACnetConfirmedServiceRequestAcknowledgeAlarm.
// This is useful for switch cases.
type BACnetConfirmedServiceRequestAcknowledgeAlarmExactly interface {
	BACnetConfirmedServiceRequestAcknowledgeAlarm
	isBACnetConfirmedServiceRequestAcknowledgeAlarm() bool
}

// _BACnetConfirmedServiceRequestAcknowledgeAlarm is the data-structure of this message
type _BACnetConfirmedServiceRequestAcknowledgeAlarm struct {
	*_BACnetConfirmedServiceRequest
	AcknowledgingProcessIdentifier BACnetContextTagUnsignedInteger
	EventObjectIdentifier          BACnetContextTagObjectIdentifier
	EventStateAcknowledged         BACnetEventStateTagged
	Timestamp                      BACnetTimeStampEnclosed
	AcknowledgmentSource           BACnetContextTagCharacterString
	TimeOfAcknowledgment           BACnetTimeStampEnclosed
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_ACKNOWLEDGE_ALARM
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) InitializeParent(parent BACnetConfirmedServiceRequest) {
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetParent() BACnetConfirmedServiceRequest {
	return m._BACnetConfirmedServiceRequest
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetAcknowledgingProcessIdentifier() BACnetContextTagUnsignedInteger {
	return m.AcknowledgingProcessIdentifier
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetEventObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.EventObjectIdentifier
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetEventStateAcknowledged() BACnetEventStateTagged {
	return m.EventStateAcknowledged
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetTimestamp() BACnetTimeStampEnclosed {
	return m.Timestamp
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetAcknowledgmentSource() BACnetContextTagCharacterString {
	return m.AcknowledgmentSource
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetTimeOfAcknowledgment() BACnetTimeStampEnclosed {
	return m.TimeOfAcknowledgment
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConfirmedServiceRequestAcknowledgeAlarm factory function for _BACnetConfirmedServiceRequestAcknowledgeAlarm
func NewBACnetConfirmedServiceRequestAcknowledgeAlarm(acknowledgingProcessIdentifier BACnetContextTagUnsignedInteger, eventObjectIdentifier BACnetContextTagObjectIdentifier, eventStateAcknowledged BACnetEventStateTagged, timestamp BACnetTimeStampEnclosed, acknowledgmentSource BACnetContextTagCharacterString, timeOfAcknowledgment BACnetTimeStampEnclosed, serviceRequestLength uint32) *_BACnetConfirmedServiceRequestAcknowledgeAlarm {
	_result := &_BACnetConfirmedServiceRequestAcknowledgeAlarm{
		AcknowledgingProcessIdentifier: acknowledgingProcessIdentifier,
		EventObjectIdentifier:          eventObjectIdentifier,
		EventStateAcknowledged:         eventStateAcknowledged,
		Timestamp:                      timestamp,
		AcknowledgmentSource:           acknowledgmentSource,
		TimeOfAcknowledgment:           timeOfAcknowledgment,
		_BACnetConfirmedServiceRequest: NewBACnetConfirmedServiceRequest(serviceRequestLength),
	}
	_result._BACnetConfirmedServiceRequest._BACnetConfirmedServiceRequestChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequestAcknowledgeAlarm(structType any) BACnetConfirmedServiceRequestAcknowledgeAlarm {
	if casted, ok := structType.(BACnetConfirmedServiceRequestAcknowledgeAlarm); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequestAcknowledgeAlarm); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetTypeName() string {
	return "BACnetConfirmedServiceRequestAcknowledgeAlarm"
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (acknowledgingProcessIdentifier)
	lengthInBits += m.AcknowledgingProcessIdentifier.GetLengthInBits(ctx)

	// Simple field (eventObjectIdentifier)
	lengthInBits += m.EventObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (eventStateAcknowledged)
	lengthInBits += m.EventStateAcknowledged.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += m.Timestamp.GetLengthInBits(ctx)

	// Simple field (acknowledgmentSource)
	lengthInBits += m.AcknowledgmentSource.GetLengthInBits(ctx)

	// Simple field (timeOfAcknowledgment)
	lengthInBits += m.TimeOfAcknowledgment.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConfirmedServiceRequestAcknowledgeAlarmParse(ctx context.Context, theBytes []byte, serviceRequestLength uint32) (BACnetConfirmedServiceRequestAcknowledgeAlarm, error) {
	return BACnetConfirmedServiceRequestAcknowledgeAlarmParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), serviceRequestLength)
}

func BACnetConfirmedServiceRequestAcknowledgeAlarmParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, serviceRequestLength uint32) (BACnetConfirmedServiceRequestAcknowledgeAlarm, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequestAcknowledgeAlarm"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (acknowledgingProcessIdentifier)
	if pullErr := readBuffer.PullContext("acknowledgingProcessIdentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for acknowledgingProcessIdentifier")
	}
	_acknowledgingProcessIdentifier, _acknowledgingProcessIdentifierErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(0)), BACnetDataType(BACnetDataType_UNSIGNED_INTEGER))
	if _acknowledgingProcessIdentifierErr != nil {
		return nil, errors.Wrap(_acknowledgingProcessIdentifierErr, "Error parsing 'acknowledgingProcessIdentifier' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	acknowledgingProcessIdentifier := _acknowledgingProcessIdentifier.(BACnetContextTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("acknowledgingProcessIdentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for acknowledgingProcessIdentifier")
	}

	// Simple Field (eventObjectIdentifier)
	if pullErr := readBuffer.PullContext("eventObjectIdentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for eventObjectIdentifier")
	}
	_eventObjectIdentifier, _eventObjectIdentifierErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(1)), BACnetDataType(BACnetDataType_BACNET_OBJECT_IDENTIFIER))
	if _eventObjectIdentifierErr != nil {
		return nil, errors.Wrap(_eventObjectIdentifierErr, "Error parsing 'eventObjectIdentifier' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	eventObjectIdentifier := _eventObjectIdentifier.(BACnetContextTagObjectIdentifier)
	if closeErr := readBuffer.CloseContext("eventObjectIdentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for eventObjectIdentifier")
	}

	// Simple Field (eventStateAcknowledged)
	if pullErr := readBuffer.PullContext("eventStateAcknowledged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for eventStateAcknowledged")
	}
	_eventStateAcknowledged, _eventStateAcknowledgedErr := BACnetEventStateTaggedParseWithBuffer(ctx, readBuffer, uint8(uint8(2)), TagClass(TagClass_CONTEXT_SPECIFIC_TAGS))
	if _eventStateAcknowledgedErr != nil {
		return nil, errors.Wrap(_eventStateAcknowledgedErr, "Error parsing 'eventStateAcknowledged' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	eventStateAcknowledged := _eventStateAcknowledged.(BACnetEventStateTagged)
	if closeErr := readBuffer.CloseContext("eventStateAcknowledged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for eventStateAcknowledged")
	}

	// Simple Field (timestamp)
	if pullErr := readBuffer.PullContext("timestamp"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for timestamp")
	}
	_timestamp, _timestampErr := BACnetTimeStampEnclosedParseWithBuffer(ctx, readBuffer, uint8(uint8(3)))
	if _timestampErr != nil {
		return nil, errors.Wrap(_timestampErr, "Error parsing 'timestamp' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	timestamp := _timestamp.(BACnetTimeStampEnclosed)
	if closeErr := readBuffer.CloseContext("timestamp"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for timestamp")
	}

	// Simple Field (acknowledgmentSource)
	if pullErr := readBuffer.PullContext("acknowledgmentSource"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for acknowledgmentSource")
	}
	_acknowledgmentSource, _acknowledgmentSourceErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(4)), BACnetDataType(BACnetDataType_CHARACTER_STRING))
	if _acknowledgmentSourceErr != nil {
		return nil, errors.Wrap(_acknowledgmentSourceErr, "Error parsing 'acknowledgmentSource' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	acknowledgmentSource := _acknowledgmentSource.(BACnetContextTagCharacterString)
	if closeErr := readBuffer.CloseContext("acknowledgmentSource"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for acknowledgmentSource")
	}

	// Simple Field (timeOfAcknowledgment)
	if pullErr := readBuffer.PullContext("timeOfAcknowledgment"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for timeOfAcknowledgment")
	}
	_timeOfAcknowledgment, _timeOfAcknowledgmentErr := BACnetTimeStampEnclosedParseWithBuffer(ctx, readBuffer, uint8(uint8(5)))
	if _timeOfAcknowledgmentErr != nil {
		return nil, errors.Wrap(_timeOfAcknowledgmentErr, "Error parsing 'timeOfAcknowledgment' field of BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}
	timeOfAcknowledgment := _timeOfAcknowledgment.(BACnetTimeStampEnclosed)
	if closeErr := readBuffer.CloseContext("timeOfAcknowledgment"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for timeOfAcknowledgment")
	}

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequestAcknowledgeAlarm"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequestAcknowledgeAlarm")
	}

	// Create a partially initialized instance
	_child := &_BACnetConfirmedServiceRequestAcknowledgeAlarm{
		_BACnetConfirmedServiceRequest: &_BACnetConfirmedServiceRequest{
			ServiceRequestLength: serviceRequestLength,
		},
		AcknowledgingProcessIdentifier: acknowledgingProcessIdentifier,
		EventObjectIdentifier:          eventObjectIdentifier,
		EventStateAcknowledged:         eventStateAcknowledged,
		Timestamp:                      timestamp,
		AcknowledgmentSource:           acknowledgmentSource,
		TimeOfAcknowledgment:           timeOfAcknowledgment,
	}
	_child._BACnetConfirmedServiceRequest._BACnetConfirmedServiceRequestChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequestAcknowledgeAlarm"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequestAcknowledgeAlarm")
		}

		// Simple Field (acknowledgingProcessIdentifier)
		if pushErr := writeBuffer.PushContext("acknowledgingProcessIdentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for acknowledgingProcessIdentifier")
		}
		_acknowledgingProcessIdentifierErr := writeBuffer.WriteSerializable(ctx, m.GetAcknowledgingProcessIdentifier())
		if popErr := writeBuffer.PopContext("acknowledgingProcessIdentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for acknowledgingProcessIdentifier")
		}
		if _acknowledgingProcessIdentifierErr != nil {
			return errors.Wrap(_acknowledgingProcessIdentifierErr, "Error serializing 'acknowledgingProcessIdentifier' field")
		}

		// Simple Field (eventObjectIdentifier)
		if pushErr := writeBuffer.PushContext("eventObjectIdentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for eventObjectIdentifier")
		}
		_eventObjectIdentifierErr := writeBuffer.WriteSerializable(ctx, m.GetEventObjectIdentifier())
		if popErr := writeBuffer.PopContext("eventObjectIdentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for eventObjectIdentifier")
		}
		if _eventObjectIdentifierErr != nil {
			return errors.Wrap(_eventObjectIdentifierErr, "Error serializing 'eventObjectIdentifier' field")
		}

		// Simple Field (eventStateAcknowledged)
		if pushErr := writeBuffer.PushContext("eventStateAcknowledged"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for eventStateAcknowledged")
		}
		_eventStateAcknowledgedErr := writeBuffer.WriteSerializable(ctx, m.GetEventStateAcknowledged())
		if popErr := writeBuffer.PopContext("eventStateAcknowledged"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for eventStateAcknowledged")
		}
		if _eventStateAcknowledgedErr != nil {
			return errors.Wrap(_eventStateAcknowledgedErr, "Error serializing 'eventStateAcknowledged' field")
		}

		// Simple Field (timestamp)
		if pushErr := writeBuffer.PushContext("timestamp"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for timestamp")
		}
		_timestampErr := writeBuffer.WriteSerializable(ctx, m.GetTimestamp())
		if popErr := writeBuffer.PopContext("timestamp"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for timestamp")
		}
		if _timestampErr != nil {
			return errors.Wrap(_timestampErr, "Error serializing 'timestamp' field")
		}

		// Simple Field (acknowledgmentSource)
		if pushErr := writeBuffer.PushContext("acknowledgmentSource"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for acknowledgmentSource")
		}
		_acknowledgmentSourceErr := writeBuffer.WriteSerializable(ctx, m.GetAcknowledgmentSource())
		if popErr := writeBuffer.PopContext("acknowledgmentSource"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for acknowledgmentSource")
		}
		if _acknowledgmentSourceErr != nil {
			return errors.Wrap(_acknowledgmentSourceErr, "Error serializing 'acknowledgmentSource' field")
		}

		// Simple Field (timeOfAcknowledgment)
		if pushErr := writeBuffer.PushContext("timeOfAcknowledgment"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for timeOfAcknowledgment")
		}
		_timeOfAcknowledgmentErr := writeBuffer.WriteSerializable(ctx, m.GetTimeOfAcknowledgment())
		if popErr := writeBuffer.PopContext("timeOfAcknowledgment"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for timeOfAcknowledgment")
		}
		if _timeOfAcknowledgmentErr != nil {
			return errors.Wrap(_timeOfAcknowledgmentErr, "Error serializing 'timeOfAcknowledgment' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequestAcknowledgeAlarm"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequestAcknowledgeAlarm")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) isBACnetConfirmedServiceRequestAcknowledgeAlarm() bool {
	return true
}

func (m *_BACnetConfirmedServiceRequestAcknowledgeAlarm) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
