/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsDataTypeArrayInfo is the corresponding interface of AdsDataTypeArrayInfo
type AdsDataTypeArrayInfo interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetLowerBound returns LowerBound (property field)
	GetLowerBound() uint32
	// GetNumElements returns NumElements (property field)
	GetNumElements() uint32
	// GetUpperBound returns UpperBound (virtual field)
	GetUpperBound() uint32
}

// AdsDataTypeArrayInfoExactly can be used when we want exactly this type and not a type which fulfills AdsDataTypeArrayInfo.
// This is useful for switch cases.
type AdsDataTypeArrayInfoExactly interface {
	AdsDataTypeArrayInfo
	isAdsDataTypeArrayInfo() bool
}

// _AdsDataTypeArrayInfo is the data-structure of this message
type _AdsDataTypeArrayInfo struct {
	LowerBound  uint32
	NumElements uint32
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsDataTypeArrayInfo) GetLowerBound() uint32 {
	return m.LowerBound
}

func (m *_AdsDataTypeArrayInfo) GetNumElements() uint32 {
	return m.NumElements
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_AdsDataTypeArrayInfo) GetUpperBound() uint32 {
	ctx := context.Background()
	_ = ctx
	return uint32(uint32(m.GetLowerBound()) + uint32(m.GetNumElements()))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAdsDataTypeArrayInfo factory function for _AdsDataTypeArrayInfo
func NewAdsDataTypeArrayInfo(lowerBound uint32, numElements uint32) *_AdsDataTypeArrayInfo {
	return &_AdsDataTypeArrayInfo{LowerBound: lowerBound, NumElements: numElements}
}

// Deprecated: use the interface for direct cast
func CastAdsDataTypeArrayInfo(structType any) AdsDataTypeArrayInfo {
	if casted, ok := structType.(AdsDataTypeArrayInfo); ok {
		return casted
	}
	if casted, ok := structType.(*AdsDataTypeArrayInfo); ok {
		return *casted
	}
	return nil
}

func (m *_AdsDataTypeArrayInfo) GetTypeName() string {
	return "AdsDataTypeArrayInfo"
}

func (m *_AdsDataTypeArrayInfo) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (lowerBound)
	lengthInBits += 32

	// Simple field (numElements)
	lengthInBits += 32

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_AdsDataTypeArrayInfo) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AdsDataTypeArrayInfoParse(ctx context.Context, theBytes []byte) (AdsDataTypeArrayInfo, error) {
	return AdsDataTypeArrayInfoParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes, utils.WithByteOrderForReadBufferByteBased(binary.LittleEndian)))
}

func AdsDataTypeArrayInfoParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AdsDataTypeArrayInfo, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AdsDataTypeArrayInfo"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsDataTypeArrayInfo")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (lowerBound)
	_lowerBound, _lowerBoundErr := readBuffer.ReadUint32("lowerBound", 32)
	if _lowerBoundErr != nil {
		return nil, errors.Wrap(_lowerBoundErr, "Error parsing 'lowerBound' field of AdsDataTypeArrayInfo")
	}
	lowerBound := _lowerBound

	// Simple Field (numElements)
	_numElements, _numElementsErr := readBuffer.ReadUint32("numElements", 32)
	if _numElementsErr != nil {
		return nil, errors.Wrap(_numElementsErr, "Error parsing 'numElements' field of AdsDataTypeArrayInfo")
	}
	numElements := _numElements

	// Virtual field
	_upperBound := uint32(lowerBound) + uint32(numElements)
	upperBound := uint32(_upperBound)
	_ = upperBound

	if closeErr := readBuffer.CloseContext("AdsDataTypeArrayInfo"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsDataTypeArrayInfo")
	}

	// Create the instance
	return &_AdsDataTypeArrayInfo{
		LowerBound:  lowerBound,
		NumElements: numElements,
	}, nil
}

func (m *_AdsDataTypeArrayInfo) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.LittleEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsDataTypeArrayInfo) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AdsDataTypeArrayInfo"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AdsDataTypeArrayInfo")
	}

	// Simple Field (lowerBound)
	lowerBound := uint32(m.GetLowerBound())
	_lowerBoundErr := writeBuffer.WriteUint32("lowerBound", 32, uint32((lowerBound)))
	if _lowerBoundErr != nil {
		return errors.Wrap(_lowerBoundErr, "Error serializing 'lowerBound' field")
	}

	// Simple Field (numElements)
	numElements := uint32(m.GetNumElements())
	_numElementsErr := writeBuffer.WriteUint32("numElements", 32, uint32((numElements)))
	if _numElementsErr != nil {
		return errors.Wrap(_numElementsErr, "Error serializing 'numElements' field")
	}
	// Virtual field
	upperBound := m.GetUpperBound()
	_ = upperBound
	if _upperBoundErr := writeBuffer.WriteVirtual(ctx, "upperBound", m.GetUpperBound()); _upperBoundErr != nil {
		return errors.Wrap(_upperBoundErr, "Error serializing 'upperBound' field")
	}

	if popErr := writeBuffer.PopContext("AdsDataTypeArrayInfo"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AdsDataTypeArrayInfo")
	}
	return nil
}

func (m *_AdsDataTypeArrayInfo) isAdsDataTypeArrayInfo() bool {
	return true
}

func (m *_AdsDataTypeArrayInfo) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
