/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AmsString is the corresponding interface of AmsString
type AmsString interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetText returns Text (property field)
	GetText() string
}

// AmsStringExactly can be used when we want exactly this type and not a type which fulfills AmsString.
// This is useful for switch cases.
type AmsStringExactly interface {
	AmsString
	isAmsString() bool
}

// _AmsString is the data-structure of this message
type _AmsString struct {
	Text string
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AmsString) GetText() string {
	return m.Text
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAmsString factory function for _AmsString
func NewAmsString(text string) *_AmsString {
	return &_AmsString{Text: text}
}

// Deprecated: use the interface for direct cast
func CastAmsString(structType any) AmsString {
	if casted, ok := structType.(AmsString); ok {
		return casted
	}
	if casted, ok := structType.(*AmsString); ok {
		return *casted
	}
	return nil
}

func (m *_AmsString) GetTypeName() string {
	return "AmsString"
}

func (m *_AmsString) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Implicit Field (strLen)
	lengthInBits += 16

	// Simple field (text)
	lengthInBits += uint16(int32(int32(8)) * int32((int32(uint16(uint16(len(m.GetText())))+uint16(uint16(1))) - int32(int32(1)))))

	// Reserved Field (reserved)
	lengthInBits += 8

	return lengthInBits
}

func (m *_AmsString) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AmsStringParse(ctx context.Context, theBytes []byte) (AmsString, error) {
	return AmsStringParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AmsStringParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AmsString, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AmsString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AmsString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (strLen) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	strLen, _strLenErr := readBuffer.ReadUint16("strLen", 16)
	_ = strLen
	if _strLenErr != nil {
		return nil, errors.Wrap(_strLenErr, "Error parsing 'strLen' field of AmsString")
	}

	// Simple Field (text)
	_text, _textErr := readBuffer.ReadString("text", uint32((8)*((strLen)-(1))), "UTF-8")
	if _textErr != nil {
		return nil, errors.Wrap(_textErr, "Error parsing 'text' field of AmsString")
	}
	text := _text

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of AmsString")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	if closeErr := readBuffer.CloseContext("AmsString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AmsString")
	}

	// Create the instance
	return &_AmsString{
		Text:           text,
		reservedField0: reservedField0,
	}, nil
}

func (m *_AmsString) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AmsString) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AmsString"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AmsString")
	}

	// Implicit Field (strLen) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
	strLen := uint16(uint16(uint16(len(m.GetText()))) + uint16(uint16(1)))
	_strLenErr := writeBuffer.WriteUint16("strLen", 16, uint16((strLen)))
	if _strLenErr != nil {
		return errors.Wrap(_strLenErr, "Error serializing 'strLen' field")
	}

	// Simple Field (text)
	text := string(m.GetText())
	_textErr := writeBuffer.WriteString("text", uint32((8)*((uint16(uint16(len(m.GetText())))+uint16(uint16(1)))-(1))), "UTF-8", (text))
	if _textErr != nil {
		return errors.Wrap(_textErr, "Error serializing 'text' field")
	}

	// Reserved Field (reserved)
	{
		var reserved uint8 = uint8(0x00)
		if m.reservedField0 != nil {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Overriding reserved field with unexpected value.")
			reserved = *m.reservedField0
		}
		_err := writeBuffer.WriteUint8("reserved", 8, uint8(reserved))
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	if popErr := writeBuffer.PopContext("AmsString"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AmsString")
	}
	return nil
}

func (m *_AmsString) isAmsString() bool {
	return true
}

func (m *_AmsString) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
