/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsDiscoveryBlockUserName is the corresponding interface of AdsDiscoveryBlockUserName
type AdsDiscoveryBlockUserName interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	AdsDiscoveryBlock
	// GetUserName returns UserName (property field)
	GetUserName() AmsString
}

// AdsDiscoveryBlockUserNameExactly can be used when we want exactly this type and not a type which fulfills AdsDiscoveryBlockUserName.
// This is useful for switch cases.
type AdsDiscoveryBlockUserNameExactly interface {
	AdsDiscoveryBlockUserName
	isAdsDiscoveryBlockUserName() bool
}

// _AdsDiscoveryBlockUserName is the data-structure of this message
type _AdsDiscoveryBlockUserName struct {
	*_AdsDiscoveryBlock
	UserName AmsString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsDiscoveryBlockUserName) GetBlockType() AdsDiscoveryBlockType {
	return AdsDiscoveryBlockType_USER_NAME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsDiscoveryBlockUserName) InitializeParent(parent AdsDiscoveryBlock) {}

func (m *_AdsDiscoveryBlockUserName) GetParent() AdsDiscoveryBlock {
	return m._AdsDiscoveryBlock
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsDiscoveryBlockUserName) GetUserName() AmsString {
	return m.UserName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAdsDiscoveryBlockUserName factory function for _AdsDiscoveryBlockUserName
func NewAdsDiscoveryBlockUserName(userName AmsString) *_AdsDiscoveryBlockUserName {
	_result := &_AdsDiscoveryBlockUserName{
		UserName:           userName,
		_AdsDiscoveryBlock: NewAdsDiscoveryBlock(),
	}
	_result._AdsDiscoveryBlock._AdsDiscoveryBlockChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAdsDiscoveryBlockUserName(structType any) AdsDiscoveryBlockUserName {
	if casted, ok := structType.(AdsDiscoveryBlockUserName); ok {
		return casted
	}
	if casted, ok := structType.(*AdsDiscoveryBlockUserName); ok {
		return *casted
	}
	return nil
}

func (m *_AdsDiscoveryBlockUserName) GetTypeName() string {
	return "AdsDiscoveryBlockUserName"
}

func (m *_AdsDiscoveryBlockUserName) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (userName)
	lengthInBits += m.UserName.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AdsDiscoveryBlockUserName) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AdsDiscoveryBlockUserNameParse(ctx context.Context, theBytes []byte) (AdsDiscoveryBlockUserName, error) {
	return AdsDiscoveryBlockUserNameParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AdsDiscoveryBlockUserNameParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AdsDiscoveryBlockUserName, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AdsDiscoveryBlockUserName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsDiscoveryBlockUserName")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (userName)
	if pullErr := readBuffer.PullContext("userName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for userName")
	}
	_userName, _userNameErr := AmsStringParseWithBuffer(ctx, readBuffer)
	if _userNameErr != nil {
		return nil, errors.Wrap(_userNameErr, "Error parsing 'userName' field of AdsDiscoveryBlockUserName")
	}
	userName := _userName.(AmsString)
	if closeErr := readBuffer.CloseContext("userName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for userName")
	}

	if closeErr := readBuffer.CloseContext("AdsDiscoveryBlockUserName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsDiscoveryBlockUserName")
	}

	// Create a partially initialized instance
	_child := &_AdsDiscoveryBlockUserName{
		_AdsDiscoveryBlock: &_AdsDiscoveryBlock{},
		UserName:           userName,
	}
	_child._AdsDiscoveryBlock._AdsDiscoveryBlockChildRequirements = _child
	return _child, nil
}

func (m *_AdsDiscoveryBlockUserName) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsDiscoveryBlockUserName) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsDiscoveryBlockUserName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsDiscoveryBlockUserName")
		}

		// Simple Field (userName)
		if pushErr := writeBuffer.PushContext("userName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for userName")
		}
		_userNameErr := writeBuffer.WriteSerializable(ctx, m.GetUserName())
		if popErr := writeBuffer.PopContext("userName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for userName")
		}
		if _userNameErr != nil {
			return errors.Wrap(_userNameErr, "Error serializing 'userName' field")
		}

		if popErr := writeBuffer.PopContext("AdsDiscoveryBlockUserName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsDiscoveryBlockUserName")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsDiscoveryBlockUserName) isAdsDiscoveryBlockUserName() bool {
	return true
}

func (m *_AdsDiscoveryBlockUserName) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
