/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SimpleTypeTest implements Message {

  // Properties.
  protected final boolean bitField;
  protected final byte byteField;
  protected final byte intField;
  protected final short uintField;
  protected final float floatField;
  protected final double doubleField;
  protected final String stringField;

  public SimpleTypeTest(
      boolean bitField,
      byte byteField,
      byte intField,
      short uintField,
      float floatField,
      double doubleField,
      String stringField) {
    super();
    this.bitField = bitField;
    this.byteField = byteField;
    this.intField = intField;
    this.uintField = uintField;
    this.floatField = floatField;
    this.doubleField = doubleField;
    this.stringField = stringField;
  }

  public boolean getBitField() {
    return bitField;
  }

  public byte getByteField() {
    return byteField;
  }

  public byte getIntField() {
    return intField;
  }

  public short getUintField() {
    return uintField;
  }

  public float getFloatField() {
    return floatField;
  }

  public double getDoubleField() {
    return doubleField;
  }

  public String getStringField() {
    return stringField;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SimpleTypeTest");

    // Simple Field (bitField)
    writeSimpleField("bitField", bitField, writeBoolean(writeBuffer));

    // Simple Field (byteField)
    writeSimpleField("byteField", byteField, writeByte(writeBuffer, 8));

    // Simple Field (intField)
    writeSimpleField("intField", intField, writeSignedByte(writeBuffer, 8));

    // Simple Field (uintField)
    writeSimpleField("uintField", uintField, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (floatField)
    writeSimpleField("floatField", floatField, writeFloat(writeBuffer, 32));

    // Simple Field (doubleField)
    writeSimpleField("doubleField", doubleField, writeDouble(writeBuffer, 64));

    // Simple Field (stringField)
    writeSimpleField("stringField", stringField, writeString(writeBuffer, 8));

    writeBuffer.popContext("SimpleTypeTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SimpleTypeTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (bitField)
    lengthInBits += 1;

    // Simple field (byteField)
    lengthInBits += 8;

    // Simple field (intField)
    lengthInBits += 8;

    // Simple field (uintField)
    lengthInBits += 8;

    // Simple field (floatField)
    lengthInBits += 32;

    // Simple field (doubleField)
    lengthInBits += 64;

    // Simple field (stringField)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static SimpleTypeTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static SimpleTypeTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SimpleTypeTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean bitField = readSimpleField("bitField", readBoolean(readBuffer));

    byte byteField = readSimpleField("byteField", readByte(readBuffer, 8));

    byte intField = readSimpleField("intField", readSignedByte(readBuffer, 8));

    short uintField = readSimpleField("uintField", readUnsignedShort(readBuffer, 8));

    float floatField = readSimpleField("floatField", readFloat(readBuffer, 32));

    double doubleField = readSimpleField("doubleField", readDouble(readBuffer, 64));

    String stringField = readSimpleField("stringField", readString(readBuffer, 8));

    readBuffer.closeContext("SimpleTypeTest");
    // Create the instance
    SimpleTypeTest _simpleTypeTest;
    _simpleTypeTest =
        new SimpleTypeTest(
            bitField, byteField, intField, uintField, floatField, doubleField, stringField);
    return _simpleTypeTest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SimpleTypeTest)) {
      return false;
    }
    SimpleTypeTest that = (SimpleTypeTest) o;
    return (getBitField() == that.getBitField())
        && (getByteField() == that.getByteField())
        && (getIntField() == that.getIntField())
        && (getUintField() == that.getUintField())
        && (getFloatField() == that.getFloatField())
        && (getDoubleField() == that.getDoubleField())
        && (getStringField() == that.getStringField())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getBitField(),
        getByteField(),
        getIntField(),
        getUintField(),
        getFloatField(),
        getDoubleField(),
        getStringField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
