/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum EnumTypeParameters {
  BOOL((byte) 0x01, (short) 1, (byte) 1, (String) "BOOL", EnumType.BOOL, (boolean) false),
  BYTE((byte) 0x02, (short) 2, (byte) 2, (String) "BYTE", EnumType.UINT, (boolean) true);
  private static final Map<Byte, EnumTypeParameters> map;

  static {
    map = new HashMap<>();
    for (EnumTypeParameters value : EnumTypeParameters.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final short uintType;
  private final byte intType;
  private final String stringType;
  private final EnumType enumType;
  private final boolean bitType;

  EnumTypeParameters(
      byte value,
      short uintType,
      byte intType,
      String stringType,
      EnumType enumType,
      boolean bitType) {
    this.value = value;
    this.uintType = uintType;
    this.intType = intType;
    this.stringType = stringType;
    this.enumType = enumType;
    this.bitType = bitType;
  }

  public byte getValue() {
    return value;
  }

  public short getUintType() {
    return uintType;
  }

  public static EnumTypeParameters firstEnumForFieldUintType(short fieldValue) {
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getUintType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<EnumTypeParameters> enumsForFieldUintType(short fieldValue) {
    List<EnumTypeParameters> _values = new ArrayList<>();
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getUintType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public byte getIntType() {
    return intType;
  }

  public static EnumTypeParameters firstEnumForFieldIntType(byte fieldValue) {
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getIntType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<EnumTypeParameters> enumsForFieldIntType(byte fieldValue) {
    List<EnumTypeParameters> _values = new ArrayList<>();
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getIntType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getStringType() {
    return stringType;
  }

  public static EnumTypeParameters firstEnumForFieldStringType(String fieldValue) {
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getStringType().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<EnumTypeParameters> enumsForFieldStringType(String fieldValue) {
    List<EnumTypeParameters> _values = new ArrayList<>();
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getStringType().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public EnumType getEnumType() {
    return enumType;
  }

  public static EnumTypeParameters firstEnumForFieldEnumType(EnumType fieldValue) {
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getEnumType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<EnumTypeParameters> enumsForFieldEnumType(EnumType fieldValue) {
    List<EnumTypeParameters> _values = new ArrayList<>();
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getEnumType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public boolean getBitType() {
    return bitType;
  }

  public static EnumTypeParameters firstEnumForFieldBitType(boolean fieldValue) {
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getBitType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<EnumTypeParameters> enumsForFieldBitType(boolean fieldValue) {
    List<EnumTypeParameters> _values = new ArrayList<>();
    for (EnumTypeParameters _val : EnumTypeParameters.values()) {
      if (_val.getBitType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static EnumTypeParameters enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
