/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class S7Payload implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getMessageType();

  public abstract Short getParameterParameterType();

  public S7Payload() {
    super();
  }

  protected abstract void serializeS7PayloadChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("S7Payload");

    // Switch field (Serialize the sub-type)
    serializeS7PayloadChild(writeBuffer);

    writeBuffer.popContext("S7Payload");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    S7Payload _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static S7Payload staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 2)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 2, but got " + args.length);
    }
    Short messageType;
    if (args[0] instanceof Short) {
      messageType = (Short) args[0];
    } else if (args[0] instanceof String) {
      messageType = Short.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Short or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    S7Parameter parameter;
    if (args[1] instanceof S7Parameter) {
      parameter = (S7Parameter) args[1];
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type S7Parameter or a string which is parseable but was "
              + args[1].getClass().getName());
    }
    return staticParse(readBuffer, messageType, parameter);
  }

  public static S7Payload staticParse(
      ReadBuffer readBuffer, Short messageType, S7Parameter parameter) throws ParseException {
    readBuffer.pullContext("S7Payload");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    S7PayloadBuilder builder = null;
    if (EvaluationHelper.equals(parameter.getParameterType(), (short) 0x04)
        && EvaluationHelper.equals(messageType, (short) 0x03)) {
      builder =
          S7PayloadReadVarResponse.staticParseS7PayloadBuilder(readBuffer, messageType, parameter);
    } else if (EvaluationHelper.equals(parameter.getParameterType(), (short) 0x05)
        && EvaluationHelper.equals(messageType, (short) 0x01)) {
      builder =
          S7PayloadWriteVarRequest.staticParseS7PayloadBuilder(readBuffer, messageType, parameter);
    } else if (EvaluationHelper.equals(parameter.getParameterType(), (short) 0x05)
        && EvaluationHelper.equals(messageType, (short) 0x03)) {
      builder =
          S7PayloadWriteVarResponse.staticParseS7PayloadBuilder(readBuffer, messageType, parameter);
    } else if (EvaluationHelper.equals(parameter.getParameterType(), (short) 0x00)
        && EvaluationHelper.equals(messageType, (short) 0x07)) {
      builder = S7PayloadUserData.staticParseS7PayloadBuilder(readBuffer, messageType, parameter);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "parameterparameterType="
              + parameter.getParameterType()
              + " "
              + "messageType="
              + messageType
              + "]");
    }

    readBuffer.closeContext("S7Payload");
    // Create the instance
    S7Payload _s7Payload = builder.build();
    return _s7Payload;
  }

  public interface S7PayloadBuilder {
    S7Payload build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7Payload)) {
      return false;
    }
    S7Payload that = (S7Payload) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
