/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvManagementAddress extends LldpUnit implements Message {

  // Accessors for discriminator values.
  public TlvType getTlvId() {
    return TlvType.MANAGEMENT_ADDRESS;
  }

  // Properties.
  protected final ManagementAddressSubType addressSubType;
  protected final IpAddress ipAddress;
  protected final short interfaceSubType;
  protected final long interfaceNumber;
  protected final short oidStringLength;

  public TlvManagementAddress(
      short tlvIdLength,
      ManagementAddressSubType addressSubType,
      IpAddress ipAddress,
      short interfaceSubType,
      long interfaceNumber,
      short oidStringLength) {
    super(tlvIdLength);
    this.addressSubType = addressSubType;
    this.ipAddress = ipAddress;
    this.interfaceSubType = interfaceSubType;
    this.interfaceNumber = interfaceNumber;
    this.oidStringLength = oidStringLength;
  }

  public ManagementAddressSubType getAddressSubType() {
    return addressSubType;
  }

  public IpAddress getIpAddress() {
    return ipAddress;
  }

  public short getInterfaceSubType() {
    return interfaceSubType;
  }

  public long getInterfaceNumber() {
    return interfaceNumber;
  }

  public short getOidStringLength() {
    return oidStringLength;
  }

  @Override
  protected void serializeLldpUnitChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvManagementAddress");

    // Implicit Field (addressStringLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short addressStringLength = (short) (5);
    writeImplicitField(
        "addressStringLength", addressStringLength, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (addressSubType)
    writeSimpleEnumField(
        "addressSubType",
        "ManagementAddressSubType",
        addressSubType,
        new DataWriterEnumDefault<>(
            ManagementAddressSubType::getValue,
            ManagementAddressSubType::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (ipAddress)
    writeSimpleField("ipAddress", ipAddress, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (interfaceSubType)
    writeSimpleField("interfaceSubType", interfaceSubType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (interfaceNumber)
    writeSimpleField("interfaceNumber", interfaceNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (oidStringLength)
    writeSimpleField("oidStringLength", oidStringLength, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("TlvManagementAddress");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvManagementAddress _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (addressStringLength)
    lengthInBits += 8;

    // Simple field (addressSubType)
    lengthInBits += 8;

    // Simple field (ipAddress)
    lengthInBits += ipAddress.getLengthInBits();

    // Simple field (interfaceSubType)
    lengthInBits += 8;

    // Simple field (interfaceNumber)
    lengthInBits += 32;

    // Simple field (oidStringLength)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static LldpUnitBuilder staticParseLldpUnitBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("TlvManagementAddress");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short addressStringLength =
        readImplicitField("addressStringLength", readUnsignedShort(readBuffer, 8));

    ManagementAddressSubType addressSubType =
        readEnumField(
            "addressSubType",
            "ManagementAddressSubType",
            new DataReaderEnumDefault<>(
                ManagementAddressSubType::enumForValue, readUnsignedShort(readBuffer, 8)));

    IpAddress ipAddress =
        readSimpleField(
            "ipAddress",
            new DataReaderComplexDefault<>(() -> IpAddress.staticParse(readBuffer), readBuffer));

    short interfaceSubType = readSimpleField("interfaceSubType", readUnsignedShort(readBuffer, 8));

    long interfaceNumber = readSimpleField("interfaceNumber", readUnsignedLong(readBuffer, 32));

    short oidStringLength = readSimpleField("oidStringLength", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("TlvManagementAddress");
    // Create the instance
    return new TlvManagementAddressBuilderImpl(
        addressSubType, ipAddress, interfaceSubType, interfaceNumber, oidStringLength);
  }

  public static class TlvManagementAddressBuilderImpl implements LldpUnit.LldpUnitBuilder {
    private final ManagementAddressSubType addressSubType;
    private final IpAddress ipAddress;
    private final short interfaceSubType;
    private final long interfaceNumber;
    private final short oidStringLength;

    public TlvManagementAddressBuilderImpl(
        ManagementAddressSubType addressSubType,
        IpAddress ipAddress,
        short interfaceSubType,
        long interfaceNumber,
        short oidStringLength) {
      this.addressSubType = addressSubType;
      this.ipAddress = ipAddress;
      this.interfaceSubType = interfaceSubType;
      this.interfaceNumber = interfaceNumber;
      this.oidStringLength = oidStringLength;
    }

    public TlvManagementAddress build(short tlvIdLength) {
      TlvManagementAddress tlvManagementAddress =
          new TlvManagementAddress(
              tlvIdLength,
              addressSubType,
              ipAddress,
              interfaceSubType,
              interfaceNumber,
              oidStringLength);
      return tlvManagementAddress;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvManagementAddress)) {
      return false;
    }
    TlvManagementAddress that = (TlvManagementAddress) o;
    return (getAddressSubType() == that.getAddressSubType())
        && (getIpAddress() == that.getIpAddress())
        && (getInterfaceSubType() == that.getInterfaceSubType())
        && (getInterfaceNumber() == that.getInterfaceNumber())
        && (getOidStringLength() == that.getOidStringLength())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getAddressSubType(),
        getIpAddress(),
        getInterfaceSubType(),
        getInterfaceNumber(),
        getOidStringLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
