/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_Block_IoCrReq extends PnIoCm_Block implements Message {

  // Accessors for discriminator values.
  public PnIoCm_BlockType getBlockType() {
    return PnIoCm_BlockType.IO_CR_BLOCK_REQ;
  }

  // Properties.
  protected final short blockVersionHigh;
  protected final short blockVersionLow;
  protected final PnIoCm_IoCrType ioCrType;
  protected final int ioCrReference;
  protected final int lt;
  protected final boolean fullSubFrameStructure;
  protected final boolean distributedSubFrameWatchDog;
  protected final boolean fastForwardingMacAdr;
  protected final boolean mediaRedundancy;
  protected final PnIoCm_RtClass rtClass;
  protected final int dataLength;
  protected final int frameId;
  protected final int sendClockFactor;
  protected final int reductionRatio;
  protected final int phase;
  protected final int sequence;
  protected final long frameSendOffset;
  protected final int watchDogFactor;
  protected final int dataHoldFactor;
  protected final int ioCrTagHeader;
  protected final MacAddress ioCrMulticastMacAdr;
  protected final List<PnIoCm_IoCrBlockReqApi> apis;

  // Reserved Fields
  private Integer reservedField0;
  private Byte reservedField1;

  public PnIoCm_Block_IoCrReq(
      short blockVersionHigh,
      short blockVersionLow,
      PnIoCm_IoCrType ioCrType,
      int ioCrReference,
      int lt,
      boolean fullSubFrameStructure,
      boolean distributedSubFrameWatchDog,
      boolean fastForwardingMacAdr,
      boolean mediaRedundancy,
      PnIoCm_RtClass rtClass,
      int dataLength,
      int frameId,
      int sendClockFactor,
      int reductionRatio,
      int phase,
      int sequence,
      long frameSendOffset,
      int watchDogFactor,
      int dataHoldFactor,
      int ioCrTagHeader,
      MacAddress ioCrMulticastMacAdr,
      List<PnIoCm_IoCrBlockReqApi> apis) {
    super();
    this.blockVersionHigh = blockVersionHigh;
    this.blockVersionLow = blockVersionLow;
    this.ioCrType = ioCrType;
    this.ioCrReference = ioCrReference;
    this.lt = lt;
    this.fullSubFrameStructure = fullSubFrameStructure;
    this.distributedSubFrameWatchDog = distributedSubFrameWatchDog;
    this.fastForwardingMacAdr = fastForwardingMacAdr;
    this.mediaRedundancy = mediaRedundancy;
    this.rtClass = rtClass;
    this.dataLength = dataLength;
    this.frameId = frameId;
    this.sendClockFactor = sendClockFactor;
    this.reductionRatio = reductionRatio;
    this.phase = phase;
    this.sequence = sequence;
    this.frameSendOffset = frameSendOffset;
    this.watchDogFactor = watchDogFactor;
    this.dataHoldFactor = dataHoldFactor;
    this.ioCrTagHeader = ioCrTagHeader;
    this.ioCrMulticastMacAdr = ioCrMulticastMacAdr;
    this.apis = apis;
  }

  public short getBlockVersionHigh() {
    return blockVersionHigh;
  }

  public short getBlockVersionLow() {
    return blockVersionLow;
  }

  public PnIoCm_IoCrType getIoCrType() {
    return ioCrType;
  }

  public int getIoCrReference() {
    return ioCrReference;
  }

  public int getLt() {
    return lt;
  }

  public boolean getFullSubFrameStructure() {
    return fullSubFrameStructure;
  }

  public boolean getDistributedSubFrameWatchDog() {
    return distributedSubFrameWatchDog;
  }

  public boolean getFastForwardingMacAdr() {
    return fastForwardingMacAdr;
  }

  public boolean getMediaRedundancy() {
    return mediaRedundancy;
  }

  public PnIoCm_RtClass getRtClass() {
    return rtClass;
  }

  public int getDataLength() {
    return dataLength;
  }

  public int getFrameId() {
    return frameId;
  }

  public int getSendClockFactor() {
    return sendClockFactor;
  }

  public int getReductionRatio() {
    return reductionRatio;
  }

  public int getPhase() {
    return phase;
  }

  public int getSequence() {
    return sequence;
  }

  public long getFrameSendOffset() {
    return frameSendOffset;
  }

  public int getWatchDogFactor() {
    return watchDogFactor;
  }

  public int getDataHoldFactor() {
    return dataHoldFactor;
  }

  public int getIoCrTagHeader() {
    return ioCrTagHeader;
  }

  public MacAddress getIoCrMulticastMacAdr() {
    return ioCrMulticastMacAdr;
  }

  public List<PnIoCm_IoCrBlockReqApi> getApis() {
    return apis;
  }

  @Override
  protected void serializePnIoCm_BlockChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_Block_IoCrReq");

    // Implicit Field (blockLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int blockLength = (int) ((getLengthInBytes()) - (4));
    writeImplicitField(
        "blockLength",
        blockLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (blockVersionHigh)
    writeSimpleField(
        "blockVersionHigh",
        blockVersionHigh,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (blockVersionLow)
    writeSimpleField(
        "blockVersionLow",
        blockVersionLow,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ioCrType)
    writeSimpleEnumField(
        "ioCrType",
        "PnIoCm_IoCrType",
        ioCrType,
        new DataWriterEnumDefault<>(
            PnIoCm_IoCrType::getValue, PnIoCm_IoCrType::name, writeUnsignedInt(writeBuffer, 16)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ioCrReference)
    writeSimpleField(
        "ioCrReference",
        ioCrReference,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (lt)
    writeSimpleField(
        "lt",
        lt,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (fullSubFrameStructure)
    writeSimpleField(
        "fullSubFrameStructure",
        fullSubFrameStructure,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (distributedSubFrameWatchDog)
    writeSimpleField(
        "distributedSubFrameWatchDog",
        distributedSubFrameWatchDog,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (fastForwardingMacAdr)
    writeSimpleField(
        "fastForwardingMacAdr",
        fastForwardingMacAdr,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (int) 0x0000,
        writeUnsignedInt(writeBuffer, 17),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (mediaRedundancy)
    writeSimpleField(
        "mediaRedundancy",
        mediaRedundancy,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 7),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (rtClass)
    writeSimpleEnumField(
        "rtClass",
        "PnIoCm_RtClass",
        rtClass,
        new DataWriterEnumDefault<>(
            PnIoCm_RtClass::getValue, PnIoCm_RtClass::name, writeUnsignedByte(writeBuffer, 4)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (dataLength)
    writeSimpleField(
        "dataLength",
        dataLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (frameId)
    writeSimpleField(
        "frameId",
        frameId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (sendClockFactor)
    writeSimpleField(
        "sendClockFactor",
        sendClockFactor,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (reductionRatio)
    writeSimpleField(
        "reductionRatio",
        reductionRatio,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (phase)
    writeSimpleField(
        "phase",
        phase,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (sequence)
    writeSimpleField(
        "sequence",
        sequence,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (frameSendOffset)
    writeSimpleField(
        "frameSendOffset",
        frameSendOffset,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (watchDogFactor)
    writeSimpleField(
        "watchDogFactor",
        watchDogFactor,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (dataHoldFactor)
    writeSimpleField(
        "dataHoldFactor",
        dataHoldFactor,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ioCrTagHeader)
    writeSimpleField(
        "ioCrTagHeader",
        ioCrTagHeader,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ioCrMulticastMacAdr)
    writeSimpleField(
        "ioCrMulticastMacAdr",
        ioCrMulticastMacAdr,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (numberOfApis) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numberOfApis = (int) (COUNT(getApis()));
    writeImplicitField(
        "numberOfApis",
        numberOfApis,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (apis)
    writeComplexTypeArrayField(
        "apis", apis, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_Block_IoCrReq");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnIoCm_Block_IoCrReq _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (blockLength)
    lengthInBits += 16;

    // Simple field (blockVersionHigh)
    lengthInBits += 8;

    // Simple field (blockVersionLow)
    lengthInBits += 8;

    // Simple field (ioCrType)
    lengthInBits += 16;

    // Simple field (ioCrReference)
    lengthInBits += 16;

    // Simple field (lt)
    lengthInBits += 16;

    // Simple field (fullSubFrameStructure)
    lengthInBits += 1;

    // Simple field (distributedSubFrameWatchDog)
    lengthInBits += 1;

    // Simple field (fastForwardingMacAdr)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 17;

    // Simple field (mediaRedundancy)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (rtClass)
    lengthInBits += 4;

    // Simple field (dataLength)
    lengthInBits += 16;

    // Simple field (frameId)
    lengthInBits += 16;

    // Simple field (sendClockFactor)
    lengthInBits += 16;

    // Simple field (reductionRatio)
    lengthInBits += 16;

    // Simple field (phase)
    lengthInBits += 16;

    // Simple field (sequence)
    lengthInBits += 16;

    // Simple field (frameSendOffset)
    lengthInBits += 32;

    // Simple field (watchDogFactor)
    lengthInBits += 16;

    // Simple field (dataHoldFactor)
    lengthInBits += 16;

    // Simple field (ioCrTagHeader)
    lengthInBits += 16;

    // Simple field (ioCrMulticastMacAdr)
    lengthInBits += ioCrMulticastMacAdr.getLengthInBits();

    // Implicit Field (numberOfApis)
    lengthInBits += 16;

    // Array field
    if (apis != null) {
      int i = 0;
      for (PnIoCm_IoCrBlockReqApi element : apis) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= apis.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnIoCm_BlockBuilder staticParsePnIoCm_BlockBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_Block_IoCrReq");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockLength =
        readImplicitField(
            "blockLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short blockVersionHigh =
        readSimpleField(
            "blockVersionHigh",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short blockVersionLow =
        readSimpleField(
            "blockVersionLow",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_IoCrType ioCrType =
        readEnumField(
            "ioCrType",
            "PnIoCm_IoCrType",
            new DataReaderEnumDefault<>(
                PnIoCm_IoCrType::enumForValue, readUnsignedInt(readBuffer, 16)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int ioCrReference =
        readSimpleField(
            "ioCrReference",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int lt =
        readSimpleField(
            "lt", readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean fullSubFrameStructure =
        readSimpleField(
            "fullSubFrameStructure",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean distributedSubFrameWatchDog =
        readSimpleField(
            "distributedSubFrameWatchDog",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean fastForwardingMacAdr =
        readSimpleField(
            "fastForwardingMacAdr",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Integer reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedInt(readBuffer, 17),
            (int) 0x0000,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean mediaRedundancy =
        readSimpleField(
            "mediaRedundancy",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Byte reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedByte(readBuffer, 7),
            (byte) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_RtClass rtClass =
        readEnumField(
            "rtClass",
            "PnIoCm_RtClass",
            new DataReaderEnumDefault<>(
                PnIoCm_RtClass::enumForValue, readUnsignedByte(readBuffer, 4)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int dataLength =
        readSimpleField(
            "dataLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int frameId =
        readSimpleField(
            "frameId",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int sendClockFactor =
        readSimpleField(
            "sendClockFactor",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int reductionRatio =
        readSimpleField(
            "reductionRatio",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int phase =
        readSimpleField(
            "phase",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int sequence =
        readSimpleField(
            "sequence",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long frameSendOffset =
        readSimpleField(
            "frameSendOffset",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int watchDogFactor =
        readSimpleField(
            "watchDogFactor",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int dataHoldFactor =
        readSimpleField(
            "dataHoldFactor",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int ioCrTagHeader =
        readSimpleField(
            "ioCrTagHeader",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    MacAddress ioCrMulticastMacAdr =
        readSimpleField(
            "ioCrMulticastMacAdr",
            new DataReaderComplexDefault<>(() -> MacAddress.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int numberOfApis =
        readImplicitField(
            "numberOfApis",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnIoCm_IoCrBlockReqApi> apis =
        readCountArrayField(
            "apis",
            new DataReaderComplexDefault<>(
                () -> PnIoCm_IoCrBlockReqApi.staticParse(readBuffer), readBuffer),
            numberOfApis,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_Block_IoCrReq");
    // Create the instance
    return new PnIoCm_Block_IoCrReqBuilderImpl(
        blockVersionHigh,
        blockVersionLow,
        ioCrType,
        ioCrReference,
        lt,
        fullSubFrameStructure,
        distributedSubFrameWatchDog,
        fastForwardingMacAdr,
        mediaRedundancy,
        rtClass,
        dataLength,
        frameId,
        sendClockFactor,
        reductionRatio,
        phase,
        sequence,
        frameSendOffset,
        watchDogFactor,
        dataHoldFactor,
        ioCrTagHeader,
        ioCrMulticastMacAdr,
        apis,
        reservedField0,
        reservedField1);
  }

  public static class PnIoCm_Block_IoCrReqBuilderImpl implements PnIoCm_Block.PnIoCm_BlockBuilder {
    private final short blockVersionHigh;
    private final short blockVersionLow;
    private final PnIoCm_IoCrType ioCrType;
    private final int ioCrReference;
    private final int lt;
    private final boolean fullSubFrameStructure;
    private final boolean distributedSubFrameWatchDog;
    private final boolean fastForwardingMacAdr;
    private final boolean mediaRedundancy;
    private final PnIoCm_RtClass rtClass;
    private final int dataLength;
    private final int frameId;
    private final int sendClockFactor;
    private final int reductionRatio;
    private final int phase;
    private final int sequence;
    private final long frameSendOffset;
    private final int watchDogFactor;
    private final int dataHoldFactor;
    private final int ioCrTagHeader;
    private final MacAddress ioCrMulticastMacAdr;
    private final List<PnIoCm_IoCrBlockReqApi> apis;
    private final Integer reservedField0;
    private final Byte reservedField1;

    public PnIoCm_Block_IoCrReqBuilderImpl(
        short blockVersionHigh,
        short blockVersionLow,
        PnIoCm_IoCrType ioCrType,
        int ioCrReference,
        int lt,
        boolean fullSubFrameStructure,
        boolean distributedSubFrameWatchDog,
        boolean fastForwardingMacAdr,
        boolean mediaRedundancy,
        PnIoCm_RtClass rtClass,
        int dataLength,
        int frameId,
        int sendClockFactor,
        int reductionRatio,
        int phase,
        int sequence,
        long frameSendOffset,
        int watchDogFactor,
        int dataHoldFactor,
        int ioCrTagHeader,
        MacAddress ioCrMulticastMacAdr,
        List<PnIoCm_IoCrBlockReqApi> apis,
        Integer reservedField0,
        Byte reservedField1) {
      this.blockVersionHigh = blockVersionHigh;
      this.blockVersionLow = blockVersionLow;
      this.ioCrType = ioCrType;
      this.ioCrReference = ioCrReference;
      this.lt = lt;
      this.fullSubFrameStructure = fullSubFrameStructure;
      this.distributedSubFrameWatchDog = distributedSubFrameWatchDog;
      this.fastForwardingMacAdr = fastForwardingMacAdr;
      this.mediaRedundancy = mediaRedundancy;
      this.rtClass = rtClass;
      this.dataLength = dataLength;
      this.frameId = frameId;
      this.sendClockFactor = sendClockFactor;
      this.reductionRatio = reductionRatio;
      this.phase = phase;
      this.sequence = sequence;
      this.frameSendOffset = frameSendOffset;
      this.watchDogFactor = watchDogFactor;
      this.dataHoldFactor = dataHoldFactor;
      this.ioCrTagHeader = ioCrTagHeader;
      this.ioCrMulticastMacAdr = ioCrMulticastMacAdr;
      this.apis = apis;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public PnIoCm_Block_IoCrReq build() {
      PnIoCm_Block_IoCrReq pnIoCm_Block_IoCrReq =
          new PnIoCm_Block_IoCrReq(
              blockVersionHigh,
              blockVersionLow,
              ioCrType,
              ioCrReference,
              lt,
              fullSubFrameStructure,
              distributedSubFrameWatchDog,
              fastForwardingMacAdr,
              mediaRedundancy,
              rtClass,
              dataLength,
              frameId,
              sendClockFactor,
              reductionRatio,
              phase,
              sequence,
              frameSendOffset,
              watchDogFactor,
              dataHoldFactor,
              ioCrTagHeader,
              ioCrMulticastMacAdr,
              apis);
      pnIoCm_Block_IoCrReq.reservedField0 = reservedField0;
      pnIoCm_Block_IoCrReq.reservedField1 = reservedField1;
      return pnIoCm_Block_IoCrReq;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_Block_IoCrReq)) {
      return false;
    }
    PnIoCm_Block_IoCrReq that = (PnIoCm_Block_IoCrReq) o;
    return (getBlockVersionHigh() == that.getBlockVersionHigh())
        && (getBlockVersionLow() == that.getBlockVersionLow())
        && (getIoCrType() == that.getIoCrType())
        && (getIoCrReference() == that.getIoCrReference())
        && (getLt() == that.getLt())
        && (getFullSubFrameStructure() == that.getFullSubFrameStructure())
        && (getDistributedSubFrameWatchDog() == that.getDistributedSubFrameWatchDog())
        && (getFastForwardingMacAdr() == that.getFastForwardingMacAdr())
        && (getMediaRedundancy() == that.getMediaRedundancy())
        && (getRtClass() == that.getRtClass())
        && (getDataLength() == that.getDataLength())
        && (getFrameId() == that.getFrameId())
        && (getSendClockFactor() == that.getSendClockFactor())
        && (getReductionRatio() == that.getReductionRatio())
        && (getPhase() == that.getPhase())
        && (getSequence() == that.getSequence())
        && (getFrameSendOffset() == that.getFrameSendOffset())
        && (getWatchDogFactor() == that.getWatchDogFactor())
        && (getDataHoldFactor() == that.getDataHoldFactor())
        && (getIoCrTagHeader() == that.getIoCrTagHeader())
        && (getIoCrMulticastMacAdr() == that.getIoCrMulticastMacAdr())
        && (getApis() == that.getApis())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getBlockVersionHigh(),
        getBlockVersionLow(),
        getIoCrType(),
        getIoCrReference(),
        getLt(),
        getFullSubFrameStructure(),
        getDistributedSubFrameWatchDog(),
        getFastForwardingMacAdr(),
        getMediaRedundancy(),
        getRtClass(),
        getDataLength(),
        getFrameId(),
        getSendClockFactor(),
        getReductionRatio(),
        getPhase(),
        getSequence(),
        getFrameSendOffset(),
        getWatchDogFactor(),
        getDataHoldFactor(),
        getIoCrTagHeader(),
        getIoCrMulticastMacAdr(),
        getApis());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
