/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "23603";
  }

  // Properties.
  protected final PascalString name;
  protected final int noOfSecurityGroupFolder;
  protected final List<PascalString> securityGroupFolder;
  protected final double keyLifetime;
  protected final PascalString securityPolicyUri;
  protected final long maxFutureKeyCount;
  protected final long maxPastKeyCount;
  protected final PascalString securityGroupId;
  protected final int noOfRolePermissions;
  protected final List<ExtensionObjectDefinition> rolePermissions;
  protected final int noOfGroupProperties;
  protected final List<ExtensionObjectDefinition> groupProperties;

  public SecurityGroupDataType(
      PascalString name,
      int noOfSecurityGroupFolder,
      List<PascalString> securityGroupFolder,
      double keyLifetime,
      PascalString securityPolicyUri,
      long maxFutureKeyCount,
      long maxPastKeyCount,
      PascalString securityGroupId,
      int noOfRolePermissions,
      List<ExtensionObjectDefinition> rolePermissions,
      int noOfGroupProperties,
      List<ExtensionObjectDefinition> groupProperties) {
    super();
    this.name = name;
    this.noOfSecurityGroupFolder = noOfSecurityGroupFolder;
    this.securityGroupFolder = securityGroupFolder;
    this.keyLifetime = keyLifetime;
    this.securityPolicyUri = securityPolicyUri;
    this.maxFutureKeyCount = maxFutureKeyCount;
    this.maxPastKeyCount = maxPastKeyCount;
    this.securityGroupId = securityGroupId;
    this.noOfRolePermissions = noOfRolePermissions;
    this.rolePermissions = rolePermissions;
    this.noOfGroupProperties = noOfGroupProperties;
    this.groupProperties = groupProperties;
  }

  public PascalString getName() {
    return name;
  }

  public int getNoOfSecurityGroupFolder() {
    return noOfSecurityGroupFolder;
  }

  public List<PascalString> getSecurityGroupFolder() {
    return securityGroupFolder;
  }

  public double getKeyLifetime() {
    return keyLifetime;
  }

  public PascalString getSecurityPolicyUri() {
    return securityPolicyUri;
  }

  public long getMaxFutureKeyCount() {
    return maxFutureKeyCount;
  }

  public long getMaxPastKeyCount() {
    return maxPastKeyCount;
  }

  public PascalString getSecurityGroupId() {
    return securityGroupId;
  }

  public int getNoOfRolePermissions() {
    return noOfRolePermissions;
  }

  public List<ExtensionObjectDefinition> getRolePermissions() {
    return rolePermissions;
  }

  public int getNoOfGroupProperties() {
    return noOfGroupProperties;
  }

  public List<ExtensionObjectDefinition> getGroupProperties() {
    return groupProperties;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityGroupDataType");

    // Simple Field (name)
    writeSimpleField("name", name, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfSecurityGroupFolder)
    writeSimpleField(
        "noOfSecurityGroupFolder", noOfSecurityGroupFolder, writeSignedInt(writeBuffer, 32));

    // Array Field (securityGroupFolder)
    writeComplexTypeArrayField("securityGroupFolder", securityGroupFolder, writeBuffer);

    // Simple Field (keyLifetime)
    writeSimpleField("keyLifetime", keyLifetime, writeDouble(writeBuffer, 64));

    // Simple Field (securityPolicyUri)
    writeSimpleField(
        "securityPolicyUri", securityPolicyUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (maxFutureKeyCount)
    writeSimpleField("maxFutureKeyCount", maxFutureKeyCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (maxPastKeyCount)
    writeSimpleField("maxPastKeyCount", maxPastKeyCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (securityGroupId)
    writeSimpleField(
        "securityGroupId", securityGroupId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfRolePermissions)
    writeSimpleField("noOfRolePermissions", noOfRolePermissions, writeSignedInt(writeBuffer, 32));

    // Array Field (rolePermissions)
    writeComplexTypeArrayField("rolePermissions", rolePermissions, writeBuffer);

    // Simple Field (noOfGroupProperties)
    writeSimpleField("noOfGroupProperties", noOfGroupProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (groupProperties)
    writeComplexTypeArrayField("groupProperties", groupProperties, writeBuffer);

    writeBuffer.popContext("SecurityGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SecurityGroupDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Simple field (noOfSecurityGroupFolder)
    lengthInBits += 32;

    // Array field
    if (securityGroupFolder != null) {
      int i = 0;
      for (PascalString element : securityGroupFolder) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityGroupFolder.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (keyLifetime)
    lengthInBits += 64;

    // Simple field (securityPolicyUri)
    lengthInBits += securityPolicyUri.getLengthInBits();

    // Simple field (maxFutureKeyCount)
    lengthInBits += 32;

    // Simple field (maxPastKeyCount)
    lengthInBits += 32;

    // Simple field (securityGroupId)
    lengthInBits += securityGroupId.getLengthInBits();

    // Simple field (noOfRolePermissions)
    lengthInBits += 32;

    // Array field
    if (rolePermissions != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : rolePermissions) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= rolePermissions.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfGroupProperties)
    lengthInBits += 32;

    // Array field
    if (groupProperties != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : groupProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= groupProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("SecurityGroupDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfSecurityGroupFolder =
        readSimpleField("noOfSecurityGroupFolder", readSignedInt(readBuffer, 32));

    List<PascalString> securityGroupFolder =
        readCountArrayField(
            "securityGroupFolder",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfSecurityGroupFolder);

    double keyLifetime = readSimpleField("keyLifetime", readDouble(readBuffer, 64));

    PascalString securityPolicyUri =
        readSimpleField(
            "securityPolicyUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    long maxFutureKeyCount = readSimpleField("maxFutureKeyCount", readUnsignedLong(readBuffer, 32));

    long maxPastKeyCount = readSimpleField("maxPastKeyCount", readUnsignedLong(readBuffer, 32));

    PascalString securityGroupId =
        readSimpleField(
            "securityGroupId",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRolePermissions = readSimpleField("noOfRolePermissions", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> rolePermissions =
        readCountArrayField(
            "rolePermissions",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("98")),
                readBuffer),
            noOfRolePermissions);

    int noOfGroupProperties = readSimpleField("noOfGroupProperties", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> groupProperties =
        readCountArrayField(
            "groupProperties",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("14535")),
                readBuffer),
            noOfGroupProperties);

    readBuffer.closeContext("SecurityGroupDataType");
    // Create the instance
    return new SecurityGroupDataTypeBuilderImpl(
        name,
        noOfSecurityGroupFolder,
        securityGroupFolder,
        keyLifetime,
        securityPolicyUri,
        maxFutureKeyCount,
        maxPastKeyCount,
        securityGroupId,
        noOfRolePermissions,
        rolePermissions,
        noOfGroupProperties,
        groupProperties);
  }

  public static class SecurityGroupDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final int noOfSecurityGroupFolder;
    private final List<PascalString> securityGroupFolder;
    private final double keyLifetime;
    private final PascalString securityPolicyUri;
    private final long maxFutureKeyCount;
    private final long maxPastKeyCount;
    private final PascalString securityGroupId;
    private final int noOfRolePermissions;
    private final List<ExtensionObjectDefinition> rolePermissions;
    private final int noOfGroupProperties;
    private final List<ExtensionObjectDefinition> groupProperties;

    public SecurityGroupDataTypeBuilderImpl(
        PascalString name,
        int noOfSecurityGroupFolder,
        List<PascalString> securityGroupFolder,
        double keyLifetime,
        PascalString securityPolicyUri,
        long maxFutureKeyCount,
        long maxPastKeyCount,
        PascalString securityGroupId,
        int noOfRolePermissions,
        List<ExtensionObjectDefinition> rolePermissions,
        int noOfGroupProperties,
        List<ExtensionObjectDefinition> groupProperties) {
      this.name = name;
      this.noOfSecurityGroupFolder = noOfSecurityGroupFolder;
      this.securityGroupFolder = securityGroupFolder;
      this.keyLifetime = keyLifetime;
      this.securityPolicyUri = securityPolicyUri;
      this.maxFutureKeyCount = maxFutureKeyCount;
      this.maxPastKeyCount = maxPastKeyCount;
      this.securityGroupId = securityGroupId;
      this.noOfRolePermissions = noOfRolePermissions;
      this.rolePermissions = rolePermissions;
      this.noOfGroupProperties = noOfGroupProperties;
      this.groupProperties = groupProperties;
    }

    public SecurityGroupDataType build() {
      SecurityGroupDataType securityGroupDataType =
          new SecurityGroupDataType(
              name,
              noOfSecurityGroupFolder,
              securityGroupFolder,
              keyLifetime,
              securityPolicyUri,
              maxFutureKeyCount,
              maxPastKeyCount,
              securityGroupId,
              noOfRolePermissions,
              rolePermissions,
              noOfGroupProperties,
              groupProperties);
      return securityGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityGroupDataType)) {
      return false;
    }
    SecurityGroupDataType that = (SecurityGroupDataType) o;
    return (getName() == that.getName())
        && (getNoOfSecurityGroupFolder() == that.getNoOfSecurityGroupFolder())
        && (getSecurityGroupFolder() == that.getSecurityGroupFolder())
        && (getKeyLifetime() == that.getKeyLifetime())
        && (getSecurityPolicyUri() == that.getSecurityPolicyUri())
        && (getMaxFutureKeyCount() == that.getMaxFutureKeyCount())
        && (getMaxPastKeyCount() == that.getMaxPastKeyCount())
        && (getSecurityGroupId() == that.getSecurityGroupId())
        && (getNoOfRolePermissions() == that.getNoOfRolePermissions())
        && (getRolePermissions() == that.getRolePermissions())
        && (getNoOfGroupProperties() == that.getNoOfGroupProperties())
        && (getGroupProperties() == that.getGroupProperties())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getNoOfSecurityGroupFolder(),
        getSecurityGroupFolder(),
        getKeyLifetime(),
        getSecurityPolicyUri(),
        getMaxFutureKeyCount(),
        getMaxPastKeyCount(),
        getSecurityGroupId(),
        getNoOfRolePermissions(),
        getRolePermissions(),
        getNoOfGroupProperties(),
        getGroupProperties());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
