/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PubSubConfigurationRefDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "25521";
  }

  // Properties.
  protected final PubSubConfigurationRefMask configurationMask;
  protected final int elementIndex;
  protected final int connectionIndex;
  protected final int groupIndex;

  public PubSubConfigurationRefDataType(
      PubSubConfigurationRefMask configurationMask,
      int elementIndex,
      int connectionIndex,
      int groupIndex) {
    super();
    this.configurationMask = configurationMask;
    this.elementIndex = elementIndex;
    this.connectionIndex = connectionIndex;
    this.groupIndex = groupIndex;
  }

  public PubSubConfigurationRefMask getConfigurationMask() {
    return configurationMask;
  }

  public int getElementIndex() {
    return elementIndex;
  }

  public int getConnectionIndex() {
    return connectionIndex;
  }

  public int getGroupIndex() {
    return groupIndex;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PubSubConfigurationRefDataType");

    // Simple Field (configurationMask)
    writeSimpleEnumField(
        "configurationMask",
        "PubSubConfigurationRefMask",
        configurationMask,
        new DataWriterEnumDefault<>(
            PubSubConfigurationRefMask::getValue,
            PubSubConfigurationRefMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (elementIndex)
    writeSimpleField("elementIndex", elementIndex, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (connectionIndex)
    writeSimpleField("connectionIndex", connectionIndex, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (groupIndex)
    writeSimpleField("groupIndex", groupIndex, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("PubSubConfigurationRefDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PubSubConfigurationRefDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (configurationMask)
    lengthInBits += 32;

    // Simple field (elementIndex)
    lengthInBits += 16;

    // Simple field (connectionIndex)
    lengthInBits += 16;

    // Simple field (groupIndex)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("PubSubConfigurationRefDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PubSubConfigurationRefMask configurationMask =
        readEnumField(
            "configurationMask",
            "PubSubConfigurationRefMask",
            new DataReaderEnumDefault<>(
                PubSubConfigurationRefMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    int elementIndex = readSimpleField("elementIndex", readUnsignedInt(readBuffer, 16));

    int connectionIndex = readSimpleField("connectionIndex", readUnsignedInt(readBuffer, 16));

    int groupIndex = readSimpleField("groupIndex", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("PubSubConfigurationRefDataType");
    // Create the instance
    return new PubSubConfigurationRefDataTypeBuilderImpl(
        configurationMask, elementIndex, connectionIndex, groupIndex);
  }

  public static class PubSubConfigurationRefDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PubSubConfigurationRefMask configurationMask;
    private final int elementIndex;
    private final int connectionIndex;
    private final int groupIndex;

    public PubSubConfigurationRefDataTypeBuilderImpl(
        PubSubConfigurationRefMask configurationMask,
        int elementIndex,
        int connectionIndex,
        int groupIndex) {
      this.configurationMask = configurationMask;
      this.elementIndex = elementIndex;
      this.connectionIndex = connectionIndex;
      this.groupIndex = groupIndex;
    }

    public PubSubConfigurationRefDataType build() {
      PubSubConfigurationRefDataType pubSubConfigurationRefDataType =
          new PubSubConfigurationRefDataType(
              configurationMask, elementIndex, connectionIndex, groupIndex);
      return pubSubConfigurationRefDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PubSubConfigurationRefDataType)) {
      return false;
    }
    PubSubConfigurationRefDataType that = (PubSubConfigurationRefDataType) o;
    return (getConfigurationMask() == that.getConfigurationMask())
        && (getElementIndex() == that.getElementIndex())
        && (getConnectionIndex() == that.getConnectionIndex())
        && (getGroupIndex() == that.getGroupIndex())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getConfigurationMask(),
        getElementIndex(),
        getConnectionIndex(),
        getGroupIndex());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
