/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_SEGMENT extends InformationObjectWithoutTime
    implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.SEGMENT;
  }

  // Properties.
  protected final NameOfFile nof;
  protected final NameOfSection nos;
  protected final LengthOfSegment los;

  public InformationObjectWithoutTime_SEGMENT(
      int address, NameOfFile nof, NameOfSection nos, LengthOfSegment los) {
    super(address);
    this.nof = nof;
    this.nos = nos;
    this.los = los;
  }

  public NameOfFile getNof() {
    return nof;
  }

  public NameOfSection getNos() {
    return nos;
  }

  public LengthOfSegment getLos() {
    return los;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_SEGMENT");

    // Simple Field (nof)
    writeSimpleField(
        "nof",
        nof,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (nos)
    writeSimpleField(
        "nos",
        nos,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (los)
    writeSimpleField(
        "los",
        los,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_SEGMENT");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_SEGMENT _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nof)
    lengthInBits += nof.getLengthInBits();

    // Simple field (nos)
    lengthInBits += nos.getLengthInBits();

    // Simple field (los)
    lengthInBits += los.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_SEGMENT");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NameOfFile nof =
        readSimpleField(
            "nof",
            new DataReaderComplexDefault<>(() -> NameOfFile.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    NameOfSection nos =
        readSimpleField(
            "nos",
            new DataReaderComplexDefault<>(() -> NameOfSection.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    LengthOfSegment los =
        readSimpleField(
            "los",
            new DataReaderComplexDefault<>(
                () -> LengthOfSegment.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_SEGMENT");
    // Create the instance
    return new InformationObjectWithoutTime_SEGMENTBuilderImpl(nof, nos, los);
  }

  public static class InformationObjectWithoutTime_SEGMENTBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final NameOfFile nof;
    private final NameOfSection nos;
    private final LengthOfSegment los;

    public InformationObjectWithoutTime_SEGMENTBuilderImpl(
        NameOfFile nof, NameOfSection nos, LengthOfSegment los) {
      this.nof = nof;
      this.nos = nos;
      this.los = los;
    }

    public InformationObjectWithoutTime_SEGMENT build(int address) {
      InformationObjectWithoutTime_SEGMENT informationObjectWithoutTime_SEGMENT =
          new InformationObjectWithoutTime_SEGMENT(address, nof, nos, los);
      return informationObjectWithoutTime_SEGMENT;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_SEGMENT)) {
      return false;
    }
    InformationObjectWithoutTime_SEGMENT that = (InformationObjectWithoutTime_SEGMENT) o;
    return (getNof() == that.getNof())
        && (getNos() == that.getNos())
        && (getLos() == that.getLos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNof(), getNos(), getLos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
