/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT
    extends InformationObjectWithoutTime implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.LAST_SECTION_LAST_SEGMENT;
  }

  // Properties.
  protected final NameOfFile nof;
  protected final NameOfSection nos;
  protected final LastSectionOrSegmentQualifier lsq;
  protected final Checksum chs;

  public InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT(
      int address,
      NameOfFile nof,
      NameOfSection nos,
      LastSectionOrSegmentQualifier lsq,
      Checksum chs) {
    super(address);
    this.nof = nof;
    this.nos = nos;
    this.lsq = lsq;
    this.chs = chs;
  }

  public NameOfFile getNof() {
    return nof;
  }

  public NameOfSection getNos() {
    return nos;
  }

  public LastSectionOrSegmentQualifier getLsq() {
    return lsq;
  }

  public Checksum getChs() {
    return chs;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT");

    // Simple Field (nof)
    writeSimpleField(
        "nof",
        nof,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (nos)
    writeSimpleField(
        "nos",
        nos,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (lsq)
    writeSimpleField(
        "lsq",
        lsq,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (chs)
    writeSimpleField(
        "chs",
        chs,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nof)
    lengthInBits += nof.getLengthInBits();

    // Simple field (nos)
    lengthInBits += nos.getLengthInBits();

    // Simple field (lsq)
    lengthInBits += lsq.getLengthInBits();

    // Simple field (chs)
    lengthInBits += chs.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NameOfFile nof =
        readSimpleField(
            "nof",
            new DataReaderComplexDefault<>(() -> NameOfFile.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    NameOfSection nos =
        readSimpleField(
            "nos",
            new DataReaderComplexDefault<>(() -> NameOfSection.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    LastSectionOrSegmentQualifier lsq =
        readSimpleField(
            "lsq",
            new DataReaderComplexDefault<>(
                () -> LastSectionOrSegmentQualifier.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Checksum chs =
        readSimpleField(
            "chs",
            new DataReaderComplexDefault<>(() -> Checksum.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT");
    // Create the instance
    return new InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENTBuilderImpl(
        nof, nos, lsq, chs);
  }

  public static class InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENTBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final NameOfFile nof;
    private final NameOfSection nos;
    private final LastSectionOrSegmentQualifier lsq;
    private final Checksum chs;

    public InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENTBuilderImpl(
        NameOfFile nof, NameOfSection nos, LastSectionOrSegmentQualifier lsq, Checksum chs) {
      this.nof = nof;
      this.nos = nos;
      this.lsq = lsq;
      this.chs = chs;
    }

    public InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT build(int address) {
      InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT
          informationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT =
              new InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT(
                  address, nof, nos, lsq, chs);
      return informationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT)) {
      return false;
    }
    InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT that =
        (InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT) o;
    return (getNof() == that.getNof())
        && (getNos() == that.getNos())
        && (getLsq() == that.getLsq())
        && (getChs() == that.getChs())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNof(), getNos(), getLsq(), getChs());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
