/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_BITSTRING_OF_32_BIT extends InformationObjectWithoutTime
    implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.BITSTRING_OF_32_BIT;
  }

  // Properties.
  protected final BinaryStateInformation bsi;
  protected final QualityDescriptor qds;

  public InformationObjectWithoutTime_BITSTRING_OF_32_BIT(
      int address, BinaryStateInformation bsi, QualityDescriptor qds) {
    super(address);
    this.bsi = bsi;
    this.qds = qds;
  }

  public BinaryStateInformation getBsi() {
    return bsi;
  }

  public QualityDescriptor getQds() {
    return qds;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_BITSTRING_OF_32_BIT");

    // Simple Field (bsi)
    writeSimpleField(
        "bsi",
        bsi,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (qds)
    writeSimpleField(
        "qds",
        qds,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_BITSTRING_OF_32_BIT");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_BITSTRING_OF_32_BIT _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (bsi)
    lengthInBits += bsi.getLengthInBits();

    // Simple field (qds)
    lengthInBits += qds.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_BITSTRING_OF_32_BIT");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BinaryStateInformation bsi =
        readSimpleField(
            "bsi",
            new DataReaderComplexDefault<>(
                () -> BinaryStateInformation.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    QualityDescriptor qds =
        readSimpleField(
            "qds",
            new DataReaderComplexDefault<>(
                () -> QualityDescriptor.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_BITSTRING_OF_32_BIT");
    // Create the instance
    return new InformationObjectWithoutTime_BITSTRING_OF_32_BITBuilderImpl(bsi, qds);
  }

  public static class InformationObjectWithoutTime_BITSTRING_OF_32_BITBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final BinaryStateInformation bsi;
    private final QualityDescriptor qds;

    public InformationObjectWithoutTime_BITSTRING_OF_32_BITBuilderImpl(
        BinaryStateInformation bsi, QualityDescriptor qds) {
      this.bsi = bsi;
      this.qds = qds;
    }

    public InformationObjectWithoutTime_BITSTRING_OF_32_BIT build(int address) {
      InformationObjectWithoutTime_BITSTRING_OF_32_BIT
          informationObjectWithoutTime_BITSTRING_OF_32_BIT =
              new InformationObjectWithoutTime_BITSTRING_OF_32_BIT(address, bsi, qds);
      return informationObjectWithoutTime_BITSTRING_OF_32_BIT;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_BITSTRING_OF_32_BIT)) {
      return false;
    }
    InformationObjectWithoutTime_BITSTRING_OF_32_BIT that =
        (InformationObjectWithoutTime_BITSTRING_OF_32_BIT) o;
    return (getBsi() == that.getBsi()) && (getQds() == that.getQds()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getBsi(), getQds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
