/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class StatusByte implements Message {

  // Properties.
  protected final GAVState gav3;
  protected final GAVState gav2;
  protected final GAVState gav1;
  protected final GAVState gav0;

  public StatusByte(GAVState gav3, GAVState gav2, GAVState gav1, GAVState gav0) {
    super();
    this.gav3 = gav3;
    this.gav2 = gav2;
    this.gav1 = gav1;
    this.gav0 = gav0;
  }

  public GAVState getGav3() {
    return gav3;
  }

  public GAVState getGav2() {
    return gav2;
  }

  public GAVState getGav1() {
    return gav1;
  }

  public GAVState getGav0() {
    return gav0;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("StatusByte");

    // Simple Field (gav3)
    writeSimpleEnumField(
        "gav3",
        "GAVState",
        gav3,
        new DataWriterEnumDefault<>(
            GAVState::getValue, GAVState::name, writeUnsignedByte(writeBuffer, 2)));

    // Simple Field (gav2)
    writeSimpleEnumField(
        "gav2",
        "GAVState",
        gav2,
        new DataWriterEnumDefault<>(
            GAVState::getValue, GAVState::name, writeUnsignedByte(writeBuffer, 2)));

    // Simple Field (gav1)
    writeSimpleEnumField(
        "gav1",
        "GAVState",
        gav1,
        new DataWriterEnumDefault<>(
            GAVState::getValue, GAVState::name, writeUnsignedByte(writeBuffer, 2)));

    // Simple Field (gav0)
    writeSimpleEnumField(
        "gav0",
        "GAVState",
        gav0,
        new DataWriterEnumDefault<>(
            GAVState::getValue, GAVState::name, writeUnsignedByte(writeBuffer, 2)));

    writeBuffer.popContext("StatusByte");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    StatusByte _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (gav3)
    lengthInBits += 2;

    // Simple field (gav2)
    lengthInBits += 2;

    // Simple field (gav1)
    lengthInBits += 2;

    // Simple field (gav0)
    lengthInBits += 2;

    return lengthInBits;
  }

  public static StatusByte staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static StatusByte staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("StatusByte");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    GAVState gav3 =
        readEnumField(
            "gav3",
            "GAVState",
            new DataReaderEnumDefault<>(GAVState::enumForValue, readUnsignedByte(readBuffer, 2)));

    GAVState gav2 =
        readEnumField(
            "gav2",
            "GAVState",
            new DataReaderEnumDefault<>(GAVState::enumForValue, readUnsignedByte(readBuffer, 2)));

    GAVState gav1 =
        readEnumField(
            "gav1",
            "GAVState",
            new DataReaderEnumDefault<>(GAVState::enumForValue, readUnsignedByte(readBuffer, 2)));

    GAVState gav0 =
        readEnumField(
            "gav0",
            "GAVState",
            new DataReaderEnumDefault<>(GAVState::enumForValue, readUnsignedByte(readBuffer, 2)));

    readBuffer.closeContext("StatusByte");
    // Create the instance
    StatusByte _statusByte;
    _statusByte = new StatusByte(gav3, gav2, gav1, gav0);
    return _statusByte;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof StatusByte)) {
      return false;
    }
    StatusByte that = (StatusByte) o;
    return (getGav3() == that.getGav3())
        && (getGav2() == that.getGav2())
        && (getGav1() == that.getGav1())
        && (getGav0() == that.getGav0())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getGav3(), getGav2(), getGav1(), getGav0());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
