/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class SALData implements Message {

  // Abstract accessors for discriminator values.
  public abstract ApplicationId getApplicationId();

  // Properties.
  protected final SALData salData;

  public SALData(SALData salData) {
    super();
    this.salData = salData;
  }

  public SALData getSalData() {
    return salData;
  }

  protected abstract void serializeSALDataChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SALData");

    // Switch field (Serialize the sub-type)
    serializeSALDataChild(writeBuffer);

    // Optional Field (salData) (Can be skipped, if the value is null)
    writeOptionalField("salData", salData, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("SALData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SALData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    // Optional Field (salData)
    if (salData != null) {
      lengthInBits += salData.getLengthInBits();
    }

    return lengthInBits;
  }

  public static SALData staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    ApplicationId applicationId;
    if (args[0] instanceof ApplicationId) {
      applicationId = (ApplicationId) args[0];
    } else if (args[0] instanceof String) {
      applicationId = ApplicationId.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type ApplicationId or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, applicationId);
  }

  public static SALData staticParse(ReadBuffer readBuffer, ApplicationId applicationId)
      throws ParseException {
    readBuffer.pullContext("SALData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    SALDataBuilder builder = null;
    if (EvaluationHelper.equals(applicationId, ApplicationId.RESERVED)) {
      builder = SALDataReserved.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.FREE_USAGE)) {
      builder = SALDataFreeUsage.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.TEMPERATURE_BROADCAST)) {
      builder = SALDataTemperatureBroadcast.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.ROOM_CONTROL_SYSTEM)) {
      builder = SALDataRoomControlSystem.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.LIGHTING)) {
      builder = SALDataLighting.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.VENTILATION)) {
      builder = SALDataVentilation.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.IRRIGATION_CONTROL)) {
      builder = SALDataIrrigationControl.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(
        applicationId, ApplicationId.POOLS_SPAS_PONDS_FOUNTAINS_CONTROL)) {
      builder =
          SALDataPoolsSpasPondsFountainsControl.staticParseSALDataBuilder(
              readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.HEATING)) {
      builder = SALDataHeating.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.AIR_CONDITIONING)) {
      builder = SALDataAirConditioning.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.TRIGGER_CONTROL)) {
      builder = SALDataTriggerControl.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.ENABLE_CONTROL)) {
      builder = SALDataEnableControl.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.AUDIO_AND_VIDEO)) {
      builder = SALDataAudioAndVideo.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.SECURITY)) {
      builder = SALDataSecurity.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.METERING)) {
      builder = SALDataMetering.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.ACCESS_CONTROL)) {
      builder = SALDataAccessControl.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.CLOCK_AND_TIMEKEEPING)) {
      builder = SALDataClockAndTimekeeping.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.TELEPHONY_STATUS_AND_CONTROL)) {
      builder =
          SALDataTelephonyStatusAndControl.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.MEASUREMENT)) {
      builder = SALDataMeasurement.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.TESTING)) {
      builder = SALDataTesting.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.MEDIA_TRANSPORT_CONTROL)) {
      builder = SALDataMediaTransport.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.ERROR_REPORTING)) {
      builder = SALDataErrorReporting.staticParseSALDataBuilder(readBuffer, applicationId);
    } else if (EvaluationHelper.equals(applicationId, ApplicationId.HVAC_ACTUATOR)) {
      builder = SALDataHvacActuator.staticParseSALDataBuilder(readBuffer, applicationId);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "applicationId="
              + applicationId
              + "]");
    }

    SALData salData =
        readOptionalField(
            "salData",
            new DataReaderComplexDefault<>(
                () -> SALData.staticParse(readBuffer, (ApplicationId) (applicationId)),
                readBuffer));

    readBuffer.closeContext("SALData");
    // Create the instance
    SALData _sALData = builder.build(salData);
    return _sALData;
  }

  public interface SALDataBuilder {
    SALData build(SALData salData);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SALData)) {
      return false;
    }
    SALData that = (SALData) o;
    return (getSalData() == that.getSalData()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSalData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
