/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ParameterValueCustomTypes extends ParameterValue implements Message {

  // Accessors for discriminator values.
  public ParameterType getParameterType() {
    return ParameterType.CUSTOM_TYPE;
  }

  // Properties.
  protected final CustomTypes value;

  // Arguments.
  protected final Short numBytes;

  public ParameterValueCustomTypes(CustomTypes value, Short numBytes) {
    super(numBytes);
    this.value = value;
    this.numBytes = numBytes;
  }

  public CustomTypes getValue() {
    return value;
  }

  @Override
  protected void serializeParameterValueChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ParameterValueCustomTypes");

    // Simple Field (value)
    writeSimpleField("value", value, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("ParameterValueCustomTypes");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ParameterValueCustomTypes _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (value)
    lengthInBits += value.getLengthInBits();

    return lengthInBits;
  }

  public static ParameterValueBuilder staticParseParameterValueBuilder(
      ReadBuffer readBuffer, ParameterType parameterType, Short numBytes) throws ParseException {
    readBuffer.pullContext("ParameterValueCustomTypes");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    CustomTypes value =
        readSimpleField(
            "value",
            new DataReaderComplexDefault<>(
                () -> CustomTypes.staticParse(readBuffer, (short) (numBytes)), readBuffer));

    readBuffer.closeContext("ParameterValueCustomTypes");
    // Create the instance
    return new ParameterValueCustomTypesBuilderImpl(value, numBytes);
  }

  public static class ParameterValueCustomTypesBuilderImpl
      implements ParameterValue.ParameterValueBuilder {
    private final CustomTypes value;
    private final Short numBytes;

    public ParameterValueCustomTypesBuilderImpl(CustomTypes value, Short numBytes) {
      this.value = value;
      this.numBytes = numBytes;
    }

    public ParameterValueCustomTypes build(Short numBytes) {

      ParameterValueCustomTypes parameterValueCustomTypes =
          new ParameterValueCustomTypes(value, numBytes);
      return parameterValueCustomTypes;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ParameterValueCustomTypes)) {
      return false;
    }
    ParameterValueCustomTypes that = (ParameterValueCustomTypes) o;
    return (getValue() == that.getValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
