/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class IdentifyReplyCommandExtendedDiagnosticSummary extends IdentifyReplyCommand
    implements Message {

  // Accessors for discriminator values.
  public Attribute getAttribute() {
    return Attribute.ExtendedDiagnosticSummary;
  }

  // Properties.
  protected final ApplicationIdContainer lowApplication;
  protected final ApplicationIdContainer highApplication;
  protected final byte area;
  protected final int crc;
  protected final long serialNumber;
  protected final byte networkVoltage;
  protected final boolean unitInLearnMode;
  protected final boolean networkVoltageLow;
  protected final boolean networkVoltageMarginal;
  protected final boolean enableChecksumAlarm;
  protected final boolean outputUnit;
  protected final boolean installationMMIError;
  protected final boolean EEWriteError;
  protected final boolean EEChecksumError;
  protected final boolean EEDataError;
  protected final boolean microReset;
  protected final boolean commsTxError;
  protected final boolean internalStackOverflow;
  protected final boolean microPowerReset;

  // Arguments.
  protected final Byte numBytes;
  // Reserved Fields
  private Byte reservedField0;
  private Byte reservedField1;
  private Byte reservedField2;

  public IdentifyReplyCommandExtendedDiagnosticSummary(
      ApplicationIdContainer lowApplication,
      ApplicationIdContainer highApplication,
      byte area,
      int crc,
      long serialNumber,
      byte networkVoltage,
      boolean unitInLearnMode,
      boolean networkVoltageLow,
      boolean networkVoltageMarginal,
      boolean enableChecksumAlarm,
      boolean outputUnit,
      boolean installationMMIError,
      boolean EEWriteError,
      boolean EEChecksumError,
      boolean EEDataError,
      boolean microReset,
      boolean commsTxError,
      boolean internalStackOverflow,
      boolean microPowerReset,
      Byte numBytes) {
    super(numBytes);
    this.lowApplication = lowApplication;
    this.highApplication = highApplication;
    this.area = area;
    this.crc = crc;
    this.serialNumber = serialNumber;
    this.networkVoltage = networkVoltage;
    this.unitInLearnMode = unitInLearnMode;
    this.networkVoltageLow = networkVoltageLow;
    this.networkVoltageMarginal = networkVoltageMarginal;
    this.enableChecksumAlarm = enableChecksumAlarm;
    this.outputUnit = outputUnit;
    this.installationMMIError = installationMMIError;
    this.EEWriteError = EEWriteError;
    this.EEChecksumError = EEChecksumError;
    this.EEDataError = EEDataError;
    this.microReset = microReset;
    this.commsTxError = commsTxError;
    this.internalStackOverflow = internalStackOverflow;
    this.microPowerReset = microPowerReset;
    this.numBytes = numBytes;
  }

  public ApplicationIdContainer getLowApplication() {
    return lowApplication;
  }

  public ApplicationIdContainer getHighApplication() {
    return highApplication;
  }

  public byte getArea() {
    return area;
  }

  public int getCrc() {
    return crc;
  }

  public long getSerialNumber() {
    return serialNumber;
  }

  public byte getNetworkVoltage() {
    return networkVoltage;
  }

  public boolean getUnitInLearnMode() {
    return unitInLearnMode;
  }

  public boolean getNetworkVoltageLow() {
    return networkVoltageLow;
  }

  public boolean getNetworkVoltageMarginal() {
    return networkVoltageMarginal;
  }

  public boolean getEnableChecksumAlarm() {
    return enableChecksumAlarm;
  }

  public boolean getOutputUnit() {
    return outputUnit;
  }

  public boolean getInstallationMMIError() {
    return installationMMIError;
  }

  public boolean getEEWriteError() {
    return EEWriteError;
  }

  public boolean getEEChecksumError() {
    return EEChecksumError;
  }

  public boolean getEEDataError() {
    return EEDataError;
  }

  public boolean getMicroReset() {
    return microReset;
  }

  public boolean getCommsTxError() {
    return commsTxError;
  }

  public boolean getInternalStackOverflow() {
    return internalStackOverflow;
  }

  public boolean getMicroPowerReset() {
    return microPowerReset;
  }

  public float getNetworkVoltageInVolts() {
    return (float) ((getNetworkVoltage()) / (6.375F));
  }

  @Override
  protected void serializeIdentifyReplyCommandChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("IdentifyReplyCommandExtendedDiagnosticSummary");

    // Simple Field (lowApplication)
    writeSimpleEnumField(
        "lowApplication",
        "ApplicationIdContainer",
        lowApplication,
        new DataWriterEnumDefault<>(
            ApplicationIdContainer::getValue,
            ApplicationIdContainer::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (highApplication)
    writeSimpleEnumField(
        "highApplication",
        "ApplicationIdContainer",
        highApplication,
        new DataWriterEnumDefault<>(
            ApplicationIdContainer::getValue,
            ApplicationIdContainer::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (area)
    writeSimpleField("area", area, writeByte(writeBuffer, 8));

    // Simple Field (crc)
    writeSimpleField("crc", crc, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (serialNumber)
    writeSimpleField("serialNumber", serialNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (networkVoltage)
    writeSimpleField("networkVoltage", networkVoltage, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float networkVoltageInVolts = getNetworkVoltageInVolts();
    writeBuffer.writeVirtual("networkVoltageInVolts", networkVoltageInVolts);

    // Simple Field (unitInLearnMode)
    writeSimpleField("unitInLearnMode", unitInLearnMode, writeBoolean(writeBuffer));

    // Simple Field (networkVoltageLow)
    writeSimpleField("networkVoltageLow", networkVoltageLow, writeBoolean(writeBuffer));

    // Simple Field (networkVoltageMarginal)
    writeSimpleField("networkVoltageMarginal", networkVoltageMarginal, writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0,
        writeUnsignedByte(writeBuffer, 1));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (byte) 0,
        writeUnsignedByte(writeBuffer, 1));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField2 != null ? reservedField2 : (byte) 0,
        writeUnsignedByte(writeBuffer, 1));

    // Simple Field (enableChecksumAlarm)
    writeSimpleField("enableChecksumAlarm", enableChecksumAlarm, writeBoolean(writeBuffer));

    // Simple Field (outputUnit)
    writeSimpleField("outputUnit", outputUnit, writeBoolean(writeBuffer));

    // Simple Field (installationMMIError)
    writeSimpleField("installationMMIError", installationMMIError, writeBoolean(writeBuffer));

    // Simple Field (EEWriteError)
    writeSimpleField("EEWriteError", EEWriteError, writeBoolean(writeBuffer));

    // Simple Field (EEChecksumError)
    writeSimpleField("EEChecksumError", EEChecksumError, writeBoolean(writeBuffer));

    // Simple Field (EEDataError)
    writeSimpleField("EEDataError", EEDataError, writeBoolean(writeBuffer));

    // Simple Field (microReset)
    writeSimpleField("microReset", microReset, writeBoolean(writeBuffer));

    // Simple Field (commsTxError)
    writeSimpleField("commsTxError", commsTxError, writeBoolean(writeBuffer));

    // Simple Field (internalStackOverflow)
    writeSimpleField("internalStackOverflow", internalStackOverflow, writeBoolean(writeBuffer));

    // Simple Field (microPowerReset)
    writeSimpleField("microPowerReset", microPowerReset, writeBoolean(writeBuffer));

    writeBuffer.popContext("IdentifyReplyCommandExtendedDiagnosticSummary");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    IdentifyReplyCommandExtendedDiagnosticSummary _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (lowApplication)
    lengthInBits += 8;

    // Simple field (highApplication)
    lengthInBits += 8;

    // Simple field (area)
    lengthInBits += 8;

    // Simple field (crc)
    lengthInBits += 16;

    // Simple field (serialNumber)
    lengthInBits += 32;

    // Simple field (networkVoltage)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (unitInLearnMode)
    lengthInBits += 1;

    // Simple field (networkVoltageLow)
    lengthInBits += 1;

    // Simple field (networkVoltageMarginal)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (enableChecksumAlarm)
    lengthInBits += 1;

    // Simple field (outputUnit)
    lengthInBits += 1;

    // Simple field (installationMMIError)
    lengthInBits += 1;

    // Simple field (EEWriteError)
    lengthInBits += 1;

    // Simple field (EEChecksumError)
    lengthInBits += 1;

    // Simple field (EEDataError)
    lengthInBits += 1;

    // Simple field (microReset)
    lengthInBits += 1;

    // Simple field (commsTxError)
    lengthInBits += 1;

    // Simple field (internalStackOverflow)
    lengthInBits += 1;

    // Simple field (microPowerReset)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static IdentifyReplyCommandBuilder staticParseIdentifyReplyCommandBuilder(
      ReadBuffer readBuffer, Attribute attribute, Byte numBytes) throws ParseException {
    readBuffer.pullContext("IdentifyReplyCommandExtendedDiagnosticSummary");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ApplicationIdContainer lowApplication =
        readEnumField(
            "lowApplication",
            "ApplicationIdContainer",
            new DataReaderEnumDefault<>(
                ApplicationIdContainer::enumForValue, readUnsignedShort(readBuffer, 8)));

    ApplicationIdContainer highApplication =
        readEnumField(
            "highApplication",
            "ApplicationIdContainer",
            new DataReaderEnumDefault<>(
                ApplicationIdContainer::enumForValue, readUnsignedShort(readBuffer, 8)));

    byte area = readSimpleField("area", readByte(readBuffer, 8));

    int crc = readSimpleField("crc", readUnsignedInt(readBuffer, 16));

    long serialNumber = readSimpleField("serialNumber", readUnsignedLong(readBuffer, 32));

    byte networkVoltage = readSimpleField("networkVoltage", readByte(readBuffer, 8));
    float networkVoltageInVolts =
        readVirtualField("networkVoltageInVolts", float.class, (networkVoltage) / (6.375F));

    boolean unitInLearnMode = readSimpleField("unitInLearnMode", readBoolean(readBuffer));

    boolean networkVoltageLow = readSimpleField("networkVoltageLow", readBoolean(readBuffer));

    boolean networkVoltageMarginal =
        readSimpleField("networkVoltageMarginal", readBoolean(readBuffer));

    Byte reservedField0 = readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0);

    Byte reservedField1 = readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0);

    Byte reservedField2 = readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0);

    boolean enableChecksumAlarm = readSimpleField("enableChecksumAlarm", readBoolean(readBuffer));

    boolean outputUnit = readSimpleField("outputUnit", readBoolean(readBuffer));

    boolean installationMMIError = readSimpleField("installationMMIError", readBoolean(readBuffer));

    boolean EEWriteError = readSimpleField("EEWriteError", readBoolean(readBuffer));

    boolean EEChecksumError = readSimpleField("EEChecksumError", readBoolean(readBuffer));

    boolean EEDataError = readSimpleField("EEDataError", readBoolean(readBuffer));

    boolean microReset = readSimpleField("microReset", readBoolean(readBuffer));

    boolean commsTxError = readSimpleField("commsTxError", readBoolean(readBuffer));

    boolean internalStackOverflow =
        readSimpleField("internalStackOverflow", readBoolean(readBuffer));

    boolean microPowerReset = readSimpleField("microPowerReset", readBoolean(readBuffer));

    readBuffer.closeContext("IdentifyReplyCommandExtendedDiagnosticSummary");
    // Create the instance
    return new IdentifyReplyCommandExtendedDiagnosticSummaryBuilderImpl(
        lowApplication,
        highApplication,
        area,
        crc,
        serialNumber,
        networkVoltage,
        unitInLearnMode,
        networkVoltageLow,
        networkVoltageMarginal,
        enableChecksumAlarm,
        outputUnit,
        installationMMIError,
        EEWriteError,
        EEChecksumError,
        EEDataError,
        microReset,
        commsTxError,
        internalStackOverflow,
        microPowerReset,
        numBytes,
        reservedField0,
        reservedField1,
        reservedField2);
  }

  public static class IdentifyReplyCommandExtendedDiagnosticSummaryBuilderImpl
      implements IdentifyReplyCommand.IdentifyReplyCommandBuilder {
    private final ApplicationIdContainer lowApplication;
    private final ApplicationIdContainer highApplication;
    private final byte area;
    private final int crc;
    private final long serialNumber;
    private final byte networkVoltage;
    private final boolean unitInLearnMode;
    private final boolean networkVoltageLow;
    private final boolean networkVoltageMarginal;
    private final boolean enableChecksumAlarm;
    private final boolean outputUnit;
    private final boolean installationMMIError;
    private final boolean EEWriteError;
    private final boolean EEChecksumError;
    private final boolean EEDataError;
    private final boolean microReset;
    private final boolean commsTxError;
    private final boolean internalStackOverflow;
    private final boolean microPowerReset;
    private final Byte numBytes;
    private final Byte reservedField0;
    private final Byte reservedField1;
    private final Byte reservedField2;

    public IdentifyReplyCommandExtendedDiagnosticSummaryBuilderImpl(
        ApplicationIdContainer lowApplication,
        ApplicationIdContainer highApplication,
        byte area,
        int crc,
        long serialNumber,
        byte networkVoltage,
        boolean unitInLearnMode,
        boolean networkVoltageLow,
        boolean networkVoltageMarginal,
        boolean enableChecksumAlarm,
        boolean outputUnit,
        boolean installationMMIError,
        boolean EEWriteError,
        boolean EEChecksumError,
        boolean EEDataError,
        boolean microReset,
        boolean commsTxError,
        boolean internalStackOverflow,
        boolean microPowerReset,
        Byte numBytes,
        Byte reservedField0,
        Byte reservedField1,
        Byte reservedField2) {
      this.lowApplication = lowApplication;
      this.highApplication = highApplication;
      this.area = area;
      this.crc = crc;
      this.serialNumber = serialNumber;
      this.networkVoltage = networkVoltage;
      this.unitInLearnMode = unitInLearnMode;
      this.networkVoltageLow = networkVoltageLow;
      this.networkVoltageMarginal = networkVoltageMarginal;
      this.enableChecksumAlarm = enableChecksumAlarm;
      this.outputUnit = outputUnit;
      this.installationMMIError = installationMMIError;
      this.EEWriteError = EEWriteError;
      this.EEChecksumError = EEChecksumError;
      this.EEDataError = EEDataError;
      this.microReset = microReset;
      this.commsTxError = commsTxError;
      this.internalStackOverflow = internalStackOverflow;
      this.microPowerReset = microPowerReset;
      this.numBytes = numBytes;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
      this.reservedField2 = reservedField2;
    }

    public IdentifyReplyCommandExtendedDiagnosticSummary build(Byte numBytes) {

      IdentifyReplyCommandExtendedDiagnosticSummary identifyReplyCommandExtendedDiagnosticSummary =
          new IdentifyReplyCommandExtendedDiagnosticSummary(
              lowApplication,
              highApplication,
              area,
              crc,
              serialNumber,
              networkVoltage,
              unitInLearnMode,
              networkVoltageLow,
              networkVoltageMarginal,
              enableChecksumAlarm,
              outputUnit,
              installationMMIError,
              EEWriteError,
              EEChecksumError,
              EEDataError,
              microReset,
              commsTxError,
              internalStackOverflow,
              microPowerReset,
              numBytes);
      identifyReplyCommandExtendedDiagnosticSummary.reservedField0 = reservedField0;
      identifyReplyCommandExtendedDiagnosticSummary.reservedField1 = reservedField1;
      identifyReplyCommandExtendedDiagnosticSummary.reservedField2 = reservedField2;
      return identifyReplyCommandExtendedDiagnosticSummary;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IdentifyReplyCommandExtendedDiagnosticSummary)) {
      return false;
    }
    IdentifyReplyCommandExtendedDiagnosticSummary that =
        (IdentifyReplyCommandExtendedDiagnosticSummary) o;
    return (getLowApplication() == that.getLowApplication())
        && (getHighApplication() == that.getHighApplication())
        && (getArea() == that.getArea())
        && (getCrc() == that.getCrc())
        && (getSerialNumber() == that.getSerialNumber())
        && (getNetworkVoltage() == that.getNetworkVoltage())
        && (getUnitInLearnMode() == that.getUnitInLearnMode())
        && (getNetworkVoltageLow() == that.getNetworkVoltageLow())
        && (getNetworkVoltageMarginal() == that.getNetworkVoltageMarginal())
        && (getEnableChecksumAlarm() == that.getEnableChecksumAlarm())
        && (getOutputUnit() == that.getOutputUnit())
        && (getInstallationMMIError() == that.getInstallationMMIError())
        && (getEEWriteError() == that.getEEWriteError())
        && (getEEChecksumError() == that.getEEChecksumError())
        && (getEEDataError() == that.getEEDataError())
        && (getMicroReset() == that.getMicroReset())
        && (getCommsTxError() == that.getCommsTxError())
        && (getInternalStackOverflow() == that.getInternalStackOverflow())
        && (getMicroPowerReset() == that.getMicroPowerReset())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getLowApplication(),
        getHighApplication(),
        getArea(),
        getCrc(),
        getSerialNumber(),
        getNetworkVoltage(),
        getUnitInLearnMode(),
        getNetworkVoltageLow(),
        getNetworkVoltageMarginal(),
        getEnableChecksumAlarm(),
        getOutputUnit(),
        getInstallationMMIError(),
        getEEWriteError(),
        getEEChecksumError(),
        getEEDataError(),
        getMicroReset(),
        getCommsTxError(),
        getInternalStackOverflow(),
        getMicroPowerReset());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
