/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BVLCBroadcastDistributionTableEntry implements Message {

  // Properties.
  protected final List<Short> ip;
  protected final int port;
  protected final List<Short> broadcastDistributionMap;

  public BVLCBroadcastDistributionTableEntry(
      List<Short> ip, int port, List<Short> broadcastDistributionMap) {
    super();
    this.ip = ip;
    this.port = port;
    this.broadcastDistributionMap = broadcastDistributionMap;
  }

  public List<Short> getIp() {
    return ip;
  }

  public int getPort() {
    return port;
  }

  public List<Short> getBroadcastDistributionMap() {
    return broadcastDistributionMap;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BVLCBroadcastDistributionTableEntry");

    // Array Field (ip)
    writeSimpleTypeArrayField("ip", ip, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (port)
    writeSimpleField("port", port, writeUnsignedInt(writeBuffer, 16));

    // Array Field (broadcastDistributionMap)
    writeSimpleTypeArrayField(
        "broadcastDistributionMap", broadcastDistributionMap, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("BVLCBroadcastDistributionTableEntry");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BVLCBroadcastDistributionTableEntry _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (ip != null) {
      lengthInBits += 8 * ip.size();
    }

    // Simple field (port)
    lengthInBits += 16;

    // Array field
    if (broadcastDistributionMap != null) {
      lengthInBits += 8 * broadcastDistributionMap.size();
    }

    return lengthInBits;
  }

  public static BVLCBroadcastDistributionTableEntry staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BVLCBroadcastDistributionTableEntry staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BVLCBroadcastDistributionTableEntry");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    List<Short> ip = readCountArrayField("ip", readUnsignedShort(readBuffer, 8), 4);

    int port = readSimpleField("port", readUnsignedInt(readBuffer, 16));

    List<Short> broadcastDistributionMap =
        readCountArrayField("broadcastDistributionMap", readUnsignedShort(readBuffer, 8), 4);

    readBuffer.closeContext("BVLCBroadcastDistributionTableEntry");
    // Create the instance
    BVLCBroadcastDistributionTableEntry _bVLCBroadcastDistributionTableEntry;
    _bVLCBroadcastDistributionTableEntry =
        new BVLCBroadcastDistributionTableEntry(ip, port, broadcastDistributionMap);
    return _bVLCBroadcastDistributionTableEntry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BVLCBroadcastDistributionTableEntry)) {
      return false;
    }
    BVLCBroadcastDistributionTableEntry that = (BVLCBroadcastDistributionTableEntry) o;
    return (getIp() == that.getIp())
        && (getPort() == that.getPort())
        && (getBroadcastDistributionMap() == that.getBroadcastDistributionMap())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getIp(), getPort(), getBroadcastDistributionMap());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
