/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetSpecialEvent implements Message {

  // Properties.
  protected final BACnetSpecialEventPeriod period;
  protected final BACnetSpecialEventListOfTimeValues listOfTimeValues;
  protected final BACnetContextTagUnsignedInteger eventPriority;

  public BACnetSpecialEvent(
      BACnetSpecialEventPeriod period,
      BACnetSpecialEventListOfTimeValues listOfTimeValues,
      BACnetContextTagUnsignedInteger eventPriority) {
    super();
    this.period = period;
    this.listOfTimeValues = listOfTimeValues;
    this.eventPriority = eventPriority;
  }

  public BACnetSpecialEventPeriod getPeriod() {
    return period;
  }

  public BACnetSpecialEventListOfTimeValues getListOfTimeValues() {
    return listOfTimeValues;
  }

  public BACnetContextTagUnsignedInteger getEventPriority() {
    return eventPriority;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetSpecialEvent");

    // Simple Field (period)
    writeSimpleField("period", period, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (listOfTimeValues)
    writeSimpleField(
        "listOfTimeValues", listOfTimeValues, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (eventPriority)
    writeSimpleField("eventPriority", eventPriority, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetSpecialEvent");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetSpecialEvent _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (period)
    lengthInBits += period.getLengthInBits();

    // Simple field (listOfTimeValues)
    lengthInBits += listOfTimeValues.getLengthInBits();

    // Simple field (eventPriority)
    lengthInBits += eventPriority.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetSpecialEvent staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetSpecialEvent staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetSpecialEvent");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetSpecialEventPeriod period =
        readSimpleField(
            "period",
            new DataReaderComplexDefault<>(
                () -> BACnetSpecialEventPeriod.staticParse(readBuffer), readBuffer));

    BACnetSpecialEventListOfTimeValues listOfTimeValues =
        readSimpleField(
            "listOfTimeValues",
            new DataReaderComplexDefault<>(
                () -> BACnetSpecialEventListOfTimeValues.staticParse(readBuffer, (short) (2)),
                readBuffer));

    BACnetContextTagUnsignedInteger eventPriority =
        readSimpleField(
            "eventPriority",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetSpecialEvent");
    // Create the instance
    BACnetSpecialEvent _bACnetSpecialEvent;
    _bACnetSpecialEvent = new BACnetSpecialEvent(period, listOfTimeValues, eventPriority);
    return _bACnetSpecialEvent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetSpecialEvent)) {
      return false;
    }
    BACnetSpecialEvent that = (BACnetSpecialEvent) o;
    return (getPeriod() == that.getPeriod())
        && (getListOfTimeValues() == that.getListOfTimeValues())
        && (getEventPriority() == that.getEventPriority())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPeriod(), getListOfTimeValues(), getEventPriority());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
