/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetServiceAckReadRange extends BACnetServiceAck implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.READ_RANGE;
  }

  // Properties.
  protected final BACnetContextTagObjectIdentifier objectIdentifier;
  protected final BACnetPropertyIdentifierTagged propertyIdentifier;
  protected final BACnetContextTagUnsignedInteger propertyArrayIndex;
  protected final BACnetResultFlagsTagged resultFlags;
  protected final BACnetContextTagUnsignedInteger itemCount;
  protected final BACnetConstructedData itemData;
  protected final BACnetContextTagUnsignedInteger firstSequenceNumber;

  // Arguments.
  protected final Long serviceAckLength;

  public BACnetServiceAckReadRange(
      BACnetContextTagObjectIdentifier objectIdentifier,
      BACnetPropertyIdentifierTagged propertyIdentifier,
      BACnetContextTagUnsignedInteger propertyArrayIndex,
      BACnetResultFlagsTagged resultFlags,
      BACnetContextTagUnsignedInteger itemCount,
      BACnetConstructedData itemData,
      BACnetContextTagUnsignedInteger firstSequenceNumber,
      Long serviceAckLength) {
    super(serviceAckLength);
    this.objectIdentifier = objectIdentifier;
    this.propertyIdentifier = propertyIdentifier;
    this.propertyArrayIndex = propertyArrayIndex;
    this.resultFlags = resultFlags;
    this.itemCount = itemCount;
    this.itemData = itemData;
    this.firstSequenceNumber = firstSequenceNumber;
    this.serviceAckLength = serviceAckLength;
  }

  public BACnetContextTagObjectIdentifier getObjectIdentifier() {
    return objectIdentifier;
  }

  public BACnetPropertyIdentifierTagged getPropertyIdentifier() {
    return propertyIdentifier;
  }

  public BACnetContextTagUnsignedInteger getPropertyArrayIndex() {
    return propertyArrayIndex;
  }

  public BACnetResultFlagsTagged getResultFlags() {
    return resultFlags;
  }

  public BACnetContextTagUnsignedInteger getItemCount() {
    return itemCount;
  }

  public BACnetConstructedData getItemData() {
    return itemData;
  }

  public BACnetContextTagUnsignedInteger getFirstSequenceNumber() {
    return firstSequenceNumber;
  }

  @Override
  protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetServiceAckReadRange");

    // Simple Field (objectIdentifier)
    writeSimpleField(
        "objectIdentifier", objectIdentifier, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (propertyIdentifier)
    writeSimpleField(
        "propertyIdentifier", propertyIdentifier, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (propertyArrayIndex) (Can be skipped, if the value is null)
    writeOptionalField(
        "propertyArrayIndex", propertyArrayIndex, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (resultFlags)
    writeSimpleField("resultFlags", resultFlags, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (itemCount)
    writeSimpleField("itemCount", itemCount, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (itemData) (Can be skipped, if the value is null)
    writeOptionalField("itemData", itemData, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (firstSequenceNumber) (Can be skipped, if the value is null)
    writeOptionalField(
        "firstSequenceNumber", firstSequenceNumber, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetServiceAckReadRange");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetServiceAckReadRange _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (objectIdentifier)
    lengthInBits += objectIdentifier.getLengthInBits();

    // Simple field (propertyIdentifier)
    lengthInBits += propertyIdentifier.getLengthInBits();

    // Optional Field (propertyArrayIndex)
    if (propertyArrayIndex != null) {
      lengthInBits += propertyArrayIndex.getLengthInBits();
    }

    // Simple field (resultFlags)
    lengthInBits += resultFlags.getLengthInBits();

    // Simple field (itemCount)
    lengthInBits += itemCount.getLengthInBits();

    // Optional Field (itemData)
    if (itemData != null) {
      lengthInBits += itemData.getLengthInBits();
    }

    // Optional Field (firstSequenceNumber)
    if (firstSequenceNumber != null) {
      lengthInBits += firstSequenceNumber.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(
      ReadBuffer readBuffer, Long serviceAckLength) throws ParseException {
    readBuffer.pullContext("BACnetServiceAckReadRange");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagObjectIdentifier objectIdentifier =
        readSimpleField(
            "objectIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetPropertyIdentifierTagged propertyIdentifier =
        readSimpleField(
            "propertyIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetPropertyIdentifierTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagUnsignedInteger propertyArrayIndex =
        readOptionalField(
            "propertyArrayIndex",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetResultFlagsTagged resultFlags =
        readSimpleField(
            "resultFlags",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetResultFlagsTagged.staticParse(
                        readBuffer, (short) (3), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagUnsignedInteger itemCount =
        readSimpleField(
            "itemCount",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (4),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetConstructedData itemData =
        readOptionalField(
            "itemData",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetConstructedData.staticParse(
                        readBuffer,
                        (short) (5),
                        (BACnetObjectType) (objectIdentifier.getObjectType()),
                        (BACnetPropertyIdentifier) (propertyIdentifier.getValue()),
                        (BACnetTagPayloadUnsignedInteger)
                            (((((propertyArrayIndex) != (null))
                                ? propertyArrayIndex.getPayload()
                                : null)))),
                readBuffer));

    BACnetContextTagUnsignedInteger firstSequenceNumber =
        readOptionalField(
            "firstSequenceNumber",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (6),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetServiceAckReadRange");
    // Create the instance
    return new BACnetServiceAckReadRangeBuilderImpl(
        objectIdentifier,
        propertyIdentifier,
        propertyArrayIndex,
        resultFlags,
        itemCount,
        itemData,
        firstSequenceNumber,
        serviceAckLength);
  }

  public static class BACnetServiceAckReadRangeBuilderImpl
      implements BACnetServiceAck.BACnetServiceAckBuilder {
    private final BACnetContextTagObjectIdentifier objectIdentifier;
    private final BACnetPropertyIdentifierTagged propertyIdentifier;
    private final BACnetContextTagUnsignedInteger propertyArrayIndex;
    private final BACnetResultFlagsTagged resultFlags;
    private final BACnetContextTagUnsignedInteger itemCount;
    private final BACnetConstructedData itemData;
    private final BACnetContextTagUnsignedInteger firstSequenceNumber;
    private final Long serviceAckLength;

    public BACnetServiceAckReadRangeBuilderImpl(
        BACnetContextTagObjectIdentifier objectIdentifier,
        BACnetPropertyIdentifierTagged propertyIdentifier,
        BACnetContextTagUnsignedInteger propertyArrayIndex,
        BACnetResultFlagsTagged resultFlags,
        BACnetContextTagUnsignedInteger itemCount,
        BACnetConstructedData itemData,
        BACnetContextTagUnsignedInteger firstSequenceNumber,
        Long serviceAckLength) {
      this.objectIdentifier = objectIdentifier;
      this.propertyIdentifier = propertyIdentifier;
      this.propertyArrayIndex = propertyArrayIndex;
      this.resultFlags = resultFlags;
      this.itemCount = itemCount;
      this.itemData = itemData;
      this.firstSequenceNumber = firstSequenceNumber;
      this.serviceAckLength = serviceAckLength;
    }

    public BACnetServiceAckReadRange build(Long serviceAckLength) {

      BACnetServiceAckReadRange bACnetServiceAckReadRange =
          new BACnetServiceAckReadRange(
              objectIdentifier,
              propertyIdentifier,
              propertyArrayIndex,
              resultFlags,
              itemCount,
              itemData,
              firstSequenceNumber,
              serviceAckLength);
      return bACnetServiceAckReadRange;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetServiceAckReadRange)) {
      return false;
    }
    BACnetServiceAckReadRange that = (BACnetServiceAckReadRange) o;
    return (getObjectIdentifier() == that.getObjectIdentifier())
        && (getPropertyIdentifier() == that.getPropertyIdentifier())
        && (getPropertyArrayIndex() == that.getPropertyArrayIndex())
        && (getResultFlags() == that.getResultFlags())
        && (getItemCount() == that.getItemCount())
        && (getItemData() == that.getItemData())
        && (getFirstSequenceNumber() == that.getFirstSequenceNumber())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getObjectIdentifier(),
        getPropertyIdentifier(),
        getPropertyArrayIndex(),
        getResultFlags(),
        getItemCount(),
        getItemData(),
        getFirstSequenceNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
