/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetRejectReasonTagged implements Message {

  // Properties.
  protected final BACnetRejectReason value;
  protected final long proprietaryValue;

  // Arguments.
  protected final Long actualLength;

  public BACnetRejectReasonTagged(
      BACnetRejectReason value, long proprietaryValue, Long actualLength) {
    super();
    this.value = value;
    this.proprietaryValue = proprietaryValue;
    this.actualLength = actualLength;
  }

  public BACnetRejectReason getValue() {
    return value;
  }

  public long getProprietaryValue() {
    return proprietaryValue;
  }

  public boolean getIsProprietary() {
    return (boolean) ((getValue()) == (BACnetRejectReason.VENDOR_PROPRIETARY_VALUE));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetRejectReasonTagged");

    // Manual Field (value)
    writeManualField(
        "value",
        () ->
            org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.writeEnumGeneric(
                writeBuffer, value),
        writeBuffer);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isProprietary = getIsProprietary();
    writeBuffer.writeVirtual("isProprietary", isProprietary);

    // Manual Field (proprietaryValue)
    writeManualField(
        "proprietaryValue",
        () ->
            org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.writeProprietaryEnumGeneric(
                writeBuffer, proprietaryValue, isProprietary),
        writeBuffer);

    writeBuffer.popContext("BACnetRejectReasonTagged");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetRejectReasonTagged _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Manual Field (value)
    lengthInBits += ((_value.getIsProprietary()) ? 0 : ((actualLength) * (8)));

    // A virtual field doesn't have any in- or output.

    // Manual Field (proprietaryValue)
    lengthInBits += ((_value.getIsProprietary()) ? ((actualLength) * (8)) : 0);

    return lengthInBits;
  }

  public static BACnetRejectReasonTagged staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Long actualLength;
    if (args[0] instanceof Long) {
      actualLength = (Long) args[0];
    } else if (args[0] instanceof String) {
      actualLength = Long.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Long or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, actualLength);
  }

  public static BACnetRejectReasonTagged staticParse(ReadBuffer readBuffer, Long actualLength)
      throws ParseException {
    readBuffer.pullContext("BACnetRejectReasonTagged");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetRejectReason value =
        readManualField(
            "value",
            readBuffer,
            () ->
                (BACnetRejectReason)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.readEnumGeneric(
                        readBuffer, actualLength, BACnetRejectReason.VENDOR_PROPRIETARY_VALUE)));
    boolean isProprietary =
        readVirtualField(
            "isProprietary",
            boolean.class,
            (value) == (BACnetRejectReason.VENDOR_PROPRIETARY_VALUE));

    long proprietaryValue =
        readManualField(
            "proprietaryValue",
            readBuffer,
            () ->
                (long)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .readProprietaryEnumGeneric(readBuffer, actualLength, isProprietary)));

    readBuffer.closeContext("BACnetRejectReasonTagged");
    // Create the instance
    BACnetRejectReasonTagged _bACnetRejectReasonTagged;
    _bACnetRejectReasonTagged = new BACnetRejectReasonTagged(value, proprietaryValue, actualLength);
    return _bACnetRejectReasonTagged;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetRejectReasonTagged)) {
      return false;
    }
    BACnetRejectReasonTagged that = (BACnetRejectReasonTagged) o;
    return (getValue() == that.getValue())
        && (getProprietaryValue() == that.getProprietaryValue())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getValue(), getProprietaryValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
