/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetNotificationParametersAccessEvent extends BACnetNotificationParameters
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetOpeningTag innerOpeningTag;
  protected final BACnetAccessEventTagged accessEvent;
  protected final BACnetStatusFlagsTagged statusFlags;
  protected final BACnetContextTagUnsignedInteger accessEventTag;
  protected final BACnetTimeStampEnclosed accessEventTime;
  protected final BACnetDeviceObjectReferenceEnclosed accessCredential;
  protected final BACnetAuthenticationFactorTypeTagged authenticationFactor;
  protected final BACnetClosingTag innerClosingTag;

  // Arguments.
  protected final Short tagNumber;
  protected final BACnetObjectType objectTypeArgument;

  public BACnetNotificationParametersAccessEvent(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetOpeningTag innerOpeningTag,
      BACnetAccessEventTagged accessEvent,
      BACnetStatusFlagsTagged statusFlags,
      BACnetContextTagUnsignedInteger accessEventTag,
      BACnetTimeStampEnclosed accessEventTime,
      BACnetDeviceObjectReferenceEnclosed accessCredential,
      BACnetAuthenticationFactorTypeTagged authenticationFactor,
      BACnetClosingTag innerClosingTag,
      Short tagNumber,
      BACnetObjectType objectTypeArgument) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber, objectTypeArgument);
    this.innerOpeningTag = innerOpeningTag;
    this.accessEvent = accessEvent;
    this.statusFlags = statusFlags;
    this.accessEventTag = accessEventTag;
    this.accessEventTime = accessEventTime;
    this.accessCredential = accessCredential;
    this.authenticationFactor = authenticationFactor;
    this.innerClosingTag = innerClosingTag;
    this.tagNumber = tagNumber;
    this.objectTypeArgument = objectTypeArgument;
  }

  public BACnetOpeningTag getInnerOpeningTag() {
    return innerOpeningTag;
  }

  public BACnetAccessEventTagged getAccessEvent() {
    return accessEvent;
  }

  public BACnetStatusFlagsTagged getStatusFlags() {
    return statusFlags;
  }

  public BACnetContextTagUnsignedInteger getAccessEventTag() {
    return accessEventTag;
  }

  public BACnetTimeStampEnclosed getAccessEventTime() {
    return accessEventTime;
  }

  public BACnetDeviceObjectReferenceEnclosed getAccessCredential() {
    return accessCredential;
  }

  public BACnetAuthenticationFactorTypeTagged getAuthenticationFactor() {
    return authenticationFactor;
  }

  public BACnetClosingTag getInnerClosingTag() {
    return innerClosingTag;
  }

  @Override
  protected void serializeBACnetNotificationParametersChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetNotificationParametersAccessEvent");

    // Simple Field (innerOpeningTag)
    writeSimpleField(
        "innerOpeningTag", innerOpeningTag, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (accessEvent)
    writeSimpleField("accessEvent", accessEvent, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (statusFlags)
    writeSimpleField("statusFlags", statusFlags, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (accessEventTag)
    writeSimpleField("accessEventTag", accessEventTag, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (accessEventTime)
    writeSimpleField(
        "accessEventTime", accessEventTime, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (accessCredential)
    writeSimpleField(
        "accessCredential", accessCredential, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (authenticationFactor) (Can be skipped, if the value is null)
    writeOptionalField(
        "authenticationFactor", authenticationFactor, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (innerClosingTag)
    writeSimpleField(
        "innerClosingTag", innerClosingTag, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetNotificationParametersAccessEvent");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetNotificationParametersAccessEvent _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (innerOpeningTag)
    lengthInBits += innerOpeningTag.getLengthInBits();

    // Simple field (accessEvent)
    lengthInBits += accessEvent.getLengthInBits();

    // Simple field (statusFlags)
    lengthInBits += statusFlags.getLengthInBits();

    // Simple field (accessEventTag)
    lengthInBits += accessEventTag.getLengthInBits();

    // Simple field (accessEventTime)
    lengthInBits += accessEventTime.getLengthInBits();

    // Simple field (accessCredential)
    lengthInBits += accessCredential.getLengthInBits();

    // Optional Field (authenticationFactor)
    if (authenticationFactor != null) {
      lengthInBits += authenticationFactor.getLengthInBits();
    }

    // Simple field (innerClosingTag)
    lengthInBits += innerClosingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetNotificationParametersBuilder staticParseBACnetNotificationParametersBuilder(
      ReadBuffer readBuffer,
      Short peekedTagNumber,
      Short tagNumber,
      BACnetObjectType objectTypeArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetNotificationParametersAccessEvent");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag innerOpeningTag =
        readSimpleField(
            "innerOpeningTag",
            new DataReaderComplexDefault<>(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (peekedTagNumber)),
                readBuffer));

    BACnetAccessEventTagged accessEvent =
        readSimpleField(
            "accessEvent",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetAccessEventTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetStatusFlagsTagged statusFlags =
        readSimpleField(
            "statusFlags",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetStatusFlagsTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagUnsignedInteger accessEventTag =
        readSimpleField(
            "accessEventTag",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetTimeStampEnclosed accessEventTime =
        readSimpleField(
            "accessEventTime",
            new DataReaderComplexDefault<>(
                () -> BACnetTimeStampEnclosed.staticParse(readBuffer, (short) (3)), readBuffer));

    BACnetDeviceObjectReferenceEnclosed accessCredential =
        readSimpleField(
            "accessCredential",
            new DataReaderComplexDefault<>(
                () -> BACnetDeviceObjectReferenceEnclosed.staticParse(readBuffer, (short) (4)),
                readBuffer));

    BACnetAuthenticationFactorTypeTagged authenticationFactor =
        readOptionalField(
            "authenticationFactor",
            new DataReaderComplexDefault<>(
                () ->
                    BACnetAuthenticationFactorTypeTagged.staticParse(
                        readBuffer, (short) (5), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetClosingTag innerClosingTag =
        readSimpleField(
            "innerClosingTag",
            new DataReaderComplexDefault<>(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (peekedTagNumber)),
                readBuffer));

    readBuffer.closeContext("BACnetNotificationParametersAccessEvent");
    // Create the instance
    return new BACnetNotificationParametersAccessEventBuilderImpl(
        innerOpeningTag,
        accessEvent,
        statusFlags,
        accessEventTag,
        accessEventTime,
        accessCredential,
        authenticationFactor,
        innerClosingTag,
        tagNumber,
        objectTypeArgument);
  }

  public static class BACnetNotificationParametersAccessEventBuilderImpl
      implements BACnetNotificationParameters.BACnetNotificationParametersBuilder {
    private final BACnetOpeningTag innerOpeningTag;
    private final BACnetAccessEventTagged accessEvent;
    private final BACnetStatusFlagsTagged statusFlags;
    private final BACnetContextTagUnsignedInteger accessEventTag;
    private final BACnetTimeStampEnclosed accessEventTime;
    private final BACnetDeviceObjectReferenceEnclosed accessCredential;
    private final BACnetAuthenticationFactorTypeTagged authenticationFactor;
    private final BACnetClosingTag innerClosingTag;
    private final Short tagNumber;
    private final BACnetObjectType objectTypeArgument;

    public BACnetNotificationParametersAccessEventBuilderImpl(
        BACnetOpeningTag innerOpeningTag,
        BACnetAccessEventTagged accessEvent,
        BACnetStatusFlagsTagged statusFlags,
        BACnetContextTagUnsignedInteger accessEventTag,
        BACnetTimeStampEnclosed accessEventTime,
        BACnetDeviceObjectReferenceEnclosed accessCredential,
        BACnetAuthenticationFactorTypeTagged authenticationFactor,
        BACnetClosingTag innerClosingTag,
        Short tagNumber,
        BACnetObjectType objectTypeArgument) {
      this.innerOpeningTag = innerOpeningTag;
      this.accessEvent = accessEvent;
      this.statusFlags = statusFlags;
      this.accessEventTag = accessEventTag;
      this.accessEventTime = accessEventTime;
      this.accessCredential = accessCredential;
      this.authenticationFactor = authenticationFactor;
      this.innerClosingTag = innerClosingTag;
      this.tagNumber = tagNumber;
      this.objectTypeArgument = objectTypeArgument;
    }

    public BACnetNotificationParametersAccessEvent build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber,
        BACnetObjectType objectTypeArgument) {
      BACnetNotificationParametersAccessEvent bACnetNotificationParametersAccessEvent =
          new BACnetNotificationParametersAccessEvent(
              openingTag,
              peekedTagHeader,
              closingTag,
              innerOpeningTag,
              accessEvent,
              statusFlags,
              accessEventTag,
              accessEventTime,
              accessCredential,
              authenticationFactor,
              innerClosingTag,
              tagNumber,
              objectTypeArgument);
      return bACnetNotificationParametersAccessEvent;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetNotificationParametersAccessEvent)) {
      return false;
    }
    BACnetNotificationParametersAccessEvent that = (BACnetNotificationParametersAccessEvent) o;
    return (getInnerOpeningTag() == that.getInnerOpeningTag())
        && (getAccessEvent() == that.getAccessEvent())
        && (getStatusFlags() == that.getStatusFlags())
        && (getAccessEventTag() == that.getAccessEventTag())
        && (getAccessEventTime() == that.getAccessEventTime())
        && (getAccessCredential() == that.getAccessCredential())
        && (getAuthenticationFactor() == that.getAuthenticationFactor())
        && (getInnerClosingTag() == that.getInnerClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getInnerOpeningTag(),
        getAccessEvent(),
        getStatusFlags(),
        getAccessEventTag(),
        getAccessEventTime(),
        getAccessCredential(),
        getAuthenticationFactor(),
        getInnerClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
