/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// COTPParameterCalledTsap is the corresponding interface of COTPParameterCalledTsap
type COTPParameterCalledTsap interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	COTPParameter
	// GetTsapId returns TsapId (property field)
	GetTsapId() uint16
}

// COTPParameterCalledTsapExactly can be used when we want exactly this type and not a type which fulfills COTPParameterCalledTsap.
// This is useful for switch cases.
type COTPParameterCalledTsapExactly interface {
	COTPParameterCalledTsap
	isCOTPParameterCalledTsap() bool
}

// _COTPParameterCalledTsap is the data-structure of this message
type _COTPParameterCalledTsap struct {
	*_COTPParameter
	TsapId uint16
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_COTPParameterCalledTsap) GetParameterType() uint8 {
	return 0xC2
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_COTPParameterCalledTsap) InitializeParent(parent COTPParameter) {}

func (m *_COTPParameterCalledTsap) GetParent() COTPParameter {
	return m._COTPParameter
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_COTPParameterCalledTsap) GetTsapId() uint16 {
	return m.TsapId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCOTPParameterCalledTsap factory function for _COTPParameterCalledTsap
func NewCOTPParameterCalledTsap(tsapId uint16, rest uint8) *_COTPParameterCalledTsap {
	_result := &_COTPParameterCalledTsap{
		TsapId:         tsapId,
		_COTPParameter: NewCOTPParameter(rest),
	}
	_result._COTPParameter._COTPParameterChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastCOTPParameterCalledTsap(structType any) COTPParameterCalledTsap {
	if casted, ok := structType.(COTPParameterCalledTsap); ok {
		return casted
	}
	if casted, ok := structType.(*COTPParameterCalledTsap); ok {
		return *casted
	}
	return nil
}

func (m *_COTPParameterCalledTsap) GetTypeName() string {
	return "COTPParameterCalledTsap"
}

func (m *_COTPParameterCalledTsap) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (tsapId)
	lengthInBits += 16

	return lengthInBits
}

func (m *_COTPParameterCalledTsap) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func COTPParameterCalledTsapParse(ctx context.Context, theBytes []byte, rest uint8) (COTPParameterCalledTsap, error) {
	return COTPParameterCalledTsapParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), rest)
}

func COTPParameterCalledTsapParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, rest uint8) (COTPParameterCalledTsap, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("COTPParameterCalledTsap"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for COTPParameterCalledTsap")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (tsapId)
	_tsapId, _tsapIdErr := readBuffer.ReadUint16("tsapId", 16)
	if _tsapIdErr != nil {
		return nil, errors.Wrap(_tsapIdErr, "Error parsing 'tsapId' field of COTPParameterCalledTsap")
	}
	tsapId := _tsapId

	if closeErr := readBuffer.CloseContext("COTPParameterCalledTsap"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for COTPParameterCalledTsap")
	}

	// Create a partially initialized instance
	_child := &_COTPParameterCalledTsap{
		_COTPParameter: &_COTPParameter{
			Rest: rest,
		},
		TsapId: tsapId,
	}
	_child._COTPParameter._COTPParameterChildRequirements = _child
	return _child, nil
}

func (m *_COTPParameterCalledTsap) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_COTPParameterCalledTsap) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("COTPParameterCalledTsap"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for COTPParameterCalledTsap")
		}

		// Simple Field (tsapId)
		tsapId := uint16(m.GetTsapId())
		_tsapIdErr := writeBuffer.WriteUint16("tsapId", 16, (tsapId))
		if _tsapIdErr != nil {
			return errors.Wrap(_tsapIdErr, "Error serializing 'tsapId' field")
		}

		if popErr := writeBuffer.PopContext("COTPParameterCalledTsap"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for COTPParameterCalledTsap")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_COTPParameterCalledTsap) isCOTPParameterCalledTsap() bool {
	return true
}

func (m *_COTPParameterCalledTsap) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
