/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// RolePermissionType is the corresponding interface of RolePermissionType
type RolePermissionType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRoleId returns RoleId (property field)
	GetRoleId() NodeId
	// GetPermissions returns Permissions (property field)
	GetPermissions() PermissionType
}

// RolePermissionTypeExactly can be used when we want exactly this type and not a type which fulfills RolePermissionType.
// This is useful for switch cases.
type RolePermissionTypeExactly interface {
	RolePermissionType
	isRolePermissionType() bool
}

// _RolePermissionType is the data-structure of this message
type _RolePermissionType struct {
	*_ExtensionObjectDefinition
	RoleId      NodeId
	Permissions PermissionType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RolePermissionType) GetIdentifier() string {
	return "98"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RolePermissionType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_RolePermissionType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RolePermissionType) GetRoleId() NodeId {
	return m.RoleId
}

func (m *_RolePermissionType) GetPermissions() PermissionType {
	return m.Permissions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewRolePermissionType factory function for _RolePermissionType
func NewRolePermissionType(roleId NodeId, permissions PermissionType) *_RolePermissionType {
	_result := &_RolePermissionType{
		RoleId:                     roleId,
		Permissions:                permissions,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastRolePermissionType(structType any) RolePermissionType {
	if casted, ok := structType.(RolePermissionType); ok {
		return casted
	}
	if casted, ok := structType.(*RolePermissionType); ok {
		return *casted
	}
	return nil
}

func (m *_RolePermissionType) GetTypeName() string {
	return "RolePermissionType"
}

func (m *_RolePermissionType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (roleId)
	lengthInBits += m.RoleId.GetLengthInBits(ctx)

	// Simple field (permissions)
	lengthInBits += 32

	return lengthInBits
}

func (m *_RolePermissionType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RolePermissionTypeParse(ctx context.Context, theBytes []byte, identifier string) (RolePermissionType, error) {
	return RolePermissionTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func RolePermissionTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (RolePermissionType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("RolePermissionType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RolePermissionType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (roleId)
	if pullErr := readBuffer.PullContext("roleId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for roleId")
	}
	_roleId, _roleIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _roleIdErr != nil {
		return nil, errors.Wrap(_roleIdErr, "Error parsing 'roleId' field of RolePermissionType")
	}
	roleId := _roleId.(NodeId)
	if closeErr := readBuffer.CloseContext("roleId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for roleId")
	}

	// Simple Field (permissions)
	if pullErr := readBuffer.PullContext("permissions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for permissions")
	}
	_permissions, _permissionsErr := PermissionTypeParseWithBuffer(ctx, readBuffer)
	if _permissionsErr != nil {
		return nil, errors.Wrap(_permissionsErr, "Error parsing 'permissions' field of RolePermissionType")
	}
	permissions := _permissions
	if closeErr := readBuffer.CloseContext("permissions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for permissions")
	}

	if closeErr := readBuffer.CloseContext("RolePermissionType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RolePermissionType")
	}

	// Create a partially initialized instance
	_child := &_RolePermissionType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RoleId:                     roleId,
		Permissions:                permissions,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_RolePermissionType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RolePermissionType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RolePermissionType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RolePermissionType")
		}

		// Simple Field (roleId)
		if pushErr := writeBuffer.PushContext("roleId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for roleId")
		}
		_roleIdErr := writeBuffer.WriteSerializable(ctx, m.GetRoleId())
		if popErr := writeBuffer.PopContext("roleId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for roleId")
		}
		if _roleIdErr != nil {
			return errors.Wrap(_roleIdErr, "Error serializing 'roleId' field")
		}

		// Simple Field (permissions)
		if pushErr := writeBuffer.PushContext("permissions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for permissions")
		}
		_permissionsErr := writeBuffer.WriteSerializable(ctx, m.GetPermissions())
		if popErr := writeBuffer.PopContext("permissions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for permissions")
		}
		if _permissionsErr != nil {
			return errors.Wrap(_permissionsErr, "Error serializing 'permissions' field")
		}

		if popErr := writeBuffer.PopContext("RolePermissionType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RolePermissionType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RolePermissionType) isRolePermissionType() bool {
	return true
}

func (m *_RolePermissionType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
