/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// RegisterServerRequest is the corresponding interface of RegisterServerRequest
type RegisterServerRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetServer returns Server (property field)
	GetServer() ExtensionObjectDefinition
}

// RegisterServerRequestExactly can be used when we want exactly this type and not a type which fulfills RegisterServerRequest.
// This is useful for switch cases.
type RegisterServerRequestExactly interface {
	RegisterServerRequest
	isRegisterServerRequest() bool
}

// _RegisterServerRequest is the data-structure of this message
type _RegisterServerRequest struct {
	*_ExtensionObjectDefinition
	RequestHeader ExtensionObjectDefinition
	Server        ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RegisterServerRequest) GetIdentifier() string {
	return "437"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RegisterServerRequest) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_RegisterServerRequest) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RegisterServerRequest) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_RegisterServerRequest) GetServer() ExtensionObjectDefinition {
	return m.Server
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewRegisterServerRequest factory function for _RegisterServerRequest
func NewRegisterServerRequest(requestHeader ExtensionObjectDefinition, server ExtensionObjectDefinition) *_RegisterServerRequest {
	_result := &_RegisterServerRequest{
		RequestHeader:              requestHeader,
		Server:                     server,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastRegisterServerRequest(structType any) RegisterServerRequest {
	if casted, ok := structType.(RegisterServerRequest); ok {
		return casted
	}
	if casted, ok := structType.(*RegisterServerRequest); ok {
		return *casted
	}
	return nil
}

func (m *_RegisterServerRequest) GetTypeName() string {
	return "RegisterServerRequest"
}

func (m *_RegisterServerRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Simple field (server)
	lengthInBits += m.Server.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_RegisterServerRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RegisterServerRequestParse(ctx context.Context, theBytes []byte, identifier string) (RegisterServerRequest, error) {
	return RegisterServerRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func RegisterServerRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (RegisterServerRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("RegisterServerRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RegisterServerRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of RegisterServerRequest")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	// Simple Field (server)
	if pullErr := readBuffer.PullContext("server"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for server")
	}
	_server, _serverErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("434"))
	if _serverErr != nil {
		return nil, errors.Wrap(_serverErr, "Error parsing 'server' field of RegisterServerRequest")
	}
	server := _server.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("server"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for server")
	}

	if closeErr := readBuffer.CloseContext("RegisterServerRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RegisterServerRequest")
	}

	// Create a partially initialized instance
	_child := &_RegisterServerRequest{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RequestHeader:              requestHeader,
		Server:                     server,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_RegisterServerRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RegisterServerRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RegisterServerRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RegisterServerRequest")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Simple Field (server)
		if pushErr := writeBuffer.PushContext("server"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for server")
		}
		_serverErr := writeBuffer.WriteSerializable(ctx, m.GetServer())
		if popErr := writeBuffer.PopContext("server"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for server")
		}
		if _serverErr != nil {
			return errors.Wrap(_serverErr, "Error serializing 'server' field")
		}

		if popErr := writeBuffer.PopContext("RegisterServerRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RegisterServerRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RegisterServerRequest) isRegisterServerRequest() bool {
	return true
}

func (m *_RegisterServerRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
