/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// RegisterServer2Request is the corresponding interface of RegisterServer2Request
type RegisterServer2Request interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetServer returns Server (property field)
	GetServer() ExtensionObjectDefinition
	// GetNoOfDiscoveryConfiguration returns NoOfDiscoveryConfiguration (property field)
	GetNoOfDiscoveryConfiguration() int32
	// GetDiscoveryConfiguration returns DiscoveryConfiguration (property field)
	GetDiscoveryConfiguration() []ExtensionObject
}

// RegisterServer2RequestExactly can be used when we want exactly this type and not a type which fulfills RegisterServer2Request.
// This is useful for switch cases.
type RegisterServer2RequestExactly interface {
	RegisterServer2Request
	isRegisterServer2Request() bool
}

// _RegisterServer2Request is the data-structure of this message
type _RegisterServer2Request struct {
	*_ExtensionObjectDefinition
	RequestHeader              ExtensionObjectDefinition
	Server                     ExtensionObjectDefinition
	NoOfDiscoveryConfiguration int32
	DiscoveryConfiguration     []ExtensionObject
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RegisterServer2Request) GetIdentifier() string {
	return "12195"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RegisterServer2Request) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_RegisterServer2Request) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RegisterServer2Request) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_RegisterServer2Request) GetServer() ExtensionObjectDefinition {
	return m.Server
}

func (m *_RegisterServer2Request) GetNoOfDiscoveryConfiguration() int32 {
	return m.NoOfDiscoveryConfiguration
}

func (m *_RegisterServer2Request) GetDiscoveryConfiguration() []ExtensionObject {
	return m.DiscoveryConfiguration
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewRegisterServer2Request factory function for _RegisterServer2Request
func NewRegisterServer2Request(requestHeader ExtensionObjectDefinition, server ExtensionObjectDefinition, noOfDiscoveryConfiguration int32, discoveryConfiguration []ExtensionObject) *_RegisterServer2Request {
	_result := &_RegisterServer2Request{
		RequestHeader:              requestHeader,
		Server:                     server,
		NoOfDiscoveryConfiguration: noOfDiscoveryConfiguration,
		DiscoveryConfiguration:     discoveryConfiguration,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastRegisterServer2Request(structType any) RegisterServer2Request {
	if casted, ok := structType.(RegisterServer2Request); ok {
		return casted
	}
	if casted, ok := structType.(*RegisterServer2Request); ok {
		return *casted
	}
	return nil
}

func (m *_RegisterServer2Request) GetTypeName() string {
	return "RegisterServer2Request"
}

func (m *_RegisterServer2Request) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Simple field (server)
	lengthInBits += m.Server.GetLengthInBits(ctx)

	// Simple field (noOfDiscoveryConfiguration)
	lengthInBits += 32

	// Array field
	if len(m.DiscoveryConfiguration) > 0 {
		for _curItem, element := range m.DiscoveryConfiguration {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiscoveryConfiguration), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_RegisterServer2Request) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RegisterServer2RequestParse(ctx context.Context, theBytes []byte, identifier string) (RegisterServer2Request, error) {
	return RegisterServer2RequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func RegisterServer2RequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (RegisterServer2Request, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("RegisterServer2Request"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RegisterServer2Request")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of RegisterServer2Request")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	// Simple Field (server)
	if pullErr := readBuffer.PullContext("server"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for server")
	}
	_server, _serverErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("434"))
	if _serverErr != nil {
		return nil, errors.Wrap(_serverErr, "Error parsing 'server' field of RegisterServer2Request")
	}
	server := _server.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("server"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for server")
	}

	// Simple Field (noOfDiscoveryConfiguration)
	_noOfDiscoveryConfiguration, _noOfDiscoveryConfigurationErr := readBuffer.ReadInt32("noOfDiscoveryConfiguration", 32)
	if _noOfDiscoveryConfigurationErr != nil {
		return nil, errors.Wrap(_noOfDiscoveryConfigurationErr, "Error parsing 'noOfDiscoveryConfiguration' field of RegisterServer2Request")
	}
	noOfDiscoveryConfiguration := _noOfDiscoveryConfiguration

	// Array field (discoveryConfiguration)
	if pullErr := readBuffer.PullContext("discoveryConfiguration", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for discoveryConfiguration")
	}
	// Count array
	discoveryConfiguration := make([]ExtensionObject, utils.Max(noOfDiscoveryConfiguration, 0))
	// This happens when the size is set conditional to 0
	if len(discoveryConfiguration) == 0 {
		discoveryConfiguration = nil
	}
	{
		_numItems := uint16(utils.Max(noOfDiscoveryConfiguration, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectParseWithBuffer(arrayCtx, readBuffer, bool(true))
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'discoveryConfiguration' field of RegisterServer2Request")
			}
			discoveryConfiguration[_curItem] = _item.(ExtensionObject)
		}
	}
	if closeErr := readBuffer.CloseContext("discoveryConfiguration", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for discoveryConfiguration")
	}

	if closeErr := readBuffer.CloseContext("RegisterServer2Request"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RegisterServer2Request")
	}

	// Create a partially initialized instance
	_child := &_RegisterServer2Request{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RequestHeader:              requestHeader,
		Server:                     server,
		NoOfDiscoveryConfiguration: noOfDiscoveryConfiguration,
		DiscoveryConfiguration:     discoveryConfiguration,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_RegisterServer2Request) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RegisterServer2Request) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RegisterServer2Request"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RegisterServer2Request")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Simple Field (server)
		if pushErr := writeBuffer.PushContext("server"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for server")
		}
		_serverErr := writeBuffer.WriteSerializable(ctx, m.GetServer())
		if popErr := writeBuffer.PopContext("server"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for server")
		}
		if _serverErr != nil {
			return errors.Wrap(_serverErr, "Error serializing 'server' field")
		}

		// Simple Field (noOfDiscoveryConfiguration)
		noOfDiscoveryConfiguration := int32(m.GetNoOfDiscoveryConfiguration())
		_noOfDiscoveryConfigurationErr := writeBuffer.WriteInt32("noOfDiscoveryConfiguration", 32, (noOfDiscoveryConfiguration))
		if _noOfDiscoveryConfigurationErr != nil {
			return errors.Wrap(_noOfDiscoveryConfigurationErr, "Error serializing 'noOfDiscoveryConfiguration' field")
		}

		// Array Field (discoveryConfiguration)
		if pushErr := writeBuffer.PushContext("discoveryConfiguration", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for discoveryConfiguration")
		}
		for _curItem, _element := range m.GetDiscoveryConfiguration() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetDiscoveryConfiguration()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'discoveryConfiguration' field")
			}
		}
		if popErr := writeBuffer.PopContext("discoveryConfiguration", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for discoveryConfiguration")
		}

		if popErr := writeBuffer.PopContext("RegisterServer2Request"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RegisterServer2Request")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RegisterServer2Request) isRegisterServer2Request() bool {
	return true
}

func (m *_RegisterServer2Request) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
