/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Range is the corresponding interface of Range
type Range interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetLow returns Low (property field)
	GetLow() float64
	// GetHigh returns High (property field)
	GetHigh() float64
}

// RangeExactly can be used when we want exactly this type and not a type which fulfills Range.
// This is useful for switch cases.
type RangeExactly interface {
	Range
	isRange() bool
}

// _Range is the data-structure of this message
type _Range struct {
	*_ExtensionObjectDefinition
	Low  float64
	High float64
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_Range) GetIdentifier() string {
	return "886"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_Range) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_Range) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Range) GetLow() float64 {
	return m.Low
}

func (m *_Range) GetHigh() float64 {
	return m.High
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewRange factory function for _Range
func NewRange(low float64, high float64) *_Range {
	_result := &_Range{
		Low:                        low,
		High:                       high,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastRange(structType any) Range {
	if casted, ok := structType.(Range); ok {
		return casted
	}
	if casted, ok := structType.(*Range); ok {
		return *casted
	}
	return nil
}

func (m *_Range) GetTypeName() string {
	return "Range"
}

func (m *_Range) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (low)
	lengthInBits += 64

	// Simple field (high)
	lengthInBits += 64

	return lengthInBits
}

func (m *_Range) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func RangeParse(ctx context.Context, theBytes []byte, identifier string) (Range, error) {
	return RangeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func RangeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (Range, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("Range"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Range")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (low)
	_low, _lowErr := readBuffer.ReadFloat64("low", 64)
	if _lowErr != nil {
		return nil, errors.Wrap(_lowErr, "Error parsing 'low' field of Range")
	}
	low := _low

	// Simple Field (high)
	_high, _highErr := readBuffer.ReadFloat64("high", 64)
	if _highErr != nil {
		return nil, errors.Wrap(_highErr, "Error parsing 'high' field of Range")
	}
	high := _high

	if closeErr := readBuffer.CloseContext("Range"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Range")
	}

	// Create a partially initialized instance
	_child := &_Range{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Low:                        low,
		High:                       high,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_Range) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Range) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("Range"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for Range")
		}

		// Simple Field (low)
		low := float64(m.GetLow())
		_lowErr := writeBuffer.WriteFloat64("low", 64, (low))
		if _lowErr != nil {
			return errors.Wrap(_lowErr, "Error serializing 'low' field")
		}

		// Simple Field (high)
		high := float64(m.GetHigh())
		_highErr := writeBuffer.WriteFloat64("high", 64, (high))
		if _highErr != nil {
			return errors.Wrap(_highErr, "Error serializing 'high' field")
		}

		if popErr := writeBuffer.PopContext("Range"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for Range")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_Range) isRange() bool {
	return true
}

func (m *_Range) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
