/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// QueryNextRequest is the corresponding interface of QueryNextRequest
type QueryNextRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() ExtensionObjectDefinition
	// GetReleaseContinuationPoint returns ReleaseContinuationPoint (property field)
	GetReleaseContinuationPoint() bool
	// GetContinuationPoint returns ContinuationPoint (property field)
	GetContinuationPoint() PascalByteString
}

// QueryNextRequestExactly can be used when we want exactly this type and not a type which fulfills QueryNextRequest.
// This is useful for switch cases.
type QueryNextRequestExactly interface {
	QueryNextRequest
	isQueryNextRequest() bool
}

// _QueryNextRequest is the data-structure of this message
type _QueryNextRequest struct {
	*_ExtensionObjectDefinition
	RequestHeader            ExtensionObjectDefinition
	ReleaseContinuationPoint bool
	ContinuationPoint        PascalByteString
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_QueryNextRequest) GetIdentifier() string {
	return "621"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_QueryNextRequest) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_QueryNextRequest) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_QueryNextRequest) GetRequestHeader() ExtensionObjectDefinition {
	return m.RequestHeader
}

func (m *_QueryNextRequest) GetReleaseContinuationPoint() bool {
	return m.ReleaseContinuationPoint
}

func (m *_QueryNextRequest) GetContinuationPoint() PascalByteString {
	return m.ContinuationPoint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewQueryNextRequest factory function for _QueryNextRequest
func NewQueryNextRequest(requestHeader ExtensionObjectDefinition, releaseContinuationPoint bool, continuationPoint PascalByteString) *_QueryNextRequest {
	_result := &_QueryNextRequest{
		RequestHeader:              requestHeader,
		ReleaseContinuationPoint:   releaseContinuationPoint,
		ContinuationPoint:          continuationPoint,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastQueryNextRequest(structType any) QueryNextRequest {
	if casted, ok := structType.(QueryNextRequest); ok {
		return casted
	}
	if casted, ok := structType.(*QueryNextRequest); ok {
		return *casted
	}
	return nil
}

func (m *_QueryNextRequest) GetTypeName() string {
	return "QueryNextRequest"
}

func (m *_QueryNextRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (releaseContinuationPoint)
	lengthInBits += 1

	// Simple field (continuationPoint)
	lengthInBits += m.ContinuationPoint.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_QueryNextRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func QueryNextRequestParse(ctx context.Context, theBytes []byte, identifier string) (QueryNextRequest, error) {
	return QueryNextRequestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func QueryNextRequestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (QueryNextRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("QueryNextRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for QueryNextRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (requestHeader)
	if pullErr := readBuffer.PullContext("requestHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestHeader")
	}
	_requestHeader, _requestHeaderErr := ExtensionObjectDefinitionParseWithBuffer(ctx, readBuffer, string("391"))
	if _requestHeaderErr != nil {
		return nil, errors.Wrap(_requestHeaderErr, "Error parsing 'requestHeader' field of QueryNextRequest")
	}
	requestHeader := _requestHeader.(ExtensionObjectDefinition)
	if closeErr := readBuffer.CloseContext("requestHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestHeader")
	}

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of QueryNextRequest")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (releaseContinuationPoint)
	_releaseContinuationPoint, _releaseContinuationPointErr := readBuffer.ReadBit("releaseContinuationPoint")
	if _releaseContinuationPointErr != nil {
		return nil, errors.Wrap(_releaseContinuationPointErr, "Error parsing 'releaseContinuationPoint' field of QueryNextRequest")
	}
	releaseContinuationPoint := _releaseContinuationPoint

	// Simple Field (continuationPoint)
	if pullErr := readBuffer.PullContext("continuationPoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for continuationPoint")
	}
	_continuationPoint, _continuationPointErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _continuationPointErr != nil {
		return nil, errors.Wrap(_continuationPointErr, "Error parsing 'continuationPoint' field of QueryNextRequest")
	}
	continuationPoint := _continuationPoint.(PascalByteString)
	if closeErr := readBuffer.CloseContext("continuationPoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for continuationPoint")
	}

	if closeErr := readBuffer.CloseContext("QueryNextRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for QueryNextRequest")
	}

	// Create a partially initialized instance
	_child := &_QueryNextRequest{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		RequestHeader:              requestHeader,
		ReleaseContinuationPoint:   releaseContinuationPoint,
		ContinuationPoint:          continuationPoint,
		reservedField0:             reservedField0,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_QueryNextRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_QueryNextRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("QueryNextRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for QueryNextRequest")
		}

		// Simple Field (requestHeader)
		if pushErr := writeBuffer.PushContext("requestHeader"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestHeader")
		}
		_requestHeaderErr := writeBuffer.WriteSerializable(ctx, m.GetRequestHeader())
		if popErr := writeBuffer.PopContext("requestHeader"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestHeader")
		}
		if _requestHeaderErr != nil {
			return errors.Wrap(_requestHeaderErr, "Error serializing 'requestHeader' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 7, reserved)
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (releaseContinuationPoint)
		releaseContinuationPoint := bool(m.GetReleaseContinuationPoint())
		_releaseContinuationPointErr := writeBuffer.WriteBit("releaseContinuationPoint", (releaseContinuationPoint))
		if _releaseContinuationPointErr != nil {
			return errors.Wrap(_releaseContinuationPointErr, "Error serializing 'releaseContinuationPoint' field")
		}

		// Simple Field (continuationPoint)
		if pushErr := writeBuffer.PushContext("continuationPoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for continuationPoint")
		}
		_continuationPointErr := writeBuffer.WriteSerializable(ctx, m.GetContinuationPoint())
		if popErr := writeBuffer.PopContext("continuationPoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for continuationPoint")
		}
		if _continuationPointErr != nil {
			return errors.Wrap(_continuationPointErr, "Error serializing 'continuationPoint' field")
		}

		if popErr := writeBuffer.PopContext("QueryNextRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for QueryNextRequest")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_QueryNextRequest) isQueryNextRequest() bool {
	return true
}

func (m *_QueryNextRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
