/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// PubSubGroupDataType is the corresponding interface of PubSubGroupDataType
type PubSubGroupDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetEnabled returns Enabled (property field)
	GetEnabled() bool
	// GetSecurityMode returns SecurityMode (property field)
	GetSecurityMode() MessageSecurityMode
	// GetSecurityGroupId returns SecurityGroupId (property field)
	GetSecurityGroupId() PascalString
	// GetNoOfSecurityKeyServices returns NoOfSecurityKeyServices (property field)
	GetNoOfSecurityKeyServices() int32
	// GetSecurityKeyServices returns SecurityKeyServices (property field)
	GetSecurityKeyServices() []ExtensionObjectDefinition
	// GetMaxNetworkMessageSize returns MaxNetworkMessageSize (property field)
	GetMaxNetworkMessageSize() uint32
	// GetNoOfGroupProperties returns NoOfGroupProperties (property field)
	GetNoOfGroupProperties() int32
	// GetGroupProperties returns GroupProperties (property field)
	GetGroupProperties() []ExtensionObjectDefinition
}

// PubSubGroupDataTypeExactly can be used when we want exactly this type and not a type which fulfills PubSubGroupDataType.
// This is useful for switch cases.
type PubSubGroupDataTypeExactly interface {
	PubSubGroupDataType
	isPubSubGroupDataType() bool
}

// _PubSubGroupDataType is the data-structure of this message
type _PubSubGroupDataType struct {
	*_ExtensionObjectDefinition
	Name                    PascalString
	Enabled                 bool
	SecurityMode            MessageSecurityMode
	SecurityGroupId         PascalString
	NoOfSecurityKeyServices int32
	SecurityKeyServices     []ExtensionObjectDefinition
	MaxNetworkMessageSize   uint32
	NoOfGroupProperties     int32
	GroupProperties         []ExtensionObjectDefinition
	// Reserved Fields
	reservedField0 *uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PubSubGroupDataType) GetIdentifier() string {
	return "15611"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PubSubGroupDataType) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_PubSubGroupDataType) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PubSubGroupDataType) GetName() PascalString {
	return m.Name
}

func (m *_PubSubGroupDataType) GetEnabled() bool {
	return m.Enabled
}

func (m *_PubSubGroupDataType) GetSecurityMode() MessageSecurityMode {
	return m.SecurityMode
}

func (m *_PubSubGroupDataType) GetSecurityGroupId() PascalString {
	return m.SecurityGroupId
}

func (m *_PubSubGroupDataType) GetNoOfSecurityKeyServices() int32 {
	return m.NoOfSecurityKeyServices
}

func (m *_PubSubGroupDataType) GetSecurityKeyServices() []ExtensionObjectDefinition {
	return m.SecurityKeyServices
}

func (m *_PubSubGroupDataType) GetMaxNetworkMessageSize() uint32 {
	return m.MaxNetworkMessageSize
}

func (m *_PubSubGroupDataType) GetNoOfGroupProperties() int32 {
	return m.NoOfGroupProperties
}

func (m *_PubSubGroupDataType) GetGroupProperties() []ExtensionObjectDefinition {
	return m.GroupProperties
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewPubSubGroupDataType factory function for _PubSubGroupDataType
func NewPubSubGroupDataType(name PascalString, enabled bool, securityMode MessageSecurityMode, securityGroupId PascalString, noOfSecurityKeyServices int32, securityKeyServices []ExtensionObjectDefinition, maxNetworkMessageSize uint32, noOfGroupProperties int32, groupProperties []ExtensionObjectDefinition) *_PubSubGroupDataType {
	_result := &_PubSubGroupDataType{
		Name:                       name,
		Enabled:                    enabled,
		SecurityMode:               securityMode,
		SecurityGroupId:            securityGroupId,
		NoOfSecurityKeyServices:    noOfSecurityKeyServices,
		SecurityKeyServices:        securityKeyServices,
		MaxNetworkMessageSize:      maxNetworkMessageSize,
		NoOfGroupProperties:        noOfGroupProperties,
		GroupProperties:            groupProperties,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastPubSubGroupDataType(structType any) PubSubGroupDataType {
	if casted, ok := structType.(PubSubGroupDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PubSubGroupDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PubSubGroupDataType) GetTypeName() string {
	return "PubSubGroupDataType"
}

func (m *_PubSubGroupDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (enabled)
	lengthInBits += 1

	// Simple field (securityMode)
	lengthInBits += 32

	// Simple field (securityGroupId)
	lengthInBits += m.SecurityGroupId.GetLengthInBits(ctx)

	// Simple field (noOfSecurityKeyServices)
	lengthInBits += 32

	// Array field
	if len(m.SecurityKeyServices) > 0 {
		for _curItem, element := range m.SecurityKeyServices {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecurityKeyServices), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (maxNetworkMessageSize)
	lengthInBits += 32

	// Simple field (noOfGroupProperties)
	lengthInBits += 32

	// Array field
	if len(m.GroupProperties) > 0 {
		for _curItem, element := range m.GroupProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GroupProperties), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PubSubGroupDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PubSubGroupDataTypeParse(ctx context.Context, theBytes []byte, identifier string) (PubSubGroupDataType, error) {
	return PubSubGroupDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func PubSubGroupDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (PubSubGroupDataType, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("PubSubGroupDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PubSubGroupDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (name)
	if pullErr := readBuffer.PullContext("name"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for name")
	}
	_name, _nameErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _nameErr != nil {
		return nil, errors.Wrap(_nameErr, "Error parsing 'name' field of PubSubGroupDataType")
	}
	name := _name.(PascalString)
	if closeErr := readBuffer.CloseContext("name"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for name")
	}

	var reservedField0 *uint8
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of PubSubGroupDataType")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]any{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Simple Field (enabled)
	_enabled, _enabledErr := readBuffer.ReadBit("enabled")
	if _enabledErr != nil {
		return nil, errors.Wrap(_enabledErr, "Error parsing 'enabled' field of PubSubGroupDataType")
	}
	enabled := _enabled

	// Simple Field (securityMode)
	if pullErr := readBuffer.PullContext("securityMode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityMode")
	}
	_securityMode, _securityModeErr := MessageSecurityModeParseWithBuffer(ctx, readBuffer)
	if _securityModeErr != nil {
		return nil, errors.Wrap(_securityModeErr, "Error parsing 'securityMode' field of PubSubGroupDataType")
	}
	securityMode := _securityMode
	if closeErr := readBuffer.CloseContext("securityMode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityMode")
	}

	// Simple Field (securityGroupId)
	if pullErr := readBuffer.PullContext("securityGroupId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityGroupId")
	}
	_securityGroupId, _securityGroupIdErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _securityGroupIdErr != nil {
		return nil, errors.Wrap(_securityGroupIdErr, "Error parsing 'securityGroupId' field of PubSubGroupDataType")
	}
	securityGroupId := _securityGroupId.(PascalString)
	if closeErr := readBuffer.CloseContext("securityGroupId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityGroupId")
	}

	// Simple Field (noOfSecurityKeyServices)
	_noOfSecurityKeyServices, _noOfSecurityKeyServicesErr := readBuffer.ReadInt32("noOfSecurityKeyServices", 32)
	if _noOfSecurityKeyServicesErr != nil {
		return nil, errors.Wrap(_noOfSecurityKeyServicesErr, "Error parsing 'noOfSecurityKeyServices' field of PubSubGroupDataType")
	}
	noOfSecurityKeyServices := _noOfSecurityKeyServices

	// Array field (securityKeyServices)
	if pullErr := readBuffer.PullContext("securityKeyServices", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for securityKeyServices")
	}
	// Count array
	securityKeyServices := make([]ExtensionObjectDefinition, utils.Max(noOfSecurityKeyServices, 0))
	// This happens when the size is set conditional to 0
	if len(securityKeyServices) == 0 {
		securityKeyServices = nil
	}
	{
		_numItems := uint16(utils.Max(noOfSecurityKeyServices, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectDefinitionParseWithBuffer(arrayCtx, readBuffer, "314")
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'securityKeyServices' field of PubSubGroupDataType")
			}
			securityKeyServices[_curItem] = _item.(ExtensionObjectDefinition)
		}
	}
	if closeErr := readBuffer.CloseContext("securityKeyServices", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for securityKeyServices")
	}

	// Simple Field (maxNetworkMessageSize)
	_maxNetworkMessageSize, _maxNetworkMessageSizeErr := readBuffer.ReadUint32("maxNetworkMessageSize", 32)
	if _maxNetworkMessageSizeErr != nil {
		return nil, errors.Wrap(_maxNetworkMessageSizeErr, "Error parsing 'maxNetworkMessageSize' field of PubSubGroupDataType")
	}
	maxNetworkMessageSize := _maxNetworkMessageSize

	// Simple Field (noOfGroupProperties)
	_noOfGroupProperties, _noOfGroupPropertiesErr := readBuffer.ReadInt32("noOfGroupProperties", 32)
	if _noOfGroupPropertiesErr != nil {
		return nil, errors.Wrap(_noOfGroupPropertiesErr, "Error parsing 'noOfGroupProperties' field of PubSubGroupDataType")
	}
	noOfGroupProperties := _noOfGroupProperties

	// Array field (groupProperties)
	if pullErr := readBuffer.PullContext("groupProperties", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for groupProperties")
	}
	// Count array
	groupProperties := make([]ExtensionObjectDefinition, utils.Max(noOfGroupProperties, 0))
	// This happens when the size is set conditional to 0
	if len(groupProperties) == 0 {
		groupProperties = nil
	}
	{
		_numItems := uint16(utils.Max(noOfGroupProperties, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectDefinitionParseWithBuffer(arrayCtx, readBuffer, "14535")
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'groupProperties' field of PubSubGroupDataType")
			}
			groupProperties[_curItem] = _item.(ExtensionObjectDefinition)
		}
	}
	if closeErr := readBuffer.CloseContext("groupProperties", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for groupProperties")
	}

	if closeErr := readBuffer.CloseContext("PubSubGroupDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PubSubGroupDataType")
	}

	// Create a partially initialized instance
	_child := &_PubSubGroupDataType{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		Name:                       name,
		Enabled:                    enabled,
		SecurityMode:               securityMode,
		SecurityGroupId:            securityGroupId,
		NoOfSecurityKeyServices:    noOfSecurityKeyServices,
		SecurityKeyServices:        securityKeyServices,
		MaxNetworkMessageSize:      maxNetworkMessageSize,
		NoOfGroupProperties:        noOfGroupProperties,
		GroupProperties:            groupProperties,
		reservedField0:             reservedField0,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_PubSubGroupDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PubSubGroupDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PubSubGroupDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PubSubGroupDataType")
		}

		// Simple Field (name)
		if pushErr := writeBuffer.PushContext("name"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for name")
		}
		_nameErr := writeBuffer.WriteSerializable(ctx, m.GetName())
		if popErr := writeBuffer.PopContext("name"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for name")
		}
		if _nameErr != nil {
			return errors.Wrap(_nameErr, "Error serializing 'name' field")
		}

		// Reserved Field (reserved)
		{
			var reserved uint8 = uint8(0x00)
			if m.reservedField0 != nil {
				log.Info().Fields(map[string]any{
					"expected value": uint8(0x00),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint8("reserved", 7, reserved)
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (enabled)
		enabled := bool(m.GetEnabled())
		_enabledErr := writeBuffer.WriteBit("enabled", (enabled))
		if _enabledErr != nil {
			return errors.Wrap(_enabledErr, "Error serializing 'enabled' field")
		}

		// Simple Field (securityMode)
		if pushErr := writeBuffer.PushContext("securityMode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityMode")
		}
		_securityModeErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityMode())
		if popErr := writeBuffer.PopContext("securityMode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityMode")
		}
		if _securityModeErr != nil {
			return errors.Wrap(_securityModeErr, "Error serializing 'securityMode' field")
		}

		// Simple Field (securityGroupId)
		if pushErr := writeBuffer.PushContext("securityGroupId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityGroupId")
		}
		_securityGroupIdErr := writeBuffer.WriteSerializable(ctx, m.GetSecurityGroupId())
		if popErr := writeBuffer.PopContext("securityGroupId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityGroupId")
		}
		if _securityGroupIdErr != nil {
			return errors.Wrap(_securityGroupIdErr, "Error serializing 'securityGroupId' field")
		}

		// Simple Field (noOfSecurityKeyServices)
		noOfSecurityKeyServices := int32(m.GetNoOfSecurityKeyServices())
		_noOfSecurityKeyServicesErr := writeBuffer.WriteInt32("noOfSecurityKeyServices", 32, (noOfSecurityKeyServices))
		if _noOfSecurityKeyServicesErr != nil {
			return errors.Wrap(_noOfSecurityKeyServicesErr, "Error serializing 'noOfSecurityKeyServices' field")
		}

		// Array Field (securityKeyServices)
		if pushErr := writeBuffer.PushContext("securityKeyServices", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for securityKeyServices")
		}
		for _curItem, _element := range m.GetSecurityKeyServices() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetSecurityKeyServices()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'securityKeyServices' field")
			}
		}
		if popErr := writeBuffer.PopContext("securityKeyServices", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for securityKeyServices")
		}

		// Simple Field (maxNetworkMessageSize)
		maxNetworkMessageSize := uint32(m.GetMaxNetworkMessageSize())
		_maxNetworkMessageSizeErr := writeBuffer.WriteUint32("maxNetworkMessageSize", 32, (maxNetworkMessageSize))
		if _maxNetworkMessageSizeErr != nil {
			return errors.Wrap(_maxNetworkMessageSizeErr, "Error serializing 'maxNetworkMessageSize' field")
		}

		// Simple Field (noOfGroupProperties)
		noOfGroupProperties := int32(m.GetNoOfGroupProperties())
		_noOfGroupPropertiesErr := writeBuffer.WriteInt32("noOfGroupProperties", 32, (noOfGroupProperties))
		if _noOfGroupPropertiesErr != nil {
			return errors.Wrap(_noOfGroupPropertiesErr, "Error serializing 'noOfGroupProperties' field")
		}

		// Array Field (groupProperties)
		if pushErr := writeBuffer.PushContext("groupProperties", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for groupProperties")
		}
		for _curItem, _element := range m.GetGroupProperties() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetGroupProperties()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'groupProperties' field")
			}
		}
		if popErr := writeBuffer.PopContext("groupProperties", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for groupProperties")
		}

		if popErr := writeBuffer.PopContext("PubSubGroupDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PubSubGroupDataType")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PubSubGroupDataType) isPubSubGroupDataType() bool {
	return true
}

func (m *_PubSubGroupDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
