/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaStatusCode is an enum
type OpcuaStatusCode uint32

type IOpcuaStatusCode interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaStatusCode_Good                                                            OpcuaStatusCode = 0x00000000
	OpcuaStatusCode_Uncertain                                                       OpcuaStatusCode = 0x40000000
	OpcuaStatusCode_Bad                                                             OpcuaStatusCode = 0x80000000
	OpcuaStatusCode_BadUnexpectedError                                              OpcuaStatusCode = 0x80010000
	OpcuaStatusCode_BadInternalError                                                OpcuaStatusCode = 0x80020000
	OpcuaStatusCode_BadOutOfMemory                                                  OpcuaStatusCode = 0x80030000
	OpcuaStatusCode_BadResourceUnavailable                                          OpcuaStatusCode = 0x80040000
	OpcuaStatusCode_BadCommunicationError                                           OpcuaStatusCode = 0x80050000
	OpcuaStatusCode_BadEncodingError                                                OpcuaStatusCode = 0x80060000
	OpcuaStatusCode_BadDecodingError                                                OpcuaStatusCode = 0x80070000
	OpcuaStatusCode_BadEncodingLimitsExceeded                                       OpcuaStatusCode = 0x80080000
	OpcuaStatusCode_BadRequestTooLarge                                              OpcuaStatusCode = 0x80B80000
	OpcuaStatusCode_BadResponseTooLarge                                             OpcuaStatusCode = 0x80B90000
	OpcuaStatusCode_BadUnknownResponse                                              OpcuaStatusCode = 0x80090000
	OpcuaStatusCode_BadTimeout                                                      OpcuaStatusCode = 0x800A0000
	OpcuaStatusCode_BadServiceUnsupported                                           OpcuaStatusCode = 0x800B0000
	OpcuaStatusCode_BadShutdown                                                     OpcuaStatusCode = 0x800C0000
	OpcuaStatusCode_BadServerNotConnected                                           OpcuaStatusCode = 0x800D0000
	OpcuaStatusCode_BadServerHalted                                                 OpcuaStatusCode = 0x800E0000
	OpcuaStatusCode_BadNothingToDo                                                  OpcuaStatusCode = 0x800F0000
	OpcuaStatusCode_BadTooManyOperations                                            OpcuaStatusCode = 0x80100000
	OpcuaStatusCode_BadTooManyMonitoredItems                                        OpcuaStatusCode = 0x80DB0000
	OpcuaStatusCode_BadDataTypeIdUnknown                                            OpcuaStatusCode = 0x80110000
	OpcuaStatusCode_BadCertificateInvalid                                           OpcuaStatusCode = 0x80120000
	OpcuaStatusCode_BadSecurityChecksFailed                                         OpcuaStatusCode = 0x80130000
	OpcuaStatusCode_BadCertificatePolicyCheckFailed                                 OpcuaStatusCode = 0x81140000
	OpcuaStatusCode_BadCertificateTimeInvalid                                       OpcuaStatusCode = 0x80140000
	OpcuaStatusCode_BadCertificateIssuerTimeInvalid                                 OpcuaStatusCode = 0x80150000
	OpcuaStatusCode_BadCertificateHostNameInvalid                                   OpcuaStatusCode = 0x80160000
	OpcuaStatusCode_BadCertificateUriInvalid                                        OpcuaStatusCode = 0x80170000
	OpcuaStatusCode_BadCertificateUseNotAllowed                                     OpcuaStatusCode = 0x80180000
	OpcuaStatusCode_BadCertificateIssuerUseNotAllowed                               OpcuaStatusCode = 0x80190000
	OpcuaStatusCode_BadCertificateUntrusted                                         OpcuaStatusCode = 0x801A0000
	OpcuaStatusCode_BadCertificateRevocationUnknown                                 OpcuaStatusCode = 0x801B0000
	OpcuaStatusCode_BadCertificateIssuerRevocationUnknown                           OpcuaStatusCode = 0x801C0000
	OpcuaStatusCode_BadCertificateRevoked                                           OpcuaStatusCode = 0x801D0000
	OpcuaStatusCode_BadCertificateIssuerRevoked                                     OpcuaStatusCode = 0x801E0000
	OpcuaStatusCode_BadCertificateChainIncomplete                                   OpcuaStatusCode = 0x810D0000
	OpcuaStatusCode_BadUserAccessDenied                                             OpcuaStatusCode = 0x801F0000
	OpcuaStatusCode_BadIdentityTokenInvalid                                         OpcuaStatusCode = 0x80200000
	OpcuaStatusCode_BadIdentityTokenRejected                                        OpcuaStatusCode = 0x80210000
	OpcuaStatusCode_BadSecureChannelIdInvalid                                       OpcuaStatusCode = 0x80220000
	OpcuaStatusCode_BadInvalidTimestamp                                             OpcuaStatusCode = 0x80230000
	OpcuaStatusCode_BadNonceInvalid                                                 OpcuaStatusCode = 0x80240000
	OpcuaStatusCode_BadSessionIdInvalid                                             OpcuaStatusCode = 0x80250000
	OpcuaStatusCode_BadSessionClosed                                                OpcuaStatusCode = 0x80260000
	OpcuaStatusCode_BadSessionNotActivated                                          OpcuaStatusCode = 0x80270000
	OpcuaStatusCode_BadSubscriptionIdInvalid                                        OpcuaStatusCode = 0x80280000
	OpcuaStatusCode_BadRequestHeaderInvalid                                         OpcuaStatusCode = 0x802A0000
	OpcuaStatusCode_BadTimestampsToReturnInvalid                                    OpcuaStatusCode = 0x802B0000
	OpcuaStatusCode_BadRequestCancelledByClient                                     OpcuaStatusCode = 0x802C0000
	OpcuaStatusCode_BadTooManyArguments                                             OpcuaStatusCode = 0x80E50000
	OpcuaStatusCode_BadLicenseExpired                                               OpcuaStatusCode = 0x810E0000
	OpcuaStatusCode_BadLicenseLimitsExceeded                                        OpcuaStatusCode = 0x810F0000
	OpcuaStatusCode_BadLicenseNotAvailable                                          OpcuaStatusCode = 0x81100000
	OpcuaStatusCode_GoodSubscriptionTransferred                                     OpcuaStatusCode = 0x002D0000
	OpcuaStatusCode_GoodCompletesAsynchronously                                     OpcuaStatusCode = 0x002E0000
	OpcuaStatusCode_GoodOverload                                                    OpcuaStatusCode = 0x002F0000
	OpcuaStatusCode_GoodClamped                                                     OpcuaStatusCode = 0x00300000
	OpcuaStatusCode_BadNoCommunication                                              OpcuaStatusCode = 0x80310000
	OpcuaStatusCode_BadWaitingForInitialData                                        OpcuaStatusCode = 0x80320000
	OpcuaStatusCode_BadNodeIdInvalid                                                OpcuaStatusCode = 0x80330000
	OpcuaStatusCode_BadNodeIdUnknown                                                OpcuaStatusCode = 0x80340000
	OpcuaStatusCode_BadAttributeIdInvalid                                           OpcuaStatusCode = 0x80350000
	OpcuaStatusCode_BadIndexRangeInvalid                                            OpcuaStatusCode = 0x80360000
	OpcuaStatusCode_BadIndexRangeNoData                                             OpcuaStatusCode = 0x80370000
	OpcuaStatusCode_BadDataEncodingInvalid                                          OpcuaStatusCode = 0x80380000
	OpcuaStatusCode_BadDataEncodingUnsupported                                      OpcuaStatusCode = 0x80390000
	OpcuaStatusCode_BadNotReadable                                                  OpcuaStatusCode = 0x803A0000
	OpcuaStatusCode_BadNotWritable                                                  OpcuaStatusCode = 0x803B0000
	OpcuaStatusCode_BadOutOfRange                                                   OpcuaStatusCode = 0x803C0000
	OpcuaStatusCode_BadNotSupported                                                 OpcuaStatusCode = 0x803D0000
	OpcuaStatusCode_BadNotFound                                                     OpcuaStatusCode = 0x803E0000
	OpcuaStatusCode_BadObjectDeleted                                                OpcuaStatusCode = 0x803F0000
	OpcuaStatusCode_BadNotImplemented                                               OpcuaStatusCode = 0x80400000
	OpcuaStatusCode_BadMonitoringModeInvalid                                        OpcuaStatusCode = 0x80410000
	OpcuaStatusCode_BadMonitoredItemIdInvalid                                       OpcuaStatusCode = 0x80420000
	OpcuaStatusCode_BadMonitoredItemFilterInvalid                                   OpcuaStatusCode = 0x80430000
	OpcuaStatusCode_BadMonitoredItemFilterUnsupported                               OpcuaStatusCode = 0x80440000
	OpcuaStatusCode_BadFilterNotAllowed                                             OpcuaStatusCode = 0x80450000
	OpcuaStatusCode_BadStructureMissing                                             OpcuaStatusCode = 0x80460000
	OpcuaStatusCode_BadEventFilterInvalid                                           OpcuaStatusCode = 0x80470000
	OpcuaStatusCode_BadContentFilterInvalid                                         OpcuaStatusCode = 0x80480000
	OpcuaStatusCode_BadFilterOperatorInvalid                                        OpcuaStatusCode = 0x80C10000
	OpcuaStatusCode_BadFilterOperatorUnsupported                                    OpcuaStatusCode = 0x80C20000
	OpcuaStatusCode_BadFilterOperandCountMismatch                                   OpcuaStatusCode = 0x80C30000
	OpcuaStatusCode_BadFilterOperandInvalid                                         OpcuaStatusCode = 0x80490000
	OpcuaStatusCode_BadFilterElementInvalid                                         OpcuaStatusCode = 0x80C40000
	OpcuaStatusCode_BadFilterLiteralInvalid                                         OpcuaStatusCode = 0x80C50000
	OpcuaStatusCode_BadContinuationPointInvalid                                     OpcuaStatusCode = 0x804A0000
	OpcuaStatusCode_BadNoContinuationPoints                                         OpcuaStatusCode = 0x804B0000
	OpcuaStatusCode_BadReferenceTypeIdInvalid                                       OpcuaStatusCode = 0x804C0000
	OpcuaStatusCode_BadBrowseDirectionInvalid                                       OpcuaStatusCode = 0x804D0000
	OpcuaStatusCode_BadNodeNotInView                                                OpcuaStatusCode = 0x804E0000
	OpcuaStatusCode_BadNumericOverflow                                              OpcuaStatusCode = 0x81120000
	OpcuaStatusCode_BadServerUriInvalid                                             OpcuaStatusCode = 0x804F0000
	OpcuaStatusCode_BadServerNameMissing                                            OpcuaStatusCode = 0x80500000
	OpcuaStatusCode_BadDiscoveryUrlMissing                                          OpcuaStatusCode = 0x80510000
	OpcuaStatusCode_BadSempahoreFileMissing                                         OpcuaStatusCode = 0x80520000
	OpcuaStatusCode_BadRequestTypeInvalid                                           OpcuaStatusCode = 0x80530000
	OpcuaStatusCode_BadSecurityModeRejected                                         OpcuaStatusCode = 0x80540000
	OpcuaStatusCode_BadSecurityPolicyRejected                                       OpcuaStatusCode = 0x80550000
	OpcuaStatusCode_BadTooManySessions                                              OpcuaStatusCode = 0x80560000
	OpcuaStatusCode_BadUserSignatureInvalid                                         OpcuaStatusCode = 0x80570000
	OpcuaStatusCode_BadApplicationSignatureInvalid                                  OpcuaStatusCode = 0x80580000
	OpcuaStatusCode_BadNoValidCertificates                                          OpcuaStatusCode = 0x80590000
	OpcuaStatusCode_BadIdentityChangeNotSupported                                   OpcuaStatusCode = 0x80C60000
	OpcuaStatusCode_BadRequestCancelledByRequest                                    OpcuaStatusCode = 0x805A0000
	OpcuaStatusCode_BadParentNodeIdInvalid                                          OpcuaStatusCode = 0x805B0000
	OpcuaStatusCode_BadReferenceNotAllowed                                          OpcuaStatusCode = 0x805C0000
	OpcuaStatusCode_BadNodeIdRejected                                               OpcuaStatusCode = 0x805D0000
	OpcuaStatusCode_BadNodeIdExists                                                 OpcuaStatusCode = 0x805E0000
	OpcuaStatusCode_BadNodeClassInvalid                                             OpcuaStatusCode = 0x805F0000
	OpcuaStatusCode_BadBrowseNameInvalid                                            OpcuaStatusCode = 0x80600000
	OpcuaStatusCode_BadBrowseNameDuplicated                                         OpcuaStatusCode = 0x80610000
	OpcuaStatusCode_BadNodeAttributesInvalid                                        OpcuaStatusCode = 0x80620000
	OpcuaStatusCode_BadTypeDefinitionInvalid                                        OpcuaStatusCode = 0x80630000
	OpcuaStatusCode_BadSourceNodeIdInvalid                                          OpcuaStatusCode = 0x80640000
	OpcuaStatusCode_BadTargetNodeIdInvalid                                          OpcuaStatusCode = 0x80650000
	OpcuaStatusCode_BadDuplicateReferenceNotAllowed                                 OpcuaStatusCode = 0x80660000
	OpcuaStatusCode_BadInvalidSelfReference                                         OpcuaStatusCode = 0x80670000
	OpcuaStatusCode_BadReferenceLocalOnly                                           OpcuaStatusCode = 0x80680000
	OpcuaStatusCode_BadNoDeleteRights                                               OpcuaStatusCode = 0x80690000
	OpcuaStatusCode_UncertainReferenceNotDeleted                                    OpcuaStatusCode = 0x40BC0000
	OpcuaStatusCode_BadServerIndexInvalid                                           OpcuaStatusCode = 0x806A0000
	OpcuaStatusCode_BadViewIdUnknown                                                OpcuaStatusCode = 0x806B0000
	OpcuaStatusCode_BadViewTimestampInvalid                                         OpcuaStatusCode = 0x80C90000
	OpcuaStatusCode_BadViewParameterMismatch                                        OpcuaStatusCode = 0x80CA0000
	OpcuaStatusCode_BadViewVersionInvalid                                           OpcuaStatusCode = 0x80CB0000
	OpcuaStatusCode_UncertainNotAllNodesAvailable                                   OpcuaStatusCode = 0x40C00000
	OpcuaStatusCode_GoodResultsMayBeIncomplete                                      OpcuaStatusCode = 0x00BA0000
	OpcuaStatusCode_BadNotTypeDefinition                                            OpcuaStatusCode = 0x80C80000
	OpcuaStatusCode_UncertainReferenceOutOfServer                                   OpcuaStatusCode = 0x406C0000
	OpcuaStatusCode_BadTooManyMatches                                               OpcuaStatusCode = 0x806D0000
	OpcuaStatusCode_BadQueryTooComplex                                              OpcuaStatusCode = 0x806E0000
	OpcuaStatusCode_BadNoMatch                                                      OpcuaStatusCode = 0x806F0000
	OpcuaStatusCode_BadMaxAgeInvalid                                                OpcuaStatusCode = 0x80700000
	OpcuaStatusCode_BadSecurityModeInsufficient                                     OpcuaStatusCode = 0x80E60000
	OpcuaStatusCode_BadHistoryOperationInvalid                                      OpcuaStatusCode = 0x80710000
	OpcuaStatusCode_BadHistoryOperationUnsupported                                  OpcuaStatusCode = 0x80720000
	OpcuaStatusCode_BadInvalidTimestampArgument                                     OpcuaStatusCode = 0x80BD0000
	OpcuaStatusCode_BadWriteNotSupported                                            OpcuaStatusCode = 0x80730000
	OpcuaStatusCode_BadTypeMismatch                                                 OpcuaStatusCode = 0x80740000
	OpcuaStatusCode_BadMethodInvalid                                                OpcuaStatusCode = 0x80750000
	OpcuaStatusCode_BadArgumentsMissing                                             OpcuaStatusCode = 0x80760000
	OpcuaStatusCode_BadNotExecutable                                                OpcuaStatusCode = 0x81110000
	OpcuaStatusCode_BadTooManySubscriptions                                         OpcuaStatusCode = 0x80770000
	OpcuaStatusCode_BadTooManyPublishRequests                                       OpcuaStatusCode = 0x80780000
	OpcuaStatusCode_BadNoSubscription                                               OpcuaStatusCode = 0x80790000
	OpcuaStatusCode_BadSequenceNumberUnknown                                        OpcuaStatusCode = 0x807A0000
	OpcuaStatusCode_GoodRetransmissionQueueNotSupported                             OpcuaStatusCode = 0x00DF0000
	OpcuaStatusCode_BadMessageNotAvailable                                          OpcuaStatusCode = 0x807B0000
	OpcuaStatusCode_BadInsufficientClientProfile                                    OpcuaStatusCode = 0x807C0000
	OpcuaStatusCode_BadStateNotActive                                               OpcuaStatusCode = 0x80BF0000
	OpcuaStatusCode_BadAlreadyExists                                                OpcuaStatusCode = 0x81150000
	OpcuaStatusCode_BadTcpServerTooBusy                                             OpcuaStatusCode = 0x807D0000
	OpcuaStatusCode_BadTcpMessageTypeInvalid                                        OpcuaStatusCode = 0x807E0000
	OpcuaStatusCode_BadTcpSecureChannelUnknown                                      OpcuaStatusCode = 0x807F0000
	OpcuaStatusCode_BadTcpMessageTooLarge                                           OpcuaStatusCode = 0x80800000
	OpcuaStatusCode_BadTcpNotEnoughResources                                        OpcuaStatusCode = 0x80810000
	OpcuaStatusCode_BadTcpInternalError                                             OpcuaStatusCode = 0x80820000
	OpcuaStatusCode_BadTcpEndpointUrlInvalid                                        OpcuaStatusCode = 0x80830000
	OpcuaStatusCode_BadRequestInterrupted                                           OpcuaStatusCode = 0x80840000
	OpcuaStatusCode_BadRequestTimeout                                               OpcuaStatusCode = 0x80850000
	OpcuaStatusCode_BadSecureChannelClosed                                          OpcuaStatusCode = 0x80860000
	OpcuaStatusCode_BadSecureChannelTokenUnknown                                    OpcuaStatusCode = 0x80870000
	OpcuaStatusCode_BadSequenceNumberInvalid                                        OpcuaStatusCode = 0x80880000
	OpcuaStatusCode_BadProtocolVersionUnsupported                                   OpcuaStatusCode = 0x80BE0000
	OpcuaStatusCode_BadConfigurationError                                           OpcuaStatusCode = 0x80890000
	OpcuaStatusCode_BadNotConnected                                                 OpcuaStatusCode = 0x808A0000
	OpcuaStatusCode_BadDeviceFailure                                                OpcuaStatusCode = 0x808B0000
	OpcuaStatusCode_BadSensorFailure                                                OpcuaStatusCode = 0x808C0000
	OpcuaStatusCode_BadOutOfService                                                 OpcuaStatusCode = 0x808D0000
	OpcuaStatusCode_BadDeadbandFilterInvalid                                        OpcuaStatusCode = 0x808E0000
	OpcuaStatusCode_UncertainNoCommunicationLastUsableValue                         OpcuaStatusCode = 0x408F0000
	OpcuaStatusCode_UncertainLastUsableValue                                        OpcuaStatusCode = 0x40900000
	OpcuaStatusCode_UncertainSubstituteValue                                        OpcuaStatusCode = 0x40910000
	OpcuaStatusCode_UncertainInitialValue                                           OpcuaStatusCode = 0x40920000
	OpcuaStatusCode_UncertainSensorNotAccurate                                      OpcuaStatusCode = 0x40930000
	OpcuaStatusCode_UncertainEngineeringUnitsExceeded                               OpcuaStatusCode = 0x40940000
	OpcuaStatusCode_UncertainSubNormal                                              OpcuaStatusCode = 0x40950000
	OpcuaStatusCode_GoodLocalOverride                                               OpcuaStatusCode = 0x00960000
	OpcuaStatusCode_BadRefreshInProgress                                            OpcuaStatusCode = 0x80970000
	OpcuaStatusCode_BadConditionAlreadyDisabled                                     OpcuaStatusCode = 0x80980000
	OpcuaStatusCode_BadConditionAlreadyEnabled                                      OpcuaStatusCode = 0x80CC0000
	OpcuaStatusCode_BadConditionDisabled                                            OpcuaStatusCode = 0x80990000
	OpcuaStatusCode_BadEventIdUnknown                                               OpcuaStatusCode = 0x809A0000
	OpcuaStatusCode_BadEventNotAcknowledgeable                                      OpcuaStatusCode = 0x80BB0000
	OpcuaStatusCode_BadDialogNotActive                                              OpcuaStatusCode = 0x80CD0000
	OpcuaStatusCode_BadDialogResponseInvalid                                        OpcuaStatusCode = 0x80CE0000
	OpcuaStatusCode_BadConditionBranchAlreadyAcked                                  OpcuaStatusCode = 0x80CF0000
	OpcuaStatusCode_BadConditionBranchAlreadyConfirmed                              OpcuaStatusCode = 0x80D00000
	OpcuaStatusCode_BadConditionAlreadyShelved                                      OpcuaStatusCode = 0x80D10000
	OpcuaStatusCode_BadConditionNotShelved                                          OpcuaStatusCode = 0x80D20000
	OpcuaStatusCode_BadShelvingTimeOutOfRange                                       OpcuaStatusCode = 0x80D30000
	OpcuaStatusCode_BadNoData                                                       OpcuaStatusCode = 0x809B0000
	OpcuaStatusCode_BadBoundNotFound                                                OpcuaStatusCode = 0x80D70000
	OpcuaStatusCode_BadBoundNotSupported                                            OpcuaStatusCode = 0x80D80000
	OpcuaStatusCode_BadDataLost                                                     OpcuaStatusCode = 0x809D0000
	OpcuaStatusCode_BadDataUnavailable                                              OpcuaStatusCode = 0x809E0000
	OpcuaStatusCode_BadEntryExists                                                  OpcuaStatusCode = 0x809F0000
	OpcuaStatusCode_BadNoEntryExists                                                OpcuaStatusCode = 0x80A00000
	OpcuaStatusCode_BadTimestampNotSupported                                        OpcuaStatusCode = 0x80A10000
	OpcuaStatusCode_GoodEntryInserted                                               OpcuaStatusCode = 0x00A20000
	OpcuaStatusCode_GoodEntryReplaced                                               OpcuaStatusCode = 0x00A30000
	OpcuaStatusCode_UncertainDataSubNormal                                          OpcuaStatusCode = 0x40A40000
	OpcuaStatusCode_GoodNoData                                                      OpcuaStatusCode = 0x00A50000
	OpcuaStatusCode_GoodMoreData                                                    OpcuaStatusCode = 0x00A60000
	OpcuaStatusCode_BadAggregateListMismatch                                        OpcuaStatusCode = 0x80D40000
	OpcuaStatusCode_BadAggregateNotSupported                                        OpcuaStatusCode = 0x80D50000
	OpcuaStatusCode_BadAggregateInvalidInputs                                       OpcuaStatusCode = 0x80D60000
	OpcuaStatusCode_BadAggregateConfigurationRejected                               OpcuaStatusCode = 0x80DA0000
	OpcuaStatusCode_GoodDataIgnored                                                 OpcuaStatusCode = 0x00D90000
	OpcuaStatusCode_BadRequestNotAllowed                                            OpcuaStatusCode = 0x80E40000
	OpcuaStatusCode_BadRequestNotComplete                                           OpcuaStatusCode = 0x81130000
	OpcuaStatusCode_BadTransactionPending                                           OpcuaStatusCode = 0x80E80000
	OpcuaStatusCode_BadTicketRequired                                               OpcuaStatusCode = 0x811F0000
	OpcuaStatusCode_BadTicketInvalid                                                OpcuaStatusCode = 0x81200000
	OpcuaStatusCode_BadLocked                                                       OpcuaStatusCode = 0x80E90000
	OpcuaStatusCode_GoodEdited                                                      OpcuaStatusCode = 0x00DC0000
	OpcuaStatusCode_GoodPostActionFailed                                            OpcuaStatusCode = 0x00DD0000
	OpcuaStatusCode_UncertainDominantValueChanged                                   OpcuaStatusCode = 0x40DE0000
	OpcuaStatusCode_GoodDependentValueChanged                                       OpcuaStatusCode = 0x00E00000
	OpcuaStatusCode_BadDominantValueChanged                                         OpcuaStatusCode = 0x80E10000
	OpcuaStatusCode_UncertainDependentValueChanged                                  OpcuaStatusCode = 0x40E20000
	OpcuaStatusCode_BadDependentValueChanged                                        OpcuaStatusCode = 0x80E30000
	OpcuaStatusCode_GoodEdited_DependentValueChanged                                OpcuaStatusCode = 0x01160000
	OpcuaStatusCode_GoodEdited_DominantValueChanged                                 OpcuaStatusCode = 0x01170000
	OpcuaStatusCode_GoodEdited_DominantValueChanged_DependentValueChanged           OpcuaStatusCode = 0x01180000
	OpcuaStatusCode_BadEdited_OutOfRange                                            OpcuaStatusCode = 0x81190000
	OpcuaStatusCode_BadInitialValue_OutOfRange                                      OpcuaStatusCode = 0x811A0000
	OpcuaStatusCode_BadOutOfRange_DominantValueChanged                              OpcuaStatusCode = 0x811B0000
	OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged                       OpcuaStatusCode = 0x811C0000
	OpcuaStatusCode_BadOutOfRange_DominantValueChanged_DependentValueChanged        OpcuaStatusCode = 0x811D0000
	OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged OpcuaStatusCode = 0x811E0000
	OpcuaStatusCode_GoodCommunicationEvent                                          OpcuaStatusCode = 0x00A70000
	OpcuaStatusCode_GoodShutdownEvent                                               OpcuaStatusCode = 0x00A80000
	OpcuaStatusCode_GoodCallAgain                                                   OpcuaStatusCode = 0x00A90000
	OpcuaStatusCode_GoodNonCriticalTimeout                                          OpcuaStatusCode = 0x00AA0000
	OpcuaStatusCode_BadInvalidArgument                                              OpcuaStatusCode = 0x80AB0000
	OpcuaStatusCode_BadConnectionRejected                                           OpcuaStatusCode = 0x80AC0000
	OpcuaStatusCode_BadDisconnect                                                   OpcuaStatusCode = 0x80AD0000
	OpcuaStatusCode_BadConnectionClosed                                             OpcuaStatusCode = 0x80AE0000
	OpcuaStatusCode_BadInvalidState                                                 OpcuaStatusCode = 0x80AF0000
	OpcuaStatusCode_BadEndOfStream                                                  OpcuaStatusCode = 0x80B00000
	OpcuaStatusCode_BadNoDataAvailable                                              OpcuaStatusCode = 0x80B10000
	OpcuaStatusCode_BadWaitingForResponse                                           OpcuaStatusCode = 0x80B20000
	OpcuaStatusCode_BadOperationAbandoned                                           OpcuaStatusCode = 0x80B30000
	OpcuaStatusCode_BadExpectedStreamToBlock                                        OpcuaStatusCode = 0x80B40000
	OpcuaStatusCode_BadWouldBlock                                                   OpcuaStatusCode = 0x80B50000
	OpcuaStatusCode_BadSyntaxError                                                  OpcuaStatusCode = 0x80B60000
	OpcuaStatusCode_BadMaxConnectionsReached                                        OpcuaStatusCode = 0x80B70000
	OpcuaStatusCode_UncertainTransducerInManual                                     OpcuaStatusCode = 0x42080000
	OpcuaStatusCode_UncertainSimulatedValue                                         OpcuaStatusCode = 0x42090000
	OpcuaStatusCode_UncertainSensorCalibration                                      OpcuaStatusCode = 0x420A0000
	OpcuaStatusCode_UncertainConfigurationError                                     OpcuaStatusCode = 0x420F0000
	OpcuaStatusCode_GoodCascadeInitializationAcknowledged                           OpcuaStatusCode = 0x04010000
	OpcuaStatusCode_GoodCascadeInitializationRequest                                OpcuaStatusCode = 0x04020000
	OpcuaStatusCode_GoodCascadeNotInvited                                           OpcuaStatusCode = 0x04030000
	OpcuaStatusCode_GoodCascadeNotSelected                                          OpcuaStatusCode = 0x04040000
	OpcuaStatusCode_GoodFaultStateActive                                            OpcuaStatusCode = 0x04070000
	OpcuaStatusCode_GoodInitiateFaultState                                          OpcuaStatusCode = 0x04080000
	OpcuaStatusCode_GoodCascade                                                     OpcuaStatusCode = 0x04090000
	OpcuaStatusCode_BadDataSetIdInvalid                                             OpcuaStatusCode = 0x80E70000
)

var OpcuaStatusCodeValues []OpcuaStatusCode

func init() {
	_ = errors.New
	OpcuaStatusCodeValues = []OpcuaStatusCode{
		OpcuaStatusCode_Good,
		OpcuaStatusCode_Uncertain,
		OpcuaStatusCode_Bad,
		OpcuaStatusCode_BadUnexpectedError,
		OpcuaStatusCode_BadInternalError,
		OpcuaStatusCode_BadOutOfMemory,
		OpcuaStatusCode_BadResourceUnavailable,
		OpcuaStatusCode_BadCommunicationError,
		OpcuaStatusCode_BadEncodingError,
		OpcuaStatusCode_BadDecodingError,
		OpcuaStatusCode_BadEncodingLimitsExceeded,
		OpcuaStatusCode_BadRequestTooLarge,
		OpcuaStatusCode_BadResponseTooLarge,
		OpcuaStatusCode_BadUnknownResponse,
		OpcuaStatusCode_BadTimeout,
		OpcuaStatusCode_BadServiceUnsupported,
		OpcuaStatusCode_BadShutdown,
		OpcuaStatusCode_BadServerNotConnected,
		OpcuaStatusCode_BadServerHalted,
		OpcuaStatusCode_BadNothingToDo,
		OpcuaStatusCode_BadTooManyOperations,
		OpcuaStatusCode_BadTooManyMonitoredItems,
		OpcuaStatusCode_BadDataTypeIdUnknown,
		OpcuaStatusCode_BadCertificateInvalid,
		OpcuaStatusCode_BadSecurityChecksFailed,
		OpcuaStatusCode_BadCertificatePolicyCheckFailed,
		OpcuaStatusCode_BadCertificateTimeInvalid,
		OpcuaStatusCode_BadCertificateIssuerTimeInvalid,
		OpcuaStatusCode_BadCertificateHostNameInvalid,
		OpcuaStatusCode_BadCertificateUriInvalid,
		OpcuaStatusCode_BadCertificateUseNotAllowed,
		OpcuaStatusCode_BadCertificateIssuerUseNotAllowed,
		OpcuaStatusCode_BadCertificateUntrusted,
		OpcuaStatusCode_BadCertificateRevocationUnknown,
		OpcuaStatusCode_BadCertificateIssuerRevocationUnknown,
		OpcuaStatusCode_BadCertificateRevoked,
		OpcuaStatusCode_BadCertificateIssuerRevoked,
		OpcuaStatusCode_BadCertificateChainIncomplete,
		OpcuaStatusCode_BadUserAccessDenied,
		OpcuaStatusCode_BadIdentityTokenInvalid,
		OpcuaStatusCode_BadIdentityTokenRejected,
		OpcuaStatusCode_BadSecureChannelIdInvalid,
		OpcuaStatusCode_BadInvalidTimestamp,
		OpcuaStatusCode_BadNonceInvalid,
		OpcuaStatusCode_BadSessionIdInvalid,
		OpcuaStatusCode_BadSessionClosed,
		OpcuaStatusCode_BadSessionNotActivated,
		OpcuaStatusCode_BadSubscriptionIdInvalid,
		OpcuaStatusCode_BadRequestHeaderInvalid,
		OpcuaStatusCode_BadTimestampsToReturnInvalid,
		OpcuaStatusCode_BadRequestCancelledByClient,
		OpcuaStatusCode_BadTooManyArguments,
		OpcuaStatusCode_BadLicenseExpired,
		OpcuaStatusCode_BadLicenseLimitsExceeded,
		OpcuaStatusCode_BadLicenseNotAvailable,
		OpcuaStatusCode_GoodSubscriptionTransferred,
		OpcuaStatusCode_GoodCompletesAsynchronously,
		OpcuaStatusCode_GoodOverload,
		OpcuaStatusCode_GoodClamped,
		OpcuaStatusCode_BadNoCommunication,
		OpcuaStatusCode_BadWaitingForInitialData,
		OpcuaStatusCode_BadNodeIdInvalid,
		OpcuaStatusCode_BadNodeIdUnknown,
		OpcuaStatusCode_BadAttributeIdInvalid,
		OpcuaStatusCode_BadIndexRangeInvalid,
		OpcuaStatusCode_BadIndexRangeNoData,
		OpcuaStatusCode_BadDataEncodingInvalid,
		OpcuaStatusCode_BadDataEncodingUnsupported,
		OpcuaStatusCode_BadNotReadable,
		OpcuaStatusCode_BadNotWritable,
		OpcuaStatusCode_BadOutOfRange,
		OpcuaStatusCode_BadNotSupported,
		OpcuaStatusCode_BadNotFound,
		OpcuaStatusCode_BadObjectDeleted,
		OpcuaStatusCode_BadNotImplemented,
		OpcuaStatusCode_BadMonitoringModeInvalid,
		OpcuaStatusCode_BadMonitoredItemIdInvalid,
		OpcuaStatusCode_BadMonitoredItemFilterInvalid,
		OpcuaStatusCode_BadMonitoredItemFilterUnsupported,
		OpcuaStatusCode_BadFilterNotAllowed,
		OpcuaStatusCode_BadStructureMissing,
		OpcuaStatusCode_BadEventFilterInvalid,
		OpcuaStatusCode_BadContentFilterInvalid,
		OpcuaStatusCode_BadFilterOperatorInvalid,
		OpcuaStatusCode_BadFilterOperatorUnsupported,
		OpcuaStatusCode_BadFilterOperandCountMismatch,
		OpcuaStatusCode_BadFilterOperandInvalid,
		OpcuaStatusCode_BadFilterElementInvalid,
		OpcuaStatusCode_BadFilterLiteralInvalid,
		OpcuaStatusCode_BadContinuationPointInvalid,
		OpcuaStatusCode_BadNoContinuationPoints,
		OpcuaStatusCode_BadReferenceTypeIdInvalid,
		OpcuaStatusCode_BadBrowseDirectionInvalid,
		OpcuaStatusCode_BadNodeNotInView,
		OpcuaStatusCode_BadNumericOverflow,
		OpcuaStatusCode_BadServerUriInvalid,
		OpcuaStatusCode_BadServerNameMissing,
		OpcuaStatusCode_BadDiscoveryUrlMissing,
		OpcuaStatusCode_BadSempahoreFileMissing,
		OpcuaStatusCode_BadRequestTypeInvalid,
		OpcuaStatusCode_BadSecurityModeRejected,
		OpcuaStatusCode_BadSecurityPolicyRejected,
		OpcuaStatusCode_BadTooManySessions,
		OpcuaStatusCode_BadUserSignatureInvalid,
		OpcuaStatusCode_BadApplicationSignatureInvalid,
		OpcuaStatusCode_BadNoValidCertificates,
		OpcuaStatusCode_BadIdentityChangeNotSupported,
		OpcuaStatusCode_BadRequestCancelledByRequest,
		OpcuaStatusCode_BadParentNodeIdInvalid,
		OpcuaStatusCode_BadReferenceNotAllowed,
		OpcuaStatusCode_BadNodeIdRejected,
		OpcuaStatusCode_BadNodeIdExists,
		OpcuaStatusCode_BadNodeClassInvalid,
		OpcuaStatusCode_BadBrowseNameInvalid,
		OpcuaStatusCode_BadBrowseNameDuplicated,
		OpcuaStatusCode_BadNodeAttributesInvalid,
		OpcuaStatusCode_BadTypeDefinitionInvalid,
		OpcuaStatusCode_BadSourceNodeIdInvalid,
		OpcuaStatusCode_BadTargetNodeIdInvalid,
		OpcuaStatusCode_BadDuplicateReferenceNotAllowed,
		OpcuaStatusCode_BadInvalidSelfReference,
		OpcuaStatusCode_BadReferenceLocalOnly,
		OpcuaStatusCode_BadNoDeleteRights,
		OpcuaStatusCode_UncertainReferenceNotDeleted,
		OpcuaStatusCode_BadServerIndexInvalid,
		OpcuaStatusCode_BadViewIdUnknown,
		OpcuaStatusCode_BadViewTimestampInvalid,
		OpcuaStatusCode_BadViewParameterMismatch,
		OpcuaStatusCode_BadViewVersionInvalid,
		OpcuaStatusCode_UncertainNotAllNodesAvailable,
		OpcuaStatusCode_GoodResultsMayBeIncomplete,
		OpcuaStatusCode_BadNotTypeDefinition,
		OpcuaStatusCode_UncertainReferenceOutOfServer,
		OpcuaStatusCode_BadTooManyMatches,
		OpcuaStatusCode_BadQueryTooComplex,
		OpcuaStatusCode_BadNoMatch,
		OpcuaStatusCode_BadMaxAgeInvalid,
		OpcuaStatusCode_BadSecurityModeInsufficient,
		OpcuaStatusCode_BadHistoryOperationInvalid,
		OpcuaStatusCode_BadHistoryOperationUnsupported,
		OpcuaStatusCode_BadInvalidTimestampArgument,
		OpcuaStatusCode_BadWriteNotSupported,
		OpcuaStatusCode_BadTypeMismatch,
		OpcuaStatusCode_BadMethodInvalid,
		OpcuaStatusCode_BadArgumentsMissing,
		OpcuaStatusCode_BadNotExecutable,
		OpcuaStatusCode_BadTooManySubscriptions,
		OpcuaStatusCode_BadTooManyPublishRequests,
		OpcuaStatusCode_BadNoSubscription,
		OpcuaStatusCode_BadSequenceNumberUnknown,
		OpcuaStatusCode_GoodRetransmissionQueueNotSupported,
		OpcuaStatusCode_BadMessageNotAvailable,
		OpcuaStatusCode_BadInsufficientClientProfile,
		OpcuaStatusCode_BadStateNotActive,
		OpcuaStatusCode_BadAlreadyExists,
		OpcuaStatusCode_BadTcpServerTooBusy,
		OpcuaStatusCode_BadTcpMessageTypeInvalid,
		OpcuaStatusCode_BadTcpSecureChannelUnknown,
		OpcuaStatusCode_BadTcpMessageTooLarge,
		OpcuaStatusCode_BadTcpNotEnoughResources,
		OpcuaStatusCode_BadTcpInternalError,
		OpcuaStatusCode_BadTcpEndpointUrlInvalid,
		OpcuaStatusCode_BadRequestInterrupted,
		OpcuaStatusCode_BadRequestTimeout,
		OpcuaStatusCode_BadSecureChannelClosed,
		OpcuaStatusCode_BadSecureChannelTokenUnknown,
		OpcuaStatusCode_BadSequenceNumberInvalid,
		OpcuaStatusCode_BadProtocolVersionUnsupported,
		OpcuaStatusCode_BadConfigurationError,
		OpcuaStatusCode_BadNotConnected,
		OpcuaStatusCode_BadDeviceFailure,
		OpcuaStatusCode_BadSensorFailure,
		OpcuaStatusCode_BadOutOfService,
		OpcuaStatusCode_BadDeadbandFilterInvalid,
		OpcuaStatusCode_UncertainNoCommunicationLastUsableValue,
		OpcuaStatusCode_UncertainLastUsableValue,
		OpcuaStatusCode_UncertainSubstituteValue,
		OpcuaStatusCode_UncertainInitialValue,
		OpcuaStatusCode_UncertainSensorNotAccurate,
		OpcuaStatusCode_UncertainEngineeringUnitsExceeded,
		OpcuaStatusCode_UncertainSubNormal,
		OpcuaStatusCode_GoodLocalOverride,
		OpcuaStatusCode_BadRefreshInProgress,
		OpcuaStatusCode_BadConditionAlreadyDisabled,
		OpcuaStatusCode_BadConditionAlreadyEnabled,
		OpcuaStatusCode_BadConditionDisabled,
		OpcuaStatusCode_BadEventIdUnknown,
		OpcuaStatusCode_BadEventNotAcknowledgeable,
		OpcuaStatusCode_BadDialogNotActive,
		OpcuaStatusCode_BadDialogResponseInvalid,
		OpcuaStatusCode_BadConditionBranchAlreadyAcked,
		OpcuaStatusCode_BadConditionBranchAlreadyConfirmed,
		OpcuaStatusCode_BadConditionAlreadyShelved,
		OpcuaStatusCode_BadConditionNotShelved,
		OpcuaStatusCode_BadShelvingTimeOutOfRange,
		OpcuaStatusCode_BadNoData,
		OpcuaStatusCode_BadBoundNotFound,
		OpcuaStatusCode_BadBoundNotSupported,
		OpcuaStatusCode_BadDataLost,
		OpcuaStatusCode_BadDataUnavailable,
		OpcuaStatusCode_BadEntryExists,
		OpcuaStatusCode_BadNoEntryExists,
		OpcuaStatusCode_BadTimestampNotSupported,
		OpcuaStatusCode_GoodEntryInserted,
		OpcuaStatusCode_GoodEntryReplaced,
		OpcuaStatusCode_UncertainDataSubNormal,
		OpcuaStatusCode_GoodNoData,
		OpcuaStatusCode_GoodMoreData,
		OpcuaStatusCode_BadAggregateListMismatch,
		OpcuaStatusCode_BadAggregateNotSupported,
		OpcuaStatusCode_BadAggregateInvalidInputs,
		OpcuaStatusCode_BadAggregateConfigurationRejected,
		OpcuaStatusCode_GoodDataIgnored,
		OpcuaStatusCode_BadRequestNotAllowed,
		OpcuaStatusCode_BadRequestNotComplete,
		OpcuaStatusCode_BadTransactionPending,
		OpcuaStatusCode_BadTicketRequired,
		OpcuaStatusCode_BadTicketInvalid,
		OpcuaStatusCode_BadLocked,
		OpcuaStatusCode_GoodEdited,
		OpcuaStatusCode_GoodPostActionFailed,
		OpcuaStatusCode_UncertainDominantValueChanged,
		OpcuaStatusCode_GoodDependentValueChanged,
		OpcuaStatusCode_BadDominantValueChanged,
		OpcuaStatusCode_UncertainDependentValueChanged,
		OpcuaStatusCode_BadDependentValueChanged,
		OpcuaStatusCode_GoodEdited_DependentValueChanged,
		OpcuaStatusCode_GoodEdited_DominantValueChanged,
		OpcuaStatusCode_GoodEdited_DominantValueChanged_DependentValueChanged,
		OpcuaStatusCode_BadEdited_OutOfRange,
		OpcuaStatusCode_BadInitialValue_OutOfRange,
		OpcuaStatusCode_BadOutOfRange_DominantValueChanged,
		OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged,
		OpcuaStatusCode_BadOutOfRange_DominantValueChanged_DependentValueChanged,
		OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged,
		OpcuaStatusCode_GoodCommunicationEvent,
		OpcuaStatusCode_GoodShutdownEvent,
		OpcuaStatusCode_GoodCallAgain,
		OpcuaStatusCode_GoodNonCriticalTimeout,
		OpcuaStatusCode_BadInvalidArgument,
		OpcuaStatusCode_BadConnectionRejected,
		OpcuaStatusCode_BadDisconnect,
		OpcuaStatusCode_BadConnectionClosed,
		OpcuaStatusCode_BadInvalidState,
		OpcuaStatusCode_BadEndOfStream,
		OpcuaStatusCode_BadNoDataAvailable,
		OpcuaStatusCode_BadWaitingForResponse,
		OpcuaStatusCode_BadOperationAbandoned,
		OpcuaStatusCode_BadExpectedStreamToBlock,
		OpcuaStatusCode_BadWouldBlock,
		OpcuaStatusCode_BadSyntaxError,
		OpcuaStatusCode_BadMaxConnectionsReached,
		OpcuaStatusCode_UncertainTransducerInManual,
		OpcuaStatusCode_UncertainSimulatedValue,
		OpcuaStatusCode_UncertainSensorCalibration,
		OpcuaStatusCode_UncertainConfigurationError,
		OpcuaStatusCode_GoodCascadeInitializationAcknowledged,
		OpcuaStatusCode_GoodCascadeInitializationRequest,
		OpcuaStatusCode_GoodCascadeNotInvited,
		OpcuaStatusCode_GoodCascadeNotSelected,
		OpcuaStatusCode_GoodFaultStateActive,
		OpcuaStatusCode_GoodInitiateFaultState,
		OpcuaStatusCode_GoodCascade,
		OpcuaStatusCode_BadDataSetIdInvalid,
	}
}

func OpcuaStatusCodeByValue(value uint32) (enum OpcuaStatusCode, ok bool) {
	switch value {
	case 0x00000000:
		return OpcuaStatusCode_Good, true
	case 0x002D0000:
		return OpcuaStatusCode_GoodSubscriptionTransferred, true
	case 0x002E0000:
		return OpcuaStatusCode_GoodCompletesAsynchronously, true
	case 0x002F0000:
		return OpcuaStatusCode_GoodOverload, true
	case 0x00300000:
		return OpcuaStatusCode_GoodClamped, true
	case 0x00960000:
		return OpcuaStatusCode_GoodLocalOverride, true
	case 0x00A20000:
		return OpcuaStatusCode_GoodEntryInserted, true
	case 0x00A30000:
		return OpcuaStatusCode_GoodEntryReplaced, true
	case 0x00A50000:
		return OpcuaStatusCode_GoodNoData, true
	case 0x00A60000:
		return OpcuaStatusCode_GoodMoreData, true
	case 0x00A70000:
		return OpcuaStatusCode_GoodCommunicationEvent, true
	case 0x00A80000:
		return OpcuaStatusCode_GoodShutdownEvent, true
	case 0x00A90000:
		return OpcuaStatusCode_GoodCallAgain, true
	case 0x00AA0000:
		return OpcuaStatusCode_GoodNonCriticalTimeout, true
	case 0x00BA0000:
		return OpcuaStatusCode_GoodResultsMayBeIncomplete, true
	case 0x00D90000:
		return OpcuaStatusCode_GoodDataIgnored, true
	case 0x00DC0000:
		return OpcuaStatusCode_GoodEdited, true
	case 0x00DD0000:
		return OpcuaStatusCode_GoodPostActionFailed, true
	case 0x00DF0000:
		return OpcuaStatusCode_GoodRetransmissionQueueNotSupported, true
	case 0x00E00000:
		return OpcuaStatusCode_GoodDependentValueChanged, true
	case 0x01160000:
		return OpcuaStatusCode_GoodEdited_DependentValueChanged, true
	case 0x01170000:
		return OpcuaStatusCode_GoodEdited_DominantValueChanged, true
	case 0x01180000:
		return OpcuaStatusCode_GoodEdited_DominantValueChanged_DependentValueChanged, true
	case 0x04010000:
		return OpcuaStatusCode_GoodCascadeInitializationAcknowledged, true
	case 0x04020000:
		return OpcuaStatusCode_GoodCascadeInitializationRequest, true
	case 0x04030000:
		return OpcuaStatusCode_GoodCascadeNotInvited, true
	case 0x04040000:
		return OpcuaStatusCode_GoodCascadeNotSelected, true
	case 0x04070000:
		return OpcuaStatusCode_GoodFaultStateActive, true
	case 0x04080000:
		return OpcuaStatusCode_GoodInitiateFaultState, true
	case 0x04090000:
		return OpcuaStatusCode_GoodCascade, true
	case 0x40000000:
		return OpcuaStatusCode_Uncertain, true
	case 0x406C0000:
		return OpcuaStatusCode_UncertainReferenceOutOfServer, true
	case 0x408F0000:
		return OpcuaStatusCode_UncertainNoCommunicationLastUsableValue, true
	case 0x40900000:
		return OpcuaStatusCode_UncertainLastUsableValue, true
	case 0x40910000:
		return OpcuaStatusCode_UncertainSubstituteValue, true
	case 0x40920000:
		return OpcuaStatusCode_UncertainInitialValue, true
	case 0x40930000:
		return OpcuaStatusCode_UncertainSensorNotAccurate, true
	case 0x40940000:
		return OpcuaStatusCode_UncertainEngineeringUnitsExceeded, true
	case 0x40950000:
		return OpcuaStatusCode_UncertainSubNormal, true
	case 0x40A40000:
		return OpcuaStatusCode_UncertainDataSubNormal, true
	case 0x40BC0000:
		return OpcuaStatusCode_UncertainReferenceNotDeleted, true
	case 0x40C00000:
		return OpcuaStatusCode_UncertainNotAllNodesAvailable, true
	case 0x40DE0000:
		return OpcuaStatusCode_UncertainDominantValueChanged, true
	case 0x40E20000:
		return OpcuaStatusCode_UncertainDependentValueChanged, true
	case 0x42080000:
		return OpcuaStatusCode_UncertainTransducerInManual, true
	case 0x42090000:
		return OpcuaStatusCode_UncertainSimulatedValue, true
	case 0x420A0000:
		return OpcuaStatusCode_UncertainSensorCalibration, true
	case 0x420F0000:
		return OpcuaStatusCode_UncertainConfigurationError, true
	case 0x80000000:
		return OpcuaStatusCode_Bad, true
	case 0x80010000:
		return OpcuaStatusCode_BadUnexpectedError, true
	case 0x80020000:
		return OpcuaStatusCode_BadInternalError, true
	case 0x80030000:
		return OpcuaStatusCode_BadOutOfMemory, true
	case 0x80040000:
		return OpcuaStatusCode_BadResourceUnavailable, true
	case 0x80050000:
		return OpcuaStatusCode_BadCommunicationError, true
	case 0x80060000:
		return OpcuaStatusCode_BadEncodingError, true
	case 0x80070000:
		return OpcuaStatusCode_BadDecodingError, true
	case 0x80080000:
		return OpcuaStatusCode_BadEncodingLimitsExceeded, true
	case 0x80090000:
		return OpcuaStatusCode_BadUnknownResponse, true
	case 0x800A0000:
		return OpcuaStatusCode_BadTimeout, true
	case 0x800B0000:
		return OpcuaStatusCode_BadServiceUnsupported, true
	case 0x800C0000:
		return OpcuaStatusCode_BadShutdown, true
	case 0x800D0000:
		return OpcuaStatusCode_BadServerNotConnected, true
	case 0x800E0000:
		return OpcuaStatusCode_BadServerHalted, true
	case 0x800F0000:
		return OpcuaStatusCode_BadNothingToDo, true
	case 0x80100000:
		return OpcuaStatusCode_BadTooManyOperations, true
	case 0x80110000:
		return OpcuaStatusCode_BadDataTypeIdUnknown, true
	case 0x80120000:
		return OpcuaStatusCode_BadCertificateInvalid, true
	case 0x80130000:
		return OpcuaStatusCode_BadSecurityChecksFailed, true
	case 0x80140000:
		return OpcuaStatusCode_BadCertificateTimeInvalid, true
	case 0x80150000:
		return OpcuaStatusCode_BadCertificateIssuerTimeInvalid, true
	case 0x80160000:
		return OpcuaStatusCode_BadCertificateHostNameInvalid, true
	case 0x80170000:
		return OpcuaStatusCode_BadCertificateUriInvalid, true
	case 0x80180000:
		return OpcuaStatusCode_BadCertificateUseNotAllowed, true
	case 0x80190000:
		return OpcuaStatusCode_BadCertificateIssuerUseNotAllowed, true
	case 0x801A0000:
		return OpcuaStatusCode_BadCertificateUntrusted, true
	case 0x801B0000:
		return OpcuaStatusCode_BadCertificateRevocationUnknown, true
	case 0x801C0000:
		return OpcuaStatusCode_BadCertificateIssuerRevocationUnknown, true
	case 0x801D0000:
		return OpcuaStatusCode_BadCertificateRevoked, true
	case 0x801E0000:
		return OpcuaStatusCode_BadCertificateIssuerRevoked, true
	case 0x801F0000:
		return OpcuaStatusCode_BadUserAccessDenied, true
	case 0x80200000:
		return OpcuaStatusCode_BadIdentityTokenInvalid, true
	case 0x80210000:
		return OpcuaStatusCode_BadIdentityTokenRejected, true
	case 0x80220000:
		return OpcuaStatusCode_BadSecureChannelIdInvalid, true
	case 0x80230000:
		return OpcuaStatusCode_BadInvalidTimestamp, true
	case 0x80240000:
		return OpcuaStatusCode_BadNonceInvalid, true
	case 0x80250000:
		return OpcuaStatusCode_BadSessionIdInvalid, true
	case 0x80260000:
		return OpcuaStatusCode_BadSessionClosed, true
	case 0x80270000:
		return OpcuaStatusCode_BadSessionNotActivated, true
	case 0x80280000:
		return OpcuaStatusCode_BadSubscriptionIdInvalid, true
	case 0x802A0000:
		return OpcuaStatusCode_BadRequestHeaderInvalid, true
	case 0x802B0000:
		return OpcuaStatusCode_BadTimestampsToReturnInvalid, true
	case 0x802C0000:
		return OpcuaStatusCode_BadRequestCancelledByClient, true
	case 0x80310000:
		return OpcuaStatusCode_BadNoCommunication, true
	case 0x80320000:
		return OpcuaStatusCode_BadWaitingForInitialData, true
	case 0x80330000:
		return OpcuaStatusCode_BadNodeIdInvalid, true
	case 0x80340000:
		return OpcuaStatusCode_BadNodeIdUnknown, true
	case 0x80350000:
		return OpcuaStatusCode_BadAttributeIdInvalid, true
	case 0x80360000:
		return OpcuaStatusCode_BadIndexRangeInvalid, true
	case 0x80370000:
		return OpcuaStatusCode_BadIndexRangeNoData, true
	case 0x80380000:
		return OpcuaStatusCode_BadDataEncodingInvalid, true
	case 0x80390000:
		return OpcuaStatusCode_BadDataEncodingUnsupported, true
	case 0x803A0000:
		return OpcuaStatusCode_BadNotReadable, true
	case 0x803B0000:
		return OpcuaStatusCode_BadNotWritable, true
	case 0x803C0000:
		return OpcuaStatusCode_BadOutOfRange, true
	case 0x803D0000:
		return OpcuaStatusCode_BadNotSupported, true
	case 0x803E0000:
		return OpcuaStatusCode_BadNotFound, true
	case 0x803F0000:
		return OpcuaStatusCode_BadObjectDeleted, true
	case 0x80400000:
		return OpcuaStatusCode_BadNotImplemented, true
	case 0x80410000:
		return OpcuaStatusCode_BadMonitoringModeInvalid, true
	case 0x80420000:
		return OpcuaStatusCode_BadMonitoredItemIdInvalid, true
	case 0x80430000:
		return OpcuaStatusCode_BadMonitoredItemFilterInvalid, true
	case 0x80440000:
		return OpcuaStatusCode_BadMonitoredItemFilterUnsupported, true
	case 0x80450000:
		return OpcuaStatusCode_BadFilterNotAllowed, true
	case 0x80460000:
		return OpcuaStatusCode_BadStructureMissing, true
	case 0x80470000:
		return OpcuaStatusCode_BadEventFilterInvalid, true
	case 0x80480000:
		return OpcuaStatusCode_BadContentFilterInvalid, true
	case 0x80490000:
		return OpcuaStatusCode_BadFilterOperandInvalid, true
	case 0x804A0000:
		return OpcuaStatusCode_BadContinuationPointInvalid, true
	case 0x804B0000:
		return OpcuaStatusCode_BadNoContinuationPoints, true
	case 0x804C0000:
		return OpcuaStatusCode_BadReferenceTypeIdInvalid, true
	case 0x804D0000:
		return OpcuaStatusCode_BadBrowseDirectionInvalid, true
	case 0x804E0000:
		return OpcuaStatusCode_BadNodeNotInView, true
	case 0x804F0000:
		return OpcuaStatusCode_BadServerUriInvalid, true
	case 0x80500000:
		return OpcuaStatusCode_BadServerNameMissing, true
	case 0x80510000:
		return OpcuaStatusCode_BadDiscoveryUrlMissing, true
	case 0x80520000:
		return OpcuaStatusCode_BadSempahoreFileMissing, true
	case 0x80530000:
		return OpcuaStatusCode_BadRequestTypeInvalid, true
	case 0x80540000:
		return OpcuaStatusCode_BadSecurityModeRejected, true
	case 0x80550000:
		return OpcuaStatusCode_BadSecurityPolicyRejected, true
	case 0x80560000:
		return OpcuaStatusCode_BadTooManySessions, true
	case 0x80570000:
		return OpcuaStatusCode_BadUserSignatureInvalid, true
	case 0x80580000:
		return OpcuaStatusCode_BadApplicationSignatureInvalid, true
	case 0x80590000:
		return OpcuaStatusCode_BadNoValidCertificates, true
	case 0x805A0000:
		return OpcuaStatusCode_BadRequestCancelledByRequest, true
	case 0x805B0000:
		return OpcuaStatusCode_BadParentNodeIdInvalid, true
	case 0x805C0000:
		return OpcuaStatusCode_BadReferenceNotAllowed, true
	case 0x805D0000:
		return OpcuaStatusCode_BadNodeIdRejected, true
	case 0x805E0000:
		return OpcuaStatusCode_BadNodeIdExists, true
	case 0x805F0000:
		return OpcuaStatusCode_BadNodeClassInvalid, true
	case 0x80600000:
		return OpcuaStatusCode_BadBrowseNameInvalid, true
	case 0x80610000:
		return OpcuaStatusCode_BadBrowseNameDuplicated, true
	case 0x80620000:
		return OpcuaStatusCode_BadNodeAttributesInvalid, true
	case 0x80630000:
		return OpcuaStatusCode_BadTypeDefinitionInvalid, true
	case 0x80640000:
		return OpcuaStatusCode_BadSourceNodeIdInvalid, true
	case 0x80650000:
		return OpcuaStatusCode_BadTargetNodeIdInvalid, true
	case 0x80660000:
		return OpcuaStatusCode_BadDuplicateReferenceNotAllowed, true
	case 0x80670000:
		return OpcuaStatusCode_BadInvalidSelfReference, true
	case 0x80680000:
		return OpcuaStatusCode_BadReferenceLocalOnly, true
	case 0x80690000:
		return OpcuaStatusCode_BadNoDeleteRights, true
	case 0x806A0000:
		return OpcuaStatusCode_BadServerIndexInvalid, true
	case 0x806B0000:
		return OpcuaStatusCode_BadViewIdUnknown, true
	case 0x806D0000:
		return OpcuaStatusCode_BadTooManyMatches, true
	case 0x806E0000:
		return OpcuaStatusCode_BadQueryTooComplex, true
	case 0x806F0000:
		return OpcuaStatusCode_BadNoMatch, true
	case 0x80700000:
		return OpcuaStatusCode_BadMaxAgeInvalid, true
	case 0x80710000:
		return OpcuaStatusCode_BadHistoryOperationInvalid, true
	case 0x80720000:
		return OpcuaStatusCode_BadHistoryOperationUnsupported, true
	case 0x80730000:
		return OpcuaStatusCode_BadWriteNotSupported, true
	case 0x80740000:
		return OpcuaStatusCode_BadTypeMismatch, true
	case 0x80750000:
		return OpcuaStatusCode_BadMethodInvalid, true
	case 0x80760000:
		return OpcuaStatusCode_BadArgumentsMissing, true
	case 0x80770000:
		return OpcuaStatusCode_BadTooManySubscriptions, true
	case 0x80780000:
		return OpcuaStatusCode_BadTooManyPublishRequests, true
	case 0x80790000:
		return OpcuaStatusCode_BadNoSubscription, true
	case 0x807A0000:
		return OpcuaStatusCode_BadSequenceNumberUnknown, true
	case 0x807B0000:
		return OpcuaStatusCode_BadMessageNotAvailable, true
	case 0x807C0000:
		return OpcuaStatusCode_BadInsufficientClientProfile, true
	case 0x807D0000:
		return OpcuaStatusCode_BadTcpServerTooBusy, true
	case 0x807E0000:
		return OpcuaStatusCode_BadTcpMessageTypeInvalid, true
	case 0x807F0000:
		return OpcuaStatusCode_BadTcpSecureChannelUnknown, true
	case 0x80800000:
		return OpcuaStatusCode_BadTcpMessageTooLarge, true
	case 0x80810000:
		return OpcuaStatusCode_BadTcpNotEnoughResources, true
	case 0x80820000:
		return OpcuaStatusCode_BadTcpInternalError, true
	case 0x80830000:
		return OpcuaStatusCode_BadTcpEndpointUrlInvalid, true
	case 0x80840000:
		return OpcuaStatusCode_BadRequestInterrupted, true
	case 0x80850000:
		return OpcuaStatusCode_BadRequestTimeout, true
	case 0x80860000:
		return OpcuaStatusCode_BadSecureChannelClosed, true
	case 0x80870000:
		return OpcuaStatusCode_BadSecureChannelTokenUnknown, true
	case 0x80880000:
		return OpcuaStatusCode_BadSequenceNumberInvalid, true
	case 0x80890000:
		return OpcuaStatusCode_BadConfigurationError, true
	case 0x808A0000:
		return OpcuaStatusCode_BadNotConnected, true
	case 0x808B0000:
		return OpcuaStatusCode_BadDeviceFailure, true
	case 0x808C0000:
		return OpcuaStatusCode_BadSensorFailure, true
	case 0x808D0000:
		return OpcuaStatusCode_BadOutOfService, true
	case 0x808E0000:
		return OpcuaStatusCode_BadDeadbandFilterInvalid, true
	case 0x80970000:
		return OpcuaStatusCode_BadRefreshInProgress, true
	case 0x80980000:
		return OpcuaStatusCode_BadConditionAlreadyDisabled, true
	case 0x80990000:
		return OpcuaStatusCode_BadConditionDisabled, true
	case 0x809A0000:
		return OpcuaStatusCode_BadEventIdUnknown, true
	case 0x809B0000:
		return OpcuaStatusCode_BadNoData, true
	case 0x809D0000:
		return OpcuaStatusCode_BadDataLost, true
	case 0x809E0000:
		return OpcuaStatusCode_BadDataUnavailable, true
	case 0x809F0000:
		return OpcuaStatusCode_BadEntryExists, true
	case 0x80A00000:
		return OpcuaStatusCode_BadNoEntryExists, true
	case 0x80A10000:
		return OpcuaStatusCode_BadTimestampNotSupported, true
	case 0x80AB0000:
		return OpcuaStatusCode_BadInvalidArgument, true
	case 0x80AC0000:
		return OpcuaStatusCode_BadConnectionRejected, true
	case 0x80AD0000:
		return OpcuaStatusCode_BadDisconnect, true
	case 0x80AE0000:
		return OpcuaStatusCode_BadConnectionClosed, true
	case 0x80AF0000:
		return OpcuaStatusCode_BadInvalidState, true
	case 0x80B00000:
		return OpcuaStatusCode_BadEndOfStream, true
	case 0x80B10000:
		return OpcuaStatusCode_BadNoDataAvailable, true
	case 0x80B20000:
		return OpcuaStatusCode_BadWaitingForResponse, true
	case 0x80B30000:
		return OpcuaStatusCode_BadOperationAbandoned, true
	case 0x80B40000:
		return OpcuaStatusCode_BadExpectedStreamToBlock, true
	case 0x80B50000:
		return OpcuaStatusCode_BadWouldBlock, true
	case 0x80B60000:
		return OpcuaStatusCode_BadSyntaxError, true
	case 0x80B70000:
		return OpcuaStatusCode_BadMaxConnectionsReached, true
	case 0x80B80000:
		return OpcuaStatusCode_BadRequestTooLarge, true
	case 0x80B90000:
		return OpcuaStatusCode_BadResponseTooLarge, true
	case 0x80BB0000:
		return OpcuaStatusCode_BadEventNotAcknowledgeable, true
	case 0x80BD0000:
		return OpcuaStatusCode_BadInvalidTimestampArgument, true
	case 0x80BE0000:
		return OpcuaStatusCode_BadProtocolVersionUnsupported, true
	case 0x80BF0000:
		return OpcuaStatusCode_BadStateNotActive, true
	case 0x80C10000:
		return OpcuaStatusCode_BadFilterOperatorInvalid, true
	case 0x80C20000:
		return OpcuaStatusCode_BadFilterOperatorUnsupported, true
	case 0x80C30000:
		return OpcuaStatusCode_BadFilterOperandCountMismatch, true
	case 0x80C40000:
		return OpcuaStatusCode_BadFilterElementInvalid, true
	case 0x80C50000:
		return OpcuaStatusCode_BadFilterLiteralInvalid, true
	case 0x80C60000:
		return OpcuaStatusCode_BadIdentityChangeNotSupported, true
	case 0x80C80000:
		return OpcuaStatusCode_BadNotTypeDefinition, true
	case 0x80C90000:
		return OpcuaStatusCode_BadViewTimestampInvalid, true
	case 0x80CA0000:
		return OpcuaStatusCode_BadViewParameterMismatch, true
	case 0x80CB0000:
		return OpcuaStatusCode_BadViewVersionInvalid, true
	case 0x80CC0000:
		return OpcuaStatusCode_BadConditionAlreadyEnabled, true
	case 0x80CD0000:
		return OpcuaStatusCode_BadDialogNotActive, true
	case 0x80CE0000:
		return OpcuaStatusCode_BadDialogResponseInvalid, true
	case 0x80CF0000:
		return OpcuaStatusCode_BadConditionBranchAlreadyAcked, true
	case 0x80D00000:
		return OpcuaStatusCode_BadConditionBranchAlreadyConfirmed, true
	case 0x80D10000:
		return OpcuaStatusCode_BadConditionAlreadyShelved, true
	case 0x80D20000:
		return OpcuaStatusCode_BadConditionNotShelved, true
	case 0x80D30000:
		return OpcuaStatusCode_BadShelvingTimeOutOfRange, true
	case 0x80D40000:
		return OpcuaStatusCode_BadAggregateListMismatch, true
	case 0x80D50000:
		return OpcuaStatusCode_BadAggregateNotSupported, true
	case 0x80D60000:
		return OpcuaStatusCode_BadAggregateInvalidInputs, true
	case 0x80D70000:
		return OpcuaStatusCode_BadBoundNotFound, true
	case 0x80D80000:
		return OpcuaStatusCode_BadBoundNotSupported, true
	case 0x80DA0000:
		return OpcuaStatusCode_BadAggregateConfigurationRejected, true
	case 0x80DB0000:
		return OpcuaStatusCode_BadTooManyMonitoredItems, true
	case 0x80E10000:
		return OpcuaStatusCode_BadDominantValueChanged, true
	case 0x80E30000:
		return OpcuaStatusCode_BadDependentValueChanged, true
	case 0x80E40000:
		return OpcuaStatusCode_BadRequestNotAllowed, true
	case 0x80E50000:
		return OpcuaStatusCode_BadTooManyArguments, true
	case 0x80E60000:
		return OpcuaStatusCode_BadSecurityModeInsufficient, true
	case 0x80E70000:
		return OpcuaStatusCode_BadDataSetIdInvalid, true
	case 0x80E80000:
		return OpcuaStatusCode_BadTransactionPending, true
	case 0x80E90000:
		return OpcuaStatusCode_BadLocked, true
	case 0x810D0000:
		return OpcuaStatusCode_BadCertificateChainIncomplete, true
	case 0x810E0000:
		return OpcuaStatusCode_BadLicenseExpired, true
	case 0x810F0000:
		return OpcuaStatusCode_BadLicenseLimitsExceeded, true
	case 0x81100000:
		return OpcuaStatusCode_BadLicenseNotAvailable, true
	case 0x81110000:
		return OpcuaStatusCode_BadNotExecutable, true
	case 0x81120000:
		return OpcuaStatusCode_BadNumericOverflow, true
	case 0x81130000:
		return OpcuaStatusCode_BadRequestNotComplete, true
	case 0x81140000:
		return OpcuaStatusCode_BadCertificatePolicyCheckFailed, true
	case 0x81150000:
		return OpcuaStatusCode_BadAlreadyExists, true
	case 0x81190000:
		return OpcuaStatusCode_BadEdited_OutOfRange, true
	case 0x811A0000:
		return OpcuaStatusCode_BadInitialValue_OutOfRange, true
	case 0x811B0000:
		return OpcuaStatusCode_BadOutOfRange_DominantValueChanged, true
	case 0x811C0000:
		return OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged, true
	case 0x811D0000:
		return OpcuaStatusCode_BadOutOfRange_DominantValueChanged_DependentValueChanged, true
	case 0x811E0000:
		return OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged, true
	case 0x811F0000:
		return OpcuaStatusCode_BadTicketRequired, true
	case 0x81200000:
		return OpcuaStatusCode_BadTicketInvalid, true
	}
	return 0, false
}

func OpcuaStatusCodeByName(value string) (enum OpcuaStatusCode, ok bool) {
	switch value {
	case "Good":
		return OpcuaStatusCode_Good, true
	case "GoodSubscriptionTransferred":
		return OpcuaStatusCode_GoodSubscriptionTransferred, true
	case "GoodCompletesAsynchronously":
		return OpcuaStatusCode_GoodCompletesAsynchronously, true
	case "GoodOverload":
		return OpcuaStatusCode_GoodOverload, true
	case "GoodClamped":
		return OpcuaStatusCode_GoodClamped, true
	case "GoodLocalOverride":
		return OpcuaStatusCode_GoodLocalOverride, true
	case "GoodEntryInserted":
		return OpcuaStatusCode_GoodEntryInserted, true
	case "GoodEntryReplaced":
		return OpcuaStatusCode_GoodEntryReplaced, true
	case "GoodNoData":
		return OpcuaStatusCode_GoodNoData, true
	case "GoodMoreData":
		return OpcuaStatusCode_GoodMoreData, true
	case "GoodCommunicationEvent":
		return OpcuaStatusCode_GoodCommunicationEvent, true
	case "GoodShutdownEvent":
		return OpcuaStatusCode_GoodShutdownEvent, true
	case "GoodCallAgain":
		return OpcuaStatusCode_GoodCallAgain, true
	case "GoodNonCriticalTimeout":
		return OpcuaStatusCode_GoodNonCriticalTimeout, true
	case "GoodResultsMayBeIncomplete":
		return OpcuaStatusCode_GoodResultsMayBeIncomplete, true
	case "GoodDataIgnored":
		return OpcuaStatusCode_GoodDataIgnored, true
	case "GoodEdited":
		return OpcuaStatusCode_GoodEdited, true
	case "GoodPostActionFailed":
		return OpcuaStatusCode_GoodPostActionFailed, true
	case "GoodRetransmissionQueueNotSupported":
		return OpcuaStatusCode_GoodRetransmissionQueueNotSupported, true
	case "GoodDependentValueChanged":
		return OpcuaStatusCode_GoodDependentValueChanged, true
	case "GoodEdited_DependentValueChanged":
		return OpcuaStatusCode_GoodEdited_DependentValueChanged, true
	case "GoodEdited_DominantValueChanged":
		return OpcuaStatusCode_GoodEdited_DominantValueChanged, true
	case "GoodEdited_DominantValueChanged_DependentValueChanged":
		return OpcuaStatusCode_GoodEdited_DominantValueChanged_DependentValueChanged, true
	case "GoodCascadeInitializationAcknowledged":
		return OpcuaStatusCode_GoodCascadeInitializationAcknowledged, true
	case "GoodCascadeInitializationRequest":
		return OpcuaStatusCode_GoodCascadeInitializationRequest, true
	case "GoodCascadeNotInvited":
		return OpcuaStatusCode_GoodCascadeNotInvited, true
	case "GoodCascadeNotSelected":
		return OpcuaStatusCode_GoodCascadeNotSelected, true
	case "GoodFaultStateActive":
		return OpcuaStatusCode_GoodFaultStateActive, true
	case "GoodInitiateFaultState":
		return OpcuaStatusCode_GoodInitiateFaultState, true
	case "GoodCascade":
		return OpcuaStatusCode_GoodCascade, true
	case "Uncertain":
		return OpcuaStatusCode_Uncertain, true
	case "UncertainReferenceOutOfServer":
		return OpcuaStatusCode_UncertainReferenceOutOfServer, true
	case "UncertainNoCommunicationLastUsableValue":
		return OpcuaStatusCode_UncertainNoCommunicationLastUsableValue, true
	case "UncertainLastUsableValue":
		return OpcuaStatusCode_UncertainLastUsableValue, true
	case "UncertainSubstituteValue":
		return OpcuaStatusCode_UncertainSubstituteValue, true
	case "UncertainInitialValue":
		return OpcuaStatusCode_UncertainInitialValue, true
	case "UncertainSensorNotAccurate":
		return OpcuaStatusCode_UncertainSensorNotAccurate, true
	case "UncertainEngineeringUnitsExceeded":
		return OpcuaStatusCode_UncertainEngineeringUnitsExceeded, true
	case "UncertainSubNormal":
		return OpcuaStatusCode_UncertainSubNormal, true
	case "UncertainDataSubNormal":
		return OpcuaStatusCode_UncertainDataSubNormal, true
	case "UncertainReferenceNotDeleted":
		return OpcuaStatusCode_UncertainReferenceNotDeleted, true
	case "UncertainNotAllNodesAvailable":
		return OpcuaStatusCode_UncertainNotAllNodesAvailable, true
	case "UncertainDominantValueChanged":
		return OpcuaStatusCode_UncertainDominantValueChanged, true
	case "UncertainDependentValueChanged":
		return OpcuaStatusCode_UncertainDependentValueChanged, true
	case "UncertainTransducerInManual":
		return OpcuaStatusCode_UncertainTransducerInManual, true
	case "UncertainSimulatedValue":
		return OpcuaStatusCode_UncertainSimulatedValue, true
	case "UncertainSensorCalibration":
		return OpcuaStatusCode_UncertainSensorCalibration, true
	case "UncertainConfigurationError":
		return OpcuaStatusCode_UncertainConfigurationError, true
	case "Bad":
		return OpcuaStatusCode_Bad, true
	case "BadUnexpectedError":
		return OpcuaStatusCode_BadUnexpectedError, true
	case "BadInternalError":
		return OpcuaStatusCode_BadInternalError, true
	case "BadOutOfMemory":
		return OpcuaStatusCode_BadOutOfMemory, true
	case "BadResourceUnavailable":
		return OpcuaStatusCode_BadResourceUnavailable, true
	case "BadCommunicationError":
		return OpcuaStatusCode_BadCommunicationError, true
	case "BadEncodingError":
		return OpcuaStatusCode_BadEncodingError, true
	case "BadDecodingError":
		return OpcuaStatusCode_BadDecodingError, true
	case "BadEncodingLimitsExceeded":
		return OpcuaStatusCode_BadEncodingLimitsExceeded, true
	case "BadUnknownResponse":
		return OpcuaStatusCode_BadUnknownResponse, true
	case "BadTimeout":
		return OpcuaStatusCode_BadTimeout, true
	case "BadServiceUnsupported":
		return OpcuaStatusCode_BadServiceUnsupported, true
	case "BadShutdown":
		return OpcuaStatusCode_BadShutdown, true
	case "BadServerNotConnected":
		return OpcuaStatusCode_BadServerNotConnected, true
	case "BadServerHalted":
		return OpcuaStatusCode_BadServerHalted, true
	case "BadNothingToDo":
		return OpcuaStatusCode_BadNothingToDo, true
	case "BadTooManyOperations":
		return OpcuaStatusCode_BadTooManyOperations, true
	case "BadDataTypeIdUnknown":
		return OpcuaStatusCode_BadDataTypeIdUnknown, true
	case "BadCertificateInvalid":
		return OpcuaStatusCode_BadCertificateInvalid, true
	case "BadSecurityChecksFailed":
		return OpcuaStatusCode_BadSecurityChecksFailed, true
	case "BadCertificateTimeInvalid":
		return OpcuaStatusCode_BadCertificateTimeInvalid, true
	case "BadCertificateIssuerTimeInvalid":
		return OpcuaStatusCode_BadCertificateIssuerTimeInvalid, true
	case "BadCertificateHostNameInvalid":
		return OpcuaStatusCode_BadCertificateHostNameInvalid, true
	case "BadCertificateUriInvalid":
		return OpcuaStatusCode_BadCertificateUriInvalid, true
	case "BadCertificateUseNotAllowed":
		return OpcuaStatusCode_BadCertificateUseNotAllowed, true
	case "BadCertificateIssuerUseNotAllowed":
		return OpcuaStatusCode_BadCertificateIssuerUseNotAllowed, true
	case "BadCertificateUntrusted":
		return OpcuaStatusCode_BadCertificateUntrusted, true
	case "BadCertificateRevocationUnknown":
		return OpcuaStatusCode_BadCertificateRevocationUnknown, true
	case "BadCertificateIssuerRevocationUnknown":
		return OpcuaStatusCode_BadCertificateIssuerRevocationUnknown, true
	case "BadCertificateRevoked":
		return OpcuaStatusCode_BadCertificateRevoked, true
	case "BadCertificateIssuerRevoked":
		return OpcuaStatusCode_BadCertificateIssuerRevoked, true
	case "BadUserAccessDenied":
		return OpcuaStatusCode_BadUserAccessDenied, true
	case "BadIdentityTokenInvalid":
		return OpcuaStatusCode_BadIdentityTokenInvalid, true
	case "BadIdentityTokenRejected":
		return OpcuaStatusCode_BadIdentityTokenRejected, true
	case "BadSecureChannelIdInvalid":
		return OpcuaStatusCode_BadSecureChannelIdInvalid, true
	case "BadInvalidTimestamp":
		return OpcuaStatusCode_BadInvalidTimestamp, true
	case "BadNonceInvalid":
		return OpcuaStatusCode_BadNonceInvalid, true
	case "BadSessionIdInvalid":
		return OpcuaStatusCode_BadSessionIdInvalid, true
	case "BadSessionClosed":
		return OpcuaStatusCode_BadSessionClosed, true
	case "BadSessionNotActivated":
		return OpcuaStatusCode_BadSessionNotActivated, true
	case "BadSubscriptionIdInvalid":
		return OpcuaStatusCode_BadSubscriptionIdInvalid, true
	case "BadRequestHeaderInvalid":
		return OpcuaStatusCode_BadRequestHeaderInvalid, true
	case "BadTimestampsToReturnInvalid":
		return OpcuaStatusCode_BadTimestampsToReturnInvalid, true
	case "BadRequestCancelledByClient":
		return OpcuaStatusCode_BadRequestCancelledByClient, true
	case "BadNoCommunication":
		return OpcuaStatusCode_BadNoCommunication, true
	case "BadWaitingForInitialData":
		return OpcuaStatusCode_BadWaitingForInitialData, true
	case "BadNodeIdInvalid":
		return OpcuaStatusCode_BadNodeIdInvalid, true
	case "BadNodeIdUnknown":
		return OpcuaStatusCode_BadNodeIdUnknown, true
	case "BadAttributeIdInvalid":
		return OpcuaStatusCode_BadAttributeIdInvalid, true
	case "BadIndexRangeInvalid":
		return OpcuaStatusCode_BadIndexRangeInvalid, true
	case "BadIndexRangeNoData":
		return OpcuaStatusCode_BadIndexRangeNoData, true
	case "BadDataEncodingInvalid":
		return OpcuaStatusCode_BadDataEncodingInvalid, true
	case "BadDataEncodingUnsupported":
		return OpcuaStatusCode_BadDataEncodingUnsupported, true
	case "BadNotReadable":
		return OpcuaStatusCode_BadNotReadable, true
	case "BadNotWritable":
		return OpcuaStatusCode_BadNotWritable, true
	case "BadOutOfRange":
		return OpcuaStatusCode_BadOutOfRange, true
	case "BadNotSupported":
		return OpcuaStatusCode_BadNotSupported, true
	case "BadNotFound":
		return OpcuaStatusCode_BadNotFound, true
	case "BadObjectDeleted":
		return OpcuaStatusCode_BadObjectDeleted, true
	case "BadNotImplemented":
		return OpcuaStatusCode_BadNotImplemented, true
	case "BadMonitoringModeInvalid":
		return OpcuaStatusCode_BadMonitoringModeInvalid, true
	case "BadMonitoredItemIdInvalid":
		return OpcuaStatusCode_BadMonitoredItemIdInvalid, true
	case "BadMonitoredItemFilterInvalid":
		return OpcuaStatusCode_BadMonitoredItemFilterInvalid, true
	case "BadMonitoredItemFilterUnsupported":
		return OpcuaStatusCode_BadMonitoredItemFilterUnsupported, true
	case "BadFilterNotAllowed":
		return OpcuaStatusCode_BadFilterNotAllowed, true
	case "BadStructureMissing":
		return OpcuaStatusCode_BadStructureMissing, true
	case "BadEventFilterInvalid":
		return OpcuaStatusCode_BadEventFilterInvalid, true
	case "BadContentFilterInvalid":
		return OpcuaStatusCode_BadContentFilterInvalid, true
	case "BadFilterOperandInvalid":
		return OpcuaStatusCode_BadFilterOperandInvalid, true
	case "BadContinuationPointInvalid":
		return OpcuaStatusCode_BadContinuationPointInvalid, true
	case "BadNoContinuationPoints":
		return OpcuaStatusCode_BadNoContinuationPoints, true
	case "BadReferenceTypeIdInvalid":
		return OpcuaStatusCode_BadReferenceTypeIdInvalid, true
	case "BadBrowseDirectionInvalid":
		return OpcuaStatusCode_BadBrowseDirectionInvalid, true
	case "BadNodeNotInView":
		return OpcuaStatusCode_BadNodeNotInView, true
	case "BadServerUriInvalid":
		return OpcuaStatusCode_BadServerUriInvalid, true
	case "BadServerNameMissing":
		return OpcuaStatusCode_BadServerNameMissing, true
	case "BadDiscoveryUrlMissing":
		return OpcuaStatusCode_BadDiscoveryUrlMissing, true
	case "BadSempahoreFileMissing":
		return OpcuaStatusCode_BadSempahoreFileMissing, true
	case "BadRequestTypeInvalid":
		return OpcuaStatusCode_BadRequestTypeInvalid, true
	case "BadSecurityModeRejected":
		return OpcuaStatusCode_BadSecurityModeRejected, true
	case "BadSecurityPolicyRejected":
		return OpcuaStatusCode_BadSecurityPolicyRejected, true
	case "BadTooManySessions":
		return OpcuaStatusCode_BadTooManySessions, true
	case "BadUserSignatureInvalid":
		return OpcuaStatusCode_BadUserSignatureInvalid, true
	case "BadApplicationSignatureInvalid":
		return OpcuaStatusCode_BadApplicationSignatureInvalid, true
	case "BadNoValidCertificates":
		return OpcuaStatusCode_BadNoValidCertificates, true
	case "BadRequestCancelledByRequest":
		return OpcuaStatusCode_BadRequestCancelledByRequest, true
	case "BadParentNodeIdInvalid":
		return OpcuaStatusCode_BadParentNodeIdInvalid, true
	case "BadReferenceNotAllowed":
		return OpcuaStatusCode_BadReferenceNotAllowed, true
	case "BadNodeIdRejected":
		return OpcuaStatusCode_BadNodeIdRejected, true
	case "BadNodeIdExists":
		return OpcuaStatusCode_BadNodeIdExists, true
	case "BadNodeClassInvalid":
		return OpcuaStatusCode_BadNodeClassInvalid, true
	case "BadBrowseNameInvalid":
		return OpcuaStatusCode_BadBrowseNameInvalid, true
	case "BadBrowseNameDuplicated":
		return OpcuaStatusCode_BadBrowseNameDuplicated, true
	case "BadNodeAttributesInvalid":
		return OpcuaStatusCode_BadNodeAttributesInvalid, true
	case "BadTypeDefinitionInvalid":
		return OpcuaStatusCode_BadTypeDefinitionInvalid, true
	case "BadSourceNodeIdInvalid":
		return OpcuaStatusCode_BadSourceNodeIdInvalid, true
	case "BadTargetNodeIdInvalid":
		return OpcuaStatusCode_BadTargetNodeIdInvalid, true
	case "BadDuplicateReferenceNotAllowed":
		return OpcuaStatusCode_BadDuplicateReferenceNotAllowed, true
	case "BadInvalidSelfReference":
		return OpcuaStatusCode_BadInvalidSelfReference, true
	case "BadReferenceLocalOnly":
		return OpcuaStatusCode_BadReferenceLocalOnly, true
	case "BadNoDeleteRights":
		return OpcuaStatusCode_BadNoDeleteRights, true
	case "BadServerIndexInvalid":
		return OpcuaStatusCode_BadServerIndexInvalid, true
	case "BadViewIdUnknown":
		return OpcuaStatusCode_BadViewIdUnknown, true
	case "BadTooManyMatches":
		return OpcuaStatusCode_BadTooManyMatches, true
	case "BadQueryTooComplex":
		return OpcuaStatusCode_BadQueryTooComplex, true
	case "BadNoMatch":
		return OpcuaStatusCode_BadNoMatch, true
	case "BadMaxAgeInvalid":
		return OpcuaStatusCode_BadMaxAgeInvalid, true
	case "BadHistoryOperationInvalid":
		return OpcuaStatusCode_BadHistoryOperationInvalid, true
	case "BadHistoryOperationUnsupported":
		return OpcuaStatusCode_BadHistoryOperationUnsupported, true
	case "BadWriteNotSupported":
		return OpcuaStatusCode_BadWriteNotSupported, true
	case "BadTypeMismatch":
		return OpcuaStatusCode_BadTypeMismatch, true
	case "BadMethodInvalid":
		return OpcuaStatusCode_BadMethodInvalid, true
	case "BadArgumentsMissing":
		return OpcuaStatusCode_BadArgumentsMissing, true
	case "BadTooManySubscriptions":
		return OpcuaStatusCode_BadTooManySubscriptions, true
	case "BadTooManyPublishRequests":
		return OpcuaStatusCode_BadTooManyPublishRequests, true
	case "BadNoSubscription":
		return OpcuaStatusCode_BadNoSubscription, true
	case "BadSequenceNumberUnknown":
		return OpcuaStatusCode_BadSequenceNumberUnknown, true
	case "BadMessageNotAvailable":
		return OpcuaStatusCode_BadMessageNotAvailable, true
	case "BadInsufficientClientProfile":
		return OpcuaStatusCode_BadInsufficientClientProfile, true
	case "BadTcpServerTooBusy":
		return OpcuaStatusCode_BadTcpServerTooBusy, true
	case "BadTcpMessageTypeInvalid":
		return OpcuaStatusCode_BadTcpMessageTypeInvalid, true
	case "BadTcpSecureChannelUnknown":
		return OpcuaStatusCode_BadTcpSecureChannelUnknown, true
	case "BadTcpMessageTooLarge":
		return OpcuaStatusCode_BadTcpMessageTooLarge, true
	case "BadTcpNotEnoughResources":
		return OpcuaStatusCode_BadTcpNotEnoughResources, true
	case "BadTcpInternalError":
		return OpcuaStatusCode_BadTcpInternalError, true
	case "BadTcpEndpointUrlInvalid":
		return OpcuaStatusCode_BadTcpEndpointUrlInvalid, true
	case "BadRequestInterrupted":
		return OpcuaStatusCode_BadRequestInterrupted, true
	case "BadRequestTimeout":
		return OpcuaStatusCode_BadRequestTimeout, true
	case "BadSecureChannelClosed":
		return OpcuaStatusCode_BadSecureChannelClosed, true
	case "BadSecureChannelTokenUnknown":
		return OpcuaStatusCode_BadSecureChannelTokenUnknown, true
	case "BadSequenceNumberInvalid":
		return OpcuaStatusCode_BadSequenceNumberInvalid, true
	case "BadConfigurationError":
		return OpcuaStatusCode_BadConfigurationError, true
	case "BadNotConnected":
		return OpcuaStatusCode_BadNotConnected, true
	case "BadDeviceFailure":
		return OpcuaStatusCode_BadDeviceFailure, true
	case "BadSensorFailure":
		return OpcuaStatusCode_BadSensorFailure, true
	case "BadOutOfService":
		return OpcuaStatusCode_BadOutOfService, true
	case "BadDeadbandFilterInvalid":
		return OpcuaStatusCode_BadDeadbandFilterInvalid, true
	case "BadRefreshInProgress":
		return OpcuaStatusCode_BadRefreshInProgress, true
	case "BadConditionAlreadyDisabled":
		return OpcuaStatusCode_BadConditionAlreadyDisabled, true
	case "BadConditionDisabled":
		return OpcuaStatusCode_BadConditionDisabled, true
	case "BadEventIdUnknown":
		return OpcuaStatusCode_BadEventIdUnknown, true
	case "BadNoData":
		return OpcuaStatusCode_BadNoData, true
	case "BadDataLost":
		return OpcuaStatusCode_BadDataLost, true
	case "BadDataUnavailable":
		return OpcuaStatusCode_BadDataUnavailable, true
	case "BadEntryExists":
		return OpcuaStatusCode_BadEntryExists, true
	case "BadNoEntryExists":
		return OpcuaStatusCode_BadNoEntryExists, true
	case "BadTimestampNotSupported":
		return OpcuaStatusCode_BadTimestampNotSupported, true
	case "BadInvalidArgument":
		return OpcuaStatusCode_BadInvalidArgument, true
	case "BadConnectionRejected":
		return OpcuaStatusCode_BadConnectionRejected, true
	case "BadDisconnect":
		return OpcuaStatusCode_BadDisconnect, true
	case "BadConnectionClosed":
		return OpcuaStatusCode_BadConnectionClosed, true
	case "BadInvalidState":
		return OpcuaStatusCode_BadInvalidState, true
	case "BadEndOfStream":
		return OpcuaStatusCode_BadEndOfStream, true
	case "BadNoDataAvailable":
		return OpcuaStatusCode_BadNoDataAvailable, true
	case "BadWaitingForResponse":
		return OpcuaStatusCode_BadWaitingForResponse, true
	case "BadOperationAbandoned":
		return OpcuaStatusCode_BadOperationAbandoned, true
	case "BadExpectedStreamToBlock":
		return OpcuaStatusCode_BadExpectedStreamToBlock, true
	case "BadWouldBlock":
		return OpcuaStatusCode_BadWouldBlock, true
	case "BadSyntaxError":
		return OpcuaStatusCode_BadSyntaxError, true
	case "BadMaxConnectionsReached":
		return OpcuaStatusCode_BadMaxConnectionsReached, true
	case "BadRequestTooLarge":
		return OpcuaStatusCode_BadRequestTooLarge, true
	case "BadResponseTooLarge":
		return OpcuaStatusCode_BadResponseTooLarge, true
	case "BadEventNotAcknowledgeable":
		return OpcuaStatusCode_BadEventNotAcknowledgeable, true
	case "BadInvalidTimestampArgument":
		return OpcuaStatusCode_BadInvalidTimestampArgument, true
	case "BadProtocolVersionUnsupported":
		return OpcuaStatusCode_BadProtocolVersionUnsupported, true
	case "BadStateNotActive":
		return OpcuaStatusCode_BadStateNotActive, true
	case "BadFilterOperatorInvalid":
		return OpcuaStatusCode_BadFilterOperatorInvalid, true
	case "BadFilterOperatorUnsupported":
		return OpcuaStatusCode_BadFilterOperatorUnsupported, true
	case "BadFilterOperandCountMismatch":
		return OpcuaStatusCode_BadFilterOperandCountMismatch, true
	case "BadFilterElementInvalid":
		return OpcuaStatusCode_BadFilterElementInvalid, true
	case "BadFilterLiteralInvalid":
		return OpcuaStatusCode_BadFilterLiteralInvalid, true
	case "BadIdentityChangeNotSupported":
		return OpcuaStatusCode_BadIdentityChangeNotSupported, true
	case "BadNotTypeDefinition":
		return OpcuaStatusCode_BadNotTypeDefinition, true
	case "BadViewTimestampInvalid":
		return OpcuaStatusCode_BadViewTimestampInvalid, true
	case "BadViewParameterMismatch":
		return OpcuaStatusCode_BadViewParameterMismatch, true
	case "BadViewVersionInvalid":
		return OpcuaStatusCode_BadViewVersionInvalid, true
	case "BadConditionAlreadyEnabled":
		return OpcuaStatusCode_BadConditionAlreadyEnabled, true
	case "BadDialogNotActive":
		return OpcuaStatusCode_BadDialogNotActive, true
	case "BadDialogResponseInvalid":
		return OpcuaStatusCode_BadDialogResponseInvalid, true
	case "BadConditionBranchAlreadyAcked":
		return OpcuaStatusCode_BadConditionBranchAlreadyAcked, true
	case "BadConditionBranchAlreadyConfirmed":
		return OpcuaStatusCode_BadConditionBranchAlreadyConfirmed, true
	case "BadConditionAlreadyShelved":
		return OpcuaStatusCode_BadConditionAlreadyShelved, true
	case "BadConditionNotShelved":
		return OpcuaStatusCode_BadConditionNotShelved, true
	case "BadShelvingTimeOutOfRange":
		return OpcuaStatusCode_BadShelvingTimeOutOfRange, true
	case "BadAggregateListMismatch":
		return OpcuaStatusCode_BadAggregateListMismatch, true
	case "BadAggregateNotSupported":
		return OpcuaStatusCode_BadAggregateNotSupported, true
	case "BadAggregateInvalidInputs":
		return OpcuaStatusCode_BadAggregateInvalidInputs, true
	case "BadBoundNotFound":
		return OpcuaStatusCode_BadBoundNotFound, true
	case "BadBoundNotSupported":
		return OpcuaStatusCode_BadBoundNotSupported, true
	case "BadAggregateConfigurationRejected":
		return OpcuaStatusCode_BadAggregateConfigurationRejected, true
	case "BadTooManyMonitoredItems":
		return OpcuaStatusCode_BadTooManyMonitoredItems, true
	case "BadDominantValueChanged":
		return OpcuaStatusCode_BadDominantValueChanged, true
	case "BadDependentValueChanged":
		return OpcuaStatusCode_BadDependentValueChanged, true
	case "BadRequestNotAllowed":
		return OpcuaStatusCode_BadRequestNotAllowed, true
	case "BadTooManyArguments":
		return OpcuaStatusCode_BadTooManyArguments, true
	case "BadSecurityModeInsufficient":
		return OpcuaStatusCode_BadSecurityModeInsufficient, true
	case "BadDataSetIdInvalid":
		return OpcuaStatusCode_BadDataSetIdInvalid, true
	case "BadTransactionPending":
		return OpcuaStatusCode_BadTransactionPending, true
	case "BadLocked":
		return OpcuaStatusCode_BadLocked, true
	case "BadCertificateChainIncomplete":
		return OpcuaStatusCode_BadCertificateChainIncomplete, true
	case "BadLicenseExpired":
		return OpcuaStatusCode_BadLicenseExpired, true
	case "BadLicenseLimitsExceeded":
		return OpcuaStatusCode_BadLicenseLimitsExceeded, true
	case "BadLicenseNotAvailable":
		return OpcuaStatusCode_BadLicenseNotAvailable, true
	case "BadNotExecutable":
		return OpcuaStatusCode_BadNotExecutable, true
	case "BadNumericOverflow":
		return OpcuaStatusCode_BadNumericOverflow, true
	case "BadRequestNotComplete":
		return OpcuaStatusCode_BadRequestNotComplete, true
	case "BadCertificatePolicyCheckFailed":
		return OpcuaStatusCode_BadCertificatePolicyCheckFailed, true
	case "BadAlreadyExists":
		return OpcuaStatusCode_BadAlreadyExists, true
	case "BadEdited_OutOfRange":
		return OpcuaStatusCode_BadEdited_OutOfRange, true
	case "BadInitialValue_OutOfRange":
		return OpcuaStatusCode_BadInitialValue_OutOfRange, true
	case "BadOutOfRange_DominantValueChanged":
		return OpcuaStatusCode_BadOutOfRange_DominantValueChanged, true
	case "BadEdited_OutOfRange_DominantValueChanged":
		return OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged, true
	case "BadOutOfRange_DominantValueChanged_DependentValueChanged":
		return OpcuaStatusCode_BadOutOfRange_DominantValueChanged_DependentValueChanged, true
	case "BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged":
		return OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged, true
	case "BadTicketRequired":
		return OpcuaStatusCode_BadTicketRequired, true
	case "BadTicketInvalid":
		return OpcuaStatusCode_BadTicketInvalid, true
	}
	return 0, false
}

func OpcuaStatusCodeKnows(value uint32) bool {
	for _, typeValue := range OpcuaStatusCodeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaStatusCode(structType any) OpcuaStatusCode {
	castFunc := func(typ any) OpcuaStatusCode {
		if sOpcuaStatusCode, ok := typ.(OpcuaStatusCode); ok {
			return sOpcuaStatusCode
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaStatusCode) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaStatusCode) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaStatusCodeParse(ctx context.Context, theBytes []byte) (OpcuaStatusCode, error) {
	return OpcuaStatusCodeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaStatusCodeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaStatusCode, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint32("OpcuaStatusCode", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaStatusCode")
	}
	if enum, ok := OpcuaStatusCodeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaStatusCode")
		return OpcuaStatusCode(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaStatusCode) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaStatusCode) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint32("OpcuaStatusCode", 32, uint32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaStatusCode) PLC4XEnumName() string {
	switch e {
	case OpcuaStatusCode_Good:
		return "Good"
	case OpcuaStatusCode_GoodSubscriptionTransferred:
		return "GoodSubscriptionTransferred"
	case OpcuaStatusCode_GoodCompletesAsynchronously:
		return "GoodCompletesAsynchronously"
	case OpcuaStatusCode_GoodOverload:
		return "GoodOverload"
	case OpcuaStatusCode_GoodClamped:
		return "GoodClamped"
	case OpcuaStatusCode_GoodLocalOverride:
		return "GoodLocalOverride"
	case OpcuaStatusCode_GoodEntryInserted:
		return "GoodEntryInserted"
	case OpcuaStatusCode_GoodEntryReplaced:
		return "GoodEntryReplaced"
	case OpcuaStatusCode_GoodNoData:
		return "GoodNoData"
	case OpcuaStatusCode_GoodMoreData:
		return "GoodMoreData"
	case OpcuaStatusCode_GoodCommunicationEvent:
		return "GoodCommunicationEvent"
	case OpcuaStatusCode_GoodShutdownEvent:
		return "GoodShutdownEvent"
	case OpcuaStatusCode_GoodCallAgain:
		return "GoodCallAgain"
	case OpcuaStatusCode_GoodNonCriticalTimeout:
		return "GoodNonCriticalTimeout"
	case OpcuaStatusCode_GoodResultsMayBeIncomplete:
		return "GoodResultsMayBeIncomplete"
	case OpcuaStatusCode_GoodDataIgnored:
		return "GoodDataIgnored"
	case OpcuaStatusCode_GoodEdited:
		return "GoodEdited"
	case OpcuaStatusCode_GoodPostActionFailed:
		return "GoodPostActionFailed"
	case OpcuaStatusCode_GoodRetransmissionQueueNotSupported:
		return "GoodRetransmissionQueueNotSupported"
	case OpcuaStatusCode_GoodDependentValueChanged:
		return "GoodDependentValueChanged"
	case OpcuaStatusCode_GoodEdited_DependentValueChanged:
		return "GoodEdited_DependentValueChanged"
	case OpcuaStatusCode_GoodEdited_DominantValueChanged:
		return "GoodEdited_DominantValueChanged"
	case OpcuaStatusCode_GoodEdited_DominantValueChanged_DependentValueChanged:
		return "GoodEdited_DominantValueChanged_DependentValueChanged"
	case OpcuaStatusCode_GoodCascadeInitializationAcknowledged:
		return "GoodCascadeInitializationAcknowledged"
	case OpcuaStatusCode_GoodCascadeInitializationRequest:
		return "GoodCascadeInitializationRequest"
	case OpcuaStatusCode_GoodCascadeNotInvited:
		return "GoodCascadeNotInvited"
	case OpcuaStatusCode_GoodCascadeNotSelected:
		return "GoodCascadeNotSelected"
	case OpcuaStatusCode_GoodFaultStateActive:
		return "GoodFaultStateActive"
	case OpcuaStatusCode_GoodInitiateFaultState:
		return "GoodInitiateFaultState"
	case OpcuaStatusCode_GoodCascade:
		return "GoodCascade"
	case OpcuaStatusCode_Uncertain:
		return "Uncertain"
	case OpcuaStatusCode_UncertainReferenceOutOfServer:
		return "UncertainReferenceOutOfServer"
	case OpcuaStatusCode_UncertainNoCommunicationLastUsableValue:
		return "UncertainNoCommunicationLastUsableValue"
	case OpcuaStatusCode_UncertainLastUsableValue:
		return "UncertainLastUsableValue"
	case OpcuaStatusCode_UncertainSubstituteValue:
		return "UncertainSubstituteValue"
	case OpcuaStatusCode_UncertainInitialValue:
		return "UncertainInitialValue"
	case OpcuaStatusCode_UncertainSensorNotAccurate:
		return "UncertainSensorNotAccurate"
	case OpcuaStatusCode_UncertainEngineeringUnitsExceeded:
		return "UncertainEngineeringUnitsExceeded"
	case OpcuaStatusCode_UncertainSubNormal:
		return "UncertainSubNormal"
	case OpcuaStatusCode_UncertainDataSubNormal:
		return "UncertainDataSubNormal"
	case OpcuaStatusCode_UncertainReferenceNotDeleted:
		return "UncertainReferenceNotDeleted"
	case OpcuaStatusCode_UncertainNotAllNodesAvailable:
		return "UncertainNotAllNodesAvailable"
	case OpcuaStatusCode_UncertainDominantValueChanged:
		return "UncertainDominantValueChanged"
	case OpcuaStatusCode_UncertainDependentValueChanged:
		return "UncertainDependentValueChanged"
	case OpcuaStatusCode_UncertainTransducerInManual:
		return "UncertainTransducerInManual"
	case OpcuaStatusCode_UncertainSimulatedValue:
		return "UncertainSimulatedValue"
	case OpcuaStatusCode_UncertainSensorCalibration:
		return "UncertainSensorCalibration"
	case OpcuaStatusCode_UncertainConfigurationError:
		return "UncertainConfigurationError"
	case OpcuaStatusCode_Bad:
		return "Bad"
	case OpcuaStatusCode_BadUnexpectedError:
		return "BadUnexpectedError"
	case OpcuaStatusCode_BadInternalError:
		return "BadInternalError"
	case OpcuaStatusCode_BadOutOfMemory:
		return "BadOutOfMemory"
	case OpcuaStatusCode_BadResourceUnavailable:
		return "BadResourceUnavailable"
	case OpcuaStatusCode_BadCommunicationError:
		return "BadCommunicationError"
	case OpcuaStatusCode_BadEncodingError:
		return "BadEncodingError"
	case OpcuaStatusCode_BadDecodingError:
		return "BadDecodingError"
	case OpcuaStatusCode_BadEncodingLimitsExceeded:
		return "BadEncodingLimitsExceeded"
	case OpcuaStatusCode_BadUnknownResponse:
		return "BadUnknownResponse"
	case OpcuaStatusCode_BadTimeout:
		return "BadTimeout"
	case OpcuaStatusCode_BadServiceUnsupported:
		return "BadServiceUnsupported"
	case OpcuaStatusCode_BadShutdown:
		return "BadShutdown"
	case OpcuaStatusCode_BadServerNotConnected:
		return "BadServerNotConnected"
	case OpcuaStatusCode_BadServerHalted:
		return "BadServerHalted"
	case OpcuaStatusCode_BadNothingToDo:
		return "BadNothingToDo"
	case OpcuaStatusCode_BadTooManyOperations:
		return "BadTooManyOperations"
	case OpcuaStatusCode_BadDataTypeIdUnknown:
		return "BadDataTypeIdUnknown"
	case OpcuaStatusCode_BadCertificateInvalid:
		return "BadCertificateInvalid"
	case OpcuaStatusCode_BadSecurityChecksFailed:
		return "BadSecurityChecksFailed"
	case OpcuaStatusCode_BadCertificateTimeInvalid:
		return "BadCertificateTimeInvalid"
	case OpcuaStatusCode_BadCertificateIssuerTimeInvalid:
		return "BadCertificateIssuerTimeInvalid"
	case OpcuaStatusCode_BadCertificateHostNameInvalid:
		return "BadCertificateHostNameInvalid"
	case OpcuaStatusCode_BadCertificateUriInvalid:
		return "BadCertificateUriInvalid"
	case OpcuaStatusCode_BadCertificateUseNotAllowed:
		return "BadCertificateUseNotAllowed"
	case OpcuaStatusCode_BadCertificateIssuerUseNotAllowed:
		return "BadCertificateIssuerUseNotAllowed"
	case OpcuaStatusCode_BadCertificateUntrusted:
		return "BadCertificateUntrusted"
	case OpcuaStatusCode_BadCertificateRevocationUnknown:
		return "BadCertificateRevocationUnknown"
	case OpcuaStatusCode_BadCertificateIssuerRevocationUnknown:
		return "BadCertificateIssuerRevocationUnknown"
	case OpcuaStatusCode_BadCertificateRevoked:
		return "BadCertificateRevoked"
	case OpcuaStatusCode_BadCertificateIssuerRevoked:
		return "BadCertificateIssuerRevoked"
	case OpcuaStatusCode_BadUserAccessDenied:
		return "BadUserAccessDenied"
	case OpcuaStatusCode_BadIdentityTokenInvalid:
		return "BadIdentityTokenInvalid"
	case OpcuaStatusCode_BadIdentityTokenRejected:
		return "BadIdentityTokenRejected"
	case OpcuaStatusCode_BadSecureChannelIdInvalid:
		return "BadSecureChannelIdInvalid"
	case OpcuaStatusCode_BadInvalidTimestamp:
		return "BadInvalidTimestamp"
	case OpcuaStatusCode_BadNonceInvalid:
		return "BadNonceInvalid"
	case OpcuaStatusCode_BadSessionIdInvalid:
		return "BadSessionIdInvalid"
	case OpcuaStatusCode_BadSessionClosed:
		return "BadSessionClosed"
	case OpcuaStatusCode_BadSessionNotActivated:
		return "BadSessionNotActivated"
	case OpcuaStatusCode_BadSubscriptionIdInvalid:
		return "BadSubscriptionIdInvalid"
	case OpcuaStatusCode_BadRequestHeaderInvalid:
		return "BadRequestHeaderInvalid"
	case OpcuaStatusCode_BadTimestampsToReturnInvalid:
		return "BadTimestampsToReturnInvalid"
	case OpcuaStatusCode_BadRequestCancelledByClient:
		return "BadRequestCancelledByClient"
	case OpcuaStatusCode_BadNoCommunication:
		return "BadNoCommunication"
	case OpcuaStatusCode_BadWaitingForInitialData:
		return "BadWaitingForInitialData"
	case OpcuaStatusCode_BadNodeIdInvalid:
		return "BadNodeIdInvalid"
	case OpcuaStatusCode_BadNodeIdUnknown:
		return "BadNodeIdUnknown"
	case OpcuaStatusCode_BadAttributeIdInvalid:
		return "BadAttributeIdInvalid"
	case OpcuaStatusCode_BadIndexRangeInvalid:
		return "BadIndexRangeInvalid"
	case OpcuaStatusCode_BadIndexRangeNoData:
		return "BadIndexRangeNoData"
	case OpcuaStatusCode_BadDataEncodingInvalid:
		return "BadDataEncodingInvalid"
	case OpcuaStatusCode_BadDataEncodingUnsupported:
		return "BadDataEncodingUnsupported"
	case OpcuaStatusCode_BadNotReadable:
		return "BadNotReadable"
	case OpcuaStatusCode_BadNotWritable:
		return "BadNotWritable"
	case OpcuaStatusCode_BadOutOfRange:
		return "BadOutOfRange"
	case OpcuaStatusCode_BadNotSupported:
		return "BadNotSupported"
	case OpcuaStatusCode_BadNotFound:
		return "BadNotFound"
	case OpcuaStatusCode_BadObjectDeleted:
		return "BadObjectDeleted"
	case OpcuaStatusCode_BadNotImplemented:
		return "BadNotImplemented"
	case OpcuaStatusCode_BadMonitoringModeInvalid:
		return "BadMonitoringModeInvalid"
	case OpcuaStatusCode_BadMonitoredItemIdInvalid:
		return "BadMonitoredItemIdInvalid"
	case OpcuaStatusCode_BadMonitoredItemFilterInvalid:
		return "BadMonitoredItemFilterInvalid"
	case OpcuaStatusCode_BadMonitoredItemFilterUnsupported:
		return "BadMonitoredItemFilterUnsupported"
	case OpcuaStatusCode_BadFilterNotAllowed:
		return "BadFilterNotAllowed"
	case OpcuaStatusCode_BadStructureMissing:
		return "BadStructureMissing"
	case OpcuaStatusCode_BadEventFilterInvalid:
		return "BadEventFilterInvalid"
	case OpcuaStatusCode_BadContentFilterInvalid:
		return "BadContentFilterInvalid"
	case OpcuaStatusCode_BadFilterOperandInvalid:
		return "BadFilterOperandInvalid"
	case OpcuaStatusCode_BadContinuationPointInvalid:
		return "BadContinuationPointInvalid"
	case OpcuaStatusCode_BadNoContinuationPoints:
		return "BadNoContinuationPoints"
	case OpcuaStatusCode_BadReferenceTypeIdInvalid:
		return "BadReferenceTypeIdInvalid"
	case OpcuaStatusCode_BadBrowseDirectionInvalid:
		return "BadBrowseDirectionInvalid"
	case OpcuaStatusCode_BadNodeNotInView:
		return "BadNodeNotInView"
	case OpcuaStatusCode_BadServerUriInvalid:
		return "BadServerUriInvalid"
	case OpcuaStatusCode_BadServerNameMissing:
		return "BadServerNameMissing"
	case OpcuaStatusCode_BadDiscoveryUrlMissing:
		return "BadDiscoveryUrlMissing"
	case OpcuaStatusCode_BadSempahoreFileMissing:
		return "BadSempahoreFileMissing"
	case OpcuaStatusCode_BadRequestTypeInvalid:
		return "BadRequestTypeInvalid"
	case OpcuaStatusCode_BadSecurityModeRejected:
		return "BadSecurityModeRejected"
	case OpcuaStatusCode_BadSecurityPolicyRejected:
		return "BadSecurityPolicyRejected"
	case OpcuaStatusCode_BadTooManySessions:
		return "BadTooManySessions"
	case OpcuaStatusCode_BadUserSignatureInvalid:
		return "BadUserSignatureInvalid"
	case OpcuaStatusCode_BadApplicationSignatureInvalid:
		return "BadApplicationSignatureInvalid"
	case OpcuaStatusCode_BadNoValidCertificates:
		return "BadNoValidCertificates"
	case OpcuaStatusCode_BadRequestCancelledByRequest:
		return "BadRequestCancelledByRequest"
	case OpcuaStatusCode_BadParentNodeIdInvalid:
		return "BadParentNodeIdInvalid"
	case OpcuaStatusCode_BadReferenceNotAllowed:
		return "BadReferenceNotAllowed"
	case OpcuaStatusCode_BadNodeIdRejected:
		return "BadNodeIdRejected"
	case OpcuaStatusCode_BadNodeIdExists:
		return "BadNodeIdExists"
	case OpcuaStatusCode_BadNodeClassInvalid:
		return "BadNodeClassInvalid"
	case OpcuaStatusCode_BadBrowseNameInvalid:
		return "BadBrowseNameInvalid"
	case OpcuaStatusCode_BadBrowseNameDuplicated:
		return "BadBrowseNameDuplicated"
	case OpcuaStatusCode_BadNodeAttributesInvalid:
		return "BadNodeAttributesInvalid"
	case OpcuaStatusCode_BadTypeDefinitionInvalid:
		return "BadTypeDefinitionInvalid"
	case OpcuaStatusCode_BadSourceNodeIdInvalid:
		return "BadSourceNodeIdInvalid"
	case OpcuaStatusCode_BadTargetNodeIdInvalid:
		return "BadTargetNodeIdInvalid"
	case OpcuaStatusCode_BadDuplicateReferenceNotAllowed:
		return "BadDuplicateReferenceNotAllowed"
	case OpcuaStatusCode_BadInvalidSelfReference:
		return "BadInvalidSelfReference"
	case OpcuaStatusCode_BadReferenceLocalOnly:
		return "BadReferenceLocalOnly"
	case OpcuaStatusCode_BadNoDeleteRights:
		return "BadNoDeleteRights"
	case OpcuaStatusCode_BadServerIndexInvalid:
		return "BadServerIndexInvalid"
	case OpcuaStatusCode_BadViewIdUnknown:
		return "BadViewIdUnknown"
	case OpcuaStatusCode_BadTooManyMatches:
		return "BadTooManyMatches"
	case OpcuaStatusCode_BadQueryTooComplex:
		return "BadQueryTooComplex"
	case OpcuaStatusCode_BadNoMatch:
		return "BadNoMatch"
	case OpcuaStatusCode_BadMaxAgeInvalid:
		return "BadMaxAgeInvalid"
	case OpcuaStatusCode_BadHistoryOperationInvalid:
		return "BadHistoryOperationInvalid"
	case OpcuaStatusCode_BadHistoryOperationUnsupported:
		return "BadHistoryOperationUnsupported"
	case OpcuaStatusCode_BadWriteNotSupported:
		return "BadWriteNotSupported"
	case OpcuaStatusCode_BadTypeMismatch:
		return "BadTypeMismatch"
	case OpcuaStatusCode_BadMethodInvalid:
		return "BadMethodInvalid"
	case OpcuaStatusCode_BadArgumentsMissing:
		return "BadArgumentsMissing"
	case OpcuaStatusCode_BadTooManySubscriptions:
		return "BadTooManySubscriptions"
	case OpcuaStatusCode_BadTooManyPublishRequests:
		return "BadTooManyPublishRequests"
	case OpcuaStatusCode_BadNoSubscription:
		return "BadNoSubscription"
	case OpcuaStatusCode_BadSequenceNumberUnknown:
		return "BadSequenceNumberUnknown"
	case OpcuaStatusCode_BadMessageNotAvailable:
		return "BadMessageNotAvailable"
	case OpcuaStatusCode_BadInsufficientClientProfile:
		return "BadInsufficientClientProfile"
	case OpcuaStatusCode_BadTcpServerTooBusy:
		return "BadTcpServerTooBusy"
	case OpcuaStatusCode_BadTcpMessageTypeInvalid:
		return "BadTcpMessageTypeInvalid"
	case OpcuaStatusCode_BadTcpSecureChannelUnknown:
		return "BadTcpSecureChannelUnknown"
	case OpcuaStatusCode_BadTcpMessageTooLarge:
		return "BadTcpMessageTooLarge"
	case OpcuaStatusCode_BadTcpNotEnoughResources:
		return "BadTcpNotEnoughResources"
	case OpcuaStatusCode_BadTcpInternalError:
		return "BadTcpInternalError"
	case OpcuaStatusCode_BadTcpEndpointUrlInvalid:
		return "BadTcpEndpointUrlInvalid"
	case OpcuaStatusCode_BadRequestInterrupted:
		return "BadRequestInterrupted"
	case OpcuaStatusCode_BadRequestTimeout:
		return "BadRequestTimeout"
	case OpcuaStatusCode_BadSecureChannelClosed:
		return "BadSecureChannelClosed"
	case OpcuaStatusCode_BadSecureChannelTokenUnknown:
		return "BadSecureChannelTokenUnknown"
	case OpcuaStatusCode_BadSequenceNumberInvalid:
		return "BadSequenceNumberInvalid"
	case OpcuaStatusCode_BadConfigurationError:
		return "BadConfigurationError"
	case OpcuaStatusCode_BadNotConnected:
		return "BadNotConnected"
	case OpcuaStatusCode_BadDeviceFailure:
		return "BadDeviceFailure"
	case OpcuaStatusCode_BadSensorFailure:
		return "BadSensorFailure"
	case OpcuaStatusCode_BadOutOfService:
		return "BadOutOfService"
	case OpcuaStatusCode_BadDeadbandFilterInvalid:
		return "BadDeadbandFilterInvalid"
	case OpcuaStatusCode_BadRefreshInProgress:
		return "BadRefreshInProgress"
	case OpcuaStatusCode_BadConditionAlreadyDisabled:
		return "BadConditionAlreadyDisabled"
	case OpcuaStatusCode_BadConditionDisabled:
		return "BadConditionDisabled"
	case OpcuaStatusCode_BadEventIdUnknown:
		return "BadEventIdUnknown"
	case OpcuaStatusCode_BadNoData:
		return "BadNoData"
	case OpcuaStatusCode_BadDataLost:
		return "BadDataLost"
	case OpcuaStatusCode_BadDataUnavailable:
		return "BadDataUnavailable"
	case OpcuaStatusCode_BadEntryExists:
		return "BadEntryExists"
	case OpcuaStatusCode_BadNoEntryExists:
		return "BadNoEntryExists"
	case OpcuaStatusCode_BadTimestampNotSupported:
		return "BadTimestampNotSupported"
	case OpcuaStatusCode_BadInvalidArgument:
		return "BadInvalidArgument"
	case OpcuaStatusCode_BadConnectionRejected:
		return "BadConnectionRejected"
	case OpcuaStatusCode_BadDisconnect:
		return "BadDisconnect"
	case OpcuaStatusCode_BadConnectionClosed:
		return "BadConnectionClosed"
	case OpcuaStatusCode_BadInvalidState:
		return "BadInvalidState"
	case OpcuaStatusCode_BadEndOfStream:
		return "BadEndOfStream"
	case OpcuaStatusCode_BadNoDataAvailable:
		return "BadNoDataAvailable"
	case OpcuaStatusCode_BadWaitingForResponse:
		return "BadWaitingForResponse"
	case OpcuaStatusCode_BadOperationAbandoned:
		return "BadOperationAbandoned"
	case OpcuaStatusCode_BadExpectedStreamToBlock:
		return "BadExpectedStreamToBlock"
	case OpcuaStatusCode_BadWouldBlock:
		return "BadWouldBlock"
	case OpcuaStatusCode_BadSyntaxError:
		return "BadSyntaxError"
	case OpcuaStatusCode_BadMaxConnectionsReached:
		return "BadMaxConnectionsReached"
	case OpcuaStatusCode_BadRequestTooLarge:
		return "BadRequestTooLarge"
	case OpcuaStatusCode_BadResponseTooLarge:
		return "BadResponseTooLarge"
	case OpcuaStatusCode_BadEventNotAcknowledgeable:
		return "BadEventNotAcknowledgeable"
	case OpcuaStatusCode_BadInvalidTimestampArgument:
		return "BadInvalidTimestampArgument"
	case OpcuaStatusCode_BadProtocolVersionUnsupported:
		return "BadProtocolVersionUnsupported"
	case OpcuaStatusCode_BadStateNotActive:
		return "BadStateNotActive"
	case OpcuaStatusCode_BadFilterOperatorInvalid:
		return "BadFilterOperatorInvalid"
	case OpcuaStatusCode_BadFilterOperatorUnsupported:
		return "BadFilterOperatorUnsupported"
	case OpcuaStatusCode_BadFilterOperandCountMismatch:
		return "BadFilterOperandCountMismatch"
	case OpcuaStatusCode_BadFilterElementInvalid:
		return "BadFilterElementInvalid"
	case OpcuaStatusCode_BadFilterLiteralInvalid:
		return "BadFilterLiteralInvalid"
	case OpcuaStatusCode_BadIdentityChangeNotSupported:
		return "BadIdentityChangeNotSupported"
	case OpcuaStatusCode_BadNotTypeDefinition:
		return "BadNotTypeDefinition"
	case OpcuaStatusCode_BadViewTimestampInvalid:
		return "BadViewTimestampInvalid"
	case OpcuaStatusCode_BadViewParameterMismatch:
		return "BadViewParameterMismatch"
	case OpcuaStatusCode_BadViewVersionInvalid:
		return "BadViewVersionInvalid"
	case OpcuaStatusCode_BadConditionAlreadyEnabled:
		return "BadConditionAlreadyEnabled"
	case OpcuaStatusCode_BadDialogNotActive:
		return "BadDialogNotActive"
	case OpcuaStatusCode_BadDialogResponseInvalid:
		return "BadDialogResponseInvalid"
	case OpcuaStatusCode_BadConditionBranchAlreadyAcked:
		return "BadConditionBranchAlreadyAcked"
	case OpcuaStatusCode_BadConditionBranchAlreadyConfirmed:
		return "BadConditionBranchAlreadyConfirmed"
	case OpcuaStatusCode_BadConditionAlreadyShelved:
		return "BadConditionAlreadyShelved"
	case OpcuaStatusCode_BadConditionNotShelved:
		return "BadConditionNotShelved"
	case OpcuaStatusCode_BadShelvingTimeOutOfRange:
		return "BadShelvingTimeOutOfRange"
	case OpcuaStatusCode_BadAggregateListMismatch:
		return "BadAggregateListMismatch"
	case OpcuaStatusCode_BadAggregateNotSupported:
		return "BadAggregateNotSupported"
	case OpcuaStatusCode_BadAggregateInvalidInputs:
		return "BadAggregateInvalidInputs"
	case OpcuaStatusCode_BadBoundNotFound:
		return "BadBoundNotFound"
	case OpcuaStatusCode_BadBoundNotSupported:
		return "BadBoundNotSupported"
	case OpcuaStatusCode_BadAggregateConfigurationRejected:
		return "BadAggregateConfigurationRejected"
	case OpcuaStatusCode_BadTooManyMonitoredItems:
		return "BadTooManyMonitoredItems"
	case OpcuaStatusCode_BadDominantValueChanged:
		return "BadDominantValueChanged"
	case OpcuaStatusCode_BadDependentValueChanged:
		return "BadDependentValueChanged"
	case OpcuaStatusCode_BadRequestNotAllowed:
		return "BadRequestNotAllowed"
	case OpcuaStatusCode_BadTooManyArguments:
		return "BadTooManyArguments"
	case OpcuaStatusCode_BadSecurityModeInsufficient:
		return "BadSecurityModeInsufficient"
	case OpcuaStatusCode_BadDataSetIdInvalid:
		return "BadDataSetIdInvalid"
	case OpcuaStatusCode_BadTransactionPending:
		return "BadTransactionPending"
	case OpcuaStatusCode_BadLocked:
		return "BadLocked"
	case OpcuaStatusCode_BadCertificateChainIncomplete:
		return "BadCertificateChainIncomplete"
	case OpcuaStatusCode_BadLicenseExpired:
		return "BadLicenseExpired"
	case OpcuaStatusCode_BadLicenseLimitsExceeded:
		return "BadLicenseLimitsExceeded"
	case OpcuaStatusCode_BadLicenseNotAvailable:
		return "BadLicenseNotAvailable"
	case OpcuaStatusCode_BadNotExecutable:
		return "BadNotExecutable"
	case OpcuaStatusCode_BadNumericOverflow:
		return "BadNumericOverflow"
	case OpcuaStatusCode_BadRequestNotComplete:
		return "BadRequestNotComplete"
	case OpcuaStatusCode_BadCertificatePolicyCheckFailed:
		return "BadCertificatePolicyCheckFailed"
	case OpcuaStatusCode_BadAlreadyExists:
		return "BadAlreadyExists"
	case OpcuaStatusCode_BadEdited_OutOfRange:
		return "BadEdited_OutOfRange"
	case OpcuaStatusCode_BadInitialValue_OutOfRange:
		return "BadInitialValue_OutOfRange"
	case OpcuaStatusCode_BadOutOfRange_DominantValueChanged:
		return "BadOutOfRange_DominantValueChanged"
	case OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged:
		return "BadEdited_OutOfRange_DominantValueChanged"
	case OpcuaStatusCode_BadOutOfRange_DominantValueChanged_DependentValueChanged:
		return "BadOutOfRange_DominantValueChanged_DependentValueChanged"
	case OpcuaStatusCode_BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged:
		return "BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged"
	case OpcuaStatusCode_BadTicketRequired:
		return "BadTicketRequired"
	case OpcuaStatusCode_BadTicketInvalid:
		return "BadTicketInvalid"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e OpcuaStatusCode) String() string {
	return e.PLC4XEnumName()
}
