/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableVector is an enum
type OpcuaNodeIdServicesVariableVector int32

type IOpcuaNodeIdServicesVariableVector interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableVector_VectorType_VectorUnit OpcuaNodeIdServicesVariableVector = 17715
)

var OpcuaNodeIdServicesVariableVectorValues []OpcuaNodeIdServicesVariableVector

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableVectorValues = []OpcuaNodeIdServicesVariableVector{
		OpcuaNodeIdServicesVariableVector_VectorType_VectorUnit,
	}
}

func OpcuaNodeIdServicesVariableVectorByValue(value int32) (enum OpcuaNodeIdServicesVariableVector, ok bool) {
	switch value {
	case 17715:
		return OpcuaNodeIdServicesVariableVector_VectorType_VectorUnit, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableVectorByName(value string) (enum OpcuaNodeIdServicesVariableVector, ok bool) {
	switch value {
	case "VectorType_VectorUnit":
		return OpcuaNodeIdServicesVariableVector_VectorType_VectorUnit, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableVectorKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableVectorValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableVector(structType any) OpcuaNodeIdServicesVariableVector {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableVector {
		if sOpcuaNodeIdServicesVariableVector, ok := typ.(OpcuaNodeIdServicesVariableVector); ok {
			return sOpcuaNodeIdServicesVariableVector
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableVector) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableVector) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableVectorParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableVector, error) {
	return OpcuaNodeIdServicesVariableVectorParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableVectorParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableVector, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableVector", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableVector")
	}
	if enum, ok := OpcuaNodeIdServicesVariableVectorByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableVector")
		return OpcuaNodeIdServicesVariableVector(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableVector) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableVector) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableVector", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableVector) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableVector_VectorType_VectorUnit:
		return "VectorType_VectorUnit"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableVector) String() string {
	return e.PLC4XEnumName()
}
