/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTransition is an enum
type OpcuaNodeIdServicesVariableTransition int32

type IOpcuaNodeIdServicesVariableTransition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTransition_TransitionType_TransitionNumber                        OpcuaNodeIdServicesVariableTransition = 2312
	OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Id                              OpcuaNodeIdServicesVariableTransition = 2763
	OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Name                            OpcuaNodeIdServicesVariableTransition = 2764
	OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Number                          OpcuaNodeIdServicesVariableTransition = 2765
	OpcuaNodeIdServicesVariableTransition_TransitionVariableType_TransitionTime                  OpcuaNodeIdServicesVariableTransition = 2766
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition                         OpcuaNodeIdServicesVariableTransition = 2774
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState                          OpcuaNodeIdServicesVariableTransition = 2775
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState                            OpcuaNodeIdServicesVariableTransition = 2776
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventId                            OpcuaNodeIdServicesVariableTransition = 3737
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventType                          OpcuaNodeIdServicesVariableTransition = 3738
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceNode                         OpcuaNodeIdServicesVariableTransition = 3739
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceName                         OpcuaNodeIdServicesVariableTransition = 3740
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Time                               OpcuaNodeIdServicesVariableTransition = 3741
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ReceiveTime                        OpcuaNodeIdServicesVariableTransition = 3742
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_LocalTime                          OpcuaNodeIdServicesVariableTransition = 3743
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Message                            OpcuaNodeIdServicesVariableTransition = 3744
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Severity                           OpcuaNodeIdServicesVariableTransition = 3745
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Id                       OpcuaNodeIdServicesVariableTransition = 3746
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Name                     OpcuaNodeIdServicesVariableTransition = 3747
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Number                   OpcuaNodeIdServicesVariableTransition = 3748
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_EffectiveDisplayName     OpcuaNodeIdServicesVariableTransition = 3749
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Id                         OpcuaNodeIdServicesVariableTransition = 3750
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Name                       OpcuaNodeIdServicesVariableTransition = 3751
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Number                     OpcuaNodeIdServicesVariableTransition = 3752
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_EffectiveDisplayName       OpcuaNodeIdServicesVariableTransition = 3753
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Id                      OpcuaNodeIdServicesVariableTransition = 3754
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Name                    OpcuaNodeIdServicesVariableTransition = 3755
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Number                  OpcuaNodeIdServicesVariableTransition = 3756
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_TransitionTime          OpcuaNodeIdServicesVariableTransition = 3757
	OpcuaNodeIdServicesVariableTransition_TransitionVariableType_EffectiveTransitionTime         OpcuaNodeIdServicesVariableTransition = 11456
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_EffectiveTransitionTime OpcuaNodeIdServicesVariableTransition = 11460
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassId                   OpcuaNodeIdServicesVariableTransition = 31919
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassName                 OpcuaNodeIdServicesVariableTransition = 31920
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassId                OpcuaNodeIdServicesVariableTransition = 31921
	OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassName              OpcuaNodeIdServicesVariableTransition = 31922
)

var OpcuaNodeIdServicesVariableTransitionValues []OpcuaNodeIdServicesVariableTransition

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTransitionValues = []OpcuaNodeIdServicesVariableTransition{
		OpcuaNodeIdServicesVariableTransition_TransitionType_TransitionNumber,
		OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Id,
		OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Name,
		OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Number,
		OpcuaNodeIdServicesVariableTransition_TransitionVariableType_TransitionTime,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventId,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventType,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceNode,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceName,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Time,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ReceiveTime,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_LocalTime,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Message,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Severity,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Id,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Name,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Number,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Id,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Name,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Number,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Id,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Name,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Number,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_TransitionTime,
		OpcuaNodeIdServicesVariableTransition_TransitionVariableType_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassId,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassName,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassName,
	}
}

func OpcuaNodeIdServicesVariableTransitionByValue(value int32) (enum OpcuaNodeIdServicesVariableTransition, ok bool) {
	switch value {
	case 11456:
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_EffectiveTransitionTime, true
	case 11460:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_EffectiveTransitionTime, true
	case 2312:
		return OpcuaNodeIdServicesVariableTransition_TransitionType_TransitionNumber, true
	case 2763:
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Id, true
	case 2764:
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Name, true
	case 2765:
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Number, true
	case 2766:
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_TransitionTime, true
	case 2774:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition, true
	case 2775:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState, true
	case 2776:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState, true
	case 31919:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassId, true
	case 31920:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassName, true
	case 31921:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassId, true
	case 31922:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassName, true
	case 3737:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventId, true
	case 3738:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventType, true
	case 3739:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceNode, true
	case 3740:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceName, true
	case 3741:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Time, true
	case 3742:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ReceiveTime, true
	case 3743:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_LocalTime, true
	case 3744:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Message, true
	case 3745:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Severity, true
	case 3746:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Id, true
	case 3747:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Name, true
	case 3748:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Number, true
	case 3749:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_EffectiveDisplayName, true
	case 3750:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Id, true
	case 3751:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Name, true
	case 3752:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Number, true
	case 3753:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_EffectiveDisplayName, true
	case 3754:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Id, true
	case 3755:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Name, true
	case 3756:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Number, true
	case 3757:
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_TransitionTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTransitionByName(value string) (enum OpcuaNodeIdServicesVariableTransition, ok bool) {
	switch value {
	case "TransitionVariableType_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_EffectiveTransitionTime, true
	case "TransitionEventType_Transition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_EffectiveTransitionTime, true
	case "TransitionType_TransitionNumber":
		return OpcuaNodeIdServicesVariableTransition_TransitionType_TransitionNumber, true
	case "TransitionVariableType_Id":
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Id, true
	case "TransitionVariableType_Name":
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Name, true
	case "TransitionVariableType_Number":
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Number, true
	case "TransitionVariableType_TransitionTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionVariableType_TransitionTime, true
	case "TransitionEventType_Transition":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition, true
	case "TransitionEventType_FromState":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState, true
	case "TransitionEventType_ToState":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState, true
	case "TransitionEventType_ConditionClassId":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassId, true
	case "TransitionEventType_ConditionClassName":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassName, true
	case "TransitionEventType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassId, true
	case "TransitionEventType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassName, true
	case "TransitionEventType_EventId":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventId, true
	case "TransitionEventType_EventType":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventType, true
	case "TransitionEventType_SourceNode":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceNode, true
	case "TransitionEventType_SourceName":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceName, true
	case "TransitionEventType_Time":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Time, true
	case "TransitionEventType_ReceiveTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ReceiveTime, true
	case "TransitionEventType_LocalTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_LocalTime, true
	case "TransitionEventType_Message":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Message, true
	case "TransitionEventType_Severity":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Severity, true
	case "TransitionEventType_FromState_Id":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Id, true
	case "TransitionEventType_FromState_Name":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Name, true
	case "TransitionEventType_FromState_Number":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Number, true
	case "TransitionEventType_FromState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_EffectiveDisplayName, true
	case "TransitionEventType_ToState_Id":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Id, true
	case "TransitionEventType_ToState_Name":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Name, true
	case "TransitionEventType_ToState_Number":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Number, true
	case "TransitionEventType_ToState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_EffectiveDisplayName, true
	case "TransitionEventType_Transition_Id":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Id, true
	case "TransitionEventType_Transition_Name":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Name, true
	case "TransitionEventType_Transition_Number":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Number, true
	case "TransitionEventType_Transition_TransitionTime":
		return OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_TransitionTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTransitionKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTransitionValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTransition(structType any) OpcuaNodeIdServicesVariableTransition {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTransition {
		if sOpcuaNodeIdServicesVariableTransition, ok := typ.(OpcuaNodeIdServicesVariableTransition); ok {
			return sOpcuaNodeIdServicesVariableTransition
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTransition) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTransition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTransitionParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTransition, error) {
	return OpcuaNodeIdServicesVariableTransitionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTransitionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTransition, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTransition", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTransition")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTransitionByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTransition")
		return OpcuaNodeIdServicesVariableTransition(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTransition) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTransition) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTransition", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTransition) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTransition_TransitionVariableType_EffectiveTransitionTime:
		return "TransitionVariableType_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_EffectiveTransitionTime:
		return "TransitionEventType_Transition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableTransition_TransitionType_TransitionNumber:
		return "TransitionType_TransitionNumber"
	case OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Id:
		return "TransitionVariableType_Id"
	case OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Name:
		return "TransitionVariableType_Name"
	case OpcuaNodeIdServicesVariableTransition_TransitionVariableType_Number:
		return "TransitionVariableType_Number"
	case OpcuaNodeIdServicesVariableTransition_TransitionVariableType_TransitionTime:
		return "TransitionVariableType_TransitionTime"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition:
		return "TransitionEventType_Transition"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState:
		return "TransitionEventType_FromState"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState:
		return "TransitionEventType_ToState"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassId:
		return "TransitionEventType_ConditionClassId"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionClassName:
		return "TransitionEventType_ConditionClassName"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassId:
		return "TransitionEventType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ConditionSubClassName:
		return "TransitionEventType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventId:
		return "TransitionEventType_EventId"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_EventType:
		return "TransitionEventType_EventType"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceNode:
		return "TransitionEventType_SourceNode"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_SourceName:
		return "TransitionEventType_SourceName"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Time:
		return "TransitionEventType_Time"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ReceiveTime:
		return "TransitionEventType_ReceiveTime"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_LocalTime:
		return "TransitionEventType_LocalTime"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Message:
		return "TransitionEventType_Message"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Severity:
		return "TransitionEventType_Severity"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Id:
		return "TransitionEventType_FromState_Id"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Name:
		return "TransitionEventType_FromState_Name"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_Number:
		return "TransitionEventType_FromState_Number"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_FromState_EffectiveDisplayName:
		return "TransitionEventType_FromState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Id:
		return "TransitionEventType_ToState_Id"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Name:
		return "TransitionEventType_ToState_Name"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_Number:
		return "TransitionEventType_ToState_Number"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_ToState_EffectiveDisplayName:
		return "TransitionEventType_ToState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Id:
		return "TransitionEventType_Transition_Id"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Name:
		return "TransitionEventType_Transition_Name"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_Number:
		return "TransitionEventType_Transition_Number"
	case OpcuaNodeIdServicesVariableTransition_TransitionEventType_Transition_TransitionTime:
		return "TransitionEventType_Transition_TransitionTime"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTransition) String() string {
	return e.PLC4XEnumName()
}
