/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePublished is an enum
type OpcuaNodeIdServicesVariablePublished int32

type IOpcuaNodeIdServicesVariablePublished interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion                                                                            OpcuaNodeIdServicesVariablePublished = 14519
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ConfigurationVersion                                                                          OpcuaNodeIdServicesVariablePublished = 14544
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData                                                                                 OpcuaNodeIdServicesVariablePublished = 14548
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments                                                                   OpcuaNodeIdServicesVariablePublished = 14556
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments                                                                  OpcuaNodeIdServicesVariablePublished = 14557
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments                                                                OpcuaNodeIdServicesVariablePublished = 14559
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments                                                               OpcuaNodeIdServicesVariablePublished = 14560
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments                                                              OpcuaNodeIdServicesVariablePublished = 14565
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments                                                             OpcuaNodeIdServicesVariablePublished = 14566
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments                                                           OpcuaNodeIdServicesVariablePublished = 14568
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments                                                          OpcuaNodeIdServicesVariablePublished = 14569
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ConfigurationVersion                                                                             OpcuaNodeIdServicesVariablePublished = 14582
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier                                                                              OpcuaNodeIdServicesVariablePublished = 14586
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields                                                                                   OpcuaNodeIdServicesVariablePublished = 14587
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter                                                                                           OpcuaNodeIdServicesVariablePublished = 14588
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments                                                              OpcuaNodeIdServicesVariablePublished = 15053
	OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments                                                     OpcuaNodeIdServicesVariablePublished = 15055
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State                                                      OpcuaNodeIdServicesVariablePublished = 15224
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData                                                                                 OpcuaNodeIdServicesVariablePublished = 15229
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State                                                    OpcuaNodeIdServicesVariablePublished = 15232
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetMetaData                                                                               OpcuaNodeIdServicesVariablePublished = 15237
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Status_State                                                       OpcuaNodeIdServicesVariablePublished = 15240
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetMetaData                                                                                  OpcuaNodeIdServicesVariablePublished = 15245
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments                                                OpcuaNodeIdServicesVariablePublished = 15483
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments                                               OpcuaNodeIdServicesVariablePublished = 15484
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments                                             OpcuaNodeIdServicesVariablePublished = 15486
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments                                              OpcuaNodeIdServicesVariablePublished = 15505
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments                                             OpcuaNodeIdServicesVariablePublished = 15506
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments                                           OpcuaNodeIdServicesVariablePublished = 15508
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments                                                 OpcuaNodeIdServicesVariablePublished = 15513
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments                                                OpcuaNodeIdServicesVariablePublished = 15514
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments                                              OpcuaNodeIdServicesVariablePublished = 15516
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments                                                             OpcuaNodeIdServicesVariablePublished = 15517
	OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments                                                    OpcuaNodeIdServicesVariablePublished = 15518
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId                                                   OpcuaNodeIdServicesVariablePublished = 16720
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                           OpcuaNodeIdServicesVariablePublished = 16721
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount                                                     OpcuaNodeIdServicesVariablePublished = 16731
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId                                                                                  OpcuaNodeIdServicesVariablePublished = 16759
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId                                                 OpcuaNodeIdServicesVariablePublished = 16760
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                         OpcuaNodeIdServicesVariablePublished = 16761
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount                                                   OpcuaNodeIdServicesVariablePublished = 16771
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetClassId                                                                                OpcuaNodeIdServicesVariablePublished = 16800
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId                                                    OpcuaNodeIdServicesVariablePublished = 16801
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                            OpcuaNodeIdServicesVariablePublished = 16802
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount                                                      OpcuaNodeIdServicesVariablePublished = 16812
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetClassId                                                                                   OpcuaNodeIdServicesVariablePublished = 16841
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties                                           OpcuaNodeIdServicesVariablePublished = 17482
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties                                         OpcuaNodeIdServicesVariablePublished = 17483
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties                                            OpcuaNodeIdServicesVariablePublished = 17484
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePublished = 18872
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation                                      OpcuaNodeIdServicesVariablePublished = 18873
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active                               OpcuaNodeIdServicesVariablePublished = 18874
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification                       OpcuaNodeIdServicesVariablePublished = 18875
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                     OpcuaNodeIdServicesVariablePublished = 18876
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                      OpcuaNodeIdServicesVariablePublished = 18877
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError                                            OpcuaNodeIdServicesVariablePublished = 18878
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active                                     OpcuaNodeIdServicesVariablePublished = 18879
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification                             OpcuaNodeIdServicesVariablePublished = 18880
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                           OpcuaNodeIdServicesVariablePublished = 18881
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange                            OpcuaNodeIdServicesVariablePublished = 18882
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError                                              OpcuaNodeIdServicesVariablePublished = 18884
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError                                   OpcuaNodeIdServicesVariablePublished = 18886
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active                            OpcuaNodeIdServicesVariablePublished = 18887
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification                    OpcuaNodeIdServicesVariablePublished = 18888
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                  OpcuaNodeIdServicesVariablePublished = 18889
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                   OpcuaNodeIdServicesVariablePublished = 18890
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                     OpcuaNodeIdServicesVariablePublished = 18891
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active              OpcuaNodeIdServicesVariablePublished = 18892
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification      OpcuaNodeIdServicesVariablePublished = 18893
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel    OpcuaNodeIdServicesVariablePublished = 18894
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange     OpcuaNodeIdServicesVariablePublished = 18895
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent                     OpcuaNodeIdServicesVariablePublished = 18896
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active              OpcuaNodeIdServicesVariablePublished = 18897
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification      OpcuaNodeIdServicesVariablePublished = 18898
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel    OpcuaNodeIdServicesVariablePublished = 18899
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange     OpcuaNodeIdServicesVariablePublished = 18900
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError                    OpcuaNodeIdServicesVariablePublished = 18901
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active             OpcuaNodeIdServicesVariablePublished = 18902
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification     OpcuaNodeIdServicesVariablePublished = 18903
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel   OpcuaNodeIdServicesVariablePublished = 18904
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange    OpcuaNodeIdServicesVariablePublished = 18905
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent                          OpcuaNodeIdServicesVariablePublished = 18906
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                   OpcuaNodeIdServicesVariablePublished = 18907
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification           OpcuaNodeIdServicesVariablePublished = 18908
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel         OpcuaNodeIdServicesVariablePublished = 18909
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange          OpcuaNodeIdServicesVariablePublished = 18910
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                        OpcuaNodeIdServicesVariablePublished = 18911
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active                 OpcuaNodeIdServicesVariablePublished = 18912
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification         OpcuaNodeIdServicesVariablePublished = 18913
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel       OpcuaNodeIdServicesVariablePublished = 18914
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange        OpcuaNodeIdServicesVariablePublished = 18915
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                        OpcuaNodeIdServicesVariablePublished = 18917
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active                 OpcuaNodeIdServicesVariablePublished = 18918
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification         OpcuaNodeIdServicesVariablePublished = 18919
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel       OpcuaNodeIdServicesVariablePublished = 18920
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange        OpcuaNodeIdServicesVariablePublished = 18921
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                      OpcuaNodeIdServicesVariablePublished = 18922
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 18923
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode                                 OpcuaNodeIdServicesVariablePublished = 18924
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel                OpcuaNodeIdServicesVariablePublished = 18925
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion                               OpcuaNodeIdServicesVariablePublished = 18926
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel              OpcuaNodeIdServicesVariablePublished = 18927
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion                               OpcuaNodeIdServicesVariablePublished = 18928
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel              OpcuaNodeIdServicesVariablePublished = 18929
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePublished = 18931
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation                                    OpcuaNodeIdServicesVariablePublished = 18932
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active                             OpcuaNodeIdServicesVariablePublished = 18933
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification                     OpcuaNodeIdServicesVariablePublished = 18934
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                   OpcuaNodeIdServicesVariablePublished = 18935
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                    OpcuaNodeIdServicesVariablePublished = 18936
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError                                          OpcuaNodeIdServicesVariablePublished = 18937
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active                                   OpcuaNodeIdServicesVariablePublished = 18938
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification                           OpcuaNodeIdServicesVariablePublished = 18939
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                         OpcuaNodeIdServicesVariablePublished = 18940
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange                          OpcuaNodeIdServicesVariablePublished = 18941
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError                                            OpcuaNodeIdServicesVariablePublished = 18943
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError                                 OpcuaNodeIdServicesVariablePublished = 18945
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active                          OpcuaNodeIdServicesVariablePublished = 18946
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification                  OpcuaNodeIdServicesVariablePublished = 18947
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                OpcuaNodeIdServicesVariablePublished = 18948
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                 OpcuaNodeIdServicesVariablePublished = 18949
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                   OpcuaNodeIdServicesVariablePublished = 18950
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active            OpcuaNodeIdServicesVariablePublished = 18951
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification    OpcuaNodeIdServicesVariablePublished = 18952
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublished = 18953
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange   OpcuaNodeIdServicesVariablePublished = 18954
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent                   OpcuaNodeIdServicesVariablePublished = 18955
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active            OpcuaNodeIdServicesVariablePublished = 18956
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification    OpcuaNodeIdServicesVariablePublished = 18957
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublished = 18958
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange   OpcuaNodeIdServicesVariablePublished = 18959
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError                  OpcuaNodeIdServicesVariablePublished = 18960
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active           OpcuaNodeIdServicesVariablePublished = 18961
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification   OpcuaNodeIdServicesVariablePublished = 18962
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel OpcuaNodeIdServicesVariablePublished = 18963
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange  OpcuaNodeIdServicesVariablePublished = 18964
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent                        OpcuaNodeIdServicesVariablePublished = 18965
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                 OpcuaNodeIdServicesVariablePublished = 18966
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification         OpcuaNodeIdServicesVariablePublished = 18967
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariablePublished = 18968
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange        OpcuaNodeIdServicesVariablePublished = 18969
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                      OpcuaNodeIdServicesVariablePublished = 18970
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active               OpcuaNodeIdServicesVariablePublished = 18971
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification       OpcuaNodeIdServicesVariablePublished = 18972
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 18973
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 18974
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                      OpcuaNodeIdServicesVariablePublished = 18976
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active               OpcuaNodeIdServicesVariablePublished = 18977
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification       OpcuaNodeIdServicesVariablePublished = 18978
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 18979
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 18980
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                    OpcuaNodeIdServicesVariablePublished = 18981
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel   OpcuaNodeIdServicesVariablePublished = 18982
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode                               OpcuaNodeIdServicesVariablePublished = 18983
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel              OpcuaNodeIdServicesVariablePublished = 18984
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion                             OpcuaNodeIdServicesVariablePublished = 18985
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariablePublished = 18986
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion                             OpcuaNodeIdServicesVariablePublished = 18987
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariablePublished = 18988
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel                                       OpcuaNodeIdServicesVariablePublished = 18990
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation                                       OpcuaNodeIdServicesVariablePublished = 18991
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active                                OpcuaNodeIdServicesVariablePublished = 18992
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification                        OpcuaNodeIdServicesVariablePublished = 18993
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                      OpcuaNodeIdServicesVariablePublished = 18994
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                       OpcuaNodeIdServicesVariablePublished = 18995
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError                                             OpcuaNodeIdServicesVariablePublished = 18996
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active                                      OpcuaNodeIdServicesVariablePublished = 18997
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification                              OpcuaNodeIdServicesVariablePublished = 18998
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                            OpcuaNodeIdServicesVariablePublished = 18999
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange                             OpcuaNodeIdServicesVariablePublished = 19000
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError                                               OpcuaNodeIdServicesVariablePublished = 19002
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError                                    OpcuaNodeIdServicesVariablePublished = 19004
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active                             OpcuaNodeIdServicesVariablePublished = 19005
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification                     OpcuaNodeIdServicesVariablePublished = 19006
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                   OpcuaNodeIdServicesVariablePublished = 19007
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                    OpcuaNodeIdServicesVariablePublished = 19008
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                      OpcuaNodeIdServicesVariablePublished = 19009
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active               OpcuaNodeIdServicesVariablePublished = 19010
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification       OpcuaNodeIdServicesVariablePublished = 19011
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 19012
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 19013
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent                      OpcuaNodeIdServicesVariablePublished = 19014
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active               OpcuaNodeIdServicesVariablePublished = 19015
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification       OpcuaNodeIdServicesVariablePublished = 19016
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 19017
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 19018
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError                     OpcuaNodeIdServicesVariablePublished = 19019
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active              OpcuaNodeIdServicesVariablePublished = 19020
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification      OpcuaNodeIdServicesVariablePublished = 19021
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel    OpcuaNodeIdServicesVariablePublished = 19022
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange     OpcuaNodeIdServicesVariablePublished = 19023
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent                           OpcuaNodeIdServicesVariablePublished = 19024
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                    OpcuaNodeIdServicesVariablePublished = 19025
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification            OpcuaNodeIdServicesVariablePublished = 19026
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel          OpcuaNodeIdServicesVariablePublished = 19027
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange           OpcuaNodeIdServicesVariablePublished = 19028
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                         OpcuaNodeIdServicesVariablePublished = 19029
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active                  OpcuaNodeIdServicesVariablePublished = 19030
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification          OpcuaNodeIdServicesVariablePublished = 19031
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel        OpcuaNodeIdServicesVariablePublished = 19032
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange         OpcuaNodeIdServicesVariablePublished = 19033
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                         OpcuaNodeIdServicesVariablePublished = 19035
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active                  OpcuaNodeIdServicesVariablePublished = 19036
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification          OpcuaNodeIdServicesVariablePublished = 19037
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel        OpcuaNodeIdServicesVariablePublished = 19038
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange         OpcuaNodeIdServicesVariablePublished = 19039
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                       OpcuaNodeIdServicesVariablePublished = 19040
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel      OpcuaNodeIdServicesVariablePublished = 19041
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode                                  OpcuaNodeIdServicesVariablePublished = 19042
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel                 OpcuaNodeIdServicesVariablePublished = 19043
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion                                OpcuaNodeIdServicesVariablePublished = 19044
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel               OpcuaNodeIdServicesVariablePublished = 19045
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion                                OpcuaNodeIdServicesVariablePublished = 19046
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel               OpcuaNodeIdServicesVariablePublished = 19047
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet                                                                                   OpcuaNodeIdServicesVariablePublished = 25521
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_CyclicDataSet                                                                                 OpcuaNodeIdServicesVariablePublished = 25522
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_CyclicDataSet                                                                                    OpcuaNodeIdServicesVariablePublished = 25523
)

var OpcuaNodeIdServicesVariablePublishedValues []OpcuaNodeIdServicesVariablePublished

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePublishedValues = []OpcuaNodeIdServicesVariablePublished{
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetMetaData,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetMetaData,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetClassId,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetClassId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_CyclicDataSet,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_CyclicDataSet,
	}
}

func OpcuaNodeIdServicesVariablePublishedByValue(value int32) (enum OpcuaNodeIdServicesVariablePublished, ok bool) {
	switch value {
	case 14519:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion, true
	case 14544:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ConfigurationVersion, true
	case 14548:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData, true
	case 14556:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments, true
	case 14557:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments, true
	case 14559:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments, true
	case 14560:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments, true
	case 14565:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments, true
	case 14566:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments, true
	case 14568:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments, true
	case 14569:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments, true
	case 14582:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ConfigurationVersion, true
	case 14586:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier, true
	case 14587:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields, true
	case 14588:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter, true
	case 15053:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments, true
	case 15055:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments, true
	case 15224:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State, true
	case 15229:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData, true
	case 15232:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State, true
	case 15237:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetMetaData, true
	case 15240:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Status_State, true
	case 15245:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetMetaData, true
	case 15483:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments, true
	case 15484:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments, true
	case 15486:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case 15505:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments, true
	case 15506:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments, true
	case 15508:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case 15513:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments, true
	case 15514:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments, true
	case 15516:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case 15517:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments, true
	case 15518:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments, true
	case 16720:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case 16721:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case 16731:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case 16759:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId, true
	case 16760:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case 16761:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case 16771:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case 16800:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetClassId, true
	case 16801:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case 16802:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case 16812:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case 16841:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetClassId, true
	case 17482:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case 17483:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case 17484:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case 18872:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18873:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case 18874:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18875:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18876:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18877:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18878:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case 18879:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case 18880:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18881:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18882:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 18884:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case 18886:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case 18887:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 18888:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 18889:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18890:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18891:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 18892:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18893:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18894:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18895:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18896:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 18897:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18898:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18899:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18900:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18901:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 18902:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18903:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18904:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18905:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18906:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 18907:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18908:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18909:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18910:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18911:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 18912:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18913:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18914:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18915:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18917:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 18918:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 18919:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 18920:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 18921:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 18922:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 18923:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 18924:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 18925:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 18926:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 18927:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 18928:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 18929:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 18931:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18932:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case 18933:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18934:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18935:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18936:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18937:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case 18938:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case 18939:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18940:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18941:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 18943:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case 18945:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case 18946:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 18947:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 18948:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18949:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18950:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 18951:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18952:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18953:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18954:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18955:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 18956:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18957:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18958:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18959:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18960:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 18961:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18962:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18963:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18964:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18965:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 18966:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18967:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18968:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18969:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18970:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 18971:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18972:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18973:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18974:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18976:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 18977:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 18978:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 18979:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 18980:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 18981:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 18982:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 18983:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 18984:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 18985:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 18986:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 18987:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 18988:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 18990:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18991:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case 18992:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18993:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18994:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18995:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18996:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case 18997:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case 18998:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18999:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 19000:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 19002:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case 19004:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case 19005:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 19006:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 19007:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 19008:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 19009:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 19010:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 19011:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 19012:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 19013:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 19014:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 19015:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 19016:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 19017:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 19018:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 19019:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 19020:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 19021:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 19022:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 19023:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 19024:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 19025:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 19026:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 19027:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 19028:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 19029:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 19030:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 19031:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 19032:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 19033:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 19035:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 19036:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 19037:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 19038:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 19039:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 19040:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 19041:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 19042:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 19043:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 19044:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 19045:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 19046:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 19047:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 25521:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet, true
	case 25522:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_CyclicDataSet, true
	case 25523:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_CyclicDataSet, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishedByName(value string) (enum OpcuaNodeIdServicesVariablePublished, ok bool) {
	switch value {
	case "PublishedDataSetType_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion, true
	case "PublishedDataItemsType_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ConfigurationVersion, true
	case "PublishedDataItemsType_PublishedData":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData, true
	case "PublishedDataItemsType_AddVariables_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments, true
	case "PublishedDataItemsType_AddVariables_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments, true
	case "PublishedDataItemsType_RemoveVariables_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments, true
	case "PublishedDataItemsType_RemoveVariables_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments, true
	case "PublishedDataItemsAddVariablesMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments, true
	case "PublishedDataItemsAddVariablesMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments, true
	case "PublishedDataItemsRemoveVariablesMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments, true
	case "PublishedDataItemsRemoveVariablesMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments, true
	case "PublishedEventsType_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ConfigurationVersion, true
	case "PublishedEventsType_PubSubEventNotifier":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier, true
	case "PublishedEventsType_SelectedFields":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields, true
	case "PublishedEventsType_Filter":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter, true
	case "PublishedEventsType_ModifyFieldSelection_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments, true
	case "PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State, true
	case "PublishedDataSetType_DataSetMetaData":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State, true
	case "PublishedDataItemsType_DataSetMetaData":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetMetaData, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Status_State, true
	case "PublishedEventsType_DataSetMetaData":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetMetaData, true
	case "PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments, true
	case "PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments, true
	case "PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case "PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments, true
	case "PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments, true
	case "PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case "PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments, true
	case "PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments, true
	case "PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case "PublishedEventsType_ModifyFieldSelection_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments, true
	case "PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case "PublishedDataSetType_DataSetClassId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case "PublishedDataItemsType_DataSetClassId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetClassId, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case "PublishedEventsType_DataSetClassId":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetClassId, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PublishedDataSetType_CyclicDataSet":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet, true
	case "PublishedDataItemsType_CyclicDataSet":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_CyclicDataSet, true
	case "PublishedEventsType_CyclicDataSet":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_CyclicDataSet, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishedKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePublishedValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePublished(structType any) OpcuaNodeIdServicesVariablePublished {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePublished {
		if sOpcuaNodeIdServicesVariablePublished, ok := typ.(OpcuaNodeIdServicesVariablePublished); ok {
			return sOpcuaNodeIdServicesVariablePublished
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePublished) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePublished) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePublishedParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePublished, error) {
	return OpcuaNodeIdServicesVariablePublishedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePublishedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePublished, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePublished", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePublished")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePublishedByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePublished")
		return OpcuaNodeIdServicesVariablePublished(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePublished) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePublished) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePublished", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePublished) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion:
		return "PublishedDataSetType_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ConfigurationVersion:
		return "PublishedDataItemsType_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData:
		return "PublishedDataItemsType_PublishedData"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments:
		return "PublishedDataItemsType_AddVariables_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments:
		return "PublishedDataItemsType_AddVariables_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments:
		return "PublishedDataItemsType_RemoveVariables_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments:
		return "PublishedDataItemsType_RemoveVariables_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments:
		return "PublishedDataItemsAddVariablesMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments:
		return "PublishedDataItemsAddVariablesMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments:
		return "PublishedDataItemsRemoveVariablesMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments:
		return "PublishedDataItemsRemoveVariablesMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ConfigurationVersion:
		return "PublishedEventsType_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier:
		return "PublishedEventsType_PubSubEventNotifier"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields:
		return "PublishedEventsType_SelectedFields"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter:
		return "PublishedEventsType_Filter"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments:
		return "PublishedEventsType_ModifyFieldSelection_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments:
		return "PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData:
		return "PublishedDataSetType_DataSetMetaData"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetMetaData:
		return "PublishedDataItemsType_DataSetMetaData"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Status_State:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetMetaData:
		return "PublishedEventsType_DataSetMetaData"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments:
		return "PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments:
		return "PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments:
		return "PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments:
		return "PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments:
		return "PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments:
		return "PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments:
		return "PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments:
		return "PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments:
		return "PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments:
		return "PublishedEventsType_ModifyFieldSelection_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments:
		return "PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId:
		return "PublishedDataSetType_DataSetClassId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetClassId:
		return "PublishedDataItemsType_DataSetClassId"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId:
		return "PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask:
		return "PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount:
		return "PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetClassId:
		return "PublishedEventsType_DataSetClassId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties:
		return "PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet:
		return "PublishedDataSetType_CyclicDataSet"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_CyclicDataSet:
		return "PublishedDataItemsType_CyclicDataSet"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_CyclicDataSet:
		return "PublishedEventsType_CyclicDataSet"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePublished) String() string {
	return e.PLC4XEnumName()
}
