/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePublish is an enum
type OpcuaNodeIdServicesVariablePublish int32

type IOpcuaNodeIdServicesVariablePublish interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_PublisherId                                                     OpcuaNodeIdServicesVariablePublish = 14418
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Status_State                                                    OpcuaNodeIdServicesVariablePublish = 14420
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments                                      OpcuaNodeIdServicesVariablePublish = 14425
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_RemoveConnection_InputArguments                                                            OpcuaNodeIdServicesVariablePublish = 14433
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments                                     OpcuaNodeIdServicesVariablePublish = 14436
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments                                    OpcuaNodeIdServicesVariablePublish = 14437
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments                                        OpcuaNodeIdServicesVariablePublish = 14439
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments                                       OpcuaNodeIdServicesVariablePublish = 14440
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments                                    OpcuaNodeIdServicesVariablePublish = 14442
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_InputArguments                                                             OpcuaNodeIdServicesVariablePublish = 15213
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_OutputArguments                                                            OpcuaNodeIdServicesVariablePublish = 15214
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_InputArguments                                                                 OpcuaNodeIdServicesVariablePublish = 15216
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_OutputArguments                                                                OpcuaNodeIdServicesVariablePublish = 15217
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_InputArguments                                                            OpcuaNodeIdServicesVariablePublish = 15432
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_OutputArguments                                                           OpcuaNodeIdServicesVariablePublish = 15433
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments                                             OpcuaNodeIdServicesVariablePublish = 15436
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments                                            OpcuaNodeIdServicesVariablePublish = 15437
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 15439
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_InputArguments                                                                OpcuaNodeIdServicesVariablePublish = 15441
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_OutputArguments                                                               OpcuaNodeIdServicesVariablePublish = 15442
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments                                                 OpcuaNodeIdServicesVariablePublish = 15445
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments                                                OpcuaNodeIdServicesVariablePublish = 15446
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments                                              OpcuaNodeIdServicesVariablePublish = 15448
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface                                        OpcuaNodeIdServicesVariablePublish = 15533
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_PublisherId                                                         OpcuaNodeIdServicesVariablePublish = 15791
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri                                                 OpcuaNodeIdServicesVariablePublish = 15792
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Status_State                                                                               OpcuaNodeIdServicesVariablePublish = 15845
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections                                      OpcuaNodeIdServicesVariablePublish = 15848
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions                           OpcuaNodeIdServicesVariablePublish = 15849
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList                                  OpcuaNodeIdServicesVariablePublish = 15850
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface                                            OpcuaNodeIdServicesVariablePublish = 15863
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Status_State                                                        OpcuaNodeIdServicesVariablePublish = 15892
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel                                        OpcuaNodeIdServicesVariablePublish = 15938
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation                                        OpcuaNodeIdServicesVariablePublish = 15939
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active                                 OpcuaNodeIdServicesVariablePublish = 15989
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification                         OpcuaNodeIdServicesVariablePublish = 15994
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                       OpcuaNodeIdServicesVariablePublish = 16013
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                        OpcuaNodeIdServicesVariablePublish = 16020
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError                                              OpcuaNodeIdServicesVariablePublish = 16059
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active                                       OpcuaNodeIdServicesVariablePublish = 16060
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification                               OpcuaNodeIdServicesVariablePublish = 16061
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                             OpcuaNodeIdServicesVariablePublish = 16074
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange                              OpcuaNodeIdServicesVariablePublish = 16075
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError                                                OpcuaNodeIdServicesVariablePublish = 16101
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError                                     OpcuaNodeIdServicesVariablePublish = 16103
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active                              OpcuaNodeIdServicesVariablePublish = 16122
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification                      OpcuaNodeIdServicesVariablePublish = 16123
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                    OpcuaNodeIdServicesVariablePublish = 16124
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                     OpcuaNodeIdServicesVariablePublish = 16160
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                       OpcuaNodeIdServicesVariablePublish = 16283
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active                OpcuaNodeIdServicesVariablePublish = 16322
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification        OpcuaNodeIdServicesVariablePublish = 16523
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments                                   OpcuaNodeIdServicesVariablePublish = 16558
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments                                  OpcuaNodeIdServicesVariablePublish = 16559
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments                                   OpcuaNodeIdServicesVariablePublish = 16561
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments                                  OpcuaNodeIdServicesVariablePublish = 16571
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_InputArguments                                                               OpcuaNodeIdServicesVariablePublish = 16599
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_OutputArguments                                                              OpcuaNodeIdServicesVariablePublish = 16600
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments                             OpcuaNodeIdServicesVariablePublish = 16611
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments                            OpcuaNodeIdServicesVariablePublish = 16638
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments                                OpcuaNodeIdServicesVariablePublish = 16640
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments                               OpcuaNodeIdServicesVariablePublish = 16641
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 16678
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments                                         OpcuaNodeIdServicesVariablePublish = 16679
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments                                       OpcuaNodeIdServicesVariablePublish = 16681
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri                                             OpcuaNodeIdServicesVariablePublish = 17292
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList                              OpcuaNodeIdServicesVariablePublish = 17295
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SetSecurityKeys_InputArguments                                                             OpcuaNodeIdServicesVariablePublish = 17297
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel      OpcuaNodeIdServicesVariablePublish = 17300
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange       OpcuaNodeIdServicesVariablePublish = 17303
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent                       OpcuaNodeIdServicesVariablePublish = 17304
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active                OpcuaNodeIdServicesVariablePublish = 17305
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification        OpcuaNodeIdServicesVariablePublish = 17320
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel      OpcuaNodeIdServicesVariablePublish = 17335
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange       OpcuaNodeIdServicesVariablePublish = 17336
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError                      OpcuaNodeIdServicesVariablePublish = 17337
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active               OpcuaNodeIdServicesVariablePublish = 17338
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification       OpcuaNodeIdServicesVariablePublish = 17339
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublish = 17340
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange      OpcuaNodeIdServicesVariablePublish = 17341
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent                            OpcuaNodeIdServicesVariablePublish = 17342
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                     OpcuaNodeIdServicesVariablePublish = 17343
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification             OpcuaNodeIdServicesVariablePublish = 17344
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel           OpcuaNodeIdServicesVariablePublish = 17345
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange            OpcuaNodeIdServicesVariablePublish = 17346
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                          OpcuaNodeIdServicesVariablePublish = 17347
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active                   OpcuaNodeIdServicesVariablePublish = 17348
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification           OpcuaNodeIdServicesVariablePublish = 17349
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel         OpcuaNodeIdServicesVariablePublish = 17350
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange          OpcuaNodeIdServicesVariablePublish = 17351
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress                              OpcuaNodeIdServicesVariablePublish = 17353
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel             OpcuaNodeIdServicesVariablePublish = 17354
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments                                       OpcuaNodeIdServicesVariablePublish = 17357
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments                                      OpcuaNodeIdServicesVariablePublish = 17358
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments                                       OpcuaNodeIdServicesVariablePublish = 17360
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments                                      OpcuaNodeIdServicesVariablePublish = 17361
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 17363
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SetSecurityKeys_InputArguments                                                                 OpcuaNodeIdServicesVariablePublish = 17365
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_InputArguments                                                                   OpcuaNodeIdServicesVariablePublish = 17367
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_OutputArguments                                                                  OpcuaNodeIdServicesVariablePublish = 17368
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_RemoveConnection_InputArguments                                                                OpcuaNodeIdServicesVariablePublish = 17370
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments                                         OpcuaNodeIdServicesVariablePublish = 17373
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments                                        OpcuaNodeIdServicesVariablePublish = 17374
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments                                            OpcuaNodeIdServicesVariablePublish = 17376
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments                                           OpcuaNodeIdServicesVariablePublish = 17377
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments                                 OpcuaNodeIdServicesVariablePublish = 17379
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments                                OpcuaNodeIdServicesVariablePublish = 17380
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments                                    OpcuaNodeIdServicesVariablePublish = 17382
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments                                   OpcuaNodeIdServicesVariablePublish = 17383
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments                                        OpcuaNodeIdServicesVariablePublish = 17385
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments                                              OpcuaNodeIdServicesVariablePublish = 17401
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments                                             OpcuaNodeIdServicesVariablePublish = 17402
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments                                           OpcuaNodeIdServicesVariablePublish = 17404
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Status_State                                                                                   OpcuaNodeIdServicesVariablePublish = 17406
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_DiagnosticsLevel                                                                   OpcuaNodeIdServicesVariablePublish = 17410
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation                                                                   OpcuaNodeIdServicesVariablePublish = 17411
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Active                                                            OpcuaNodeIdServicesVariablePublish = 17412
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Classification                                                    OpcuaNodeIdServicesVariablePublish = 17413
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel                                                  OpcuaNodeIdServicesVariablePublish = 17414
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange                                                   OpcuaNodeIdServicesVariablePublish = 17415
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError                                                                         OpcuaNodeIdServicesVariablePublish = 17416
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Active                                                                  OpcuaNodeIdServicesVariablePublish = 17417
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Classification                                                          OpcuaNodeIdServicesVariablePublish = 17418
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel                                                        OpcuaNodeIdServicesVariablePublish = 17419
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_TimeFirstChange                                                         OpcuaNodeIdServicesVariablePublish = 17420
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_SubError                                                                           OpcuaNodeIdServicesVariablePublish = 17422
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError                                                                OpcuaNodeIdServicesVariablePublish = 17424
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Active                                                         OpcuaNodeIdServicesVariablePublish = 17425
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Classification                                                 OpcuaNodeIdServicesVariablePublish = 17426
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel                                               OpcuaNodeIdServicesVariablePublish = 17429
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange                                                OpcuaNodeIdServicesVariablePublish = 17430
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod                                                  OpcuaNodeIdServicesVariablePublish = 17431
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active                                           OpcuaNodeIdServicesVariablePublish = 17432
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification                                   OpcuaNodeIdServicesVariablePublish = 17433
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePublish = 17434
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange                                  OpcuaNodeIdServicesVariablePublish = 17435
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent                                                  OpcuaNodeIdServicesVariablePublish = 17436
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active                                           OpcuaNodeIdServicesVariablePublish = 17437
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification                                   OpcuaNodeIdServicesVariablePublish = 17438
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel                                 OpcuaNodeIdServicesVariablePublish = 17439
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange                                  OpcuaNodeIdServicesVariablePublish = 17440
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError                                                 OpcuaNodeIdServicesVariablePublish = 17441
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active                                          OpcuaNodeIdServicesVariablePublish = 17442
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification                                  OpcuaNodeIdServicesVariablePublish = 17443
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePublish = 17444
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange                                 OpcuaNodeIdServicesVariablePublish = 17445
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent                                                       OpcuaNodeIdServicesVariablePublish = 17446
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active                                                OpcuaNodeIdServicesVariablePublish = 17447
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification                                        OpcuaNodeIdServicesVariablePublish = 17448
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel                                      OpcuaNodeIdServicesVariablePublish = 17449
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange                                       OpcuaNodeIdServicesVariablePublish = 17450
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod                                                     OpcuaNodeIdServicesVariablePublish = 17451
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active                                              OpcuaNodeIdServicesVariablePublish = 17452
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification                                      OpcuaNodeIdServicesVariablePublish = 17453
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePublish = 17454
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange                                     OpcuaNodeIdServicesVariablePublish = 17455
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters                                                OpcuaNodeIdServicesVariablePublish = 17458
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel                               OpcuaNodeIdServicesVariablePublish = 17459
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders                                                OpcuaNodeIdServicesVariablePublish = 17460
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel                               OpcuaNodeIdServicesVariablePublish = 17461
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters                                               OpcuaNodeIdServicesVariablePublish = 17462
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel                              OpcuaNodeIdServicesVariablePublish = 17463
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders                                               OpcuaNodeIdServicesVariablePublish = 17464
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel                              OpcuaNodeIdServicesVariablePublish = 17466
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties                                            OpcuaNodeIdServicesVariablePublish = 17478
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SupportedTransportProfiles                                                                 OpcuaNodeIdServicesVariablePublish = 17479
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties                                                OpcuaNodeIdServicesVariablePublish = 17480
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SupportedTransportProfiles                                                                     OpcuaNodeIdServicesVariablePublish = 17481
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections                             OpcuaNodeIdServicesVariablePublish = 17503
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions                  OpcuaNodeIdServicesVariablePublish = 17504
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList                         OpcuaNodeIdServicesVariablePublish = 17505
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections                                 OpcuaNodeIdServicesVariablePublish = 17506
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions                      OpcuaNodeIdServicesVariablePublish = 17509
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList                             OpcuaNodeIdServicesVariablePublish = 17510
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections                                  OpcuaNodeIdServicesVariablePublish = 17706
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions                       OpcuaNodeIdServicesVariablePublish = 17707
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePublish = 18668
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation                                    OpcuaNodeIdServicesVariablePublish = 18669
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active                             OpcuaNodeIdServicesVariablePublish = 18670
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification                     OpcuaNodeIdServicesVariablePublish = 18671
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                   OpcuaNodeIdServicesVariablePublish = 18672
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                    OpcuaNodeIdServicesVariablePublish = 18673
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError                                          OpcuaNodeIdServicesVariablePublish = 18674
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active                                   OpcuaNodeIdServicesVariablePublish = 18675
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification                           OpcuaNodeIdServicesVariablePublish = 18676
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                         OpcuaNodeIdServicesVariablePublish = 18677
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange                          OpcuaNodeIdServicesVariablePublish = 18678
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError                                            OpcuaNodeIdServicesVariablePublish = 18680
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError                                 OpcuaNodeIdServicesVariablePublish = 18682
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active                          OpcuaNodeIdServicesVariablePublish = 18683
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification                  OpcuaNodeIdServicesVariablePublish = 18684
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                OpcuaNodeIdServicesVariablePublish = 18685
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                 OpcuaNodeIdServicesVariablePublish = 18686
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                   OpcuaNodeIdServicesVariablePublish = 18687
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active            OpcuaNodeIdServicesVariablePublish = 18688
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification    OpcuaNodeIdServicesVariablePublish = 18689
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublish = 18690
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange   OpcuaNodeIdServicesVariablePublish = 18691
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent                   OpcuaNodeIdServicesVariablePublish = 18692
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active            OpcuaNodeIdServicesVariablePublish = 18693
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification    OpcuaNodeIdServicesVariablePublish = 18694
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublish = 18695
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange   OpcuaNodeIdServicesVariablePublish = 18696
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError                  OpcuaNodeIdServicesVariablePublish = 18697
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active           OpcuaNodeIdServicesVariablePublish = 18698
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification   OpcuaNodeIdServicesVariablePublish = 18699
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel OpcuaNodeIdServicesVariablePublish = 18700
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange  OpcuaNodeIdServicesVariablePublish = 18701
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent                        OpcuaNodeIdServicesVariablePublish = 18702
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                 OpcuaNodeIdServicesVariablePublish = 18703
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification         OpcuaNodeIdServicesVariablePublish = 18704
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariablePublish = 18705
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange        OpcuaNodeIdServicesVariablePublish = 18706
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                      OpcuaNodeIdServicesVariablePublish = 18707
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active               OpcuaNodeIdServicesVariablePublish = 18708
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification       OpcuaNodeIdServicesVariablePublish = 18709
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublish = 18710
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange      OpcuaNodeIdServicesVariablePublish = 18711
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress                          OpcuaNodeIdServicesVariablePublish = 18713
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel         OpcuaNodeIdServicesVariablePublish = 18714
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_DiagnosticsLevel                                                               OpcuaNodeIdServicesVariablePublish = 18716
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation                                                               OpcuaNodeIdServicesVariablePublish = 18717
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Active                                                        OpcuaNodeIdServicesVariablePublish = 18718
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Classification                                                OpcuaNodeIdServicesVariablePublish = 18719
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel                                              OpcuaNodeIdServicesVariablePublish = 18720
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange                                               OpcuaNodeIdServicesVariablePublish = 18721
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError                                                                     OpcuaNodeIdServicesVariablePublish = 18722
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Active                                                              OpcuaNodeIdServicesVariablePublish = 18723
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Classification                                                      OpcuaNodeIdServicesVariablePublish = 18724
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel                                                    OpcuaNodeIdServicesVariablePublish = 18725
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange                                                     OpcuaNodeIdServicesVariablePublish = 18726
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_SubError                                                                       OpcuaNodeIdServicesVariablePublish = 18728
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError                                                            OpcuaNodeIdServicesVariablePublish = 18730
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Active                                                     OpcuaNodeIdServicesVariablePublish = 18731
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Classification                                             OpcuaNodeIdServicesVariablePublish = 18732
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel                                           OpcuaNodeIdServicesVariablePublish = 18733
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange                                            OpcuaNodeIdServicesVariablePublish = 18734
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod                                              OpcuaNodeIdServicesVariablePublish = 18735
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active                                       OpcuaNodeIdServicesVariablePublish = 18736
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification                               OpcuaNodeIdServicesVariablePublish = 18737
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel                             OpcuaNodeIdServicesVariablePublish = 18738
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange                              OpcuaNodeIdServicesVariablePublish = 18739
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent                                              OpcuaNodeIdServicesVariablePublish = 18740
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active                                       OpcuaNodeIdServicesVariablePublish = 18741
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification                               OpcuaNodeIdServicesVariablePublish = 18742
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel                             OpcuaNodeIdServicesVariablePublish = 18743
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange                              OpcuaNodeIdServicesVariablePublish = 18744
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError                                             OpcuaNodeIdServicesVariablePublish = 18745
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active                                      OpcuaNodeIdServicesVariablePublish = 18746
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification                              OpcuaNodeIdServicesVariablePublish = 18747
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel                            OpcuaNodeIdServicesVariablePublish = 18748
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange                             OpcuaNodeIdServicesVariablePublish = 18749
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent                                                   OpcuaNodeIdServicesVariablePublish = 18750
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active                                            OpcuaNodeIdServicesVariablePublish = 18751
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification                                    OpcuaNodeIdServicesVariablePublish = 18752
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel                                  OpcuaNodeIdServicesVariablePublish = 18753
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange                                   OpcuaNodeIdServicesVariablePublish = 18754
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod                                                 OpcuaNodeIdServicesVariablePublish = 18755
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active                                          OpcuaNodeIdServicesVariablePublish = 18756
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification                                  OpcuaNodeIdServicesVariablePublish = 18757
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel                                OpcuaNodeIdServicesVariablePublish = 18758
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange                                 OpcuaNodeIdServicesVariablePublish = 18759
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters                                            OpcuaNodeIdServicesVariablePublish = 18761
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel                           OpcuaNodeIdServicesVariablePublish = 18762
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders                                            OpcuaNodeIdServicesVariablePublish = 18763
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel                           OpcuaNodeIdServicesVariablePublish = 18764
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters                                           OpcuaNodeIdServicesVariablePublish = 18765
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel                          OpcuaNodeIdServicesVariablePublish = 18766
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders                                           OpcuaNodeIdServicesVariablePublish = 18767
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel                          OpcuaNodeIdServicesVariablePublish = 18768
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments                                         OpcuaNodeIdServicesVariablePublish = 23638
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments                                        OpcuaNodeIdServicesVariablePublish = 23639
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments                                      OpcuaNodeIdServicesVariablePublish = 23641
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections                                                     OpcuaNodeIdServicesVariablePublish = 23643
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxWriterGroups                                                          OpcuaNodeIdServicesVariablePublish = 23644
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxReaderGroups                                                          OpcuaNodeIdServicesVariablePublish = 23645
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters                                                        OpcuaNodeIdServicesVariablePublish = 23646
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders                                                        OpcuaNodeIdServicesVariablePublish = 23647
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet                                                      OpcuaNodeIdServicesVariablePublish = 23648
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments                                             OpcuaNodeIdServicesVariablePublish = 23674
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments                                            OpcuaNodeIdServicesVariablePublish = 23675
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 23677
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxPubSubConnections                                                         OpcuaNodeIdServicesVariablePublish = 23679
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxWriterGroups                                                              OpcuaNodeIdServicesVariablePublish = 23680
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxReaderGroups                                                              OpcuaNodeIdServicesVariablePublish = 23681
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWriters                                                            OpcuaNodeIdServicesVariablePublish = 23682
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetReaders                                                            OpcuaNodeIdServicesVariablePublish = 23683
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet                                                          OpcuaNodeIdServicesVariablePublish = 23684
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments                                     OpcuaNodeIdServicesVariablePublish = 24005
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments                                    OpcuaNodeIdServicesVariablePublish = 24006
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments                                  OpcuaNodeIdServicesVariablePublish = 24008
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder                                                     OpcuaNodeIdServicesVariablePublish = 24009
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments                                         OpcuaNodeIdServicesVariablePublish = 24011
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments                                        OpcuaNodeIdServicesVariablePublish = 24012
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments                                      OpcuaNodeIdServicesVariablePublish = 24014
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DataSetClasses_DataSetName_Placeholder                                                         OpcuaNodeIdServicesVariablePublish = 24015
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments                                       OpcuaNodeIdServicesVariablePublish = 25387
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments                                      OpcuaNodeIdServicesVariablePublish = 25388
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments                                    OpcuaNodeIdServicesVariablePublish = 25390
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris                                                 OpcuaNodeIdServicesVariablePublish = 25391
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments                                                OpcuaNodeIdServicesVariablePublish = 25394
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments                                               OpcuaNodeIdServicesVariablePublish = 25395
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments                                             OpcuaNodeIdServicesVariablePublish = 25397
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 25399
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments                                         OpcuaNodeIdServicesVariablePublish = 25400
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments                                       OpcuaNodeIdServicesVariablePublish = 25402
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Size                                                                   OpcuaNodeIdServicesVariablePublish = 25404
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Writable                                                               OpcuaNodeIdServicesVariablePublish = 25405
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_UserWritable                                                           OpcuaNodeIdServicesVariablePublish = 25406
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_OpenCount                                                              OpcuaNodeIdServicesVariablePublish = 25407
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MimeType                                                               OpcuaNodeIdServicesVariablePublish = 25408
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MaxByteStringLength                                                    OpcuaNodeIdServicesVariablePublish = 25409
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_LastModifiedTime                                                       OpcuaNodeIdServicesVariablePublish = 25410
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_InputArguments                                                    OpcuaNodeIdServicesVariablePublish = 25412
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments                                                   OpcuaNodeIdServicesVariablePublish = 25413
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Close_InputArguments                                                   OpcuaNodeIdServicesVariablePublish = 25415
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_InputArguments                                                    OpcuaNodeIdServicesVariablePublish = 25417
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments                                                   OpcuaNodeIdServicesVariablePublish = 25418
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Write_InputArguments                                                   OpcuaNodeIdServicesVariablePublish = 25420
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments                                             OpcuaNodeIdServicesVariablePublish = 25422
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments                                            OpcuaNodeIdServicesVariablePublish = 25423
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments                                             OpcuaNodeIdServicesVariablePublish = 25425
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments                                              OpcuaNodeIdServicesVariablePublish = 25427
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments                                             OpcuaNodeIdServicesVariablePublish = 25428
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments                                          OpcuaNodeIdServicesVariablePublish = 25430
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments                                         OpcuaNodeIdServicesVariablePublish = 25431
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultDatagramPublisherId                                                                 OpcuaNodeIdServicesVariablePublish = 25432
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationVersion                                                                       OpcuaNodeIdServicesVariablePublish = 25433
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments                                           OpcuaNodeIdServicesVariablePublish = 25435
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments                                          OpcuaNodeIdServicesVariablePublish = 25436
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments                                        OpcuaNodeIdServicesVariablePublish = 25438
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris                                                     OpcuaNodeIdServicesVariablePublish = 25439
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments                                                    OpcuaNodeIdServicesVariablePublish = 25442
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments                                                   OpcuaNodeIdServicesVariablePublish = 25443
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments                                                 OpcuaNodeIdServicesVariablePublish = 25445
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments                                              OpcuaNodeIdServicesVariablePublish = 25447
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments                                             OpcuaNodeIdServicesVariablePublish = 25448
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments                                           OpcuaNodeIdServicesVariablePublish = 25450
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Size                                                                       OpcuaNodeIdServicesVariablePublish = 25452
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Writable                                                                   OpcuaNodeIdServicesVariablePublish = 25453
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_UserWritable                                                               OpcuaNodeIdServicesVariablePublish = 25454
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_OpenCount                                                                  OpcuaNodeIdServicesVariablePublish = 25455
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MimeType                                                                   OpcuaNodeIdServicesVariablePublish = 25456
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MaxByteStringLength                                                        OpcuaNodeIdServicesVariablePublish = 25457
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_LastModifiedTime                                                           OpcuaNodeIdServicesVariablePublish = 25458
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_InputArguments                                                        OpcuaNodeIdServicesVariablePublish = 25460
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_OutputArguments                                                       OpcuaNodeIdServicesVariablePublish = 25461
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Close_InputArguments                                                       OpcuaNodeIdServicesVariablePublish = 25463
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_InputArguments                                                        OpcuaNodeIdServicesVariablePublish = 25465
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_OutputArguments                                                       OpcuaNodeIdServicesVariablePublish = 25466
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Write_InputArguments                                                       OpcuaNodeIdServicesVariablePublish = 25468
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments                                                 OpcuaNodeIdServicesVariablePublish = 25470
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments                                                OpcuaNodeIdServicesVariablePublish = 25471
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments                                                 OpcuaNodeIdServicesVariablePublish = 25473
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments                                                  OpcuaNodeIdServicesVariablePublish = 25475
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments                                                 OpcuaNodeIdServicesVariablePublish = 25476
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments                                              OpcuaNodeIdServicesVariablePublish = 25478
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments                                             OpcuaNodeIdServicesVariablePublish = 25479
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultDatagramPublisherId                                                                     OpcuaNodeIdServicesVariablePublish = 25480
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationVersion                                                                           OpcuaNodeIdServicesVariablePublish = 25481
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup                                                OpcuaNodeIdServicesVariablePublish = 32391
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram                                            OpcuaNodeIdServicesVariablePublish = 32392
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker                                              OpcuaNodeIdServicesVariablePublish = 32393
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull                                                   OpcuaNodeIdServicesVariablePublish = 32394
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush                                                   OpcuaNodeIdServicesVariablePublish = 32395
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultSecurityKeyServices                                                                 OpcuaNodeIdServicesVariablePublish = 32396
	OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationProperties                                                                    OpcuaNodeIdServicesVariablePublish = 32397
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup                                                    OpcuaNodeIdServicesVariablePublish = 32398
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram                                                OpcuaNodeIdServicesVariablePublish = 32399
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker                                                  OpcuaNodeIdServicesVariablePublish = 32400
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull                                                       OpcuaNodeIdServicesVariablePublish = 32401
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush                                                       OpcuaNodeIdServicesVariablePublish = 32402
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultSecurityKeyServices                                                                     OpcuaNodeIdServicesVariablePublish = 32403
	OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationProperties                                                                        OpcuaNodeIdServicesVariablePublish = 32404
)

var OpcuaNodeIdServicesVariablePublishValues []OpcuaNodeIdServicesVariablePublish

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePublishValues = []OpcuaNodeIdServicesVariablePublish{
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_PublisherId,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_RemoveConnection_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_PublisherId,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Status_State,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SetSecurityKeys_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SetSecurityKeys_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_RemoveConnection_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Status_State,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SupportedTransportProfiles,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SupportedTransportProfiles,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxWriterGroups,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxReaderGroups,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxPubSubConnections,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxWriterGroups,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxReaderGroups,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWriters,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetReaders,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DataSetClasses_DataSetName_Placeholder,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Size,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Writable,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_UserWritable,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_OpenCount,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MimeType,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MaxByteStringLength,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_LastModifiedTime,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Close_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Write_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultDatagramPublisherId,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Size,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Writable,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_UserWritable,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_OpenCount,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MimeType,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MaxByteStringLength,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_LastModifiedTime,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Close_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Write_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultDatagramPublisherId,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultSecurityKeyServices,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationProperties,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultSecurityKeyServices,
		OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationProperties,
	}
}

func OpcuaNodeIdServicesVariablePublishByValue(value int32) (enum OpcuaNodeIdServicesVariablePublish, ok bool) {
	switch value {
	case 14418:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_PublisherId, true
	case 14420:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Status_State, true
	case 14425:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments, true
	case 14433:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_RemoveConnection_InputArguments, true
	case 14436:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments, true
	case 14437:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments, true
	case 14439:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments, true
	case 14440:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments, true
	case 14442:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments, true
	case 15213:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_InputArguments, true
	case 15214:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_OutputArguments, true
	case 15216:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_InputArguments, true
	case 15217:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_OutputArguments, true
	case 15432:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_InputArguments, true
	case 15433:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_OutputArguments, true
	case 15436:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments, true
	case 15437:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case 15439:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case 15441:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_InputArguments, true
	case 15442:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_OutputArguments, true
	case 15445:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments, true
	case 15446:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case 15448:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case 15533:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface, true
	case 15791:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_PublisherId, true
	case 15792:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri, true
	case 15845:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Status_State, true
	case 15848:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections, true
	case 15849:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions, true
	case 15850:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList, true
	case 15863:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface, true
	case 15892:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Status_State, true
	case 15938:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 15939:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation, true
	case 15989:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 15994:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 16013:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 16020:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 16059:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError, true
	case 16060:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active, true
	case 16061:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification, true
	case 16074:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 16075:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 16101:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError, true
	case 16103:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError, true
	case 16122:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 16123:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 16124:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 16160:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 16283:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 16322:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 16523:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 16558:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments, true
	case 16559:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments, true
	case 16561:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments, true
	case 16571:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments, true
	case 16599:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_InputArguments, true
	case 16600:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_OutputArguments, true
	case 16611:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments, true
	case 16638:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments, true
	case 16640:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments, true
	case 16641:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments, true
	case 16678:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments, true
	case 16679:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments, true
	case 16681:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments, true
	case 17292:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri, true
	case 17295:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList, true
	case 17297:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SetSecurityKeys_InputArguments, true
	case 17300:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 17303:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 17304:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 17305:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 17320:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 17335:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 17336:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 17337:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 17338:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 17339:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 17340:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 17341:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 17342:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 17343:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 17344:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 17345:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 17346:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 17347:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 17348:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 17349:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 17350:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 17351:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 17353:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress, true
	case 17354:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case 17357:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments, true
	case 17358:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments, true
	case 17360:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments, true
	case 17361:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments, true
	case 17363:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments, true
	case 17365:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SetSecurityKeys_InputArguments, true
	case 17367:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_InputArguments, true
	case 17368:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_OutputArguments, true
	case 17370:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_RemoveConnection_InputArguments, true
	case 17373:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments, true
	case 17374:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments, true
	case 17376:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments, true
	case 17377:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments, true
	case 17379:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments, true
	case 17380:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments, true
	case 17382:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments, true
	case 17383:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments, true
	case 17385:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments, true
	case 17401:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments, true
	case 17402:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments, true
	case 17404:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments, true
	case 17406:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Status_State, true
	case 17410:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_DiagnosticsLevel, true
	case 17411:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation, true
	case 17412:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Active, true
	case 17413:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Classification, true
	case 17414:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 17415:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange, true
	case 17416:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError, true
	case 17417:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Active, true
	case 17418:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Classification, true
	case 17419:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel, true
	case 17420:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_TimeFirstChange, true
	case 17422:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_SubError, true
	case 17424:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError, true
	case 17425:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Active, true
	case 17426:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Classification, true
	case 17429:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 17430:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 17431:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod, true
	case 17432:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 17433:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 17434:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 17435:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 17436:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent, true
	case 17437:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 17438:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 17439:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 17440:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 17441:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError, true
	case 17442:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 17443:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 17444:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 17445:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 17446:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent, true
	case 17447:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active, true
	case 17448:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 17449:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 17450:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 17451:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod, true
	case 17452:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 17453:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 17454:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 17455:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 17458:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case 17459:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 17460:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case 17461:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 17462:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case 17463:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 17464:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case 17466:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 17478:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties, true
	case 17479:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SupportedTransportProfiles, true
	case 17480:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties, true
	case 17481:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SupportedTransportProfiles, true
	case 17503:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections, true
	case 17504:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions, true
	case 17505:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList, true
	case 17506:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections, true
	case 17509:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions, true
	case 17510:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList, true
	case 17706:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections, true
	case 17707:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions, true
	case 18668:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18669:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation, true
	case 18670:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18671:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18672:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18673:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18674:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError, true
	case 18675:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active, true
	case 18676:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18677:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18678:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 18680:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError, true
	case 18682:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError, true
	case 18683:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 18684:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 18685:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18686:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18687:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 18688:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18689:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18690:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18691:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18692:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 18693:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18694:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18695:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18696:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18697:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 18698:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18699:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18700:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18701:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18702:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 18703:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18704:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18705:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18706:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18707:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 18708:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18709:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18710:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18711:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18713:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress, true
	case 18714:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case 18716:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_DiagnosticsLevel, true
	case 18717:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation, true
	case 18718:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Active, true
	case 18719:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Classification, true
	case 18720:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18721:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18722:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError, true
	case 18723:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Active, true
	case 18724:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Classification, true
	case 18725:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18726:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange, true
	case 18728:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_SubError, true
	case 18730:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError, true
	case 18731:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Active, true
	case 18732:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Classification, true
	case 18733:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18734:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18735:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod, true
	case 18736:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18737:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18738:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18739:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18740:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent, true
	case 18741:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18742:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18743:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18744:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18745:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError, true
	case 18746:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18747:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18748:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18749:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18750:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent, true
	case 18751:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18752:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18753:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18754:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18755:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod, true
	case 18756:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18757:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18758:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18759:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18761:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case 18762:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case 18763:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case 18764:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case 18765:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case 18766:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case 18767:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case 18768:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case 23638:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments, true
	case 23639:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments, true
	case 23641:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments, true
	case 23643:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections, true
	case 23644:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxWriterGroups, true
	case 23645:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxReaderGroups, true
	case 23646:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters, true
	case 23647:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders, true
	case 23648:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet, true
	case 23674:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments, true
	case 23675:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments, true
	case 23677:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments, true
	case 23679:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxPubSubConnections, true
	case 23680:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxWriterGroups, true
	case 23681:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxReaderGroups, true
	case 23682:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWriters, true
	case 23683:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetReaders, true
	case 23684:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet, true
	case 24005:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments, true
	case 24006:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments, true
	case 24008:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments, true
	case 24009:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder, true
	case 24011:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments, true
	case 24012:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments, true
	case 24014:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments, true
	case 24015:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DataSetClasses_DataSetName_Placeholder, true
	case 25387:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case 25388:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case 25390:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case 25391:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris, true
	case 25394:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments, true
	case 25395:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments, true
	case 25397:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments, true
	case 25399:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case 25400:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case 25402:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case 25404:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Size, true
	case 25405:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Writable, true
	case 25406:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_UserWritable, true
	case 25407:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_OpenCount, true
	case 25408:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MimeType, true
	case 25409:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MaxByteStringLength, true
	case 25410:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_LastModifiedTime, true
	case 25412:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_InputArguments, true
	case 25413:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments, true
	case 25415:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Close_InputArguments, true
	case 25417:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_InputArguments, true
	case 25418:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments, true
	case 25420:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Write_InputArguments, true
	case 25422:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments, true
	case 25423:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments, true
	case 25425:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments, true
	case 25427:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments, true
	case 25428:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments, true
	case 25430:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments, true
	case 25431:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments, true
	case 25432:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultDatagramPublisherId, true
	case 25433:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationVersion, true
	case 25435:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case 25436:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case 25438:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case 25439:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris, true
	case 25442:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments, true
	case 25443:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments, true
	case 25445:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments, true
	case 25447:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case 25448:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case 25450:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case 25452:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Size, true
	case 25453:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Writable, true
	case 25454:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_UserWritable, true
	case 25455:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_OpenCount, true
	case 25456:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MimeType, true
	case 25457:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MaxByteStringLength, true
	case 25458:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_LastModifiedTime, true
	case 25460:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_InputArguments, true
	case 25461:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_OutputArguments, true
	case 25463:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Close_InputArguments, true
	case 25465:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_InputArguments, true
	case 25466:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_OutputArguments, true
	case 25468:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Write_InputArguments, true
	case 25470:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments, true
	case 25471:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments, true
	case 25473:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments, true
	case 25475:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments, true
	case 25476:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments, true
	case 25478:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments, true
	case 25479:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments, true
	case 25480:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultDatagramPublisherId, true
	case 25481:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationVersion, true
	case 32391:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup, true
	case 32392:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram, true
	case 32393:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker, true
	case 32394:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull, true
	case 32395:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush, true
	case 32396:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultSecurityKeyServices, true
	case 32397:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationProperties, true
	case 32398:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup, true
	case 32399:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram, true
	case 32400:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker, true
	case 32401:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull, true
	case 32402:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush, true
	case 32403:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultSecurityKeyServices, true
	case 32404:
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationProperties, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishByName(value string) (enum OpcuaNodeIdServicesVariablePublish, ok bool) {
	switch value {
	case "PublishSubscribeType_ConnectionName_Placeholder_PublisherId":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_PublisherId, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Status_State, true
	case "PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments, true
	case "PublishSubscribeType_RemoveConnection_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_RemoveConnection_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments, true
	case "PublishSubscribeType_GetSecurityKeys_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_InputArguments, true
	case "PublishSubscribeType_GetSecurityKeys_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_OutputArguments, true
	case "PublishSubscribe_GetSecurityKeys_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_InputArguments, true
	case "PublishSubscribe_GetSecurityKeys_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_OutputArguments, true
	case "PublishSubscribeType_GetSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_InputArguments, true
	case "PublishSubscribeType_GetSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_OutputArguments, true
	case "PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments, true
	case "PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case "PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case "PublishSubscribe_GetSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_InputArguments, true
	case "PublishSubscribe_GetSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_OutputArguments, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments, true
	case "PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface, true
	case "PublishSubscribe_ConnectionName_Placeholder_PublisherId":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_PublisherId, true
	case "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri, true
	case "PublishSubscribeType_Status_State":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Status_State, true
	case "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections, true
	case "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions, true
	case "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList, true
	case "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface, true
	case "PublishSubscribe_ConnectionName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Status_State, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments, true
	case "PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments, true
	case "PublishSubscribeType_AddConnection_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_InputArguments, true
	case "PublishSubscribeType_AddConnection_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments, true
	case "PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments, true
	case "PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments, true
	case "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri, true
	case "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList, true
	case "PublishSubscribeType_SetSecurityKeys_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SetSecurityKeys_InputArguments, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress, true
	case "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case "PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments, true
	case "PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments, true
	case "PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments, true
	case "PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments, true
	case "PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments, true
	case "PublishSubscribe_SetSecurityKeys_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SetSecurityKeys_InputArguments, true
	case "PublishSubscribe_AddConnection_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_InputArguments, true
	case "PublishSubscribe_AddConnection_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_OutputArguments, true
	case "PublishSubscribe_RemoveConnection_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_RemoveConnection_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments, true
	case "PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments, true
	case "PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments, true
	case "PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments, true
	case "PublishSubscribe_Status_State":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Status_State, true
	case "PublishSubscribe_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation, true
	case "PublishSubscribe_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Active, true
	case "PublishSubscribe_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Classification, true
	case "PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError, true
	case "PublishSubscribe_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Active, true
	case "PublishSubscribe_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Classification, true
	case "PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_SubError, true
	case "PublishSubscribe_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError, true
	case "PublishSubscribe_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent, true
	case "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties, true
	case "PublishSubscribeType_SupportedTransportProfiles":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SupportedTransportProfiles, true
	case "PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties, true
	case "PublishSubscribe_SupportedTransportProfiles":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SupportedTransportProfiles, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList, true
	case "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections, true
	case "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions, true
	case "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList, true
	case "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections, true
	case "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation, true
	case "PublishSubscribeType_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Active, true
	case "PublishSubscribeType_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Classification, true
	case "PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError, true
	case "PublishSubscribeType_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Active, true
	case "PublishSubscribeType_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Classification, true
	case "PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_SubError, true
	case "PublishSubscribeType_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError, true
	case "PublishSubscribeType_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent, true
	case "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters, true
	case "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders, true
	case "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters, true
	case "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel, true
	case "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders, true
	case "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel, true
	case "PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments, true
	case "PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments, true
	case "PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments, true
	case "PublishSubscribeType_PubSubCapablities_MaxPubSubConnections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections, true
	case "PublishSubscribeType_PubSubCapablities_MaxWriterGroups":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxWriterGroups, true
	case "PublishSubscribeType_PubSubCapablities_MaxReaderGroups":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxReaderGroups, true
	case "PublishSubscribeType_PubSubCapablities_MaxDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters, true
	case "PublishSubscribeType_PubSubCapablities_MaxDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders, true
	case "PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet, true
	case "PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments, true
	case "PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments, true
	case "PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments, true
	case "PublishSubscribe_PubSubCapablities_MaxPubSubConnections":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxPubSubConnections, true
	case "PublishSubscribe_PubSubCapablities_MaxWriterGroups":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxWriterGroups, true
	case "PublishSubscribe_PubSubCapablities_MaxReaderGroups":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxReaderGroups, true
	case "PublishSubscribe_PubSubCapablities_MaxDataSetWriters":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWriters, true
	case "PublishSubscribe_PubSubCapablities_MaxDataSetReaders":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetReaders, true
	case "PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet, true
	case "PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments, true
	case "PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments, true
	case "PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments, true
	case "PublishSubscribeType_DataSetClasses_DataSetName_Placeholder":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder, true
	case "PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments, true
	case "PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments, true
	case "PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments, true
	case "PublishSubscribe_DataSetClasses_DataSetName_Placeholder":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DataSetClasses_DataSetName_Placeholder, true
	case "PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case "PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case "PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case "PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris, true
	case "PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments, true
	case "PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments, true
	case "PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments, true
	case "PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case "PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case "PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Size":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Size, true
	case "PublishSubscribeType_PubSubConfiguration_Writable":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Writable, true
	case "PublishSubscribeType_PubSubConfiguration_UserWritable":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_UserWritable, true
	case "PublishSubscribeType_PubSubConfiguration_OpenCount":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_OpenCount, true
	case "PublishSubscribeType_PubSubConfiguration_MimeType":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MimeType, true
	case "PublishSubscribeType_PubSubConfiguration_MaxByteStringLength":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MaxByteStringLength, true
	case "PublishSubscribeType_PubSubConfiguration_LastModifiedTime":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_LastModifiedTime, true
	case "PublishSubscribeType_PubSubConfiguration_Open_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Open_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Close_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Close_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Read_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Read_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_Write_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Write_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments, true
	case "PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments, true
	case "PublishSubscribeType_DefaultDatagramPublisherId":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultDatagramPublisherId, true
	case "PublishSubscribeType_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationVersion, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments, true
	case "PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments, true
	case "PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments, true
	case "PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris, true
	case "PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments, true
	case "PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments, true
	case "PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments, true
	case "PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments, true
	case "PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments, true
	case "PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Size":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Size, true
	case "PublishSubscribe_PubSubConfiguration_Writable":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Writable, true
	case "PublishSubscribe_PubSubConfiguration_UserWritable":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_UserWritable, true
	case "PublishSubscribe_PubSubConfiguration_OpenCount":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_OpenCount, true
	case "PublishSubscribe_PubSubConfiguration_MimeType":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MimeType, true
	case "PublishSubscribe_PubSubConfiguration_MaxByteStringLength":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MaxByteStringLength, true
	case "PublishSubscribe_PubSubConfiguration_LastModifiedTime":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_LastModifiedTime, true
	case "PublishSubscribe_PubSubConfiguration_Open_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Open_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_OutputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Close_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Close_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Read_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Read_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_OutputArguments, true
	case "PublishSubscribe_PubSubConfiguration_Write_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Write_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments, true
	case "PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments, true
	case "PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments, true
	case "PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments, true
	case "PublishSubscribe_DefaultDatagramPublisherId":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultDatagramPublisherId, true
	case "PublishSubscribe_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationVersion, true
	case "PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup, true
	case "PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram, true
	case "PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker, true
	case "PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull, true
	case "PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush, true
	case "PublishSubscribeType_DefaultSecurityKeyServices":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultSecurityKeyServices, true
	case "PublishSubscribeType_ConfigurationProperties":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationProperties, true
	case "PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup, true
	case "PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram, true
	case "PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker, true
	case "PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull, true
	case "PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush, true
	case "PublishSubscribe_DefaultSecurityKeyServices":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultSecurityKeyServices, true
	case "PublishSubscribe_ConfigurationProperties":
		return OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationProperties, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePublishValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePublish(structType any) OpcuaNodeIdServicesVariablePublish {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePublish {
		if sOpcuaNodeIdServicesVariablePublish, ok := typ.(OpcuaNodeIdServicesVariablePublish); ok {
			return sOpcuaNodeIdServicesVariablePublish
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePublish) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePublish) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePublishParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePublish, error) {
	return OpcuaNodeIdServicesVariablePublishParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePublishParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePublish, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePublish", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePublish")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePublishByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePublish")
		return OpcuaNodeIdServicesVariablePublish(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePublish) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePublish) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePublish", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePublish) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_PublisherId:
		return "PublishSubscribeType_ConnectionName_Placeholder_PublisherId"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Status_State:
		return "PublishSubscribeType_ConnectionName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments:
		return "PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_RemoveConnection_InputArguments:
		return "PublishSubscribeType_RemoveConnection_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_InputArguments:
		return "PublishSubscribeType_GetSecurityKeys_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityKeys_OutputArguments:
		return "PublishSubscribeType_GetSecurityKeys_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_InputArguments:
		return "PublishSubscribe_GetSecurityKeys_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityKeys_OutputArguments:
		return "PublishSubscribe_GetSecurityKeys_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_InputArguments:
		return "PublishSubscribeType_GetSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_GetSecurityGroup_OutputArguments:
		return "PublishSubscribeType_GetSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments:
		return "PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments:
		return "PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments:
		return "PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_InputArguments:
		return "PublishSubscribe_GetSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_GetSecurityGroup_OutputArguments:
		return "PublishSubscribe_GetSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments:
		return "PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments:
		return "PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments:
		return "PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface:
		return "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_PublisherId:
		return "PublishSubscribe_ConnectionName_Placeholder_PublisherId"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri:
		return "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Status_State:
		return "PublishSubscribeType_Status_State"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections:
		return "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions:
		return "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList:
		return "PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface:
		return "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Status_State:
		return "PublishSubscribe_ConnectionName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments:
		return "PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments:
		return "PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments:
		return "PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments:
		return "PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_InputArguments:
		return "PublishSubscribeType_AddConnection_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_AddConnection_OutputArguments:
		return "PublishSubscribeType_AddConnection_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments:
		return "PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments:
		return "PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri:
		return "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList:
		return "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SetSecurityKeys_InputArguments:
		return "PublishSubscribeType_SetSecurityKeys_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel:
		return "PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments:
		return "PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments:
		return "PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments:
		return "PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments:
		return "PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments:
		return "PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SetSecurityKeys_InputArguments:
		return "PublishSubscribe_SetSecurityKeys_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_InputArguments:
		return "PublishSubscribe_AddConnection_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_AddConnection_OutputArguments:
		return "PublishSubscribe_AddConnection_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_RemoveConnection_InputArguments:
		return "PublishSubscribe_RemoveConnection_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments:
		return "PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments:
		return "PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments:
		return "PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments:
		return "PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments:
		return "PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Status_State:
		return "PublishSubscribe_Status_State"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation:
		return "PublishSubscribe_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Active:
		return "PublishSubscribe_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_Classification:
		return "PublishSubscribe_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError:
		return "PublishSubscribe_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Active:
		return "PublishSubscribe_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_Classification:
		return "PublishSubscribe_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_TotalError_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_SubError:
		return "PublishSubscribe_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError:
		return "PublishSubscribe_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Active:
		return "PublishSubscribe_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent:
		return "PublishSubscribe_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters:
		return "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders:
		return "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters:
		return "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders:
		return "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties:
		return "PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SupportedTransportProfiles:
		return "PublishSubscribeType_SupportedTransportProfiles"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties:
		return "PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SupportedTransportProfiles:
		return "PublishSubscribe_SupportedTransportProfiles"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections:
		return "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions:
		return "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList:
		return "PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections:
		return "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions:
		return "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList:
		return "PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections:
		return "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions:
		return "PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation:
		return "PublishSubscribeType_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Active:
		return "PublishSubscribeType_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_Classification:
		return "PublishSubscribeType_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError:
		return "PublishSubscribeType_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Active:
		return "PublishSubscribeType_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_Classification:
		return "PublishSubscribeType_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_SubError:
		return "PublishSubscribeType_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError:
		return "PublishSubscribeType_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent:
		return "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters:
		return "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders:
		return "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters:
		return "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders:
		return "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel:
		return "PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments:
		return "PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments:
		return "PublishSubscribeType_SubscribedDataSets_AddDataSetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments:
		return "PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxPubSubConnections:
		return "PublishSubscribeType_PubSubCapablities_MaxPubSubConnections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxWriterGroups:
		return "PublishSubscribeType_PubSubCapablities_MaxWriterGroups"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxReaderGroups:
		return "PublishSubscribeType_PubSubCapablities_MaxReaderGroups"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWriters:
		return "PublishSubscribeType_PubSubCapablities_MaxDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetReaders:
		return "PublishSubscribeType_PubSubCapablities_MaxDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet:
		return "PublishSubscribeType_PubSubCapablities_MaxFieldsPerDataSet"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments:
		return "PublishSubscribe_SubscribedDataSets_AddDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments:
		return "PublishSubscribe_SubscribedDataSets_AddDataSetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments:
		return "PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxPubSubConnections:
		return "PublishSubscribe_PubSubCapablities_MaxPubSubConnections"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxWriterGroups:
		return "PublishSubscribe_PubSubCapablities_MaxWriterGroups"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxReaderGroups:
		return "PublishSubscribe_PubSubCapablities_MaxReaderGroups"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWriters:
		return "PublishSubscribe_PubSubCapablities_MaxDataSetWriters"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetReaders:
		return "PublishSubscribe_PubSubCapablities_MaxDataSetReaders"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet:
		return "PublishSubscribe_PubSubCapablities_MaxFieldsPerDataSet"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments:
		return "PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments:
		return "PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments:
		return "PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DataSetClasses_DataSetName_Placeholder:
		return "PublishSubscribeType_DataSetClasses_DataSetName_Placeholder"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments:
		return "PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments:
		return "PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments:
		return "PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DataSetClasses_DataSetName_Placeholder:
		return "PublishSubscribe_DataSetClasses_DataSetName_Placeholder"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments:
		return "PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments:
		return "PublishSubscribeType_SecurityGroups_AddSecurityGroupFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments:
		return "PublishSubscribeType_SecurityGroups_RemoveSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris:
		return "PublishSubscribeType_SecurityGroups_SupportedSecurityPolicyUris"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments:
		return "PublishSubscribeType_KeyPushTargets_AddPushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments:
		return "PublishSubscribeType_KeyPushTargets_AddPushTarget_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments:
		return "PublishSubscribeType_KeyPushTargets_RemovePushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments:
		return "PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments:
		return "PublishSubscribeType_KeyPushTargets_AddPushTargetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments:
		return "PublishSubscribeType_KeyPushTargets_RemovePushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Size:
		return "PublishSubscribeType_PubSubConfiguration_Size"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Writable:
		return "PublishSubscribeType_PubSubConfiguration_Writable"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_UserWritable:
		return "PublishSubscribeType_PubSubConfiguration_UserWritable"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_OpenCount:
		return "PublishSubscribeType_PubSubConfiguration_OpenCount"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MimeType:
		return "PublishSubscribeType_PubSubConfiguration_MimeType"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_MaxByteStringLength:
		return "PublishSubscribeType_PubSubConfiguration_MaxByteStringLength"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_LastModifiedTime:
		return "PublishSubscribeType_PubSubConfiguration_LastModifiedTime"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Open_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Open_OutputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Open_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Close_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Close_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Read_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Read_OutputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Read_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_Write_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_Write_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments:
		return "PublishSubscribeType_PubSubConfiguration_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_ReserveIds_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments:
		return "PublishSubscribeType_PubSubConfiguration_ReserveIds_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments:
		return "PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments:
		return "PublishSubscribeType_PubSubConfiguration_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultDatagramPublisherId:
		return "PublishSubscribeType_DefaultDatagramPublisherId"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationVersion:
		return "PublishSubscribeType_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments:
		return "PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments:
		return "PublishSubscribe_SecurityGroups_AddSecurityGroupFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments:
		return "PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris:
		return "PublishSubscribe_SecurityGroups_SupportedSecurityPolicyUris"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments:
		return "PublishSubscribe_KeyPushTargets_AddPushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments:
		return "PublishSubscribe_KeyPushTargets_AddPushTarget_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments:
		return "PublishSubscribe_KeyPushTargets_RemovePushTarget_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments:
		return "PublishSubscribe_KeyPushTargets_AddPushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments:
		return "PublishSubscribe_KeyPushTargets_AddPushTargetFolder_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments:
		return "PublishSubscribe_KeyPushTargets_RemovePushTargetFolder_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Size:
		return "PublishSubscribe_PubSubConfiguration_Size"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Writable:
		return "PublishSubscribe_PubSubConfiguration_Writable"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_UserWritable:
		return "PublishSubscribe_PubSubConfiguration_UserWritable"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_OpenCount:
		return "PublishSubscribe_PubSubConfiguration_OpenCount"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MimeType:
		return "PublishSubscribe_PubSubConfiguration_MimeType"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_MaxByteStringLength:
		return "PublishSubscribe_PubSubConfiguration_MaxByteStringLength"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_LastModifiedTime:
		return "PublishSubscribe_PubSubConfiguration_LastModifiedTime"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_Open_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Open_OutputArguments:
		return "PublishSubscribe_PubSubConfiguration_Open_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Close_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_Close_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_Read_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Read_OutputArguments:
		return "PublishSubscribe_PubSubConfiguration_Read_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_Write_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_Write_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments:
		return "PublishSubscribe_PubSubConfiguration_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_ReserveIds_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments:
		return "PublishSubscribe_PubSubConfiguration_ReserveIds_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments:
		return "PublishSubscribe_PubSubConfiguration_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments:
		return "PublishSubscribe_PubSubConfiguration_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultDatagramPublisherId:
		return "PublishSubscribe_DefaultDatagramPublisherId"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationVersion:
		return "PublishSubscribe_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup:
		return "PublishSubscribeType_PubSubCapablities_MaxDataSetWritersPerGroup"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram:
		return "PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeDatagram"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker:
		return "PublishSubscribeType_PubSubCapablities_MaxNetworkMessageSizeBroker"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull:
		return "PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPull"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush:
		return "PublishSubscribeType_PubSubCapablities_SupportSecurityKeyPush"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_DefaultSecurityKeyServices:
		return "PublishSubscribeType_DefaultSecurityKeyServices"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribeType_ConfigurationProperties:
		return "PublishSubscribeType_ConfigurationProperties"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup:
		return "PublishSubscribe_PubSubCapablities_MaxDataSetWritersPerGroup"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram:
		return "PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeDatagram"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker:
		return "PublishSubscribe_PubSubCapablities_MaxNetworkMessageSizeBroker"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull:
		return "PublishSubscribe_PubSubCapablities_SupportSecurityKeyPull"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush:
		return "PublishSubscribe_PubSubCapablities_SupportSecurityKeyPush"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_DefaultSecurityKeyServices:
		return "PublishSubscribe_DefaultSecurityKeyServices"
	case OpcuaNodeIdServicesVariablePublish_PublishSubscribe_ConfigurationProperties:
		return "PublishSubscribe_ConfigurationProperties"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePublish) String() string {
	return e.PLC4XEnumName()
}
