/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableNon is an enum
type OpcuaNodeIdServicesVariableNon int32

type IOpcuaNodeIdServicesVariableNon interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray                                            OpcuaNodeIdServicesVariableNon = 2040
	OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_RedundancySupport                                         OpcuaNodeIdServicesVariableNon = 3189
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventId                                                     OpcuaNodeIdServicesVariableNon = 9907
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventType                                                   OpcuaNodeIdServicesVariableNon = 9908
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceNode                                                  OpcuaNodeIdServicesVariableNon = 9909
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceName                                                  OpcuaNodeIdServicesVariableNon = 9910
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Time                                                        OpcuaNodeIdServicesVariableNon = 9911
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReceiveTime                                                 OpcuaNodeIdServicesVariableNon = 9912
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LocalTime                                                   OpcuaNodeIdServicesVariableNon = 9913
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Message                                                     OpcuaNodeIdServicesVariableNon = 9914
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Severity                                                    OpcuaNodeIdServicesVariableNon = 9915
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionName                                               OpcuaNodeIdServicesVariableNon = 9916
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BranchId                                                    OpcuaNodeIdServicesVariableNon = 9917
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Retain                                                      OpcuaNodeIdServicesVariableNon = 9918
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState                                                OpcuaNodeIdServicesVariableNon = 9919
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Id                                             OpcuaNodeIdServicesVariableNon = 9920
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Name                                           OpcuaNodeIdServicesVariableNon = 9921
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Number                                         OpcuaNodeIdServicesVariableNon = 9922
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 9923
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 9924
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 9925
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TrueState                                      OpcuaNodeIdServicesVariableNon = 9926
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_FalseState                                     OpcuaNodeIdServicesVariableNon = 9927
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality                                                     OpcuaNodeIdServicesVariableNon = 9928
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality_SourceTimestamp                                     OpcuaNodeIdServicesVariableNon = 9929
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity                                                OpcuaNodeIdServicesVariableNon = 9930
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp                                OpcuaNodeIdServicesVariableNon = 9931
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment                                                     OpcuaNodeIdServicesVariableNon = 9932
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment_SourceTimestamp                                     OpcuaNodeIdServicesVariableNon = 9933
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ClientUserId                                                OpcuaNodeIdServicesVariableNon = 9934
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AddComment_InputArguments                                   OpcuaNodeIdServicesVariableNon = 9938
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments                             OpcuaNodeIdServicesVariableNon = 9940
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState                                                  OpcuaNodeIdServicesVariableNon = 9941
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Id                                               OpcuaNodeIdServicesVariableNon = 9942
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Name                                             OpcuaNodeIdServicesVariableNon = 9943
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Number                                           OpcuaNodeIdServicesVariableNon = 9944
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName                             OpcuaNodeIdServicesVariableNon = 9945
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TransitionTime                                   OpcuaNodeIdServicesVariableNon = 9946
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime                          OpcuaNodeIdServicesVariableNon = 9947
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TrueState                                        OpcuaNodeIdServicesVariableNon = 9948
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_FalseState                                       OpcuaNodeIdServicesVariableNon = 9949
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState                                              OpcuaNodeIdServicesVariableNon = 9950
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Id                                           OpcuaNodeIdServicesVariableNon = 9951
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Name                                         OpcuaNodeIdServicesVariableNon = 9952
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Number                                       OpcuaNodeIdServicesVariableNon = 9953
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableNon = 9954
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime                               OpcuaNodeIdServicesVariableNon = 9955
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableNon = 9956
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TrueState                                    OpcuaNodeIdServicesVariableNon = 9957
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_FalseState                                   OpcuaNodeIdServicesVariableNon = 9958
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Acknowledge_InputArguments                                  OpcuaNodeIdServicesVariableNon = 9960
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Confirm_InputArguments                                      OpcuaNodeIdServicesVariableNon = 9962
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState                                                 OpcuaNodeIdServicesVariableNon = 9963
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id                                              OpcuaNodeIdServicesVariableNon = 9964
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name                                            OpcuaNodeIdServicesVariableNon = 9965
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number                                          OpcuaNodeIdServicesVariableNon = 9966
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableNon = 9967
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime                                  OpcuaNodeIdServicesVariableNon = 9968
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableNon = 9969
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState                                       OpcuaNodeIdServicesVariableNon = 9970
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState                                      OpcuaNodeIdServicesVariableNon = 9971
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState                                             OpcuaNodeIdServicesVariableNon = 9972
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Id                                          OpcuaNodeIdServicesVariableNon = 9973
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Name                                        OpcuaNodeIdServicesVariableNon = 9974
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Number                                      OpcuaNodeIdServicesVariableNon = 9975
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableNon = 9976
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TransitionTime                              OpcuaNodeIdServicesVariableNon = 9977
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableNon = 9978
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TrueState                                   OpcuaNodeIdServicesVariableNon = 9979
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_FalseState                                  OpcuaNodeIdServicesVariableNon = 9980
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState                                  OpcuaNodeIdServicesVariableNon = 9982
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id                               OpcuaNodeIdServicesVariableNon = 9983
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name                             OpcuaNodeIdServicesVariableNon = 9984
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number                           OpcuaNodeIdServicesVariableNon = 9985
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName             OpcuaNodeIdServicesVariableNon = 9986
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition                                OpcuaNodeIdServicesVariableNon = 9987
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id                             OpcuaNodeIdServicesVariableNon = 9988
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name                           OpcuaNodeIdServicesVariableNon = 9989
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number                         OpcuaNodeIdServicesVariableNon = 9990
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime                 OpcuaNodeIdServicesVariableNon = 9991
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime                                  OpcuaNodeIdServicesVariableNon = 9992
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments                    OpcuaNodeIdServicesVariableNon = 10017
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedOrShelved                                         OpcuaNodeIdServicesVariableNon = 10018
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_MaxTimeShelved                                              OpcuaNodeIdServicesVariableNon = 10019
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState                                               OpcuaNodeIdServicesVariableNon = 10020
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id                                            OpcuaNodeIdServicesVariableNon = 10021
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name                                          OpcuaNodeIdServicesVariableNon = 10022
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number                                        OpcuaNodeIdServicesVariableNon = 10023
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableNon = 10024
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime                                OpcuaNodeIdServicesVariableNon = 10025
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableNon = 10026
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState                                     OpcuaNodeIdServicesVariableNon = 10027
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState                                    OpcuaNodeIdServicesVariableNon = 10028
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState                                                   OpcuaNodeIdServicesVariableNon = 10029
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id                                                OpcuaNodeIdServicesVariableNon = 10030
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name                                              OpcuaNodeIdServicesVariableNon = 10031
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number                                            OpcuaNodeIdServicesVariableNon = 10032
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableNon = 10033
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime                                    OpcuaNodeIdServicesVariableNon = 10034
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableNon = 10035
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState                                         OpcuaNodeIdServicesVariableNon = 10036
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState                                        OpcuaNodeIdServicesVariableNon = 10037
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState                                                    OpcuaNodeIdServicesVariableNon = 10038
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id                                                 OpcuaNodeIdServicesVariableNon = 10039
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name                                               OpcuaNodeIdServicesVariableNon = 10040
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number                                             OpcuaNodeIdServicesVariableNon = 10041
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableNon = 10042
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime                                     OpcuaNodeIdServicesVariableNon = 10043
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableNon = 10044
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState                                          OpcuaNodeIdServicesVariableNon = 10045
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState                                         OpcuaNodeIdServicesVariableNon = 10046
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState                                                 OpcuaNodeIdServicesVariableNon = 10047
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id                                              OpcuaNodeIdServicesVariableNon = 10048
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name                                            OpcuaNodeIdServicesVariableNon = 10049
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number                                          OpcuaNodeIdServicesVariableNon = 10050
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableNon = 10051
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime                                  OpcuaNodeIdServicesVariableNon = 10052
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableNon = 10053
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState                                       OpcuaNodeIdServicesVariableNon = 10054
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState                                      OpcuaNodeIdServicesVariableNon = 10055
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighLimit                                               OpcuaNodeIdServicesVariableNon = 10056
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighLimit                                                   OpcuaNodeIdServicesVariableNon = 10057
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLimit                                                    OpcuaNodeIdServicesVariableNon = 10058
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowLimit                                                 OpcuaNodeIdServicesVariableNon = 10059
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventId                                                     OpcuaNodeIdServicesVariableNon = 10061
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventType                                                   OpcuaNodeIdServicesVariableNon = 10062
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceNode                                                  OpcuaNodeIdServicesVariableNon = 10063
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceName                                                  OpcuaNodeIdServicesVariableNon = 10064
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Time                                                        OpcuaNodeIdServicesVariableNon = 10065
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReceiveTime                                                 OpcuaNodeIdServicesVariableNon = 10066
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LocalTime                                                   OpcuaNodeIdServicesVariableNon = 10067
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Message                                                     OpcuaNodeIdServicesVariableNon = 10068
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Severity                                                    OpcuaNodeIdServicesVariableNon = 10069
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionName                                               OpcuaNodeIdServicesVariableNon = 10070
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BranchId                                                    OpcuaNodeIdServicesVariableNon = 10071
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Retain                                                      OpcuaNodeIdServicesVariableNon = 10072
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState                                                OpcuaNodeIdServicesVariableNon = 10073
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Id                                             OpcuaNodeIdServicesVariableNon = 10074
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Name                                           OpcuaNodeIdServicesVariableNon = 10075
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Number                                         OpcuaNodeIdServicesVariableNon = 10076
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 10077
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 10078
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 10079
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TrueState                                      OpcuaNodeIdServicesVariableNon = 10080
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_FalseState                                     OpcuaNodeIdServicesVariableNon = 10081
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality                                                     OpcuaNodeIdServicesVariableNon = 10082
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality_SourceTimestamp                                     OpcuaNodeIdServicesVariableNon = 10083
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity                                                OpcuaNodeIdServicesVariableNon = 10084
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp                                OpcuaNodeIdServicesVariableNon = 10085
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment                                                     OpcuaNodeIdServicesVariableNon = 10086
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment_SourceTimestamp                                     OpcuaNodeIdServicesVariableNon = 10087
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ClientUserId                                                OpcuaNodeIdServicesVariableNon = 10088
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AddComment_InputArguments                                   OpcuaNodeIdServicesVariableNon = 10092
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments                             OpcuaNodeIdServicesVariableNon = 10094
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState                                                  OpcuaNodeIdServicesVariableNon = 10095
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Id                                               OpcuaNodeIdServicesVariableNon = 10096
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Name                                             OpcuaNodeIdServicesVariableNon = 10097
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Number                                           OpcuaNodeIdServicesVariableNon = 10098
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName                             OpcuaNodeIdServicesVariableNon = 10099
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TransitionTime                                   OpcuaNodeIdServicesVariableNon = 10100
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime                          OpcuaNodeIdServicesVariableNon = 10101
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TrueState                                        OpcuaNodeIdServicesVariableNon = 10102
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_FalseState                                       OpcuaNodeIdServicesVariableNon = 10103
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState                                              OpcuaNodeIdServicesVariableNon = 10104
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Id                                           OpcuaNodeIdServicesVariableNon = 10105
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Name                                         OpcuaNodeIdServicesVariableNon = 10106
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Number                                       OpcuaNodeIdServicesVariableNon = 10107
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableNon = 10108
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime                               OpcuaNodeIdServicesVariableNon = 10109
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableNon = 10110
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TrueState                                    OpcuaNodeIdServicesVariableNon = 10111
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_FalseState                                   OpcuaNodeIdServicesVariableNon = 10112
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Acknowledge_InputArguments                                  OpcuaNodeIdServicesVariableNon = 10114
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Confirm_InputArguments                                      OpcuaNodeIdServicesVariableNon = 10116
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState                                                 OpcuaNodeIdServicesVariableNon = 10117
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Id                                              OpcuaNodeIdServicesVariableNon = 10118
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Name                                            OpcuaNodeIdServicesVariableNon = 10119
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Number                                          OpcuaNodeIdServicesVariableNon = 10120
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableNon = 10121
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TransitionTime                                  OpcuaNodeIdServicesVariableNon = 10122
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableNon = 10123
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TrueState                                       OpcuaNodeIdServicesVariableNon = 10124
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_FalseState                                      OpcuaNodeIdServicesVariableNon = 10125
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState                                             OpcuaNodeIdServicesVariableNon = 10126
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Id                                          OpcuaNodeIdServicesVariableNon = 10127
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Name                                        OpcuaNodeIdServicesVariableNon = 10128
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Number                                      OpcuaNodeIdServicesVariableNon = 10129
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableNon = 10130
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TransitionTime                              OpcuaNodeIdServicesVariableNon = 10131
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableNon = 10132
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TrueState                                   OpcuaNodeIdServicesVariableNon = 10133
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_FalseState                                  OpcuaNodeIdServicesVariableNon = 10134
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState                                  OpcuaNodeIdServicesVariableNon = 10136
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id                               OpcuaNodeIdServicesVariableNon = 10137
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name                             OpcuaNodeIdServicesVariableNon = 10138
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number                           OpcuaNodeIdServicesVariableNon = 10139
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName             OpcuaNodeIdServicesVariableNon = 10140
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition                                OpcuaNodeIdServicesVariableNon = 10141
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id                             OpcuaNodeIdServicesVariableNon = 10142
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name                           OpcuaNodeIdServicesVariableNon = 10143
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number                         OpcuaNodeIdServicesVariableNon = 10144
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime                 OpcuaNodeIdServicesVariableNon = 10145
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime                                  OpcuaNodeIdServicesVariableNon = 10146
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments                    OpcuaNodeIdServicesVariableNon = 10171
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedOrShelved                                         OpcuaNodeIdServicesVariableNon = 10172
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_MaxTimeShelved                                              OpcuaNodeIdServicesVariableNon = 10173
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState                                               OpcuaNodeIdServicesVariableNon = 10174
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Id                                            OpcuaNodeIdServicesVariableNon = 10175
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Name                                          OpcuaNodeIdServicesVariableNon = 10176
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Number                                        OpcuaNodeIdServicesVariableNon = 10177
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableNon = 10178
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TransitionTime                                OpcuaNodeIdServicesVariableNon = 10179
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableNon = 10180
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TrueState                                     OpcuaNodeIdServicesVariableNon = 10181
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_FalseState                                    OpcuaNodeIdServicesVariableNon = 10182
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState                                                   OpcuaNodeIdServicesVariableNon = 10183
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Id                                                OpcuaNodeIdServicesVariableNon = 10184
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Name                                              OpcuaNodeIdServicesVariableNon = 10185
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Number                                            OpcuaNodeIdServicesVariableNon = 10186
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName                              OpcuaNodeIdServicesVariableNon = 10187
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TransitionTime                                    OpcuaNodeIdServicesVariableNon = 10188
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime                           OpcuaNodeIdServicesVariableNon = 10189
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TrueState                                         OpcuaNodeIdServicesVariableNon = 10190
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_FalseState                                        OpcuaNodeIdServicesVariableNon = 10191
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState                                                    OpcuaNodeIdServicesVariableNon = 10192
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Id                                                 OpcuaNodeIdServicesVariableNon = 10193
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Name                                               OpcuaNodeIdServicesVariableNon = 10194
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Number                                             OpcuaNodeIdServicesVariableNon = 10195
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName                               OpcuaNodeIdServicesVariableNon = 10196
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TransitionTime                                     OpcuaNodeIdServicesVariableNon = 10197
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime                            OpcuaNodeIdServicesVariableNon = 10198
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TrueState                                          OpcuaNodeIdServicesVariableNon = 10199
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_FalseState                                         OpcuaNodeIdServicesVariableNon = 10200
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState                                                 OpcuaNodeIdServicesVariableNon = 10201
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Id                                              OpcuaNodeIdServicesVariableNon = 10202
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Name                                            OpcuaNodeIdServicesVariableNon = 10203
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Number                                          OpcuaNodeIdServicesVariableNon = 10204
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableNon = 10205
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TransitionTime                                  OpcuaNodeIdServicesVariableNon = 10206
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableNon = 10207
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TrueState                                       OpcuaNodeIdServicesVariableNon = 10208
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_FalseState                                      OpcuaNodeIdServicesVariableNon = 10209
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighLimit                                               OpcuaNodeIdServicesVariableNon = 10210
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighLimit                                                   OpcuaNodeIdServicesVariableNon = 10211
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLimit                                                    OpcuaNodeIdServicesVariableNon = 10212
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowLimit                                                 OpcuaNodeIdServicesVariableNon = 10213
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventId                                              OpcuaNodeIdServicesVariableNon = 10215
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventType                                            OpcuaNodeIdServicesVariableNon = 10216
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableNon = 10217
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceName                                           OpcuaNodeIdServicesVariableNon = 10218
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Time                                                 OpcuaNodeIdServicesVariableNon = 10219
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableNon = 10220
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableNon = 10221
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Message                                              OpcuaNodeIdServicesVariableNon = 10222
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Severity                                             OpcuaNodeIdServicesVariableNon = 10223
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableNon = 10224
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BranchId                                             OpcuaNodeIdServicesVariableNon = 10225
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Retain                                               OpcuaNodeIdServicesVariableNon = 10226
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableNon = 10227
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableNon = 10228
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableNon = 10229
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableNon = 10230
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableNon = 10231
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableNon = 10232
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableNon = 10233
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableNon = 10234
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableNon = 10235
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality                                              OpcuaNodeIdServicesVariableNon = 10236
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableNon = 10237
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableNon = 10238
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableNon = 10239
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment                                              OpcuaNodeIdServicesVariableNon = 10240
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableNon = 10241
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableNon = 10242
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableNon = 10246
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableNon = 10248
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState                                           OpcuaNodeIdServicesVariableNon = 10249
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableNon = 10250
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableNon = 10251
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableNon = 10252
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableNon = 10253
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableNon = 10254
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableNon = 10255
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableNon = 10256
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableNon = 10257
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableNon = 10258
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableNon = 10259
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableNon = 10260
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableNon = 10261
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableNon = 10262
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableNon = 10263
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableNon = 10264
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableNon = 10265
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableNon = 10266
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableNon = 10268
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableNon = 10270
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableNon = 10271
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableNon = 10272
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableNon = 10273
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableNon = 10274
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableNon = 10275
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableNon = 10276
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableNon = 10277
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableNon = 10278
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableNon = 10279
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableNon = 10280
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableNon = 10281
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableNon = 10282
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableNon = 10283
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableNon = 10284
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableNon = 10285
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableNon = 10286
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableNon = 10287
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableNon = 10288
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableNon = 10290
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableNon = 10291
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableNon = 10292
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableNon = 10293
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableNon = 10294
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableNon = 10295
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableNon = 10296
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableNon = 10297
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableNon = 10298
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableNon = 10299
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableNon = 10300
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableNon = 10325
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableNon = 10326
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableNon = 10327
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState                                        OpcuaNodeIdServicesVariableNon = 10328
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Id                                     OpcuaNodeIdServicesVariableNon = 10329
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Name                                   OpcuaNodeIdServicesVariableNon = 10330
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Number                                 OpcuaNodeIdServicesVariableNon = 10331
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableNon = 10332
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime                         OpcuaNodeIdServicesVariableNon = 10333
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableNon = 10334
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState                              OpcuaNodeIdServicesVariableNon = 10335
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState                             OpcuaNodeIdServicesVariableNon = 10336
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState                                            OpcuaNodeIdServicesVariableNon = 10337
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Id                                         OpcuaNodeIdServicesVariableNon = 10338
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Name                                       OpcuaNodeIdServicesVariableNon = 10339
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Number                                     OpcuaNodeIdServicesVariableNon = 10340
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableNon = 10341
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime                             OpcuaNodeIdServicesVariableNon = 10342
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableNon = 10343
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TrueState                                  OpcuaNodeIdServicesVariableNon = 10344
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_FalseState                                 OpcuaNodeIdServicesVariableNon = 10345
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState                                             OpcuaNodeIdServicesVariableNon = 10346
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Id                                          OpcuaNodeIdServicesVariableNon = 10347
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Name                                        OpcuaNodeIdServicesVariableNon = 10348
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Number                                      OpcuaNodeIdServicesVariableNon = 10349
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableNon = 10350
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime                              OpcuaNodeIdServicesVariableNon = 10351
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableNon = 10352
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TrueState                                   OpcuaNodeIdServicesVariableNon = 10353
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_FalseState                                  OpcuaNodeIdServicesVariableNon = 10354
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState                                          OpcuaNodeIdServicesVariableNon = 10355
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Id                                       OpcuaNodeIdServicesVariableNon = 10356
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Name                                     OpcuaNodeIdServicesVariableNon = 10357
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Number                                   OpcuaNodeIdServicesVariableNon = 10358
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableNon = 10359
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime                           OpcuaNodeIdServicesVariableNon = 10360
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableNon = 10361
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState                                OpcuaNodeIdServicesVariableNon = 10362
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState                               OpcuaNodeIdServicesVariableNon = 10363
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighLimit                                        OpcuaNodeIdServicesVariableNon = 10364
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighLimit                                            OpcuaNodeIdServicesVariableNon = 10365
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLimit                                             OpcuaNodeIdServicesVariableNon = 10366
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowLimit                                          OpcuaNodeIdServicesVariableNon = 10367
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventId                                                 OpcuaNodeIdServicesVariableNon = 10369
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventType                                               OpcuaNodeIdServicesVariableNon = 10370
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceNode                                              OpcuaNodeIdServicesVariableNon = 10371
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceName                                              OpcuaNodeIdServicesVariableNon = 10372
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Time                                                    OpcuaNodeIdServicesVariableNon = 10373
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReceiveTime                                             OpcuaNodeIdServicesVariableNon = 10374
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LocalTime                                               OpcuaNodeIdServicesVariableNon = 10375
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Message                                                 OpcuaNodeIdServicesVariableNon = 10376
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Severity                                                OpcuaNodeIdServicesVariableNon = 10377
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionName                                           OpcuaNodeIdServicesVariableNon = 10378
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BranchId                                                OpcuaNodeIdServicesVariableNon = 10379
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Retain                                                  OpcuaNodeIdServicesVariableNon = 10380
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState                                            OpcuaNodeIdServicesVariableNon = 10381
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Id                                         OpcuaNodeIdServicesVariableNon = 10382
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Name                                       OpcuaNodeIdServicesVariableNon = 10383
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Number                                     OpcuaNodeIdServicesVariableNon = 10384
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableNon = 10385
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TransitionTime                             OpcuaNodeIdServicesVariableNon = 10386
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableNon = 10387
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TrueState                                  OpcuaNodeIdServicesVariableNon = 10388
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_FalseState                                 OpcuaNodeIdServicesVariableNon = 10389
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality                                                 OpcuaNodeIdServicesVariableNon = 10390
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp                                 OpcuaNodeIdServicesVariableNon = 10391
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity                                            OpcuaNodeIdServicesVariableNon = 10392
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp                            OpcuaNodeIdServicesVariableNon = 10393
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment                                                 OpcuaNodeIdServicesVariableNon = 10394
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp                                 OpcuaNodeIdServicesVariableNon = 10395
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ClientUserId                                            OpcuaNodeIdServicesVariableNon = 10396
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AddComment_InputArguments                               OpcuaNodeIdServicesVariableNon = 10400
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments                         OpcuaNodeIdServicesVariableNon = 10402
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState                                              OpcuaNodeIdServicesVariableNon = 10403
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Id                                           OpcuaNodeIdServicesVariableNon = 10404
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Name                                         OpcuaNodeIdServicesVariableNon = 10405
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Number                                       OpcuaNodeIdServicesVariableNon = 10406
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName                         OpcuaNodeIdServicesVariableNon = 10407
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TransitionTime                               OpcuaNodeIdServicesVariableNon = 10408
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime                      OpcuaNodeIdServicesVariableNon = 10409
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TrueState                                    OpcuaNodeIdServicesVariableNon = 10410
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_FalseState                                   OpcuaNodeIdServicesVariableNon = 10411
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState                                          OpcuaNodeIdServicesVariableNon = 10412
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Id                                       OpcuaNodeIdServicesVariableNon = 10413
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Name                                     OpcuaNodeIdServicesVariableNon = 10414
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Number                                   OpcuaNodeIdServicesVariableNon = 10415
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableNon = 10416
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime                           OpcuaNodeIdServicesVariableNon = 10417
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableNon = 10418
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TrueState                                OpcuaNodeIdServicesVariableNon = 10419
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_FalseState                               OpcuaNodeIdServicesVariableNon = 10420
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments                              OpcuaNodeIdServicesVariableNon = 10422
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Confirm_InputArguments                                  OpcuaNodeIdServicesVariableNon = 10424
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState                                             OpcuaNodeIdServicesVariableNon = 10425
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Id                                          OpcuaNodeIdServicesVariableNon = 10426
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Name                                        OpcuaNodeIdServicesVariableNon = 10427
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Number                                      OpcuaNodeIdServicesVariableNon = 10428
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableNon = 10429
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TransitionTime                              OpcuaNodeIdServicesVariableNon = 10430
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableNon = 10431
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TrueState                                   OpcuaNodeIdServicesVariableNon = 10432
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_FalseState                                  OpcuaNodeIdServicesVariableNon = 10433
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState                                         OpcuaNodeIdServicesVariableNon = 10434
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Id                                      OpcuaNodeIdServicesVariableNon = 10435
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Name                                    OpcuaNodeIdServicesVariableNon = 10436
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Number                                  OpcuaNodeIdServicesVariableNon = 10437
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableNon = 10438
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime                          OpcuaNodeIdServicesVariableNon = 10439
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableNon = 10440
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TrueState                               OpcuaNodeIdServicesVariableNon = 10441
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_FalseState                              OpcuaNodeIdServicesVariableNon = 10442
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState                              OpcuaNodeIdServicesVariableNon = 10444
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id                           OpcuaNodeIdServicesVariableNon = 10445
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name                         OpcuaNodeIdServicesVariableNon = 10446
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number                       OpcuaNodeIdServicesVariableNon = 10447
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName         OpcuaNodeIdServicesVariableNon = 10448
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition                            OpcuaNodeIdServicesVariableNon = 10449
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id                         OpcuaNodeIdServicesVariableNon = 10450
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name                       OpcuaNodeIdServicesVariableNon = 10451
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number                     OpcuaNodeIdServicesVariableNon = 10452
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime             OpcuaNodeIdServicesVariableNon = 10453
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime                              OpcuaNodeIdServicesVariableNon = 10454
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments                OpcuaNodeIdServicesVariableNon = 10479
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedOrShelved                                     OpcuaNodeIdServicesVariableNon = 10480
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_MaxTimeShelved                                          OpcuaNodeIdServicesVariableNon = 10481
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState                                           OpcuaNodeIdServicesVariableNon = 10482
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Id                                        OpcuaNodeIdServicesVariableNon = 10483
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Name                                      OpcuaNodeIdServicesVariableNon = 10484
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Number                                    OpcuaNodeIdServicesVariableNon = 10485
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableNon = 10486
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TransitionTime                            OpcuaNodeIdServicesVariableNon = 10487
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableNon = 10488
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TrueState                                 OpcuaNodeIdServicesVariableNon = 10489
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_FalseState                                OpcuaNodeIdServicesVariableNon = 10490
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState                                               OpcuaNodeIdServicesVariableNon = 10491
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Id                                            OpcuaNodeIdServicesVariableNon = 10492
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Name                                          OpcuaNodeIdServicesVariableNon = 10493
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Number                                        OpcuaNodeIdServicesVariableNon = 10494
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableNon = 10495
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TransitionTime                                OpcuaNodeIdServicesVariableNon = 10496
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableNon = 10497
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TrueState                                     OpcuaNodeIdServicesVariableNon = 10498
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_FalseState                                    OpcuaNodeIdServicesVariableNon = 10499
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState                                                OpcuaNodeIdServicesVariableNon = 10500
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Id                                             OpcuaNodeIdServicesVariableNon = 10501
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Name                                           OpcuaNodeIdServicesVariableNon = 10502
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Number                                         OpcuaNodeIdServicesVariableNon = 10503
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 10504
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 10505
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 10506
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TrueState                                      OpcuaNodeIdServicesVariableNon = 10507
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_FalseState                                     OpcuaNodeIdServicesVariableNon = 10508
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState                                             OpcuaNodeIdServicesVariableNon = 10509
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Id                                          OpcuaNodeIdServicesVariableNon = 10510
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Name                                        OpcuaNodeIdServicesVariableNon = 10511
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Number                                      OpcuaNodeIdServicesVariableNon = 10512
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableNon = 10513
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TransitionTime                              OpcuaNodeIdServicesVariableNon = 10514
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableNon = 10515
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TrueState                                   OpcuaNodeIdServicesVariableNon = 10516
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_FalseState                                  OpcuaNodeIdServicesVariableNon = 10517
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighLimit                                           OpcuaNodeIdServicesVariableNon = 10518
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighLimit                                               OpcuaNodeIdServicesVariableNon = 10519
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLimit                                                OpcuaNodeIdServicesVariableNon = 10520
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowLimit                                             OpcuaNodeIdServicesVariableNon = 10521
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode                                            OpcuaNodeIdServicesVariableNon = 10522
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassId                                            OpcuaNodeIdServicesVariableNon = 11140
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassName                                          OpcuaNodeIdServicesVariableNon = 11141
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_InputNode                                                   OpcuaNodeIdServicesVariableNon = 11142
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassId                                            OpcuaNodeIdServicesVariableNon = 11143
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassName                                          OpcuaNodeIdServicesVariableNon = 11144
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_InputNode                                                   OpcuaNodeIdServicesVariableNon = 11145
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableNon = 11146
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableNon = 11147
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_InputNode                                            OpcuaNodeIdServicesVariableNon = 11148
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassId                                        OpcuaNodeIdServicesVariableNon = 11149
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassName                                      OpcuaNodeIdServicesVariableNon = 11150
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_InputNode                                               OpcuaNodeIdServicesVariableNon = 11151
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime        OpcuaNodeIdServicesVariableNon = 11477
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime        OpcuaNodeIdServicesVariableNon = 11478
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableNon = 11479
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime    OpcuaNodeIdServicesVariableNon = 11480
	OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_RedundancySupport                                  OpcuaNodeIdServicesVariableNon = 11946
	OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerUriArray                                     OpcuaNodeIdServicesVariableNon = 11947
	OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups                                OpcuaNodeIdServicesVariableNon = 11948
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments                            OpcuaNodeIdServicesVariableNon = 12991
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments                            OpcuaNodeIdServicesVariableNon = 12993
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments                        OpcuaNodeIdServicesVariableNon = 12997
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableNon = 13001
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassId                                         OpcuaNodeIdServicesVariableNon = 16616
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassName                                       OpcuaNodeIdServicesVariableNon = 16617
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState                                           OpcuaNodeIdServicesVariableNon = 16618
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Id                                        OpcuaNodeIdServicesVariableNon = 16619
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Name                                      OpcuaNodeIdServicesVariableNon = 16620
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Number                                    OpcuaNodeIdServicesVariableNon = 16621
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableNon = 16622
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime                            OpcuaNodeIdServicesVariableNon = 16623
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableNon = 16624
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TrueState                                 OpcuaNodeIdServicesVariableNon = 16625
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_FalseState                                OpcuaNodeIdServicesVariableNon = 16626
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState                                                OpcuaNodeIdServicesVariableNon = 16627
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Id                                             OpcuaNodeIdServicesVariableNon = 16628
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Name                                           OpcuaNodeIdServicesVariableNon = 16629
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Number                                         OpcuaNodeIdServicesVariableNon = 16630
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 16631
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 16632
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 16633
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TrueState                                      OpcuaNodeIdServicesVariableNon = 16634
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_FalseState                                     OpcuaNodeIdServicesVariableNon = 16635
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleEnabled                                              OpcuaNodeIdServicesVariableNon = 16636
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound                                                OpcuaNodeIdServicesVariableNon = 16637
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OnDelay                                                     OpcuaNodeIdServicesVariableNon = 16642
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OffDelay                                                    OpcuaNodeIdServicesVariableNon = 16643
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_FirstInGroupFlag                                            OpcuaNodeIdServicesVariableNon = 16644
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmTime                                                 OpcuaNodeIdServicesVariableNon = 16647
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmRepeatCount                                          OpcuaNodeIdServicesVariableNon = 16648
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighHighLimit                                           OpcuaNodeIdServicesVariableNon = 16652
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighLimit                                               OpcuaNodeIdServicesVariableNon = 16653
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLimit                                                OpcuaNodeIdServicesVariableNon = 16654
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLowLimit                                             OpcuaNodeIdServicesVariableNon = 16655
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassId                                         OpcuaNodeIdServicesVariableNon = 16656
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassName                                       OpcuaNodeIdServicesVariableNon = 16657
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState                                           OpcuaNodeIdServicesVariableNon = 16658
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Id                                        OpcuaNodeIdServicesVariableNon = 16659
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Name                                      OpcuaNodeIdServicesVariableNon = 16660
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Number                                    OpcuaNodeIdServicesVariableNon = 16661
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableNon = 16662
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime                            OpcuaNodeIdServicesVariableNon = 16663
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableNon = 16664
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TrueState                                 OpcuaNodeIdServicesVariableNon = 16665
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_FalseState                                OpcuaNodeIdServicesVariableNon = 16666
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState                                                OpcuaNodeIdServicesVariableNon = 16667
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Id                                             OpcuaNodeIdServicesVariableNon = 16668
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Name                                           OpcuaNodeIdServicesVariableNon = 16669
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Number                                         OpcuaNodeIdServicesVariableNon = 16670
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 16671
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 16672
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 16673
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TrueState                                      OpcuaNodeIdServicesVariableNon = 16674
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_FalseState                                     OpcuaNodeIdServicesVariableNon = 16675
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleEnabled                                              OpcuaNodeIdServicesVariableNon = 16676
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound                                                OpcuaNodeIdServicesVariableNon = 16677
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OnDelay                                                     OpcuaNodeIdServicesVariableNon = 16682
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OffDelay                                                    OpcuaNodeIdServicesVariableNon = 16683
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_FirstInGroupFlag                                            OpcuaNodeIdServicesVariableNon = 16684
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmTime                                                 OpcuaNodeIdServicesVariableNon = 16687
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmRepeatCount                                          OpcuaNodeIdServicesVariableNon = 16688
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighHighLimit                                           OpcuaNodeIdServicesVariableNon = 16692
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighLimit                                               OpcuaNodeIdServicesVariableNon = 16693
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLimit                                                OpcuaNodeIdServicesVariableNon = 16694
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLowLimit                                             OpcuaNodeIdServicesVariableNon = 16695
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassId                                     OpcuaNodeIdServicesVariableNon = 16736
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassName                                   OpcuaNodeIdServicesVariableNon = 16737
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState                                       OpcuaNodeIdServicesVariableNon = 16738
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Id                                    OpcuaNodeIdServicesVariableNon = 16739
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Name                                  OpcuaNodeIdServicesVariableNon = 16740
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Number                                OpcuaNodeIdServicesVariableNon = 16741
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableNon = 16742
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime                        OpcuaNodeIdServicesVariableNon = 16743
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableNon = 16744
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState                             OpcuaNodeIdServicesVariableNon = 16745
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState                            OpcuaNodeIdServicesVariableNon = 16746
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState                                            OpcuaNodeIdServicesVariableNon = 16747
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Id                                         OpcuaNodeIdServicesVariableNon = 16748
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Name                                       OpcuaNodeIdServicesVariableNon = 16749
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Number                                     OpcuaNodeIdServicesVariableNon = 16750
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableNon = 16751
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TransitionTime                             OpcuaNodeIdServicesVariableNon = 16752
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableNon = 16753
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TrueState                                  OpcuaNodeIdServicesVariableNon = 16754
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_FalseState                                 OpcuaNodeIdServicesVariableNon = 16755
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleEnabled                                          OpcuaNodeIdServicesVariableNon = 16756
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound                                            OpcuaNodeIdServicesVariableNon = 16757
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OnDelay                                                 OpcuaNodeIdServicesVariableNon = 16762
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OffDelay                                                OpcuaNodeIdServicesVariableNon = 16763
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_FirstInGroupFlag                                        OpcuaNodeIdServicesVariableNon = 16764
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmTime                                             OpcuaNodeIdServicesVariableNon = 16767
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmRepeatCount                                      OpcuaNodeIdServicesVariableNon = 16768
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighHighLimit                                       OpcuaNodeIdServicesVariableNon = 16772
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighLimit                                           OpcuaNodeIdServicesVariableNon = 16773
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLimit                                            OpcuaNodeIdServicesVariableNon = 16774
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLowLimit                                         OpcuaNodeIdServicesVariableNon = 16775
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode                                        OpcuaNodeIdServicesVariableNon = 16776
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableNon = 16818
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableNon = 16819
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableNon = 16820
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableNon = 16821
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableNon = 16822
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableNon = 16823
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableNon = 16824
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableNon = 16825
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableNon = 16826
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableNon = 16827
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableNon = 16828
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableNon = 16829
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableNon = 16830
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableNon = 16831
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableNon = 16832
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableNon = 16833
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableNon = 16834
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableNon = 16835
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableNon = 16836
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableNon = 16837
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableNon = 16838
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableNon = 16839
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableNon = 16844
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableNon = 16845
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableNon = 16846
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableNon = 16849
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableNon = 16850
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit                                    OpcuaNodeIdServicesVariableNon = 16854
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighLimit                                        OpcuaNodeIdServicesVariableNon = 16855
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLimit                                         OpcuaNodeIdServicesVariableNon = 16856
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit                                      OpcuaNodeIdServicesVariableNon = 16857
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits                                     OpcuaNodeIdServicesVariableNon = 16858
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableStates                               OpcuaNodeIdServicesVariableNon = 17672
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions                          OpcuaNodeIdServicesVariableNon = 17673
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableStates                               OpcuaNodeIdServicesVariableNon = 17674
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions                          OpcuaNodeIdServicesVariableNon = 17675
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates                           OpcuaNodeIdServicesVariableNon = 17680
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions                      OpcuaNodeIdServicesVariableNon = 17681
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableNon = 17686
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableNon = 17687
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_ListId                                         OpcuaNodeIdServicesVariableNon = 17893
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_AgencyId                                       OpcuaNodeIdServicesVariableNon = 17894
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_VersionId                                      OpcuaNodeIdServicesVariableNon = 17895
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_ListId                                     OpcuaNodeIdServicesVariableNon = 17914
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_AgencyId                                   OpcuaNodeIdServicesVariableNon = 17915
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_VersionId                                  OpcuaNodeIdServicesVariableNon = 17916
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableNon = 17921
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableNon = 17922
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableNon = 17923
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState                                                OpcuaNodeIdServicesVariableNon = 18233
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Id                                             OpcuaNodeIdServicesVariableNon = 18234
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Name                                           OpcuaNodeIdServicesVariableNon = 18235
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Number                                         OpcuaNodeIdServicesVariableNon = 18236
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 18237
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 18238
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 18239
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TrueState                                      OpcuaNodeIdServicesVariableNon = 18240
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_FalseState                                     OpcuaNodeIdServicesVariableNon = 18241
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_ListId                                         OpcuaNodeIdServicesVariableNon = 18243
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_AgencyId                                       OpcuaNodeIdServicesVariableNon = 18244
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_VersionId                                      OpcuaNodeIdServicesVariableNon = 18245
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState                                                OpcuaNodeIdServicesVariableNon = 18246
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Id                                             OpcuaNodeIdServicesVariableNon = 18247
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Name                                           OpcuaNodeIdServicesVariableNon = 18248
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Number                                         OpcuaNodeIdServicesVariableNon = 18249
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableNon = 18250
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TransitionTime                                 OpcuaNodeIdServicesVariableNon = 18251
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableNon = 18252
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TrueState                                      OpcuaNodeIdServicesVariableNon = 18253
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_FalseState                                     OpcuaNodeIdServicesVariableNon = 18254
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState                                            OpcuaNodeIdServicesVariableNon = 18267
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Id                                         OpcuaNodeIdServicesVariableNon = 18268
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Name                                       OpcuaNodeIdServicesVariableNon = 18269
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Number                                     OpcuaNodeIdServicesVariableNon = 18270
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableNon = 18271
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TransitionTime                             OpcuaNodeIdServicesVariableNon = 18272
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableNon = 18273
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TrueState                                  OpcuaNodeIdServicesVariableNon = 18274
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_FalseState                                 OpcuaNodeIdServicesVariableNon = 18275
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableNon = 18277
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableNon = 18278
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableNon = 18279
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableNon = 18280
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableNon = 18281
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableNon = 18282
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableNon = 18283
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableNon = 18284
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableNon = 18285
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Suppress2_InputArguments                                    OpcuaNodeIdServicesVariableNon = 24359
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments                                  OpcuaNodeIdServicesVariableNon = 24361
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments                           OpcuaNodeIdServicesVariableNon = 24363
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments                              OpcuaNodeIdServicesVariableNon = 24365
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Reset2_InputArguments                                       OpcuaNodeIdServicesVariableNon = 24367
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Suppress2_InputArguments                                    OpcuaNodeIdServicesVariableNon = 24369
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments                                  OpcuaNodeIdServicesVariableNon = 24371
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments                           OpcuaNodeIdServicesVariableNon = 24373
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments                              OpcuaNodeIdServicesVariableNon = 24375
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Reset2_InputArguments                                       OpcuaNodeIdServicesVariableNon = 24377
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Suppress2_InputArguments                                OpcuaNodeIdServicesVariableNon = 24389
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments                              OpcuaNodeIdServicesVariableNon = 24391
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments                       OpcuaNodeIdServicesVariableNon = 24393
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments                          OpcuaNodeIdServicesVariableNon = 24395
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Reset2_InputArguments                                   OpcuaNodeIdServicesVariableNon = 24397
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableNon = 24399
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableNon = 24401
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableNon = 24403
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableNon = 24405
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableNon = 24407
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments                   OpcuaNodeIdServicesVariableNon = 24795
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments                      OpcuaNodeIdServicesVariableNon = 24797
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments                 OpcuaNodeIdServicesVariableNon = 24799
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHighHigh                                            OpcuaNodeIdServicesVariableNon = 24802
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHigh                                                OpcuaNodeIdServicesVariableNon = 24803
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLow                                                 OpcuaNodeIdServicesVariableNon = 24804
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLowLow                                              OpcuaNodeIdServicesVariableNon = 24805
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighDeadband                                            OpcuaNodeIdServicesVariableNon = 24806
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighDeadband                                                OpcuaNodeIdServicesVariableNon = 24807
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowDeadband                                                 OpcuaNodeIdServicesVariableNon = 24808
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowDeadband                                              OpcuaNodeIdServicesVariableNon = 24809
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments                   OpcuaNodeIdServicesVariableNon = 24811
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments                      OpcuaNodeIdServicesVariableNon = 24813
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments                 OpcuaNodeIdServicesVariableNon = 24815
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHighHigh                                            OpcuaNodeIdServicesVariableNon = 24818
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHigh                                                OpcuaNodeIdServicesVariableNon = 24819
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLow                                                 OpcuaNodeIdServicesVariableNon = 24820
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLowLow                                              OpcuaNodeIdServicesVariableNon = 24821
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighDeadband                                            OpcuaNodeIdServicesVariableNon = 24822
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighDeadband                                                OpcuaNodeIdServicesVariableNon = 24823
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowDeadband                                                 OpcuaNodeIdServicesVariableNon = 24824
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowDeadband                                              OpcuaNodeIdServicesVariableNon = 24825
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments               OpcuaNodeIdServicesVariableNon = 24843
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments                  OpcuaNodeIdServicesVariableNon = 24845
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments             OpcuaNodeIdServicesVariableNon = 24847
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHighHigh                                        OpcuaNodeIdServicesVariableNon = 24850
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHigh                                            OpcuaNodeIdServicesVariableNon = 24851
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLow                                             OpcuaNodeIdServicesVariableNon = 24852
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLowLow                                          OpcuaNodeIdServicesVariableNon = 24853
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighDeadband                                        OpcuaNodeIdServicesVariableNon = 24854
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighDeadband                                            OpcuaNodeIdServicesVariableNon = 24855
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowDeadband                                             OpcuaNodeIdServicesVariableNon = 24856
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowDeadband                                          OpcuaNodeIdServicesVariableNon = 24857
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableNon = 24859
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableNon = 24861
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableNon = 24863
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHighHigh                                     OpcuaNodeIdServicesVariableNon = 24866
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHigh                                         OpcuaNodeIdServicesVariableNon = 24867
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLow                                          OpcuaNodeIdServicesVariableNon = 24868
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLowLow                                       OpcuaNodeIdServicesVariableNon = 24869
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighDeadband                                     OpcuaNodeIdServicesVariableNon = 24870
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighDeadband                                         OpcuaNodeIdServicesVariableNon = 24871
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowDeadband                                          OpcuaNodeIdServicesVariableNon = 24872
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowDeadband                                       OpcuaNodeIdServicesVariableNon = 24873
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments                         OpcuaNodeIdServicesVariableNon = 25161
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments                         OpcuaNodeIdServicesVariableNon = 25162
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments                     OpcuaNodeIdServicesVariableNon = 25164
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableNon = 25165
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SupportsFilteredRetain                                      OpcuaNodeIdServicesVariableNon = 32229
	OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SupportsFilteredRetain                                      OpcuaNodeIdServicesVariableNon = 32230
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SupportsFilteredRetain                                  OpcuaNodeIdServicesVariableNon = 32232
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableNon = 32233
)

var OpcuaNodeIdServicesVariableNonValues []OpcuaNodeIdServicesVariableNon

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableNonValues = []OpcuaNodeIdServicesVariableNon{
		OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray,
		OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_RedundancySupport,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventType,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Time,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Message,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Severity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BranchId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Retain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventType,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Time,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Message,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Severity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BranchId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Retain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventType,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Time,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Message,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Severity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BranchId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Retain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventType,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Time,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Message,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Severity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BranchId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Retain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_InputNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_InputNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_InputNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_InputNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_RedundancySupport,
		OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerUriArray,
		OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHighHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHigh,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLowLow,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowDeadband,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SupportsFilteredRetain,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableNonByValue(value int32) (enum OpcuaNodeIdServicesVariableNon, ok bool) {
	switch value {
	case 10017:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10018:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedOrShelved, true
	case 10019:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_MaxTimeShelved, true
	case 10020:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState, true
	case 10021:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id, true
	case 10022:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name, true
	case 10023:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number, true
	case 10024:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName, true
	case 10025:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime, true
	case 10026:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime, true
	case 10027:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState, true
	case 10028:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState, true
	case 10029:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState, true
	case 10030:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id, true
	case 10031:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name, true
	case 10032:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number, true
	case 10033:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName, true
	case 10034:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime, true
	case 10035:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime, true
	case 10036:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState, true
	case 10037:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState, true
	case 10038:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState, true
	case 10039:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id, true
	case 10040:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name, true
	case 10041:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number, true
	case 10042:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName, true
	case 10043:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime, true
	case 10044:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime, true
	case 10045:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState, true
	case 10046:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState, true
	case 10047:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState, true
	case 10048:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id, true
	case 10049:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name, true
	case 10050:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number, true
	case 10051:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName, true
	case 10052:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime, true
	case 10053:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime, true
	case 10054:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState, true
	case 10055:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState, true
	case 10056:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighLimit, true
	case 10057:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighLimit, true
	case 10058:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLimit, true
	case 10059:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowLimit, true
	case 10061:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventId, true
	case 10062:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventType, true
	case 10063:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceNode, true
	case 10064:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceName, true
	case 10065:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Time, true
	case 10066:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReceiveTime, true
	case 10067:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LocalTime, true
	case 10068:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Message, true
	case 10069:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Severity, true
	case 10070:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionName, true
	case 10071:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BranchId, true
	case 10072:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Retain, true
	case 10073:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState, true
	case 10074:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Id, true
	case 10075:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Name, true
	case 10076:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Number, true
	case 10077:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName, true
	case 10078:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TransitionTime, true
	case 10079:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime, true
	case 10080:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TrueState, true
	case 10081:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_FalseState, true
	case 10082:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality, true
	case 10083:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality_SourceTimestamp, true
	case 10084:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity, true
	case 10085:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp, true
	case 10086:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment, true
	case 10087:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment_SourceTimestamp, true
	case 10088:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ClientUserId, true
	case 10092:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AddComment_InputArguments, true
	case 10094:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments, true
	case 10095:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState, true
	case 10096:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Id, true
	case 10097:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Name, true
	case 10098:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Number, true
	case 10099:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName, true
	case 10100:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TransitionTime, true
	case 10101:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime, true
	case 10102:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TrueState, true
	case 10103:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_FalseState, true
	case 10104:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState, true
	case 10105:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Id, true
	case 10106:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Name, true
	case 10107:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Number, true
	case 10108:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 10109:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime, true
	case 10110:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 10111:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TrueState, true
	case 10112:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_FalseState, true
	case 10114:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Acknowledge_InputArguments, true
	case 10116:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Confirm_InputArguments, true
	case 10117:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState, true
	case 10118:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Id, true
	case 10119:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Name, true
	case 10120:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Number, true
	case 10121:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName, true
	case 10122:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TransitionTime, true
	case 10123:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime, true
	case 10124:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TrueState, true
	case 10125:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_FalseState, true
	case 10126:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState, true
	case 10127:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Id, true
	case 10128:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Name, true
	case 10129:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Number, true
	case 10130:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName, true
	case 10131:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TransitionTime, true
	case 10132:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 10133:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TrueState, true
	case 10134:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_FalseState, true
	case 10136:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState, true
	case 10137:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id, true
	case 10138:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name, true
	case 10139:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number, true
	case 10140:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 10141:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition, true
	case 10142:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id, true
	case 10143:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name, true
	case 10144:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number, true
	case 10145:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 10146:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime, true
	case 10171:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10172:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedOrShelved, true
	case 10173:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_MaxTimeShelved, true
	case 10174:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState, true
	case 10175:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Id, true
	case 10176:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Name, true
	case 10177:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Number, true
	case 10178:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName, true
	case 10179:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TransitionTime, true
	case 10180:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime, true
	case 10181:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TrueState, true
	case 10182:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_FalseState, true
	case 10183:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState, true
	case 10184:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Id, true
	case 10185:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Name, true
	case 10186:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Number, true
	case 10187:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName, true
	case 10188:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TransitionTime, true
	case 10189:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime, true
	case 10190:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TrueState, true
	case 10191:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_FalseState, true
	case 10192:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState, true
	case 10193:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Id, true
	case 10194:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Name, true
	case 10195:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Number, true
	case 10196:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName, true
	case 10197:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TransitionTime, true
	case 10198:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime, true
	case 10199:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TrueState, true
	case 10200:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_FalseState, true
	case 10201:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState, true
	case 10202:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Id, true
	case 10203:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Name, true
	case 10204:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Number, true
	case 10205:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName, true
	case 10206:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TransitionTime, true
	case 10207:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime, true
	case 10208:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TrueState, true
	case 10209:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_FalseState, true
	case 10210:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighLimit, true
	case 10211:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighLimit, true
	case 10212:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLimit, true
	case 10213:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowLimit, true
	case 10215:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventId, true
	case 10216:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventType, true
	case 10217:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceNode, true
	case 10218:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceName, true
	case 10219:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Time, true
	case 10220:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReceiveTime, true
	case 10221:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LocalTime, true
	case 10222:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Message, true
	case 10223:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Severity, true
	case 10224:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionName, true
	case 10225:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BranchId, true
	case 10226:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Retain, true
	case 10227:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState, true
	case 10228:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Id, true
	case 10229:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Name, true
	case 10230:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Number, true
	case 10231:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName, true
	case 10232:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime, true
	case 10233:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime, true
	case 10234:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState, true
	case 10235:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState, true
	case 10236:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality, true
	case 10237:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp, true
	case 10238:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity, true
	case 10239:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp, true
	case 10240:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment, true
	case 10241:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp, true
	case 10242:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ClientUserId, true
	case 10246:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments, true
	case 10248:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments, true
	case 10249:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState, true
	case 10250:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Id, true
	case 10251:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Name, true
	case 10252:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Number, true
	case 10253:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName, true
	case 10254:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime, true
	case 10255:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime, true
	case 10256:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TrueState, true
	case 10257:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_FalseState, true
	case 10258:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState, true
	case 10259:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id, true
	case 10260:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name, true
	case 10261:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number, true
	case 10262:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 10263:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime, true
	case 10264:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 10265:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState, true
	case 10266:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState, true
	case 10268:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments, true
	case 10270:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments, true
	case 10271:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState, true
	case 10272:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Id, true
	case 10273:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Name, true
	case 10274:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Number, true
	case 10275:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName, true
	case 10276:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime, true
	case 10277:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime, true
	case 10278:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState, true
	case 10279:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState, true
	case 10280:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState, true
	case 10281:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id, true
	case 10282:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Name, true
	case 10283:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Number, true
	case 10284:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName, true
	case 10285:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime, true
	case 10286:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 10287:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState, true
	case 10288:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState, true
	case 10290:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState, true
	case 10291:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id, true
	case 10292:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name, true
	case 10293:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number, true
	case 10294:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 10295:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition, true
	case 10296:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id, true
	case 10297:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name, true
	case 10298:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number, true
	case 10299:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 10300:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime, true
	case 10325:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10326:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved, true
	case 10327:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_MaxTimeShelved, true
	case 10328:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState, true
	case 10329:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Id, true
	case 10330:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Name, true
	case 10331:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Number, true
	case 10332:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName, true
	case 10333:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime, true
	case 10334:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime, true
	case 10335:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState, true
	case 10336:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState, true
	case 10337:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState, true
	case 10338:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Id, true
	case 10339:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Name, true
	case 10340:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Number, true
	case 10341:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName, true
	case 10342:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime, true
	case 10343:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime, true
	case 10344:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TrueState, true
	case 10345:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_FalseState, true
	case 10346:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState, true
	case 10347:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Id, true
	case 10348:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Name, true
	case 10349:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Number, true
	case 10350:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName, true
	case 10351:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime, true
	case 10352:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime, true
	case 10353:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TrueState, true
	case 10354:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_FalseState, true
	case 10355:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState, true
	case 10356:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Id, true
	case 10357:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Name, true
	case 10358:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Number, true
	case 10359:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName, true
	case 10360:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime, true
	case 10361:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime, true
	case 10362:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState, true
	case 10363:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState, true
	case 10364:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighLimit, true
	case 10365:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighLimit, true
	case 10366:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLimit, true
	case 10367:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowLimit, true
	case 10369:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventId, true
	case 10370:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventType, true
	case 10371:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceNode, true
	case 10372:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceName, true
	case 10373:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Time, true
	case 10374:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReceiveTime, true
	case 10375:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LocalTime, true
	case 10376:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Message, true
	case 10377:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Severity, true
	case 10378:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionName, true
	case 10379:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BranchId, true
	case 10380:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Retain, true
	case 10381:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState, true
	case 10382:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Id, true
	case 10383:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Name, true
	case 10384:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Number, true
	case 10385:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName, true
	case 10386:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TransitionTime, true
	case 10387:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime, true
	case 10388:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TrueState, true
	case 10389:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_FalseState, true
	case 10390:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality, true
	case 10391:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp, true
	case 10392:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity, true
	case 10393:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp, true
	case 10394:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment, true
	case 10395:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp, true
	case 10396:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ClientUserId, true
	case 10400:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AddComment_InputArguments, true
	case 10402:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments, true
	case 10403:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState, true
	case 10404:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Id, true
	case 10405:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Name, true
	case 10406:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Number, true
	case 10407:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName, true
	case 10408:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TransitionTime, true
	case 10409:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime, true
	case 10410:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TrueState, true
	case 10411:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_FalseState, true
	case 10412:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState, true
	case 10413:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Id, true
	case 10414:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Name, true
	case 10415:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Number, true
	case 10416:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 10417:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime, true
	case 10418:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 10419:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TrueState, true
	case 10420:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_FalseState, true
	case 10422:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments, true
	case 10424:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Confirm_InputArguments, true
	case 10425:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState, true
	case 10426:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Id, true
	case 10427:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Name, true
	case 10428:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Number, true
	case 10429:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName, true
	case 10430:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TransitionTime, true
	case 10431:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime, true
	case 10432:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TrueState, true
	case 10433:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_FalseState, true
	case 10434:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState, true
	case 10435:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Id, true
	case 10436:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Name, true
	case 10437:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Number, true
	case 10438:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName, true
	case 10439:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime, true
	case 10440:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 10441:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TrueState, true
	case 10442:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_FalseState, true
	case 10444:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState, true
	case 10445:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id, true
	case 10446:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name, true
	case 10447:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number, true
	case 10448:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 10449:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition, true
	case 10450:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id, true
	case 10451:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name, true
	case 10452:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number, true
	case 10453:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 10454:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime, true
	case 10479:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10480:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedOrShelved, true
	case 10481:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_MaxTimeShelved, true
	case 10482:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState, true
	case 10483:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Id, true
	case 10484:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Name, true
	case 10485:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Number, true
	case 10486:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName, true
	case 10487:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TransitionTime, true
	case 10488:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime, true
	case 10489:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TrueState, true
	case 10490:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_FalseState, true
	case 10491:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState, true
	case 10492:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Id, true
	case 10493:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Name, true
	case 10494:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Number, true
	case 10495:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName, true
	case 10496:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TransitionTime, true
	case 10497:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime, true
	case 10498:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TrueState, true
	case 10499:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_FalseState, true
	case 10500:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState, true
	case 10501:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Id, true
	case 10502:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Name, true
	case 10503:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Number, true
	case 10504:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName, true
	case 10505:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TransitionTime, true
	case 10506:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime, true
	case 10507:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TrueState, true
	case 10508:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_FalseState, true
	case 10509:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState, true
	case 10510:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Id, true
	case 10511:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Name, true
	case 10512:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Number, true
	case 10513:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName, true
	case 10514:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TransitionTime, true
	case 10515:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime, true
	case 10516:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TrueState, true
	case 10517:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_FalseState, true
	case 10518:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighLimit, true
	case 10519:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighLimit, true
	case 10520:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLimit, true
	case 10521:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowLimit, true
	case 10522:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode, true
	case 11140:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassId, true
	case 11141:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassName, true
	case 11142:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_InputNode, true
	case 11143:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassId, true
	case 11144:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassName, true
	case 11145:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_InputNode, true
	case 11146:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassId, true
	case 11147:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassName, true
	case 11148:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_InputNode, true
	case 11149:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassId, true
	case 11150:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassName, true
	case 11151:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_InputNode, true
	case 11477:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11478:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11479:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11480:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 11946:
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_RedundancySupport, true
	case 11947:
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerUriArray, true
	case 11948:
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups, true
	case 12991:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments, true
	case 12993:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments, true
	case 12997:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments, true
	case 13001:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments, true
	case 16616:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassId, true
	case 16617:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassName, true
	case 16618:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState, true
	case 16619:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Id, true
	case 16620:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Name, true
	case 16621:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Number, true
	case 16622:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16623:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime, true
	case 16624:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16625:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TrueState, true
	case 16626:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_FalseState, true
	case 16627:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState, true
	case 16628:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Id, true
	case 16629:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Name, true
	case 16630:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Number, true
	case 16631:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName, true
	case 16632:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TransitionTime, true
	case 16633:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16634:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TrueState, true
	case 16635:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_FalseState, true
	case 16636:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleEnabled, true
	case 16637:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound, true
	case 16642:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OnDelay, true
	case 16643:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OffDelay, true
	case 16644:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_FirstInGroupFlag, true
	case 16647:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmTime, true
	case 16648:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmRepeatCount, true
	case 16652:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighHighLimit, true
	case 16653:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighLimit, true
	case 16654:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLimit, true
	case 16655:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLowLimit, true
	case 16656:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassId, true
	case 16657:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassName, true
	case 16658:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState, true
	case 16659:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Id, true
	case 16660:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Name, true
	case 16661:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Number, true
	case 16662:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16663:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime, true
	case 16664:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16665:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TrueState, true
	case 16666:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_FalseState, true
	case 16667:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState, true
	case 16668:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Id, true
	case 16669:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Name, true
	case 16670:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Number, true
	case 16671:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName, true
	case 16672:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TransitionTime, true
	case 16673:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16674:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TrueState, true
	case 16675:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_FalseState, true
	case 16676:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleEnabled, true
	case 16677:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound, true
	case 16682:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OnDelay, true
	case 16683:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OffDelay, true
	case 16684:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_FirstInGroupFlag, true
	case 16687:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmTime, true
	case 16688:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmRepeatCount, true
	case 16692:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighHighLimit, true
	case 16693:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighLimit, true
	case 16694:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLimit, true
	case 16695:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLowLimit, true
	case 16736:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassId, true
	case 16737:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassName, true
	case 16738:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState, true
	case 16739:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Id, true
	case 16740:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Name, true
	case 16741:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Number, true
	case 16742:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16743:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime, true
	case 16744:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16745:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState, true
	case 16746:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState, true
	case 16747:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState, true
	case 16748:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Id, true
	case 16749:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Name, true
	case 16750:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Number, true
	case 16751:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName, true
	case 16752:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TransitionTime, true
	case 16753:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16754:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TrueState, true
	case 16755:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_FalseState, true
	case 16756:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleEnabled, true
	case 16757:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound, true
	case 16762:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OnDelay, true
	case 16763:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OffDelay, true
	case 16764:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_FirstInGroupFlag, true
	case 16767:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmTime, true
	case 16768:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmRepeatCount, true
	case 16772:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighHighLimit, true
	case 16773:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighLimit, true
	case 16774:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLimit, true
	case 16775:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLowLimit, true
	case 16776:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode, true
	case 16818:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassId, true
	case 16819:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassName, true
	case 16820:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState, true
	case 16821:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id, true
	case 16822:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name, true
	case 16823:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number, true
	case 16824:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16825:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime, true
	case 16826:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16827:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState, true
	case 16828:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState, true
	case 16829:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState, true
	case 16830:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Id, true
	case 16831:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Name, true
	case 16832:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Number, true
	case 16833:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName, true
	case 16834:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime, true
	case 16835:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16836:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState, true
	case 16837:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState, true
	case 16838:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleEnabled, true
	case 16839:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound, true
	case 16844:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OnDelay, true
	case 16845:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OffDelay, true
	case 16846:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag, true
	case 16849:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmTime, true
	case 16850:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount, true
	case 16854:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit, true
	case 16855:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighLimit, true
	case 16856:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLimit, true
	case 16857:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit, true
	case 16858:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case 17672:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableStates, true
	case 17673:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions, true
	case 17674:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableStates, true
	case 17675:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions, true
	case 17680:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates, true
	case 17681:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions, true
	case 17686:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates, true
	case 17687:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions, true
	case 17893:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_ListId, true
	case 17894:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_AgencyId, true
	case 17895:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_VersionId, true
	case 17914:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_ListId, true
	case 17915:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_AgencyId, true
	case 17916:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_VersionId, true
	case 17921:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId, true
	case 17922:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId, true
	case 17923:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId, true
	case 18233:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState, true
	case 18234:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Id, true
	case 18235:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Name, true
	case 18236:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Number, true
	case 18237:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName, true
	case 18238:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TransitionTime, true
	case 18239:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18240:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TrueState, true
	case 18241:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_FalseState, true
	case 18243:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_ListId, true
	case 18244:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_AgencyId, true
	case 18245:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_VersionId, true
	case 18246:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState, true
	case 18247:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Id, true
	case 18248:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Name, true
	case 18249:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Number, true
	case 18250:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName, true
	case 18251:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TransitionTime, true
	case 18252:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18253:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TrueState, true
	case 18254:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_FalseState, true
	case 18267:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState, true
	case 18268:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Id, true
	case 18269:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Name, true
	case 18270:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Number, true
	case 18271:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName, true
	case 18272:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TransitionTime, true
	case 18273:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18274:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TrueState, true
	case 18275:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_FalseState, true
	case 18277:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState, true
	case 18278:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Id, true
	case 18279:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Name, true
	case 18280:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Number, true
	case 18281:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName, true
	case 18282:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime, true
	case 18283:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18284:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState, true
	case 18285:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState, true
	case 2040:
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray, true
	case 24359:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Suppress2_InputArguments, true
	case 24361:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments, true
	case 24363:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments, true
	case 24365:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments, true
	case 24367:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Reset2_InputArguments, true
	case 24369:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Suppress2_InputArguments, true
	case 24371:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments, true
	case 24373:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments, true
	case 24375:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments, true
	case 24377:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Reset2_InputArguments, true
	case 24389:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Suppress2_InputArguments, true
	case 24391:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments, true
	case 24393:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments, true
	case 24395:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments, true
	case 24397:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Reset2_InputArguments, true
	case 24399:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments, true
	case 24401:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments, true
	case 24403:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments, true
	case 24405:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments, true
	case 24407:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments, true
	case 24795:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24797:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24799:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24802:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHighHigh, true
	case 24803:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHigh, true
	case 24804:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLow, true
	case 24805:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLowLow, true
	case 24806:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighDeadband, true
	case 24807:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighDeadband, true
	case 24808:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowDeadband, true
	case 24809:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowDeadband, true
	case 24811:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24813:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24815:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24818:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHighHigh, true
	case 24819:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHigh, true
	case 24820:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLow, true
	case 24821:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLowLow, true
	case 24822:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighDeadband, true
	case 24823:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighDeadband, true
	case 24824:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowDeadband, true
	case 24825:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowDeadband, true
	case 24843:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24845:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24847:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24850:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHighHigh, true
	case 24851:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHigh, true
	case 24852:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLow, true
	case 24853:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLowLow, true
	case 24854:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighDeadband, true
	case 24855:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighDeadband, true
	case 24856:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowDeadband, true
	case 24857:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowDeadband, true
	case 24859:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24861:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24863:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 24866:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHighHigh, true
	case 24867:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHigh, true
	case 24868:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLow, true
	case 24869:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLowLow, true
	case 24870:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighDeadband, true
	case 24871:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighDeadband, true
	case 24872:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowDeadband, true
	case 24873:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowDeadband, true
	case 25161:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments, true
	case 25162:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments, true
	case 25164:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments, true
	case 25165:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments, true
	case 3189:
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_RedundancySupport, true
	case 32229:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SupportsFilteredRetain, true
	case 32230:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SupportsFilteredRetain, true
	case 32232:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SupportsFilteredRetain, true
	case 32233:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain, true
	case 9907:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventId, true
	case 9908:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventType, true
	case 9909:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceNode, true
	case 9910:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceName, true
	case 9911:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Time, true
	case 9912:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReceiveTime, true
	case 9913:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LocalTime, true
	case 9914:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Message, true
	case 9915:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Severity, true
	case 9916:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionName, true
	case 9917:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BranchId, true
	case 9918:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Retain, true
	case 9919:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState, true
	case 9920:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Id, true
	case 9921:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Name, true
	case 9922:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Number, true
	case 9923:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName, true
	case 9924:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TransitionTime, true
	case 9925:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime, true
	case 9926:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TrueState, true
	case 9927:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_FalseState, true
	case 9928:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality, true
	case 9929:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality_SourceTimestamp, true
	case 9930:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity, true
	case 9931:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp, true
	case 9932:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment, true
	case 9933:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment_SourceTimestamp, true
	case 9934:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ClientUserId, true
	case 9938:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AddComment_InputArguments, true
	case 9940:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments, true
	case 9941:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState, true
	case 9942:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Id, true
	case 9943:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Name, true
	case 9944:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Number, true
	case 9945:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName, true
	case 9946:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TransitionTime, true
	case 9947:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime, true
	case 9948:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TrueState, true
	case 9949:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_FalseState, true
	case 9950:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState, true
	case 9951:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Id, true
	case 9952:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Name, true
	case 9953:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Number, true
	case 9954:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 9955:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime, true
	case 9956:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 9957:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TrueState, true
	case 9958:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_FalseState, true
	case 9960:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Acknowledge_InputArguments, true
	case 9962:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Confirm_InputArguments, true
	case 9963:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState, true
	case 9964:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id, true
	case 9965:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name, true
	case 9966:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number, true
	case 9967:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case 9968:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case 9969:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9970:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState, true
	case 9971:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState, true
	case 9972:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState, true
	case 9973:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Id, true
	case 9974:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Name, true
	case 9975:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Number, true
	case 9976:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName, true
	case 9977:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TransitionTime, true
	case 9978:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 9979:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TrueState, true
	case 9980:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_FalseState, true
	case 9982:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState, true
	case 9983:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id, true
	case 9984:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name, true
	case 9985:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number, true
	case 9986:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 9987:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition, true
	case 9988:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id, true
	case 9989:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name, true
	case 9990:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number, true
	case 9991:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 9992:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNonByName(value string) (enum OpcuaNodeIdServicesVariableNon, ok bool) {
	switch value {
	case "NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "NonExclusiveLimitAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedOrShelved, true
	case "NonExclusiveLimitAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_MaxTimeShelved, true
	case "NonExclusiveLimitAlarmType_HighHighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState, true
	case "NonExclusiveLimitAlarmType_HighHighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id, true
	case "NonExclusiveLimitAlarmType_HighHighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name, true
	case "NonExclusiveLimitAlarmType_HighHighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number, true
	case "NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_HighHighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_HighHighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState, true
	case "NonExclusiveLimitAlarmType_HighHighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState, true
	case "NonExclusiveLimitAlarmType_HighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState, true
	case "NonExclusiveLimitAlarmType_HighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id, true
	case "NonExclusiveLimitAlarmType_HighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name, true
	case "NonExclusiveLimitAlarmType_HighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number, true
	case "NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_HighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_HighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState, true
	case "NonExclusiveLimitAlarmType_HighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState, true
	case "NonExclusiveLimitAlarmType_LowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState, true
	case "NonExclusiveLimitAlarmType_LowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id, true
	case "NonExclusiveLimitAlarmType_LowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name, true
	case "NonExclusiveLimitAlarmType_LowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number, true
	case "NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_LowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_LowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState, true
	case "NonExclusiveLimitAlarmType_LowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState, true
	case "NonExclusiveLimitAlarmType_LowLowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState, true
	case "NonExclusiveLimitAlarmType_LowLowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id, true
	case "NonExclusiveLimitAlarmType_LowLowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name, true
	case "NonExclusiveLimitAlarmType_LowLowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number, true
	case "NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_LowLowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_LowLowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState, true
	case "NonExclusiveLimitAlarmType_LowLowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState, true
	case "NonExclusiveLimitAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighLimit, true
	case "NonExclusiveLimitAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighLimit, true
	case "NonExclusiveLimitAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLimit, true
	case "NonExclusiveLimitAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowLimit, true
	case "NonExclusiveLevelAlarmType_EventId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventId, true
	case "NonExclusiveLevelAlarmType_EventType":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventType, true
	case "NonExclusiveLevelAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceNode, true
	case "NonExclusiveLevelAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceName, true
	case "NonExclusiveLevelAlarmType_Time":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Time, true
	case "NonExclusiveLevelAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReceiveTime, true
	case "NonExclusiveLevelAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LocalTime, true
	case "NonExclusiveLevelAlarmType_Message":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Message, true
	case "NonExclusiveLevelAlarmType_Severity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Severity, true
	case "NonExclusiveLevelAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionName, true
	case "NonExclusiveLevelAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BranchId, true
	case "NonExclusiveLevelAlarmType_Retain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Retain, true
	case "NonExclusiveLevelAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState, true
	case "NonExclusiveLevelAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Id, true
	case "NonExclusiveLevelAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Name, true
	case "NonExclusiveLevelAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Number, true
	case "NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TrueState, true
	case "NonExclusiveLevelAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_FalseState, true
	case "NonExclusiveLevelAlarmType_Quality":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality, true
	case "NonExclusiveLevelAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality_SourceTimestamp, true
	case "NonExclusiveLevelAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity, true
	case "NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp, true
	case "NonExclusiveLevelAlarmType_Comment":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment, true
	case "NonExclusiveLevelAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment_SourceTimestamp, true
	case "NonExclusiveLevelAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ClientUserId, true
	case "NonExclusiveLevelAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AddComment_InputArguments, true
	case "NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments, true
	case "NonExclusiveLevelAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState, true
	case "NonExclusiveLevelAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Id, true
	case "NonExclusiveLevelAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Name, true
	case "NonExclusiveLevelAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Number, true
	case "NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TrueState, true
	case "NonExclusiveLevelAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_FalseState, true
	case "NonExclusiveLevelAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Id, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Name, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Number, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TrueState, true
	case "NonExclusiveLevelAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_FalseState, true
	case "NonExclusiveLevelAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Acknowledge_InputArguments, true
	case "NonExclusiveLevelAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Confirm_InputArguments, true
	case "NonExclusiveLevelAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState, true
	case "NonExclusiveLevelAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Id, true
	case "NonExclusiveLevelAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Name, true
	case "NonExclusiveLevelAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Number, true
	case "NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TrueState, true
	case "NonExclusiveLevelAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_FalseState, true
	case "NonExclusiveLevelAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState, true
	case "NonExclusiveLevelAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Id, true
	case "NonExclusiveLevelAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Name, true
	case "NonExclusiveLevelAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Number, true
	case "NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TrueState, true
	case "NonExclusiveLevelAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_FalseState, true
	case "NonExclusiveLevelAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState, true
	case "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id, true
	case "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name, true
	case "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number, true
	case "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime, true
	case "NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "NonExclusiveLevelAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedOrShelved, true
	case "NonExclusiveLevelAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_MaxTimeShelved, true
	case "NonExclusiveLevelAlarmType_HighHighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState, true
	case "NonExclusiveLevelAlarmType_HighHighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Id, true
	case "NonExclusiveLevelAlarmType_HighHighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Name, true
	case "NonExclusiveLevelAlarmType_HighHighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Number, true
	case "NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_HighHighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_HighHighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TrueState, true
	case "NonExclusiveLevelAlarmType_HighHighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_FalseState, true
	case "NonExclusiveLevelAlarmType_HighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState, true
	case "NonExclusiveLevelAlarmType_HighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Id, true
	case "NonExclusiveLevelAlarmType_HighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Name, true
	case "NonExclusiveLevelAlarmType_HighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Number, true
	case "NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_HighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_HighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TrueState, true
	case "NonExclusiveLevelAlarmType_HighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_FalseState, true
	case "NonExclusiveLevelAlarmType_LowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState, true
	case "NonExclusiveLevelAlarmType_LowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Id, true
	case "NonExclusiveLevelAlarmType_LowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Name, true
	case "NonExclusiveLevelAlarmType_LowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Number, true
	case "NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_LowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_LowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TrueState, true
	case "NonExclusiveLevelAlarmType_LowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_FalseState, true
	case "NonExclusiveLevelAlarmType_LowLowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState, true
	case "NonExclusiveLevelAlarmType_LowLowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Id, true
	case "NonExclusiveLevelAlarmType_LowLowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Name, true
	case "NonExclusiveLevelAlarmType_LowLowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Number, true
	case "NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_LowLowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_LowLowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TrueState, true
	case "NonExclusiveLevelAlarmType_LowLowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_FalseState, true
	case "NonExclusiveLevelAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighLimit, true
	case "NonExclusiveLevelAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighLimit, true
	case "NonExclusiveLevelAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLimit, true
	case "NonExclusiveLevelAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowLimit, true
	case "NonExclusiveRateOfChangeAlarmType_EventId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventId, true
	case "NonExclusiveRateOfChangeAlarmType_EventType":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventType, true
	case "NonExclusiveRateOfChangeAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceNode, true
	case "NonExclusiveRateOfChangeAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceName, true
	case "NonExclusiveRateOfChangeAlarmType_Time":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Time, true
	case "NonExclusiveRateOfChangeAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReceiveTime, true
	case "NonExclusiveRateOfChangeAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LocalTime, true
	case "NonExclusiveRateOfChangeAlarmType_Message":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Message, true
	case "NonExclusiveRateOfChangeAlarmType_Severity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Severity, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionName, true
	case "NonExclusiveRateOfChangeAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BranchId, true
	case "NonExclusiveRateOfChangeAlarmType_Retain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Retain, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_Quality":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality, true
	case "NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp, true
	case "NonExclusiveRateOfChangeAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity, true
	case "NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp, true
	case "NonExclusiveRateOfChangeAlarmType_Comment":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment, true
	case "NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp, true
	case "NonExclusiveRateOfChangeAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ClientUserId, true
	case "NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved, true
	case "NonExclusiveRateOfChangeAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_MaxTimeShelved, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_HighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_HighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_LowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_LowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighLimit, true
	case "NonExclusiveRateOfChangeAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighLimit, true
	case "NonExclusiveRateOfChangeAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLimit, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowLimit, true
	case "NonExclusiveDeviationAlarmType_EventId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventId, true
	case "NonExclusiveDeviationAlarmType_EventType":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventType, true
	case "NonExclusiveDeviationAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceNode, true
	case "NonExclusiveDeviationAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceName, true
	case "NonExclusiveDeviationAlarmType_Time":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Time, true
	case "NonExclusiveDeviationAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReceiveTime, true
	case "NonExclusiveDeviationAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LocalTime, true
	case "NonExclusiveDeviationAlarmType_Message":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Message, true
	case "NonExclusiveDeviationAlarmType_Severity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Severity, true
	case "NonExclusiveDeviationAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionName, true
	case "NonExclusiveDeviationAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BranchId, true
	case "NonExclusiveDeviationAlarmType_Retain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Retain, true
	case "NonExclusiveDeviationAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState, true
	case "NonExclusiveDeviationAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Id, true
	case "NonExclusiveDeviationAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Name, true
	case "NonExclusiveDeviationAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Number, true
	case "NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TrueState, true
	case "NonExclusiveDeviationAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_FalseState, true
	case "NonExclusiveDeviationAlarmType_Quality":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality, true
	case "NonExclusiveDeviationAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp, true
	case "NonExclusiveDeviationAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity, true
	case "NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp, true
	case "NonExclusiveDeviationAlarmType_Comment":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment, true
	case "NonExclusiveDeviationAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp, true
	case "NonExclusiveDeviationAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ClientUserId, true
	case "NonExclusiveDeviationAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AddComment_InputArguments, true
	case "NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments, true
	case "NonExclusiveDeviationAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState, true
	case "NonExclusiveDeviationAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Id, true
	case "NonExclusiveDeviationAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Name, true
	case "NonExclusiveDeviationAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Number, true
	case "NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TrueState, true
	case "NonExclusiveDeviationAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_FalseState, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Id, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Name, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Number, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TrueState, true
	case "NonExclusiveDeviationAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_FalseState, true
	case "NonExclusiveDeviationAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments, true
	case "NonExclusiveDeviationAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Confirm_InputArguments, true
	case "NonExclusiveDeviationAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState, true
	case "NonExclusiveDeviationAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Id, true
	case "NonExclusiveDeviationAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Name, true
	case "NonExclusiveDeviationAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Number, true
	case "NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TrueState, true
	case "NonExclusiveDeviationAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_FalseState, true
	case "NonExclusiveDeviationAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Id, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Name, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Number, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TrueState, true
	case "NonExclusiveDeviationAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_FalseState, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "NonExclusiveDeviationAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedOrShelved, true
	case "NonExclusiveDeviationAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_MaxTimeShelved, true
	case "NonExclusiveDeviationAlarmType_HighHighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState, true
	case "NonExclusiveDeviationAlarmType_HighHighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Id, true
	case "NonExclusiveDeviationAlarmType_HighHighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Name, true
	case "NonExclusiveDeviationAlarmType_HighHighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Number, true
	case "NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_HighHighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_HighHighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TrueState, true
	case "NonExclusiveDeviationAlarmType_HighHighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_FalseState, true
	case "NonExclusiveDeviationAlarmType_HighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState, true
	case "NonExclusiveDeviationAlarmType_HighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Id, true
	case "NonExclusiveDeviationAlarmType_HighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Name, true
	case "NonExclusiveDeviationAlarmType_HighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Number, true
	case "NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_HighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_HighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TrueState, true
	case "NonExclusiveDeviationAlarmType_HighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_FalseState, true
	case "NonExclusiveDeviationAlarmType_LowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState, true
	case "NonExclusiveDeviationAlarmType_LowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Id, true
	case "NonExclusiveDeviationAlarmType_LowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Name, true
	case "NonExclusiveDeviationAlarmType_LowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Number, true
	case "NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_LowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_LowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TrueState, true
	case "NonExclusiveDeviationAlarmType_LowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_FalseState, true
	case "NonExclusiveDeviationAlarmType_LowLowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState, true
	case "NonExclusiveDeviationAlarmType_LowLowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Id, true
	case "NonExclusiveDeviationAlarmType_LowLowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Name, true
	case "NonExclusiveDeviationAlarmType_LowLowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Number, true
	case "NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_LowLowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_LowLowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TrueState, true
	case "NonExclusiveDeviationAlarmType_LowLowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_FalseState, true
	case "NonExclusiveDeviationAlarmType_HighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighLimit, true
	case "NonExclusiveDeviationAlarmType_HighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighLimit, true
	case "NonExclusiveDeviationAlarmType_LowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLimit, true
	case "NonExclusiveDeviationAlarmType_LowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowLimit, true
	case "NonExclusiveDeviationAlarmType_SetpointNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode, true
	case "NonExclusiveLimitAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassId, true
	case "NonExclusiveLimitAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassName, true
	case "NonExclusiveLimitAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_InputNode, true
	case "NonExclusiveLevelAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassId, true
	case "NonExclusiveLevelAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassName, true
	case "NonExclusiveLevelAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_InputNode, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassId, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassName, true
	case "NonExclusiveRateOfChangeAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_InputNode, true
	case "NonExclusiveDeviationAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassId, true
	case "NonExclusiveDeviationAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassName, true
	case "NonExclusiveDeviationAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_InputNode, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "NonTransparentNetworkRedundancyType_RedundancySupport":
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_RedundancySupport, true
	case "NonTransparentNetworkRedundancyType_ServerUriArray":
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerUriArray, true
	case "NonTransparentNetworkRedundancyType_ServerNetworkGroups":
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups, true
	case "NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments, true
	case "NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments, true
	case "NonExclusiveLimitAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassId, true
	case "NonExclusiveLimitAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassName, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Id, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Name, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Number, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TrueState, true
	case "NonExclusiveLimitAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_FalseState, true
	case "NonExclusiveLimitAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState, true
	case "NonExclusiveLimitAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Id, true
	case "NonExclusiveLimitAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Name, true
	case "NonExclusiveLimitAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Number, true
	case "NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TrueState, true
	case "NonExclusiveLimitAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_FalseState, true
	case "NonExclusiveLimitAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleEnabled, true
	case "NonExclusiveLimitAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound, true
	case "NonExclusiveLimitAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OnDelay, true
	case "NonExclusiveLimitAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OffDelay, true
	case "NonExclusiveLimitAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_FirstInGroupFlag, true
	case "NonExclusiveLimitAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmTime, true
	case "NonExclusiveLimitAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmRepeatCount, true
	case "NonExclusiveLimitAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighHighLimit, true
	case "NonExclusiveLimitAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighLimit, true
	case "NonExclusiveLimitAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLimit, true
	case "NonExclusiveLimitAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLowLimit, true
	case "NonExclusiveLevelAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassId, true
	case "NonExclusiveLevelAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassName, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Id, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Name, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Number, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TrueState, true
	case "NonExclusiveLevelAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_FalseState, true
	case "NonExclusiveLevelAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState, true
	case "NonExclusiveLevelAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Id, true
	case "NonExclusiveLevelAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Name, true
	case "NonExclusiveLevelAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Number, true
	case "NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TrueState, true
	case "NonExclusiveLevelAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_FalseState, true
	case "NonExclusiveLevelAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleEnabled, true
	case "NonExclusiveLevelAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound, true
	case "NonExclusiveLevelAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OnDelay, true
	case "NonExclusiveLevelAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OffDelay, true
	case "NonExclusiveLevelAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_FirstInGroupFlag, true
	case "NonExclusiveLevelAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmTime, true
	case "NonExclusiveLevelAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmRepeatCount, true
	case "NonExclusiveLevelAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighHighLimit, true
	case "NonExclusiveLevelAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighLimit, true
	case "NonExclusiveLevelAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLimit, true
	case "NonExclusiveLevelAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLowLimit, true
	case "NonExclusiveDeviationAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassId, true
	case "NonExclusiveDeviationAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassName, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Id, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Name, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Number, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState, true
	case "NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState, true
	case "NonExclusiveDeviationAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState, true
	case "NonExclusiveDeviationAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Id, true
	case "NonExclusiveDeviationAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Name, true
	case "NonExclusiveDeviationAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Number, true
	case "NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TrueState, true
	case "NonExclusiveDeviationAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_FalseState, true
	case "NonExclusiveDeviationAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleEnabled, true
	case "NonExclusiveDeviationAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound, true
	case "NonExclusiveDeviationAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OnDelay, true
	case "NonExclusiveDeviationAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OffDelay, true
	case "NonExclusiveDeviationAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_FirstInGroupFlag, true
	case "NonExclusiveDeviationAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmTime, true
	case "NonExclusiveDeviationAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmRepeatCount, true
	case "NonExclusiveDeviationAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighHighLimit, true
	case "NonExclusiveDeviationAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighLimit, true
	case "NonExclusiveDeviationAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLimit, true
	case "NonExclusiveDeviationAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLowLimit, true
	case "NonExclusiveDeviationAlarmType_BaseSetpointNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassId, true
	case "NonExclusiveRateOfChangeAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassName, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleEnabled, true
	case "NonExclusiveRateOfChangeAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound, true
	case "NonExclusiveRateOfChangeAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OnDelay, true
	case "NonExclusiveRateOfChangeAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OffDelay, true
	case "NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag, true
	case "NonExclusiveRateOfChangeAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmTime, true
	case "NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount, true
	case "NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit, true
	case "NonExclusiveRateOfChangeAlarmType_BaseHighLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighLimit, true
	case "NonExclusiveRateOfChangeAlarmType_BaseLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLimit, true
	case "NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit, true
	case "NonExclusiveRateOfChangeAlarmType_EngineeringUnits":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case "NonExclusiveLimitAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableStates, true
	case "NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions, true
	case "NonExclusiveLevelAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableStates, true
	case "NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions, true
	case "NonExclusiveLimitAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_ListId, true
	case "NonExclusiveLimitAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_AgencyId, true
	case "NonExclusiveLimitAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_VersionId, true
	case "NonExclusiveDeviationAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_ListId, true
	case "NonExclusiveDeviationAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_AgencyId, true
	case "NonExclusiveDeviationAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_VersionId, true
	case "NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId, true
	case "NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId, true
	case "NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId, true
	case "NonExclusiveLimitAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState, true
	case "NonExclusiveLimitAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Id, true
	case "NonExclusiveLimitAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Name, true
	case "NonExclusiveLimitAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Number, true
	case "NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TrueState, true
	case "NonExclusiveLimitAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_FalseState, true
	case "NonExclusiveLevelAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_ListId, true
	case "NonExclusiveLevelAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_AgencyId, true
	case "NonExclusiveLevelAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_VersionId, true
	case "NonExclusiveLevelAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState, true
	case "NonExclusiveLevelAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Id, true
	case "NonExclusiveLevelAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Name, true
	case "NonExclusiveLevelAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Number, true
	case "NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName, true
	case "NonExclusiveLevelAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TransitionTime, true
	case "NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime, true
	case "NonExclusiveLevelAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TrueState, true
	case "NonExclusiveLevelAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_FalseState, true
	case "NonExclusiveDeviationAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState, true
	case "NonExclusiveDeviationAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Id, true
	case "NonExclusiveDeviationAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Name, true
	case "NonExclusiveDeviationAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Number, true
	case "NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName, true
	case "NonExclusiveDeviationAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TransitionTime, true
	case "NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime, true
	case "NonExclusiveDeviationAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TrueState, true
	case "NonExclusiveDeviationAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_FalseState, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Id, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Name, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Number, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState, true
	case "NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState, true
	case "NonTransparentRedundancyType_ServerUriArray":
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray, true
	case "NonExclusiveLimitAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Suppress2_InputArguments, true
	case "NonExclusiveLimitAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments, true
	case "NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments, true
	case "NonExclusiveLimitAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments, true
	case "NonExclusiveLimitAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Reset2_InputArguments, true
	case "NonExclusiveLevelAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Suppress2_InputArguments, true
	case "NonExclusiveLevelAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments, true
	case "NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments, true
	case "NonExclusiveLevelAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments, true
	case "NonExclusiveLevelAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Reset2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Suppress2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Reset2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments, true
	case "NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "NonExclusiveLimitAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHighHigh, true
	case "NonExclusiveLimitAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHigh, true
	case "NonExclusiveLimitAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLow, true
	case "NonExclusiveLimitAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLowLow, true
	case "NonExclusiveLimitAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighDeadband, true
	case "NonExclusiveLimitAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighDeadband, true
	case "NonExclusiveLimitAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowDeadband, true
	case "NonExclusiveLimitAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowDeadband, true
	case "NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "NonExclusiveLevelAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHighHigh, true
	case "NonExclusiveLevelAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHigh, true
	case "NonExclusiveLevelAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLow, true
	case "NonExclusiveLevelAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLowLow, true
	case "NonExclusiveLevelAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighDeadband, true
	case "NonExclusiveLevelAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighDeadband, true
	case "NonExclusiveLevelAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowDeadband, true
	case "NonExclusiveLevelAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowDeadband, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "NonExclusiveDeviationAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHighHigh, true
	case "NonExclusiveDeviationAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHigh, true
	case "NonExclusiveDeviationAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLow, true
	case "NonExclusiveDeviationAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLowLow, true
	case "NonExclusiveDeviationAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighDeadband, true
	case "NonExclusiveDeviationAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighDeadband, true
	case "NonExclusiveDeviationAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowDeadband, true
	case "NonExclusiveDeviationAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowDeadband, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_SeverityHighHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHighHigh, true
	case "NonExclusiveRateOfChangeAlarmType_SeverityHigh":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHigh, true
	case "NonExclusiveRateOfChangeAlarmType_SeverityLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLow, true
	case "NonExclusiveRateOfChangeAlarmType_SeverityLowLow":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLowLow, true
	case "NonExclusiveRateOfChangeAlarmType_HighHighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighDeadband, true
	case "NonExclusiveRateOfChangeAlarmType_HighDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighDeadband, true
	case "NonExclusiveRateOfChangeAlarmType_LowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowDeadband, true
	case "NonExclusiveRateOfChangeAlarmType_LowLowDeadband":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowDeadband, true
	case "NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments, true
	case "NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments, true
	case "NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments, true
	case "NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments, true
	case "NonTransparentRedundancyType_RedundancySupport":
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_RedundancySupport, true
	case "NonExclusiveLimitAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SupportsFilteredRetain, true
	case "NonExclusiveLevelAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SupportsFilteredRetain, true
	case "NonExclusiveDeviationAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SupportsFilteredRetain, true
	case "NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain, true
	case "NonExclusiveLimitAlarmType_EventId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventId, true
	case "NonExclusiveLimitAlarmType_EventType":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventType, true
	case "NonExclusiveLimitAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceNode, true
	case "NonExclusiveLimitAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceName, true
	case "NonExclusiveLimitAlarmType_Time":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Time, true
	case "NonExclusiveLimitAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReceiveTime, true
	case "NonExclusiveLimitAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LocalTime, true
	case "NonExclusiveLimitAlarmType_Message":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Message, true
	case "NonExclusiveLimitAlarmType_Severity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Severity, true
	case "NonExclusiveLimitAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionName, true
	case "NonExclusiveLimitAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BranchId, true
	case "NonExclusiveLimitAlarmType_Retain":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Retain, true
	case "NonExclusiveLimitAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState, true
	case "NonExclusiveLimitAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Id, true
	case "NonExclusiveLimitAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Name, true
	case "NonExclusiveLimitAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Number, true
	case "NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TrueState, true
	case "NonExclusiveLimitAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_FalseState, true
	case "NonExclusiveLimitAlarmType_Quality":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality, true
	case "NonExclusiveLimitAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality_SourceTimestamp, true
	case "NonExclusiveLimitAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity, true
	case "NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp, true
	case "NonExclusiveLimitAlarmType_Comment":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment, true
	case "NonExclusiveLimitAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment_SourceTimestamp, true
	case "NonExclusiveLimitAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ClientUserId, true
	case "NonExclusiveLimitAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AddComment_InputArguments, true
	case "NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments, true
	case "NonExclusiveLimitAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState, true
	case "NonExclusiveLimitAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Id, true
	case "NonExclusiveLimitAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Name, true
	case "NonExclusiveLimitAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Number, true
	case "NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TrueState, true
	case "NonExclusiveLimitAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_FalseState, true
	case "NonExclusiveLimitAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Id, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Name, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Number, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TrueState, true
	case "NonExclusiveLimitAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_FalseState, true
	case "NonExclusiveLimitAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Acknowledge_InputArguments, true
	case "NonExclusiveLimitAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Confirm_InputArguments, true
	case "NonExclusiveLimitAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState, true
	case "NonExclusiveLimitAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id, true
	case "NonExclusiveLimitAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name, true
	case "NonExclusiveLimitAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number, true
	case "NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState, true
	case "NonExclusiveLimitAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState, true
	case "NonExclusiveLimitAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState, true
	case "NonExclusiveLimitAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Id, true
	case "NonExclusiveLimitAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Name, true
	case "NonExclusiveLimitAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Number, true
	case "NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TrueState, true
	case "NonExclusiveLimitAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_FalseState, true
	case "NonExclusiveLimitAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState, true
	case "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id, true
	case "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name, true
	case "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number, true
	case "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number, true
	case "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNonKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableNonValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableNon(structType any) OpcuaNodeIdServicesVariableNon {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableNon {
		if sOpcuaNodeIdServicesVariableNon, ok := typ.(OpcuaNodeIdServicesVariableNon); ok {
			return sOpcuaNodeIdServicesVariableNon
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableNon) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableNon) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableNonParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableNon, error) {
	return OpcuaNodeIdServicesVariableNonParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableNonParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableNon, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableNon", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableNon")
	}
	if enum, ok := OpcuaNodeIdServicesVariableNonByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableNon")
		return OpcuaNodeIdServicesVariableNon(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableNon) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableNon) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableNon", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableNon) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedOrShelved:
		return "NonExclusiveLimitAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_MaxTimeShelved:
		return "NonExclusiveLimitAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState:
		return "NonExclusiveLimitAlarmType_HighHighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id:
		return "NonExclusiveLimitAlarmType_HighHighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name:
		return "NonExclusiveLimitAlarmType_HighHighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number:
		return "NonExclusiveLimitAlarmType_HighHighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime:
		return "NonExclusiveLimitAlarmType_HighHighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState:
		return "NonExclusiveLimitAlarmType_HighHighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState:
		return "NonExclusiveLimitAlarmType_HighHighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState:
		return "NonExclusiveLimitAlarmType_HighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id:
		return "NonExclusiveLimitAlarmType_HighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name:
		return "NonExclusiveLimitAlarmType_HighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number:
		return "NonExclusiveLimitAlarmType_HighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime:
		return "NonExclusiveLimitAlarmType_HighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState:
		return "NonExclusiveLimitAlarmType_HighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState:
		return "NonExclusiveLimitAlarmType_HighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState:
		return "NonExclusiveLimitAlarmType_LowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id:
		return "NonExclusiveLimitAlarmType_LowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name:
		return "NonExclusiveLimitAlarmType_LowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number:
		return "NonExclusiveLimitAlarmType_LowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime:
		return "NonExclusiveLimitAlarmType_LowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState:
		return "NonExclusiveLimitAlarmType_LowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState:
		return "NonExclusiveLimitAlarmType_LowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState:
		return "NonExclusiveLimitAlarmType_LowLowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id:
		return "NonExclusiveLimitAlarmType_LowLowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name:
		return "NonExclusiveLimitAlarmType_LowLowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number:
		return "NonExclusiveLimitAlarmType_LowLowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime:
		return "NonExclusiveLimitAlarmType_LowLowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState:
		return "NonExclusiveLimitAlarmType_LowLowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState:
		return "NonExclusiveLimitAlarmType_LowLowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighLimit:
		return "NonExclusiveLimitAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighLimit:
		return "NonExclusiveLimitAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLimit:
		return "NonExclusiveLimitAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowLimit:
		return "NonExclusiveLimitAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventId:
		return "NonExclusiveLevelAlarmType_EventId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EventType:
		return "NonExclusiveLevelAlarmType_EventType"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceNode:
		return "NonExclusiveLevelAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SourceName:
		return "NonExclusiveLevelAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Time:
		return "NonExclusiveLevelAlarmType_Time"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReceiveTime:
		return "NonExclusiveLevelAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LocalTime:
		return "NonExclusiveLevelAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Message:
		return "NonExclusiveLevelAlarmType_Message"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Severity:
		return "NonExclusiveLevelAlarmType_Severity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionName:
		return "NonExclusiveLevelAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BranchId:
		return "NonExclusiveLevelAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Retain:
		return "NonExclusiveLevelAlarmType_Retain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState:
		return "NonExclusiveLevelAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Id:
		return "NonExclusiveLevelAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Name:
		return "NonExclusiveLevelAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_Number:
		return "NonExclusiveLevelAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TransitionTime:
		return "NonExclusiveLevelAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_TrueState:
		return "NonExclusiveLevelAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_EnabledState_FalseState:
		return "NonExclusiveLevelAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality:
		return "NonExclusiveLevelAlarmType_Quality"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Quality_SourceTimestamp:
		return "NonExclusiveLevelAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity:
		return "NonExclusiveLevelAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp:
		return "NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment:
		return "NonExclusiveLevelAlarmType_Comment"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Comment_SourceTimestamp:
		return "NonExclusiveLevelAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ClientUserId:
		return "NonExclusiveLevelAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AddComment_InputArguments:
		return "NonExclusiveLevelAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments:
		return "NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState:
		return "NonExclusiveLevelAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Id:
		return "NonExclusiveLevelAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Name:
		return "NonExclusiveLevelAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_Number:
		return "NonExclusiveLevelAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TransitionTime:
		return "NonExclusiveLevelAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_TrueState:
		return "NonExclusiveLevelAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AckedState_FalseState:
		return "NonExclusiveLevelAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState:
		return "NonExclusiveLevelAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Id:
		return "NonExclusiveLevelAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Name:
		return "NonExclusiveLevelAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_Number:
		return "NonExclusiveLevelAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime:
		return "NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_TrueState:
		return "NonExclusiveLevelAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConfirmedState_FalseState:
		return "NonExclusiveLevelAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Acknowledge_InputArguments:
		return "NonExclusiveLevelAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Confirm_InputArguments:
		return "NonExclusiveLevelAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState:
		return "NonExclusiveLevelAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Id:
		return "NonExclusiveLevelAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Name:
		return "NonExclusiveLevelAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_Number:
		return "NonExclusiveLevelAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TransitionTime:
		return "NonExclusiveLevelAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_TrueState:
		return "NonExclusiveLevelAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ActiveState_FalseState:
		return "NonExclusiveLevelAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState:
		return "NonExclusiveLevelAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Id:
		return "NonExclusiveLevelAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Name:
		return "NonExclusiveLevelAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_Number:
		return "NonExclusiveLevelAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TransitionTime:
		return "NonExclusiveLevelAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_TrueState:
		return "NonExclusiveLevelAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedState_FalseState:
		return "NonExclusiveLevelAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState:
		return "NonExclusiveLevelAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id:
		return "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name:
		return "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number:
		return "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime:
		return "NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SuppressedOrShelved:
		return "NonExclusiveLevelAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_MaxTimeShelved:
		return "NonExclusiveLevelAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState:
		return "NonExclusiveLevelAlarmType_HighHighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Id:
		return "NonExclusiveLevelAlarmType_HighHighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Name:
		return "NonExclusiveLevelAlarmType_HighHighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_Number:
		return "NonExclusiveLevelAlarmType_HighHighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TransitionTime:
		return "NonExclusiveLevelAlarmType_HighHighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_TrueState:
		return "NonExclusiveLevelAlarmType_HighHighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighState_FalseState:
		return "NonExclusiveLevelAlarmType_HighHighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState:
		return "NonExclusiveLevelAlarmType_HighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Id:
		return "NonExclusiveLevelAlarmType_HighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Name:
		return "NonExclusiveLevelAlarmType_HighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_Number:
		return "NonExclusiveLevelAlarmType_HighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TransitionTime:
		return "NonExclusiveLevelAlarmType_HighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_TrueState:
		return "NonExclusiveLevelAlarmType_HighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighState_FalseState:
		return "NonExclusiveLevelAlarmType_HighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState:
		return "NonExclusiveLevelAlarmType_LowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Id:
		return "NonExclusiveLevelAlarmType_LowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Name:
		return "NonExclusiveLevelAlarmType_LowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_Number:
		return "NonExclusiveLevelAlarmType_LowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TransitionTime:
		return "NonExclusiveLevelAlarmType_LowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_TrueState:
		return "NonExclusiveLevelAlarmType_LowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowState_FalseState:
		return "NonExclusiveLevelAlarmType_LowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState:
		return "NonExclusiveLevelAlarmType_LowLowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Id:
		return "NonExclusiveLevelAlarmType_LowLowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Name:
		return "NonExclusiveLevelAlarmType_LowLowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_Number:
		return "NonExclusiveLevelAlarmType_LowLowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TransitionTime:
		return "NonExclusiveLevelAlarmType_LowLowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_TrueState:
		return "NonExclusiveLevelAlarmType_LowLowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowState_FalseState:
		return "NonExclusiveLevelAlarmType_LowLowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighLimit:
		return "NonExclusiveLevelAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighLimit:
		return "NonExclusiveLevelAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLimit:
		return "NonExclusiveLevelAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowLimit:
		return "NonExclusiveLevelAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventId:
		return "NonExclusiveRateOfChangeAlarmType_EventId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EventType:
		return "NonExclusiveRateOfChangeAlarmType_EventType"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceNode:
		return "NonExclusiveRateOfChangeAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SourceName:
		return "NonExclusiveRateOfChangeAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Time:
		return "NonExclusiveRateOfChangeAlarmType_Time"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReceiveTime:
		return "NonExclusiveRateOfChangeAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LocalTime:
		return "NonExclusiveRateOfChangeAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Message:
		return "NonExclusiveRateOfChangeAlarmType_Message"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Severity:
		return "NonExclusiveRateOfChangeAlarmType_Severity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionName:
		return "NonExclusiveRateOfChangeAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BranchId:
		return "NonExclusiveRateOfChangeAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Retain:
		return "NonExclusiveRateOfChangeAlarmType_Retain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Id:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Name:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_Number:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality:
		return "NonExclusiveRateOfChangeAlarmType_Quality"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp:
		return "NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity:
		return "NonExclusiveRateOfChangeAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp:
		return "NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment:
		return "NonExclusiveRateOfChangeAlarmType_Comment"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp:
		return "NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ClientUserId:
		return "NonExclusiveRateOfChangeAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState:
		return "NonExclusiveRateOfChangeAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Id:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Name:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_Number:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AckedState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Id:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Name:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_Number:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Id:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Name:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_Number:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved:
		return "NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_MaxTimeShelved:
		return "NonExclusiveRateOfChangeAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Id:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Name:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_Number:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState:
		return "NonExclusiveRateOfChangeAlarmType_HighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Id:
		return "NonExclusiveRateOfChangeAlarmType_HighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Name:
		return "NonExclusiveRateOfChangeAlarmType_HighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_Number:
		return "NonExclusiveRateOfChangeAlarmType_HighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_HighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_HighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState:
		return "NonExclusiveRateOfChangeAlarmType_LowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Id:
		return "NonExclusiveRateOfChangeAlarmType_LowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Name:
		return "NonExclusiveRateOfChangeAlarmType_LowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_Number:
		return "NonExclusiveRateOfChangeAlarmType_LowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_LowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_LowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Id:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Name:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_Number:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighLimit:
		return "NonExclusiveRateOfChangeAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighLimit:
		return "NonExclusiveRateOfChangeAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLimit:
		return "NonExclusiveRateOfChangeAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowLimit:
		return "NonExclusiveRateOfChangeAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventId:
		return "NonExclusiveDeviationAlarmType_EventId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EventType:
		return "NonExclusiveDeviationAlarmType_EventType"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceNode:
		return "NonExclusiveDeviationAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SourceName:
		return "NonExclusiveDeviationAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Time:
		return "NonExclusiveDeviationAlarmType_Time"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReceiveTime:
		return "NonExclusiveDeviationAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LocalTime:
		return "NonExclusiveDeviationAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Message:
		return "NonExclusiveDeviationAlarmType_Message"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Severity:
		return "NonExclusiveDeviationAlarmType_Severity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionName:
		return "NonExclusiveDeviationAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BranchId:
		return "NonExclusiveDeviationAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Retain:
		return "NonExclusiveDeviationAlarmType_Retain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState:
		return "NonExclusiveDeviationAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Id:
		return "NonExclusiveDeviationAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Name:
		return "NonExclusiveDeviationAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_Number:
		return "NonExclusiveDeviationAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_TrueState:
		return "NonExclusiveDeviationAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_EnabledState_FalseState:
		return "NonExclusiveDeviationAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality:
		return "NonExclusiveDeviationAlarmType_Quality"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Quality_SourceTimestamp:
		return "NonExclusiveDeviationAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity:
		return "NonExclusiveDeviationAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp:
		return "NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment:
		return "NonExclusiveDeviationAlarmType_Comment"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Comment_SourceTimestamp:
		return "NonExclusiveDeviationAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ClientUserId:
		return "NonExclusiveDeviationAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AddComment_InputArguments:
		return "NonExclusiveDeviationAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments:
		return "NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState:
		return "NonExclusiveDeviationAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Id:
		return "NonExclusiveDeviationAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Name:
		return "NonExclusiveDeviationAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_Number:
		return "NonExclusiveDeviationAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_TrueState:
		return "NonExclusiveDeviationAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AckedState_FalseState:
		return "NonExclusiveDeviationAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState:
		return "NonExclusiveDeviationAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Id:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Name:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_Number:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_TrueState:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConfirmedState_FalseState:
		return "NonExclusiveDeviationAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Acknowledge_InputArguments:
		return "NonExclusiveDeviationAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Confirm_InputArguments:
		return "NonExclusiveDeviationAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState:
		return "NonExclusiveDeviationAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Id:
		return "NonExclusiveDeviationAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Name:
		return "NonExclusiveDeviationAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_Number:
		return "NonExclusiveDeviationAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_TrueState:
		return "NonExclusiveDeviationAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ActiveState_FalseState:
		return "NonExclusiveDeviationAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState:
		return "NonExclusiveDeviationAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Id:
		return "NonExclusiveDeviationAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Name:
		return "NonExclusiveDeviationAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_Number:
		return "NonExclusiveDeviationAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_TrueState:
		return "NonExclusiveDeviationAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedState_FalseState:
		return "NonExclusiveDeviationAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState:
		return "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id:
		return "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name:
		return "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number:
		return "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime:
		return "NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SuppressedOrShelved:
		return "NonExclusiveDeviationAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_MaxTimeShelved:
		return "NonExclusiveDeviationAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState:
		return "NonExclusiveDeviationAlarmType_HighHighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Id:
		return "NonExclusiveDeviationAlarmType_HighHighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Name:
		return "NonExclusiveDeviationAlarmType_HighHighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_Number:
		return "NonExclusiveDeviationAlarmType_HighHighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_HighHighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_TrueState:
		return "NonExclusiveDeviationAlarmType_HighHighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighState_FalseState:
		return "NonExclusiveDeviationAlarmType_HighHighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState:
		return "NonExclusiveDeviationAlarmType_HighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Id:
		return "NonExclusiveDeviationAlarmType_HighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Name:
		return "NonExclusiveDeviationAlarmType_HighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_Number:
		return "NonExclusiveDeviationAlarmType_HighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_HighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_TrueState:
		return "NonExclusiveDeviationAlarmType_HighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighState_FalseState:
		return "NonExclusiveDeviationAlarmType_HighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState:
		return "NonExclusiveDeviationAlarmType_LowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Id:
		return "NonExclusiveDeviationAlarmType_LowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Name:
		return "NonExclusiveDeviationAlarmType_LowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_Number:
		return "NonExclusiveDeviationAlarmType_LowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_LowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_TrueState:
		return "NonExclusiveDeviationAlarmType_LowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowState_FalseState:
		return "NonExclusiveDeviationAlarmType_LowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState:
		return "NonExclusiveDeviationAlarmType_LowLowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Id:
		return "NonExclusiveDeviationAlarmType_LowLowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Name:
		return "NonExclusiveDeviationAlarmType_LowLowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_Number:
		return "NonExclusiveDeviationAlarmType_LowLowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_LowLowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_TrueState:
		return "NonExclusiveDeviationAlarmType_LowLowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowState_FalseState:
		return "NonExclusiveDeviationAlarmType_LowLowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighLimit:
		return "NonExclusiveDeviationAlarmType_HighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighLimit:
		return "NonExclusiveDeviationAlarmType_HighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLimit:
		return "NonExclusiveDeviationAlarmType_LowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowLimit:
		return "NonExclusiveDeviationAlarmType_LowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode:
		return "NonExclusiveDeviationAlarmType_SetpointNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassId:
		return "NonExclusiveLimitAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionClassName:
		return "NonExclusiveLimitAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_InputNode:
		return "NonExclusiveLimitAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassId:
		return "NonExclusiveLevelAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionClassName:
		return "NonExclusiveLevelAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_InputNode:
		return "NonExclusiveLevelAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassId:
		return "NonExclusiveRateOfChangeAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionClassName:
		return "NonExclusiveRateOfChangeAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_InputNode:
		return "NonExclusiveRateOfChangeAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassId:
		return "NonExclusiveDeviationAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionClassName:
		return "NonExclusiveDeviationAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_InputNode:
		return "NonExclusiveDeviationAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_RedundancySupport:
		return "NonTransparentNetworkRedundancyType_RedundancySupport"
	case OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerUriArray:
		return "NonTransparentNetworkRedundancyType_ServerUriArray"
	case OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups:
		return "NonTransparentNetworkRedundancyType_ServerNetworkGroups"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments:
		return "NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments:
		return "NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments:
		return "NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassId:
		return "NonExclusiveLimitAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionSubClassName:
		return "NonExclusiveLimitAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState:
		return "NonExclusiveLimitAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Id:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Name:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_Number:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_TrueState:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OutOfServiceState_FalseState:
		return "NonExclusiveLimitAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState:
		return "NonExclusiveLimitAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Id:
		return "NonExclusiveLimitAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Name:
		return "NonExclusiveLimitAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_Number:
		return "NonExclusiveLimitAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TransitionTime:
		return "NonExclusiveLimitAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_TrueState:
		return "NonExclusiveLimitAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SilenceState_FalseState:
		return "NonExclusiveLimitAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleEnabled:
		return "NonExclusiveLimitAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound:
		return "NonExclusiveLimitAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OnDelay:
		return "NonExclusiveLimitAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_OffDelay:
		return "NonExclusiveLimitAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_FirstInGroupFlag:
		return "NonExclusiveLimitAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmTime:
		return "NonExclusiveLimitAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReAlarmRepeatCount:
		return "NonExclusiveLimitAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighHighLimit:
		return "NonExclusiveLimitAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseHighLimit:
		return "NonExclusiveLimitAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLimit:
		return "NonExclusiveLimitAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BaseLowLowLimit:
		return "NonExclusiveLimitAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassId:
		return "NonExclusiveLevelAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ConditionSubClassName:
		return "NonExclusiveLevelAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState:
		return "NonExclusiveLevelAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Id:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Name:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_Number:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_TrueState:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OutOfServiceState_FalseState:
		return "NonExclusiveLevelAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState:
		return "NonExclusiveLevelAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Id:
		return "NonExclusiveLevelAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Name:
		return "NonExclusiveLevelAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_Number:
		return "NonExclusiveLevelAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TransitionTime:
		return "NonExclusiveLevelAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_TrueState:
		return "NonExclusiveLevelAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SilenceState_FalseState:
		return "NonExclusiveLevelAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleEnabled:
		return "NonExclusiveLevelAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound:
		return "NonExclusiveLevelAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OnDelay:
		return "NonExclusiveLevelAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_OffDelay:
		return "NonExclusiveLevelAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_FirstInGroupFlag:
		return "NonExclusiveLevelAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmTime:
		return "NonExclusiveLevelAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ReAlarmRepeatCount:
		return "NonExclusiveLevelAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighHighLimit:
		return "NonExclusiveLevelAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseHighLimit:
		return "NonExclusiveLevelAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLimit:
		return "NonExclusiveLevelAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_BaseLowLowLimit:
		return "NonExclusiveLevelAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassId:
		return "NonExclusiveDeviationAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ConditionSubClassName:
		return "NonExclusiveDeviationAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Id:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Name:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_Number:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState:
		return "NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState:
		return "NonExclusiveDeviationAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Id:
		return "NonExclusiveDeviationAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Name:
		return "NonExclusiveDeviationAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_Number:
		return "NonExclusiveDeviationAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_TrueState:
		return "NonExclusiveDeviationAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SilenceState_FalseState:
		return "NonExclusiveDeviationAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleEnabled:
		return "NonExclusiveDeviationAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound:
		return "NonExclusiveDeviationAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OnDelay:
		return "NonExclusiveDeviationAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_OffDelay:
		return "NonExclusiveDeviationAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_FirstInGroupFlag:
		return "NonExclusiveDeviationAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmTime:
		return "NonExclusiveDeviationAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ReAlarmRepeatCount:
		return "NonExclusiveDeviationAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighHighLimit:
		return "NonExclusiveDeviationAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseHighLimit:
		return "NonExclusiveDeviationAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLimit:
		return "NonExclusiveDeviationAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseLowLowLimit:
		return "NonExclusiveDeviationAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode:
		return "NonExclusiveDeviationAlarmType_BaseSetpointNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassId:
		return "NonExclusiveRateOfChangeAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ConditionSubClassName:
		return "NonExclusiveRateOfChangeAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Id:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Name:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_Number:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleEnabled:
		return "NonExclusiveRateOfChangeAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound:
		return "NonExclusiveRateOfChangeAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OnDelay:
		return "NonExclusiveRateOfChangeAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_OffDelay:
		return "NonExclusiveRateOfChangeAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag:
		return "NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmTime:
		return "NonExclusiveRateOfChangeAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount:
		return "NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit:
		return "NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseHighLimit:
		return "NonExclusiveRateOfChangeAlarmType_BaseHighLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLimit:
		return "NonExclusiveRateOfChangeAlarmType_BaseLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit:
		return "NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits:
		return "NonExclusiveRateOfChangeAlarmType_EngineeringUnits"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableStates:
		return "NonExclusiveLimitAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions:
		return "NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableStates:
		return "NonExclusiveLevelAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions:
		return "NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates:
		return "NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions:
		return "NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_ListId:
		return "NonExclusiveLimitAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_AgencyId:
		return "NonExclusiveLimitAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AudibleSound_VersionId:
		return "NonExclusiveLimitAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_ListId:
		return "NonExclusiveDeviationAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_AgencyId:
		return "NonExclusiveDeviationAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_AudibleSound_VersionId:
		return "NonExclusiveDeviationAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId:
		return "NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId:
		return "NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId:
		return "NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState:
		return "NonExclusiveLimitAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Id:
		return "NonExclusiveLimitAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Name:
		return "NonExclusiveLimitAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_Number:
		return "NonExclusiveLimitAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TransitionTime:
		return "NonExclusiveLimitAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_TrueState:
		return "NonExclusiveLimitAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LatchedState_FalseState:
		return "NonExclusiveLimitAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_ListId:
		return "NonExclusiveLevelAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_AgencyId:
		return "NonExclusiveLevelAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_AudibleSound_VersionId:
		return "NonExclusiveLevelAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState:
		return "NonExclusiveLevelAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Id:
		return "NonExclusiveLevelAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Name:
		return "NonExclusiveLevelAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_Number:
		return "NonExclusiveLevelAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName:
		return "NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TransitionTime:
		return "NonExclusiveLevelAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime:
		return "NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_TrueState:
		return "NonExclusiveLevelAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LatchedState_FalseState:
		return "NonExclusiveLevelAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState:
		return "NonExclusiveDeviationAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Id:
		return "NonExclusiveDeviationAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Name:
		return "NonExclusiveDeviationAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_Number:
		return "NonExclusiveDeviationAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName:
		return "NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TransitionTime:
		return "NonExclusiveDeviationAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime:
		return "NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_TrueState:
		return "NonExclusiveDeviationAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LatchedState_FalseState:
		return "NonExclusiveDeviationAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Id:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Name:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_Number:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState:
		return "NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray:
		return "NonTransparentRedundancyType_ServerUriArray"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Suppress2_InputArguments:
		return "NonExclusiveLimitAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Unsuppress2_InputArguments:
		return "NonExclusiveLimitAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments:
		return "NonExclusiveLimitAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_PlaceInService2_InputArguments:
		return "NonExclusiveLimitAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Reset2_InputArguments:
		return "NonExclusiveLimitAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Suppress2_InputArguments:
		return "NonExclusiveLevelAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Unsuppress2_InputArguments:
		return "NonExclusiveLevelAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments:
		return "NonExclusiveLevelAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_PlaceInService2_InputArguments:
		return "NonExclusiveLevelAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_Reset2_InputArguments:
		return "NonExclusiveLevelAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Suppress2_InputArguments:
		return "NonExclusiveDeviationAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments:
		return "NonExclusiveDeviationAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments:
		return "NonExclusiveDeviationAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments:
		return "NonExclusiveDeviationAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_Reset2_InputArguments:
		return "NonExclusiveDeviationAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "NonExclusiveLimitAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "NonExclusiveLimitAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHighHigh:
		return "NonExclusiveLimitAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityHigh:
		return "NonExclusiveLimitAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLow:
		return "NonExclusiveLimitAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SeverityLowLow:
		return "NonExclusiveLimitAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighDeadband:
		return "NonExclusiveLimitAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighDeadband:
		return "NonExclusiveLimitAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowDeadband:
		return "NonExclusiveLimitAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowDeadband:
		return "NonExclusiveLimitAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "NonExclusiveLevelAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "NonExclusiveLevelAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHighHigh:
		return "NonExclusiveLevelAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityHigh:
		return "NonExclusiveLevelAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLow:
		return "NonExclusiveLevelAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SeverityLowLow:
		return "NonExclusiveLevelAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighHighDeadband:
		return "NonExclusiveLevelAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_HighDeadband:
		return "NonExclusiveLevelAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowDeadband:
		return "NonExclusiveLevelAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_LowLowDeadband:
		return "NonExclusiveLevelAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "NonExclusiveDeviationAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHighHigh:
		return "NonExclusiveDeviationAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityHigh:
		return "NonExclusiveDeviationAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLow:
		return "NonExclusiveDeviationAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SeverityLowLow:
		return "NonExclusiveDeviationAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighHighDeadband:
		return "NonExclusiveDeviationAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_HighDeadband:
		return "NonExclusiveDeviationAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowDeadband:
		return "NonExclusiveDeviationAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_LowLowDeadband:
		return "NonExclusiveDeviationAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHighHigh:
		return "NonExclusiveRateOfChangeAlarmType_SeverityHighHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityHigh:
		return "NonExclusiveRateOfChangeAlarmType_SeverityHigh"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLow:
		return "NonExclusiveRateOfChangeAlarmType_SeverityLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SeverityLowLow:
		return "NonExclusiveRateOfChangeAlarmType_SeverityLowLow"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighHighDeadband:
		return "NonExclusiveRateOfChangeAlarmType_HighHighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_HighDeadband:
		return "NonExclusiveRateOfChangeAlarmType_HighDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowDeadband:
		return "NonExclusiveRateOfChangeAlarmType_LowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_LowLowDeadband:
		return "NonExclusiveRateOfChangeAlarmType_LowLowDeadband"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments:
		return "NonExclusiveLimitAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments:
		return "NonExclusiveLevelAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments:
		return "NonExclusiveDeviationAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments:
		return "NonExclusiveRateOfChangeAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_RedundancySupport:
		return "NonTransparentRedundancyType_RedundancySupport"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SupportsFilteredRetain:
		return "NonExclusiveLimitAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLevelAlarmType_SupportsFilteredRetain:
		return "NonExclusiveLevelAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SupportsFilteredRetain:
		return "NonExclusiveDeviationAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain:
		return "NonExclusiveRateOfChangeAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventId:
		return "NonExclusiveLimitAlarmType_EventId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EventType:
		return "NonExclusiveLimitAlarmType_EventType"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceNode:
		return "NonExclusiveLimitAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SourceName:
		return "NonExclusiveLimitAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Time:
		return "NonExclusiveLimitAlarmType_Time"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ReceiveTime:
		return "NonExclusiveLimitAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LocalTime:
		return "NonExclusiveLimitAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Message:
		return "NonExclusiveLimitAlarmType_Message"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Severity:
		return "NonExclusiveLimitAlarmType_Severity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionName:
		return "NonExclusiveLimitAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_BranchId:
		return "NonExclusiveLimitAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Retain:
		return "NonExclusiveLimitAlarmType_Retain"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState:
		return "NonExclusiveLimitAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Id:
		return "NonExclusiveLimitAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Name:
		return "NonExclusiveLimitAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_Number:
		return "NonExclusiveLimitAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TransitionTime:
		return "NonExclusiveLimitAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_TrueState:
		return "NonExclusiveLimitAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_EnabledState_FalseState:
		return "NonExclusiveLimitAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality:
		return "NonExclusiveLimitAlarmType_Quality"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Quality_SourceTimestamp:
		return "NonExclusiveLimitAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity:
		return "NonExclusiveLimitAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp:
		return "NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment:
		return "NonExclusiveLimitAlarmType_Comment"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Comment_SourceTimestamp:
		return "NonExclusiveLimitAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ClientUserId:
		return "NonExclusiveLimitAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AddComment_InputArguments:
		return "NonExclusiveLimitAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments:
		return "NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState:
		return "NonExclusiveLimitAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Id:
		return "NonExclusiveLimitAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Name:
		return "NonExclusiveLimitAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_Number:
		return "NonExclusiveLimitAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TransitionTime:
		return "NonExclusiveLimitAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_TrueState:
		return "NonExclusiveLimitAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_AckedState_FalseState:
		return "NonExclusiveLimitAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState:
		return "NonExclusiveLimitAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Id:
		return "NonExclusiveLimitAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Name:
		return "NonExclusiveLimitAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_Number:
		return "NonExclusiveLimitAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime:
		return "NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_TrueState:
		return "NonExclusiveLimitAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ConfirmedState_FalseState:
		return "NonExclusiveLimitAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Acknowledge_InputArguments:
		return "NonExclusiveLimitAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_Confirm_InputArguments:
		return "NonExclusiveLimitAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState:
		return "NonExclusiveLimitAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id:
		return "NonExclusiveLimitAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name:
		return "NonExclusiveLimitAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number:
		return "NonExclusiveLimitAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime:
		return "NonExclusiveLimitAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState:
		return "NonExclusiveLimitAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState:
		return "NonExclusiveLimitAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState:
		return "NonExclusiveLimitAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Id:
		return "NonExclusiveLimitAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Name:
		return "NonExclusiveLimitAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_Number:
		return "NonExclusiveLimitAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TransitionTime:
		return "NonExclusiveLimitAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_TrueState:
		return "NonExclusiveLimitAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_SuppressedState_FalseState:
		return "NonExclusiveLimitAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState:
		return "NonExclusiveLimitAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id:
		return "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name:
		return "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number:
		return "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime:
		return "NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableNon) String() string {
	return e.PLC4XEnumName()
}
