/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDiscrete is an enum
type OpcuaNodeIdServicesVariableDiscrete int32

type IOpcuaNodeIdServicesVariableDiscrete interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_Definition                                            OpcuaNodeIdServicesVariableDiscrete = 3776
	OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_ValuePrecision                                        OpcuaNodeIdServicesVariableDiscrete = 3777
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventId                                              OpcuaNodeIdServicesVariableDiscrete = 10524
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventType                                            OpcuaNodeIdServicesVariableDiscrete = 10525
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableDiscrete = 10526
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceName                                           OpcuaNodeIdServicesVariableDiscrete = 10527
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Time                                                 OpcuaNodeIdServicesVariableDiscrete = 10528
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableDiscrete = 10529
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableDiscrete = 10530
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Message                                              OpcuaNodeIdServicesVariableDiscrete = 10531
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Severity                                             OpcuaNodeIdServicesVariableDiscrete = 10532
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableDiscrete = 10533
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_BranchId                                             OpcuaNodeIdServicesVariableDiscrete = 10534
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Retain                                               OpcuaNodeIdServicesVariableDiscrete = 10535
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableDiscrete = 10536
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableDiscrete = 10537
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableDiscrete = 10538
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableDiscrete = 10539
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrete = 10540
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrete = 10541
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrete = 10542
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableDiscrete = 10543
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableDiscrete = 10544
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality                                              OpcuaNodeIdServicesVariableDiscrete = 10545
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableDiscrete = 10546
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableDiscrete = 10547
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableDiscrete = 10548
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment                                              OpcuaNodeIdServicesVariableDiscrete = 10549
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableDiscrete = 10550
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableDiscrete = 10551
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableDiscrete = 10555
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableDiscrete = 10557
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState                                           OpcuaNodeIdServicesVariableDiscrete = 10558
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableDiscrete = 10559
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableDiscrete = 10560
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableDiscrete = 10561
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableDiscrete = 10562
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableDiscrete = 10563
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableDiscrete = 10564
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableDiscrete = 10565
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableDiscrete = 10566
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableDiscrete = 10567
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableDiscrete = 10568
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableDiscrete = 10569
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableDiscrete = 10570
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableDiscrete = 10571
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableDiscrete = 10572
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableDiscrete = 10573
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableDiscrete = 10574
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableDiscrete = 10575
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableDiscrete = 10577
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableDiscrete = 10579
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableDiscrete = 10580
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableDiscrete = 10581
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableDiscrete = 10582
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableDiscrete = 10583
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableDiscrete = 10584
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableDiscrete = 10585
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableDiscrete = 10586
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableDiscrete = 10587
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableDiscrete = 10588
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableDiscrete = 10589
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableDiscrete = 10590
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableDiscrete = 10591
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableDiscrete = 10592
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableDiscrete = 10593
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableDiscrete = 10594
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableDiscrete = 10595
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableDiscrete = 10596
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableDiscrete = 10597
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableDiscrete = 10599
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableDiscrete = 10600
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableDiscrete = 10601
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableDiscrete = 10602
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableDiscrete = 10603
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableDiscrete = 10604
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableDiscrete = 10605
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableDiscrete = 10606
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableDiscrete = 10607
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableDiscrete = 10608
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableDiscrete = 10609
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableDiscrete = 10634
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableDiscrete = 10635
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableDiscrete = 10636
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableDiscrete = 11152
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableDiscrete = 11153
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_InputNode                                            OpcuaNodeIdServicesVariableDiscrete = 11154
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableDiscrete = 11481
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableDiscrete = 13005
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableDiscrete = 16900
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableDiscrete = 16901
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableDiscrete = 16902
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableDiscrete = 16903
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableDiscrete = 16904
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableDiscrete = 16905
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableDiscrete = 16906
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableDiscrete = 16907
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableDiscrete = 16908
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableDiscrete = 16909
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableDiscrete = 16910
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableDiscrete = 16911
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableDiscrete = 16912
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableDiscrete = 16913
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableDiscrete = 16914
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrete = 16915
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrete = 16916
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrete = 16917
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableDiscrete = 16918
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableDiscrete = 16919
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableDiscrete = 16920
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableDiscrete = 16921
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableDiscrete = 16926
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableDiscrete = 16927
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableDiscrete = 16928
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableDiscrete = 16931
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableDiscrete = 16932
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableDiscrete = 17692
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableDiscrete = 17693
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableDiscrete = 17942
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableDiscrete = 17943
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableDiscrete = 17944
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableDiscrete = 18307
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableDiscrete = 18308
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableDiscrete = 18309
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableDiscrete = 18310
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrete = 18311
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrete = 18312
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrete = 18313
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableDiscrete = 18314
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableDiscrete = 18315
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableDiscrete = 24429
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableDiscrete = 24431
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableDiscrete = 24433
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableDiscrete = 24435
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableDiscrete = 24437
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableDiscrete = 24907
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableDiscrete = 24909
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableDiscrete = 24911
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableDiscrete = 25168
	OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableDiscrete = 32236
)

var OpcuaNodeIdServicesVariableDiscreteValues []OpcuaNodeIdServicesVariableDiscrete

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDiscreteValues = []OpcuaNodeIdServicesVariableDiscrete{
		OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_Definition,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_ValuePrecision,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventType,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Time,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Message,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Severity,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_BranchId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Retain,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_InputNode,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableDiscreteByValue(value int32) (enum OpcuaNodeIdServicesVariableDiscrete, ok bool) {
	switch value {
	case 10524:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventId, true
	case 10525:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventType, true
	case 10526:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceNode, true
	case 10527:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceName, true
	case 10528:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Time, true
	case 10529:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReceiveTime, true
	case 10530:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LocalTime, true
	case 10531:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Message, true
	case 10532:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Severity, true
	case 10533:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionName, true
	case 10534:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_BranchId, true
	case 10535:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Retain, true
	case 10536:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState, true
	case 10537:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Id, true
	case 10538:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Name, true
	case 10539:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Number, true
	case 10540:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveDisplayName, true
	case 10541:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TransitionTime, true
	case 10542:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveTransitionTime, true
	case 10543:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TrueState, true
	case 10544:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_FalseState, true
	case 10545:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality, true
	case 10546:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality_SourceTimestamp, true
	case 10547:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity, true
	case 10548:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity_SourceTimestamp, true
	case 10549:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment, true
	case 10550:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment_SourceTimestamp, true
	case 10551:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ClientUserId, true
	case 10555:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AddComment_InputArguments, true
	case 10557:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh_InputArguments, true
	case 10558:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState, true
	case 10559:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Id, true
	case 10560:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Name, true
	case 10561:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Number, true
	case 10562:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveDisplayName, true
	case 10563:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TransitionTime, true
	case 10564:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveTransitionTime, true
	case 10565:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TrueState, true
	case 10566:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_FalseState, true
	case 10567:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState, true
	case 10568:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Id, true
	case 10569:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Name, true
	case 10570:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Number, true
	case 10571:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 10572:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TransitionTime, true
	case 10573:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 10574:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TrueState, true
	case 10575:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_FalseState, true
	case 10577:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Acknowledge_InputArguments, true
	case 10579:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Confirm_InputArguments, true
	case 10580:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState, true
	case 10581:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Id, true
	case 10582:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Name, true
	case 10583:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Number, true
	case 10584:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveDisplayName, true
	case 10585:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TransitionTime, true
	case 10586:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveTransitionTime, true
	case 10587:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TrueState, true
	case 10588:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_FalseState, true
	case 10589:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState, true
	case 10590:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Id, true
	case 10591:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Name, true
	case 10592:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Number, true
	case 10593:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveDisplayName, true
	case 10594:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TransitionTime, true
	case 10595:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 10596:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TrueState, true
	case 10597:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_FalseState, true
	case 10599:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState, true
	case 10600:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Id, true
	case 10601:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Name, true
	case 10602:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Number, true
	case 10603:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 10604:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition, true
	case 10605:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Id, true
	case 10606:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Name, true
	case 10607:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Number, true
	case 10608:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 10609:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_UnshelveTime, true
	case 10634:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 10635:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedOrShelved, true
	case 10636:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_MaxTimeShelved, true
	case 11152:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassId, true
	case 11153:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassName, true
	case 11154:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_InputNode, true
	case 11481:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 13005:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh2_InputArguments, true
	case 16900:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassId, true
	case 16901:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassName, true
	case 16902:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState, true
	case 16903:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Id, true
	case 16904:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Name, true
	case 16905:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Number, true
	case 16906:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 16907:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TransitionTime, true
	case 16908:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 16909:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TrueState, true
	case 16910:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_FalseState, true
	case 16911:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState, true
	case 16912:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Id, true
	case 16913:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Name, true
	case 16914:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Number, true
	case 16915:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveDisplayName, true
	case 16916:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TransitionTime, true
	case 16917:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveTransitionTime, true
	case 16918:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TrueState, true
	case 16919:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_FalseState, true
	case 16920:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleEnabled, true
	case 16921:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound, true
	case 16926:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OnDelay, true
	case 16927:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OffDelay, true
	case 16928:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_FirstInGroupFlag, true
	case 16931:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmTime, true
	case 16932:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmRepeatCount, true
	case 17692:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableStates, true
	case 17693:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableTransitions, true
	case 17942:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_ListId, true
	case 17943:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_AgencyId, true
	case 17944:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_VersionId, true
	case 18307:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState, true
	case 18308:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Id, true
	case 18309:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Name, true
	case 18310:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Number, true
	case 18311:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveDisplayName, true
	case 18312:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TransitionTime, true
	case 18313:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18314:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TrueState, true
	case 18315:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_FalseState, true
	case 24429:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Suppress2_InputArguments, true
	case 24431:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Unsuppress2_InputArguments, true
	case 24433:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_RemoveFromService2_InputArguments, true
	case 24435:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_PlaceInService2_InputArguments, true
	case 24437:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Reset2_InputArguments, true
	case 24907:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24909:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24911:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 25168:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_GetGroupMemberships_OutputArguments, true
	case 32236:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SupportsFilteredRetain, true
	case 3776:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_Definition, true
	case 3777:
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_ValuePrecision, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscreteByName(value string) (enum OpcuaNodeIdServicesVariableDiscrete, ok bool) {
	switch value {
	case "DiscreteAlarmType_EventId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventId, true
	case "DiscreteAlarmType_EventType":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventType, true
	case "DiscreteAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceNode, true
	case "DiscreteAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceName, true
	case "DiscreteAlarmType_Time":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Time, true
	case "DiscreteAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReceiveTime, true
	case "DiscreteAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LocalTime, true
	case "DiscreteAlarmType_Message":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Message, true
	case "DiscreteAlarmType_Severity":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Severity, true
	case "DiscreteAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionName, true
	case "DiscreteAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_BranchId, true
	case "DiscreteAlarmType_Retain":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Retain, true
	case "DiscreteAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState, true
	case "DiscreteAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Id, true
	case "DiscreteAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Name, true
	case "DiscreteAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Number, true
	case "DiscreteAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveDisplayName, true
	case "DiscreteAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TransitionTime, true
	case "DiscreteAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TrueState, true
	case "DiscreteAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_FalseState, true
	case "DiscreteAlarmType_Quality":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality, true
	case "DiscreteAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality_SourceTimestamp, true
	case "DiscreteAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity, true
	case "DiscreteAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity_SourceTimestamp, true
	case "DiscreteAlarmType_Comment":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment, true
	case "DiscreteAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment_SourceTimestamp, true
	case "DiscreteAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ClientUserId, true
	case "DiscreteAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AddComment_InputArguments, true
	case "DiscreteAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh_InputArguments, true
	case "DiscreteAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState, true
	case "DiscreteAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Id, true
	case "DiscreteAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Name, true
	case "DiscreteAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Number, true
	case "DiscreteAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveDisplayName, true
	case "DiscreteAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TransitionTime, true
	case "DiscreteAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TrueState, true
	case "DiscreteAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_FalseState, true
	case "DiscreteAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState, true
	case "DiscreteAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Id, true
	case "DiscreteAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Name, true
	case "DiscreteAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Number, true
	case "DiscreteAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "DiscreteAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TransitionTime, true
	case "DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TrueState, true
	case "DiscreteAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_FalseState, true
	case "DiscreteAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Acknowledge_InputArguments, true
	case "DiscreteAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Confirm_InputArguments, true
	case "DiscreteAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState, true
	case "DiscreteAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Id, true
	case "DiscreteAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Name, true
	case "DiscreteAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Number, true
	case "DiscreteAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveDisplayName, true
	case "DiscreteAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TransitionTime, true
	case "DiscreteAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TrueState, true
	case "DiscreteAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_FalseState, true
	case "DiscreteAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState, true
	case "DiscreteAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Id, true
	case "DiscreteAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Name, true
	case "DiscreteAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Number, true
	case "DiscreteAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveDisplayName, true
	case "DiscreteAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TransitionTime, true
	case "DiscreteAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TrueState, true
	case "DiscreteAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_FalseState, true
	case "DiscreteAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState, true
	case "DiscreteAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Id, true
	case "DiscreteAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Name, true
	case "DiscreteAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Number, true
	case "DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "DiscreteAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition, true
	case "DiscreteAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Id, true
	case "DiscreteAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Name, true
	case "DiscreteAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Number, true
	case "DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "DiscreteAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_UnshelveTime, true
	case "DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "DiscreteAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedOrShelved, true
	case "DiscreteAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_MaxTimeShelved, true
	case "DiscreteAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassId, true
	case "DiscreteAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassName, true
	case "DiscreteAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_InputNode, true
	case "DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "DiscreteAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh2_InputArguments, true
	case "DiscreteAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassId, true
	case "DiscreteAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassName, true
	case "DiscreteAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState, true
	case "DiscreteAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Id, true
	case "DiscreteAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Name, true
	case "DiscreteAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Number, true
	case "DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "DiscreteAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TransitionTime, true
	case "DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TrueState, true
	case "DiscreteAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_FalseState, true
	case "DiscreteAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState, true
	case "DiscreteAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Id, true
	case "DiscreteAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Name, true
	case "DiscreteAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Number, true
	case "DiscreteAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveDisplayName, true
	case "DiscreteAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TransitionTime, true
	case "DiscreteAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TrueState, true
	case "DiscreteAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_FalseState, true
	case "DiscreteAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleEnabled, true
	case "DiscreteAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound, true
	case "DiscreteAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OnDelay, true
	case "DiscreteAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OffDelay, true
	case "DiscreteAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_FirstInGroupFlag, true
	case "DiscreteAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmTime, true
	case "DiscreteAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmRepeatCount, true
	case "DiscreteAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableStates, true
	case "DiscreteAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableTransitions, true
	case "DiscreteAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_ListId, true
	case "DiscreteAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_AgencyId, true
	case "DiscreteAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_VersionId, true
	case "DiscreteAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState, true
	case "DiscreteAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Id, true
	case "DiscreteAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Name, true
	case "DiscreteAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Number, true
	case "DiscreteAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveDisplayName, true
	case "DiscreteAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TransitionTime, true
	case "DiscreteAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveTransitionTime, true
	case "DiscreteAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TrueState, true
	case "DiscreteAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_FalseState, true
	case "DiscreteAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Suppress2_InputArguments, true
	case "DiscreteAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Unsuppress2_InputArguments, true
	case "DiscreteAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_RemoveFromService2_InputArguments, true
	case "DiscreteAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_PlaceInService2_InputArguments, true
	case "DiscreteAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Reset2_InputArguments, true
	case "DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "DiscreteAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_GetGroupMemberships_OutputArguments, true
	case "DiscreteAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SupportsFilteredRetain, true
	case "DiscreteItemType_Definition":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_Definition, true
	case "DiscreteItemType_ValuePrecision":
		return OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_ValuePrecision, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscreteKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDiscreteValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDiscrete(structType any) OpcuaNodeIdServicesVariableDiscrete {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDiscrete {
		if sOpcuaNodeIdServicesVariableDiscrete, ok := typ.(OpcuaNodeIdServicesVariableDiscrete); ok {
			return sOpcuaNodeIdServicesVariableDiscrete
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDiscrete) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDiscrete) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDiscreteParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDiscrete, error) {
	return OpcuaNodeIdServicesVariableDiscreteParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDiscreteParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDiscrete, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDiscrete", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDiscrete")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDiscreteByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDiscrete")
		return OpcuaNodeIdServicesVariableDiscrete(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDiscrete) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDiscrete) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDiscrete", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDiscrete) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventId:
		return "DiscreteAlarmType_EventId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EventType:
		return "DiscreteAlarmType_EventType"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceNode:
		return "DiscreteAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SourceName:
		return "DiscreteAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Time:
		return "DiscreteAlarmType_Time"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReceiveTime:
		return "DiscreteAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LocalTime:
		return "DiscreteAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Message:
		return "DiscreteAlarmType_Message"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Severity:
		return "DiscreteAlarmType_Severity"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionName:
		return "DiscreteAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_BranchId:
		return "DiscreteAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Retain:
		return "DiscreteAlarmType_Retain"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState:
		return "DiscreteAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Id:
		return "DiscreteAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Name:
		return "DiscreteAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_Number:
		return "DiscreteAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveDisplayName:
		return "DiscreteAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TransitionTime:
		return "DiscreteAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_EffectiveTransitionTime:
		return "DiscreteAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_TrueState:
		return "DiscreteAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_EnabledState_FalseState:
		return "DiscreteAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality:
		return "DiscreteAlarmType_Quality"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Quality_SourceTimestamp:
		return "DiscreteAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity:
		return "DiscreteAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LastSeverity_SourceTimestamp:
		return "DiscreteAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment:
		return "DiscreteAlarmType_Comment"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Comment_SourceTimestamp:
		return "DiscreteAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ClientUserId:
		return "DiscreteAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AddComment_InputArguments:
		return "DiscreteAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh_InputArguments:
		return "DiscreteAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState:
		return "DiscreteAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Id:
		return "DiscreteAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Name:
		return "DiscreteAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_Number:
		return "DiscreteAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveDisplayName:
		return "DiscreteAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TransitionTime:
		return "DiscreteAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_EffectiveTransitionTime:
		return "DiscreteAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_TrueState:
		return "DiscreteAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AckedState_FalseState:
		return "DiscreteAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState:
		return "DiscreteAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Id:
		return "DiscreteAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Name:
		return "DiscreteAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_Number:
		return "DiscreteAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveDisplayName:
		return "DiscreteAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TransitionTime:
		return "DiscreteAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_TrueState:
		return "DiscreteAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConfirmedState_FalseState:
		return "DiscreteAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Acknowledge_InputArguments:
		return "DiscreteAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Confirm_InputArguments:
		return "DiscreteAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState:
		return "DiscreteAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Id:
		return "DiscreteAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Name:
		return "DiscreteAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_Number:
		return "DiscreteAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveDisplayName:
		return "DiscreteAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TransitionTime:
		return "DiscreteAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_EffectiveTransitionTime:
		return "DiscreteAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_TrueState:
		return "DiscreteAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ActiveState_FalseState:
		return "DiscreteAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState:
		return "DiscreteAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Id:
		return "DiscreteAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Name:
		return "DiscreteAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_Number:
		return "DiscreteAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveDisplayName:
		return "DiscreteAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TransitionTime:
		return "DiscreteAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_EffectiveTransitionTime:
		return "DiscreteAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_TrueState:
		return "DiscreteAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedState_FalseState:
		return "DiscreteAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState:
		return "DiscreteAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Id:
		return "DiscreteAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Name:
		return "DiscreteAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_Number:
		return "DiscreteAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition:
		return "DiscreteAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Id:
		return "DiscreteAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Name:
		return "DiscreteAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_Number:
		return "DiscreteAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_UnshelveTime:
		return "DiscreteAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SuppressedOrShelved:
		return "DiscreteAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_MaxTimeShelved:
		return "DiscreteAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassId:
		return "DiscreteAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionClassName:
		return "DiscreteAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_InputNode:
		return "DiscreteAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionRefresh2_InputArguments:
		return "DiscreteAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassId:
		return "DiscreteAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ConditionSubClassName:
		return "DiscreteAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState:
		return "DiscreteAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Id:
		return "DiscreteAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Name:
		return "DiscreteAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_Number:
		return "DiscreteAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TransitionTime:
		return "DiscreteAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_TrueState:
		return "DiscreteAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OutOfServiceState_FalseState:
		return "DiscreteAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState:
		return "DiscreteAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Id:
		return "DiscreteAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Name:
		return "DiscreteAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_Number:
		return "DiscreteAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveDisplayName:
		return "DiscreteAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TransitionTime:
		return "DiscreteAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_EffectiveTransitionTime:
		return "DiscreteAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_TrueState:
		return "DiscreteAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SilenceState_FalseState:
		return "DiscreteAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleEnabled:
		return "DiscreteAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound:
		return "DiscreteAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OnDelay:
		return "DiscreteAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_OffDelay:
		return "DiscreteAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_FirstInGroupFlag:
		return "DiscreteAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmTime:
		return "DiscreteAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ReAlarmRepeatCount:
		return "DiscreteAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableStates:
		return "DiscreteAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_AvailableTransitions:
		return "DiscreteAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_ListId:
		return "DiscreteAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_AgencyId:
		return "DiscreteAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_AudibleSound_VersionId:
		return "DiscreteAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState:
		return "DiscreteAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Id:
		return "DiscreteAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Name:
		return "DiscreteAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_Number:
		return "DiscreteAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveDisplayName:
		return "DiscreteAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TransitionTime:
		return "DiscreteAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_EffectiveTransitionTime:
		return "DiscreteAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_TrueState:
		return "DiscreteAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_LatchedState_FalseState:
		return "DiscreteAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Suppress2_InputArguments:
		return "DiscreteAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Unsuppress2_InputArguments:
		return "DiscreteAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_RemoveFromService2_InputArguments:
		return "DiscreteAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_PlaceInService2_InputArguments:
		return "DiscreteAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_Reset2_InputArguments:
		return "DiscreteAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "DiscreteAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "DiscreteAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "DiscreteAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_GetGroupMemberships_OutputArguments:
		return "DiscreteAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteAlarmType_SupportsFilteredRetain:
		return "DiscreteAlarmType_SupportsFilteredRetain"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_Definition:
		return "DiscreteItemType_Definition"
	case OpcuaNodeIdServicesVariableDiscrete_DiscreteItemType_ValuePrecision:
		return "DiscreteItemType_ValuePrecision"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDiscrete) String() string {
	return e.PLC4XEnumName()
}
