/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDiscrepancy is an enum
type OpcuaNodeIdServicesVariableDiscrepancy int32

type IOpcuaNodeIdServicesVariableDiscrepancy interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventId                                              OpcuaNodeIdServicesVariableDiscrepancy = 17081
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventType                                            OpcuaNodeIdServicesVariableDiscrepancy = 17082
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceNode                                           OpcuaNodeIdServicesVariableDiscrepancy = 17083
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceName                                           OpcuaNodeIdServicesVariableDiscrepancy = 17084
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Time                                                 OpcuaNodeIdServicesVariableDiscrepancy = 17085
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReceiveTime                                          OpcuaNodeIdServicesVariableDiscrepancy = 17086
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LocalTime                                            OpcuaNodeIdServicesVariableDiscrepancy = 17087
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Message                                              OpcuaNodeIdServicesVariableDiscrepancy = 17088
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Severity                                             OpcuaNodeIdServicesVariableDiscrepancy = 17089
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassId                                     OpcuaNodeIdServicesVariableDiscrepancy = 17090
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassName                                   OpcuaNodeIdServicesVariableDiscrepancy = 17091
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassId                                  OpcuaNodeIdServicesVariableDiscrepancy = 17092
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassName                                OpcuaNodeIdServicesVariableDiscrepancy = 17093
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionName                                        OpcuaNodeIdServicesVariableDiscrepancy = 17094
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_BranchId                                             OpcuaNodeIdServicesVariableDiscrepancy = 17095
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Retain                                               OpcuaNodeIdServicesVariableDiscrepancy = 17096
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState                                         OpcuaNodeIdServicesVariableDiscrepancy = 17097
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Id                                      OpcuaNodeIdServicesVariableDiscrepancy = 17098
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Name                                    OpcuaNodeIdServicesVariableDiscrepancy = 17099
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Number                                  OpcuaNodeIdServicesVariableDiscrepancy = 17100
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrepancy = 17101
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrepancy = 17102
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrepancy = 17103
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TrueState                               OpcuaNodeIdServicesVariableDiscrepancy = 17104
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_FalseState                              OpcuaNodeIdServicesVariableDiscrepancy = 17105
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality                                              OpcuaNodeIdServicesVariableDiscrepancy = 17106
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableDiscrepancy = 17107
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity                                         OpcuaNodeIdServicesVariableDiscrepancy = 17108
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableDiscrepancy = 17109
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment                                              OpcuaNodeIdServicesVariableDiscrepancy = 17110
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableDiscrepancy = 17111
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ClientUserId                                         OpcuaNodeIdServicesVariableDiscrepancy = 17112
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AddComment_InputArguments                            OpcuaNodeIdServicesVariableDiscrepancy = 17116
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh_InputArguments                      OpcuaNodeIdServicesVariableDiscrepancy = 17118
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh2_InputArguments                     OpcuaNodeIdServicesVariableDiscrepancy = 17120
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState                                           OpcuaNodeIdServicesVariableDiscrepancy = 17121
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Id                                        OpcuaNodeIdServicesVariableDiscrepancy = 17122
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Name                                      OpcuaNodeIdServicesVariableDiscrepancy = 17123
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Number                                    OpcuaNodeIdServicesVariableDiscrepancy = 17124
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableDiscrepancy = 17125
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableDiscrepancy = 17126
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableDiscrepancy = 17127
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TrueState                                 OpcuaNodeIdServicesVariableDiscrepancy = 17128
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_FalseState                                OpcuaNodeIdServicesVariableDiscrepancy = 17129
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState                                       OpcuaNodeIdServicesVariableDiscrepancy = 17130
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableDiscrepancy = 17131
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableDiscrepancy = 17132
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Number                                OpcuaNodeIdServicesVariableDiscrepancy = 17133
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableDiscrepancy = 17134
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableDiscrepancy = 17135
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableDiscrepancy = 17136
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableDiscrepancy = 17137
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableDiscrepancy = 17138
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableDiscrepancy = 17140
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Confirm_InputArguments                               OpcuaNodeIdServicesVariableDiscrepancy = 17142
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState                                          OpcuaNodeIdServicesVariableDiscrepancy = 17143
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Id                                       OpcuaNodeIdServicesVariableDiscrepancy = 17144
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Name                                     OpcuaNodeIdServicesVariableDiscrepancy = 17145
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Number                                   OpcuaNodeIdServicesVariableDiscrepancy = 17146
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableDiscrepancy = 17147
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableDiscrepancy = 17148
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableDiscrepancy = 17149
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TrueState                                OpcuaNodeIdServicesVariableDiscrepancy = 17150
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_FalseState                               OpcuaNodeIdServicesVariableDiscrepancy = 17151
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_InputNode                                            OpcuaNodeIdServicesVariableDiscrepancy = 17152
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState                                      OpcuaNodeIdServicesVariableDiscrepancy = 17153
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Id                                   OpcuaNodeIdServicesVariableDiscrepancy = 17154
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Name                                 OpcuaNodeIdServicesVariableDiscrepancy = 17155
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Number                               OpcuaNodeIdServicesVariableDiscrepancy = 17156
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableDiscrepancy = 17157
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableDiscrepancy = 17158
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableDiscrepancy = 17159
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableDiscrepancy = 17160
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableDiscrepancy = 17161
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState                                    OpcuaNodeIdServicesVariableDiscrepancy = 17162
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableDiscrepancy = 17163
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableDiscrepancy = 17164
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableDiscrepancy = 17165
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableDiscrepancy = 17166
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableDiscrepancy = 17167
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableDiscrepancy = 17168
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableDiscrepancy = 17169
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableDiscrepancy = 17170
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState                                         OpcuaNodeIdServicesVariableDiscrepancy = 17171
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Id                                      OpcuaNodeIdServicesVariableDiscrepancy = 17172
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Name                                    OpcuaNodeIdServicesVariableDiscrepancy = 17173
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Number                                  OpcuaNodeIdServicesVariableDiscrepancy = 17174
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrepancy = 17175
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrepancy = 17176
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrepancy = 17177
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TrueState                               OpcuaNodeIdServicesVariableDiscrepancy = 17178
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_FalseState                              OpcuaNodeIdServicesVariableDiscrepancy = 17179
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableDiscrepancy = 17181
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableDiscrepancy = 17182
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableDiscrepancy = 17183
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableDiscrepancy = 17184
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableDiscrepancy = 17185
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableDiscrepancy = 17186
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableDiscrepancy = 17187
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableDiscrepancy = 17188
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableDiscrepancy = 17189
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableDiscrepancy = 17190
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableDiscrepancy = 17191
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableDiscrepancy = 17192
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableDiscrepancy = 17196
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableDiscrepancy = 17197
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_MaxTimeShelved                                       OpcuaNodeIdServicesVariableDiscrepancy = 17198
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleEnabled                                       OpcuaNodeIdServicesVariableDiscrepancy = 17199
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound                                         OpcuaNodeIdServicesVariableDiscrepancy = 17200
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OnDelay                                              OpcuaNodeIdServicesVariableDiscrepancy = 17205
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OffDelay                                             OpcuaNodeIdServicesVariableDiscrepancy = 17206
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableDiscrepancy = 17207
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmTime                                          OpcuaNodeIdServicesVariableDiscrepancy = 17210
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableDiscrepancy = 17211
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode                                      OpcuaNodeIdServicesVariableDiscrepancy = 17215
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime                                         OpcuaNodeIdServicesVariableDiscrepancy = 17216
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance                                            OpcuaNodeIdServicesVariableDiscrepancy = 17217
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableDiscrepancy = 17702
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableDiscrepancy = 17703
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableDiscrepancy = 17977
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableDiscrepancy = 17978
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableDiscrepancy = 17979
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState                                         OpcuaNodeIdServicesVariableDiscrepancy = 18655
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Id                                      OpcuaNodeIdServicesVariableDiscrepancy = 18656
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Name                                    OpcuaNodeIdServicesVariableDiscrepancy = 18657
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Number                                  OpcuaNodeIdServicesVariableDiscrepancy = 18658
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableDiscrepancy = 18659
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableDiscrepancy = 18660
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableDiscrepancy = 18661
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TrueState                               OpcuaNodeIdServicesVariableDiscrepancy = 18662
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_FalseState                              OpcuaNodeIdServicesVariableDiscrepancy = 18663
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableDiscrepancy = 24499
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableDiscrepancy = 24501
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableDiscrepancy = 24503
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableDiscrepancy = 24505
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Reset2_InputArguments                                OpcuaNodeIdServicesVariableDiscrepancy = 24507
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableDiscrepancy = 24963
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableDiscrepancy = 24965
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableDiscrepancy = 24967
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableDiscrepancy = 25175
	OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SupportsFilteredRetain                               OpcuaNodeIdServicesVariableDiscrepancy = 32243
)

var OpcuaNodeIdServicesVariableDiscrepancyValues []OpcuaNodeIdServicesVariableDiscrepancy

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDiscrepancyValues = []OpcuaNodeIdServicesVariableDiscrepancy{
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventType,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceNode,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Time,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReceiveTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LocalTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Message,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Severity,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_BranchId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Retain,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ClientUserId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_InputNode,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_MaxTimeShelved,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleEnabled,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OnDelay,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OffDelay,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Id,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Name,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Number,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SupportsFilteredRetain,
	}
}

func OpcuaNodeIdServicesVariableDiscrepancyByValue(value int32) (enum OpcuaNodeIdServicesVariableDiscrepancy, ok bool) {
	switch value {
	case 17081:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventId, true
	case 17082:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventType, true
	case 17083:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceNode, true
	case 17084:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceName, true
	case 17085:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Time, true
	case 17086:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReceiveTime, true
	case 17087:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LocalTime, true
	case 17088:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Message, true
	case 17089:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Severity, true
	case 17090:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassId, true
	case 17091:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassName, true
	case 17092:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassId, true
	case 17093:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassName, true
	case 17094:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionName, true
	case 17095:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_BranchId, true
	case 17096:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Retain, true
	case 17097:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState, true
	case 17098:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Id, true
	case 17099:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Name, true
	case 17100:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Number, true
	case 17101:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveDisplayName, true
	case 17102:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TransitionTime, true
	case 17103:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime, true
	case 17104:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TrueState, true
	case 17105:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_FalseState, true
	case 17106:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality, true
	case 17107:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality_SourceTimestamp, true
	case 17108:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity, true
	case 17109:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity_SourceTimestamp, true
	case 17110:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment, true
	case 17111:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment_SourceTimestamp, true
	case 17112:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ClientUserId, true
	case 17116:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AddComment_InputArguments, true
	case 17118:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh_InputArguments, true
	case 17120:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh2_InputArguments, true
	case 17121:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState, true
	case 17122:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Id, true
	case 17123:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Name, true
	case 17124:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Number, true
	case 17125:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveDisplayName, true
	case 17126:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TransitionTime, true
	case 17127:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveTransitionTime, true
	case 17128:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TrueState, true
	case 17129:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_FalseState, true
	case 17130:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState, true
	case 17131:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Id, true
	case 17132:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Name, true
	case 17133:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Number, true
	case 17134:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName, true
	case 17135:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TransitionTime, true
	case 17136:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case 17137:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TrueState, true
	case 17138:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_FalseState, true
	case 17140:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Acknowledge_InputArguments, true
	case 17142:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Confirm_InputArguments, true
	case 17143:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState, true
	case 17144:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Id, true
	case 17145:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Name, true
	case 17146:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Number, true
	case 17147:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveDisplayName, true
	case 17148:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TransitionTime, true
	case 17149:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime, true
	case 17150:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TrueState, true
	case 17151:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_FalseState, true
	case 17152:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_InputNode, true
	case 17153:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState, true
	case 17154:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Id, true
	case 17155:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Name, true
	case 17156:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Number, true
	case 17157:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName, true
	case 17158:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TransitionTime, true
	case 17159:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime, true
	case 17160:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TrueState, true
	case 17161:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_FalseState, true
	case 17162:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState, true
	case 17163:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Id, true
	case 17164:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Name, true
	case 17165:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Number, true
	case 17166:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case 17167:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TransitionTime, true
	case 17168:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case 17169:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TrueState, true
	case 17170:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_FalseState, true
	case 17171:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState, true
	case 17172:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Id, true
	case 17173:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Name, true
	case 17174:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Number, true
	case 17175:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveDisplayName, true
	case 17176:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TransitionTime, true
	case 17177:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime, true
	case 17178:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TrueState, true
	case 17179:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_FalseState, true
	case 17181:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState, true
	case 17182:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Id, true
	case 17183:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Name, true
	case 17184:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Number, true
	case 17185:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 17186:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition, true
	case 17187:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Id, true
	case 17188:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Name, true
	case 17189:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Number, true
	case 17190:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case 17191:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 17192:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_UnshelveTime, true
	case 17196:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case 17197:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedOrShelved, true
	case 17198:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_MaxTimeShelved, true
	case 17199:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleEnabled, true
	case 17200:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound, true
	case 17205:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OnDelay, true
	case 17206:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OffDelay, true
	case 17207:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_FirstInGroupFlag, true
	case 17210:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmTime, true
	case 17211:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmRepeatCount, true
	case 17215:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode, true
	case 17216:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime, true
	case 17217:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance, true
	case 17702:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableStates, true
	case 17703:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableTransitions, true
	case 17977:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_ListId, true
	case 17978:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_AgencyId, true
	case 17979:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_VersionId, true
	case 18655:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState, true
	case 18656:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Id, true
	case 18657:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Name, true
	case 18658:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Number, true
	case 18659:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveDisplayName, true
	case 18660:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TransitionTime, true
	case 18661:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime, true
	case 18662:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TrueState, true
	case 18663:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_FalseState, true
	case 24499:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Suppress2_InputArguments, true
	case 24501:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Unsuppress2_InputArguments, true
	case 24503:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_RemoveFromService2_InputArguments, true
	case 24505:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_PlaceInService2_InputArguments, true
	case 24507:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Reset2_InputArguments, true
	case 24963:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case 24965:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case 24967:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case 25175:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments, true
	case 32243:
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscrepancyByName(value string) (enum OpcuaNodeIdServicesVariableDiscrepancy, ok bool) {
	switch value {
	case "DiscrepancyAlarmType_EventId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventId, true
	case "DiscrepancyAlarmType_EventType":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventType, true
	case "DiscrepancyAlarmType_SourceNode":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceNode, true
	case "DiscrepancyAlarmType_SourceName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceName, true
	case "DiscrepancyAlarmType_Time":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Time, true
	case "DiscrepancyAlarmType_ReceiveTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReceiveTime, true
	case "DiscrepancyAlarmType_LocalTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LocalTime, true
	case "DiscrepancyAlarmType_Message":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Message, true
	case "DiscrepancyAlarmType_Severity":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Severity, true
	case "DiscrepancyAlarmType_ConditionClassId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassId, true
	case "DiscrepancyAlarmType_ConditionClassName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassName, true
	case "DiscrepancyAlarmType_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassId, true
	case "DiscrepancyAlarmType_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassName, true
	case "DiscrepancyAlarmType_ConditionName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionName, true
	case "DiscrepancyAlarmType_BranchId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_BranchId, true
	case "DiscrepancyAlarmType_Retain":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Retain, true
	case "DiscrepancyAlarmType_EnabledState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState, true
	case "DiscrepancyAlarmType_EnabledState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Id, true
	case "DiscrepancyAlarmType_EnabledState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Name, true
	case "DiscrepancyAlarmType_EnabledState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Number, true
	case "DiscrepancyAlarmType_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TransitionTime, true
	case "DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TrueState, true
	case "DiscrepancyAlarmType_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_FalseState, true
	case "DiscrepancyAlarmType_Quality":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality, true
	case "DiscrepancyAlarmType_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality_SourceTimestamp, true
	case "DiscrepancyAlarmType_LastSeverity":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity, true
	case "DiscrepancyAlarmType_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity_SourceTimestamp, true
	case "DiscrepancyAlarmType_Comment":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment, true
	case "DiscrepancyAlarmType_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment_SourceTimestamp, true
	case "DiscrepancyAlarmType_ClientUserId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ClientUserId, true
	case "DiscrepancyAlarmType_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AddComment_InputArguments, true
	case "DiscrepancyAlarmType_ConditionRefresh_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh_InputArguments, true
	case "DiscrepancyAlarmType_ConditionRefresh2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh2_InputArguments, true
	case "DiscrepancyAlarmType_AckedState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState, true
	case "DiscrepancyAlarmType_AckedState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Id, true
	case "DiscrepancyAlarmType_AckedState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Name, true
	case "DiscrepancyAlarmType_AckedState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Number, true
	case "DiscrepancyAlarmType_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TransitionTime, true
	case "DiscrepancyAlarmType_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TrueState, true
	case "DiscrepancyAlarmType_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_FalseState, true
	case "DiscrepancyAlarmType_ConfirmedState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState, true
	case "DiscrepancyAlarmType_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Id, true
	case "DiscrepancyAlarmType_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Name, true
	case "DiscrepancyAlarmType_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Number, true
	case "DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TransitionTime, true
	case "DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TrueState, true
	case "DiscrepancyAlarmType_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_FalseState, true
	case "DiscrepancyAlarmType_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Acknowledge_InputArguments, true
	case "DiscrepancyAlarmType_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Confirm_InputArguments, true
	case "DiscrepancyAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState, true
	case "DiscrepancyAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Id, true
	case "DiscrepancyAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Name, true
	case "DiscrepancyAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Number, true
	case "DiscrepancyAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TransitionTime, true
	case "DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TrueState, true
	case "DiscrepancyAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_FalseState, true
	case "DiscrepancyAlarmType_InputNode":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_InputNode, true
	case "DiscrepancyAlarmType_SuppressedState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState, true
	case "DiscrepancyAlarmType_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Id, true
	case "DiscrepancyAlarmType_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Name, true
	case "DiscrepancyAlarmType_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Number, true
	case "DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TransitionTime, true
	case "DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TrueState, true
	case "DiscrepancyAlarmType_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_FalseState, true
	case "DiscrepancyAlarmType_OutOfServiceState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState, true
	case "DiscrepancyAlarmType_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Id, true
	case "DiscrepancyAlarmType_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Name, true
	case "DiscrepancyAlarmType_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Number, true
	case "DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TransitionTime, true
	case "DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TrueState, true
	case "DiscrepancyAlarmType_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_FalseState, true
	case "DiscrepancyAlarmType_SilenceState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState, true
	case "DiscrepancyAlarmType_SilenceState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Id, true
	case "DiscrepancyAlarmType_SilenceState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Name, true
	case "DiscrepancyAlarmType_SilenceState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Number, true
	case "DiscrepancyAlarmType_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TransitionTime, true
	case "DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TrueState, true
	case "DiscrepancyAlarmType_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_FalseState, true
	case "DiscrepancyAlarmType_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState, true
	case "DiscrepancyAlarmType_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Id, true
	case "DiscrepancyAlarmType_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Name, true
	case "DiscrepancyAlarmType_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Number, true
	case "DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Id, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Name, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Number, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime, true
	case "DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_UnshelveTime, true
	case "DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments, true
	case "DiscrepancyAlarmType_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedOrShelved, true
	case "DiscrepancyAlarmType_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_MaxTimeShelved, true
	case "DiscrepancyAlarmType_AudibleEnabled":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleEnabled, true
	case "DiscrepancyAlarmType_AudibleSound":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound, true
	case "DiscrepancyAlarmType_OnDelay":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OnDelay, true
	case "DiscrepancyAlarmType_OffDelay":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OffDelay, true
	case "DiscrepancyAlarmType_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_FirstInGroupFlag, true
	case "DiscrepancyAlarmType_ReAlarmTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmTime, true
	case "DiscrepancyAlarmType_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmRepeatCount, true
	case "DiscrepancyAlarmType_TargetValueNode":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode, true
	case "DiscrepancyAlarmType_ExpectedTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime, true
	case "DiscrepancyAlarmType_Tolerance":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance, true
	case "DiscrepancyAlarmType_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableStates, true
	case "DiscrepancyAlarmType_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableTransitions, true
	case "DiscrepancyAlarmType_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_ListId, true
	case "DiscrepancyAlarmType_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_AgencyId, true
	case "DiscrepancyAlarmType_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_VersionId, true
	case "DiscrepancyAlarmType_LatchedState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState, true
	case "DiscrepancyAlarmType_LatchedState_Id":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Id, true
	case "DiscrepancyAlarmType_LatchedState_Name":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Name, true
	case "DiscrepancyAlarmType_LatchedState_Number":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Number, true
	case "DiscrepancyAlarmType_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveDisplayName, true
	case "DiscrepancyAlarmType_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TransitionTime, true
	case "DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime, true
	case "DiscrepancyAlarmType_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TrueState, true
	case "DiscrepancyAlarmType_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_FalseState, true
	case "DiscrepancyAlarmType_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Suppress2_InputArguments, true
	case "DiscrepancyAlarmType_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Unsuppress2_InputArguments, true
	case "DiscrepancyAlarmType_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_RemoveFromService2_InputArguments, true
	case "DiscrepancyAlarmType_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_PlaceInService2_InputArguments, true
	case "DiscrepancyAlarmType_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Reset2_InputArguments, true
	case "DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments, true
	case "DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments, true
	case "DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments, true
	case "DiscrepancyAlarmType_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments, true
	case "DiscrepancyAlarmType_SupportsFilteredRetain":
		return OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SupportsFilteredRetain, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiscrepancyKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDiscrepancyValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDiscrepancy(structType any) OpcuaNodeIdServicesVariableDiscrepancy {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDiscrepancy {
		if sOpcuaNodeIdServicesVariableDiscrepancy, ok := typ.(OpcuaNodeIdServicesVariableDiscrepancy); ok {
			return sOpcuaNodeIdServicesVariableDiscrepancy
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDiscrepancy) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDiscrepancy) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDiscrepancyParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDiscrepancy, error) {
	return OpcuaNodeIdServicesVariableDiscrepancyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDiscrepancyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDiscrepancy, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDiscrepancy", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDiscrepancy")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDiscrepancyByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDiscrepancy")
		return OpcuaNodeIdServicesVariableDiscrepancy(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDiscrepancy", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDiscrepancy) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventId:
		return "DiscrepancyAlarmType_EventId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EventType:
		return "DiscrepancyAlarmType_EventType"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceNode:
		return "DiscrepancyAlarmType_SourceNode"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SourceName:
		return "DiscrepancyAlarmType_SourceName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Time:
		return "DiscrepancyAlarmType_Time"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReceiveTime:
		return "DiscrepancyAlarmType_ReceiveTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LocalTime:
		return "DiscrepancyAlarmType_LocalTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Message:
		return "DiscrepancyAlarmType_Message"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Severity:
		return "DiscrepancyAlarmType_Severity"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassId:
		return "DiscrepancyAlarmType_ConditionClassId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionClassName:
		return "DiscrepancyAlarmType_ConditionClassName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassId:
		return "DiscrepancyAlarmType_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionSubClassName:
		return "DiscrepancyAlarmType_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionName:
		return "DiscrepancyAlarmType_ConditionName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_BranchId:
		return "DiscrepancyAlarmType_BranchId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Retain:
		return "DiscrepancyAlarmType_Retain"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState:
		return "DiscrepancyAlarmType_EnabledState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Id:
		return "DiscrepancyAlarmType_EnabledState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Name:
		return "DiscrepancyAlarmType_EnabledState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_Number:
		return "DiscrepancyAlarmType_EnabledState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TransitionTime:
		return "DiscrepancyAlarmType_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_TrueState:
		return "DiscrepancyAlarmType_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_EnabledState_FalseState:
		return "DiscrepancyAlarmType_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality:
		return "DiscrepancyAlarmType_Quality"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Quality_SourceTimestamp:
		return "DiscrepancyAlarmType_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity:
		return "DiscrepancyAlarmType_LastSeverity"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LastSeverity_SourceTimestamp:
		return "DiscrepancyAlarmType_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment:
		return "DiscrepancyAlarmType_Comment"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Comment_SourceTimestamp:
		return "DiscrepancyAlarmType_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ClientUserId:
		return "DiscrepancyAlarmType_ClientUserId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AddComment_InputArguments:
		return "DiscrepancyAlarmType_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh_InputArguments:
		return "DiscrepancyAlarmType_ConditionRefresh_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConditionRefresh2_InputArguments:
		return "DiscrepancyAlarmType_ConditionRefresh2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState:
		return "DiscrepancyAlarmType_AckedState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Id:
		return "DiscrepancyAlarmType_AckedState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Name:
		return "DiscrepancyAlarmType_AckedState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_Number:
		return "DiscrepancyAlarmType_AckedState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TransitionTime:
		return "DiscrepancyAlarmType_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_TrueState:
		return "DiscrepancyAlarmType_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AckedState_FalseState:
		return "DiscrepancyAlarmType_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState:
		return "DiscrepancyAlarmType_ConfirmedState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Id:
		return "DiscrepancyAlarmType_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Name:
		return "DiscrepancyAlarmType_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_Number:
		return "DiscrepancyAlarmType_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TransitionTime:
		return "DiscrepancyAlarmType_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_TrueState:
		return "DiscrepancyAlarmType_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ConfirmedState_FalseState:
		return "DiscrepancyAlarmType_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Acknowledge_InputArguments:
		return "DiscrepancyAlarmType_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Confirm_InputArguments:
		return "DiscrepancyAlarmType_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState:
		return "DiscrepancyAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Id:
		return "DiscrepancyAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Name:
		return "DiscrepancyAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_Number:
		return "DiscrepancyAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TransitionTime:
		return "DiscrepancyAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_TrueState:
		return "DiscrepancyAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ActiveState_FalseState:
		return "DiscrepancyAlarmType_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_InputNode:
		return "DiscrepancyAlarmType_InputNode"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState:
		return "DiscrepancyAlarmType_SuppressedState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Id:
		return "DiscrepancyAlarmType_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Name:
		return "DiscrepancyAlarmType_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_Number:
		return "DiscrepancyAlarmType_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TransitionTime:
		return "DiscrepancyAlarmType_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_TrueState:
		return "DiscrepancyAlarmType_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedState_FalseState:
		return "DiscrepancyAlarmType_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState:
		return "DiscrepancyAlarmType_OutOfServiceState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Id:
		return "DiscrepancyAlarmType_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Name:
		return "DiscrepancyAlarmType_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_Number:
		return "DiscrepancyAlarmType_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TransitionTime:
		return "DiscrepancyAlarmType_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_TrueState:
		return "DiscrepancyAlarmType_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OutOfServiceState_FalseState:
		return "DiscrepancyAlarmType_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState:
		return "DiscrepancyAlarmType_SilenceState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Id:
		return "DiscrepancyAlarmType_SilenceState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Name:
		return "DiscrepancyAlarmType_SilenceState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_Number:
		return "DiscrepancyAlarmType_SilenceState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_SilenceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TransitionTime:
		return "DiscrepancyAlarmType_SilenceState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_TrueState:
		return "DiscrepancyAlarmType_SilenceState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SilenceState_FalseState:
		return "DiscrepancyAlarmType_SilenceState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState:
		return "DiscrepancyAlarmType_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Id:
		return "DiscrepancyAlarmType_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Name:
		return "DiscrepancyAlarmType_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_Number:
		return "DiscrepancyAlarmType_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Id:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Name:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_Number:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_UnshelveTime:
		return "DiscrepancyAlarmType_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments:
		return "DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SuppressedOrShelved:
		return "DiscrepancyAlarmType_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_MaxTimeShelved:
		return "DiscrepancyAlarmType_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleEnabled:
		return "DiscrepancyAlarmType_AudibleEnabled"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound:
		return "DiscrepancyAlarmType_AudibleSound"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OnDelay:
		return "DiscrepancyAlarmType_OnDelay"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_OffDelay:
		return "DiscrepancyAlarmType_OffDelay"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_FirstInGroupFlag:
		return "DiscrepancyAlarmType_FirstInGroupFlag"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmTime:
		return "DiscrepancyAlarmType_ReAlarmTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ReAlarmRepeatCount:
		return "DiscrepancyAlarmType_ReAlarmRepeatCount"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_TargetValueNode:
		return "DiscrepancyAlarmType_TargetValueNode"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ExpectedTime:
		return "DiscrepancyAlarmType_ExpectedTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Tolerance:
		return "DiscrepancyAlarmType_Tolerance"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableStates:
		return "DiscrepancyAlarmType_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_AvailableTransitions:
		return "DiscrepancyAlarmType_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_ListId:
		return "DiscrepancyAlarmType_AudibleSound_ListId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_AgencyId:
		return "DiscrepancyAlarmType_AudibleSound_AgencyId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_AudibleSound_VersionId:
		return "DiscrepancyAlarmType_AudibleSound_VersionId"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState:
		return "DiscrepancyAlarmType_LatchedState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Id:
		return "DiscrepancyAlarmType_LatchedState_Id"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Name:
		return "DiscrepancyAlarmType_LatchedState_Name"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_Number:
		return "DiscrepancyAlarmType_LatchedState_Number"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveDisplayName:
		return "DiscrepancyAlarmType_LatchedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TransitionTime:
		return "DiscrepancyAlarmType_LatchedState_TransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime:
		return "DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_TrueState:
		return "DiscrepancyAlarmType_LatchedState_TrueState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_LatchedState_FalseState:
		return "DiscrepancyAlarmType_LatchedState_FalseState"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Suppress2_InputArguments:
		return "DiscrepancyAlarmType_Suppress2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Unsuppress2_InputArguments:
		return "DiscrepancyAlarmType_Unsuppress2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_RemoveFromService2_InputArguments:
		return "DiscrepancyAlarmType_RemoveFromService2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_PlaceInService2_InputArguments:
		return "DiscrepancyAlarmType_PlaceInService2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_Reset2_InputArguments:
		return "DiscrepancyAlarmType_Reset2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments:
		return "DiscrepancyAlarmType_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments:
		return "DiscrepancyAlarmType_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments:
		return "DiscrepancyAlarmType_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_GetGroupMemberships_OutputArguments:
		return "DiscrepancyAlarmType_GetGroupMemberships_OutputArguments"
	case OpcuaNodeIdServicesVariableDiscrepancy_DiscrepancyAlarmType_SupportsFilteredRetain:
		return "DiscrepancyAlarmType_SupportsFilteredRetain"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDiscrepancy) String() string {
	return e.PLC4XEnumName()
}
