/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDefault is an enum
type OpcuaNodeIdServicesVariableDefault int32

type IOpcuaNodeIdServicesVariableDefault interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDefault_DefaultInstanceBrowseName OpcuaNodeIdServicesVariableDefault = 17605
)

var OpcuaNodeIdServicesVariableDefaultValues []OpcuaNodeIdServicesVariableDefault

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDefaultValues = []OpcuaNodeIdServicesVariableDefault{
		OpcuaNodeIdServicesVariableDefault_DefaultInstanceBrowseName,
	}
}

func OpcuaNodeIdServicesVariableDefaultByValue(value int32) (enum OpcuaNodeIdServicesVariableDefault, ok bool) {
	switch value {
	case 17605:
		return OpcuaNodeIdServicesVariableDefault_DefaultInstanceBrowseName, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDefaultByName(value string) (enum OpcuaNodeIdServicesVariableDefault, ok bool) {
	switch value {
	case "DefaultInstanceBrowseName":
		return OpcuaNodeIdServicesVariableDefault_DefaultInstanceBrowseName, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDefaultKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDefaultValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDefault(structType any) OpcuaNodeIdServicesVariableDefault {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDefault {
		if sOpcuaNodeIdServicesVariableDefault, ok := typ.(OpcuaNodeIdServicesVariableDefault); ok {
			return sOpcuaNodeIdServicesVariableDefault
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDefault) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDefault) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDefaultParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDefault, error) {
	return OpcuaNodeIdServicesVariableDefaultParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDefaultParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDefault, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDefault", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDefault")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDefaultByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDefault")
		return OpcuaNodeIdServicesVariableDefault(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDefault) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDefault) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDefault", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDefault) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDefault_DefaultInstanceBrowseName:
		return "DefaultInstanceBrowseName"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDefault) String() string {
	return e.PLC4XEnumName()
}
