/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableChoice is an enum
type OpcuaNodeIdServicesVariableChoice int32

type IOpcuaNodeIdServicesVariableChoice interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableChoice_ChoiceStateType_StateNumber OpcuaNodeIdServicesVariableChoice = 15110
)

var OpcuaNodeIdServicesVariableChoiceValues []OpcuaNodeIdServicesVariableChoice

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableChoiceValues = []OpcuaNodeIdServicesVariableChoice{
		OpcuaNodeIdServicesVariableChoice_ChoiceStateType_StateNumber,
	}
}

func OpcuaNodeIdServicesVariableChoiceByValue(value int32) (enum OpcuaNodeIdServicesVariableChoice, ok bool) {
	switch value {
	case 15110:
		return OpcuaNodeIdServicesVariableChoice_ChoiceStateType_StateNumber, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableChoiceByName(value string) (enum OpcuaNodeIdServicesVariableChoice, ok bool) {
	switch value {
	case "ChoiceStateType_StateNumber":
		return OpcuaNodeIdServicesVariableChoice_ChoiceStateType_StateNumber, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableChoiceKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableChoiceValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableChoice(structType any) OpcuaNodeIdServicesVariableChoice {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableChoice {
		if sOpcuaNodeIdServicesVariableChoice, ok := typ.(OpcuaNodeIdServicesVariableChoice); ok {
			return sOpcuaNodeIdServicesVariableChoice
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableChoice) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableChoice) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableChoiceParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableChoice, error) {
	return OpcuaNodeIdServicesVariableChoiceParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableChoiceParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableChoice, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableChoice", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableChoice")
	}
	if enum, ok := OpcuaNodeIdServicesVariableChoiceByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableChoice")
		return OpcuaNodeIdServicesVariableChoice(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableChoice) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableChoice) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableChoice", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableChoice) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableChoice_ChoiceStateType_StateNumber:
		return "ChoiceStateType_StateNumber"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableChoice) String() string {
	return e.PLC4XEnumName()
}
