/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAttribute is an enum
type OpcuaNodeIdServicesVariableAttribute int32

type IOpcuaNodeIdServicesVariableAttribute interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAttribute_AttributeWriteMask_OptionSetValues OpcuaNodeIdServicesVariableAttribute = 15036
)

var OpcuaNodeIdServicesVariableAttributeValues []OpcuaNodeIdServicesVariableAttribute

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAttributeValues = []OpcuaNodeIdServicesVariableAttribute{
		OpcuaNodeIdServicesVariableAttribute_AttributeWriteMask_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariableAttributeByValue(value int32) (enum OpcuaNodeIdServicesVariableAttribute, ok bool) {
	switch value {
	case 15036:
		return OpcuaNodeIdServicesVariableAttribute_AttributeWriteMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAttributeByName(value string) (enum OpcuaNodeIdServicesVariableAttribute, ok bool) {
	switch value {
	case "AttributeWriteMask_OptionSetValues":
		return OpcuaNodeIdServicesVariableAttribute_AttributeWriteMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAttributeKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAttributeValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAttribute(structType any) OpcuaNodeIdServicesVariableAttribute {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAttribute {
		if sOpcuaNodeIdServicesVariableAttribute, ok := typ.(OpcuaNodeIdServicesVariableAttribute); ok {
			return sOpcuaNodeIdServicesVariableAttribute
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAttribute) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAttribute) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAttributeParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAttribute, error) {
	return OpcuaNodeIdServicesVariableAttributeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAttributeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAttribute, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAttribute", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAttribute")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAttributeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAttribute")
		return OpcuaNodeIdServicesVariableAttribute(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAttribute) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAttribute) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAttribute", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAttribute) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAttribute_AttributeWriteMask_OptionSetValues:
		return "AttributeWriteMask_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAttribute) String() string {
	return e.PLC4XEnumName()
}
