/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAnnotations is an enum
type OpcuaNodeIdServicesVariableAnnotations int32

type IOpcuaNodeIdServicesVariableAnnotations interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAnnotations_Annotations OpcuaNodeIdServicesVariableAnnotations = 11214
)

var OpcuaNodeIdServicesVariableAnnotationsValues []OpcuaNodeIdServicesVariableAnnotations

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAnnotationsValues = []OpcuaNodeIdServicesVariableAnnotations{
		OpcuaNodeIdServicesVariableAnnotations_Annotations,
	}
}

func OpcuaNodeIdServicesVariableAnnotationsByValue(value int32) (enum OpcuaNodeIdServicesVariableAnnotations, ok bool) {
	switch value {
	case 11214:
		return OpcuaNodeIdServicesVariableAnnotations_Annotations, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAnnotationsByName(value string) (enum OpcuaNodeIdServicesVariableAnnotations, ok bool) {
	switch value {
	case "Annotations":
		return OpcuaNodeIdServicesVariableAnnotations_Annotations, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAnnotationsKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAnnotationsValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAnnotations(structType any) OpcuaNodeIdServicesVariableAnnotations {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAnnotations {
		if sOpcuaNodeIdServicesVariableAnnotations, ok := typ.(OpcuaNodeIdServicesVariableAnnotations); ok {
			return sOpcuaNodeIdServicesVariableAnnotations
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAnnotations) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAnnotations) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAnnotationsParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAnnotations, error) {
	return OpcuaNodeIdServicesVariableAnnotationsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAnnotationsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAnnotations, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAnnotations", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAnnotations")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAnnotationsByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAnnotations")
		return OpcuaNodeIdServicesVariableAnnotations(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAnnotations) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAnnotations) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAnnotations", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAnnotations) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAnnotations_Annotations:
		return "Annotations"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAnnotations) String() string {
	return e.PLC4XEnumName()
}
