/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAddress is an enum
type OpcuaNodeIdServicesVariableAddress int32

type IOpcuaNodeIdServicesVariableAddress interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Size                        OpcuaNodeIdServicesVariableAddress = 11596
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_OpenCount                   OpcuaNodeIdServicesVariableAddress = 11599
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_InputArguments         OpcuaNodeIdServicesVariableAddress = 11601
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_OutputArguments        OpcuaNodeIdServicesVariableAddress = 11602
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Close_InputArguments        OpcuaNodeIdServicesVariableAddress = 11604
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_InputArguments         OpcuaNodeIdServicesVariableAddress = 11606
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_OutputArguments        OpcuaNodeIdServicesVariableAddress = 11607
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Write_InputArguments        OpcuaNodeIdServicesVariableAddress = 11609
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_InputArguments  OpcuaNodeIdServicesVariableAddress = 11611
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_OutputArguments OpcuaNodeIdServicesVariableAddress = 11612
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_SetPosition_InputArguments  OpcuaNodeIdServicesVariableAddress = 11614
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Writable                    OpcuaNodeIdServicesVariableAddress = 12688
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_UserWritable                OpcuaNodeIdServicesVariableAddress = 12689
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MimeType                    OpcuaNodeIdServicesVariableAddress = 13398
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MaxByteStringLength         OpcuaNodeIdServicesVariableAddress = 24245
	OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_LastModifiedTime            OpcuaNodeIdServicesVariableAddress = 25201
)

var OpcuaNodeIdServicesVariableAddressValues []OpcuaNodeIdServicesVariableAddress

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAddressValues = []OpcuaNodeIdServicesVariableAddress{
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Size,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_OpenCount,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_OutputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Close_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_OutputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Write_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Writable,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_UserWritable,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MimeType,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MaxByteStringLength,
		OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_LastModifiedTime,
	}
}

func OpcuaNodeIdServicesVariableAddressByValue(value int32) (enum OpcuaNodeIdServicesVariableAddress, ok bool) {
	switch value {
	case 11596:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Size, true
	case 11599:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_OpenCount, true
	case 11601:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_InputArguments, true
	case 11602:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_OutputArguments, true
	case 11604:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Close_InputArguments, true
	case 11606:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_InputArguments, true
	case 11607:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_OutputArguments, true
	case 11609:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Write_InputArguments, true
	case 11611:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_InputArguments, true
	case 11612:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_OutputArguments, true
	case 11614:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_SetPosition_InputArguments, true
	case 12688:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Writable, true
	case 12689:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_UserWritable, true
	case 13398:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MimeType, true
	case 24245:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MaxByteStringLength, true
	case 25201:
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_LastModifiedTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAddressByName(value string) (enum OpcuaNodeIdServicesVariableAddress, ok bool) {
	switch value {
	case "AddressSpaceFileType_Size":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Size, true
	case "AddressSpaceFileType_OpenCount":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_OpenCount, true
	case "AddressSpaceFileType_Open_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_InputArguments, true
	case "AddressSpaceFileType_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_OutputArguments, true
	case "AddressSpaceFileType_Close_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Close_InputArguments, true
	case "AddressSpaceFileType_Read_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_InputArguments, true
	case "AddressSpaceFileType_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_OutputArguments, true
	case "AddressSpaceFileType_Write_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Write_InputArguments, true
	case "AddressSpaceFileType_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_InputArguments, true
	case "AddressSpaceFileType_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_OutputArguments, true
	case "AddressSpaceFileType_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_SetPosition_InputArguments, true
	case "AddressSpaceFileType_Writable":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Writable, true
	case "AddressSpaceFileType_UserWritable":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_UserWritable, true
	case "AddressSpaceFileType_MimeType":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MimeType, true
	case "AddressSpaceFileType_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MaxByteStringLength, true
	case "AddressSpaceFileType_LastModifiedTime":
		return OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_LastModifiedTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAddressKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAddressValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAddress(structType any) OpcuaNodeIdServicesVariableAddress {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAddress {
		if sOpcuaNodeIdServicesVariableAddress, ok := typ.(OpcuaNodeIdServicesVariableAddress); ok {
			return sOpcuaNodeIdServicesVariableAddress
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAddress) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAddressParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAddress, error) {
	return OpcuaNodeIdServicesVariableAddressParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAddressParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAddress, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAddress", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAddress")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAddressByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAddress")
		return OpcuaNodeIdServicesVariableAddress(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAddress) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAddress) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAddress", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAddress) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Size:
		return "AddressSpaceFileType_Size"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_OpenCount:
		return "AddressSpaceFileType_OpenCount"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_InputArguments:
		return "AddressSpaceFileType_Open_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Open_OutputArguments:
		return "AddressSpaceFileType_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Close_InputArguments:
		return "AddressSpaceFileType_Close_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_InputArguments:
		return "AddressSpaceFileType_Read_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Read_OutputArguments:
		return "AddressSpaceFileType_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Write_InputArguments:
		return "AddressSpaceFileType_Write_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_InputArguments:
		return "AddressSpaceFileType_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_GetPosition_OutputArguments:
		return "AddressSpaceFileType_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_SetPosition_InputArguments:
		return "AddressSpaceFileType_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_Writable:
		return "AddressSpaceFileType_Writable"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_UserWritable:
		return "AddressSpaceFileType_UserWritable"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MimeType:
		return "AddressSpaceFileType_MimeType"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_MaxByteStringLength:
		return "AddressSpaceFileType_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableAddress_AddressSpaceFileType_LastModifiedTime:
		return "AddressSpaceFileType_LastModifiedTime"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAddress) String() string {
	return e.PLC4XEnumName()
}
