/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesDataType is an enum
type OpcuaNodeIdServicesDataType int32

type IOpcuaNodeIdServicesDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesDataType_Boolean                                OpcuaNodeIdServicesDataType = 1
	OpcuaNodeIdServicesDataType_SByte                                  OpcuaNodeIdServicesDataType = 2
	OpcuaNodeIdServicesDataType_Byte                                   OpcuaNodeIdServicesDataType = 3
	OpcuaNodeIdServicesDataType_Int16                                  OpcuaNodeIdServicesDataType = 4
	OpcuaNodeIdServicesDataType_UInt16                                 OpcuaNodeIdServicesDataType = 5
	OpcuaNodeIdServicesDataType_Int32                                  OpcuaNodeIdServicesDataType = 6
	OpcuaNodeIdServicesDataType_UInt32                                 OpcuaNodeIdServicesDataType = 7
	OpcuaNodeIdServicesDataType_Int64                                  OpcuaNodeIdServicesDataType = 8
	OpcuaNodeIdServicesDataType_UInt64                                 OpcuaNodeIdServicesDataType = 9
	OpcuaNodeIdServicesDataType_Float                                  OpcuaNodeIdServicesDataType = 10
	OpcuaNodeIdServicesDataType_Double                                 OpcuaNodeIdServicesDataType = 11
	OpcuaNodeIdServicesDataType_String                                 OpcuaNodeIdServicesDataType = 12
	OpcuaNodeIdServicesDataType_DateTime                               OpcuaNodeIdServicesDataType = 13
	OpcuaNodeIdServicesDataType_Guid                                   OpcuaNodeIdServicesDataType = 14
	OpcuaNodeIdServicesDataType_ByteString                             OpcuaNodeIdServicesDataType = 15
	OpcuaNodeIdServicesDataType_XmlElement                             OpcuaNodeIdServicesDataType = 16
	OpcuaNodeIdServicesDataType_NodeId                                 OpcuaNodeIdServicesDataType = 17
	OpcuaNodeIdServicesDataType_ExpandedNodeId                         OpcuaNodeIdServicesDataType = 18
	OpcuaNodeIdServicesDataType_StatusCode                             OpcuaNodeIdServicesDataType = 19
	OpcuaNodeIdServicesDataType_QualifiedName                          OpcuaNodeIdServicesDataType = 20
	OpcuaNodeIdServicesDataType_LocalizedText                          OpcuaNodeIdServicesDataType = 21
	OpcuaNodeIdServicesDataType_Structure                              OpcuaNodeIdServicesDataType = 22
	OpcuaNodeIdServicesDataType_DataValue                              OpcuaNodeIdServicesDataType = 23
	OpcuaNodeIdServicesDataType_BaseDataType                           OpcuaNodeIdServicesDataType = 24
	OpcuaNodeIdServicesDataType_DiagnosticInfo                         OpcuaNodeIdServicesDataType = 25
	OpcuaNodeIdServicesDataType_Number                                 OpcuaNodeIdServicesDataType = 26
	OpcuaNodeIdServicesDataType_Integer                                OpcuaNodeIdServicesDataType = 27
	OpcuaNodeIdServicesDataType_UInteger                               OpcuaNodeIdServicesDataType = 28
	OpcuaNodeIdServicesDataType_Enumeration                            OpcuaNodeIdServicesDataType = 29
	OpcuaNodeIdServicesDataType_Image                                  OpcuaNodeIdServicesDataType = 30
	OpcuaNodeIdServicesDataType_Decimal                                OpcuaNodeIdServicesDataType = 50
	OpcuaNodeIdServicesDataType_PermissionType                         OpcuaNodeIdServicesDataType = 94
	OpcuaNodeIdServicesDataType_AccessRestrictionType                  OpcuaNodeIdServicesDataType = 95
	OpcuaNodeIdServicesDataType_RolePermissionType                     OpcuaNodeIdServicesDataType = 96
	OpcuaNodeIdServicesDataType_DataTypeDefinition                     OpcuaNodeIdServicesDataType = 97
	OpcuaNodeIdServicesDataType_StructureType                          OpcuaNodeIdServicesDataType = 98
	OpcuaNodeIdServicesDataType_StructureDefinition                    OpcuaNodeIdServicesDataType = 99
	OpcuaNodeIdServicesDataType_EnumDefinition                         OpcuaNodeIdServicesDataType = 100
	OpcuaNodeIdServicesDataType_StructureField                         OpcuaNodeIdServicesDataType = 101
	OpcuaNodeIdServicesDataType_EnumField                              OpcuaNodeIdServicesDataType = 102
	OpcuaNodeIdServicesDataType_NamingRuleType                         OpcuaNodeIdServicesDataType = 120
	OpcuaNodeIdServicesDataType_IdType                                 OpcuaNodeIdServicesDataType = 256
	OpcuaNodeIdServicesDataType_NodeClass                              OpcuaNodeIdServicesDataType = 257
	OpcuaNodeIdServicesDataType_Node                                   OpcuaNodeIdServicesDataType = 258
	OpcuaNodeIdServicesDataType_ObjectNode                             OpcuaNodeIdServicesDataType = 261
	OpcuaNodeIdServicesDataType_ObjectTypeNode                         OpcuaNodeIdServicesDataType = 264
	OpcuaNodeIdServicesDataType_VariableNode                           OpcuaNodeIdServicesDataType = 267
	OpcuaNodeIdServicesDataType_VariableTypeNode                       OpcuaNodeIdServicesDataType = 270
	OpcuaNodeIdServicesDataType_ReferenceTypeNode                      OpcuaNodeIdServicesDataType = 273
	OpcuaNodeIdServicesDataType_MethodNode                             OpcuaNodeIdServicesDataType = 276
	OpcuaNodeIdServicesDataType_ViewNode                               OpcuaNodeIdServicesDataType = 279
	OpcuaNodeIdServicesDataType_DataTypeNode                           OpcuaNodeIdServicesDataType = 282
	OpcuaNodeIdServicesDataType_ReferenceNode                          OpcuaNodeIdServicesDataType = 285
	OpcuaNodeIdServicesDataType_IntegerId                              OpcuaNodeIdServicesDataType = 288
	OpcuaNodeIdServicesDataType_Counter                                OpcuaNodeIdServicesDataType = 289
	OpcuaNodeIdServicesDataType_Duration                               OpcuaNodeIdServicesDataType = 290
	OpcuaNodeIdServicesDataType_NumericRange                           OpcuaNodeIdServicesDataType = 291
	OpcuaNodeIdServicesDataType_UtcTime                                OpcuaNodeIdServicesDataType = 294
	OpcuaNodeIdServicesDataType_LocaleId                               OpcuaNodeIdServicesDataType = 295
	OpcuaNodeIdServicesDataType_Argument                               OpcuaNodeIdServicesDataType = 296
	OpcuaNodeIdServicesDataType_StatusResult                           OpcuaNodeIdServicesDataType = 299
	OpcuaNodeIdServicesDataType_MessageSecurityMode                    OpcuaNodeIdServicesDataType = 302
	OpcuaNodeIdServicesDataType_UserTokenType                          OpcuaNodeIdServicesDataType = 303
	OpcuaNodeIdServicesDataType_UserTokenPolicy                        OpcuaNodeIdServicesDataType = 304
	OpcuaNodeIdServicesDataType_ApplicationType                        OpcuaNodeIdServicesDataType = 307
	OpcuaNodeIdServicesDataType_ApplicationDescription                 OpcuaNodeIdServicesDataType = 308
	OpcuaNodeIdServicesDataType_ApplicationInstanceCertificate         OpcuaNodeIdServicesDataType = 311
	OpcuaNodeIdServicesDataType_EndpointDescription                    OpcuaNodeIdServicesDataType = 312
	OpcuaNodeIdServicesDataType_SecurityTokenRequestType               OpcuaNodeIdServicesDataType = 315
	OpcuaNodeIdServicesDataType_UserIdentityToken                      OpcuaNodeIdServicesDataType = 316
	OpcuaNodeIdServicesDataType_AnonymousIdentityToken                 OpcuaNodeIdServicesDataType = 319
	OpcuaNodeIdServicesDataType_UserNameIdentityToken                  OpcuaNodeIdServicesDataType = 322
	OpcuaNodeIdServicesDataType_X509IdentityToken                      OpcuaNodeIdServicesDataType = 325
	OpcuaNodeIdServicesDataType_EndpointConfiguration                  OpcuaNodeIdServicesDataType = 331
	OpcuaNodeIdServicesDataType_BuildInfo                              OpcuaNodeIdServicesDataType = 338
	OpcuaNodeIdServicesDataType_SignedSoftwareCertificate              OpcuaNodeIdServicesDataType = 344
	OpcuaNodeIdServicesDataType_AttributeWriteMask                     OpcuaNodeIdServicesDataType = 347
	OpcuaNodeIdServicesDataType_NodeAttributesMask                     OpcuaNodeIdServicesDataType = 348
	OpcuaNodeIdServicesDataType_NodeAttributes                         OpcuaNodeIdServicesDataType = 349
	OpcuaNodeIdServicesDataType_ObjectAttributes                       OpcuaNodeIdServicesDataType = 352
	OpcuaNodeIdServicesDataType_VariableAttributes                     OpcuaNodeIdServicesDataType = 355
	OpcuaNodeIdServicesDataType_MethodAttributes                       OpcuaNodeIdServicesDataType = 358
	OpcuaNodeIdServicesDataType_ObjectTypeAttributes                   OpcuaNodeIdServicesDataType = 361
	OpcuaNodeIdServicesDataType_VariableTypeAttributes                 OpcuaNodeIdServicesDataType = 364
	OpcuaNodeIdServicesDataType_ReferenceTypeAttributes                OpcuaNodeIdServicesDataType = 367
	OpcuaNodeIdServicesDataType_DataTypeAttributes                     OpcuaNodeIdServicesDataType = 370
	OpcuaNodeIdServicesDataType_ViewAttributes                         OpcuaNodeIdServicesDataType = 373
	OpcuaNodeIdServicesDataType_AddNodesItem                           OpcuaNodeIdServicesDataType = 376
	OpcuaNodeIdServicesDataType_AddReferencesItem                      OpcuaNodeIdServicesDataType = 379
	OpcuaNodeIdServicesDataType_DeleteNodesItem                        OpcuaNodeIdServicesDataType = 382
	OpcuaNodeIdServicesDataType_DeleteReferencesItem                   OpcuaNodeIdServicesDataType = 385
	OpcuaNodeIdServicesDataType_SessionAuthenticationToken             OpcuaNodeIdServicesDataType = 388
	OpcuaNodeIdServicesDataType_RequestHeader                          OpcuaNodeIdServicesDataType = 389
	OpcuaNodeIdServicesDataType_ResponseHeader                         OpcuaNodeIdServicesDataType = 392
	OpcuaNodeIdServicesDataType_ServiceFault                           OpcuaNodeIdServicesDataType = 395
	OpcuaNodeIdServicesDataType_FindServersRequest                     OpcuaNodeIdServicesDataType = 420
	OpcuaNodeIdServicesDataType_FindServersResponse                    OpcuaNodeIdServicesDataType = 423
	OpcuaNodeIdServicesDataType_GetEndpointsRequest                    OpcuaNodeIdServicesDataType = 426
	OpcuaNodeIdServicesDataType_GetEndpointsResponse                   OpcuaNodeIdServicesDataType = 429
	OpcuaNodeIdServicesDataType_RegisteredServer                       OpcuaNodeIdServicesDataType = 432
	OpcuaNodeIdServicesDataType_RegisterServerRequest                  OpcuaNodeIdServicesDataType = 435
	OpcuaNodeIdServicesDataType_RegisterServerResponse                 OpcuaNodeIdServicesDataType = 438
	OpcuaNodeIdServicesDataType_ChannelSecurityToken                   OpcuaNodeIdServicesDataType = 441
	OpcuaNodeIdServicesDataType_OpenSecureChannelRequest               OpcuaNodeIdServicesDataType = 444
	OpcuaNodeIdServicesDataType_OpenSecureChannelResponse              OpcuaNodeIdServicesDataType = 447
	OpcuaNodeIdServicesDataType_CloseSecureChannelRequest              OpcuaNodeIdServicesDataType = 450
	OpcuaNodeIdServicesDataType_CloseSecureChannelResponse             OpcuaNodeIdServicesDataType = 453
	OpcuaNodeIdServicesDataType_SignatureData                          OpcuaNodeIdServicesDataType = 456
	OpcuaNodeIdServicesDataType_CreateSessionRequest                   OpcuaNodeIdServicesDataType = 459
	OpcuaNodeIdServicesDataType_CreateSessionResponse                  OpcuaNodeIdServicesDataType = 462
	OpcuaNodeIdServicesDataType_ActivateSessionRequest                 OpcuaNodeIdServicesDataType = 465
	OpcuaNodeIdServicesDataType_ActivateSessionResponse                OpcuaNodeIdServicesDataType = 468
	OpcuaNodeIdServicesDataType_CloseSessionRequest                    OpcuaNodeIdServicesDataType = 471
	OpcuaNodeIdServicesDataType_CloseSessionResponse                   OpcuaNodeIdServicesDataType = 474
	OpcuaNodeIdServicesDataType_CancelRequest                          OpcuaNodeIdServicesDataType = 477
	OpcuaNodeIdServicesDataType_CancelResponse                         OpcuaNodeIdServicesDataType = 480
	OpcuaNodeIdServicesDataType_AddNodesResult                         OpcuaNodeIdServicesDataType = 483
	OpcuaNodeIdServicesDataType_AddNodesRequest                        OpcuaNodeIdServicesDataType = 486
	OpcuaNodeIdServicesDataType_AddNodesResponse                       OpcuaNodeIdServicesDataType = 489
	OpcuaNodeIdServicesDataType_AddReferencesRequest                   OpcuaNodeIdServicesDataType = 492
	OpcuaNodeIdServicesDataType_AddReferencesResponse                  OpcuaNodeIdServicesDataType = 495
	OpcuaNodeIdServicesDataType_DeleteNodesRequest                     OpcuaNodeIdServicesDataType = 498
	OpcuaNodeIdServicesDataType_DeleteNodesResponse                    OpcuaNodeIdServicesDataType = 501
	OpcuaNodeIdServicesDataType_DeleteReferencesRequest                OpcuaNodeIdServicesDataType = 504
	OpcuaNodeIdServicesDataType_DeleteReferencesResponse               OpcuaNodeIdServicesDataType = 507
	OpcuaNodeIdServicesDataType_BrowseDirection                        OpcuaNodeIdServicesDataType = 510
	OpcuaNodeIdServicesDataType_ViewDescription                        OpcuaNodeIdServicesDataType = 511
	OpcuaNodeIdServicesDataType_BrowseDescription                      OpcuaNodeIdServicesDataType = 514
	OpcuaNodeIdServicesDataType_BrowseResultMask                       OpcuaNodeIdServicesDataType = 517
	OpcuaNodeIdServicesDataType_ReferenceDescription                   OpcuaNodeIdServicesDataType = 518
	OpcuaNodeIdServicesDataType_ContinuationPoint                      OpcuaNodeIdServicesDataType = 521
	OpcuaNodeIdServicesDataType_BrowseResult                           OpcuaNodeIdServicesDataType = 522
	OpcuaNodeIdServicesDataType_BrowseRequest                          OpcuaNodeIdServicesDataType = 525
	OpcuaNodeIdServicesDataType_BrowseResponse                         OpcuaNodeIdServicesDataType = 528
	OpcuaNodeIdServicesDataType_BrowseNextRequest                      OpcuaNodeIdServicesDataType = 531
	OpcuaNodeIdServicesDataType_BrowseNextResponse                     OpcuaNodeIdServicesDataType = 534
	OpcuaNodeIdServicesDataType_RelativePathElement                    OpcuaNodeIdServicesDataType = 537
	OpcuaNodeIdServicesDataType_RelativePath                           OpcuaNodeIdServicesDataType = 540
	OpcuaNodeIdServicesDataType_BrowsePath                             OpcuaNodeIdServicesDataType = 543
	OpcuaNodeIdServicesDataType_BrowsePathTarget                       OpcuaNodeIdServicesDataType = 546
	OpcuaNodeIdServicesDataType_BrowsePathResult                       OpcuaNodeIdServicesDataType = 549
	OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsRequest   OpcuaNodeIdServicesDataType = 552
	OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsResponse  OpcuaNodeIdServicesDataType = 555
	OpcuaNodeIdServicesDataType_RegisterNodesRequest                   OpcuaNodeIdServicesDataType = 558
	OpcuaNodeIdServicesDataType_RegisterNodesResponse                  OpcuaNodeIdServicesDataType = 561
	OpcuaNodeIdServicesDataType_UnregisterNodesRequest                 OpcuaNodeIdServicesDataType = 564
	OpcuaNodeIdServicesDataType_UnregisterNodesResponse                OpcuaNodeIdServicesDataType = 567
	OpcuaNodeIdServicesDataType_QueryDataDescription                   OpcuaNodeIdServicesDataType = 570
	OpcuaNodeIdServicesDataType_NodeTypeDescription                    OpcuaNodeIdServicesDataType = 573
	OpcuaNodeIdServicesDataType_FilterOperator                         OpcuaNodeIdServicesDataType = 576
	OpcuaNodeIdServicesDataType_QueryDataSet                           OpcuaNodeIdServicesDataType = 577
	OpcuaNodeIdServicesDataType_NodeReference                          OpcuaNodeIdServicesDataType = 580
	OpcuaNodeIdServicesDataType_ContentFilterElement                   OpcuaNodeIdServicesDataType = 583
	OpcuaNodeIdServicesDataType_ContentFilter                          OpcuaNodeIdServicesDataType = 586
	OpcuaNodeIdServicesDataType_FilterOperand                          OpcuaNodeIdServicesDataType = 589
	OpcuaNodeIdServicesDataType_ElementOperand                         OpcuaNodeIdServicesDataType = 592
	OpcuaNodeIdServicesDataType_LiteralOperand                         OpcuaNodeIdServicesDataType = 595
	OpcuaNodeIdServicesDataType_AttributeOperand                       OpcuaNodeIdServicesDataType = 598
	OpcuaNodeIdServicesDataType_SimpleAttributeOperand                 OpcuaNodeIdServicesDataType = 601
	OpcuaNodeIdServicesDataType_ContentFilterElementResult             OpcuaNodeIdServicesDataType = 604
	OpcuaNodeIdServicesDataType_ContentFilterResult                    OpcuaNodeIdServicesDataType = 607
	OpcuaNodeIdServicesDataType_ParsingResult                          OpcuaNodeIdServicesDataType = 610
	OpcuaNodeIdServicesDataType_QueryFirstRequest                      OpcuaNodeIdServicesDataType = 613
	OpcuaNodeIdServicesDataType_QueryFirstResponse                     OpcuaNodeIdServicesDataType = 616
	OpcuaNodeIdServicesDataType_QueryNextRequest                       OpcuaNodeIdServicesDataType = 619
	OpcuaNodeIdServicesDataType_QueryNextResponse                      OpcuaNodeIdServicesDataType = 622
	OpcuaNodeIdServicesDataType_TimestampsToReturn                     OpcuaNodeIdServicesDataType = 625
	OpcuaNodeIdServicesDataType_ReadValueId                            OpcuaNodeIdServicesDataType = 626
	OpcuaNodeIdServicesDataType_ReadRequest                            OpcuaNodeIdServicesDataType = 629
	OpcuaNodeIdServicesDataType_ReadResponse                           OpcuaNodeIdServicesDataType = 632
	OpcuaNodeIdServicesDataType_HistoryReadValueId                     OpcuaNodeIdServicesDataType = 635
	OpcuaNodeIdServicesDataType_HistoryReadResult                      OpcuaNodeIdServicesDataType = 638
	OpcuaNodeIdServicesDataType_HistoryReadDetails                     OpcuaNodeIdServicesDataType = 641
	OpcuaNodeIdServicesDataType_ReadEventDetails                       OpcuaNodeIdServicesDataType = 644
	OpcuaNodeIdServicesDataType_ReadRawModifiedDetails                 OpcuaNodeIdServicesDataType = 647
	OpcuaNodeIdServicesDataType_ReadProcessedDetails                   OpcuaNodeIdServicesDataType = 650
	OpcuaNodeIdServicesDataType_ReadAtTimeDetails                      OpcuaNodeIdServicesDataType = 653
	OpcuaNodeIdServicesDataType_HistoryData                            OpcuaNodeIdServicesDataType = 656
	OpcuaNodeIdServicesDataType_HistoryEvent                           OpcuaNodeIdServicesDataType = 659
	OpcuaNodeIdServicesDataType_HistoryReadRequest                     OpcuaNodeIdServicesDataType = 662
	OpcuaNodeIdServicesDataType_HistoryReadResponse                    OpcuaNodeIdServicesDataType = 665
	OpcuaNodeIdServicesDataType_WriteValue                             OpcuaNodeIdServicesDataType = 668
	OpcuaNodeIdServicesDataType_WriteRequest                           OpcuaNodeIdServicesDataType = 671
	OpcuaNodeIdServicesDataType_WriteResponse                          OpcuaNodeIdServicesDataType = 674
	OpcuaNodeIdServicesDataType_HistoryUpdateDetails                   OpcuaNodeIdServicesDataType = 677
	OpcuaNodeIdServicesDataType_UpdateDataDetails                      OpcuaNodeIdServicesDataType = 680
	OpcuaNodeIdServicesDataType_UpdateEventDetails                     OpcuaNodeIdServicesDataType = 683
	OpcuaNodeIdServicesDataType_DeleteRawModifiedDetails               OpcuaNodeIdServicesDataType = 686
	OpcuaNodeIdServicesDataType_DeleteAtTimeDetails                    OpcuaNodeIdServicesDataType = 689
	OpcuaNodeIdServicesDataType_DeleteEventDetails                     OpcuaNodeIdServicesDataType = 692
	OpcuaNodeIdServicesDataType_HistoryUpdateResult                    OpcuaNodeIdServicesDataType = 695
	OpcuaNodeIdServicesDataType_HistoryUpdateRequest                   OpcuaNodeIdServicesDataType = 698
	OpcuaNodeIdServicesDataType_HistoryUpdateResponse                  OpcuaNodeIdServicesDataType = 701
	OpcuaNodeIdServicesDataType_CallMethodRequest                      OpcuaNodeIdServicesDataType = 704
	OpcuaNodeIdServicesDataType_CallMethodResult                       OpcuaNodeIdServicesDataType = 707
	OpcuaNodeIdServicesDataType_CallRequest                            OpcuaNodeIdServicesDataType = 710
	OpcuaNodeIdServicesDataType_CallResponse                           OpcuaNodeIdServicesDataType = 713
	OpcuaNodeIdServicesDataType_MonitoringMode                         OpcuaNodeIdServicesDataType = 716
	OpcuaNodeIdServicesDataType_DataChangeTrigger                      OpcuaNodeIdServicesDataType = 717
	OpcuaNodeIdServicesDataType_DeadbandType                           OpcuaNodeIdServicesDataType = 718
	OpcuaNodeIdServicesDataType_MonitoringFilter                       OpcuaNodeIdServicesDataType = 719
	OpcuaNodeIdServicesDataType_DataChangeFilter                       OpcuaNodeIdServicesDataType = 722
	OpcuaNodeIdServicesDataType_EventFilter                            OpcuaNodeIdServicesDataType = 725
	OpcuaNodeIdServicesDataType_AggregateFilter                        OpcuaNodeIdServicesDataType = 728
	OpcuaNodeIdServicesDataType_MonitoringFilterResult                 OpcuaNodeIdServicesDataType = 731
	OpcuaNodeIdServicesDataType_EventFilterResult                      OpcuaNodeIdServicesDataType = 734
	OpcuaNodeIdServicesDataType_AggregateFilterResult                  OpcuaNodeIdServicesDataType = 737
	OpcuaNodeIdServicesDataType_MonitoringParameters                   OpcuaNodeIdServicesDataType = 740
	OpcuaNodeIdServicesDataType_MonitoredItemCreateRequest             OpcuaNodeIdServicesDataType = 743
	OpcuaNodeIdServicesDataType_MonitoredItemCreateResult              OpcuaNodeIdServicesDataType = 746
	OpcuaNodeIdServicesDataType_CreateMonitoredItemsRequest            OpcuaNodeIdServicesDataType = 749
	OpcuaNodeIdServicesDataType_CreateMonitoredItemsResponse           OpcuaNodeIdServicesDataType = 752
	OpcuaNodeIdServicesDataType_MonitoredItemModifyRequest             OpcuaNodeIdServicesDataType = 755
	OpcuaNodeIdServicesDataType_MonitoredItemModifyResult              OpcuaNodeIdServicesDataType = 758
	OpcuaNodeIdServicesDataType_ModifyMonitoredItemsRequest            OpcuaNodeIdServicesDataType = 761
	OpcuaNodeIdServicesDataType_ModifyMonitoredItemsResponse           OpcuaNodeIdServicesDataType = 764
	OpcuaNodeIdServicesDataType_SetMonitoringModeRequest               OpcuaNodeIdServicesDataType = 767
	OpcuaNodeIdServicesDataType_SetMonitoringModeResponse              OpcuaNodeIdServicesDataType = 770
	OpcuaNodeIdServicesDataType_SetTriggeringRequest                   OpcuaNodeIdServicesDataType = 773
	OpcuaNodeIdServicesDataType_SetTriggeringResponse                  OpcuaNodeIdServicesDataType = 776
	OpcuaNodeIdServicesDataType_DeleteMonitoredItemsRequest            OpcuaNodeIdServicesDataType = 779
	OpcuaNodeIdServicesDataType_DeleteMonitoredItemsResponse           OpcuaNodeIdServicesDataType = 782
	OpcuaNodeIdServicesDataType_CreateSubscriptionRequest              OpcuaNodeIdServicesDataType = 785
	OpcuaNodeIdServicesDataType_CreateSubscriptionResponse             OpcuaNodeIdServicesDataType = 788
	OpcuaNodeIdServicesDataType_ModifySubscriptionRequest              OpcuaNodeIdServicesDataType = 791
	OpcuaNodeIdServicesDataType_ModifySubscriptionResponse             OpcuaNodeIdServicesDataType = 794
	OpcuaNodeIdServicesDataType_SetPublishingModeRequest               OpcuaNodeIdServicesDataType = 797
	OpcuaNodeIdServicesDataType_SetPublishingModeResponse              OpcuaNodeIdServicesDataType = 800
	OpcuaNodeIdServicesDataType_NotificationMessage                    OpcuaNodeIdServicesDataType = 803
	OpcuaNodeIdServicesDataType_MonitoredItemNotification              OpcuaNodeIdServicesDataType = 806
	OpcuaNodeIdServicesDataType_DataChangeNotification                 OpcuaNodeIdServicesDataType = 809
	OpcuaNodeIdServicesDataType_StatusChangeNotification               OpcuaNodeIdServicesDataType = 818
	OpcuaNodeIdServicesDataType_SubscriptionAcknowledgement            OpcuaNodeIdServicesDataType = 821
	OpcuaNodeIdServicesDataType_PublishRequest                         OpcuaNodeIdServicesDataType = 824
	OpcuaNodeIdServicesDataType_PublishResponse                        OpcuaNodeIdServicesDataType = 827
	OpcuaNodeIdServicesDataType_RepublishRequest                       OpcuaNodeIdServicesDataType = 830
	OpcuaNodeIdServicesDataType_RepublishResponse                      OpcuaNodeIdServicesDataType = 833
	OpcuaNodeIdServicesDataType_TransferResult                         OpcuaNodeIdServicesDataType = 836
	OpcuaNodeIdServicesDataType_TransferSubscriptionsRequest           OpcuaNodeIdServicesDataType = 839
	OpcuaNodeIdServicesDataType_TransferSubscriptionsResponse          OpcuaNodeIdServicesDataType = 842
	OpcuaNodeIdServicesDataType_DeleteSubscriptionsRequest             OpcuaNodeIdServicesDataType = 845
	OpcuaNodeIdServicesDataType_DeleteSubscriptionsResponse            OpcuaNodeIdServicesDataType = 848
	OpcuaNodeIdServicesDataType_RedundancySupport                      OpcuaNodeIdServicesDataType = 851
	OpcuaNodeIdServicesDataType_ServerState                            OpcuaNodeIdServicesDataType = 852
	OpcuaNodeIdServicesDataType_RedundantServerDataType                OpcuaNodeIdServicesDataType = 853
	OpcuaNodeIdServicesDataType_SamplingIntervalDiagnosticsDataType    OpcuaNodeIdServicesDataType = 856
	OpcuaNodeIdServicesDataType_ServerDiagnosticsSummaryDataType       OpcuaNodeIdServicesDataType = 859
	OpcuaNodeIdServicesDataType_ServerStatusDataType                   OpcuaNodeIdServicesDataType = 862
	OpcuaNodeIdServicesDataType_SessionDiagnosticsDataType             OpcuaNodeIdServicesDataType = 865
	OpcuaNodeIdServicesDataType_SessionSecurityDiagnosticsDataType     OpcuaNodeIdServicesDataType = 868
	OpcuaNodeIdServicesDataType_ServiceCounterDataType                 OpcuaNodeIdServicesDataType = 871
	OpcuaNodeIdServicesDataType_SubscriptionDiagnosticsDataType        OpcuaNodeIdServicesDataType = 874
	OpcuaNodeIdServicesDataType_ModelChangeStructureDataType           OpcuaNodeIdServicesDataType = 877
	OpcuaNodeIdServicesDataType_Range                                  OpcuaNodeIdServicesDataType = 884
	OpcuaNodeIdServicesDataType_EUInformation                          OpcuaNodeIdServicesDataType = 887
	OpcuaNodeIdServicesDataType_ExceptionDeviationFormat               OpcuaNodeIdServicesDataType = 890
	OpcuaNodeIdServicesDataType_Annotation                             OpcuaNodeIdServicesDataType = 891
	OpcuaNodeIdServicesDataType_ProgramDiagnosticDataType              OpcuaNodeIdServicesDataType = 894
	OpcuaNodeIdServicesDataType_SemanticChangeStructureDataType        OpcuaNodeIdServicesDataType = 897
	OpcuaNodeIdServicesDataType_EventNotificationList                  OpcuaNodeIdServicesDataType = 914
	OpcuaNodeIdServicesDataType_EventFieldList                         OpcuaNodeIdServicesDataType = 917
	OpcuaNodeIdServicesDataType_HistoryEventFieldList                  OpcuaNodeIdServicesDataType = 920
	OpcuaNodeIdServicesDataType_IssuedIdentityToken                    OpcuaNodeIdServicesDataType = 938
	OpcuaNodeIdServicesDataType_NotificationData                       OpcuaNodeIdServicesDataType = 945
	OpcuaNodeIdServicesDataType_AggregateConfiguration                 OpcuaNodeIdServicesDataType = 948
	OpcuaNodeIdServicesDataType_ImageBMP                               OpcuaNodeIdServicesDataType = 2000
	OpcuaNodeIdServicesDataType_ImageGIF                               OpcuaNodeIdServicesDataType = 2001
	OpcuaNodeIdServicesDataType_ImageJPG                               OpcuaNodeIdServicesDataType = 2002
	OpcuaNodeIdServicesDataType_ImagePNG                               OpcuaNodeIdServicesDataType = 2003
	OpcuaNodeIdServicesDataType_EnumValueType                          OpcuaNodeIdServicesDataType = 7594
	OpcuaNodeIdServicesDataType_TimeZoneDataType                       OpcuaNodeIdServicesDataType = 8912
	OpcuaNodeIdServicesDataType_ModificationInfo                       OpcuaNodeIdServicesDataType = 11216
	OpcuaNodeIdServicesDataType_HistoryModifiedData                    OpcuaNodeIdServicesDataType = 11217
	OpcuaNodeIdServicesDataType_HistoryUpdateType                      OpcuaNodeIdServicesDataType = 11234
	OpcuaNodeIdServicesDataType_PerformUpdateType                      OpcuaNodeIdServicesDataType = 11293
	OpcuaNodeIdServicesDataType_UpdateStructureDataDetails             OpcuaNodeIdServicesDataType = 11295
	OpcuaNodeIdServicesDataType_BitFieldMaskDataType                   OpcuaNodeIdServicesDataType = 11737
	OpcuaNodeIdServicesDataType_InstanceNode                           OpcuaNodeIdServicesDataType = 11879
	OpcuaNodeIdServicesDataType_TypeNode                               OpcuaNodeIdServicesDataType = 11880
	OpcuaNodeIdServicesDataType_OpenFileMode                           OpcuaNodeIdServicesDataType = 11939
	OpcuaNodeIdServicesDataType_ModelChangeStructureVerbMask           OpcuaNodeIdServicesDataType = 11941
	OpcuaNodeIdServicesDataType_EndpointUrlListDataType                OpcuaNodeIdServicesDataType = 11943
	OpcuaNodeIdServicesDataType_NetworkGroupDataType                   OpcuaNodeIdServicesDataType = 11944
	OpcuaNodeIdServicesDataType_AxisScaleEnumeration                   OpcuaNodeIdServicesDataType = 12077
	OpcuaNodeIdServicesDataType_AxisInformation                        OpcuaNodeIdServicesDataType = 12079
	OpcuaNodeIdServicesDataType_XVType                                 OpcuaNodeIdServicesDataType = 12080
	OpcuaNodeIdServicesDataType_ComplexNumberType                      OpcuaNodeIdServicesDataType = 12171
	OpcuaNodeIdServicesDataType_DoubleComplexNumberType                OpcuaNodeIdServicesDataType = 12172
	OpcuaNodeIdServicesDataType_ServerOnNetwork                        OpcuaNodeIdServicesDataType = 12189
	OpcuaNodeIdServicesDataType_FindServersOnNetworkRequest            OpcuaNodeIdServicesDataType = 12190
	OpcuaNodeIdServicesDataType_FindServersOnNetworkResponse           OpcuaNodeIdServicesDataType = 12191
	OpcuaNodeIdServicesDataType_RegisterServer2Request                 OpcuaNodeIdServicesDataType = 12193
	OpcuaNodeIdServicesDataType_RegisterServer2Response                OpcuaNodeIdServicesDataType = 12194
	OpcuaNodeIdServicesDataType_TrustListMasks                         OpcuaNodeIdServicesDataType = 12552
	OpcuaNodeIdServicesDataType_TrustListDataType                      OpcuaNodeIdServicesDataType = 12554
	OpcuaNodeIdServicesDataType_OptionSet                              OpcuaNodeIdServicesDataType = 12755
	OpcuaNodeIdServicesDataType_Union                                  OpcuaNodeIdServicesDataType = 12756
	OpcuaNodeIdServicesDataType_NormalizedString                       OpcuaNodeIdServicesDataType = 12877
	OpcuaNodeIdServicesDataType_DecimalString                          OpcuaNodeIdServicesDataType = 12878
	OpcuaNodeIdServicesDataType_DurationString                         OpcuaNodeIdServicesDataType = 12879
	OpcuaNodeIdServicesDataType_TimeString                             OpcuaNodeIdServicesDataType = 12880
	OpcuaNodeIdServicesDataType_DateString                             OpcuaNodeIdServicesDataType = 12881
	OpcuaNodeIdServicesDataType_DiscoveryConfiguration                 OpcuaNodeIdServicesDataType = 12890
	OpcuaNodeIdServicesDataType_MdnsDiscoveryConfiguration             OpcuaNodeIdServicesDataType = 12891
	OpcuaNodeIdServicesDataType_PublishedVariableDataType              OpcuaNodeIdServicesDataType = 14273
	OpcuaNodeIdServicesDataType_DataSetMetaDataType                    OpcuaNodeIdServicesDataType = 14523
	OpcuaNodeIdServicesDataType_FieldMetaData                          OpcuaNodeIdServicesDataType = 14524
	OpcuaNodeIdServicesDataType_DataTypeDescription                    OpcuaNodeIdServicesDataType = 14525
	OpcuaNodeIdServicesDataType_KeyValuePair                           OpcuaNodeIdServicesDataType = 14533
	OpcuaNodeIdServicesDataType_ConfigurationVersionDataType           OpcuaNodeIdServicesDataType = 14593
	OpcuaNodeIdServicesDataType_PubSubState                            OpcuaNodeIdServicesDataType = 14647
	OpcuaNodeIdServicesDataType_FieldTargetDataType                    OpcuaNodeIdServicesDataType = 14744
	OpcuaNodeIdServicesDataType_SimpleTypeDescription                  OpcuaNodeIdServicesDataType = 15005
	OpcuaNodeIdServicesDataType_UABinaryFileDataType                   OpcuaNodeIdServicesDataType = 15006
	OpcuaNodeIdServicesDataType_BrokerConnectionTransportDataType      OpcuaNodeIdServicesDataType = 15007
	OpcuaNodeIdServicesDataType_BrokerTransportQualityOfService        OpcuaNodeIdServicesDataType = 15008
	OpcuaNodeIdServicesDataType_AccessLevelType                        OpcuaNodeIdServicesDataType = 15031
	OpcuaNodeIdServicesDataType_EventNotifierType                      OpcuaNodeIdServicesDataType = 15033
	OpcuaNodeIdServicesDataType_AccessLevelExType                      OpcuaNodeIdServicesDataType = 15406
	OpcuaNodeIdServicesDataType_WriterGroupDataType                    OpcuaNodeIdServicesDataType = 15480
	OpcuaNodeIdServicesDataType_StructureDescription                   OpcuaNodeIdServicesDataType = 15487
	OpcuaNodeIdServicesDataType_EnumDescription                        OpcuaNodeIdServicesDataType = 15488
	OpcuaNodeIdServicesDataType_NetworkAddressDataType                 OpcuaNodeIdServicesDataType = 15502
	OpcuaNodeIdServicesDataType_NetworkAddressUrlDataType              OpcuaNodeIdServicesDataType = 15510
	OpcuaNodeIdServicesDataType_ReaderGroupDataType                    OpcuaNodeIdServicesDataType = 15520
	OpcuaNodeIdServicesDataType_EndpointType                           OpcuaNodeIdServicesDataType = 15528
	OpcuaNodeIdServicesDataType_PubSubConfigurationDataType            OpcuaNodeIdServicesDataType = 15530
	OpcuaNodeIdServicesDataType_DatagramWriterGroupTransportDataType   OpcuaNodeIdServicesDataType = 15532
	OpcuaNodeIdServicesDataType_DataTypeSchemaHeader                   OpcuaNodeIdServicesDataType = 15534
	OpcuaNodeIdServicesDataType_PublishedDataSetDataType               OpcuaNodeIdServicesDataType = 15578
	OpcuaNodeIdServicesDataType_PublishedDataSetSourceDataType         OpcuaNodeIdServicesDataType = 15580
	OpcuaNodeIdServicesDataType_PublishedDataItemsDataType             OpcuaNodeIdServicesDataType = 15581
	OpcuaNodeIdServicesDataType_PublishedEventsDataType                OpcuaNodeIdServicesDataType = 15582
	OpcuaNodeIdServicesDataType_DataSetFieldContentMask                OpcuaNodeIdServicesDataType = 15583
	OpcuaNodeIdServicesDataType_DataSetWriterDataType                  OpcuaNodeIdServicesDataType = 15597
	OpcuaNodeIdServicesDataType_DataSetWriterTransportDataType         OpcuaNodeIdServicesDataType = 15598
	OpcuaNodeIdServicesDataType_DataSetWriterMessageDataType           OpcuaNodeIdServicesDataType = 15605
	OpcuaNodeIdServicesDataType_PubSubGroupDataType                    OpcuaNodeIdServicesDataType = 15609
	OpcuaNodeIdServicesDataType_WriterGroupTransportDataType           OpcuaNodeIdServicesDataType = 15611
	OpcuaNodeIdServicesDataType_WriterGroupMessageDataType             OpcuaNodeIdServicesDataType = 15616
	OpcuaNodeIdServicesDataType_PubSubConnectionDataType               OpcuaNodeIdServicesDataType = 15617
	OpcuaNodeIdServicesDataType_ConnectionTransportDataType            OpcuaNodeIdServicesDataType = 15618
	OpcuaNodeIdServicesDataType_ReaderGroupTransportDataType           OpcuaNodeIdServicesDataType = 15621
	OpcuaNodeIdServicesDataType_ReaderGroupMessageDataType             OpcuaNodeIdServicesDataType = 15622
	OpcuaNodeIdServicesDataType_DataSetReaderDataType                  OpcuaNodeIdServicesDataType = 15623
	OpcuaNodeIdServicesDataType_DataSetReaderTransportDataType         OpcuaNodeIdServicesDataType = 15628
	OpcuaNodeIdServicesDataType_DataSetReaderMessageDataType           OpcuaNodeIdServicesDataType = 15629
	OpcuaNodeIdServicesDataType_SubscribedDataSetDataType              OpcuaNodeIdServicesDataType = 15630
	OpcuaNodeIdServicesDataType_TargetVariablesDataType                OpcuaNodeIdServicesDataType = 15631
	OpcuaNodeIdServicesDataType_IdentityCriteriaType                   OpcuaNodeIdServicesDataType = 15632
	OpcuaNodeIdServicesDataType_IdentityMappingRuleType                OpcuaNodeIdServicesDataType = 15634
	OpcuaNodeIdServicesDataType_SubscribedDataSetMirrorDataType        OpcuaNodeIdServicesDataType = 15635
	OpcuaNodeIdServicesDataType_UadpNetworkMessageContentMask          OpcuaNodeIdServicesDataType = 15642
	OpcuaNodeIdServicesDataType_UadpWriterGroupMessageDataType         OpcuaNodeIdServicesDataType = 15645
	OpcuaNodeIdServicesDataType_UadpDataSetMessageContentMask          OpcuaNodeIdServicesDataType = 15646
	OpcuaNodeIdServicesDataType_UadpDataSetWriterMessageDataType       OpcuaNodeIdServicesDataType = 15652
	OpcuaNodeIdServicesDataType_UadpDataSetReaderMessageDataType       OpcuaNodeIdServicesDataType = 15653
	OpcuaNodeIdServicesDataType_JsonNetworkMessageContentMask          OpcuaNodeIdServicesDataType = 15654
	OpcuaNodeIdServicesDataType_JsonWriterGroupMessageDataType         OpcuaNodeIdServicesDataType = 15657
	OpcuaNodeIdServicesDataType_JsonDataSetMessageContentMask          OpcuaNodeIdServicesDataType = 15658
	OpcuaNodeIdServicesDataType_JsonDataSetWriterMessageDataType       OpcuaNodeIdServicesDataType = 15664
	OpcuaNodeIdServicesDataType_JsonDataSetReaderMessageDataType       OpcuaNodeIdServicesDataType = 15665
	OpcuaNodeIdServicesDataType_BrokerWriterGroupTransportDataType     OpcuaNodeIdServicesDataType = 15667
	OpcuaNodeIdServicesDataType_BrokerDataSetWriterTransportDataType   OpcuaNodeIdServicesDataType = 15669
	OpcuaNodeIdServicesDataType_BrokerDataSetReaderTransportDataType   OpcuaNodeIdServicesDataType = 15670
	OpcuaNodeIdServicesDataType_OverrideValueHandling                  OpcuaNodeIdServicesDataType = 15874
	OpcuaNodeIdServicesDataType_SessionlessInvokeRequestType           OpcuaNodeIdServicesDataType = 15901
	OpcuaNodeIdServicesDataType_DataSetFieldFlags                      OpcuaNodeIdServicesDataType = 15904
	OpcuaNodeIdServicesDataType_AudioDataType                          OpcuaNodeIdServicesDataType = 16307
	OpcuaNodeIdServicesDataType_AdditionalParametersType               OpcuaNodeIdServicesDataType = 16313
	OpcuaNodeIdServicesDataType_DatagramConnectionTransportDataType    OpcuaNodeIdServicesDataType = 17467
	OpcuaNodeIdServicesDataType_RsaEncryptedSecret                     OpcuaNodeIdServicesDataType = 17545
	OpcuaNodeIdServicesDataType_EccEncryptedSecret                     OpcuaNodeIdServicesDataType = 17546
	OpcuaNodeIdServicesDataType_EphemeralKeyType                       OpcuaNodeIdServicesDataType = 17548
	OpcuaNodeIdServicesDataType_Index                                  OpcuaNodeIdServicesDataType = 17588
	OpcuaNodeIdServicesDataType_GenericAttributeValue                  OpcuaNodeIdServicesDataType = 17606
	OpcuaNodeIdServicesDataType_GenericAttributes                      OpcuaNodeIdServicesDataType = 17607
	OpcuaNodeIdServicesDataType_DecimalDataType                        OpcuaNodeIdServicesDataType = 17861
	OpcuaNodeIdServicesDataType_RationalNumber                         OpcuaNodeIdServicesDataType = 18806
	OpcuaNodeIdServicesDataType_Vector                                 OpcuaNodeIdServicesDataType = 18807
	OpcuaNodeIdServicesDataType_ThreeDVector                           OpcuaNodeIdServicesDataType = 18808
	OpcuaNodeIdServicesDataType_CartesianCoordinates                   OpcuaNodeIdServicesDataType = 18809
	OpcuaNodeIdServicesDataType_ThreeDCartesianCoordinates             OpcuaNodeIdServicesDataType = 18810
	OpcuaNodeIdServicesDataType_Orientation                            OpcuaNodeIdServicesDataType = 18811
	OpcuaNodeIdServicesDataType_ThreeDOrientation                      OpcuaNodeIdServicesDataType = 18812
	OpcuaNodeIdServicesDataType_Frame                                  OpcuaNodeIdServicesDataType = 18813
	OpcuaNodeIdServicesDataType_ThreeDFrame                            OpcuaNodeIdServicesDataType = 18814
	OpcuaNodeIdServicesDataType_DiagnosticsLevel                       OpcuaNodeIdServicesDataType = 19723
	OpcuaNodeIdServicesDataType_PubSubDiagnosticsCounterClassification OpcuaNodeIdServicesDataType = 19730
	OpcuaNodeIdServicesDataType_DataSetOrderingType                    OpcuaNodeIdServicesDataType = 20408
	OpcuaNodeIdServicesDataType_VersionTime                            OpcuaNodeIdServicesDataType = 20998
	OpcuaNodeIdServicesDataType_SessionlessInvokeResponseType          OpcuaNodeIdServicesDataType = 20999
	OpcuaNodeIdServicesDataType_AliasNameDataType                      OpcuaNodeIdServicesDataType = 23468
	OpcuaNodeIdServicesDataType_ReadAnnotationDataDetails              OpcuaNodeIdServicesDataType = 23497
	OpcuaNodeIdServicesDataType_CurrencyUnitType                       OpcuaNodeIdServicesDataType = 23498
	OpcuaNodeIdServicesDataType_TrustListValidationOptions             OpcuaNodeIdServicesDataType = 23564
	OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetRefDataType OpcuaNodeIdServicesDataType = 23599
	OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetDataType    OpcuaNodeIdServicesDataType = 23600
	OpcuaNodeIdServicesDataType_SecurityGroupDataType                  OpcuaNodeIdServicesDataType = 23601
	OpcuaNodeIdServicesDataType_PubSubConfiguration2DataType           OpcuaNodeIdServicesDataType = 23602
	OpcuaNodeIdServicesDataType_QosDataType                            OpcuaNodeIdServicesDataType = 23603
	OpcuaNodeIdServicesDataType_TransmitQosDataType                    OpcuaNodeIdServicesDataType = 23604
	OpcuaNodeIdServicesDataType_TransmitQosPriorityDataType            OpcuaNodeIdServicesDataType = 23605
	OpcuaNodeIdServicesDataType_ReceiveQosDataType                     OpcuaNodeIdServicesDataType = 23608
	OpcuaNodeIdServicesDataType_ReceiveQosPriorityDataType             OpcuaNodeIdServicesDataType = 23609
	OpcuaNodeIdServicesDataType_DatagramConnectionTransport2DataType   OpcuaNodeIdServicesDataType = 23612
	OpcuaNodeIdServicesDataType_DatagramWriterGroupTransport2DataType  OpcuaNodeIdServicesDataType = 23613
	OpcuaNodeIdServicesDataType_DatagramDataSetReaderTransportDataType OpcuaNodeIdServicesDataType = 23614
	OpcuaNodeIdServicesDataType_UriString                              OpcuaNodeIdServicesDataType = 23751
	OpcuaNodeIdServicesDataType_ProgramDiagnostic2DataType             OpcuaNodeIdServicesDataType = 24033
	OpcuaNodeIdServicesDataType_PortableQualifiedName                  OpcuaNodeIdServicesDataType = 24105
	OpcuaNodeIdServicesDataType_PortableNodeId                         OpcuaNodeIdServicesDataType = 24106
	OpcuaNodeIdServicesDataType_UnsignedRationalNumber                 OpcuaNodeIdServicesDataType = 24107
	OpcuaNodeIdServicesDataType_Duplex                                 OpcuaNodeIdServicesDataType = 24210
	OpcuaNodeIdServicesDataType_InterfaceAdminStatus                   OpcuaNodeIdServicesDataType = 24212
	OpcuaNodeIdServicesDataType_InterfaceOperStatus                    OpcuaNodeIdServicesDataType = 24214
	OpcuaNodeIdServicesDataType_NegotiationStatus                      OpcuaNodeIdServicesDataType = 24216
	OpcuaNodeIdServicesDataType_TsnFailureCode                         OpcuaNodeIdServicesDataType = 24218
	OpcuaNodeIdServicesDataType_TsnStreamState                         OpcuaNodeIdServicesDataType = 24220
	OpcuaNodeIdServicesDataType_TsnTalkerStatus                        OpcuaNodeIdServicesDataType = 24222
	OpcuaNodeIdServicesDataType_TsnListenerStatus                      OpcuaNodeIdServicesDataType = 24224
	OpcuaNodeIdServicesDataType_SemanticVersionString                  OpcuaNodeIdServicesDataType = 24263
	OpcuaNodeIdServicesDataType_PasswordOptionsMask                    OpcuaNodeIdServicesDataType = 24277
	OpcuaNodeIdServicesDataType_UserConfigurationMask                  OpcuaNodeIdServicesDataType = 24279
	OpcuaNodeIdServicesDataType_UserManagementDataType                 OpcuaNodeIdServicesDataType = 24281
	OpcuaNodeIdServicesDataType_PriorityMappingEntryType               OpcuaNodeIdServicesDataType = 25220
	OpcuaNodeIdServicesDataType_PublishedDataSetCustomSourceDataType   OpcuaNodeIdServicesDataType = 25269
	OpcuaNodeIdServicesDataType_PubSubKeyPushTargetDataType            OpcuaNodeIdServicesDataType = 25270
	OpcuaNodeIdServicesDataType_PubSubConfigurationRefMask             OpcuaNodeIdServicesDataType = 25517
	OpcuaNodeIdServicesDataType_PubSubConfigurationRefDataType         OpcuaNodeIdServicesDataType = 25519
	OpcuaNodeIdServicesDataType_PubSubConfigurationValueDataType       OpcuaNodeIdServicesDataType = 25520
	OpcuaNodeIdServicesDataType_EncodedTicket                          OpcuaNodeIdServicesDataType = 25726
	OpcuaNodeIdServicesDataType_Handle                                 OpcuaNodeIdServicesDataType = 31917
	OpcuaNodeIdServicesDataType_TrimmedString                          OpcuaNodeIdServicesDataType = 31918
	OpcuaNodeIdServicesDataType_AlarmMask                              OpcuaNodeIdServicesDataType = 32251
	OpcuaNodeIdServicesDataType_TransactionErrorType                   OpcuaNodeIdServicesDataType = 32285
	OpcuaNodeIdServicesDataType_ReferenceDescriptionDataType           OpcuaNodeIdServicesDataType = 32659
	OpcuaNodeIdServicesDataType_ReferenceListEntryDataType             OpcuaNodeIdServicesDataType = 32660
)

var OpcuaNodeIdServicesDataTypeValues []OpcuaNodeIdServicesDataType

func init() {
	_ = errors.New
	OpcuaNodeIdServicesDataTypeValues = []OpcuaNodeIdServicesDataType{
		OpcuaNodeIdServicesDataType_Boolean,
		OpcuaNodeIdServicesDataType_SByte,
		OpcuaNodeIdServicesDataType_Byte,
		OpcuaNodeIdServicesDataType_Int16,
		OpcuaNodeIdServicesDataType_UInt16,
		OpcuaNodeIdServicesDataType_Int32,
		OpcuaNodeIdServicesDataType_UInt32,
		OpcuaNodeIdServicesDataType_Int64,
		OpcuaNodeIdServicesDataType_UInt64,
		OpcuaNodeIdServicesDataType_Float,
		OpcuaNodeIdServicesDataType_Double,
		OpcuaNodeIdServicesDataType_String,
		OpcuaNodeIdServicesDataType_DateTime,
		OpcuaNodeIdServicesDataType_Guid,
		OpcuaNodeIdServicesDataType_ByteString,
		OpcuaNodeIdServicesDataType_XmlElement,
		OpcuaNodeIdServicesDataType_NodeId,
		OpcuaNodeIdServicesDataType_ExpandedNodeId,
		OpcuaNodeIdServicesDataType_StatusCode,
		OpcuaNodeIdServicesDataType_QualifiedName,
		OpcuaNodeIdServicesDataType_LocalizedText,
		OpcuaNodeIdServicesDataType_Structure,
		OpcuaNodeIdServicesDataType_DataValue,
		OpcuaNodeIdServicesDataType_BaseDataType,
		OpcuaNodeIdServicesDataType_DiagnosticInfo,
		OpcuaNodeIdServicesDataType_Number,
		OpcuaNodeIdServicesDataType_Integer,
		OpcuaNodeIdServicesDataType_UInteger,
		OpcuaNodeIdServicesDataType_Enumeration,
		OpcuaNodeIdServicesDataType_Image,
		OpcuaNodeIdServicesDataType_Decimal,
		OpcuaNodeIdServicesDataType_PermissionType,
		OpcuaNodeIdServicesDataType_AccessRestrictionType,
		OpcuaNodeIdServicesDataType_RolePermissionType,
		OpcuaNodeIdServicesDataType_DataTypeDefinition,
		OpcuaNodeIdServicesDataType_StructureType,
		OpcuaNodeIdServicesDataType_StructureDefinition,
		OpcuaNodeIdServicesDataType_EnumDefinition,
		OpcuaNodeIdServicesDataType_StructureField,
		OpcuaNodeIdServicesDataType_EnumField,
		OpcuaNodeIdServicesDataType_NamingRuleType,
		OpcuaNodeIdServicesDataType_IdType,
		OpcuaNodeIdServicesDataType_NodeClass,
		OpcuaNodeIdServicesDataType_Node,
		OpcuaNodeIdServicesDataType_ObjectNode,
		OpcuaNodeIdServicesDataType_ObjectTypeNode,
		OpcuaNodeIdServicesDataType_VariableNode,
		OpcuaNodeIdServicesDataType_VariableTypeNode,
		OpcuaNodeIdServicesDataType_ReferenceTypeNode,
		OpcuaNodeIdServicesDataType_MethodNode,
		OpcuaNodeIdServicesDataType_ViewNode,
		OpcuaNodeIdServicesDataType_DataTypeNode,
		OpcuaNodeIdServicesDataType_ReferenceNode,
		OpcuaNodeIdServicesDataType_IntegerId,
		OpcuaNodeIdServicesDataType_Counter,
		OpcuaNodeIdServicesDataType_Duration,
		OpcuaNodeIdServicesDataType_NumericRange,
		OpcuaNodeIdServicesDataType_UtcTime,
		OpcuaNodeIdServicesDataType_LocaleId,
		OpcuaNodeIdServicesDataType_Argument,
		OpcuaNodeIdServicesDataType_StatusResult,
		OpcuaNodeIdServicesDataType_MessageSecurityMode,
		OpcuaNodeIdServicesDataType_UserTokenType,
		OpcuaNodeIdServicesDataType_UserTokenPolicy,
		OpcuaNodeIdServicesDataType_ApplicationType,
		OpcuaNodeIdServicesDataType_ApplicationDescription,
		OpcuaNodeIdServicesDataType_ApplicationInstanceCertificate,
		OpcuaNodeIdServicesDataType_EndpointDescription,
		OpcuaNodeIdServicesDataType_SecurityTokenRequestType,
		OpcuaNodeIdServicesDataType_UserIdentityToken,
		OpcuaNodeIdServicesDataType_AnonymousIdentityToken,
		OpcuaNodeIdServicesDataType_UserNameIdentityToken,
		OpcuaNodeIdServicesDataType_X509IdentityToken,
		OpcuaNodeIdServicesDataType_EndpointConfiguration,
		OpcuaNodeIdServicesDataType_BuildInfo,
		OpcuaNodeIdServicesDataType_SignedSoftwareCertificate,
		OpcuaNodeIdServicesDataType_AttributeWriteMask,
		OpcuaNodeIdServicesDataType_NodeAttributesMask,
		OpcuaNodeIdServicesDataType_NodeAttributes,
		OpcuaNodeIdServicesDataType_ObjectAttributes,
		OpcuaNodeIdServicesDataType_VariableAttributes,
		OpcuaNodeIdServicesDataType_MethodAttributes,
		OpcuaNodeIdServicesDataType_ObjectTypeAttributes,
		OpcuaNodeIdServicesDataType_VariableTypeAttributes,
		OpcuaNodeIdServicesDataType_ReferenceTypeAttributes,
		OpcuaNodeIdServicesDataType_DataTypeAttributes,
		OpcuaNodeIdServicesDataType_ViewAttributes,
		OpcuaNodeIdServicesDataType_AddNodesItem,
		OpcuaNodeIdServicesDataType_AddReferencesItem,
		OpcuaNodeIdServicesDataType_DeleteNodesItem,
		OpcuaNodeIdServicesDataType_DeleteReferencesItem,
		OpcuaNodeIdServicesDataType_SessionAuthenticationToken,
		OpcuaNodeIdServicesDataType_RequestHeader,
		OpcuaNodeIdServicesDataType_ResponseHeader,
		OpcuaNodeIdServicesDataType_ServiceFault,
		OpcuaNodeIdServicesDataType_FindServersRequest,
		OpcuaNodeIdServicesDataType_FindServersResponse,
		OpcuaNodeIdServicesDataType_GetEndpointsRequest,
		OpcuaNodeIdServicesDataType_GetEndpointsResponse,
		OpcuaNodeIdServicesDataType_RegisteredServer,
		OpcuaNodeIdServicesDataType_RegisterServerRequest,
		OpcuaNodeIdServicesDataType_RegisterServerResponse,
		OpcuaNodeIdServicesDataType_ChannelSecurityToken,
		OpcuaNodeIdServicesDataType_OpenSecureChannelRequest,
		OpcuaNodeIdServicesDataType_OpenSecureChannelResponse,
		OpcuaNodeIdServicesDataType_CloseSecureChannelRequest,
		OpcuaNodeIdServicesDataType_CloseSecureChannelResponse,
		OpcuaNodeIdServicesDataType_SignatureData,
		OpcuaNodeIdServicesDataType_CreateSessionRequest,
		OpcuaNodeIdServicesDataType_CreateSessionResponse,
		OpcuaNodeIdServicesDataType_ActivateSessionRequest,
		OpcuaNodeIdServicesDataType_ActivateSessionResponse,
		OpcuaNodeIdServicesDataType_CloseSessionRequest,
		OpcuaNodeIdServicesDataType_CloseSessionResponse,
		OpcuaNodeIdServicesDataType_CancelRequest,
		OpcuaNodeIdServicesDataType_CancelResponse,
		OpcuaNodeIdServicesDataType_AddNodesResult,
		OpcuaNodeIdServicesDataType_AddNodesRequest,
		OpcuaNodeIdServicesDataType_AddNodesResponse,
		OpcuaNodeIdServicesDataType_AddReferencesRequest,
		OpcuaNodeIdServicesDataType_AddReferencesResponse,
		OpcuaNodeIdServicesDataType_DeleteNodesRequest,
		OpcuaNodeIdServicesDataType_DeleteNodesResponse,
		OpcuaNodeIdServicesDataType_DeleteReferencesRequest,
		OpcuaNodeIdServicesDataType_DeleteReferencesResponse,
		OpcuaNodeIdServicesDataType_BrowseDirection,
		OpcuaNodeIdServicesDataType_ViewDescription,
		OpcuaNodeIdServicesDataType_BrowseDescription,
		OpcuaNodeIdServicesDataType_BrowseResultMask,
		OpcuaNodeIdServicesDataType_ReferenceDescription,
		OpcuaNodeIdServicesDataType_ContinuationPoint,
		OpcuaNodeIdServicesDataType_BrowseResult,
		OpcuaNodeIdServicesDataType_BrowseRequest,
		OpcuaNodeIdServicesDataType_BrowseResponse,
		OpcuaNodeIdServicesDataType_BrowseNextRequest,
		OpcuaNodeIdServicesDataType_BrowseNextResponse,
		OpcuaNodeIdServicesDataType_RelativePathElement,
		OpcuaNodeIdServicesDataType_RelativePath,
		OpcuaNodeIdServicesDataType_BrowsePath,
		OpcuaNodeIdServicesDataType_BrowsePathTarget,
		OpcuaNodeIdServicesDataType_BrowsePathResult,
		OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsRequest,
		OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsResponse,
		OpcuaNodeIdServicesDataType_RegisterNodesRequest,
		OpcuaNodeIdServicesDataType_RegisterNodesResponse,
		OpcuaNodeIdServicesDataType_UnregisterNodesRequest,
		OpcuaNodeIdServicesDataType_UnregisterNodesResponse,
		OpcuaNodeIdServicesDataType_QueryDataDescription,
		OpcuaNodeIdServicesDataType_NodeTypeDescription,
		OpcuaNodeIdServicesDataType_FilterOperator,
		OpcuaNodeIdServicesDataType_QueryDataSet,
		OpcuaNodeIdServicesDataType_NodeReference,
		OpcuaNodeIdServicesDataType_ContentFilterElement,
		OpcuaNodeIdServicesDataType_ContentFilter,
		OpcuaNodeIdServicesDataType_FilterOperand,
		OpcuaNodeIdServicesDataType_ElementOperand,
		OpcuaNodeIdServicesDataType_LiteralOperand,
		OpcuaNodeIdServicesDataType_AttributeOperand,
		OpcuaNodeIdServicesDataType_SimpleAttributeOperand,
		OpcuaNodeIdServicesDataType_ContentFilterElementResult,
		OpcuaNodeIdServicesDataType_ContentFilterResult,
		OpcuaNodeIdServicesDataType_ParsingResult,
		OpcuaNodeIdServicesDataType_QueryFirstRequest,
		OpcuaNodeIdServicesDataType_QueryFirstResponse,
		OpcuaNodeIdServicesDataType_QueryNextRequest,
		OpcuaNodeIdServicesDataType_QueryNextResponse,
		OpcuaNodeIdServicesDataType_TimestampsToReturn,
		OpcuaNodeIdServicesDataType_ReadValueId,
		OpcuaNodeIdServicesDataType_ReadRequest,
		OpcuaNodeIdServicesDataType_ReadResponse,
		OpcuaNodeIdServicesDataType_HistoryReadValueId,
		OpcuaNodeIdServicesDataType_HistoryReadResult,
		OpcuaNodeIdServicesDataType_HistoryReadDetails,
		OpcuaNodeIdServicesDataType_ReadEventDetails,
		OpcuaNodeIdServicesDataType_ReadRawModifiedDetails,
		OpcuaNodeIdServicesDataType_ReadProcessedDetails,
		OpcuaNodeIdServicesDataType_ReadAtTimeDetails,
		OpcuaNodeIdServicesDataType_HistoryData,
		OpcuaNodeIdServicesDataType_HistoryEvent,
		OpcuaNodeIdServicesDataType_HistoryReadRequest,
		OpcuaNodeIdServicesDataType_HistoryReadResponse,
		OpcuaNodeIdServicesDataType_WriteValue,
		OpcuaNodeIdServicesDataType_WriteRequest,
		OpcuaNodeIdServicesDataType_WriteResponse,
		OpcuaNodeIdServicesDataType_HistoryUpdateDetails,
		OpcuaNodeIdServicesDataType_UpdateDataDetails,
		OpcuaNodeIdServicesDataType_UpdateEventDetails,
		OpcuaNodeIdServicesDataType_DeleteRawModifiedDetails,
		OpcuaNodeIdServicesDataType_DeleteAtTimeDetails,
		OpcuaNodeIdServicesDataType_DeleteEventDetails,
		OpcuaNodeIdServicesDataType_HistoryUpdateResult,
		OpcuaNodeIdServicesDataType_HistoryUpdateRequest,
		OpcuaNodeIdServicesDataType_HistoryUpdateResponse,
		OpcuaNodeIdServicesDataType_CallMethodRequest,
		OpcuaNodeIdServicesDataType_CallMethodResult,
		OpcuaNodeIdServicesDataType_CallRequest,
		OpcuaNodeIdServicesDataType_CallResponse,
		OpcuaNodeIdServicesDataType_MonitoringMode,
		OpcuaNodeIdServicesDataType_DataChangeTrigger,
		OpcuaNodeIdServicesDataType_DeadbandType,
		OpcuaNodeIdServicesDataType_MonitoringFilter,
		OpcuaNodeIdServicesDataType_DataChangeFilter,
		OpcuaNodeIdServicesDataType_EventFilter,
		OpcuaNodeIdServicesDataType_AggregateFilter,
		OpcuaNodeIdServicesDataType_MonitoringFilterResult,
		OpcuaNodeIdServicesDataType_EventFilterResult,
		OpcuaNodeIdServicesDataType_AggregateFilterResult,
		OpcuaNodeIdServicesDataType_MonitoringParameters,
		OpcuaNodeIdServicesDataType_MonitoredItemCreateRequest,
		OpcuaNodeIdServicesDataType_MonitoredItemCreateResult,
		OpcuaNodeIdServicesDataType_CreateMonitoredItemsRequest,
		OpcuaNodeIdServicesDataType_CreateMonitoredItemsResponse,
		OpcuaNodeIdServicesDataType_MonitoredItemModifyRequest,
		OpcuaNodeIdServicesDataType_MonitoredItemModifyResult,
		OpcuaNodeIdServicesDataType_ModifyMonitoredItemsRequest,
		OpcuaNodeIdServicesDataType_ModifyMonitoredItemsResponse,
		OpcuaNodeIdServicesDataType_SetMonitoringModeRequest,
		OpcuaNodeIdServicesDataType_SetMonitoringModeResponse,
		OpcuaNodeIdServicesDataType_SetTriggeringRequest,
		OpcuaNodeIdServicesDataType_SetTriggeringResponse,
		OpcuaNodeIdServicesDataType_DeleteMonitoredItemsRequest,
		OpcuaNodeIdServicesDataType_DeleteMonitoredItemsResponse,
		OpcuaNodeIdServicesDataType_CreateSubscriptionRequest,
		OpcuaNodeIdServicesDataType_CreateSubscriptionResponse,
		OpcuaNodeIdServicesDataType_ModifySubscriptionRequest,
		OpcuaNodeIdServicesDataType_ModifySubscriptionResponse,
		OpcuaNodeIdServicesDataType_SetPublishingModeRequest,
		OpcuaNodeIdServicesDataType_SetPublishingModeResponse,
		OpcuaNodeIdServicesDataType_NotificationMessage,
		OpcuaNodeIdServicesDataType_MonitoredItemNotification,
		OpcuaNodeIdServicesDataType_DataChangeNotification,
		OpcuaNodeIdServicesDataType_StatusChangeNotification,
		OpcuaNodeIdServicesDataType_SubscriptionAcknowledgement,
		OpcuaNodeIdServicesDataType_PublishRequest,
		OpcuaNodeIdServicesDataType_PublishResponse,
		OpcuaNodeIdServicesDataType_RepublishRequest,
		OpcuaNodeIdServicesDataType_RepublishResponse,
		OpcuaNodeIdServicesDataType_TransferResult,
		OpcuaNodeIdServicesDataType_TransferSubscriptionsRequest,
		OpcuaNodeIdServicesDataType_TransferSubscriptionsResponse,
		OpcuaNodeIdServicesDataType_DeleteSubscriptionsRequest,
		OpcuaNodeIdServicesDataType_DeleteSubscriptionsResponse,
		OpcuaNodeIdServicesDataType_RedundancySupport,
		OpcuaNodeIdServicesDataType_ServerState,
		OpcuaNodeIdServicesDataType_RedundantServerDataType,
		OpcuaNodeIdServicesDataType_SamplingIntervalDiagnosticsDataType,
		OpcuaNodeIdServicesDataType_ServerDiagnosticsSummaryDataType,
		OpcuaNodeIdServicesDataType_ServerStatusDataType,
		OpcuaNodeIdServicesDataType_SessionDiagnosticsDataType,
		OpcuaNodeIdServicesDataType_SessionSecurityDiagnosticsDataType,
		OpcuaNodeIdServicesDataType_ServiceCounterDataType,
		OpcuaNodeIdServicesDataType_SubscriptionDiagnosticsDataType,
		OpcuaNodeIdServicesDataType_ModelChangeStructureDataType,
		OpcuaNodeIdServicesDataType_Range,
		OpcuaNodeIdServicesDataType_EUInformation,
		OpcuaNodeIdServicesDataType_ExceptionDeviationFormat,
		OpcuaNodeIdServicesDataType_Annotation,
		OpcuaNodeIdServicesDataType_ProgramDiagnosticDataType,
		OpcuaNodeIdServicesDataType_SemanticChangeStructureDataType,
		OpcuaNodeIdServicesDataType_EventNotificationList,
		OpcuaNodeIdServicesDataType_EventFieldList,
		OpcuaNodeIdServicesDataType_HistoryEventFieldList,
		OpcuaNodeIdServicesDataType_IssuedIdentityToken,
		OpcuaNodeIdServicesDataType_NotificationData,
		OpcuaNodeIdServicesDataType_AggregateConfiguration,
		OpcuaNodeIdServicesDataType_ImageBMP,
		OpcuaNodeIdServicesDataType_ImageGIF,
		OpcuaNodeIdServicesDataType_ImageJPG,
		OpcuaNodeIdServicesDataType_ImagePNG,
		OpcuaNodeIdServicesDataType_EnumValueType,
		OpcuaNodeIdServicesDataType_TimeZoneDataType,
		OpcuaNodeIdServicesDataType_ModificationInfo,
		OpcuaNodeIdServicesDataType_HistoryModifiedData,
		OpcuaNodeIdServicesDataType_HistoryUpdateType,
		OpcuaNodeIdServicesDataType_PerformUpdateType,
		OpcuaNodeIdServicesDataType_UpdateStructureDataDetails,
		OpcuaNodeIdServicesDataType_BitFieldMaskDataType,
		OpcuaNodeIdServicesDataType_InstanceNode,
		OpcuaNodeIdServicesDataType_TypeNode,
		OpcuaNodeIdServicesDataType_OpenFileMode,
		OpcuaNodeIdServicesDataType_ModelChangeStructureVerbMask,
		OpcuaNodeIdServicesDataType_EndpointUrlListDataType,
		OpcuaNodeIdServicesDataType_NetworkGroupDataType,
		OpcuaNodeIdServicesDataType_AxisScaleEnumeration,
		OpcuaNodeIdServicesDataType_AxisInformation,
		OpcuaNodeIdServicesDataType_XVType,
		OpcuaNodeIdServicesDataType_ComplexNumberType,
		OpcuaNodeIdServicesDataType_DoubleComplexNumberType,
		OpcuaNodeIdServicesDataType_ServerOnNetwork,
		OpcuaNodeIdServicesDataType_FindServersOnNetworkRequest,
		OpcuaNodeIdServicesDataType_FindServersOnNetworkResponse,
		OpcuaNodeIdServicesDataType_RegisterServer2Request,
		OpcuaNodeIdServicesDataType_RegisterServer2Response,
		OpcuaNodeIdServicesDataType_TrustListMasks,
		OpcuaNodeIdServicesDataType_TrustListDataType,
		OpcuaNodeIdServicesDataType_OptionSet,
		OpcuaNodeIdServicesDataType_Union,
		OpcuaNodeIdServicesDataType_NormalizedString,
		OpcuaNodeIdServicesDataType_DecimalString,
		OpcuaNodeIdServicesDataType_DurationString,
		OpcuaNodeIdServicesDataType_TimeString,
		OpcuaNodeIdServicesDataType_DateString,
		OpcuaNodeIdServicesDataType_DiscoveryConfiguration,
		OpcuaNodeIdServicesDataType_MdnsDiscoveryConfiguration,
		OpcuaNodeIdServicesDataType_PublishedVariableDataType,
		OpcuaNodeIdServicesDataType_DataSetMetaDataType,
		OpcuaNodeIdServicesDataType_FieldMetaData,
		OpcuaNodeIdServicesDataType_DataTypeDescription,
		OpcuaNodeIdServicesDataType_KeyValuePair,
		OpcuaNodeIdServicesDataType_ConfigurationVersionDataType,
		OpcuaNodeIdServicesDataType_PubSubState,
		OpcuaNodeIdServicesDataType_FieldTargetDataType,
		OpcuaNodeIdServicesDataType_SimpleTypeDescription,
		OpcuaNodeIdServicesDataType_UABinaryFileDataType,
		OpcuaNodeIdServicesDataType_BrokerConnectionTransportDataType,
		OpcuaNodeIdServicesDataType_BrokerTransportQualityOfService,
		OpcuaNodeIdServicesDataType_AccessLevelType,
		OpcuaNodeIdServicesDataType_EventNotifierType,
		OpcuaNodeIdServicesDataType_AccessLevelExType,
		OpcuaNodeIdServicesDataType_WriterGroupDataType,
		OpcuaNodeIdServicesDataType_StructureDescription,
		OpcuaNodeIdServicesDataType_EnumDescription,
		OpcuaNodeIdServicesDataType_NetworkAddressDataType,
		OpcuaNodeIdServicesDataType_NetworkAddressUrlDataType,
		OpcuaNodeIdServicesDataType_ReaderGroupDataType,
		OpcuaNodeIdServicesDataType_EndpointType,
		OpcuaNodeIdServicesDataType_PubSubConfigurationDataType,
		OpcuaNodeIdServicesDataType_DatagramWriterGroupTransportDataType,
		OpcuaNodeIdServicesDataType_DataTypeSchemaHeader,
		OpcuaNodeIdServicesDataType_PublishedDataSetDataType,
		OpcuaNodeIdServicesDataType_PublishedDataSetSourceDataType,
		OpcuaNodeIdServicesDataType_PublishedDataItemsDataType,
		OpcuaNodeIdServicesDataType_PublishedEventsDataType,
		OpcuaNodeIdServicesDataType_DataSetFieldContentMask,
		OpcuaNodeIdServicesDataType_DataSetWriterDataType,
		OpcuaNodeIdServicesDataType_DataSetWriterTransportDataType,
		OpcuaNodeIdServicesDataType_DataSetWriterMessageDataType,
		OpcuaNodeIdServicesDataType_PubSubGroupDataType,
		OpcuaNodeIdServicesDataType_WriterGroupTransportDataType,
		OpcuaNodeIdServicesDataType_WriterGroupMessageDataType,
		OpcuaNodeIdServicesDataType_PubSubConnectionDataType,
		OpcuaNodeIdServicesDataType_ConnectionTransportDataType,
		OpcuaNodeIdServicesDataType_ReaderGroupTransportDataType,
		OpcuaNodeIdServicesDataType_ReaderGroupMessageDataType,
		OpcuaNodeIdServicesDataType_DataSetReaderDataType,
		OpcuaNodeIdServicesDataType_DataSetReaderTransportDataType,
		OpcuaNodeIdServicesDataType_DataSetReaderMessageDataType,
		OpcuaNodeIdServicesDataType_SubscribedDataSetDataType,
		OpcuaNodeIdServicesDataType_TargetVariablesDataType,
		OpcuaNodeIdServicesDataType_IdentityCriteriaType,
		OpcuaNodeIdServicesDataType_IdentityMappingRuleType,
		OpcuaNodeIdServicesDataType_SubscribedDataSetMirrorDataType,
		OpcuaNodeIdServicesDataType_UadpNetworkMessageContentMask,
		OpcuaNodeIdServicesDataType_UadpWriterGroupMessageDataType,
		OpcuaNodeIdServicesDataType_UadpDataSetMessageContentMask,
		OpcuaNodeIdServicesDataType_UadpDataSetWriterMessageDataType,
		OpcuaNodeIdServicesDataType_UadpDataSetReaderMessageDataType,
		OpcuaNodeIdServicesDataType_JsonNetworkMessageContentMask,
		OpcuaNodeIdServicesDataType_JsonWriterGroupMessageDataType,
		OpcuaNodeIdServicesDataType_JsonDataSetMessageContentMask,
		OpcuaNodeIdServicesDataType_JsonDataSetWriterMessageDataType,
		OpcuaNodeIdServicesDataType_JsonDataSetReaderMessageDataType,
		OpcuaNodeIdServicesDataType_BrokerWriterGroupTransportDataType,
		OpcuaNodeIdServicesDataType_BrokerDataSetWriterTransportDataType,
		OpcuaNodeIdServicesDataType_BrokerDataSetReaderTransportDataType,
		OpcuaNodeIdServicesDataType_OverrideValueHandling,
		OpcuaNodeIdServicesDataType_SessionlessInvokeRequestType,
		OpcuaNodeIdServicesDataType_DataSetFieldFlags,
		OpcuaNodeIdServicesDataType_AudioDataType,
		OpcuaNodeIdServicesDataType_AdditionalParametersType,
		OpcuaNodeIdServicesDataType_DatagramConnectionTransportDataType,
		OpcuaNodeIdServicesDataType_RsaEncryptedSecret,
		OpcuaNodeIdServicesDataType_EccEncryptedSecret,
		OpcuaNodeIdServicesDataType_EphemeralKeyType,
		OpcuaNodeIdServicesDataType_Index,
		OpcuaNodeIdServicesDataType_GenericAttributeValue,
		OpcuaNodeIdServicesDataType_GenericAttributes,
		OpcuaNodeIdServicesDataType_DecimalDataType,
		OpcuaNodeIdServicesDataType_RationalNumber,
		OpcuaNodeIdServicesDataType_Vector,
		OpcuaNodeIdServicesDataType_ThreeDVector,
		OpcuaNodeIdServicesDataType_CartesianCoordinates,
		OpcuaNodeIdServicesDataType_ThreeDCartesianCoordinates,
		OpcuaNodeIdServicesDataType_Orientation,
		OpcuaNodeIdServicesDataType_ThreeDOrientation,
		OpcuaNodeIdServicesDataType_Frame,
		OpcuaNodeIdServicesDataType_ThreeDFrame,
		OpcuaNodeIdServicesDataType_DiagnosticsLevel,
		OpcuaNodeIdServicesDataType_PubSubDiagnosticsCounterClassification,
		OpcuaNodeIdServicesDataType_DataSetOrderingType,
		OpcuaNodeIdServicesDataType_VersionTime,
		OpcuaNodeIdServicesDataType_SessionlessInvokeResponseType,
		OpcuaNodeIdServicesDataType_AliasNameDataType,
		OpcuaNodeIdServicesDataType_ReadAnnotationDataDetails,
		OpcuaNodeIdServicesDataType_CurrencyUnitType,
		OpcuaNodeIdServicesDataType_TrustListValidationOptions,
		OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetRefDataType,
		OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetDataType,
		OpcuaNodeIdServicesDataType_SecurityGroupDataType,
		OpcuaNodeIdServicesDataType_PubSubConfiguration2DataType,
		OpcuaNodeIdServicesDataType_QosDataType,
		OpcuaNodeIdServicesDataType_TransmitQosDataType,
		OpcuaNodeIdServicesDataType_TransmitQosPriorityDataType,
		OpcuaNodeIdServicesDataType_ReceiveQosDataType,
		OpcuaNodeIdServicesDataType_ReceiveQosPriorityDataType,
		OpcuaNodeIdServicesDataType_DatagramConnectionTransport2DataType,
		OpcuaNodeIdServicesDataType_DatagramWriterGroupTransport2DataType,
		OpcuaNodeIdServicesDataType_DatagramDataSetReaderTransportDataType,
		OpcuaNodeIdServicesDataType_UriString,
		OpcuaNodeIdServicesDataType_ProgramDiagnostic2DataType,
		OpcuaNodeIdServicesDataType_PortableQualifiedName,
		OpcuaNodeIdServicesDataType_PortableNodeId,
		OpcuaNodeIdServicesDataType_UnsignedRationalNumber,
		OpcuaNodeIdServicesDataType_Duplex,
		OpcuaNodeIdServicesDataType_InterfaceAdminStatus,
		OpcuaNodeIdServicesDataType_InterfaceOperStatus,
		OpcuaNodeIdServicesDataType_NegotiationStatus,
		OpcuaNodeIdServicesDataType_TsnFailureCode,
		OpcuaNodeIdServicesDataType_TsnStreamState,
		OpcuaNodeIdServicesDataType_TsnTalkerStatus,
		OpcuaNodeIdServicesDataType_TsnListenerStatus,
		OpcuaNodeIdServicesDataType_SemanticVersionString,
		OpcuaNodeIdServicesDataType_PasswordOptionsMask,
		OpcuaNodeIdServicesDataType_UserConfigurationMask,
		OpcuaNodeIdServicesDataType_UserManagementDataType,
		OpcuaNodeIdServicesDataType_PriorityMappingEntryType,
		OpcuaNodeIdServicesDataType_PublishedDataSetCustomSourceDataType,
		OpcuaNodeIdServicesDataType_PubSubKeyPushTargetDataType,
		OpcuaNodeIdServicesDataType_PubSubConfigurationRefMask,
		OpcuaNodeIdServicesDataType_PubSubConfigurationRefDataType,
		OpcuaNodeIdServicesDataType_PubSubConfigurationValueDataType,
		OpcuaNodeIdServicesDataType_EncodedTicket,
		OpcuaNodeIdServicesDataType_Handle,
		OpcuaNodeIdServicesDataType_TrimmedString,
		OpcuaNodeIdServicesDataType_AlarmMask,
		OpcuaNodeIdServicesDataType_TransactionErrorType,
		OpcuaNodeIdServicesDataType_ReferenceDescriptionDataType,
		OpcuaNodeIdServicesDataType_ReferenceListEntryDataType,
	}
}

func OpcuaNodeIdServicesDataTypeByValue(value int32) (enum OpcuaNodeIdServicesDataType, ok bool) {
	switch value {
	case 1:
		return OpcuaNodeIdServicesDataType_Boolean, true
	case 10:
		return OpcuaNodeIdServicesDataType_Float, true
	case 100:
		return OpcuaNodeIdServicesDataType_EnumDefinition, true
	case 101:
		return OpcuaNodeIdServicesDataType_StructureField, true
	case 102:
		return OpcuaNodeIdServicesDataType_EnumField, true
	case 11:
		return OpcuaNodeIdServicesDataType_Double, true
	case 11216:
		return OpcuaNodeIdServicesDataType_ModificationInfo, true
	case 11217:
		return OpcuaNodeIdServicesDataType_HistoryModifiedData, true
	case 11234:
		return OpcuaNodeIdServicesDataType_HistoryUpdateType, true
	case 11293:
		return OpcuaNodeIdServicesDataType_PerformUpdateType, true
	case 11295:
		return OpcuaNodeIdServicesDataType_UpdateStructureDataDetails, true
	case 11737:
		return OpcuaNodeIdServicesDataType_BitFieldMaskDataType, true
	case 11879:
		return OpcuaNodeIdServicesDataType_InstanceNode, true
	case 11880:
		return OpcuaNodeIdServicesDataType_TypeNode, true
	case 11939:
		return OpcuaNodeIdServicesDataType_OpenFileMode, true
	case 11941:
		return OpcuaNodeIdServicesDataType_ModelChangeStructureVerbMask, true
	case 11943:
		return OpcuaNodeIdServicesDataType_EndpointUrlListDataType, true
	case 11944:
		return OpcuaNodeIdServicesDataType_NetworkGroupDataType, true
	case 12:
		return OpcuaNodeIdServicesDataType_String, true
	case 120:
		return OpcuaNodeIdServicesDataType_NamingRuleType, true
	case 12077:
		return OpcuaNodeIdServicesDataType_AxisScaleEnumeration, true
	case 12079:
		return OpcuaNodeIdServicesDataType_AxisInformation, true
	case 12080:
		return OpcuaNodeIdServicesDataType_XVType, true
	case 12171:
		return OpcuaNodeIdServicesDataType_ComplexNumberType, true
	case 12172:
		return OpcuaNodeIdServicesDataType_DoubleComplexNumberType, true
	case 12189:
		return OpcuaNodeIdServicesDataType_ServerOnNetwork, true
	case 12190:
		return OpcuaNodeIdServicesDataType_FindServersOnNetworkRequest, true
	case 12191:
		return OpcuaNodeIdServicesDataType_FindServersOnNetworkResponse, true
	case 12193:
		return OpcuaNodeIdServicesDataType_RegisterServer2Request, true
	case 12194:
		return OpcuaNodeIdServicesDataType_RegisterServer2Response, true
	case 12552:
		return OpcuaNodeIdServicesDataType_TrustListMasks, true
	case 12554:
		return OpcuaNodeIdServicesDataType_TrustListDataType, true
	case 12755:
		return OpcuaNodeIdServicesDataType_OptionSet, true
	case 12756:
		return OpcuaNodeIdServicesDataType_Union, true
	case 12877:
		return OpcuaNodeIdServicesDataType_NormalizedString, true
	case 12878:
		return OpcuaNodeIdServicesDataType_DecimalString, true
	case 12879:
		return OpcuaNodeIdServicesDataType_DurationString, true
	case 12880:
		return OpcuaNodeIdServicesDataType_TimeString, true
	case 12881:
		return OpcuaNodeIdServicesDataType_DateString, true
	case 12890:
		return OpcuaNodeIdServicesDataType_DiscoveryConfiguration, true
	case 12891:
		return OpcuaNodeIdServicesDataType_MdnsDiscoveryConfiguration, true
	case 13:
		return OpcuaNodeIdServicesDataType_DateTime, true
	case 14:
		return OpcuaNodeIdServicesDataType_Guid, true
	case 14273:
		return OpcuaNodeIdServicesDataType_PublishedVariableDataType, true
	case 14523:
		return OpcuaNodeIdServicesDataType_DataSetMetaDataType, true
	case 14524:
		return OpcuaNodeIdServicesDataType_FieldMetaData, true
	case 14525:
		return OpcuaNodeIdServicesDataType_DataTypeDescription, true
	case 14533:
		return OpcuaNodeIdServicesDataType_KeyValuePair, true
	case 14593:
		return OpcuaNodeIdServicesDataType_ConfigurationVersionDataType, true
	case 14647:
		return OpcuaNodeIdServicesDataType_PubSubState, true
	case 14744:
		return OpcuaNodeIdServicesDataType_FieldTargetDataType, true
	case 15:
		return OpcuaNodeIdServicesDataType_ByteString, true
	case 15005:
		return OpcuaNodeIdServicesDataType_SimpleTypeDescription, true
	case 15006:
		return OpcuaNodeIdServicesDataType_UABinaryFileDataType, true
	case 15007:
		return OpcuaNodeIdServicesDataType_BrokerConnectionTransportDataType, true
	case 15008:
		return OpcuaNodeIdServicesDataType_BrokerTransportQualityOfService, true
	case 15031:
		return OpcuaNodeIdServicesDataType_AccessLevelType, true
	case 15033:
		return OpcuaNodeIdServicesDataType_EventNotifierType, true
	case 15406:
		return OpcuaNodeIdServicesDataType_AccessLevelExType, true
	case 15480:
		return OpcuaNodeIdServicesDataType_WriterGroupDataType, true
	case 15487:
		return OpcuaNodeIdServicesDataType_StructureDescription, true
	case 15488:
		return OpcuaNodeIdServicesDataType_EnumDescription, true
	case 15502:
		return OpcuaNodeIdServicesDataType_NetworkAddressDataType, true
	case 15510:
		return OpcuaNodeIdServicesDataType_NetworkAddressUrlDataType, true
	case 15520:
		return OpcuaNodeIdServicesDataType_ReaderGroupDataType, true
	case 15528:
		return OpcuaNodeIdServicesDataType_EndpointType, true
	case 15530:
		return OpcuaNodeIdServicesDataType_PubSubConfigurationDataType, true
	case 15532:
		return OpcuaNodeIdServicesDataType_DatagramWriterGroupTransportDataType, true
	case 15534:
		return OpcuaNodeIdServicesDataType_DataTypeSchemaHeader, true
	case 15578:
		return OpcuaNodeIdServicesDataType_PublishedDataSetDataType, true
	case 15580:
		return OpcuaNodeIdServicesDataType_PublishedDataSetSourceDataType, true
	case 15581:
		return OpcuaNodeIdServicesDataType_PublishedDataItemsDataType, true
	case 15582:
		return OpcuaNodeIdServicesDataType_PublishedEventsDataType, true
	case 15583:
		return OpcuaNodeIdServicesDataType_DataSetFieldContentMask, true
	case 15597:
		return OpcuaNodeIdServicesDataType_DataSetWriterDataType, true
	case 15598:
		return OpcuaNodeIdServicesDataType_DataSetWriterTransportDataType, true
	case 15605:
		return OpcuaNodeIdServicesDataType_DataSetWriterMessageDataType, true
	case 15609:
		return OpcuaNodeIdServicesDataType_PubSubGroupDataType, true
	case 15611:
		return OpcuaNodeIdServicesDataType_WriterGroupTransportDataType, true
	case 15616:
		return OpcuaNodeIdServicesDataType_WriterGroupMessageDataType, true
	case 15617:
		return OpcuaNodeIdServicesDataType_PubSubConnectionDataType, true
	case 15618:
		return OpcuaNodeIdServicesDataType_ConnectionTransportDataType, true
	case 15621:
		return OpcuaNodeIdServicesDataType_ReaderGroupTransportDataType, true
	case 15622:
		return OpcuaNodeIdServicesDataType_ReaderGroupMessageDataType, true
	case 15623:
		return OpcuaNodeIdServicesDataType_DataSetReaderDataType, true
	case 15628:
		return OpcuaNodeIdServicesDataType_DataSetReaderTransportDataType, true
	case 15629:
		return OpcuaNodeIdServicesDataType_DataSetReaderMessageDataType, true
	case 15630:
		return OpcuaNodeIdServicesDataType_SubscribedDataSetDataType, true
	case 15631:
		return OpcuaNodeIdServicesDataType_TargetVariablesDataType, true
	case 15632:
		return OpcuaNodeIdServicesDataType_IdentityCriteriaType, true
	case 15634:
		return OpcuaNodeIdServicesDataType_IdentityMappingRuleType, true
	case 15635:
		return OpcuaNodeIdServicesDataType_SubscribedDataSetMirrorDataType, true
	case 15642:
		return OpcuaNodeIdServicesDataType_UadpNetworkMessageContentMask, true
	case 15645:
		return OpcuaNodeIdServicesDataType_UadpWriterGroupMessageDataType, true
	case 15646:
		return OpcuaNodeIdServicesDataType_UadpDataSetMessageContentMask, true
	case 15652:
		return OpcuaNodeIdServicesDataType_UadpDataSetWriterMessageDataType, true
	case 15653:
		return OpcuaNodeIdServicesDataType_UadpDataSetReaderMessageDataType, true
	case 15654:
		return OpcuaNodeIdServicesDataType_JsonNetworkMessageContentMask, true
	case 15657:
		return OpcuaNodeIdServicesDataType_JsonWriterGroupMessageDataType, true
	case 15658:
		return OpcuaNodeIdServicesDataType_JsonDataSetMessageContentMask, true
	case 15664:
		return OpcuaNodeIdServicesDataType_JsonDataSetWriterMessageDataType, true
	case 15665:
		return OpcuaNodeIdServicesDataType_JsonDataSetReaderMessageDataType, true
	case 15667:
		return OpcuaNodeIdServicesDataType_BrokerWriterGroupTransportDataType, true
	case 15669:
		return OpcuaNodeIdServicesDataType_BrokerDataSetWriterTransportDataType, true
	case 15670:
		return OpcuaNodeIdServicesDataType_BrokerDataSetReaderTransportDataType, true
	case 15874:
		return OpcuaNodeIdServicesDataType_OverrideValueHandling, true
	case 15901:
		return OpcuaNodeIdServicesDataType_SessionlessInvokeRequestType, true
	case 15904:
		return OpcuaNodeIdServicesDataType_DataSetFieldFlags, true
	case 16:
		return OpcuaNodeIdServicesDataType_XmlElement, true
	case 16307:
		return OpcuaNodeIdServicesDataType_AudioDataType, true
	case 16313:
		return OpcuaNodeIdServicesDataType_AdditionalParametersType, true
	case 17:
		return OpcuaNodeIdServicesDataType_NodeId, true
	case 17467:
		return OpcuaNodeIdServicesDataType_DatagramConnectionTransportDataType, true
	case 17545:
		return OpcuaNodeIdServicesDataType_RsaEncryptedSecret, true
	case 17546:
		return OpcuaNodeIdServicesDataType_EccEncryptedSecret, true
	case 17548:
		return OpcuaNodeIdServicesDataType_EphemeralKeyType, true
	case 17588:
		return OpcuaNodeIdServicesDataType_Index, true
	case 17606:
		return OpcuaNodeIdServicesDataType_GenericAttributeValue, true
	case 17607:
		return OpcuaNodeIdServicesDataType_GenericAttributes, true
	case 17861:
		return OpcuaNodeIdServicesDataType_DecimalDataType, true
	case 18:
		return OpcuaNodeIdServicesDataType_ExpandedNodeId, true
	case 18806:
		return OpcuaNodeIdServicesDataType_RationalNumber, true
	case 18807:
		return OpcuaNodeIdServicesDataType_Vector, true
	case 18808:
		return OpcuaNodeIdServicesDataType_ThreeDVector, true
	case 18809:
		return OpcuaNodeIdServicesDataType_CartesianCoordinates, true
	case 18810:
		return OpcuaNodeIdServicesDataType_ThreeDCartesianCoordinates, true
	case 18811:
		return OpcuaNodeIdServicesDataType_Orientation, true
	case 18812:
		return OpcuaNodeIdServicesDataType_ThreeDOrientation, true
	case 18813:
		return OpcuaNodeIdServicesDataType_Frame, true
	case 18814:
		return OpcuaNodeIdServicesDataType_ThreeDFrame, true
	case 19:
		return OpcuaNodeIdServicesDataType_StatusCode, true
	case 19723:
		return OpcuaNodeIdServicesDataType_DiagnosticsLevel, true
	case 19730:
		return OpcuaNodeIdServicesDataType_PubSubDiagnosticsCounterClassification, true
	case 2:
		return OpcuaNodeIdServicesDataType_SByte, true
	case 20:
		return OpcuaNodeIdServicesDataType_QualifiedName, true
	case 2000:
		return OpcuaNodeIdServicesDataType_ImageBMP, true
	case 2001:
		return OpcuaNodeIdServicesDataType_ImageGIF, true
	case 2002:
		return OpcuaNodeIdServicesDataType_ImageJPG, true
	case 2003:
		return OpcuaNodeIdServicesDataType_ImagePNG, true
	case 20408:
		return OpcuaNodeIdServicesDataType_DataSetOrderingType, true
	case 20998:
		return OpcuaNodeIdServicesDataType_VersionTime, true
	case 20999:
		return OpcuaNodeIdServicesDataType_SessionlessInvokeResponseType, true
	case 21:
		return OpcuaNodeIdServicesDataType_LocalizedText, true
	case 22:
		return OpcuaNodeIdServicesDataType_Structure, true
	case 23:
		return OpcuaNodeIdServicesDataType_DataValue, true
	case 23468:
		return OpcuaNodeIdServicesDataType_AliasNameDataType, true
	case 23497:
		return OpcuaNodeIdServicesDataType_ReadAnnotationDataDetails, true
	case 23498:
		return OpcuaNodeIdServicesDataType_CurrencyUnitType, true
	case 23564:
		return OpcuaNodeIdServicesDataType_TrustListValidationOptions, true
	case 23599:
		return OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetRefDataType, true
	case 23600:
		return OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetDataType, true
	case 23601:
		return OpcuaNodeIdServicesDataType_SecurityGroupDataType, true
	case 23602:
		return OpcuaNodeIdServicesDataType_PubSubConfiguration2DataType, true
	case 23603:
		return OpcuaNodeIdServicesDataType_QosDataType, true
	case 23604:
		return OpcuaNodeIdServicesDataType_TransmitQosDataType, true
	case 23605:
		return OpcuaNodeIdServicesDataType_TransmitQosPriorityDataType, true
	case 23608:
		return OpcuaNodeIdServicesDataType_ReceiveQosDataType, true
	case 23609:
		return OpcuaNodeIdServicesDataType_ReceiveQosPriorityDataType, true
	case 23612:
		return OpcuaNodeIdServicesDataType_DatagramConnectionTransport2DataType, true
	case 23613:
		return OpcuaNodeIdServicesDataType_DatagramWriterGroupTransport2DataType, true
	case 23614:
		return OpcuaNodeIdServicesDataType_DatagramDataSetReaderTransportDataType, true
	case 23751:
		return OpcuaNodeIdServicesDataType_UriString, true
	case 24:
		return OpcuaNodeIdServicesDataType_BaseDataType, true
	case 24033:
		return OpcuaNodeIdServicesDataType_ProgramDiagnostic2DataType, true
	case 24105:
		return OpcuaNodeIdServicesDataType_PortableQualifiedName, true
	case 24106:
		return OpcuaNodeIdServicesDataType_PortableNodeId, true
	case 24107:
		return OpcuaNodeIdServicesDataType_UnsignedRationalNumber, true
	case 24210:
		return OpcuaNodeIdServicesDataType_Duplex, true
	case 24212:
		return OpcuaNodeIdServicesDataType_InterfaceAdminStatus, true
	case 24214:
		return OpcuaNodeIdServicesDataType_InterfaceOperStatus, true
	case 24216:
		return OpcuaNodeIdServicesDataType_NegotiationStatus, true
	case 24218:
		return OpcuaNodeIdServicesDataType_TsnFailureCode, true
	case 24220:
		return OpcuaNodeIdServicesDataType_TsnStreamState, true
	case 24222:
		return OpcuaNodeIdServicesDataType_TsnTalkerStatus, true
	case 24224:
		return OpcuaNodeIdServicesDataType_TsnListenerStatus, true
	case 24263:
		return OpcuaNodeIdServicesDataType_SemanticVersionString, true
	case 24277:
		return OpcuaNodeIdServicesDataType_PasswordOptionsMask, true
	case 24279:
		return OpcuaNodeIdServicesDataType_UserConfigurationMask, true
	case 24281:
		return OpcuaNodeIdServicesDataType_UserManagementDataType, true
	case 25:
		return OpcuaNodeIdServicesDataType_DiagnosticInfo, true
	case 25220:
		return OpcuaNodeIdServicesDataType_PriorityMappingEntryType, true
	case 25269:
		return OpcuaNodeIdServicesDataType_PublishedDataSetCustomSourceDataType, true
	case 25270:
		return OpcuaNodeIdServicesDataType_PubSubKeyPushTargetDataType, true
	case 25517:
		return OpcuaNodeIdServicesDataType_PubSubConfigurationRefMask, true
	case 25519:
		return OpcuaNodeIdServicesDataType_PubSubConfigurationRefDataType, true
	case 25520:
		return OpcuaNodeIdServicesDataType_PubSubConfigurationValueDataType, true
	case 256:
		return OpcuaNodeIdServicesDataType_IdType, true
	case 257:
		return OpcuaNodeIdServicesDataType_NodeClass, true
	case 25726:
		return OpcuaNodeIdServicesDataType_EncodedTicket, true
	case 258:
		return OpcuaNodeIdServicesDataType_Node, true
	case 26:
		return OpcuaNodeIdServicesDataType_Number, true
	case 261:
		return OpcuaNodeIdServicesDataType_ObjectNode, true
	case 264:
		return OpcuaNodeIdServicesDataType_ObjectTypeNode, true
	case 267:
		return OpcuaNodeIdServicesDataType_VariableNode, true
	case 27:
		return OpcuaNodeIdServicesDataType_Integer, true
	case 270:
		return OpcuaNodeIdServicesDataType_VariableTypeNode, true
	case 273:
		return OpcuaNodeIdServicesDataType_ReferenceTypeNode, true
	case 276:
		return OpcuaNodeIdServicesDataType_MethodNode, true
	case 279:
		return OpcuaNodeIdServicesDataType_ViewNode, true
	case 28:
		return OpcuaNodeIdServicesDataType_UInteger, true
	case 282:
		return OpcuaNodeIdServicesDataType_DataTypeNode, true
	case 285:
		return OpcuaNodeIdServicesDataType_ReferenceNode, true
	case 288:
		return OpcuaNodeIdServicesDataType_IntegerId, true
	case 289:
		return OpcuaNodeIdServicesDataType_Counter, true
	case 29:
		return OpcuaNodeIdServicesDataType_Enumeration, true
	case 290:
		return OpcuaNodeIdServicesDataType_Duration, true
	case 291:
		return OpcuaNodeIdServicesDataType_NumericRange, true
	case 294:
		return OpcuaNodeIdServicesDataType_UtcTime, true
	case 295:
		return OpcuaNodeIdServicesDataType_LocaleId, true
	case 296:
		return OpcuaNodeIdServicesDataType_Argument, true
	case 299:
		return OpcuaNodeIdServicesDataType_StatusResult, true
	case 3:
		return OpcuaNodeIdServicesDataType_Byte, true
	case 30:
		return OpcuaNodeIdServicesDataType_Image, true
	case 302:
		return OpcuaNodeIdServicesDataType_MessageSecurityMode, true
	case 303:
		return OpcuaNodeIdServicesDataType_UserTokenType, true
	case 304:
		return OpcuaNodeIdServicesDataType_UserTokenPolicy, true
	case 307:
		return OpcuaNodeIdServicesDataType_ApplicationType, true
	case 308:
		return OpcuaNodeIdServicesDataType_ApplicationDescription, true
	case 311:
		return OpcuaNodeIdServicesDataType_ApplicationInstanceCertificate, true
	case 312:
		return OpcuaNodeIdServicesDataType_EndpointDescription, true
	case 315:
		return OpcuaNodeIdServicesDataType_SecurityTokenRequestType, true
	case 316:
		return OpcuaNodeIdServicesDataType_UserIdentityToken, true
	case 319:
		return OpcuaNodeIdServicesDataType_AnonymousIdentityToken, true
	case 31917:
		return OpcuaNodeIdServicesDataType_Handle, true
	case 31918:
		return OpcuaNodeIdServicesDataType_TrimmedString, true
	case 322:
		return OpcuaNodeIdServicesDataType_UserNameIdentityToken, true
	case 32251:
		return OpcuaNodeIdServicesDataType_AlarmMask, true
	case 32285:
		return OpcuaNodeIdServicesDataType_TransactionErrorType, true
	case 325:
		return OpcuaNodeIdServicesDataType_X509IdentityToken, true
	case 32659:
		return OpcuaNodeIdServicesDataType_ReferenceDescriptionDataType, true
	case 32660:
		return OpcuaNodeIdServicesDataType_ReferenceListEntryDataType, true
	case 331:
		return OpcuaNodeIdServicesDataType_EndpointConfiguration, true
	case 338:
		return OpcuaNodeIdServicesDataType_BuildInfo, true
	case 344:
		return OpcuaNodeIdServicesDataType_SignedSoftwareCertificate, true
	case 347:
		return OpcuaNodeIdServicesDataType_AttributeWriteMask, true
	case 348:
		return OpcuaNodeIdServicesDataType_NodeAttributesMask, true
	case 349:
		return OpcuaNodeIdServicesDataType_NodeAttributes, true
	case 352:
		return OpcuaNodeIdServicesDataType_ObjectAttributes, true
	case 355:
		return OpcuaNodeIdServicesDataType_VariableAttributes, true
	case 358:
		return OpcuaNodeIdServicesDataType_MethodAttributes, true
	case 361:
		return OpcuaNodeIdServicesDataType_ObjectTypeAttributes, true
	case 364:
		return OpcuaNodeIdServicesDataType_VariableTypeAttributes, true
	case 367:
		return OpcuaNodeIdServicesDataType_ReferenceTypeAttributes, true
	case 370:
		return OpcuaNodeIdServicesDataType_DataTypeAttributes, true
	case 373:
		return OpcuaNodeIdServicesDataType_ViewAttributes, true
	case 376:
		return OpcuaNodeIdServicesDataType_AddNodesItem, true
	case 379:
		return OpcuaNodeIdServicesDataType_AddReferencesItem, true
	case 382:
		return OpcuaNodeIdServicesDataType_DeleteNodesItem, true
	case 385:
		return OpcuaNodeIdServicesDataType_DeleteReferencesItem, true
	case 388:
		return OpcuaNodeIdServicesDataType_SessionAuthenticationToken, true
	case 389:
		return OpcuaNodeIdServicesDataType_RequestHeader, true
	case 392:
		return OpcuaNodeIdServicesDataType_ResponseHeader, true
	case 395:
		return OpcuaNodeIdServicesDataType_ServiceFault, true
	case 4:
		return OpcuaNodeIdServicesDataType_Int16, true
	case 420:
		return OpcuaNodeIdServicesDataType_FindServersRequest, true
	case 423:
		return OpcuaNodeIdServicesDataType_FindServersResponse, true
	case 426:
		return OpcuaNodeIdServicesDataType_GetEndpointsRequest, true
	case 429:
		return OpcuaNodeIdServicesDataType_GetEndpointsResponse, true
	case 432:
		return OpcuaNodeIdServicesDataType_RegisteredServer, true
	case 435:
		return OpcuaNodeIdServicesDataType_RegisterServerRequest, true
	case 438:
		return OpcuaNodeIdServicesDataType_RegisterServerResponse, true
	case 441:
		return OpcuaNodeIdServicesDataType_ChannelSecurityToken, true
	case 444:
		return OpcuaNodeIdServicesDataType_OpenSecureChannelRequest, true
	case 447:
		return OpcuaNodeIdServicesDataType_OpenSecureChannelResponse, true
	case 450:
		return OpcuaNodeIdServicesDataType_CloseSecureChannelRequest, true
	case 453:
		return OpcuaNodeIdServicesDataType_CloseSecureChannelResponse, true
	case 456:
		return OpcuaNodeIdServicesDataType_SignatureData, true
	case 459:
		return OpcuaNodeIdServicesDataType_CreateSessionRequest, true
	case 462:
		return OpcuaNodeIdServicesDataType_CreateSessionResponse, true
	case 465:
		return OpcuaNodeIdServicesDataType_ActivateSessionRequest, true
	case 468:
		return OpcuaNodeIdServicesDataType_ActivateSessionResponse, true
	case 471:
		return OpcuaNodeIdServicesDataType_CloseSessionRequest, true
	case 474:
		return OpcuaNodeIdServicesDataType_CloseSessionResponse, true
	case 477:
		return OpcuaNodeIdServicesDataType_CancelRequest, true
	case 480:
		return OpcuaNodeIdServicesDataType_CancelResponse, true
	case 483:
		return OpcuaNodeIdServicesDataType_AddNodesResult, true
	case 486:
		return OpcuaNodeIdServicesDataType_AddNodesRequest, true
	case 489:
		return OpcuaNodeIdServicesDataType_AddNodesResponse, true
	case 492:
		return OpcuaNodeIdServicesDataType_AddReferencesRequest, true
	case 495:
		return OpcuaNodeIdServicesDataType_AddReferencesResponse, true
	case 498:
		return OpcuaNodeIdServicesDataType_DeleteNodesRequest, true
	case 5:
		return OpcuaNodeIdServicesDataType_UInt16, true
	case 50:
		return OpcuaNodeIdServicesDataType_Decimal, true
	case 501:
		return OpcuaNodeIdServicesDataType_DeleteNodesResponse, true
	case 504:
		return OpcuaNodeIdServicesDataType_DeleteReferencesRequest, true
	case 507:
		return OpcuaNodeIdServicesDataType_DeleteReferencesResponse, true
	case 510:
		return OpcuaNodeIdServicesDataType_BrowseDirection, true
	case 511:
		return OpcuaNodeIdServicesDataType_ViewDescription, true
	case 514:
		return OpcuaNodeIdServicesDataType_BrowseDescription, true
	case 517:
		return OpcuaNodeIdServicesDataType_BrowseResultMask, true
	case 518:
		return OpcuaNodeIdServicesDataType_ReferenceDescription, true
	case 521:
		return OpcuaNodeIdServicesDataType_ContinuationPoint, true
	case 522:
		return OpcuaNodeIdServicesDataType_BrowseResult, true
	case 525:
		return OpcuaNodeIdServicesDataType_BrowseRequest, true
	case 528:
		return OpcuaNodeIdServicesDataType_BrowseResponse, true
	case 531:
		return OpcuaNodeIdServicesDataType_BrowseNextRequest, true
	case 534:
		return OpcuaNodeIdServicesDataType_BrowseNextResponse, true
	case 537:
		return OpcuaNodeIdServicesDataType_RelativePathElement, true
	case 540:
		return OpcuaNodeIdServicesDataType_RelativePath, true
	case 543:
		return OpcuaNodeIdServicesDataType_BrowsePath, true
	case 546:
		return OpcuaNodeIdServicesDataType_BrowsePathTarget, true
	case 549:
		return OpcuaNodeIdServicesDataType_BrowsePathResult, true
	case 552:
		return OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsRequest, true
	case 555:
		return OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsResponse, true
	case 558:
		return OpcuaNodeIdServicesDataType_RegisterNodesRequest, true
	case 561:
		return OpcuaNodeIdServicesDataType_RegisterNodesResponse, true
	case 564:
		return OpcuaNodeIdServicesDataType_UnregisterNodesRequest, true
	case 567:
		return OpcuaNodeIdServicesDataType_UnregisterNodesResponse, true
	case 570:
		return OpcuaNodeIdServicesDataType_QueryDataDescription, true
	case 573:
		return OpcuaNodeIdServicesDataType_NodeTypeDescription, true
	case 576:
		return OpcuaNodeIdServicesDataType_FilterOperator, true
	case 577:
		return OpcuaNodeIdServicesDataType_QueryDataSet, true
	case 580:
		return OpcuaNodeIdServicesDataType_NodeReference, true
	case 583:
		return OpcuaNodeIdServicesDataType_ContentFilterElement, true
	case 586:
		return OpcuaNodeIdServicesDataType_ContentFilter, true
	case 589:
		return OpcuaNodeIdServicesDataType_FilterOperand, true
	case 592:
		return OpcuaNodeIdServicesDataType_ElementOperand, true
	case 595:
		return OpcuaNodeIdServicesDataType_LiteralOperand, true
	case 598:
		return OpcuaNodeIdServicesDataType_AttributeOperand, true
	case 6:
		return OpcuaNodeIdServicesDataType_Int32, true
	case 601:
		return OpcuaNodeIdServicesDataType_SimpleAttributeOperand, true
	case 604:
		return OpcuaNodeIdServicesDataType_ContentFilterElementResult, true
	case 607:
		return OpcuaNodeIdServicesDataType_ContentFilterResult, true
	case 610:
		return OpcuaNodeIdServicesDataType_ParsingResult, true
	case 613:
		return OpcuaNodeIdServicesDataType_QueryFirstRequest, true
	case 616:
		return OpcuaNodeIdServicesDataType_QueryFirstResponse, true
	case 619:
		return OpcuaNodeIdServicesDataType_QueryNextRequest, true
	case 622:
		return OpcuaNodeIdServicesDataType_QueryNextResponse, true
	case 625:
		return OpcuaNodeIdServicesDataType_TimestampsToReturn, true
	case 626:
		return OpcuaNodeIdServicesDataType_ReadValueId, true
	case 629:
		return OpcuaNodeIdServicesDataType_ReadRequest, true
	case 632:
		return OpcuaNodeIdServicesDataType_ReadResponse, true
	case 635:
		return OpcuaNodeIdServicesDataType_HistoryReadValueId, true
	case 638:
		return OpcuaNodeIdServicesDataType_HistoryReadResult, true
	case 641:
		return OpcuaNodeIdServicesDataType_HistoryReadDetails, true
	case 644:
		return OpcuaNodeIdServicesDataType_ReadEventDetails, true
	case 647:
		return OpcuaNodeIdServicesDataType_ReadRawModifiedDetails, true
	case 650:
		return OpcuaNodeIdServicesDataType_ReadProcessedDetails, true
	case 653:
		return OpcuaNodeIdServicesDataType_ReadAtTimeDetails, true
	case 656:
		return OpcuaNodeIdServicesDataType_HistoryData, true
	case 659:
		return OpcuaNodeIdServicesDataType_HistoryEvent, true
	case 662:
		return OpcuaNodeIdServicesDataType_HistoryReadRequest, true
	case 665:
		return OpcuaNodeIdServicesDataType_HistoryReadResponse, true
	case 668:
		return OpcuaNodeIdServicesDataType_WriteValue, true
	case 671:
		return OpcuaNodeIdServicesDataType_WriteRequest, true
	case 674:
		return OpcuaNodeIdServicesDataType_WriteResponse, true
	case 677:
		return OpcuaNodeIdServicesDataType_HistoryUpdateDetails, true
	case 680:
		return OpcuaNodeIdServicesDataType_UpdateDataDetails, true
	case 683:
		return OpcuaNodeIdServicesDataType_UpdateEventDetails, true
	case 686:
		return OpcuaNodeIdServicesDataType_DeleteRawModifiedDetails, true
	case 689:
		return OpcuaNodeIdServicesDataType_DeleteAtTimeDetails, true
	case 692:
		return OpcuaNodeIdServicesDataType_DeleteEventDetails, true
	case 695:
		return OpcuaNodeIdServicesDataType_HistoryUpdateResult, true
	case 698:
		return OpcuaNodeIdServicesDataType_HistoryUpdateRequest, true
	case 7:
		return OpcuaNodeIdServicesDataType_UInt32, true
	case 701:
		return OpcuaNodeIdServicesDataType_HistoryUpdateResponse, true
	case 704:
		return OpcuaNodeIdServicesDataType_CallMethodRequest, true
	case 707:
		return OpcuaNodeIdServicesDataType_CallMethodResult, true
	case 710:
		return OpcuaNodeIdServicesDataType_CallRequest, true
	case 713:
		return OpcuaNodeIdServicesDataType_CallResponse, true
	case 716:
		return OpcuaNodeIdServicesDataType_MonitoringMode, true
	case 717:
		return OpcuaNodeIdServicesDataType_DataChangeTrigger, true
	case 718:
		return OpcuaNodeIdServicesDataType_DeadbandType, true
	case 719:
		return OpcuaNodeIdServicesDataType_MonitoringFilter, true
	case 722:
		return OpcuaNodeIdServicesDataType_DataChangeFilter, true
	case 725:
		return OpcuaNodeIdServicesDataType_EventFilter, true
	case 728:
		return OpcuaNodeIdServicesDataType_AggregateFilter, true
	case 731:
		return OpcuaNodeIdServicesDataType_MonitoringFilterResult, true
	case 734:
		return OpcuaNodeIdServicesDataType_EventFilterResult, true
	case 737:
		return OpcuaNodeIdServicesDataType_AggregateFilterResult, true
	case 740:
		return OpcuaNodeIdServicesDataType_MonitoringParameters, true
	case 743:
		return OpcuaNodeIdServicesDataType_MonitoredItemCreateRequest, true
	case 746:
		return OpcuaNodeIdServicesDataType_MonitoredItemCreateResult, true
	case 749:
		return OpcuaNodeIdServicesDataType_CreateMonitoredItemsRequest, true
	case 752:
		return OpcuaNodeIdServicesDataType_CreateMonitoredItemsResponse, true
	case 755:
		return OpcuaNodeIdServicesDataType_MonitoredItemModifyRequest, true
	case 758:
		return OpcuaNodeIdServicesDataType_MonitoredItemModifyResult, true
	case 7594:
		return OpcuaNodeIdServicesDataType_EnumValueType, true
	case 761:
		return OpcuaNodeIdServicesDataType_ModifyMonitoredItemsRequest, true
	case 764:
		return OpcuaNodeIdServicesDataType_ModifyMonitoredItemsResponse, true
	case 767:
		return OpcuaNodeIdServicesDataType_SetMonitoringModeRequest, true
	case 770:
		return OpcuaNodeIdServicesDataType_SetMonitoringModeResponse, true
	case 773:
		return OpcuaNodeIdServicesDataType_SetTriggeringRequest, true
	case 776:
		return OpcuaNodeIdServicesDataType_SetTriggeringResponse, true
	case 779:
		return OpcuaNodeIdServicesDataType_DeleteMonitoredItemsRequest, true
	case 782:
		return OpcuaNodeIdServicesDataType_DeleteMonitoredItemsResponse, true
	case 785:
		return OpcuaNodeIdServicesDataType_CreateSubscriptionRequest, true
	case 788:
		return OpcuaNodeIdServicesDataType_CreateSubscriptionResponse, true
	case 791:
		return OpcuaNodeIdServicesDataType_ModifySubscriptionRequest, true
	case 794:
		return OpcuaNodeIdServicesDataType_ModifySubscriptionResponse, true
	case 797:
		return OpcuaNodeIdServicesDataType_SetPublishingModeRequest, true
	case 8:
		return OpcuaNodeIdServicesDataType_Int64, true
	case 800:
		return OpcuaNodeIdServicesDataType_SetPublishingModeResponse, true
	case 803:
		return OpcuaNodeIdServicesDataType_NotificationMessage, true
	case 806:
		return OpcuaNodeIdServicesDataType_MonitoredItemNotification, true
	case 809:
		return OpcuaNodeIdServicesDataType_DataChangeNotification, true
	case 818:
		return OpcuaNodeIdServicesDataType_StatusChangeNotification, true
	case 821:
		return OpcuaNodeIdServicesDataType_SubscriptionAcknowledgement, true
	case 824:
		return OpcuaNodeIdServicesDataType_PublishRequest, true
	case 827:
		return OpcuaNodeIdServicesDataType_PublishResponse, true
	case 830:
		return OpcuaNodeIdServicesDataType_RepublishRequest, true
	case 833:
		return OpcuaNodeIdServicesDataType_RepublishResponse, true
	case 836:
		return OpcuaNodeIdServicesDataType_TransferResult, true
	case 839:
		return OpcuaNodeIdServicesDataType_TransferSubscriptionsRequest, true
	case 842:
		return OpcuaNodeIdServicesDataType_TransferSubscriptionsResponse, true
	case 845:
		return OpcuaNodeIdServicesDataType_DeleteSubscriptionsRequest, true
	case 848:
		return OpcuaNodeIdServicesDataType_DeleteSubscriptionsResponse, true
	case 851:
		return OpcuaNodeIdServicesDataType_RedundancySupport, true
	case 852:
		return OpcuaNodeIdServicesDataType_ServerState, true
	case 853:
		return OpcuaNodeIdServicesDataType_RedundantServerDataType, true
	case 856:
		return OpcuaNodeIdServicesDataType_SamplingIntervalDiagnosticsDataType, true
	case 859:
		return OpcuaNodeIdServicesDataType_ServerDiagnosticsSummaryDataType, true
	case 862:
		return OpcuaNodeIdServicesDataType_ServerStatusDataType, true
	case 865:
		return OpcuaNodeIdServicesDataType_SessionDiagnosticsDataType, true
	case 868:
		return OpcuaNodeIdServicesDataType_SessionSecurityDiagnosticsDataType, true
	case 871:
		return OpcuaNodeIdServicesDataType_ServiceCounterDataType, true
	case 874:
		return OpcuaNodeIdServicesDataType_SubscriptionDiagnosticsDataType, true
	case 877:
		return OpcuaNodeIdServicesDataType_ModelChangeStructureDataType, true
	case 884:
		return OpcuaNodeIdServicesDataType_Range, true
	case 887:
		return OpcuaNodeIdServicesDataType_EUInformation, true
	case 890:
		return OpcuaNodeIdServicesDataType_ExceptionDeviationFormat, true
	case 891:
		return OpcuaNodeIdServicesDataType_Annotation, true
	case 8912:
		return OpcuaNodeIdServicesDataType_TimeZoneDataType, true
	case 894:
		return OpcuaNodeIdServicesDataType_ProgramDiagnosticDataType, true
	case 897:
		return OpcuaNodeIdServicesDataType_SemanticChangeStructureDataType, true
	case 9:
		return OpcuaNodeIdServicesDataType_UInt64, true
	case 914:
		return OpcuaNodeIdServicesDataType_EventNotificationList, true
	case 917:
		return OpcuaNodeIdServicesDataType_EventFieldList, true
	case 920:
		return OpcuaNodeIdServicesDataType_HistoryEventFieldList, true
	case 938:
		return OpcuaNodeIdServicesDataType_IssuedIdentityToken, true
	case 94:
		return OpcuaNodeIdServicesDataType_PermissionType, true
	case 945:
		return OpcuaNodeIdServicesDataType_NotificationData, true
	case 948:
		return OpcuaNodeIdServicesDataType_AggregateConfiguration, true
	case 95:
		return OpcuaNodeIdServicesDataType_AccessRestrictionType, true
	case 96:
		return OpcuaNodeIdServicesDataType_RolePermissionType, true
	case 97:
		return OpcuaNodeIdServicesDataType_DataTypeDefinition, true
	case 98:
		return OpcuaNodeIdServicesDataType_StructureType, true
	case 99:
		return OpcuaNodeIdServicesDataType_StructureDefinition, true
	}
	return 0, false
}

func OpcuaNodeIdServicesDataTypeByName(value string) (enum OpcuaNodeIdServicesDataType, ok bool) {
	switch value {
	case "Boolean":
		return OpcuaNodeIdServicesDataType_Boolean, true
	case "Float":
		return OpcuaNodeIdServicesDataType_Float, true
	case "EnumDefinition":
		return OpcuaNodeIdServicesDataType_EnumDefinition, true
	case "StructureField":
		return OpcuaNodeIdServicesDataType_StructureField, true
	case "EnumField":
		return OpcuaNodeIdServicesDataType_EnumField, true
	case "Double":
		return OpcuaNodeIdServicesDataType_Double, true
	case "ModificationInfo":
		return OpcuaNodeIdServicesDataType_ModificationInfo, true
	case "HistoryModifiedData":
		return OpcuaNodeIdServicesDataType_HistoryModifiedData, true
	case "HistoryUpdateType":
		return OpcuaNodeIdServicesDataType_HistoryUpdateType, true
	case "PerformUpdateType":
		return OpcuaNodeIdServicesDataType_PerformUpdateType, true
	case "UpdateStructureDataDetails":
		return OpcuaNodeIdServicesDataType_UpdateStructureDataDetails, true
	case "BitFieldMaskDataType":
		return OpcuaNodeIdServicesDataType_BitFieldMaskDataType, true
	case "InstanceNode":
		return OpcuaNodeIdServicesDataType_InstanceNode, true
	case "TypeNode":
		return OpcuaNodeIdServicesDataType_TypeNode, true
	case "OpenFileMode":
		return OpcuaNodeIdServicesDataType_OpenFileMode, true
	case "ModelChangeStructureVerbMask":
		return OpcuaNodeIdServicesDataType_ModelChangeStructureVerbMask, true
	case "EndpointUrlListDataType":
		return OpcuaNodeIdServicesDataType_EndpointUrlListDataType, true
	case "NetworkGroupDataType":
		return OpcuaNodeIdServicesDataType_NetworkGroupDataType, true
	case "String":
		return OpcuaNodeIdServicesDataType_String, true
	case "NamingRuleType":
		return OpcuaNodeIdServicesDataType_NamingRuleType, true
	case "AxisScaleEnumeration":
		return OpcuaNodeIdServicesDataType_AxisScaleEnumeration, true
	case "AxisInformation":
		return OpcuaNodeIdServicesDataType_AxisInformation, true
	case "XVType":
		return OpcuaNodeIdServicesDataType_XVType, true
	case "ComplexNumberType":
		return OpcuaNodeIdServicesDataType_ComplexNumberType, true
	case "DoubleComplexNumberType":
		return OpcuaNodeIdServicesDataType_DoubleComplexNumberType, true
	case "ServerOnNetwork":
		return OpcuaNodeIdServicesDataType_ServerOnNetwork, true
	case "FindServersOnNetworkRequest":
		return OpcuaNodeIdServicesDataType_FindServersOnNetworkRequest, true
	case "FindServersOnNetworkResponse":
		return OpcuaNodeIdServicesDataType_FindServersOnNetworkResponse, true
	case "RegisterServer2Request":
		return OpcuaNodeIdServicesDataType_RegisterServer2Request, true
	case "RegisterServer2Response":
		return OpcuaNodeIdServicesDataType_RegisterServer2Response, true
	case "TrustListMasks":
		return OpcuaNodeIdServicesDataType_TrustListMasks, true
	case "TrustListDataType":
		return OpcuaNodeIdServicesDataType_TrustListDataType, true
	case "OptionSet":
		return OpcuaNodeIdServicesDataType_OptionSet, true
	case "Union":
		return OpcuaNodeIdServicesDataType_Union, true
	case "NormalizedString":
		return OpcuaNodeIdServicesDataType_NormalizedString, true
	case "DecimalString":
		return OpcuaNodeIdServicesDataType_DecimalString, true
	case "DurationString":
		return OpcuaNodeIdServicesDataType_DurationString, true
	case "TimeString":
		return OpcuaNodeIdServicesDataType_TimeString, true
	case "DateString":
		return OpcuaNodeIdServicesDataType_DateString, true
	case "DiscoveryConfiguration":
		return OpcuaNodeIdServicesDataType_DiscoveryConfiguration, true
	case "MdnsDiscoveryConfiguration":
		return OpcuaNodeIdServicesDataType_MdnsDiscoveryConfiguration, true
	case "DateTime":
		return OpcuaNodeIdServicesDataType_DateTime, true
	case "Guid":
		return OpcuaNodeIdServicesDataType_Guid, true
	case "PublishedVariableDataType":
		return OpcuaNodeIdServicesDataType_PublishedVariableDataType, true
	case "DataSetMetaDataType":
		return OpcuaNodeIdServicesDataType_DataSetMetaDataType, true
	case "FieldMetaData":
		return OpcuaNodeIdServicesDataType_FieldMetaData, true
	case "DataTypeDescription":
		return OpcuaNodeIdServicesDataType_DataTypeDescription, true
	case "KeyValuePair":
		return OpcuaNodeIdServicesDataType_KeyValuePair, true
	case "ConfigurationVersionDataType":
		return OpcuaNodeIdServicesDataType_ConfigurationVersionDataType, true
	case "PubSubState":
		return OpcuaNodeIdServicesDataType_PubSubState, true
	case "FieldTargetDataType":
		return OpcuaNodeIdServicesDataType_FieldTargetDataType, true
	case "ByteString":
		return OpcuaNodeIdServicesDataType_ByteString, true
	case "SimpleTypeDescription":
		return OpcuaNodeIdServicesDataType_SimpleTypeDescription, true
	case "UABinaryFileDataType":
		return OpcuaNodeIdServicesDataType_UABinaryFileDataType, true
	case "BrokerConnectionTransportDataType":
		return OpcuaNodeIdServicesDataType_BrokerConnectionTransportDataType, true
	case "BrokerTransportQualityOfService":
		return OpcuaNodeIdServicesDataType_BrokerTransportQualityOfService, true
	case "AccessLevelType":
		return OpcuaNodeIdServicesDataType_AccessLevelType, true
	case "EventNotifierType":
		return OpcuaNodeIdServicesDataType_EventNotifierType, true
	case "AccessLevelExType":
		return OpcuaNodeIdServicesDataType_AccessLevelExType, true
	case "WriterGroupDataType":
		return OpcuaNodeIdServicesDataType_WriterGroupDataType, true
	case "StructureDescription":
		return OpcuaNodeIdServicesDataType_StructureDescription, true
	case "EnumDescription":
		return OpcuaNodeIdServicesDataType_EnumDescription, true
	case "NetworkAddressDataType":
		return OpcuaNodeIdServicesDataType_NetworkAddressDataType, true
	case "NetworkAddressUrlDataType":
		return OpcuaNodeIdServicesDataType_NetworkAddressUrlDataType, true
	case "ReaderGroupDataType":
		return OpcuaNodeIdServicesDataType_ReaderGroupDataType, true
	case "EndpointType":
		return OpcuaNodeIdServicesDataType_EndpointType, true
	case "PubSubConfigurationDataType":
		return OpcuaNodeIdServicesDataType_PubSubConfigurationDataType, true
	case "DatagramWriterGroupTransportDataType":
		return OpcuaNodeIdServicesDataType_DatagramWriterGroupTransportDataType, true
	case "DataTypeSchemaHeader":
		return OpcuaNodeIdServicesDataType_DataTypeSchemaHeader, true
	case "PublishedDataSetDataType":
		return OpcuaNodeIdServicesDataType_PublishedDataSetDataType, true
	case "PublishedDataSetSourceDataType":
		return OpcuaNodeIdServicesDataType_PublishedDataSetSourceDataType, true
	case "PublishedDataItemsDataType":
		return OpcuaNodeIdServicesDataType_PublishedDataItemsDataType, true
	case "PublishedEventsDataType":
		return OpcuaNodeIdServicesDataType_PublishedEventsDataType, true
	case "DataSetFieldContentMask":
		return OpcuaNodeIdServicesDataType_DataSetFieldContentMask, true
	case "DataSetWriterDataType":
		return OpcuaNodeIdServicesDataType_DataSetWriterDataType, true
	case "DataSetWriterTransportDataType":
		return OpcuaNodeIdServicesDataType_DataSetWriterTransportDataType, true
	case "DataSetWriterMessageDataType":
		return OpcuaNodeIdServicesDataType_DataSetWriterMessageDataType, true
	case "PubSubGroupDataType":
		return OpcuaNodeIdServicesDataType_PubSubGroupDataType, true
	case "WriterGroupTransportDataType":
		return OpcuaNodeIdServicesDataType_WriterGroupTransportDataType, true
	case "WriterGroupMessageDataType":
		return OpcuaNodeIdServicesDataType_WriterGroupMessageDataType, true
	case "PubSubConnectionDataType":
		return OpcuaNodeIdServicesDataType_PubSubConnectionDataType, true
	case "ConnectionTransportDataType":
		return OpcuaNodeIdServicesDataType_ConnectionTransportDataType, true
	case "ReaderGroupTransportDataType":
		return OpcuaNodeIdServicesDataType_ReaderGroupTransportDataType, true
	case "ReaderGroupMessageDataType":
		return OpcuaNodeIdServicesDataType_ReaderGroupMessageDataType, true
	case "DataSetReaderDataType":
		return OpcuaNodeIdServicesDataType_DataSetReaderDataType, true
	case "DataSetReaderTransportDataType":
		return OpcuaNodeIdServicesDataType_DataSetReaderTransportDataType, true
	case "DataSetReaderMessageDataType":
		return OpcuaNodeIdServicesDataType_DataSetReaderMessageDataType, true
	case "SubscribedDataSetDataType":
		return OpcuaNodeIdServicesDataType_SubscribedDataSetDataType, true
	case "TargetVariablesDataType":
		return OpcuaNodeIdServicesDataType_TargetVariablesDataType, true
	case "IdentityCriteriaType":
		return OpcuaNodeIdServicesDataType_IdentityCriteriaType, true
	case "IdentityMappingRuleType":
		return OpcuaNodeIdServicesDataType_IdentityMappingRuleType, true
	case "SubscribedDataSetMirrorDataType":
		return OpcuaNodeIdServicesDataType_SubscribedDataSetMirrorDataType, true
	case "UadpNetworkMessageContentMask":
		return OpcuaNodeIdServicesDataType_UadpNetworkMessageContentMask, true
	case "UadpWriterGroupMessageDataType":
		return OpcuaNodeIdServicesDataType_UadpWriterGroupMessageDataType, true
	case "UadpDataSetMessageContentMask":
		return OpcuaNodeIdServicesDataType_UadpDataSetMessageContentMask, true
	case "UadpDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesDataType_UadpDataSetWriterMessageDataType, true
	case "UadpDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesDataType_UadpDataSetReaderMessageDataType, true
	case "JsonNetworkMessageContentMask":
		return OpcuaNodeIdServicesDataType_JsonNetworkMessageContentMask, true
	case "JsonWriterGroupMessageDataType":
		return OpcuaNodeIdServicesDataType_JsonWriterGroupMessageDataType, true
	case "JsonDataSetMessageContentMask":
		return OpcuaNodeIdServicesDataType_JsonDataSetMessageContentMask, true
	case "JsonDataSetWriterMessageDataType":
		return OpcuaNodeIdServicesDataType_JsonDataSetWriterMessageDataType, true
	case "JsonDataSetReaderMessageDataType":
		return OpcuaNodeIdServicesDataType_JsonDataSetReaderMessageDataType, true
	case "BrokerWriterGroupTransportDataType":
		return OpcuaNodeIdServicesDataType_BrokerWriterGroupTransportDataType, true
	case "BrokerDataSetWriterTransportDataType":
		return OpcuaNodeIdServicesDataType_BrokerDataSetWriterTransportDataType, true
	case "BrokerDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesDataType_BrokerDataSetReaderTransportDataType, true
	case "OverrideValueHandling":
		return OpcuaNodeIdServicesDataType_OverrideValueHandling, true
	case "SessionlessInvokeRequestType":
		return OpcuaNodeIdServicesDataType_SessionlessInvokeRequestType, true
	case "DataSetFieldFlags":
		return OpcuaNodeIdServicesDataType_DataSetFieldFlags, true
	case "XmlElement":
		return OpcuaNodeIdServicesDataType_XmlElement, true
	case "AudioDataType":
		return OpcuaNodeIdServicesDataType_AudioDataType, true
	case "AdditionalParametersType":
		return OpcuaNodeIdServicesDataType_AdditionalParametersType, true
	case "NodeId":
		return OpcuaNodeIdServicesDataType_NodeId, true
	case "DatagramConnectionTransportDataType":
		return OpcuaNodeIdServicesDataType_DatagramConnectionTransportDataType, true
	case "RsaEncryptedSecret":
		return OpcuaNodeIdServicesDataType_RsaEncryptedSecret, true
	case "EccEncryptedSecret":
		return OpcuaNodeIdServicesDataType_EccEncryptedSecret, true
	case "EphemeralKeyType":
		return OpcuaNodeIdServicesDataType_EphemeralKeyType, true
	case "Index":
		return OpcuaNodeIdServicesDataType_Index, true
	case "GenericAttributeValue":
		return OpcuaNodeIdServicesDataType_GenericAttributeValue, true
	case "GenericAttributes":
		return OpcuaNodeIdServicesDataType_GenericAttributes, true
	case "DecimalDataType":
		return OpcuaNodeIdServicesDataType_DecimalDataType, true
	case "ExpandedNodeId":
		return OpcuaNodeIdServicesDataType_ExpandedNodeId, true
	case "RationalNumber":
		return OpcuaNodeIdServicesDataType_RationalNumber, true
	case "Vector":
		return OpcuaNodeIdServicesDataType_Vector, true
	case "ThreeDVector":
		return OpcuaNodeIdServicesDataType_ThreeDVector, true
	case "CartesianCoordinates":
		return OpcuaNodeIdServicesDataType_CartesianCoordinates, true
	case "ThreeDCartesianCoordinates":
		return OpcuaNodeIdServicesDataType_ThreeDCartesianCoordinates, true
	case "Orientation":
		return OpcuaNodeIdServicesDataType_Orientation, true
	case "ThreeDOrientation":
		return OpcuaNodeIdServicesDataType_ThreeDOrientation, true
	case "Frame":
		return OpcuaNodeIdServicesDataType_Frame, true
	case "ThreeDFrame":
		return OpcuaNodeIdServicesDataType_ThreeDFrame, true
	case "StatusCode":
		return OpcuaNodeIdServicesDataType_StatusCode, true
	case "DiagnosticsLevel":
		return OpcuaNodeIdServicesDataType_DiagnosticsLevel, true
	case "PubSubDiagnosticsCounterClassification":
		return OpcuaNodeIdServicesDataType_PubSubDiagnosticsCounterClassification, true
	case "SByte":
		return OpcuaNodeIdServicesDataType_SByte, true
	case "QualifiedName":
		return OpcuaNodeIdServicesDataType_QualifiedName, true
	case "ImageBMP":
		return OpcuaNodeIdServicesDataType_ImageBMP, true
	case "ImageGIF":
		return OpcuaNodeIdServicesDataType_ImageGIF, true
	case "ImageJPG":
		return OpcuaNodeIdServicesDataType_ImageJPG, true
	case "ImagePNG":
		return OpcuaNodeIdServicesDataType_ImagePNG, true
	case "DataSetOrderingType":
		return OpcuaNodeIdServicesDataType_DataSetOrderingType, true
	case "VersionTime":
		return OpcuaNodeIdServicesDataType_VersionTime, true
	case "SessionlessInvokeResponseType":
		return OpcuaNodeIdServicesDataType_SessionlessInvokeResponseType, true
	case "LocalizedText":
		return OpcuaNodeIdServicesDataType_LocalizedText, true
	case "Structure":
		return OpcuaNodeIdServicesDataType_Structure, true
	case "DataValue":
		return OpcuaNodeIdServicesDataType_DataValue, true
	case "AliasNameDataType":
		return OpcuaNodeIdServicesDataType_AliasNameDataType, true
	case "ReadAnnotationDataDetails":
		return OpcuaNodeIdServicesDataType_ReadAnnotationDataDetails, true
	case "CurrencyUnitType":
		return OpcuaNodeIdServicesDataType_CurrencyUnitType, true
	case "TrustListValidationOptions":
		return OpcuaNodeIdServicesDataType_TrustListValidationOptions, true
	case "StandaloneSubscribedDataSetRefDataType":
		return OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetRefDataType, true
	case "StandaloneSubscribedDataSetDataType":
		return OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetDataType, true
	case "SecurityGroupDataType":
		return OpcuaNodeIdServicesDataType_SecurityGroupDataType, true
	case "PubSubConfiguration2DataType":
		return OpcuaNodeIdServicesDataType_PubSubConfiguration2DataType, true
	case "QosDataType":
		return OpcuaNodeIdServicesDataType_QosDataType, true
	case "TransmitQosDataType":
		return OpcuaNodeIdServicesDataType_TransmitQosDataType, true
	case "TransmitQosPriorityDataType":
		return OpcuaNodeIdServicesDataType_TransmitQosPriorityDataType, true
	case "ReceiveQosDataType":
		return OpcuaNodeIdServicesDataType_ReceiveQosDataType, true
	case "ReceiveQosPriorityDataType":
		return OpcuaNodeIdServicesDataType_ReceiveQosPriorityDataType, true
	case "DatagramConnectionTransport2DataType":
		return OpcuaNodeIdServicesDataType_DatagramConnectionTransport2DataType, true
	case "DatagramWriterGroupTransport2DataType":
		return OpcuaNodeIdServicesDataType_DatagramWriterGroupTransport2DataType, true
	case "DatagramDataSetReaderTransportDataType":
		return OpcuaNodeIdServicesDataType_DatagramDataSetReaderTransportDataType, true
	case "UriString":
		return OpcuaNodeIdServicesDataType_UriString, true
	case "BaseDataType":
		return OpcuaNodeIdServicesDataType_BaseDataType, true
	case "ProgramDiagnostic2DataType":
		return OpcuaNodeIdServicesDataType_ProgramDiagnostic2DataType, true
	case "PortableQualifiedName":
		return OpcuaNodeIdServicesDataType_PortableQualifiedName, true
	case "PortableNodeId":
		return OpcuaNodeIdServicesDataType_PortableNodeId, true
	case "UnsignedRationalNumber":
		return OpcuaNodeIdServicesDataType_UnsignedRationalNumber, true
	case "Duplex":
		return OpcuaNodeIdServicesDataType_Duplex, true
	case "InterfaceAdminStatus":
		return OpcuaNodeIdServicesDataType_InterfaceAdminStatus, true
	case "InterfaceOperStatus":
		return OpcuaNodeIdServicesDataType_InterfaceOperStatus, true
	case "NegotiationStatus":
		return OpcuaNodeIdServicesDataType_NegotiationStatus, true
	case "TsnFailureCode":
		return OpcuaNodeIdServicesDataType_TsnFailureCode, true
	case "TsnStreamState":
		return OpcuaNodeIdServicesDataType_TsnStreamState, true
	case "TsnTalkerStatus":
		return OpcuaNodeIdServicesDataType_TsnTalkerStatus, true
	case "TsnListenerStatus":
		return OpcuaNodeIdServicesDataType_TsnListenerStatus, true
	case "SemanticVersionString":
		return OpcuaNodeIdServicesDataType_SemanticVersionString, true
	case "PasswordOptionsMask":
		return OpcuaNodeIdServicesDataType_PasswordOptionsMask, true
	case "UserConfigurationMask":
		return OpcuaNodeIdServicesDataType_UserConfigurationMask, true
	case "UserManagementDataType":
		return OpcuaNodeIdServicesDataType_UserManagementDataType, true
	case "DiagnosticInfo":
		return OpcuaNodeIdServicesDataType_DiagnosticInfo, true
	case "PriorityMappingEntryType":
		return OpcuaNodeIdServicesDataType_PriorityMappingEntryType, true
	case "PublishedDataSetCustomSourceDataType":
		return OpcuaNodeIdServicesDataType_PublishedDataSetCustomSourceDataType, true
	case "PubSubKeyPushTargetDataType":
		return OpcuaNodeIdServicesDataType_PubSubKeyPushTargetDataType, true
	case "PubSubConfigurationRefMask":
		return OpcuaNodeIdServicesDataType_PubSubConfigurationRefMask, true
	case "PubSubConfigurationRefDataType":
		return OpcuaNodeIdServicesDataType_PubSubConfigurationRefDataType, true
	case "PubSubConfigurationValueDataType":
		return OpcuaNodeIdServicesDataType_PubSubConfigurationValueDataType, true
	case "IdType":
		return OpcuaNodeIdServicesDataType_IdType, true
	case "NodeClass":
		return OpcuaNodeIdServicesDataType_NodeClass, true
	case "EncodedTicket":
		return OpcuaNodeIdServicesDataType_EncodedTicket, true
	case "Node":
		return OpcuaNodeIdServicesDataType_Node, true
	case "Number":
		return OpcuaNodeIdServicesDataType_Number, true
	case "ObjectNode":
		return OpcuaNodeIdServicesDataType_ObjectNode, true
	case "ObjectTypeNode":
		return OpcuaNodeIdServicesDataType_ObjectTypeNode, true
	case "VariableNode":
		return OpcuaNodeIdServicesDataType_VariableNode, true
	case "Integer":
		return OpcuaNodeIdServicesDataType_Integer, true
	case "VariableTypeNode":
		return OpcuaNodeIdServicesDataType_VariableTypeNode, true
	case "ReferenceTypeNode":
		return OpcuaNodeIdServicesDataType_ReferenceTypeNode, true
	case "MethodNode":
		return OpcuaNodeIdServicesDataType_MethodNode, true
	case "ViewNode":
		return OpcuaNodeIdServicesDataType_ViewNode, true
	case "UInteger":
		return OpcuaNodeIdServicesDataType_UInteger, true
	case "DataTypeNode":
		return OpcuaNodeIdServicesDataType_DataTypeNode, true
	case "ReferenceNode":
		return OpcuaNodeIdServicesDataType_ReferenceNode, true
	case "IntegerId":
		return OpcuaNodeIdServicesDataType_IntegerId, true
	case "Counter":
		return OpcuaNodeIdServicesDataType_Counter, true
	case "Enumeration":
		return OpcuaNodeIdServicesDataType_Enumeration, true
	case "Duration":
		return OpcuaNodeIdServicesDataType_Duration, true
	case "NumericRange":
		return OpcuaNodeIdServicesDataType_NumericRange, true
	case "UtcTime":
		return OpcuaNodeIdServicesDataType_UtcTime, true
	case "LocaleId":
		return OpcuaNodeIdServicesDataType_LocaleId, true
	case "Argument":
		return OpcuaNodeIdServicesDataType_Argument, true
	case "StatusResult":
		return OpcuaNodeIdServicesDataType_StatusResult, true
	case "Byte":
		return OpcuaNodeIdServicesDataType_Byte, true
	case "Image":
		return OpcuaNodeIdServicesDataType_Image, true
	case "MessageSecurityMode":
		return OpcuaNodeIdServicesDataType_MessageSecurityMode, true
	case "UserTokenType":
		return OpcuaNodeIdServicesDataType_UserTokenType, true
	case "UserTokenPolicy":
		return OpcuaNodeIdServicesDataType_UserTokenPolicy, true
	case "ApplicationType":
		return OpcuaNodeIdServicesDataType_ApplicationType, true
	case "ApplicationDescription":
		return OpcuaNodeIdServicesDataType_ApplicationDescription, true
	case "ApplicationInstanceCertificate":
		return OpcuaNodeIdServicesDataType_ApplicationInstanceCertificate, true
	case "EndpointDescription":
		return OpcuaNodeIdServicesDataType_EndpointDescription, true
	case "SecurityTokenRequestType":
		return OpcuaNodeIdServicesDataType_SecurityTokenRequestType, true
	case "UserIdentityToken":
		return OpcuaNodeIdServicesDataType_UserIdentityToken, true
	case "AnonymousIdentityToken":
		return OpcuaNodeIdServicesDataType_AnonymousIdentityToken, true
	case "Handle":
		return OpcuaNodeIdServicesDataType_Handle, true
	case "TrimmedString":
		return OpcuaNodeIdServicesDataType_TrimmedString, true
	case "UserNameIdentityToken":
		return OpcuaNodeIdServicesDataType_UserNameIdentityToken, true
	case "AlarmMask":
		return OpcuaNodeIdServicesDataType_AlarmMask, true
	case "TransactionErrorType":
		return OpcuaNodeIdServicesDataType_TransactionErrorType, true
	case "X509IdentityToken":
		return OpcuaNodeIdServicesDataType_X509IdentityToken, true
	case "ReferenceDescriptionDataType":
		return OpcuaNodeIdServicesDataType_ReferenceDescriptionDataType, true
	case "ReferenceListEntryDataType":
		return OpcuaNodeIdServicesDataType_ReferenceListEntryDataType, true
	case "EndpointConfiguration":
		return OpcuaNodeIdServicesDataType_EndpointConfiguration, true
	case "BuildInfo":
		return OpcuaNodeIdServicesDataType_BuildInfo, true
	case "SignedSoftwareCertificate":
		return OpcuaNodeIdServicesDataType_SignedSoftwareCertificate, true
	case "AttributeWriteMask":
		return OpcuaNodeIdServicesDataType_AttributeWriteMask, true
	case "NodeAttributesMask":
		return OpcuaNodeIdServicesDataType_NodeAttributesMask, true
	case "NodeAttributes":
		return OpcuaNodeIdServicesDataType_NodeAttributes, true
	case "ObjectAttributes":
		return OpcuaNodeIdServicesDataType_ObjectAttributes, true
	case "VariableAttributes":
		return OpcuaNodeIdServicesDataType_VariableAttributes, true
	case "MethodAttributes":
		return OpcuaNodeIdServicesDataType_MethodAttributes, true
	case "ObjectTypeAttributes":
		return OpcuaNodeIdServicesDataType_ObjectTypeAttributes, true
	case "VariableTypeAttributes":
		return OpcuaNodeIdServicesDataType_VariableTypeAttributes, true
	case "ReferenceTypeAttributes":
		return OpcuaNodeIdServicesDataType_ReferenceTypeAttributes, true
	case "DataTypeAttributes":
		return OpcuaNodeIdServicesDataType_DataTypeAttributes, true
	case "ViewAttributes":
		return OpcuaNodeIdServicesDataType_ViewAttributes, true
	case "AddNodesItem":
		return OpcuaNodeIdServicesDataType_AddNodesItem, true
	case "AddReferencesItem":
		return OpcuaNodeIdServicesDataType_AddReferencesItem, true
	case "DeleteNodesItem":
		return OpcuaNodeIdServicesDataType_DeleteNodesItem, true
	case "DeleteReferencesItem":
		return OpcuaNodeIdServicesDataType_DeleteReferencesItem, true
	case "SessionAuthenticationToken":
		return OpcuaNodeIdServicesDataType_SessionAuthenticationToken, true
	case "RequestHeader":
		return OpcuaNodeIdServicesDataType_RequestHeader, true
	case "ResponseHeader":
		return OpcuaNodeIdServicesDataType_ResponseHeader, true
	case "ServiceFault":
		return OpcuaNodeIdServicesDataType_ServiceFault, true
	case "Int16":
		return OpcuaNodeIdServicesDataType_Int16, true
	case "FindServersRequest":
		return OpcuaNodeIdServicesDataType_FindServersRequest, true
	case "FindServersResponse":
		return OpcuaNodeIdServicesDataType_FindServersResponse, true
	case "GetEndpointsRequest":
		return OpcuaNodeIdServicesDataType_GetEndpointsRequest, true
	case "GetEndpointsResponse":
		return OpcuaNodeIdServicesDataType_GetEndpointsResponse, true
	case "RegisteredServer":
		return OpcuaNodeIdServicesDataType_RegisteredServer, true
	case "RegisterServerRequest":
		return OpcuaNodeIdServicesDataType_RegisterServerRequest, true
	case "RegisterServerResponse":
		return OpcuaNodeIdServicesDataType_RegisterServerResponse, true
	case "ChannelSecurityToken":
		return OpcuaNodeIdServicesDataType_ChannelSecurityToken, true
	case "OpenSecureChannelRequest":
		return OpcuaNodeIdServicesDataType_OpenSecureChannelRequest, true
	case "OpenSecureChannelResponse":
		return OpcuaNodeIdServicesDataType_OpenSecureChannelResponse, true
	case "CloseSecureChannelRequest":
		return OpcuaNodeIdServicesDataType_CloseSecureChannelRequest, true
	case "CloseSecureChannelResponse":
		return OpcuaNodeIdServicesDataType_CloseSecureChannelResponse, true
	case "SignatureData":
		return OpcuaNodeIdServicesDataType_SignatureData, true
	case "CreateSessionRequest":
		return OpcuaNodeIdServicesDataType_CreateSessionRequest, true
	case "CreateSessionResponse":
		return OpcuaNodeIdServicesDataType_CreateSessionResponse, true
	case "ActivateSessionRequest":
		return OpcuaNodeIdServicesDataType_ActivateSessionRequest, true
	case "ActivateSessionResponse":
		return OpcuaNodeIdServicesDataType_ActivateSessionResponse, true
	case "CloseSessionRequest":
		return OpcuaNodeIdServicesDataType_CloseSessionRequest, true
	case "CloseSessionResponse":
		return OpcuaNodeIdServicesDataType_CloseSessionResponse, true
	case "CancelRequest":
		return OpcuaNodeIdServicesDataType_CancelRequest, true
	case "CancelResponse":
		return OpcuaNodeIdServicesDataType_CancelResponse, true
	case "AddNodesResult":
		return OpcuaNodeIdServicesDataType_AddNodesResult, true
	case "AddNodesRequest":
		return OpcuaNodeIdServicesDataType_AddNodesRequest, true
	case "AddNodesResponse":
		return OpcuaNodeIdServicesDataType_AddNodesResponse, true
	case "AddReferencesRequest":
		return OpcuaNodeIdServicesDataType_AddReferencesRequest, true
	case "AddReferencesResponse":
		return OpcuaNodeIdServicesDataType_AddReferencesResponse, true
	case "DeleteNodesRequest":
		return OpcuaNodeIdServicesDataType_DeleteNodesRequest, true
	case "UInt16":
		return OpcuaNodeIdServicesDataType_UInt16, true
	case "Decimal":
		return OpcuaNodeIdServicesDataType_Decimal, true
	case "DeleteNodesResponse":
		return OpcuaNodeIdServicesDataType_DeleteNodesResponse, true
	case "DeleteReferencesRequest":
		return OpcuaNodeIdServicesDataType_DeleteReferencesRequest, true
	case "DeleteReferencesResponse":
		return OpcuaNodeIdServicesDataType_DeleteReferencesResponse, true
	case "BrowseDirection":
		return OpcuaNodeIdServicesDataType_BrowseDirection, true
	case "ViewDescription":
		return OpcuaNodeIdServicesDataType_ViewDescription, true
	case "BrowseDescription":
		return OpcuaNodeIdServicesDataType_BrowseDescription, true
	case "BrowseResultMask":
		return OpcuaNodeIdServicesDataType_BrowseResultMask, true
	case "ReferenceDescription":
		return OpcuaNodeIdServicesDataType_ReferenceDescription, true
	case "ContinuationPoint":
		return OpcuaNodeIdServicesDataType_ContinuationPoint, true
	case "BrowseResult":
		return OpcuaNodeIdServicesDataType_BrowseResult, true
	case "BrowseRequest":
		return OpcuaNodeIdServicesDataType_BrowseRequest, true
	case "BrowseResponse":
		return OpcuaNodeIdServicesDataType_BrowseResponse, true
	case "BrowseNextRequest":
		return OpcuaNodeIdServicesDataType_BrowseNextRequest, true
	case "BrowseNextResponse":
		return OpcuaNodeIdServicesDataType_BrowseNextResponse, true
	case "RelativePathElement":
		return OpcuaNodeIdServicesDataType_RelativePathElement, true
	case "RelativePath":
		return OpcuaNodeIdServicesDataType_RelativePath, true
	case "BrowsePath":
		return OpcuaNodeIdServicesDataType_BrowsePath, true
	case "BrowsePathTarget":
		return OpcuaNodeIdServicesDataType_BrowsePathTarget, true
	case "BrowsePathResult":
		return OpcuaNodeIdServicesDataType_BrowsePathResult, true
	case "TranslateBrowsePathsToNodeIdsRequest":
		return OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsRequest, true
	case "TranslateBrowsePathsToNodeIdsResponse":
		return OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsResponse, true
	case "RegisterNodesRequest":
		return OpcuaNodeIdServicesDataType_RegisterNodesRequest, true
	case "RegisterNodesResponse":
		return OpcuaNodeIdServicesDataType_RegisterNodesResponse, true
	case "UnregisterNodesRequest":
		return OpcuaNodeIdServicesDataType_UnregisterNodesRequest, true
	case "UnregisterNodesResponse":
		return OpcuaNodeIdServicesDataType_UnregisterNodesResponse, true
	case "QueryDataDescription":
		return OpcuaNodeIdServicesDataType_QueryDataDescription, true
	case "NodeTypeDescription":
		return OpcuaNodeIdServicesDataType_NodeTypeDescription, true
	case "FilterOperator":
		return OpcuaNodeIdServicesDataType_FilterOperator, true
	case "QueryDataSet":
		return OpcuaNodeIdServicesDataType_QueryDataSet, true
	case "NodeReference":
		return OpcuaNodeIdServicesDataType_NodeReference, true
	case "ContentFilterElement":
		return OpcuaNodeIdServicesDataType_ContentFilterElement, true
	case "ContentFilter":
		return OpcuaNodeIdServicesDataType_ContentFilter, true
	case "FilterOperand":
		return OpcuaNodeIdServicesDataType_FilterOperand, true
	case "ElementOperand":
		return OpcuaNodeIdServicesDataType_ElementOperand, true
	case "LiteralOperand":
		return OpcuaNodeIdServicesDataType_LiteralOperand, true
	case "AttributeOperand":
		return OpcuaNodeIdServicesDataType_AttributeOperand, true
	case "Int32":
		return OpcuaNodeIdServicesDataType_Int32, true
	case "SimpleAttributeOperand":
		return OpcuaNodeIdServicesDataType_SimpleAttributeOperand, true
	case "ContentFilterElementResult":
		return OpcuaNodeIdServicesDataType_ContentFilterElementResult, true
	case "ContentFilterResult":
		return OpcuaNodeIdServicesDataType_ContentFilterResult, true
	case "ParsingResult":
		return OpcuaNodeIdServicesDataType_ParsingResult, true
	case "QueryFirstRequest":
		return OpcuaNodeIdServicesDataType_QueryFirstRequest, true
	case "QueryFirstResponse":
		return OpcuaNodeIdServicesDataType_QueryFirstResponse, true
	case "QueryNextRequest":
		return OpcuaNodeIdServicesDataType_QueryNextRequest, true
	case "QueryNextResponse":
		return OpcuaNodeIdServicesDataType_QueryNextResponse, true
	case "TimestampsToReturn":
		return OpcuaNodeIdServicesDataType_TimestampsToReturn, true
	case "ReadValueId":
		return OpcuaNodeIdServicesDataType_ReadValueId, true
	case "ReadRequest":
		return OpcuaNodeIdServicesDataType_ReadRequest, true
	case "ReadResponse":
		return OpcuaNodeIdServicesDataType_ReadResponse, true
	case "HistoryReadValueId":
		return OpcuaNodeIdServicesDataType_HistoryReadValueId, true
	case "HistoryReadResult":
		return OpcuaNodeIdServicesDataType_HistoryReadResult, true
	case "HistoryReadDetails":
		return OpcuaNodeIdServicesDataType_HistoryReadDetails, true
	case "ReadEventDetails":
		return OpcuaNodeIdServicesDataType_ReadEventDetails, true
	case "ReadRawModifiedDetails":
		return OpcuaNodeIdServicesDataType_ReadRawModifiedDetails, true
	case "ReadProcessedDetails":
		return OpcuaNodeIdServicesDataType_ReadProcessedDetails, true
	case "ReadAtTimeDetails":
		return OpcuaNodeIdServicesDataType_ReadAtTimeDetails, true
	case "HistoryData":
		return OpcuaNodeIdServicesDataType_HistoryData, true
	case "HistoryEvent":
		return OpcuaNodeIdServicesDataType_HistoryEvent, true
	case "HistoryReadRequest":
		return OpcuaNodeIdServicesDataType_HistoryReadRequest, true
	case "HistoryReadResponse":
		return OpcuaNodeIdServicesDataType_HistoryReadResponse, true
	case "WriteValue":
		return OpcuaNodeIdServicesDataType_WriteValue, true
	case "WriteRequest":
		return OpcuaNodeIdServicesDataType_WriteRequest, true
	case "WriteResponse":
		return OpcuaNodeIdServicesDataType_WriteResponse, true
	case "HistoryUpdateDetails":
		return OpcuaNodeIdServicesDataType_HistoryUpdateDetails, true
	case "UpdateDataDetails":
		return OpcuaNodeIdServicesDataType_UpdateDataDetails, true
	case "UpdateEventDetails":
		return OpcuaNodeIdServicesDataType_UpdateEventDetails, true
	case "DeleteRawModifiedDetails":
		return OpcuaNodeIdServicesDataType_DeleteRawModifiedDetails, true
	case "DeleteAtTimeDetails":
		return OpcuaNodeIdServicesDataType_DeleteAtTimeDetails, true
	case "DeleteEventDetails":
		return OpcuaNodeIdServicesDataType_DeleteEventDetails, true
	case "HistoryUpdateResult":
		return OpcuaNodeIdServicesDataType_HistoryUpdateResult, true
	case "HistoryUpdateRequest":
		return OpcuaNodeIdServicesDataType_HistoryUpdateRequest, true
	case "UInt32":
		return OpcuaNodeIdServicesDataType_UInt32, true
	case "HistoryUpdateResponse":
		return OpcuaNodeIdServicesDataType_HistoryUpdateResponse, true
	case "CallMethodRequest":
		return OpcuaNodeIdServicesDataType_CallMethodRequest, true
	case "CallMethodResult":
		return OpcuaNodeIdServicesDataType_CallMethodResult, true
	case "CallRequest":
		return OpcuaNodeIdServicesDataType_CallRequest, true
	case "CallResponse":
		return OpcuaNodeIdServicesDataType_CallResponse, true
	case "MonitoringMode":
		return OpcuaNodeIdServicesDataType_MonitoringMode, true
	case "DataChangeTrigger":
		return OpcuaNodeIdServicesDataType_DataChangeTrigger, true
	case "DeadbandType":
		return OpcuaNodeIdServicesDataType_DeadbandType, true
	case "MonitoringFilter":
		return OpcuaNodeIdServicesDataType_MonitoringFilter, true
	case "DataChangeFilter":
		return OpcuaNodeIdServicesDataType_DataChangeFilter, true
	case "EventFilter":
		return OpcuaNodeIdServicesDataType_EventFilter, true
	case "AggregateFilter":
		return OpcuaNodeIdServicesDataType_AggregateFilter, true
	case "MonitoringFilterResult":
		return OpcuaNodeIdServicesDataType_MonitoringFilterResult, true
	case "EventFilterResult":
		return OpcuaNodeIdServicesDataType_EventFilterResult, true
	case "AggregateFilterResult":
		return OpcuaNodeIdServicesDataType_AggregateFilterResult, true
	case "MonitoringParameters":
		return OpcuaNodeIdServicesDataType_MonitoringParameters, true
	case "MonitoredItemCreateRequest":
		return OpcuaNodeIdServicesDataType_MonitoredItemCreateRequest, true
	case "MonitoredItemCreateResult":
		return OpcuaNodeIdServicesDataType_MonitoredItemCreateResult, true
	case "CreateMonitoredItemsRequest":
		return OpcuaNodeIdServicesDataType_CreateMonitoredItemsRequest, true
	case "CreateMonitoredItemsResponse":
		return OpcuaNodeIdServicesDataType_CreateMonitoredItemsResponse, true
	case "MonitoredItemModifyRequest":
		return OpcuaNodeIdServicesDataType_MonitoredItemModifyRequest, true
	case "MonitoredItemModifyResult":
		return OpcuaNodeIdServicesDataType_MonitoredItemModifyResult, true
	case "EnumValueType":
		return OpcuaNodeIdServicesDataType_EnumValueType, true
	case "ModifyMonitoredItemsRequest":
		return OpcuaNodeIdServicesDataType_ModifyMonitoredItemsRequest, true
	case "ModifyMonitoredItemsResponse":
		return OpcuaNodeIdServicesDataType_ModifyMonitoredItemsResponse, true
	case "SetMonitoringModeRequest":
		return OpcuaNodeIdServicesDataType_SetMonitoringModeRequest, true
	case "SetMonitoringModeResponse":
		return OpcuaNodeIdServicesDataType_SetMonitoringModeResponse, true
	case "SetTriggeringRequest":
		return OpcuaNodeIdServicesDataType_SetTriggeringRequest, true
	case "SetTriggeringResponse":
		return OpcuaNodeIdServicesDataType_SetTriggeringResponse, true
	case "DeleteMonitoredItemsRequest":
		return OpcuaNodeIdServicesDataType_DeleteMonitoredItemsRequest, true
	case "DeleteMonitoredItemsResponse":
		return OpcuaNodeIdServicesDataType_DeleteMonitoredItemsResponse, true
	case "CreateSubscriptionRequest":
		return OpcuaNodeIdServicesDataType_CreateSubscriptionRequest, true
	case "CreateSubscriptionResponse":
		return OpcuaNodeIdServicesDataType_CreateSubscriptionResponse, true
	case "ModifySubscriptionRequest":
		return OpcuaNodeIdServicesDataType_ModifySubscriptionRequest, true
	case "ModifySubscriptionResponse":
		return OpcuaNodeIdServicesDataType_ModifySubscriptionResponse, true
	case "SetPublishingModeRequest":
		return OpcuaNodeIdServicesDataType_SetPublishingModeRequest, true
	case "Int64":
		return OpcuaNodeIdServicesDataType_Int64, true
	case "SetPublishingModeResponse":
		return OpcuaNodeIdServicesDataType_SetPublishingModeResponse, true
	case "NotificationMessage":
		return OpcuaNodeIdServicesDataType_NotificationMessage, true
	case "MonitoredItemNotification":
		return OpcuaNodeIdServicesDataType_MonitoredItemNotification, true
	case "DataChangeNotification":
		return OpcuaNodeIdServicesDataType_DataChangeNotification, true
	case "StatusChangeNotification":
		return OpcuaNodeIdServicesDataType_StatusChangeNotification, true
	case "SubscriptionAcknowledgement":
		return OpcuaNodeIdServicesDataType_SubscriptionAcknowledgement, true
	case "PublishRequest":
		return OpcuaNodeIdServicesDataType_PublishRequest, true
	case "PublishResponse":
		return OpcuaNodeIdServicesDataType_PublishResponse, true
	case "RepublishRequest":
		return OpcuaNodeIdServicesDataType_RepublishRequest, true
	case "RepublishResponse":
		return OpcuaNodeIdServicesDataType_RepublishResponse, true
	case "TransferResult":
		return OpcuaNodeIdServicesDataType_TransferResult, true
	case "TransferSubscriptionsRequest":
		return OpcuaNodeIdServicesDataType_TransferSubscriptionsRequest, true
	case "TransferSubscriptionsResponse":
		return OpcuaNodeIdServicesDataType_TransferSubscriptionsResponse, true
	case "DeleteSubscriptionsRequest":
		return OpcuaNodeIdServicesDataType_DeleteSubscriptionsRequest, true
	case "DeleteSubscriptionsResponse":
		return OpcuaNodeIdServicesDataType_DeleteSubscriptionsResponse, true
	case "RedundancySupport":
		return OpcuaNodeIdServicesDataType_RedundancySupport, true
	case "ServerState":
		return OpcuaNodeIdServicesDataType_ServerState, true
	case "RedundantServerDataType":
		return OpcuaNodeIdServicesDataType_RedundantServerDataType, true
	case "SamplingIntervalDiagnosticsDataType":
		return OpcuaNodeIdServicesDataType_SamplingIntervalDiagnosticsDataType, true
	case "ServerDiagnosticsSummaryDataType":
		return OpcuaNodeIdServicesDataType_ServerDiagnosticsSummaryDataType, true
	case "ServerStatusDataType":
		return OpcuaNodeIdServicesDataType_ServerStatusDataType, true
	case "SessionDiagnosticsDataType":
		return OpcuaNodeIdServicesDataType_SessionDiagnosticsDataType, true
	case "SessionSecurityDiagnosticsDataType":
		return OpcuaNodeIdServicesDataType_SessionSecurityDiagnosticsDataType, true
	case "ServiceCounterDataType":
		return OpcuaNodeIdServicesDataType_ServiceCounterDataType, true
	case "SubscriptionDiagnosticsDataType":
		return OpcuaNodeIdServicesDataType_SubscriptionDiagnosticsDataType, true
	case "ModelChangeStructureDataType":
		return OpcuaNodeIdServicesDataType_ModelChangeStructureDataType, true
	case "Range":
		return OpcuaNodeIdServicesDataType_Range, true
	case "EUInformation":
		return OpcuaNodeIdServicesDataType_EUInformation, true
	case "ExceptionDeviationFormat":
		return OpcuaNodeIdServicesDataType_ExceptionDeviationFormat, true
	case "Annotation":
		return OpcuaNodeIdServicesDataType_Annotation, true
	case "TimeZoneDataType":
		return OpcuaNodeIdServicesDataType_TimeZoneDataType, true
	case "ProgramDiagnosticDataType":
		return OpcuaNodeIdServicesDataType_ProgramDiagnosticDataType, true
	case "SemanticChangeStructureDataType":
		return OpcuaNodeIdServicesDataType_SemanticChangeStructureDataType, true
	case "UInt64":
		return OpcuaNodeIdServicesDataType_UInt64, true
	case "EventNotificationList":
		return OpcuaNodeIdServicesDataType_EventNotificationList, true
	case "EventFieldList":
		return OpcuaNodeIdServicesDataType_EventFieldList, true
	case "HistoryEventFieldList":
		return OpcuaNodeIdServicesDataType_HistoryEventFieldList, true
	case "IssuedIdentityToken":
		return OpcuaNodeIdServicesDataType_IssuedIdentityToken, true
	case "PermissionType":
		return OpcuaNodeIdServicesDataType_PermissionType, true
	case "NotificationData":
		return OpcuaNodeIdServicesDataType_NotificationData, true
	case "AggregateConfiguration":
		return OpcuaNodeIdServicesDataType_AggregateConfiguration, true
	case "AccessRestrictionType":
		return OpcuaNodeIdServicesDataType_AccessRestrictionType, true
	case "RolePermissionType":
		return OpcuaNodeIdServicesDataType_RolePermissionType, true
	case "DataTypeDefinition":
		return OpcuaNodeIdServicesDataType_DataTypeDefinition, true
	case "StructureType":
		return OpcuaNodeIdServicesDataType_StructureType, true
	case "StructureDefinition":
		return OpcuaNodeIdServicesDataType_StructureDefinition, true
	}
	return 0, false
}

func OpcuaNodeIdServicesDataTypeKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesDataTypeValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesDataType(structType any) OpcuaNodeIdServicesDataType {
	castFunc := func(typ any) OpcuaNodeIdServicesDataType {
		if sOpcuaNodeIdServicesDataType, ok := typ.(OpcuaNodeIdServicesDataType); ok {
			return sOpcuaNodeIdServicesDataType
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesDataType) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesDataTypeParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesDataType, error) {
	return OpcuaNodeIdServicesDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesDataType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadInt32("OpcuaNodeIdServicesDataType", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesDataType")
	}
	if enum, ok := OpcuaNodeIdServicesDataTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesDataType")
		return OpcuaNodeIdServicesDataType(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteInt32("OpcuaNodeIdServicesDataType", 32, int32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesDataType) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesDataType_Boolean:
		return "Boolean"
	case OpcuaNodeIdServicesDataType_Float:
		return "Float"
	case OpcuaNodeIdServicesDataType_EnumDefinition:
		return "EnumDefinition"
	case OpcuaNodeIdServicesDataType_StructureField:
		return "StructureField"
	case OpcuaNodeIdServicesDataType_EnumField:
		return "EnumField"
	case OpcuaNodeIdServicesDataType_Double:
		return "Double"
	case OpcuaNodeIdServicesDataType_ModificationInfo:
		return "ModificationInfo"
	case OpcuaNodeIdServicesDataType_HistoryModifiedData:
		return "HistoryModifiedData"
	case OpcuaNodeIdServicesDataType_HistoryUpdateType:
		return "HistoryUpdateType"
	case OpcuaNodeIdServicesDataType_PerformUpdateType:
		return "PerformUpdateType"
	case OpcuaNodeIdServicesDataType_UpdateStructureDataDetails:
		return "UpdateStructureDataDetails"
	case OpcuaNodeIdServicesDataType_BitFieldMaskDataType:
		return "BitFieldMaskDataType"
	case OpcuaNodeIdServicesDataType_InstanceNode:
		return "InstanceNode"
	case OpcuaNodeIdServicesDataType_TypeNode:
		return "TypeNode"
	case OpcuaNodeIdServicesDataType_OpenFileMode:
		return "OpenFileMode"
	case OpcuaNodeIdServicesDataType_ModelChangeStructureVerbMask:
		return "ModelChangeStructureVerbMask"
	case OpcuaNodeIdServicesDataType_EndpointUrlListDataType:
		return "EndpointUrlListDataType"
	case OpcuaNodeIdServicesDataType_NetworkGroupDataType:
		return "NetworkGroupDataType"
	case OpcuaNodeIdServicesDataType_String:
		return "String"
	case OpcuaNodeIdServicesDataType_NamingRuleType:
		return "NamingRuleType"
	case OpcuaNodeIdServicesDataType_AxisScaleEnumeration:
		return "AxisScaleEnumeration"
	case OpcuaNodeIdServicesDataType_AxisInformation:
		return "AxisInformation"
	case OpcuaNodeIdServicesDataType_XVType:
		return "XVType"
	case OpcuaNodeIdServicesDataType_ComplexNumberType:
		return "ComplexNumberType"
	case OpcuaNodeIdServicesDataType_DoubleComplexNumberType:
		return "DoubleComplexNumberType"
	case OpcuaNodeIdServicesDataType_ServerOnNetwork:
		return "ServerOnNetwork"
	case OpcuaNodeIdServicesDataType_FindServersOnNetworkRequest:
		return "FindServersOnNetworkRequest"
	case OpcuaNodeIdServicesDataType_FindServersOnNetworkResponse:
		return "FindServersOnNetworkResponse"
	case OpcuaNodeIdServicesDataType_RegisterServer2Request:
		return "RegisterServer2Request"
	case OpcuaNodeIdServicesDataType_RegisterServer2Response:
		return "RegisterServer2Response"
	case OpcuaNodeIdServicesDataType_TrustListMasks:
		return "TrustListMasks"
	case OpcuaNodeIdServicesDataType_TrustListDataType:
		return "TrustListDataType"
	case OpcuaNodeIdServicesDataType_OptionSet:
		return "OptionSet"
	case OpcuaNodeIdServicesDataType_Union:
		return "Union"
	case OpcuaNodeIdServicesDataType_NormalizedString:
		return "NormalizedString"
	case OpcuaNodeIdServicesDataType_DecimalString:
		return "DecimalString"
	case OpcuaNodeIdServicesDataType_DurationString:
		return "DurationString"
	case OpcuaNodeIdServicesDataType_TimeString:
		return "TimeString"
	case OpcuaNodeIdServicesDataType_DateString:
		return "DateString"
	case OpcuaNodeIdServicesDataType_DiscoveryConfiguration:
		return "DiscoveryConfiguration"
	case OpcuaNodeIdServicesDataType_MdnsDiscoveryConfiguration:
		return "MdnsDiscoveryConfiguration"
	case OpcuaNodeIdServicesDataType_DateTime:
		return "DateTime"
	case OpcuaNodeIdServicesDataType_Guid:
		return "Guid"
	case OpcuaNodeIdServicesDataType_PublishedVariableDataType:
		return "PublishedVariableDataType"
	case OpcuaNodeIdServicesDataType_DataSetMetaDataType:
		return "DataSetMetaDataType"
	case OpcuaNodeIdServicesDataType_FieldMetaData:
		return "FieldMetaData"
	case OpcuaNodeIdServicesDataType_DataTypeDescription:
		return "DataTypeDescription"
	case OpcuaNodeIdServicesDataType_KeyValuePair:
		return "KeyValuePair"
	case OpcuaNodeIdServicesDataType_ConfigurationVersionDataType:
		return "ConfigurationVersionDataType"
	case OpcuaNodeIdServicesDataType_PubSubState:
		return "PubSubState"
	case OpcuaNodeIdServicesDataType_FieldTargetDataType:
		return "FieldTargetDataType"
	case OpcuaNodeIdServicesDataType_ByteString:
		return "ByteString"
	case OpcuaNodeIdServicesDataType_SimpleTypeDescription:
		return "SimpleTypeDescription"
	case OpcuaNodeIdServicesDataType_UABinaryFileDataType:
		return "UABinaryFileDataType"
	case OpcuaNodeIdServicesDataType_BrokerConnectionTransportDataType:
		return "BrokerConnectionTransportDataType"
	case OpcuaNodeIdServicesDataType_BrokerTransportQualityOfService:
		return "BrokerTransportQualityOfService"
	case OpcuaNodeIdServicesDataType_AccessLevelType:
		return "AccessLevelType"
	case OpcuaNodeIdServicesDataType_EventNotifierType:
		return "EventNotifierType"
	case OpcuaNodeIdServicesDataType_AccessLevelExType:
		return "AccessLevelExType"
	case OpcuaNodeIdServicesDataType_WriterGroupDataType:
		return "WriterGroupDataType"
	case OpcuaNodeIdServicesDataType_StructureDescription:
		return "StructureDescription"
	case OpcuaNodeIdServicesDataType_EnumDescription:
		return "EnumDescription"
	case OpcuaNodeIdServicesDataType_NetworkAddressDataType:
		return "NetworkAddressDataType"
	case OpcuaNodeIdServicesDataType_NetworkAddressUrlDataType:
		return "NetworkAddressUrlDataType"
	case OpcuaNodeIdServicesDataType_ReaderGroupDataType:
		return "ReaderGroupDataType"
	case OpcuaNodeIdServicesDataType_EndpointType:
		return "EndpointType"
	case OpcuaNodeIdServicesDataType_PubSubConfigurationDataType:
		return "PubSubConfigurationDataType"
	case OpcuaNodeIdServicesDataType_DatagramWriterGroupTransportDataType:
		return "DatagramWriterGroupTransportDataType"
	case OpcuaNodeIdServicesDataType_DataTypeSchemaHeader:
		return "DataTypeSchemaHeader"
	case OpcuaNodeIdServicesDataType_PublishedDataSetDataType:
		return "PublishedDataSetDataType"
	case OpcuaNodeIdServicesDataType_PublishedDataSetSourceDataType:
		return "PublishedDataSetSourceDataType"
	case OpcuaNodeIdServicesDataType_PublishedDataItemsDataType:
		return "PublishedDataItemsDataType"
	case OpcuaNodeIdServicesDataType_PublishedEventsDataType:
		return "PublishedEventsDataType"
	case OpcuaNodeIdServicesDataType_DataSetFieldContentMask:
		return "DataSetFieldContentMask"
	case OpcuaNodeIdServicesDataType_DataSetWriterDataType:
		return "DataSetWriterDataType"
	case OpcuaNodeIdServicesDataType_DataSetWriterTransportDataType:
		return "DataSetWriterTransportDataType"
	case OpcuaNodeIdServicesDataType_DataSetWriterMessageDataType:
		return "DataSetWriterMessageDataType"
	case OpcuaNodeIdServicesDataType_PubSubGroupDataType:
		return "PubSubGroupDataType"
	case OpcuaNodeIdServicesDataType_WriterGroupTransportDataType:
		return "WriterGroupTransportDataType"
	case OpcuaNodeIdServicesDataType_WriterGroupMessageDataType:
		return "WriterGroupMessageDataType"
	case OpcuaNodeIdServicesDataType_PubSubConnectionDataType:
		return "PubSubConnectionDataType"
	case OpcuaNodeIdServicesDataType_ConnectionTransportDataType:
		return "ConnectionTransportDataType"
	case OpcuaNodeIdServicesDataType_ReaderGroupTransportDataType:
		return "ReaderGroupTransportDataType"
	case OpcuaNodeIdServicesDataType_ReaderGroupMessageDataType:
		return "ReaderGroupMessageDataType"
	case OpcuaNodeIdServicesDataType_DataSetReaderDataType:
		return "DataSetReaderDataType"
	case OpcuaNodeIdServicesDataType_DataSetReaderTransportDataType:
		return "DataSetReaderTransportDataType"
	case OpcuaNodeIdServicesDataType_DataSetReaderMessageDataType:
		return "DataSetReaderMessageDataType"
	case OpcuaNodeIdServicesDataType_SubscribedDataSetDataType:
		return "SubscribedDataSetDataType"
	case OpcuaNodeIdServicesDataType_TargetVariablesDataType:
		return "TargetVariablesDataType"
	case OpcuaNodeIdServicesDataType_IdentityCriteriaType:
		return "IdentityCriteriaType"
	case OpcuaNodeIdServicesDataType_IdentityMappingRuleType:
		return "IdentityMappingRuleType"
	case OpcuaNodeIdServicesDataType_SubscribedDataSetMirrorDataType:
		return "SubscribedDataSetMirrorDataType"
	case OpcuaNodeIdServicesDataType_UadpNetworkMessageContentMask:
		return "UadpNetworkMessageContentMask"
	case OpcuaNodeIdServicesDataType_UadpWriterGroupMessageDataType:
		return "UadpWriterGroupMessageDataType"
	case OpcuaNodeIdServicesDataType_UadpDataSetMessageContentMask:
		return "UadpDataSetMessageContentMask"
	case OpcuaNodeIdServicesDataType_UadpDataSetWriterMessageDataType:
		return "UadpDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesDataType_UadpDataSetReaderMessageDataType:
		return "UadpDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesDataType_JsonNetworkMessageContentMask:
		return "JsonNetworkMessageContentMask"
	case OpcuaNodeIdServicesDataType_JsonWriterGroupMessageDataType:
		return "JsonWriterGroupMessageDataType"
	case OpcuaNodeIdServicesDataType_JsonDataSetMessageContentMask:
		return "JsonDataSetMessageContentMask"
	case OpcuaNodeIdServicesDataType_JsonDataSetWriterMessageDataType:
		return "JsonDataSetWriterMessageDataType"
	case OpcuaNodeIdServicesDataType_JsonDataSetReaderMessageDataType:
		return "JsonDataSetReaderMessageDataType"
	case OpcuaNodeIdServicesDataType_BrokerWriterGroupTransportDataType:
		return "BrokerWriterGroupTransportDataType"
	case OpcuaNodeIdServicesDataType_BrokerDataSetWriterTransportDataType:
		return "BrokerDataSetWriterTransportDataType"
	case OpcuaNodeIdServicesDataType_BrokerDataSetReaderTransportDataType:
		return "BrokerDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesDataType_OverrideValueHandling:
		return "OverrideValueHandling"
	case OpcuaNodeIdServicesDataType_SessionlessInvokeRequestType:
		return "SessionlessInvokeRequestType"
	case OpcuaNodeIdServicesDataType_DataSetFieldFlags:
		return "DataSetFieldFlags"
	case OpcuaNodeIdServicesDataType_XmlElement:
		return "XmlElement"
	case OpcuaNodeIdServicesDataType_AudioDataType:
		return "AudioDataType"
	case OpcuaNodeIdServicesDataType_AdditionalParametersType:
		return "AdditionalParametersType"
	case OpcuaNodeIdServicesDataType_NodeId:
		return "NodeId"
	case OpcuaNodeIdServicesDataType_DatagramConnectionTransportDataType:
		return "DatagramConnectionTransportDataType"
	case OpcuaNodeIdServicesDataType_RsaEncryptedSecret:
		return "RsaEncryptedSecret"
	case OpcuaNodeIdServicesDataType_EccEncryptedSecret:
		return "EccEncryptedSecret"
	case OpcuaNodeIdServicesDataType_EphemeralKeyType:
		return "EphemeralKeyType"
	case OpcuaNodeIdServicesDataType_Index:
		return "Index"
	case OpcuaNodeIdServicesDataType_GenericAttributeValue:
		return "GenericAttributeValue"
	case OpcuaNodeIdServicesDataType_GenericAttributes:
		return "GenericAttributes"
	case OpcuaNodeIdServicesDataType_DecimalDataType:
		return "DecimalDataType"
	case OpcuaNodeIdServicesDataType_ExpandedNodeId:
		return "ExpandedNodeId"
	case OpcuaNodeIdServicesDataType_RationalNumber:
		return "RationalNumber"
	case OpcuaNodeIdServicesDataType_Vector:
		return "Vector"
	case OpcuaNodeIdServicesDataType_ThreeDVector:
		return "ThreeDVector"
	case OpcuaNodeIdServicesDataType_CartesianCoordinates:
		return "CartesianCoordinates"
	case OpcuaNodeIdServicesDataType_ThreeDCartesianCoordinates:
		return "ThreeDCartesianCoordinates"
	case OpcuaNodeIdServicesDataType_Orientation:
		return "Orientation"
	case OpcuaNodeIdServicesDataType_ThreeDOrientation:
		return "ThreeDOrientation"
	case OpcuaNodeIdServicesDataType_Frame:
		return "Frame"
	case OpcuaNodeIdServicesDataType_ThreeDFrame:
		return "ThreeDFrame"
	case OpcuaNodeIdServicesDataType_StatusCode:
		return "StatusCode"
	case OpcuaNodeIdServicesDataType_DiagnosticsLevel:
		return "DiagnosticsLevel"
	case OpcuaNodeIdServicesDataType_PubSubDiagnosticsCounterClassification:
		return "PubSubDiagnosticsCounterClassification"
	case OpcuaNodeIdServicesDataType_SByte:
		return "SByte"
	case OpcuaNodeIdServicesDataType_QualifiedName:
		return "QualifiedName"
	case OpcuaNodeIdServicesDataType_ImageBMP:
		return "ImageBMP"
	case OpcuaNodeIdServicesDataType_ImageGIF:
		return "ImageGIF"
	case OpcuaNodeIdServicesDataType_ImageJPG:
		return "ImageJPG"
	case OpcuaNodeIdServicesDataType_ImagePNG:
		return "ImagePNG"
	case OpcuaNodeIdServicesDataType_DataSetOrderingType:
		return "DataSetOrderingType"
	case OpcuaNodeIdServicesDataType_VersionTime:
		return "VersionTime"
	case OpcuaNodeIdServicesDataType_SessionlessInvokeResponseType:
		return "SessionlessInvokeResponseType"
	case OpcuaNodeIdServicesDataType_LocalizedText:
		return "LocalizedText"
	case OpcuaNodeIdServicesDataType_Structure:
		return "Structure"
	case OpcuaNodeIdServicesDataType_DataValue:
		return "DataValue"
	case OpcuaNodeIdServicesDataType_AliasNameDataType:
		return "AliasNameDataType"
	case OpcuaNodeIdServicesDataType_ReadAnnotationDataDetails:
		return "ReadAnnotationDataDetails"
	case OpcuaNodeIdServicesDataType_CurrencyUnitType:
		return "CurrencyUnitType"
	case OpcuaNodeIdServicesDataType_TrustListValidationOptions:
		return "TrustListValidationOptions"
	case OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetRefDataType:
		return "StandaloneSubscribedDataSetRefDataType"
	case OpcuaNodeIdServicesDataType_StandaloneSubscribedDataSetDataType:
		return "StandaloneSubscribedDataSetDataType"
	case OpcuaNodeIdServicesDataType_SecurityGroupDataType:
		return "SecurityGroupDataType"
	case OpcuaNodeIdServicesDataType_PubSubConfiguration2DataType:
		return "PubSubConfiguration2DataType"
	case OpcuaNodeIdServicesDataType_QosDataType:
		return "QosDataType"
	case OpcuaNodeIdServicesDataType_TransmitQosDataType:
		return "TransmitQosDataType"
	case OpcuaNodeIdServicesDataType_TransmitQosPriorityDataType:
		return "TransmitQosPriorityDataType"
	case OpcuaNodeIdServicesDataType_ReceiveQosDataType:
		return "ReceiveQosDataType"
	case OpcuaNodeIdServicesDataType_ReceiveQosPriorityDataType:
		return "ReceiveQosPriorityDataType"
	case OpcuaNodeIdServicesDataType_DatagramConnectionTransport2DataType:
		return "DatagramConnectionTransport2DataType"
	case OpcuaNodeIdServicesDataType_DatagramWriterGroupTransport2DataType:
		return "DatagramWriterGroupTransport2DataType"
	case OpcuaNodeIdServicesDataType_DatagramDataSetReaderTransportDataType:
		return "DatagramDataSetReaderTransportDataType"
	case OpcuaNodeIdServicesDataType_UriString:
		return "UriString"
	case OpcuaNodeIdServicesDataType_BaseDataType:
		return "BaseDataType"
	case OpcuaNodeIdServicesDataType_ProgramDiagnostic2DataType:
		return "ProgramDiagnostic2DataType"
	case OpcuaNodeIdServicesDataType_PortableQualifiedName:
		return "PortableQualifiedName"
	case OpcuaNodeIdServicesDataType_PortableNodeId:
		return "PortableNodeId"
	case OpcuaNodeIdServicesDataType_UnsignedRationalNumber:
		return "UnsignedRationalNumber"
	case OpcuaNodeIdServicesDataType_Duplex:
		return "Duplex"
	case OpcuaNodeIdServicesDataType_InterfaceAdminStatus:
		return "InterfaceAdminStatus"
	case OpcuaNodeIdServicesDataType_InterfaceOperStatus:
		return "InterfaceOperStatus"
	case OpcuaNodeIdServicesDataType_NegotiationStatus:
		return "NegotiationStatus"
	case OpcuaNodeIdServicesDataType_TsnFailureCode:
		return "TsnFailureCode"
	case OpcuaNodeIdServicesDataType_TsnStreamState:
		return "TsnStreamState"
	case OpcuaNodeIdServicesDataType_TsnTalkerStatus:
		return "TsnTalkerStatus"
	case OpcuaNodeIdServicesDataType_TsnListenerStatus:
		return "TsnListenerStatus"
	case OpcuaNodeIdServicesDataType_SemanticVersionString:
		return "SemanticVersionString"
	case OpcuaNodeIdServicesDataType_PasswordOptionsMask:
		return "PasswordOptionsMask"
	case OpcuaNodeIdServicesDataType_UserConfigurationMask:
		return "UserConfigurationMask"
	case OpcuaNodeIdServicesDataType_UserManagementDataType:
		return "UserManagementDataType"
	case OpcuaNodeIdServicesDataType_DiagnosticInfo:
		return "DiagnosticInfo"
	case OpcuaNodeIdServicesDataType_PriorityMappingEntryType:
		return "PriorityMappingEntryType"
	case OpcuaNodeIdServicesDataType_PublishedDataSetCustomSourceDataType:
		return "PublishedDataSetCustomSourceDataType"
	case OpcuaNodeIdServicesDataType_PubSubKeyPushTargetDataType:
		return "PubSubKeyPushTargetDataType"
	case OpcuaNodeIdServicesDataType_PubSubConfigurationRefMask:
		return "PubSubConfigurationRefMask"
	case OpcuaNodeIdServicesDataType_PubSubConfigurationRefDataType:
		return "PubSubConfigurationRefDataType"
	case OpcuaNodeIdServicesDataType_PubSubConfigurationValueDataType:
		return "PubSubConfigurationValueDataType"
	case OpcuaNodeIdServicesDataType_IdType:
		return "IdType"
	case OpcuaNodeIdServicesDataType_NodeClass:
		return "NodeClass"
	case OpcuaNodeIdServicesDataType_EncodedTicket:
		return "EncodedTicket"
	case OpcuaNodeIdServicesDataType_Node:
		return "Node"
	case OpcuaNodeIdServicesDataType_Number:
		return "Number"
	case OpcuaNodeIdServicesDataType_ObjectNode:
		return "ObjectNode"
	case OpcuaNodeIdServicesDataType_ObjectTypeNode:
		return "ObjectTypeNode"
	case OpcuaNodeIdServicesDataType_VariableNode:
		return "VariableNode"
	case OpcuaNodeIdServicesDataType_Integer:
		return "Integer"
	case OpcuaNodeIdServicesDataType_VariableTypeNode:
		return "VariableTypeNode"
	case OpcuaNodeIdServicesDataType_ReferenceTypeNode:
		return "ReferenceTypeNode"
	case OpcuaNodeIdServicesDataType_MethodNode:
		return "MethodNode"
	case OpcuaNodeIdServicesDataType_ViewNode:
		return "ViewNode"
	case OpcuaNodeIdServicesDataType_UInteger:
		return "UInteger"
	case OpcuaNodeIdServicesDataType_DataTypeNode:
		return "DataTypeNode"
	case OpcuaNodeIdServicesDataType_ReferenceNode:
		return "ReferenceNode"
	case OpcuaNodeIdServicesDataType_IntegerId:
		return "IntegerId"
	case OpcuaNodeIdServicesDataType_Counter:
		return "Counter"
	case OpcuaNodeIdServicesDataType_Enumeration:
		return "Enumeration"
	case OpcuaNodeIdServicesDataType_Duration:
		return "Duration"
	case OpcuaNodeIdServicesDataType_NumericRange:
		return "NumericRange"
	case OpcuaNodeIdServicesDataType_UtcTime:
		return "UtcTime"
	case OpcuaNodeIdServicesDataType_LocaleId:
		return "LocaleId"
	case OpcuaNodeIdServicesDataType_Argument:
		return "Argument"
	case OpcuaNodeIdServicesDataType_StatusResult:
		return "StatusResult"
	case OpcuaNodeIdServicesDataType_Byte:
		return "Byte"
	case OpcuaNodeIdServicesDataType_Image:
		return "Image"
	case OpcuaNodeIdServicesDataType_MessageSecurityMode:
		return "MessageSecurityMode"
	case OpcuaNodeIdServicesDataType_UserTokenType:
		return "UserTokenType"
	case OpcuaNodeIdServicesDataType_UserTokenPolicy:
		return "UserTokenPolicy"
	case OpcuaNodeIdServicesDataType_ApplicationType:
		return "ApplicationType"
	case OpcuaNodeIdServicesDataType_ApplicationDescription:
		return "ApplicationDescription"
	case OpcuaNodeIdServicesDataType_ApplicationInstanceCertificate:
		return "ApplicationInstanceCertificate"
	case OpcuaNodeIdServicesDataType_EndpointDescription:
		return "EndpointDescription"
	case OpcuaNodeIdServicesDataType_SecurityTokenRequestType:
		return "SecurityTokenRequestType"
	case OpcuaNodeIdServicesDataType_UserIdentityToken:
		return "UserIdentityToken"
	case OpcuaNodeIdServicesDataType_AnonymousIdentityToken:
		return "AnonymousIdentityToken"
	case OpcuaNodeIdServicesDataType_Handle:
		return "Handle"
	case OpcuaNodeIdServicesDataType_TrimmedString:
		return "TrimmedString"
	case OpcuaNodeIdServicesDataType_UserNameIdentityToken:
		return "UserNameIdentityToken"
	case OpcuaNodeIdServicesDataType_AlarmMask:
		return "AlarmMask"
	case OpcuaNodeIdServicesDataType_TransactionErrorType:
		return "TransactionErrorType"
	case OpcuaNodeIdServicesDataType_X509IdentityToken:
		return "X509IdentityToken"
	case OpcuaNodeIdServicesDataType_ReferenceDescriptionDataType:
		return "ReferenceDescriptionDataType"
	case OpcuaNodeIdServicesDataType_ReferenceListEntryDataType:
		return "ReferenceListEntryDataType"
	case OpcuaNodeIdServicesDataType_EndpointConfiguration:
		return "EndpointConfiguration"
	case OpcuaNodeIdServicesDataType_BuildInfo:
		return "BuildInfo"
	case OpcuaNodeIdServicesDataType_SignedSoftwareCertificate:
		return "SignedSoftwareCertificate"
	case OpcuaNodeIdServicesDataType_AttributeWriteMask:
		return "AttributeWriteMask"
	case OpcuaNodeIdServicesDataType_NodeAttributesMask:
		return "NodeAttributesMask"
	case OpcuaNodeIdServicesDataType_NodeAttributes:
		return "NodeAttributes"
	case OpcuaNodeIdServicesDataType_ObjectAttributes:
		return "ObjectAttributes"
	case OpcuaNodeIdServicesDataType_VariableAttributes:
		return "VariableAttributes"
	case OpcuaNodeIdServicesDataType_MethodAttributes:
		return "MethodAttributes"
	case OpcuaNodeIdServicesDataType_ObjectTypeAttributes:
		return "ObjectTypeAttributes"
	case OpcuaNodeIdServicesDataType_VariableTypeAttributes:
		return "VariableTypeAttributes"
	case OpcuaNodeIdServicesDataType_ReferenceTypeAttributes:
		return "ReferenceTypeAttributes"
	case OpcuaNodeIdServicesDataType_DataTypeAttributes:
		return "DataTypeAttributes"
	case OpcuaNodeIdServicesDataType_ViewAttributes:
		return "ViewAttributes"
	case OpcuaNodeIdServicesDataType_AddNodesItem:
		return "AddNodesItem"
	case OpcuaNodeIdServicesDataType_AddReferencesItem:
		return "AddReferencesItem"
	case OpcuaNodeIdServicesDataType_DeleteNodesItem:
		return "DeleteNodesItem"
	case OpcuaNodeIdServicesDataType_DeleteReferencesItem:
		return "DeleteReferencesItem"
	case OpcuaNodeIdServicesDataType_SessionAuthenticationToken:
		return "SessionAuthenticationToken"
	case OpcuaNodeIdServicesDataType_RequestHeader:
		return "RequestHeader"
	case OpcuaNodeIdServicesDataType_ResponseHeader:
		return "ResponseHeader"
	case OpcuaNodeIdServicesDataType_ServiceFault:
		return "ServiceFault"
	case OpcuaNodeIdServicesDataType_Int16:
		return "Int16"
	case OpcuaNodeIdServicesDataType_FindServersRequest:
		return "FindServersRequest"
	case OpcuaNodeIdServicesDataType_FindServersResponse:
		return "FindServersResponse"
	case OpcuaNodeIdServicesDataType_GetEndpointsRequest:
		return "GetEndpointsRequest"
	case OpcuaNodeIdServicesDataType_GetEndpointsResponse:
		return "GetEndpointsResponse"
	case OpcuaNodeIdServicesDataType_RegisteredServer:
		return "RegisteredServer"
	case OpcuaNodeIdServicesDataType_RegisterServerRequest:
		return "RegisterServerRequest"
	case OpcuaNodeIdServicesDataType_RegisterServerResponse:
		return "RegisterServerResponse"
	case OpcuaNodeIdServicesDataType_ChannelSecurityToken:
		return "ChannelSecurityToken"
	case OpcuaNodeIdServicesDataType_OpenSecureChannelRequest:
		return "OpenSecureChannelRequest"
	case OpcuaNodeIdServicesDataType_OpenSecureChannelResponse:
		return "OpenSecureChannelResponse"
	case OpcuaNodeIdServicesDataType_CloseSecureChannelRequest:
		return "CloseSecureChannelRequest"
	case OpcuaNodeIdServicesDataType_CloseSecureChannelResponse:
		return "CloseSecureChannelResponse"
	case OpcuaNodeIdServicesDataType_SignatureData:
		return "SignatureData"
	case OpcuaNodeIdServicesDataType_CreateSessionRequest:
		return "CreateSessionRequest"
	case OpcuaNodeIdServicesDataType_CreateSessionResponse:
		return "CreateSessionResponse"
	case OpcuaNodeIdServicesDataType_ActivateSessionRequest:
		return "ActivateSessionRequest"
	case OpcuaNodeIdServicesDataType_ActivateSessionResponse:
		return "ActivateSessionResponse"
	case OpcuaNodeIdServicesDataType_CloseSessionRequest:
		return "CloseSessionRequest"
	case OpcuaNodeIdServicesDataType_CloseSessionResponse:
		return "CloseSessionResponse"
	case OpcuaNodeIdServicesDataType_CancelRequest:
		return "CancelRequest"
	case OpcuaNodeIdServicesDataType_CancelResponse:
		return "CancelResponse"
	case OpcuaNodeIdServicesDataType_AddNodesResult:
		return "AddNodesResult"
	case OpcuaNodeIdServicesDataType_AddNodesRequest:
		return "AddNodesRequest"
	case OpcuaNodeIdServicesDataType_AddNodesResponse:
		return "AddNodesResponse"
	case OpcuaNodeIdServicesDataType_AddReferencesRequest:
		return "AddReferencesRequest"
	case OpcuaNodeIdServicesDataType_AddReferencesResponse:
		return "AddReferencesResponse"
	case OpcuaNodeIdServicesDataType_DeleteNodesRequest:
		return "DeleteNodesRequest"
	case OpcuaNodeIdServicesDataType_UInt16:
		return "UInt16"
	case OpcuaNodeIdServicesDataType_Decimal:
		return "Decimal"
	case OpcuaNodeIdServicesDataType_DeleteNodesResponse:
		return "DeleteNodesResponse"
	case OpcuaNodeIdServicesDataType_DeleteReferencesRequest:
		return "DeleteReferencesRequest"
	case OpcuaNodeIdServicesDataType_DeleteReferencesResponse:
		return "DeleteReferencesResponse"
	case OpcuaNodeIdServicesDataType_BrowseDirection:
		return "BrowseDirection"
	case OpcuaNodeIdServicesDataType_ViewDescription:
		return "ViewDescription"
	case OpcuaNodeIdServicesDataType_BrowseDescription:
		return "BrowseDescription"
	case OpcuaNodeIdServicesDataType_BrowseResultMask:
		return "BrowseResultMask"
	case OpcuaNodeIdServicesDataType_ReferenceDescription:
		return "ReferenceDescription"
	case OpcuaNodeIdServicesDataType_ContinuationPoint:
		return "ContinuationPoint"
	case OpcuaNodeIdServicesDataType_BrowseResult:
		return "BrowseResult"
	case OpcuaNodeIdServicesDataType_BrowseRequest:
		return "BrowseRequest"
	case OpcuaNodeIdServicesDataType_BrowseResponse:
		return "BrowseResponse"
	case OpcuaNodeIdServicesDataType_BrowseNextRequest:
		return "BrowseNextRequest"
	case OpcuaNodeIdServicesDataType_BrowseNextResponse:
		return "BrowseNextResponse"
	case OpcuaNodeIdServicesDataType_RelativePathElement:
		return "RelativePathElement"
	case OpcuaNodeIdServicesDataType_RelativePath:
		return "RelativePath"
	case OpcuaNodeIdServicesDataType_BrowsePath:
		return "BrowsePath"
	case OpcuaNodeIdServicesDataType_BrowsePathTarget:
		return "BrowsePathTarget"
	case OpcuaNodeIdServicesDataType_BrowsePathResult:
		return "BrowsePathResult"
	case OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsRequest:
		return "TranslateBrowsePathsToNodeIdsRequest"
	case OpcuaNodeIdServicesDataType_TranslateBrowsePathsToNodeIdsResponse:
		return "TranslateBrowsePathsToNodeIdsResponse"
	case OpcuaNodeIdServicesDataType_RegisterNodesRequest:
		return "RegisterNodesRequest"
	case OpcuaNodeIdServicesDataType_RegisterNodesResponse:
		return "RegisterNodesResponse"
	case OpcuaNodeIdServicesDataType_UnregisterNodesRequest:
		return "UnregisterNodesRequest"
	case OpcuaNodeIdServicesDataType_UnregisterNodesResponse:
		return "UnregisterNodesResponse"
	case OpcuaNodeIdServicesDataType_QueryDataDescription:
		return "QueryDataDescription"
	case OpcuaNodeIdServicesDataType_NodeTypeDescription:
		return "NodeTypeDescription"
	case OpcuaNodeIdServicesDataType_FilterOperator:
		return "FilterOperator"
	case OpcuaNodeIdServicesDataType_QueryDataSet:
		return "QueryDataSet"
	case OpcuaNodeIdServicesDataType_NodeReference:
		return "NodeReference"
	case OpcuaNodeIdServicesDataType_ContentFilterElement:
		return "ContentFilterElement"
	case OpcuaNodeIdServicesDataType_ContentFilter:
		return "ContentFilter"
	case OpcuaNodeIdServicesDataType_FilterOperand:
		return "FilterOperand"
	case OpcuaNodeIdServicesDataType_ElementOperand:
		return "ElementOperand"
	case OpcuaNodeIdServicesDataType_LiteralOperand:
		return "LiteralOperand"
	case OpcuaNodeIdServicesDataType_AttributeOperand:
		return "AttributeOperand"
	case OpcuaNodeIdServicesDataType_Int32:
		return "Int32"
	case OpcuaNodeIdServicesDataType_SimpleAttributeOperand:
		return "SimpleAttributeOperand"
	case OpcuaNodeIdServicesDataType_ContentFilterElementResult:
		return "ContentFilterElementResult"
	case OpcuaNodeIdServicesDataType_ContentFilterResult:
		return "ContentFilterResult"
	case OpcuaNodeIdServicesDataType_ParsingResult:
		return "ParsingResult"
	case OpcuaNodeIdServicesDataType_QueryFirstRequest:
		return "QueryFirstRequest"
	case OpcuaNodeIdServicesDataType_QueryFirstResponse:
		return "QueryFirstResponse"
	case OpcuaNodeIdServicesDataType_QueryNextRequest:
		return "QueryNextRequest"
	case OpcuaNodeIdServicesDataType_QueryNextResponse:
		return "QueryNextResponse"
	case OpcuaNodeIdServicesDataType_TimestampsToReturn:
		return "TimestampsToReturn"
	case OpcuaNodeIdServicesDataType_ReadValueId:
		return "ReadValueId"
	case OpcuaNodeIdServicesDataType_ReadRequest:
		return "ReadRequest"
	case OpcuaNodeIdServicesDataType_ReadResponse:
		return "ReadResponse"
	case OpcuaNodeIdServicesDataType_HistoryReadValueId:
		return "HistoryReadValueId"
	case OpcuaNodeIdServicesDataType_HistoryReadResult:
		return "HistoryReadResult"
	case OpcuaNodeIdServicesDataType_HistoryReadDetails:
		return "HistoryReadDetails"
	case OpcuaNodeIdServicesDataType_ReadEventDetails:
		return "ReadEventDetails"
	case OpcuaNodeIdServicesDataType_ReadRawModifiedDetails:
		return "ReadRawModifiedDetails"
	case OpcuaNodeIdServicesDataType_ReadProcessedDetails:
		return "ReadProcessedDetails"
	case OpcuaNodeIdServicesDataType_ReadAtTimeDetails:
		return "ReadAtTimeDetails"
	case OpcuaNodeIdServicesDataType_HistoryData:
		return "HistoryData"
	case OpcuaNodeIdServicesDataType_HistoryEvent:
		return "HistoryEvent"
	case OpcuaNodeIdServicesDataType_HistoryReadRequest:
		return "HistoryReadRequest"
	case OpcuaNodeIdServicesDataType_HistoryReadResponse:
		return "HistoryReadResponse"
	case OpcuaNodeIdServicesDataType_WriteValue:
		return "WriteValue"
	case OpcuaNodeIdServicesDataType_WriteRequest:
		return "WriteRequest"
	case OpcuaNodeIdServicesDataType_WriteResponse:
		return "WriteResponse"
	case OpcuaNodeIdServicesDataType_HistoryUpdateDetails:
		return "HistoryUpdateDetails"
	case OpcuaNodeIdServicesDataType_UpdateDataDetails:
		return "UpdateDataDetails"
	case OpcuaNodeIdServicesDataType_UpdateEventDetails:
		return "UpdateEventDetails"
	case OpcuaNodeIdServicesDataType_DeleteRawModifiedDetails:
		return "DeleteRawModifiedDetails"
	case OpcuaNodeIdServicesDataType_DeleteAtTimeDetails:
		return "DeleteAtTimeDetails"
	case OpcuaNodeIdServicesDataType_DeleteEventDetails:
		return "DeleteEventDetails"
	case OpcuaNodeIdServicesDataType_HistoryUpdateResult:
		return "HistoryUpdateResult"
	case OpcuaNodeIdServicesDataType_HistoryUpdateRequest:
		return "HistoryUpdateRequest"
	case OpcuaNodeIdServicesDataType_UInt32:
		return "UInt32"
	case OpcuaNodeIdServicesDataType_HistoryUpdateResponse:
		return "HistoryUpdateResponse"
	case OpcuaNodeIdServicesDataType_CallMethodRequest:
		return "CallMethodRequest"
	case OpcuaNodeIdServicesDataType_CallMethodResult:
		return "CallMethodResult"
	case OpcuaNodeIdServicesDataType_CallRequest:
		return "CallRequest"
	case OpcuaNodeIdServicesDataType_CallResponse:
		return "CallResponse"
	case OpcuaNodeIdServicesDataType_MonitoringMode:
		return "MonitoringMode"
	case OpcuaNodeIdServicesDataType_DataChangeTrigger:
		return "DataChangeTrigger"
	case OpcuaNodeIdServicesDataType_DeadbandType:
		return "DeadbandType"
	case OpcuaNodeIdServicesDataType_MonitoringFilter:
		return "MonitoringFilter"
	case OpcuaNodeIdServicesDataType_DataChangeFilter:
		return "DataChangeFilter"
	case OpcuaNodeIdServicesDataType_EventFilter:
		return "EventFilter"
	case OpcuaNodeIdServicesDataType_AggregateFilter:
		return "AggregateFilter"
	case OpcuaNodeIdServicesDataType_MonitoringFilterResult:
		return "MonitoringFilterResult"
	case OpcuaNodeIdServicesDataType_EventFilterResult:
		return "EventFilterResult"
	case OpcuaNodeIdServicesDataType_AggregateFilterResult:
		return "AggregateFilterResult"
	case OpcuaNodeIdServicesDataType_MonitoringParameters:
		return "MonitoringParameters"
	case OpcuaNodeIdServicesDataType_MonitoredItemCreateRequest:
		return "MonitoredItemCreateRequest"
	case OpcuaNodeIdServicesDataType_MonitoredItemCreateResult:
		return "MonitoredItemCreateResult"
	case OpcuaNodeIdServicesDataType_CreateMonitoredItemsRequest:
		return "CreateMonitoredItemsRequest"
	case OpcuaNodeIdServicesDataType_CreateMonitoredItemsResponse:
		return "CreateMonitoredItemsResponse"
	case OpcuaNodeIdServicesDataType_MonitoredItemModifyRequest:
		return "MonitoredItemModifyRequest"
	case OpcuaNodeIdServicesDataType_MonitoredItemModifyResult:
		return "MonitoredItemModifyResult"
	case OpcuaNodeIdServicesDataType_EnumValueType:
		return "EnumValueType"
	case OpcuaNodeIdServicesDataType_ModifyMonitoredItemsRequest:
		return "ModifyMonitoredItemsRequest"
	case OpcuaNodeIdServicesDataType_ModifyMonitoredItemsResponse:
		return "ModifyMonitoredItemsResponse"
	case OpcuaNodeIdServicesDataType_SetMonitoringModeRequest:
		return "SetMonitoringModeRequest"
	case OpcuaNodeIdServicesDataType_SetMonitoringModeResponse:
		return "SetMonitoringModeResponse"
	case OpcuaNodeIdServicesDataType_SetTriggeringRequest:
		return "SetTriggeringRequest"
	case OpcuaNodeIdServicesDataType_SetTriggeringResponse:
		return "SetTriggeringResponse"
	case OpcuaNodeIdServicesDataType_DeleteMonitoredItemsRequest:
		return "DeleteMonitoredItemsRequest"
	case OpcuaNodeIdServicesDataType_DeleteMonitoredItemsResponse:
		return "DeleteMonitoredItemsResponse"
	case OpcuaNodeIdServicesDataType_CreateSubscriptionRequest:
		return "CreateSubscriptionRequest"
	case OpcuaNodeIdServicesDataType_CreateSubscriptionResponse:
		return "CreateSubscriptionResponse"
	case OpcuaNodeIdServicesDataType_ModifySubscriptionRequest:
		return "ModifySubscriptionRequest"
	case OpcuaNodeIdServicesDataType_ModifySubscriptionResponse:
		return "ModifySubscriptionResponse"
	case OpcuaNodeIdServicesDataType_SetPublishingModeRequest:
		return "SetPublishingModeRequest"
	case OpcuaNodeIdServicesDataType_Int64:
		return "Int64"
	case OpcuaNodeIdServicesDataType_SetPublishingModeResponse:
		return "SetPublishingModeResponse"
	case OpcuaNodeIdServicesDataType_NotificationMessage:
		return "NotificationMessage"
	case OpcuaNodeIdServicesDataType_MonitoredItemNotification:
		return "MonitoredItemNotification"
	case OpcuaNodeIdServicesDataType_DataChangeNotification:
		return "DataChangeNotification"
	case OpcuaNodeIdServicesDataType_StatusChangeNotification:
		return "StatusChangeNotification"
	case OpcuaNodeIdServicesDataType_SubscriptionAcknowledgement:
		return "SubscriptionAcknowledgement"
	case OpcuaNodeIdServicesDataType_PublishRequest:
		return "PublishRequest"
	case OpcuaNodeIdServicesDataType_PublishResponse:
		return "PublishResponse"
	case OpcuaNodeIdServicesDataType_RepublishRequest:
		return "RepublishRequest"
	case OpcuaNodeIdServicesDataType_RepublishResponse:
		return "RepublishResponse"
	case OpcuaNodeIdServicesDataType_TransferResult:
		return "TransferResult"
	case OpcuaNodeIdServicesDataType_TransferSubscriptionsRequest:
		return "TransferSubscriptionsRequest"
	case OpcuaNodeIdServicesDataType_TransferSubscriptionsResponse:
		return "TransferSubscriptionsResponse"
	case OpcuaNodeIdServicesDataType_DeleteSubscriptionsRequest:
		return "DeleteSubscriptionsRequest"
	case OpcuaNodeIdServicesDataType_DeleteSubscriptionsResponse:
		return "DeleteSubscriptionsResponse"
	case OpcuaNodeIdServicesDataType_RedundancySupport:
		return "RedundancySupport"
	case OpcuaNodeIdServicesDataType_ServerState:
		return "ServerState"
	case OpcuaNodeIdServicesDataType_RedundantServerDataType:
		return "RedundantServerDataType"
	case OpcuaNodeIdServicesDataType_SamplingIntervalDiagnosticsDataType:
		return "SamplingIntervalDiagnosticsDataType"
	case OpcuaNodeIdServicesDataType_ServerDiagnosticsSummaryDataType:
		return "ServerDiagnosticsSummaryDataType"
	case OpcuaNodeIdServicesDataType_ServerStatusDataType:
		return "ServerStatusDataType"
	case OpcuaNodeIdServicesDataType_SessionDiagnosticsDataType:
		return "SessionDiagnosticsDataType"
	case OpcuaNodeIdServicesDataType_SessionSecurityDiagnosticsDataType:
		return "SessionSecurityDiagnosticsDataType"
	case OpcuaNodeIdServicesDataType_ServiceCounterDataType:
		return "ServiceCounterDataType"
	case OpcuaNodeIdServicesDataType_SubscriptionDiagnosticsDataType:
		return "SubscriptionDiagnosticsDataType"
	case OpcuaNodeIdServicesDataType_ModelChangeStructureDataType:
		return "ModelChangeStructureDataType"
	case OpcuaNodeIdServicesDataType_Range:
		return "Range"
	case OpcuaNodeIdServicesDataType_EUInformation:
		return "EUInformation"
	case OpcuaNodeIdServicesDataType_ExceptionDeviationFormat:
		return "ExceptionDeviationFormat"
	case OpcuaNodeIdServicesDataType_Annotation:
		return "Annotation"
	case OpcuaNodeIdServicesDataType_TimeZoneDataType:
		return "TimeZoneDataType"
	case OpcuaNodeIdServicesDataType_ProgramDiagnosticDataType:
		return "ProgramDiagnosticDataType"
	case OpcuaNodeIdServicesDataType_SemanticChangeStructureDataType:
		return "SemanticChangeStructureDataType"
	case OpcuaNodeIdServicesDataType_UInt64:
		return "UInt64"
	case OpcuaNodeIdServicesDataType_EventNotificationList:
		return "EventNotificationList"
	case OpcuaNodeIdServicesDataType_EventFieldList:
		return "EventFieldList"
	case OpcuaNodeIdServicesDataType_HistoryEventFieldList:
		return "HistoryEventFieldList"
	case OpcuaNodeIdServicesDataType_IssuedIdentityToken:
		return "IssuedIdentityToken"
	case OpcuaNodeIdServicesDataType_PermissionType:
		return "PermissionType"
	case OpcuaNodeIdServicesDataType_NotificationData:
		return "NotificationData"
	case OpcuaNodeIdServicesDataType_AggregateConfiguration:
		return "AggregateConfiguration"
	case OpcuaNodeIdServicesDataType_AccessRestrictionType:
		return "AccessRestrictionType"
	case OpcuaNodeIdServicesDataType_RolePermissionType:
		return "RolePermissionType"
	case OpcuaNodeIdServicesDataType_DataTypeDefinition:
		return "DataTypeDefinition"
	case OpcuaNodeIdServicesDataType_StructureType:
		return "StructureType"
	case OpcuaNodeIdServicesDataType_StructureDefinition:
		return "StructureDefinition"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesDataType) String() string {
	return e.PLC4XEnumName()
}
